	AREA wram_code0, CODE, READWRITE

	INCLUDE equates.h
	INCLUDE 6502mac.h
	INCLUDE cart.h
	INCLUDE memory.h
	INCLUDE io.h
	INCLUDE ppu.h
	INCLUDE sound.h

	IMPORT |wram_globals0$$Base|
	IMPORT ui	;ui.c
	IMPORT quickload	;sram.c
	IMPORT quicksave	;sram.c
	IMPORT pcmctrl

	EXPORT nes_reset
	EXPORT run
	EXPORT op_table
	EXPORT default_scanlinehook
	EXPORT pcm_scanlinehook
	EXPORT irq6502
	EXPORT agb_vbl
	EXPORT cpustate
	EXPORT rommap
	EXPORT frametotal

pcmirqbakup EQU mapperdata+24
pcmirqcount EQU mapperdata+28
;----------------------------------------------------------------------------
_xx;	???					;invalid opcode
;----------------------------------------------------------------------------
	[ DEBUG
		adr r0,_xx
		mov r1,#0
		bl debug_
	]
	fetch 2
;----------------------------------------------------------------------------
_00;   BRK
;----------------------------------------------------------------------------
	[ DEBUG
		adr r0,_00
		mov r1,#0
		bl debug_
	]

	ldr r0,lastbank
	sub r1,nes_pc,r0
	add r0,r1,#1
	push16			;save PC

	encodeP (B+R)		;save P
	push8 r0

	ldr r1,nes_di
	orr r1,r1,#I		;disable IRQ
	str r1,nes_di

	ldr r0,memmap_tbl+7*4
	ldr r1,=IRQ_VECTOR
	ldrb nes_pc,[r0,r1]!
	ldrb r2,[r0,#1]
	orr nes_pc,nes_pc,r2,lsl#8
	encodePC		;get BRK vector

	fetch 7
	LTORG
;----------------------------------------------------------------------------
_01;   ORA ($nn,X)
;----------------------------------------------------------------------------
	doIIX
	opORA
	fetch 6
;----------------------------------------------------------------------------
_05;   ORA $nn
;----------------------------------------------------------------------------
	doZ
	opORA
	fetch 3
;----------------------------------------------------------------------------
_06;   ASL $nn
;----------------------------------------------------------------------------
	doZ
	opASL
	fetch 5
;----------------------------------------------------------------------------
_08;   PHP
;----------------------------------------------------------------------------
	encodeP (B+R)
	push8 r0
	fetch 3
;----------------------------------------------------------------------------
_09;   ORA #$nn
;----------------------------------------------------------------------------
	doIMM
	opORA
	fetch 2
;----------------------------------------------------------------------------
_0A;   ASL
;----------------------------------------------------------------------------
	adds nes_a,nes_a,nes_a
	orr nes_nz,nes_a,nes_a,lsr#24
	mrs nes_c,cpsr
	fetch 2
;----------------------------------------------------------------------------
_0D;   ORA $nnnn
;----------------------------------------------------------------------------
	doABS
	opORA
	fetch 4
;----------------------------------------------------------------------------
_0E;   ASL $nnnn
;----------------------------------------------------------------------------
	doABS
	opASL
	fetch 6
;----------------------------------------------------------------------------
_10x;   BPL
;----------------------------------------------------------------------------
	orr cycles,cycles,#BRANCH
_10
	tst nes_nz,#0x80000000
	ldrsb r0,[nes_pc],#1
	addeq nes_pc,nes_pc,r0
	subeq cycles,cycles,#3*CYCLE
	fetch 2
;----------------------------------------------------------------------------
_11;   ORA ($nn),Y
;----------------------------------------------------------------------------
	doIIY
	opORA
	fetch 5
;----------------------------------------------------------------------------
_15;   ORA $nn,X
;----------------------------------------------------------------------------
	doZIX
	opORA
	fetch 4
;----------------------------------------------------------------------------
_16;   ASL $nn,X
;----------------------------------------------------------------------------
	doZIX
	opASL
	fetch 6
;----------------------------------------------------------------------------
_18;   CLC
;----------------------------------------------------------------------------
	mov nes_c,#0
	fetch 2
;----------------------------------------------------------------------------
_19;   ORA $nnnn,Y
;----------------------------------------------------------------------------
	doAIY
	opORA
	fetch 4
;----------------------------------------------------------------------------
_1D;   ORA $nnnn,X
;----------------------------------------------------------------------------
	doAIX
	opORA
	fetch 4
;----------------------------------------------------------------------------
_1E;   ASL $nnnn,X
;----------------------------------------------------------------------------
	doAIX
	opASL
	fetch 7
;----------------------------------------------------------------------------
_20;   JSR $nnnn
;----------------------------------------------------------------------------
	ldrb r2,[nes_pc],#1
	ldr r1,lastbank
	sub r0,nes_pc,r1
	ldrb r1,[nes_pc]
	orr nes_pc,r2,r1,lsl#8
	push16
	encodePC
	fetch 6
;----------------------------------------------------------------------------
_21;   AND ($nn,X)
;----------------------------------------------------------------------------
	doIIX
	opAND
	fetch 6
;----------------------------------------------------------------------------
_24;   BIT $nn
;----------------------------------------------------------------------------
	doZ
	opBIT
	fetch 3
;----------------------------------------------------------------------------
_25;   AND $nn
;----------------------------------------------------------------------------
	doZ
	opAND
	fetch 3
;----------------------------------------------------------------------------
_26;   ROL $nn
;----------------------------------------------------------------------------
	doZ
	opROL
	fetch 5
;----------------------------------------------------------------------------
_28;   PLP
;----------------------------------------------------------------------------
	pop8 r0
	decodeP
	fetch 4
;----------------------------------------------------------------------------
_29;   AND #$nn
;----------------------------------------------------------------------------
	doIMM
	opAND
	fetch 2
;----------------------------------------------------------------------------
_2A;   ROL
;----------------------------------------------------------------------------
	msr cpsr_f,nes_c	;get C
	orrcs nes_a,nes_a,#0x00800000
	adds nes_a,nes_a,nes_a
	mov nes_nz,nes_a,asr#24	;NZ
	mrs nes_c,cpsr		;C
	fetch 2
;----------------------------------------------------------------------------
_2C;   BIT $nnnn
;----------------------------------------------------------------------------
	doABS
	opBIT
	fetch 4
;----------------------------------------------------------------------------
_2D;   AND $nnnn
;----------------------------------------------------------------------------
	doABS
	opAND
	fetch 4
;----------------------------------------------------------------------------
_2E;   ROL $nnnn
;----------------------------------------------------------------------------
	doABS
	opROL
	fetch 6
;----------------------------------------------------------------------------
_30x;   BMI
;----------------------------------------------------------------------------
	orr cycles,cycles,#BRANCH
_30
	tst nes_nz,#0x80000000
	ldrsb r0,[nes_pc],#1
	addne nes_pc,nes_pc,r0
	subne cycles,cycles,#3*CYCLE
	fetch 2
;----------------------------------------------------------------------------
_31;   AND ($nn),Y
;----------------------------------------------------------------------------
	doIIY
	opAND
	fetch 5
;----------------------------------------------------------------------------
_35;   AND $nn,X
;----------------------------------------------------------------------------
	doZIX
	opAND
	fetch 4
;----------------------------------------------------------------------------
_36;   ROL $nn,X
;----------------------------------------------------------------------------
	doZIX
	opROL
	fetch 6
;----------------------------------------------------------------------------
_38;   SEC
;----------------------------------------------------------------------------
	mov nes_c,#PSR_C
	fetch 2
;----------------------------------------------------------------------------
_39;   AND $nnnn,Y
;----------------------------------------------------------------------------
	doAIY
	opAND
	fetch 4
;----------------------------------------------------------------------------
_3D;   AND $nnnn,X
;----------------------------------------------------------------------------
	doAIX
	opAND
	fetch 4
;----------------------------------------------------------------------------
_3E;   ROL $nnnn,X
;----------------------------------------------------------------------------
	doAIX
	opROL
	fetch 7
;----------------------------------------------------------------------------
_40;   RTI
;----------------------------------------------------------------------------
	pop8 r0		;pop 6502 flags and decode
	decodeP
	pop16		;pop the return address
	encodePC
	fetch 6
;----------------------------------------------------------------------------
_41;   EOR ($nn,X)
;----------------------------------------------------------------------------
	doIIX
	opEOR
	fetch 6
;----------------------------------------------------------------------------
_45;   EOR $nn
;----------------------------------------------------------------------------
	doZ
	opEOR
	fetch 3
;----------------------------------------------------------------------------
_46;   LSR $nn
;----------------------------------------------------------------------------
	doZ
	opLSR
	fetch 5
;----------------------------------------------------------------------------
_48;   PHA
;----------------------------------------------------------------------------
	mov r0,nes_a,lsr#24
	push8 r0
	fetch 3
;----------------------------------------------------------------------------
_49;   EOR #$nn
;----------------------------------------------------------------------------
	doIMM
	opEOR
	fetch 2
;----------------------------------------------------------------------------
_4A;   LSR
;----------------------------------------------------------------------------
	movs nes_nz,nes_a,lsr#25	;Z
	mov nes_a,nes_nz,lsl#24
	mrs nes_c,cpsr			;C
	fetch 2
;----------------------------------------------------------------------------
_4C;   JMP $nnnn
;----------------------------------------------------------------------------
	ldrb r0,[nes_pc],#1
	ldrb r1,[nes_pc]
	orr nes_pc,r0,r1,lsl#8
	encodePC
	fetch 3
;----------------------------------------------------------------------------
_4Cx;   JMP $nnnn
;----------------------------------------------------------------------------
	ldrb r0,[nes_pc],#1
	ldrb r1,[nes_pc]
	orr nes_pc,r0,r1,lsl#8
		tst cycles,#BRANCH
		beq checkdeadloop
		bic cycles,cycles,#BRANCH
fini
	encodePC
	fetch 3
checkdeadloop 		;if thisjumpaddr=lastjumpaddr, cycles=0
		ldr addy,lastjump
		cmp addy,nes_pc
		moveq cycles,#0
		strne nes_pc,lastjump
		b fini
lastjump DCD 0
;----------------------------------------------------------------------------
_4D;   EOR $nnnn
;----------------------------------------------------------------------------
	doABS
	opEOR
	fetch 4
;----------------------------------------------------------------------------
_4E;   LSR $nnnn
;----------------------------------------------------------------------------
	doABS
	opLSR
	fetch 6
;----------------------------------------------------------------------------
_50x;   BVC
;----------------------------------------------------------------------------
	orr cycles,cycles,#BRANCH
_50
	ldr r0,nes_v
	tst r0,#PSR_V
	ldrsb r0,[nes_pc],#1
	addeq nes_pc,nes_pc,r0
	subeq cycles,cycles,#3*CYCLE
	fetch 2
;----------------------------------------------------------------------------
_51;   EOR ($nn),Y
;----------------------------------------------------------------------------
	doIIY
	opEOR
	fetch 5
;----------------------------------------------------------------------------
_55;   EOR $nn,X
;----------------------------------------------------------------------------
	doZIX
	opEOR
	fetch 4
;----------------------------------------------------------------------------
_56;   LSR $nn,X
;----------------------------------------------------------------------------
	doZIX
	opLSR
	fetch 6
;----------------------------------------------------------------------------
_58;   CLI
;----------------------------------------------------------------------------
	ldr r0,nes_di
	bic r0,r0,#I
	str r0,nes_di
	fetch 2
;----------------------------------------------------------------------------
_59;   EOR $nnnn,Y
;----------------------------------------------------------------------------
	doAIY
	opEOR
	fetch 4
;----------------------------------------------------------------------------
_5D;   EOR $nnnn,X
;----------------------------------------------------------------------------
	doAIX
	opEOR
	fetch 4
;----------------------------------------------------------------------------
_5E;   LSR $nnnn,X
;----------------------------------------------------------------------------
	doAIX
	opLSR
	fetch 7
;----------------------------------------------------------------------------
_60;   RTS
;----------------------------------------------------------------------------
	pop16
	add nes_pc,nes_pc,#1
	encodePC
	fetch 6
;----------------------------------------------------------------------------
_61;   ADC ($nn,X)
;----------------------------------------------------------------------------
	doIIX
	opADC
	fetch 6
;----------------------------------------------------------------------------
_65;   ADC $nn
;----------------------------------------------------------------------------
	doZ
	opADC
	fetch 3
;----------------------------------------------------------------------------
_66;   ROR $nn
;----------------------------------------------------------------------------
	doZ
	opROR
	fetch 5
;----------------------------------------------------------------------------
_68;   PLA
;----------------------------------------------------------------------------
	pop8 nes_nz
	mov nes_a,nes_nz,lsl#24
	fetch 4
;----------------------------------------------------------------------------
_69;   ADC #$nn
;----------------------------------------------------------------------------
	doIMM
	opADC
	fetch 2
;----------------------------------------------------------------------------
_6A;   ROR
;----------------------------------------------------------------------------
	msr cpsr_f,nes_c
	mov nes_a,nes_a,rrx
	movs nes_nz,nes_a,asr#24
	and nes_a,nes_a,#0xff000000
	mrs nes_c,cpsr          ;C
	fetch 2
;----------------------------------------------------------------------------
_6C;   JMP ($nnnn)
;----------------------------------------------------------------------------
	doABS
	adr r1,memmap_tbl
	and r2,addy,#0xE000
	ldr r1,[r1,r2,lsr#11]
	ldrb nes_pc,[r1,addy]
	add addy,addy,#1
	ldrb r0,[r1,addy]
	orr nes_pc,nes_pc,r0,lsl#8
	encodePC
	fetch 5
;----------------------------------------------------------------------------
_6D;   ADC $nnnn
;----------------------------------------------------------------------------
	doABS
	opADC
	fetch 4
;----------------------------------------------------------------------------
_6E;   ROR $nnnn
;----------------------------------------------------------------------------
	doABS
	opROR
	fetch 6
;----------------------------------------------------------------------------
_70x;   BVS
;----------------------------------------------------------------------------
	orr cycles,cycles,#BRANCH
_70
	ldr r0,nes_v
	tst r0,#PSR_V
	ldrsb r0,[nes_pc],#1
	addne nes_pc,nes_pc,r0
	subne cycles,cycles,#3*CYCLE
	fetch 2
;----------------------------------------------------------------------------
_71;   ADC ($nn),Y
;----------------------------------------------------------------------------
	doIIY
	opADC
	fetch 5
;----------------------------------------------------------------------------
_75;   ADC $nn,X
;----------------------------------------------------------------------------
	doZIX
	opADC
	fetch 4
;----------------------------------------------------------------------------
_76;   ROR $nn,X
;----------------------------------------------------------------------------
	doZIX
	opROR
	fetch 6
;----------------------------------------------------------------------------
_78;   SEI
;----------------------------------------------------------------------------
	ldr r0,nes_di
	orr r0,r0,#I
	str r0,nes_di
	fetch 2
;----------------------------------------------------------------------------
_79;   ADC $nnnn,Y
;----------------------------------------------------------------------------
	doAIY
	opADC
	fetch 4
;----------------------------------------------------------------------------
_7D;   ADC $nnnn,X
;----------------------------------------------------------------------------
	doAIX
	opADC
	fetch 4
;----------------------------------------------------------------------------
_7E;   ROR $nnnn,X
;----------------------------------------------------------------------------
	doAIX
	opROR
	fetch 7
;----------------------------------------------------------------------------
_81;   STA ($nn,X)
;----------------------------------------------------------------------------
	doIIX
	opSTORE nes_a
	fetch 6
;----------------------------------------------------------------------------
_84;   STY $nn
;----------------------------------------------------------------------------
	doZ
	opSTORE nes_y
	fetch 3
;----------------------------------------------------------------------------
_85;   STA $nn
;----------------------------------------------------------------------------
	doZ
	opSTORE nes_a
	fetch 3
;----------------------------------------------------------------------------
_86;   STX $nn
;----------------------------------------------------------------------------
	doZ
	opSTORE nes_x
	fetch 3
;----------------------------------------------------------------------------
_88;   DEY
;----------------------------------------------------------------------------
	sub nes_y,nes_y,#0x01000000
	mov nes_nz,nes_y,asr#24
	fetch 2
;----------------------------------------------------------------------------
_8A;   TXA
;----------------------------------------------------------------------------
	mov nes_a,nes_x
	mov nes_nz,nes_x,asr#24
	fetch 2
;----------------------------------------------------------------------------
_8C;   STY $nnnn
;----------------------------------------------------------------------------
	doABS
	opSTORE nes_y
	fetch 4
;----------------------------------------------------------------------------
_8D;   STA $nnnn
;----------------------------------------------------------------------------
	doABS
	opSTORE nes_a
	fetch 4
;----------------------------------------------------------------------------
_8E;   STX $nnnn
;----------------------------------------------------------------------------
	doABS
	opSTORE nes_x
	fetch 4
;----------------------------------------------------------------------------
_90x;   BCC
;----------------------------------------------------------------------------
	orr cycles,cycles,#BRANCH
_90
	tst nes_c,#PSR_C
	ldrsb r0,[nes_pc],#1
	addeq nes_pc,nes_pc,r0
	subeq cycles,cycles,#3*CYCLE
	fetch 2
;----------------------------------------------------------------------------
_91;   STA ($nn),Y
;----------------------------------------------------------------------------
	doIIY
	opSTORE nes_a
	fetch 6
;----------------------------------------------------------------------------
_94;   STY $nn,X
;----------------------------------------------------------------------------
	doZIX
	opSTORE nes_y
	fetch 4
;----------------------------------------------------------------------------
_95;   STA $nn,X
;----------------------------------------------------------------------------
	doZIX
	opSTORE nes_a
	fetch 4
;----------------------------------------------------------------------------
_96;   STX $nn,Y
;----------------------------------------------------------------------------
	doZIY
	opSTORE nes_x
	fetch 4
;----------------------------------------------------------------------------
_98;   TYA
;----------------------------------------------------------------------------
	mov nes_a,nes_y
	mov nes_nz,nes_y,asr#24
	fetch 2
;----------------------------------------------------------------------------
_99;   STA $nnnn,Y
;----------------------------------------------------------------------------
	doAIY
	opSTORE nes_a
	fetch 5
;----------------------------------------------------------------------------
_9A;   TXS
;----------------------------------------------------------------------------
	mov r0,nes_x,lsr#24
	strb r0,nes_s	;don't make it harder than it is, use byte transfer!
	fetch 2
;----------------------------------------------------------------------------
_9D;   STA $nnnn,X
;----------------------------------------------------------------------------
	doAIX
	opSTORE nes_a
	fetch 5
;----------------------------------------------------------------------------
_A0;   LDY #$nn
;----------------------------------------------------------------------------
	doIMM
	opLOAD nes_y
	fetch 2
;----------------------------------------------------------------------------
_A1;   LDA ($nn,X)
;----------------------------------------------------------------------------
	doIIX
	opLOAD nes_a
	fetch 6
;----------------------------------------------------------------------------
_A2;   LDX #$nn
;----------------------------------------------------------------------------
	doIMM
	opLOAD nes_x
	fetch 2
;----------------------------------------------------------------------------
_A4;   LDY $nn
;----------------------------------------------------------------------------
	doZ
	opLOAD nes_y
	fetch 3
;----------------------------------------------------------------------------
_A5;   LDA $nn
;----------------------------------------------------------------------------
	doZ
	opLOAD nes_a
	fetch 3
;----------------------------------------------------------------------------
_A6;   LDX $nn
;----------------------------------------------------------------------------
	doZ
	opLOAD nes_x
	fetch 3
;----------------------------------------------------------------------------
_A8;   TAY
;----------------------------------------------------------------------------
	mov nes_y,nes_a
	mov nes_nz,nes_y,asr#24
	fetch 2
;----------------------------------------------------------------------------
_A9;   LDA #$nn
;----------------------------------------------------------------------------
	doIMM
	opLOAD nes_a
	fetch 2
;----------------------------------------------------------------------------
_AA;   TAX
;----------------------------------------------------------------------------
	mov nes_x,nes_a
	mov nes_nz,nes_x,asr#24
	fetch 2
;----------------------------------------------------------------------------
_AC;   LDY $nnnn
;----------------------------------------------------------------------------
	doABS
	opLOAD nes_y
	fetch 4
;----------------------------------------------------------------------------
_AD;   LDA $nnnn
;----------------------------------------------------------------------------
	doABS
	opLOAD nes_a
	fetch 4
;----------------------------------------------------------------------------
_AE;   LDX $nnnn
;----------------------------------------------------------------------------
	doABS
	opLOAD nes_x
	fetch 4
;----------------------------------------------------------------------------
_B0x;   BCS
;----------------------------------------------------------------------------
	orr cycles,cycles,#BRANCH
_B0
	tst nes_c,#PSR_C
	ldrsb r0,[nes_pc],#1
	addne nes_pc,nes_pc,r0
	subne cycles,cycles,#3*CYCLE
	fetch 2
;----------------------------------------------------------------------------
_B1;   LDA ($nn),Y
;----------------------------------------------------------------------------
	doIIY
	opLOAD nes_a
	fetch 5
;----------------------------------------------------------------------------
_B4;   LDY $nn,X
;----------------------------------------------------------------------------
	doZIX
	opLOAD nes_y
	fetch 4
;----------------------------------------------------------------------------
_B5;   LDA $nn,X
;----------------------------------------------------------------------------
	doZIX
	opLOAD nes_a
	fetch 4
;----------------------------------------------------------------------------
_B6;   LDX $nn,Y
;----------------------------------------------------------------------------
	doZIY
	opLOAD nes_x
	fetch 4
;----------------------------------------------------------------------------
_B8;   CLV
;----------------------------------------------------------------------------
	mov r0,#0
	str r0,nes_v
	fetch 2
;----------------------------------------------------------------------------
_B9;   LDA $nnnn,Y
;----------------------------------------------------------------------------
	doAIY
	opLOAD nes_a
	fetch 4
;----------------------------------------------------------------------------
_BA;   TSX
;----------------------------------------------------------------------------
	ldrb nes_x,nes_s
	mov nes_x,nes_x,lsl#24
	mov nes_nz,nes_x,asr#24
	fetch 2
;----------------------------------------------------------------------------
_BC;   LDY $nnnn,X
;----------------------------------------------------------------------------
	doAIX
	opLOAD nes_y
	fetch 4
;----------------------------------------------------------------------------
_BD;   LDA $nnnn,X
;----------------------------------------------------------------------------
	doAIX
	opLOAD nes_a
	fetch 4
;----------------------------------------------------------------------------
_BE;   LDX $nnnn,Y
;----------------------------------------------------------------------------
	doAIY
	opLOAD nes_x
	fetch 4
;----------------------------------------------------------------------------
_C0;   CPY #$nn
;----------------------------------------------------------------------------
	doIMM
	opCOMP nes_y
	fetch 2
;----------------------------------------------------------------------------
_C1;   CMP ($nn,X)
;----------------------------------------------------------------------------
	doIIX
	opCOMP nes_a
	fetch 6
;----------------------------------------------------------------------------
_C4;   CPY $nn
;----------------------------------------------------------------------------
	doZ
	opCOMP nes_y
	fetch 3
;----------------------------------------------------------------------------
_C5;   CMP $nn
;----------------------------------------------------------------------------
	doZ
	opCOMP nes_a
	fetch 3
;----------------------------------------------------------------------------
_C6;   DEC $nn
;----------------------------------------------------------------------------
	doZ
	opDEC
	fetch 5
;----------------------------------------------------------------------------
_C8;   INY
;----------------------------------------------------------------------------
	add nes_y,nes_y,#0x01000000
	mov nes_nz,nes_y,asr#24
	fetch 2
;----------------------------------------------------------------------------
_C9;   CMP #$nn
;----------------------------------------------------------------------------
	doIMM
	opCOMP nes_a
	fetch 2
;----------------------------------------------------------------------------
_CA;   DEX
;----------------------------------------------------------------------------
	sub nes_x,nes_x,#0x01000000
	mov nes_nz,nes_x,asr#24
	fetch 2
;----------------------------------------------------------------------------
_CC;   CPY $nnnn
;----------------------------------------------------------------------------
	doABS
	opCOMP nes_y
	fetch 4
;----------------------------------------------------------------------------
_CD;   CMP $nnnn
;----------------------------------------------------------------------------
	doABS
	opCOMP nes_a
	fetch 4
;----------------------------------------------------------------------------
_CE;   DEC $nnnn
;----------------------------------------------------------------------------
	doABS
	opDEC
	fetch 6
;----------------------------------------------------------------------------
_D0x;   BNE
;----------------------------------------------------------------------------
	orr cycles,cycles,#BRANCH
_D0
	tst nes_nz,#0xff
	ldrsb r0,[nes_pc],#1
	addne nes_pc,nes_pc,r0
	subne cycles,cycles,#3*CYCLE
	fetch 2
;----------------------------------------------------------------------------
_D1;   CMP ($nn),Y
;----------------------------------------------------------------------------
	doIIY
	opCOMP nes_a
	fetch 5
;----------------------------------------------------------------------------
_D5;   CMP $nn,X
;----------------------------------------------------------------------------
	doZIX
	opCOMP nes_a
	fetch 4
;----------------------------------------------------------------------------
_D6;   DEC $nn,X
;----------------------------------------------------------------------------
	doZIX
	opDEC
	fetch 6
;----------------------------------------------------------------------------
_D8;   CLD
;----------------------------------------------------------------------------
	ldr r0,nes_di
	bic r0,r0,#D
	str r0,nes_di
	fetch 2
;----------------------------------------------------------------------------
_D9;   CMP $nnnn,Y
;----------------------------------------------------------------------------
	doAIY
	opCOMP nes_a
	fetch 4
;----------------------------------------------------------------------------
_DD;   CMP $nnnn,X
;----------------------------------------------------------------------------
	doAIX
	opCOMP nes_a
	fetch 4
;----------------------------------------------------------------------------
_DE;   DEC $nnnn,X
;----------------------------------------------------------------------------
	doAIX
	opDEC
	fetch 7
;----------------------------------------------------------------------------
_E0;   CPX #$nn
;----------------------------------------------------------------------------
	doIMM
	opCOMP nes_x
	fetch 2
;----------------------------------------------------------------------------
_E1;   SBC ($nn,X)
;----------------------------------------------------------------------------
	doIIX
	opSBC
	fetch 6
;----------------------------------------------------------------------------
_E4;   CPX $nn
;----------------------------------------------------------------------------
	doZ
	opCOMP nes_x
	fetch 3
;----------------------------------------------------------------------------
_E5;   SBC $nn
;----------------------------------------------------------------------------
	doZ
	opSBC
	fetch 3
;----------------------------------------------------------------------------
_E6;   INC $nn
;----------------------------------------------------------------------------
	doZ
	opINC
	fetch 5
;----------------------------------------------------------------------------
_E8;   INX
;----------------------------------------------------------------------------
	add nes_x,nes_x,#0x01000000
	mov nes_nz,nes_x,asr#24
	fetch 2
;----------------------------------------------------------------------------
_E9;   SBC #$nn
;----------------------------------------------------------------------------
	doIMM
	opSBC
	fetch 2
;----------------------------------------------------------------------------
_EA;   NOP
;----------------------------------------------------------------------------
	fetch 2
;----------------------------------------------------------------------------
_EC;   CPX $nnnn
;----------------------------------------------------------------------------
	doABS
	opCOMP nes_x
	fetch 4
;----------------------------------------------------------------------------
_ED;   SBC $nnnn
;----------------------------------------------------------------------------
	doABS
	opSBC
	fetch 4
;----------------------------------------------------------------------------
_EE;   INC $nnnn
;----------------------------------------------------------------------------
	doABS
	opINC
	fetch 6
;----------------------------------------------------------------------------
_F0x;   BEQ
;----------------------------------------------------------------------------
	orr cycles,cycles,#BRANCH
_F0
	tst nes_nz,#0xff
;	bne nobranch
	ldrsb r0,[nes_pc],#1
	addeq nes_pc,nes_pc,r0
	subeq cycles,cycles,#3*CYCLE
	fetch 2


;	cmp r0,#-4			;speed hack for Ballon Fight.
;	movcs cycles,#0			;speed hack 
;	fetch 3
;nobranch
;	add nes_pc,nes_pc,#1
;	fetch 2
;----------------------------------------------------------------------------
_F1;   SBC ($nn),Y
;----------------------------------------------------------------------------
	doIIY
	opSBC
	fetch 5
;----------------------------------------------------------------------------
_F5;   SBC $nn,X
;----------------------------------------------------------------------------
	doZIX
	opSBC
	fetch 4
;----------------------------------------------------------------------------
_F6;   INC $nn,X
;----------------------------------------------------------------------------
	doZIX
	opINC
	fetch 6
;----------------------------------------------------------------------------
_F8;   SED
;----------------------------------------------------------------------------
	ldr r0,nes_di
	orr r0,r0,#D
	str r0,nes_di
	fetch 2
;----------------------------------------------------------------------------
_F9;   SBC $nnnn,Y
;----------------------------------------------------------------------------
	doAIY
	opSBC
	fetch 4
;----------------------------------------------------------------------------
_FD;   SBC $nnnn,X
;----------------------------------------------------------------------------
	doAIX
	opSBC
	fetch 4
;----------------------------------------------------------------------------
_FE;   INC $nnnn,X
;----------------------------------------------------------------------------
	doAIX
	opINC
	fetch 7
;----------------------------------------------------------------------------
run	;r0=0 to return after frame
;----------------------------------------------------------------------------
	mov r1,#0
	strb r1,novblankwait

	str r0,dontstop
	tst r0,#1
	stmeqfd sp!,{nes_nz-nes_pc,globalptr,nes_zpage,lr}

	ldr globalptr,=|wram_globals0$$Base|
	ldr nes_zpage,=NES_RAM
	b line0x
;----------------------------------------------------------------------------
;cycles ran out
;----------------------------------------------------------------------------
line0
	adr r2,cpuregs
	stmia r2,{nes_nz-nes_pc}	;save 6502 state
waitformulti
	ldr r1,=REG_P1		;refresh input every frame
	ldrh r0,[r1]
		eor r0,r0,#0xff
		eor r0,r0,#0x300	;r0=button state (raw)
	ldr r1,AGBjoypad
	eor r1,r1,r0
	and r1,r1,r0		;r1=button state (0->1)
	str r0,AGBjoypad

        ldrb r3,emuflags+1
	cmp r3,#SCALED
	bhs %F0			;if unscaled
	ldr r3,windowtop
	tst r0,#0x100			;R=scroll down
	addne r3,r3,#2
	cmp r3,#79
	movhi r3,#79
	tst r0,#0x200			;L=scroll up
	subnes r3,r3,#2
	movmi r3,#0
	str r3,windowtop
0
	ldr r2,dontstop
	cmp r2,#0
	ldmeqfd sp!,{nes_nz-nes_pc,globalptr,nes_zpage,lr}	;exit here if doing single frame:
	bxeq lr							;return to rommenu()

	;----anything from here til line0x won't get executed while rom menu is active---

	mov r2,#REG_BASE
	mov r3,#0x0110
	strh r3,[r2,#REG_BLDMOD]	;stop darkened screen,OBJ blend to BG0
	mov r3,#0x1000			;BG0=16, OBJ=0
	strh r3,[r2,#REG_COLEV]		;Alpha values

	adr lr,line0x		;return here after doing L/R + SEL/START

	tst r1,#0x300		;if L or R was pressed
	tstne r0,#0x100
	tstne r0,#0x200		;and both L+R are held..
	ldrne r1,=ui
	bxne r1			;do menu

	ands r3,r0,#0x300		;if either L or R is pressed (not both)
	eornes r3,r3,#0x300
	bicne r0,r0,#0x0c		;	hide sel,start from NES
	str r0,NESjoypad
	beq line0x		;skip ahead if neither or both are pressed

	tst r0,#0x200
	tstne r1,#4		;L+SEL for BG adjust
	ldrne r2,adjustblend
	addne r2,r2,#1
	strne r2,adjustblend

	tst r0,#0x200		;L?
	tstne r1,#8		;START?
	ldrb r2,novblankwait	;0=Normal, 1=No wait, 2=Slomo
	addne r2,r2,#1
	cmp r2,#3
	moveq r2,#0
	strb r2,novblankwait

	tst r0,#0x100		;R?
	tstne r1,#8		;START:
	ldrne r1,=quickload
	bxne r1

	tst r0,#0x100		;R?
	tstne r1,#4		;SELECT:
	ldrne r1,=quicksave
	bxne r1
line0x
;	mov r1,#AGB_PALETTE
;	mov r0,#0		;black
;	strh r0,[r1]		;BG palette
;	ldr r0,frame
;	mov r1,#2
;	bl debug_
	bl refreshNESjoypads	;Z=1 if communication ok
	bne waitformulti	;waiting on other GBA..

	ldr r0,AGBjoypad
	ldr r2,fiveminutes	;sleep after 5 minutes of inactivity
	cmp r0,#0		;(left out of the loop so waiting on multi-link
	movne r2,#0x4700	;doesn't accelerate time)
	subs r2,r2,#1
	str r2,fiveminutes
	bleq suspend

	mov r1,#0
	strb r1,ppustat		;vbl clear, sprite0 clear
	str r1,scanline		;reset scanline count

	bl newframe		;display update
	bl updatesound

;-----------------------------------
;	ldr r0,=0x04000006	;to write out the scanline
;	ldrh r0,[r0]
;	mov r1,#19
;	bl debug_
;-----------------------------------


 [ BUILD <> "DEBUG"
	ldrb r1,novblankwait
	teq r1,#1
	beq l03
l01
	swieq 0x020000		; Turn of CPU until IRQ if not too late allready.
	ldrb r0,agb_vbl		;wait for AGB VBL
	cmp r0,#0
	beq l01
	teq r1,#2		;Check for slomo
	moveq r1,#0
	streqb r1,agb_vbl
	beq l01

l03
	mov r0,#0
	strb r0,agb_vbl
 ]
	adr r0,cpuregs
	ldmia r0,{nes_nz-nes_pc}	;restore 6502 state

	ldr r0,cyclesperscanline
	ldr r1,frame
	tst r1,#1
	subeq r0,r0,#CYCLE		;Every other frame has 1/3 less CPU cycle.
	add cycles,cycles,r0
	adr r0,line1_to_119
	str r0,nexttimeout

	ldr pc,scanlinehook
line1_to_119 ;------------------------
	ldr r0,cyclesperscanline
	add cycles,cycles,r0

	ldr r1,scanline
	add r1,r1,#1
	str r1,scanline
	cmp r1,#119
	ldrne pc,scanlinehook
;--------------------------------------------- between 119 and 120
	ldr r0,nes_chr_map		;For sprites
	str r0,old_chr_map		;TMNT 2 likes this
	ldr r0,nes_chr_map+4
	str r0,old_chr_map+4

	ldrb r0,ppuctrl0
	strb r0,ppuctrl0frame		;Contra likes this

	adr addy,line120_to_240
	str addy,nexttimeout
	ldr pc,scanlinehook
line120_to_240 ;------------------------
	ldr r0,cyclesperscanline
	add cycles,cycles,r0

	ldr r1,scanline
	add r1,r1,#1
	str r1,scanline
	cmp r1,#240
	ldrne pc,scanlinehook

	adr addy,line242
	str addy,nexttimeout
	ldr pc,scanlinehook
line242 ;------------------------
NMIDELAY EQU CYCLE*30
	add cycles,cycles,#NMIDELAY	;NMI is delayed a few cycles..

	mov r1,#0x80
	strb r1,ppustat		;vbl flag

	adr addy,line241NMI
	str addy,nexttimeout
	b default_scanlinehook
line241NMI ;---------------------------
	ldr r0,frame
	add r0,r0,#1
	str r0,frame
 [ DEBUG
	mov r1,#REG_BASE			;darken screen during NES vblank
	mov r0,#0x00f1
	strh r0,[r1,#REG_BLDMOD]
	ldrh r0,[r1,#REG_VCOUNT]
	mov r1,#19
	bl debug_
 ]
	ldrb r0,ppuctrl0
	tst r0,#0x80
	beq %F0			;NMI?

	ldr r1,lastbank
	sub r0,nes_pc,r1
	push16					;save PC

	encodeP (R)				;save P
	push8 r0

	ldr r1,nes_di
	orr r1,r1,#I				;disable IRQ
	str r1,nes_di

	ldr r0,memmap_tbl+7*4	;JMP [NMI]
	ldr r1,=NMI_VECTOR
	ldrb nes_pc,[r0,r1]!
	ldrb r2,[r0,#1]
	orr nes_pc,nes_pc,r2,lsl#8
	encodePC
	sub cycles,cycles,#3*7*CYCLE
0
	ldr r0,cyclesperscanline
	add cycles,cycles,r0
	sub cycles,cycles,#NMIDELAY
	adr r1,line242_to_end
	str r1,nexttimeout

	mov r0,#241
	str r0,scanline

	ldr pc,scanlinehook
line242_to_end ;------------------------
	ldr r0,cyclesperscanline
	add cycles,cycles,r0

	ldr r1,scanline
	ldr r2,lastscanline
	add r1,r1,#1
	str r1,scanline
	cmp r1,r2
	adreq addy,line0
	streq addy,nexttimeout

	ldr pc,scanlinehook

pcm_scanlinehook
	ldr addy,=pcmctrl
	ldr r2,[addy]
	tst r2,#0x1000			;Is PCM on?
	beq hk0

	ldr r0,pcmirqcount
;	ldr r1,cyclesperscanline
;	subs r0,r0,r1,lsr#4
	subs r0,r0,#121			;Fire Hawk=122
	str r0,pcmirqcount
	bpl hk0

	tst r2,#0x40			;Is PCM loop on?
	ldrne r0,pcmirqbakup
	strne r0,pcmirqcount
	bne hk0
	tst r2,#0x80			;Is PCM IRQ on?
	orrne r2,r2,#0x8000		;set pcm IRQ bit in R4015
	bic r2,r2,#0x1000		;clear channel 5
	str r2,[addy]
	bne irq6502
hk0
default_scanlinehook
	fetch 0
;----------------------------------------------------------
irq6502
;----------------------------------------------------------
	ldrb r0,nes_di
	tst r0,#I
	bne default_scanlinehook		;we dont want no stinkin irqs

	ldr r0,lastbank
	sub r0,nes_pc,r0
	push16					;save PC

	encodeP (R)				;save P
	push8 r0

	ldrb r1,nes_di
	orr r1,r1,#I				;disable IRQ
	strb r1,nes_di

	ldr r0,memmap_tbl+7*4
	ldr r1,=IRQ_VECTOR
	ldrb nes_pc,[r0,r1]!
	ldrb r2,[r0,#1]
	orr nes_pc,nes_pc,r2,lsl#8
	encodePC				;get IRQ vector

	fetch 7
;----------------------------------------------------------------------------
fiveminutes DCD 5*60*60
dontstop DCD 0
agb_vbl DCB 0		;nonzero when AGB enters vblank
novblankwait DCB 0
;----------------------------------------------------------------------------
	AREA rom_code, CODE, READONLY

nes_reset	;called by loadcart (r0-r9 are free to use)
;----------------------------------------------------------------------------
	mov addy,lr

	bl IO_reset_
	bl sound_reset_
	bl ppureset_
;---SRAM setup
	ldrb r0,cartflags
	tst r0,#SRAM			;use sram?
	ldrne r1,=sram_W2			;write to cart sram
	strne r1,writemem_tbl+12
;---NTSC/PAL
	ldr r0,emuflags
	tst r0,#PALTIMING
	ldreq r1,=341*CYCLE		;NTSC		(113+2/3)*3
	ldrne r1,=320*CYCLE		;PAL		(106+9/16)*3
	str r1,cyclesperscanline
	ldreq r1,=261			;NTSC
	ldrne r1,=311			;PAL
	str r1,lastscanline
;---cpu reset
	tst r0,#NOCPUHACK	;load opcode set
	adr r1,jmpops
	adrne r1,normalops
	adr r3,opindex
	mov r4,#8
nr0	ldr r5,[r1,r4,lsl#2]
	ldr r6,[r3,r4,lsl#2]
	str r5,[r6]
	subs r4,r4,#1
	bpl nr0

	mov nes_a,#0
	mov nes_x,#0
	mov nes_y,#0
	mov nes_nz,#0
	mov nes_c,#0
	str nes_a,nes_v
	mov r0,#I		;D=0, disable IRQ
	str r0,nes_di
	ldr r0,=NES_RAM+0x1ff
	str r0,nes_s		;S=FF
	mov cycles,#0

	str nes_a,frame		;frame count reset

	;(clear irq/nmi/res source)...

	ldr r0,memmap_tbl+7*4
	ldr r1,=RES_VECTOR
	ldrb nes_pc,[r0,r1]!
	ldrb r2,[r0,#1]
	orr nes_pc,nes_pc,r2,lsl#8
	encodePC		;get RESET vector

	adr r0,cpuregs
	stmia r0,{nes_nz-nes_pc}
	mov pc,addy
normalops
	DCD _10,_30,_50,_70,_90,_B0,_D0,_F0,_4C
jmpops
	DCD _10x,_30x,_50x,_70x,_90x,_B0x,_D0x,_F0x,_4Cx
opindex
	DCD op_table+0x10*4,op_table+0x30*4,op_table+0x50*4,op_table+0x70*4,op_table+0x90*4
	DCD op_table+0xB0*4,op_table+0xD0*4,op_table+0xF0*4,op_table+0x4C*4
;----------------------------------------------------------
	AREA wram_globals0, CODE, READWRITE

op_table
	DCD _00,_01,_xx,_xx,_xx,_05,_06,_xx,_08,_09,_0A,_xx,_xx,_0D,_0E,_xx
	DCD _10,_11,_xx,_xx,_xx,_15,_16,_xx,_18,_19,_xx,_xx,_xx,_1D,_1E,_xx
	DCD _20,_21,_xx,_xx,_24,_25,_26,_xx,_28,_29,_2A,_xx,_2C,_2D,_2E,_xx
	DCD _30,_31,_xx,_xx,_xx,_35,_36,_xx,_38,_39,_xx,_xx,_xx,_3D,_3E,_xx
	DCD _40,_41,_xx,_xx,_xx,_45,_46,_xx,_48,_49,_4A,_xx,_4C,_4D,_4E,_xx
	DCD _50,_51,_xx,_xx,_xx,_55,_56,_xx,_58,_59,_xx,_xx,_xx,_5D,_5E,_xx
	DCD _60,_61,_xx,_xx,_xx,_65,_66,_xx,_68,_69,_6A,_xx,_6C,_6D,_6E,_xx
	DCD _70,_71,_xx,_xx,_xx,_75,_76,_xx,_78,_79,_xx,_xx,_xx,_7D,_7E,_xx
	DCD _xx,_81,_xx,_xx,_84,_85,_86,_xx,_88,_xx,_8A,_xx,_8C,_8D,_8E,_xx
	DCD _90,_91,_xx,_xx,_94,_95,_96,_xx,_98,_99,_9A,_xx,_xx,_9D,_xx,_xx
	DCD _A0,_A1,_A2,_xx,_A4,_A5,_A6,_xx,_A8,_A9,_AA,_xx,_AC,_AD,_AE,_xx
	DCD _B0,_B1,_xx,_xx,_B4,_B5,_B6,_xx,_B8,_B9,_BA,_xx,_BC,_BD,_BE,_xx
	DCD _C0,_C1,_xx,_xx,_C4,_C5,_C6,_xx,_C8,_C9,_CA,_xx,_CC,_CD,_CE,_xx
	DCD _D0,_D1,_xx,_xx,_xx,_D5,_D6,_xx,_D8,_D9,_xx,_xx,_xx,_DD,_DE,_xx
	DCD _E0,_E1,_xx,_xx,_E4,_E5,_E6,_xx,_E8,_E9,_EA,_xx,_EC,_ED,_EE,_xx
	DCD _F0,_F1,_xx,_xx,_xx,_F5,_F6,_xx,_F8,_F9,_xx,_xx,_xx,_FD,_FE,_xx
  ;readmem_tbl
	DCD ram_R	;$0000
	DCD PPU_R	;$2000
	DCD IO_R	;$4000
	DCD sram_R	;$6000
	DCD rom_R80	;$8000
	DCD rom_RA0	;$A000
	DCD rom_RC0	;$C000
	DCD rom_RE0	;$E000
  ;writemem_tbl
	DCD ram_W	;$0000
	DCD PPU_W	;$2000
	DCD IO_W	;$4000
	DCD sram_W	;$6000
	DCD void	;$8000
	DCD void	;$A000
	DCD void	;$C000
	DCD void	;$E000
   ;memmap_tbl
	DCD NES_RAM		;$0000   0000-7fff
	DCD NES_RAM		;$2000    should
	DCD NES_RAM		;$4000     never
	DCD NES_RAM-0x5800	;$6000      change
rommap	% 4*4			;$8000-FFFF

cpustate
	;group these together for save/loadstate
	% 7*4 ;cpuregs (nz,c,a,x,y,cycles,pc)
	DCD 0 ;nes_s:
	DCD 0 ;nes_di:   (ONLY d,i bits are set)
	DCD 0 ;nes_v:    PSR_V (everything else undefined)
	DCD 0 ;lastbank: last memmap added to PC (used to calculate current PC)

	DCD 0 ;nexttimeout:  jump here when cycles runs out
	DCD 0 ;scanline
	DCD 0 ;scanlinehook
frametotal		;let ui.c see frame count for savestates
	DCD 0 ;frame
	DCD 0 ;cyclesperscanline (341*CYCLE or 320*CYCLE)
	DCD 0 ;lastscanline (261 or 311)
;----------------------------------------------------------------------------
	END

