/* Borrowed from: */

/* KallistiOS ##version##

   cdrom.c

   (c)2000 Dan Potter

 */

#include <dc/cdrom.h>

#define __MAKE_SYSCALL(rs, p1, p2, idx) \
	uint32 *syscall_bc = (uint32*)0x8c0000bc; \
	int (*syscall)() = (int (*)())(*syscall_bc); \
	rs syscall((p1), (p2), 0, (idx));

/* Set disc access mode */
static int gdc_change_data_type(void *param) { __MAKE_SYSCALL(return, param, 0, 10); }
static int gdc_get_drv_stat(void *param) { __MAKE_SYSCALL(return, param, 0, 4); }

int cd_reinit()	{
	int rv = 0;
	unsigned long params[4];
	int cdxa = 0;

	gdc_get_drv_stat(params);
	cdxa = params[1] == 32;

	params[0] = 0;
	params[1] = 4096;
	params[2] = cdxa ? 2048 : 1024;
	params[3] = 2352;

	if(gdc_change_data_type(params) < 0)	{
		rv = ERR_SYS;
	}

	return rv;
}
