/*

Token parser class

Copyright (C) 2003  Joe Fisher, Shiny Technologies, LLC
http://www.shinytechnologies.com

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of 
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the 
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

*/

#include "token.h"
#include "excep.h"

Token::Token(char *szSeps)
{
    strcpy(m_szSeps, szSeps);
}

Token::~Token()
{
}

Token &Token::operator =(Token &tok)
{
    m_str = tok.m_str;
    m_tokList = tok.m_tokList;
    strcpy(m_szSeps, tok.m_szSeps);

    return *this;
}

Token &Token::operator =(char *szBuff)
{
    m_str = szBuff;
    Tokenize();

    return *this;
}

Token &Token::operator =(string &sBuff)
{
    m_str = sBuff;
    Tokenize();

    return *this;
}

const char *Token::operator[](int i)
{
    m_pTok = m_tokList.GetNode(i);

    if (m_pTok == NULL)
    {
        return NULL;
    }
    
    return m_pTok->c_str();
}

void Token::Tokenize()
{
    char *pC, *szBuff;
    szBuff = new char[m_str.length() + 1];

    strcpy(szBuff, m_str.c_str());

    m_tokList.Empty();

    pC = strtok(szBuff, m_szSeps);

    while (pC != NULL)
    {
        string s = pC;
        m_tokList.AddNode(s);
        pC = strtok(NULL, m_szSeps);
    }

    delete[] szBuff;
}

int Token::SetNewSeparators(char *szSeps)
{
    strcpy(m_szSeps, szSeps);
    Tokenize();

    return 1;
}

int Token::Tokenize(char *szSeps)
{
    char szTemp[255];

    if (strlen(szSeps) > 254)
        throw InternalError("Token::Tokenize", "szSeps too long");

    strcpy(szTemp, m_szSeps);
    strcpy(m_szSeps, szSeps);
    Tokenize();
    strcpy(m_szSeps, szTemp);

    return 1;

}

