/*
 * ============================================================================
 *  Title:    Event Subsystem Tables
 *  Author:   J. Zbiciak
 *  $Id: event_tbl.c,v 1.3 2001/02/03 02:31:50 im14u2c Exp $
 * ============================================================================
 *  This file contains lookup tables used by the event subsystem.
 *  I split this out into a separate file since this table is impressively
 *  large.
 * ============================================================================
 *  EVENT_NAMES      -- An array of event names that can be mapped.
 * ============================================================================
 */

static const char rcs_id[]="$Id: event_tbl.c,v 1.3 2001/02/03 02:31:50 im14u2c Exp $";

#include "../config.h"

#ifndef macintosh
# include <SDL/SDL.h>
# include <SDL/SDL_events.h>
#else
# include "keyboard_macos.h"
#endif

#include "periph/periph.h"
#include "event/event.h"
#include "event/event_tbl.h"

/*
 * ============================================================================
 *  EVENT_NAMES      -- An array of event names that can be mapped.
 * ============================================================================
 */
event_name_t event_names[] =
{
    /* -------------------------------------------------------------------- */
    /*  Events that correspond to SDL Key events                            */
    /* -------------------------------------------------------------------- */
    {   "BACKSPACE",    EVENT_BACKSPACE     },
    {   "TAB",          EVENT_TAB           },
    {   "CLEAR",        EVENT_CLEAR         },
    {   "RETURN",       EVENT_RETURN        },
    {   "PAUSE",        EVENT_PAUSE         },
    {   "ESCAPE",       EVENT_ESCAPE        },
    {   "SPACE",        EVENT_SPACE         },
    {   "EXCLAIM",      EVENT_EXCLAIM       },
    {   "QUOTEDBL",     EVENT_QUOTEDBL      },
    {   "HASH",         EVENT_HASH          },
    {   "DOLLAR",       EVENT_DOLLAR        },
    {   "AMPERSAND",    EVENT_AMPERSAND     },
    {   "QUOTE",        EVENT_QUOTE         },
    {   "LEFTPAREN",    EVENT_LEFTPAREN     },
    {   "RIGHTPAREN",   EVENT_RIGHTPAREN    },
    {   "ASTERISK",     EVENT_ASTERISK      },
    {   "PLUS",         EVENT_PLUS          },
    {   "COMMA",        EVENT_COMMA         },
    {   "MINUS",        EVENT_MINUS         },
    {   "PERIOD",       EVENT_PERIOD        },
    {   "SLASH",        EVENT_SLASH         },
    {   "0",            EVENT_0             },
    {   "1",            EVENT_1             },
    {   "2",            EVENT_2             },
    {   "3",            EVENT_3             },
    {   "4",            EVENT_4             },
    {   "5",            EVENT_5             },
    {   "6",            EVENT_6             },
    {   "7",            EVENT_7             },
    {   "8",            EVENT_8             },
    {   "9",            EVENT_9             },
    {   "COLON",        EVENT_COLON         },
    {   "SEMICOLON",    EVENT_SEMICOLON     },
    {   "LESS",         EVENT_LESS          },
    {   "EQUALS",       EVENT_EQUALS        },
    {   "GREATER",      EVENT_GREATER       },
    {   "QUESTION",     EVENT_QUESTION      },
    {   "AT",           EVENT_AT            },
    {   "LEFTBRACKET",  EVENT_LEFTBRACKET   },
    {   "BACKSLASH",    EVENT_BACKSLASH     },
    {   "RIGHTBRACKET", EVENT_RIGHTBRACKET  },
    {   "CARET",        EVENT_CARET         },
    {   "UNDERSCORE",   EVENT_UNDERSCORE    },
    {   "BACKQUOTE",    EVENT_BACKQUOTE     },
    {   "A",            EVENT_a             },
    {   "B",            EVENT_b             },
    {   "C",            EVENT_c             },
    {   "D",            EVENT_d             },
    {   "E",            EVENT_e             },
    {   "F",            EVENT_f             },
    {   "G",            EVENT_g             },
    {   "H",            EVENT_h             },
    {   "I",            EVENT_i             },
    {   "J",            EVENT_j             },
    {   "K",            EVENT_k             },
    {   "L",            EVENT_l             },
    {   "M",            EVENT_m             },
    {   "N",            EVENT_n             },
    {   "O",            EVENT_o             },
    {   "P",            EVENT_p             },
    {   "Q",            EVENT_q             },
    {   "R",            EVENT_r             },
    {   "S",            EVENT_s             },
    {   "T",            EVENT_t             },
    {   "U",            EVENT_u             },
    {   "V",            EVENT_v             },
    {   "W",            EVENT_w             },
    {   "X",            EVENT_x             },
    {   "Y",            EVENT_y             },
    {   "Z",            EVENT_z             },
    {   "DELETE",       EVENT_DELETE        },
#if 0
    {   "WORLD_0",      EVENT_WORLD_0       },
    {   "WORLD_1",      EVENT_WORLD_1       },
    {   "WORLD_2",      EVENT_WORLD_2       },
    {   "WORLD_3",      EVENT_WORLD_3       },
    {   "WORLD_4",      EVENT_WORLD_4       },
    {   "WORLD_5",      EVENT_WORLD_5       },
    {   "WORLD_6",      EVENT_WORLD_6       },
    {   "WORLD_7",      EVENT_WORLD_7       },
    {   "WORLD_8",      EVENT_WORLD_8       },
    {   "WORLD_9",      EVENT_WORLD_9       },
    {   "WORLD_10",     EVENT_WORLD_10      },
    {   "WORLD_11",     EVENT_WORLD_11      },
    {   "WORLD_12",     EVENT_WORLD_12      },
    {   "WORLD_13",     EVENT_WORLD_13      },
    {   "WORLD_14",     EVENT_WORLD_14      },
    {   "WORLD_15",     EVENT_WORLD_15      },
    {   "WORLD_16",     EVENT_WORLD_16      },
    {   "WORLD_17",     EVENT_WORLD_17      },
    {   "WORLD_18",     EVENT_WORLD_18      },
    {   "WORLD_19",     EVENT_WORLD_19      },
    {   "WORLD_20",     EVENT_WORLD_20      },
    {   "WORLD_21",     EVENT_WORLD_21      },
    {   "WORLD_22",     EVENT_WORLD_22      },
    {   "WORLD_23",     EVENT_WORLD_23      },
    {   "WORLD_24",     EVENT_WORLD_24      },
    {   "WORLD_25",     EVENT_WORLD_25      },
    {   "WORLD_26",     EVENT_WORLD_26      },
    {   "WORLD_27",     EVENT_WORLD_27      },
    {   "WORLD_28",     EVENT_WORLD_28      },
    {   "WORLD_29",     EVENT_WORLD_29      },
    {   "WORLD_30",     EVENT_WORLD_30      },
    {   "WORLD_31",     EVENT_WORLD_31      },
    {   "WORLD_32",     EVENT_WORLD_32      },
    {   "WORLD_33",     EVENT_WORLD_33      },
    {   "WORLD_34",     EVENT_WORLD_34      },
    {   "WORLD_35",     EVENT_WORLD_35      },
    {   "WORLD_36",     EVENT_WORLD_36      },
    {   "WORLD_37",     EVENT_WORLD_37      },
    {   "WORLD_38",     EVENT_WORLD_38      },
    {   "WORLD_39",     EVENT_WORLD_39      },
    {   "WORLD_40",     EVENT_WORLD_40      },
    {   "WORLD_41",     EVENT_WORLD_41      },
    {   "WORLD_42",     EVENT_WORLD_42      },
    {   "WORLD_43",     EVENT_WORLD_43      },
    {   "WORLD_44",     EVENT_WORLD_44      },
    {   "WORLD_45",     EVENT_WORLD_45      },
    {   "WORLD_46",     EVENT_WORLD_46      },
    {   "WORLD_47",     EVENT_WORLD_47      },
    {   "WORLD_48",     EVENT_WORLD_48      },
    {   "WORLD_49",     EVENT_WORLD_49      },
    {   "WORLD_50",     EVENT_WORLD_50      },
    {   "WORLD_51",     EVENT_WORLD_51      },
    {   "WORLD_52",     EVENT_WORLD_52      },
    {   "WORLD_53",     EVENT_WORLD_53      },
    {   "WORLD_54",     EVENT_WORLD_54      },
    {   "WORLD_55",     EVENT_WORLD_55      },
    {   "WORLD_56",     EVENT_WORLD_56      },
    {   "WORLD_57",     EVENT_WORLD_57      },
    {   "WORLD_58",     EVENT_WORLD_58      },
    {   "WORLD_59",     EVENT_WORLD_59      },
    {   "WORLD_60",     EVENT_WORLD_60      },
    {   "WORLD_61",     EVENT_WORLD_61      },
    {   "WORLD_62",     EVENT_WORLD_62      },
    {   "WORLD_63",     EVENT_WORLD_63      },
    {   "WORLD_64",     EVENT_WORLD_64      },
    {   "WORLD_65",     EVENT_WORLD_65      },
    {   "WORLD_66",     EVENT_WORLD_66      },
    {   "WORLD_67",     EVENT_WORLD_67      },
    {   "WORLD_68",     EVENT_WORLD_68      },
    {   "WORLD_69",     EVENT_WORLD_69      },
    {   "WORLD_70",     EVENT_WORLD_70      },
    {   "WORLD_71",     EVENT_WORLD_71      },
    {   "WORLD_72",     EVENT_WORLD_72      },
    {   "WORLD_73",     EVENT_WORLD_73      },
    {   "WORLD_74",     EVENT_WORLD_74      },
    {   "WORLD_75",     EVENT_WORLD_75      },
    {   "WORLD_76",     EVENT_WORLD_76      },
    {   "WORLD_77",     EVENT_WORLD_77      },
    {   "WORLD_78",     EVENT_WORLD_78      },
    {   "WORLD_79",     EVENT_WORLD_79      },
    {   "WORLD_80",     EVENT_WORLD_80      },
    {   "WORLD_81",     EVENT_WORLD_81      },
    {   "WORLD_82",     EVENT_WORLD_82      },
    {   "WORLD_83",     EVENT_WORLD_83      },
    {   "WORLD_84",     EVENT_WORLD_84      },
    {   "WORLD_85",     EVENT_WORLD_85      },
    {   "WORLD_86",     EVENT_WORLD_86      },
    {   "WORLD_87",     EVENT_WORLD_87      },
    {   "WORLD_88",     EVENT_WORLD_88      },
    {   "WORLD_89",     EVENT_WORLD_89      },
    {   "WORLD_90",     EVENT_WORLD_90      },
    {   "WORLD_91",     EVENT_WORLD_91      },
    {   "WORLD_92",     EVENT_WORLD_92      },
    {   "WORLD_93",     EVENT_WORLD_93      },
    {   "WORLD_94",     EVENT_WORLD_94      },
    {   "WORLD_95",     EVENT_WORLD_95      },
#endif
    {   "KP0",          EVENT_KP0           },
    {   "KP1",          EVENT_KP1           },
    {   "KP2",          EVENT_KP2           },
    {   "KP3",          EVENT_KP3           },
    {   "KP4",          EVENT_KP4           },
    {   "KP5",          EVENT_KP5           },
    {   "KP6",          EVENT_KP6           },
    {   "KP7",          EVENT_KP7           },
    {   "KP8",          EVENT_KP8           },
    {   "KP9",          EVENT_KP9           },
    {   "KP_PERIOD",    EVENT_KP_PERIOD     },
    {   "KP_DIVIDE",    EVENT_KP_DIVIDE     },
    {   "KP_MULTIPLY",  EVENT_KP_MULTIPLY   },
    {   "KP_MINUS",     EVENT_KP_MINUS      },
    {   "KP_PLUS",      EVENT_KP_PLUS       },
    {   "KP_ENTER",     EVENT_KP_ENTER      },
    {   "KP_EQUALS",    EVENT_KP_EQUALS     },
    {   "UP",           EVENT_UP            },
    {   "DOWN",         EVENT_DOWN          },
    {   "RIGHT",        EVENT_RIGHT         },
    {   "LEFT",         EVENT_LEFT          },
    {   "INSERT",       EVENT_INSERT        },
    {   "HOME",         EVENT_HOME          },
    {   "END",          EVENT_END           },
    {   "PAGEUP",       EVENT_PAGEUP        },
    {   "PAGEDOWN",     EVENT_PAGEDOWN      },
    {   "F1",           EVENT_F1            },
    {   "F2",           EVENT_F2            },
    {   "F3",           EVENT_F3            },
    {   "F4",           EVENT_F4            },
    {   "F5",           EVENT_F5            },
    {   "F6",           EVENT_F6            },
    {   "F7",           EVENT_F7            },
    {   "F8",           EVENT_F8            },
    {   "F9",           EVENT_F9            },
    {   "F10",          EVENT_F10           },
    {   "F11",          EVENT_F11           },
    {   "F12",          EVENT_F12           },
    {   "F13",          EVENT_F13           },
    {   "F14",          EVENT_F14           },
    {   "F15",          EVENT_F15           },
    {   "NUMLOCK",      EVENT_NUMLOCK       },
    {   "CAPSLOCK",     EVENT_CAPSLOCK      },
    {   "SCROLLOCK",    EVENT_SCROLLOCK     },
    {   "RSHIFT",       EVENT_RSHIFT        },
    {   "LSHIFT",       EVENT_LSHIFT        },
    {   "RCTRL",        EVENT_RCTRL         },
    {   "LCTRL",        EVENT_LCTRL         },
    {   "RALT",         EVENT_RALT          },
    {   "LALT",         EVENT_LALT          },
    {   "RMETA",        EVENT_RMETA         },
    {   "LMETA",        EVENT_LMETA         },
    {   "LSUPER",       EVENT_LSUPER        },
    {   "RSUPER",       EVENT_RSUPER        },
    {   "MODE",         EVENT_MODE          },
    {   "HELP",         EVENT_HELP          },
    {   "PRINT",        EVENT_PRINT         },
    {   "SYSREQ",       EVENT_SYSREQ        },
    {   "BREAK",        EVENT_BREAK         },
    {   "MENU",         EVENT_MENU          },
    {   "POWER",        EVENT_POWER         },
    {   "EURO",         EVENT_EURO          },

    /* -------------------------------------------------------------------- */
    /*  More common aliases for some of the SDLKey names                    */
    /* -------------------------------------------------------------------- */
    {   " ",            EVENT_SPACE         },
    {   "!",            EVENT_EXCLAIM       },
    {   "\"",           EVENT_QUOTEDBL      },
    {   "#",            EVENT_HASH          },
    {   "$",            EVENT_DOLLAR        },
    {   "&",            EVENT_AMPERSAND     },
    {   "'",            EVENT_QUOTE         },
    {   "(",            EVENT_LEFTPAREN     },
    {   "*",            EVENT_RIGHTPAREN    },
    {   ")",            EVENT_ASTERISK      },
    {   "+",            EVENT_PLUS          },
    {   ",",            EVENT_COMMA         },
    {   "-",            EVENT_MINUS         },
    {   ".",            EVENT_PERIOD        },
    {   "/",            EVENT_SLASH         },
    {   ":",            EVENT_COLON         },
    {   ";",            EVENT_SEMICOLON     },
    {   "<",            EVENT_LESS          },
    {   "=",            EVENT_EQUALS        },
    {   ">",            EVENT_GREATER       },
    {   "?",            EVENT_QUESTION      },
    {   "@",            EVENT_AT            },
    {   "[",            EVENT_LEFTBRACKET   },
    {   "\\",           EVENT_BACKSLASH     },
    {   "]",            EVENT_RIGHTBRACKET  },
    {   "^",            EVENT_CARET         },
    {   "_",            EVENT_UNDERSCORE    },
    {   "`",            EVENT_BACKQUOTE     },

    /* -------------------------------------------------------------------- */
    /*  The QUIT event, which corresponds to SDLQuit                        */
    /* -------------------------------------------------------------------- */
    {   "QUIT",         EVENT_QUIT          },

    /* -------------------------------------------------------------------- */
    /*  The HIDE  event is lets us know when we're iconified or not.        */
    /*  A "HIDE DOWN" event means we're iconified, and a "HIDE UP" event    */
    /*  means we're visible.  I use this to disable graphics updates while  */
    /*  we're iconified.                                                    */
    /* -------------------------------------------------------------------- */
    {   "HIDE",         EVENT_HIDE          },

    /* -------------------------------------------------------------------- */
    /*  The 16 joystick directions that we resolve, on joystick 0.          */
    /* -------------------------------------------------------------------- */
    {   "JS0_E",        EVENT_JS0_E         },
    {   "JS0_ENE",      EVENT_JS0_ENE       },
    {   "JS0_NE",       EVENT_JS0_NE        },
    {   "JS0_NNE",      EVENT_JS0_NNE       },
    {   "JS0_N",        EVENT_JS0_N         },
    {   "JS0_NNW",      EVENT_JS0_NNW       },
    {   "JS0_NW",       EVENT_JS0_NW        },
    {   "JS0_WNW",      EVENT_JS0_WNW       },
    {   "JS0_W",        EVENT_JS0_W         },
    {   "JS0_WSW",      EVENT_JS0_WSW       },
    {   "JS0_SW",       EVENT_JS0_SW        },
    {   "JS0_SSW",      EVENT_JS0_SSW       },
    {   "JS0_S",        EVENT_JS0_S         },
    {   "JS0_SSE",      EVENT_JS0_SSE       },
    {   "JS0_SE",       EVENT_JS0_SE        },
    {   "JS0_ESE",      EVENT_JS0_ESE       },

    /* -------------------------------------------------------------------- */
    /*  The joystick buttons (up to 32)                                     */
    /* -------------------------------------------------------------------- */
    {   "JS0_BTN_00",   EVENT_JS0_BTN_00    },
    {   "JS0_BTN_01",   EVENT_JS0_BTN_01    },
    {   "JS0_BTN_02",   EVENT_JS0_BTN_02    },
    {   "JS0_BTN_03",   EVENT_JS0_BTN_03    },
    {   "JS0_BTN_04",   EVENT_JS0_BTN_04    },
    {   "JS0_BTN_05",   EVENT_JS0_BTN_05    },
    {   "JS0_BTN_06",   EVENT_JS0_BTN_06    },
    {   "JS0_BTN_07",   EVENT_JS0_BTN_07    },
    {   "JS0_BTN_08",   EVENT_JS0_BTN_08    },
    {   "JS0_BTN_09",   EVENT_JS0_BTN_09    },
    {   "JS0_BTN_10",   EVENT_JS0_BTN_10    },
    {   "JS0_BTN_11",   EVENT_JS0_BTN_11    },
    {   "JS0_BTN_12",   EVENT_JS0_BTN_12    },
    {   "JS0_BTN_13",   EVENT_JS0_BTN_13    },
    {   "JS0_BTN_14",   EVENT_JS0_BTN_14    },
    {   "JS0_BTN_15",   EVENT_JS0_BTN_15    },
    {   "JS0_BTN_16",   EVENT_JS0_BTN_16    },
    {   "JS0_BTN_17",   EVENT_JS0_BTN_17    },
    {   "JS0_BTN_18",   EVENT_JS0_BTN_18    },
    {   "JS0_BTN_19",   EVENT_JS0_BTN_19    },
    {   "JS0_BTN_20",   EVENT_JS0_BTN_20    },
    {   "JS0_BTN_21",   EVENT_JS0_BTN_21    },
    {   "JS0_BTN_22",   EVENT_JS0_BTN_22    },
    {   "JS0_BTN_23",   EVENT_JS0_BTN_23    },
    {   "JS0_BTN_24",   EVENT_JS0_BTN_24    },
    {   "JS0_BTN_25",   EVENT_JS0_BTN_25    },
    {   "JS0_BTN_26",   EVENT_JS0_BTN_26    },
    {   "JS0_BTN_27",   EVENT_JS0_BTN_27    },
    {   "JS0_BTN_08",   EVENT_JS0_BTN_28    },
    {   "JS0_BTN_29",   EVENT_JS0_BTN_29    },
    {   "JS0_BTN_30",   EVENT_JS0_BTN_30    },
    {   "JS0_BTN_31",   EVENT_JS0_BTN_31    },


    /* -------------------------------------------------------------------- */
    /*  The 16 joystick directions that we resolve, on joystick 1.          */
    /* -------------------------------------------------------------------- */
    {   "JS1_E",        EVENT_JS1_E         },
    {   "JS1_ENE",      EVENT_JS1_ENE       },
    {   "JS1_NE",       EVENT_JS1_NE        },
    {   "JS1_NNE",      EVENT_JS1_NNE       },
    {   "JS1_N",        EVENT_JS1_N         },
    {   "JS1_NNW",      EVENT_JS1_NNW       },
    {   "JS1_NW",       EVENT_JS1_NW        },
    {   "JS1_WNW",      EVENT_JS1_WNW       },
    {   "JS1_W",        EVENT_JS1_W         },
    {   "JS1_WSW",      EVENT_JS1_WSW       },
    {   "JS1_SW",       EVENT_JS1_SW        },
    {   "JS1_SSW",      EVENT_JS1_SSW       },
    {   "JS1_S",        EVENT_JS1_S         },
    {   "JS1_SSE",      EVENT_JS1_SSE       },
    {   "JS1_SE",       EVENT_JS1_SE        },
    {   "JS1_ESE",      EVENT_JS1_ESE       },

    /* -------------------------------------------------------------------- */
    /*  The joystick buttons (up to 16)                                     */
    /* -------------------------------------------------------------------- */
    {   "JS1_BTN_00",   EVENT_JS1_BTN_00    },
    {   "JS1_BTN_01",   EVENT_JS1_BTN_01    },
    {   "JS1_BTN_02",   EVENT_JS1_BTN_02    },
    {   "JS1_BTN_03",   EVENT_JS1_BTN_03    },
    {   "JS1_BTN_04",   EVENT_JS1_BTN_04    },
    {   "JS1_BTN_05",   EVENT_JS1_BTN_05    },
    {   "JS1_BTN_06",   EVENT_JS1_BTN_06    },
    {   "JS1_BTN_07",   EVENT_JS1_BTN_07    },
    {   "JS1_BTN_08",   EVENT_JS1_BTN_08    },
    {   "JS1_BTN_09",   EVENT_JS1_BTN_09    },
    {   "JS1_BTN_10",   EVENT_JS1_BTN_10    },
    {   "JS1_BTN_11",   EVENT_JS1_BTN_11    },
    {   "JS1_BTN_12",   EVENT_JS1_BTN_12    },
    {   "JS1_BTN_13",   EVENT_JS1_BTN_13    },
    {   "JS1_BTN_14",   EVENT_JS1_BTN_14    },
    {   "JS1_BTN_15",   EVENT_JS1_BTN_15    },
    {   "JS1_BTN_16",   EVENT_JS1_BTN_16    },
    {   "JS1_BTN_17",   EVENT_JS1_BTN_17    },
    {   "JS1_BTN_18",   EVENT_JS1_BTN_18    },
    {   "JS1_BTN_19",   EVENT_JS1_BTN_19    },
    {   "JS1_BTN_20",   EVENT_JS1_BTN_20    },
    {   "JS1_BTN_21",   EVENT_JS1_BTN_21    },
    {   "JS1_BTN_22",   EVENT_JS1_BTN_22    },
    {   "JS1_BTN_23",   EVENT_JS1_BTN_23    },
    {   "JS1_BTN_24",   EVENT_JS1_BTN_24    },
    {   "JS1_BTN_25",   EVENT_JS1_BTN_25    },
    {   "JS1_BTN_26",   EVENT_JS1_BTN_26    },
    {   "JS1_BTN_27",   EVENT_JS1_BTN_27    },
    {   "JS1_BTN_28",   EVENT_JS1_BTN_28    },
    {   "JS1_BTN_29",   EVENT_JS1_BTN_29    },
    {   "JS1_BTN_30",   EVENT_JS1_BTN_30    },
    {   "JS1_BTN_31",   EVENT_JS1_BTN_31    },

    /* -------------------------------------------------------------------- */
    /*  The 16 joystick directions that we resolve, on joystick 2.          */
    /* -------------------------------------------------------------------- */
    {   "JS2_E",        EVENT_JS2_E         },
    {   "JS2_ENE",      EVENT_JS2_ENE       },
    {   "JS2_NE",       EVENT_JS2_NE        },
    {   "JS2_NNE",      EVENT_JS2_NNE       },
    {   "JS2_N",        EVENT_JS2_N         },
    {   "JS2_NNW",      EVENT_JS2_NNW       },
    {   "JS2_NW",       EVENT_JS2_NW        },
    {   "JS2_WNW",      EVENT_JS2_WNW       },
    {   "JS2_W",        EVENT_JS2_W         },
    {   "JS2_WSW",      EVENT_JS2_WSW       },
    {   "JS2_SW",       EVENT_JS2_SW        },
    {   "JS2_SSW",      EVENT_JS2_SSW       },
    {   "JS2_S",        EVENT_JS2_S         },
    {   "JS2_SSE",      EVENT_JS2_SSE       },
    {   "JS2_SE",       EVENT_JS2_SE        },
    {   "JS2_ESE",      EVENT_JS2_ESE       },

    /* -------------------------------------------------------------------- */
    /*  The joystick buttons (up to 16)                                     */
    /* -------------------------------------------------------------------- */
    {   "JS2_BTN_00",   EVENT_JS2_BTN_00    },
    {   "JS2_BTN_01",   EVENT_JS2_BTN_01    },
    {   "JS2_BTN_02",   EVENT_JS2_BTN_02    },
    {   "JS2_BTN_03",   EVENT_JS2_BTN_03    },
    {   "JS2_BTN_04",   EVENT_JS2_BTN_04    },
    {   "JS2_BTN_05",   EVENT_JS2_BTN_05    },
    {   "JS2_BTN_06",   EVENT_JS2_BTN_06    },
    {   "JS2_BTN_07",   EVENT_JS2_BTN_07    },
    {   "JS2_BTN_08",   EVENT_JS2_BTN_08    },
    {   "JS2_BTN_09",   EVENT_JS2_BTN_09    },
    {   "JS2_BTN_10",   EVENT_JS2_BTN_10    },
    {   "JS2_BTN_11",   EVENT_JS2_BTN_11    },
    {   "JS2_BTN_12",   EVENT_JS2_BTN_12    },
    {   "JS2_BTN_13",   EVENT_JS2_BTN_13    },
    {   "JS2_BTN_14",   EVENT_JS2_BTN_14    },
    {   "JS2_BTN_15",   EVENT_JS2_BTN_15    },
    {   "JS2_BTN_16",   EVENT_JS2_BTN_16    },
    {   "JS2_BTN_17",   EVENT_JS2_BTN_17    },
    {   "JS2_BTN_18",   EVENT_JS2_BTN_18    },
    {   "JS2_BTN_19",   EVENT_JS2_BTN_19    },
    {   "JS2_BTN_20",   EVENT_JS2_BTN_20    },
    {   "JS2_BTN_21",   EVENT_JS2_BTN_21    },
    {   "JS2_BTN_22",   EVENT_JS2_BTN_22    },
    {   "JS2_BTN_23",   EVENT_JS2_BTN_23    },
    {   "JS2_BTN_24",   EVENT_JS2_BTN_24    },
    {   "JS2_BTN_25",   EVENT_JS2_BTN_25    },
    {   "JS2_BTN_26",   EVENT_JS2_BTN_26    },
    {   "JS2_BTN_27",   EVENT_JS2_BTN_27    },
    {   "JS2_BTN_28",   EVENT_JS2_BTN_28    },
    {   "JS2_BTN_29",   EVENT_JS2_BTN_29    },
    {   "JS2_BTN_30",   EVENT_JS2_BTN_30    },
    {   "JS2_BTN_31",   EVENT_JS2_BTN_31    },

    /* -------------------------------------------------------------------- */
    /*  The 16 joystick directions that we resolve, on joystick 3.          */
    /* -------------------------------------------------------------------- */
    {   "JS3_E",        EVENT_JS3_E         },
    {   "JS3_ENE",      EVENT_JS3_ENE       },
    {   "JS3_NE",       EVENT_JS3_NE        },
    {   "JS3_NNE",      EVENT_JS3_NNE       },
    {   "JS3_N",        EVENT_JS3_N         },
    {   "JS3_NNW",      EVENT_JS3_NNW       },
    {   "JS3_NW",       EVENT_JS3_NW        },
    {   "JS3_WNW",      EVENT_JS3_WNW       },
    {   "JS3_W",        EVENT_JS3_W         },
    {   "JS3_WSW",      EVENT_JS3_WSW       },
    {   "JS3_SW",       EVENT_JS3_SW        },
    {   "JS3_SSW",      EVENT_JS3_SSW       },
    {   "JS3_S",        EVENT_JS3_S         },
    {   "JS3_SSE",      EVENT_JS3_SSE       },
    {   "JS3_SE",       EVENT_JS3_SE        },
    {   "JS3_ESE",      EVENT_JS3_ESE       },

    /* -------------------------------------------------------------------- */
    /*  The joystick buttons (up to 16)                                     */
    /* -------------------------------------------------------------------- */
    {   "JS3_BTN_00",   EVENT_JS3_BTN_00    },
    {   "JS3_BTN_01",   EVENT_JS3_BTN_01    },
    {   "JS3_BTN_02",   EVENT_JS3_BTN_02    },
    {   "JS3_BTN_03",   EVENT_JS3_BTN_03    },
    {   "JS3_BTN_04",   EVENT_JS3_BTN_04    },
    {   "JS3_BTN_05",   EVENT_JS3_BTN_05    },
    {   "JS3_BTN_06",   EVENT_JS3_BTN_06    },
    {   "JS3_BTN_07",   EVENT_JS3_BTN_07    },
    {   "JS3_BTN_08",   EVENT_JS3_BTN_08    },
    {   "JS3_BTN_09",   EVENT_JS3_BTN_09    },
    {   "JS3_BTN_10",   EVENT_JS3_BTN_10    },
    {   "JS3_BTN_11",   EVENT_JS3_BTN_11    },
    {   "JS3_BTN_12",   EVENT_JS3_BTN_12    },
    {   "JS3_BTN_13",   EVENT_JS3_BTN_13    },
    {   "JS3_BTN_14",   EVENT_JS3_BTN_14    },
    {   "JS3_BTN_15",   EVENT_JS3_BTN_15    },
    {   "JS3_BTN_16",   EVENT_JS3_BTN_16    },
    {   "JS3_BTN_17",   EVENT_JS3_BTN_17    },
    {   "JS3_BTN_18",   EVENT_JS3_BTN_18    },
    {   "JS3_BTN_19",   EVENT_JS3_BTN_19    },
    {   "JS3_BTN_20",   EVENT_JS3_BTN_20    },
    {   "JS3_BTN_21",   EVENT_JS3_BTN_21    },
    {   "JS3_BTN_22",   EVENT_JS3_BTN_22    },
    {   "JS3_BTN_23",   EVENT_JS3_BTN_23    },
    {   "JS3_BTN_24",   EVENT_JS3_BTN_24    },
    {   "JS3_BTN_25",   EVENT_JS3_BTN_25    },
    {   "JS3_BTN_26",   EVENT_JS3_BTN_26    },
    {   "JS3_BTN_27",   EVENT_JS3_BTN_27    },
    {   "JS3_BTN_28",   EVENT_JS3_BTN_28    },
    {   "JS3_BTN_29",   EVENT_JS3_BTN_29    },
    {   "JS3_BTN_30",   EVENT_JS3_BTN_30    },
    {   "JS3_BTN_31",   EVENT_JS3_BTN_31    },
};

const int event_name_count = sizeof(event_names) / sizeof(event_name_t);

/* ======================================================================== */
/*  This program is free software; you can redistribute it and/or modify    */
/*  it under the terms of the GNU General Public License as published by    */
/*  the Free Software Foundation; either version 2 of the License, or       */
/*  (at your option) any later version.                                     */
/*                                                                          */
/*  This program is distributed in the hope that it will be useful,         */
/*  but WITHOUT ANY WARRANTY; without even the implied warranty of          */
/*  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU       */
/*  General Public License for more details.                                */
/*                                                                          */
/*  You should have received a copy of the GNU General Public License       */
/*  along with this program; if not, write to the Free Software             */
/*  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.               */
/* ======================================================================== */
/*                 Copyright (c) 1998-1999, Joseph Zbiciak                  */
/* ======================================================================== */
