#include "wc_debug.h"
#include <ogc/exi.h>

int EmuDebugf(const char *format, ...) {
  va_list args;
  int len;
  char buffer[WC_DEGUB_BUFFER_SIZE];
  va_start(args, format);

  //len = _vscprintf(format, args);
  //if(len >= WC_DEGUB_BUFFER_SIZE)
    //return 0;
  len = vsprintf(buffer, format, args);
  EmuDebug(buffer);

  return len;
}

#define MAGIC_WORD 0xC001F00D
#define MAGIC_BYTE 0xEC

u32 GetWhineCubeMagic() {
  u32 data;
  EXI_Select(2, 0, 0);
  data = MAGIC_WORD;
  EXI_Imm(2, &data, 4, EXI_WRITE);
  EXI_Imm(2, &data, 4, EXI_READ);
  EXI_Deselect(2);

  return data;
}

bool IsRunningOnWhineCube() {
  return (GetWhineCubeMagic() >> 24) == MAGIC_BYTE;
}

char *GetWhineCubeVersion(char *buffer) {
  buffer[0] = 0;
  if(IsRunningOnWhineCube()) {
    u32 data = GetWhineCubeMagic();
    sprintf(buffer, "r%i", data & 0xFFFFFF);
  }
  return buffer;
}
