#include "gba.h"

#define CHRBASE (u16*)0x6000000
#define BG0BASE (u16*)0x6004000
#define BG1BASE (u16*)0x6008000

extern u32 Image$$RW$$Limit;
extern u32 IOmode;	//IOmode=4 when transfer is finished
extern u32 current;	//bytes received
extern u32 total;	//bytes expected

void loader(void);
void initgfx(void);
void tilecopy(int,int);
void irq(void);

const u16 tile1[128]={
0x1111,0x1111,0x1121,0x1222,0x1121,0x1212,0x1121,0x1222,
0x1111,0x1111,0x1121,0x1222,0x1121,0x1212,0x1121,0x1222,
0x1111,0x1111,0x1222,0x1121,0x1212,0x1121,0x1222,0x1121,
0x1111,0x1111,0x1222,0x1222,0x1212,0x1212,0x1222,0x1222,
0x1111,0x1111,0x1121,0x1222,0x1121,0x1212,0x1121,0x1222,
0x1111,0x1111,0x1222,0x1121,0x1212,0x1121,0x1222,0x1121,
0x1111,0x1111,0x1222,0x1222,0x1212,0x1212,0x1222,0x1222,
0x1111,0x1111,0x1121,0x1121,0x1121,0x1121,0x1121,0x1121,
0x1111,0x1111,0x1222,0x1222,0x1212,0x1212,0x1222,0x1222,
0x1111,0x1111,0x1121,0x1222,0x1121,0x1212,0x1121,0x1222,
0x1111,0x1111,0x1121,0x1121,0x1121,0x1121,0x1121,0x1121,
0x1111,0x1111,0x1121,0x1222,0x1121,0x1212,0x1121,0x1222,
0x1111,0x1111,0x1222,0x1121,0x1212,0x1121,0x1222,0x1121,
0x1111,0x1111,0x1121,0x1121,0x1121,0x1121,0x1121,0x1121,
0x1111,0x1111,0x1222,0x1222,0x1212,0x1212,0x1222,0x1222,
0x1111,0x1111,0x1222,0x1121,0x1212,0x1121,0x1222,0x1121};
const u16 tile2[64]={
0x1111,0x1111,0x1111,0x1111,0x1111,0x1111,0x1111,0x1111,
0x1111,0x1111,0x1221,0x1211,0x1111,0x1112,0x1112,0x1211,
0x1111,0x1111,0x1111,0x1111,0x1111,0x1111,0x1111,0x1111,
0x2111,0x1111,0x2111,0x1111,0x1121,0x2121,0x1111,0x2111,
0x1111,0x1111,0x1111,0x1111,0x1111,0x1111,0x1111,0x1111,
0x1111,0x1112,0x1112,0x1111,0x1211,0x1112,0x1111,0x2111,
0x1111,0x1111,0x1111,0x1111,0x1111,0x1111,0x1111,0x1111,
0x1111,0x1121,0x1121,0x1111,0x2111,0x1121,0x1112,0x1111};

void AGBmain() {
	u32 *src=(u32*)0x20000c0;
	u32 *dst=(u32*)0x3000000;
	fptr jump_to_iwram=loader;
	__asm {mov sp,#0x3007f00}
	do {				//copy self to internal ram
		*dst=*src;
		src++;
		dst++;
	} while(dst<&Image$$RW$$Limit);
	jump_to_iwram();
}

void loader() {
	int scrollpos=0;
	int tilerotate=0;
	fptr jump_to_exram=(fptr)0x2000000;

	initgfx();

	REG_IF=0xffff;		//stop any pending interrupts
	REG_IE=0x0080;		//serial interrupt enable
	REG_IME=1;		//master interrupt enable
	INTR_VECT=(u32)irq;

	REG_RCNT=0;
	REG_SIOMLT_SEND=0x99;	//ready to receive
	REG_SIOCNT=0x6003;

	while(IOmode<4) {
		scrollpos--;
		REG_BG1VOFS=scrollpos;
		REG_BG0VOFS=96+160*current/total;
		while(REG_VCOUNT>=160) {};	//wait a while
		while(REG_VCOUNT<160) {};
		if(!(scrollpos&3))
			tilecopy(2,tilerotate++);
		if(!(scrollpos&7))
			tilecopy(1,tilerotate>>1);
		if(!(scrollpos&15))
			tilecopy(0,tilerotate>>2);
	}
	REG_SIOCNT=0x2000;
	jump_to_exram();
}

void initgfx() {
	int i;
	u16 *p,*q;
	u32 seed1=0x87654321;
	u32 seed2=0x12345678;
	u32 tmp;

	REG_DISPCNT=FORCE_BLANK;	//screen OFF
	REG_BG0CNT=0x8800;	//16color 256x512 CHRbase0 SCRbase8 priority0
	REG_BG1CNT=0x1001;	//16color 256x256 CHRbase0 SCRbase16 priority1

	p=BG0BASE; q=BG1BASE;
	for(i=0;i<32*32;i++) {//blank both BGs
		*p=0x0c; *q=0x0c;
		p++; q++;
	}
	for(i=0;i<32*32;i++) {//BG0="water" level
		tmp=seed1;		//silly random number generator
		seed1+=seed2;
		seed2=tmp;
		*p=seed1>>29;
		p++;
	}
	*(p-1025)=0x0428;//splash
	*(p-1054)=0x29;
	*(p-1024)=0x20;
	*(p-1023)=0x21;
	*(p-992)=0x22;
	*(p-991)=0x23;
	*(p-1022)=0x14;
	*(p-993)=0x15;
	q=BG1BASE;
	for(i=0;i<32;i++) {//BG1=bit stream
		tmp=seed1;
		seed1+=seed2;
		seed2=tmp;
		*q=seed1>>29;
		*(q+1)=seed1&7;
		q+=32;
	}
	p=MEM_PALETTE;
	p[0]=0x7fff; p[1]=0x7fff; p[2]=0;

	REG_BG0HOFS=111;
	REG_BG1HOFS=111;
	REG_DISPCNT=BG0_EN|BG1_EN;
}

void tilecopy(int tileset,int rotate) {
	u16 *p=CHRBASE+tileset*0x100;
	int i;
	rotate*=16;
	for(i=0;i<128;i++) {
		*p=tile1[(i+rotate)&127];
		p++;
	}
	if(tileset==2) for(i=0;i<64;i++) {
		*p=tile2[(i+rotate)&63];
		p++;
	}
}
