;	AREA rom_code, CODE, READONLY ;-- - - - - - - - - - - - - - - - - - - - - -
	AREA wram_code0, CODE, READWRITE

	INCLUDE equates.h
	INCLUDE h6280mac.h
	INCLUDE cart.h
	INCLUDE memory.h
	INCLUDE io.h
	INCLUDE vdc.h
	INCLUDE sound.h
	INCLUDE cdrom.h

	IMPORT |wram_globals0$$Base|
	IMPORT ui	;ui.c

	EXPORT pce_reset
	EXPORT run
	EXPORT op_table
	EXPORT default_scanlinehook
	EXPORT cpustate
	EXPORT mapperstate
	EXPORT rommap
	EXPORT frametotal
	EXPORT sleeptime
	EXPORT novblankwait
	EXPORT dontstop

;----------------------------------------------------------------------------
_xx;	???					;invalid opcode
;----------------------------------------------------------------------------
	[ DEBUG
		adr r0,_xx
		mov r1,#0
		bl debug_
	]
	fetch 2

;----------------------------------------------------------------------------
_00;   BRK					;error?
;----------------------------------------------------------------------------
	sub pce_pc,pce_pc,#1
	ldr r1,lastbank
	sub pce_pc,pce_pc,r1
	encodePC
	ldrb r0,[pce_pc]
	cmp r0,#0				;real BRK?
	beq doBRK
	fetch 0
doBRK
	mov r11,r11				;No$GBA debugg!
	[ DEBUG
		adr r0,_00
		mov r1,#0
		bl debug_
	]

	ldr r12,=BRK_VECTOR
	ldr r0,lastbank
	sub r1,pce_pc,r0
	add r0,r1,#1
	push16				;save PC

	encodeP (B)			;save P
	b irq_cont

	LTORG
;----------------------------------------------------------------------------
_01;   ORA ($nn,X)
;----------------------------------------------------------------------------
	doIIX
	opORA
	fetch 7
;----------------------------------------------------------------------------
_02;   SXY swap X & Y
;----------------------------------------------------------------------------
	opSWAP pce_x,pce_y
	fetch 3
;----------------------------------------------------------------------------
;_03;   ST0 #$nn store immediate value at VDC, [moved to vdc.s]
;----------------------------------------------------------------------------
;	readmemimm
;	bl _VDC0W
;	fetch 4
;----------------------------------------------------------------------------
_04;   TSB $nn
;----------------------------------------------------------------------------
	doZ
	opTSB
	fetch 6
;----------------------------------------------------------------------------
_05;   ORA $nn
;----------------------------------------------------------------------------
	doZ
	opORA
	fetch 4
;----------------------------------------------------------------------------
_06;   ASL $nn
;----------------------------------------------------------------------------
	doZ
	opASL
	fetch_c 6
;----------------------------------------------------------------------------
_07;   RMB0
;----------------------------------------------------------------------------
	opRMB 0
;----------------------------------------------------------------------------
_08;   PHP
;----------------------------------------------------------------------------
	encodeP (B)
	push8 r0
	fetch 3
;----------------------------------------------------------------------------
_09;   ORA #$nn
;----------------------------------------------------------------------------
	doIMM
	opORA
	fetch 2
;----------------------------------------------------------------------------
_0A;   ASL
;----------------------------------------------------------------------------
	adds pce_a,pce_a,pce_a
	mov pce_nz,pce_a,asr#24		;NZ
	orr cycles,cycles,#CYC_C	;Prepare C
	fetch_c 2					;also subs carry
;----------------------------------------------------------------------------
_0C;   TSB $nnnn
;----------------------------------------------------------------------------
	doABS
	opTSB
	fetch 7
;----------------------------------------------------------------------------
_0D;   ORA $nnnn
;----------------------------------------------------------------------------
	doABS
	opORA
	fetch 4
;----------------------------------------------------------------------------
_0E;   ASL $nnnn
;----------------------------------------------------------------------------
	doABS
	opASL
	fetch_c 6
nobbranch
	fetch 6
;----------------------------------------------------------------------------
_0F;   BBR0 $nn,*
;----------------------------------------------------------------------------
	opBBRx 0
;----------------------------------------------------------------------------
_10;   BPL *
;----------------------------------------------------------------------------
	tst pce_nz,#0x80000000
	bne nobranch
	ldrsb r0,[pce_pc],#1
	add pce_pc,pce_pc,r0
	fetch 4
nobranch
	add pce_pc,pce_pc,#1
	fetch 2
;----------------------------------------------------------------------------
_10y;   BPL *
;----------------------------------------------------------------------------
	tst pce_nz,#0x80000000
	bne nobranch
	ldrsb r0,[pce_pc],#1
	add pce_pc,pce_pc,r0
	cmp r0,#-8						;speed hack 2 Street Fighter II CE
	andcs cycles,cycles,#CYC_MASK	;Save CPU bits
	fetch 4
;----------------------------------------------------------------------------
_11;   ORA ($nn),Y
;----------------------------------------------------------------------------
	doIIY
	opORA
	fetch 7
;----------------------------------------------------------------------------
_12;   ORA ($nn)
;----------------------------------------------------------------------------
	doZPI
	opORA
	fetch 7
;----------------------------------------------------------------------------
;_13;   ST1 #$nn store immediate value at VDC, [moved to vdc.s]
;----------------------------------------------------------------------------
;	readmemimm
;	adr lr,%F0
;	ldr pc,vdcRegPtrL_		;what function
;0
;	fetch 4
;----------------------------------------------------------------------------
_14;   TRB $nn
;----------------------------------------------------------------------------
	doZ
	opTRB
	fetch 6
;----------------------------------------------------------------------------
_15;   ORA $nn,X
;----------------------------------------------------------------------------
	doZIXf
	opORA
	fetch 4
;----------------------------------------------------------------------------
_16;   ASL $nn,X
;----------------------------------------------------------------------------
	doZIXf
	opASL
	fetch_c 6
;----------------------------------------------------------------------------
_17;   RMB1
;----------------------------------------------------------------------------
	opRMB 1
;----------------------------------------------------------------------------
_18;   CLC
;----------------------------------------------------------------------------
	bic cycles,cycles,#CYC_C
	fetch 2
;----------------------------------------------------------------------------
_19;   ORA $nnnn,Y
;----------------------------------------------------------------------------
	doAIY
	opORA
	fetch 5
;----------------------------------------------------------------------------
_1A;   INA
;----------------------------------------------------------------------------
	add pce_a,pce_a,#0x01000000
	mov pce_nz,pce_a,asr#24		;NZ
	fetch 2
;----------------------------------------------------------------------------
_1C;   TRB $nnnn
;----------------------------------------------------------------------------
	doABS
	opTRB
	fetch 7
;----------------------------------------------------------------------------
_1D;   ORA $nnnn,X
;----------------------------------------------------------------------------
	doAIX
	opORA
	fetch 5
;----------------------------------------------------------------------------
_1E;   ASL $nnnn,X
;----------------------------------------------------------------------------
	doAIX
	opASL
	fetch_c 7
;----------------------------------------------------------------------------
_1F;   BBR1 $nn,*
;----------------------------------------------------------------------------
	opBBR 1
;----------------------------------------------------------------------------
_20;   JSR $nnnn
;----------------------------------------------------------------------------
	ldrb r2,[pce_pc],#1
	ldr r1,lastbank
	sub r0,pce_pc,r1
	ldrb r1,[pce_pc]
	orr pce_pc,r2,r1,lsl#8
	push16
	encodePC
	fetch 7
;----------------------------------------------------------------------------
_21;   AND ($nn,X)
;----------------------------------------------------------------------------
	doIIX
	opAND
	fetch 7
;----------------------------------------------------------------------------
_22;   SAX swap A & X
;----------------------------------------------------------------------------
	opSWAP pce_a,pce_x
	fetch 3
;----------------------------------------------------------------------------
;_23;   ST2 #$nn store immediate value at VDC, [moved to vdc.s]
;----------------------------------------------------------------------------
;	readmemimm
;	adr lr,%F0
;	ldr pc,vdcRegPtrH_		;what function
;0
;	fetch 4
;----------------------------------------------------------------------------
_24;   BIT $nn
;----------------------------------------------------------------------------
	doZ
	opBIT
	fetch 4
;----------------------------------------------------------------------------
_25;   AND $nn
;----------------------------------------------------------------------------
	doZ
	opAND
	fetch 4
;----------------------------------------------------------------------------
_26;   ROL $nn
;----------------------------------------------------------------------------
	doZ
	opROL
	fetch 6
;----------------------------------------------------------------------------
_27;   RMB2
;----------------------------------------------------------------------------
	opRMB 2
;----------------------------------------------------------------------------
_28;   PLP
;----------------------------------------------------------------------------
	pop8 r0
	decodePF
;	sub cycles,cycles,#4*3*CYCLE
;	b checkirqdisable		;Fixes? Breaks "Maniac Pro wrestling"
	fetch 4
;----------------------------------------------------------------------------
_29;   AND #$nn
;----------------------------------------------------------------------------
	doIMM
	opAND
	fetch 2
;----------------------------------------------------------------------------
_2A;   ROL
;----------------------------------------------------------------------------
	movs cycles,cycles,lsr#1	;get C
	orrcs pce_a,pce_a,#0x00800000
	adds pce_a,pce_a,pce_a
	mov pce_nz,pce_a,asr#24		;NZ
	adc cycles,cycles,cycles	;Set C
	fetch 2
;----------------------------------------------------------------------------
_2C;   BIT $nnnn
;----------------------------------------------------------------------------
	doABS
	opBIT
	fetch 5
;----------------------------------------------------------------------------
_2D;   AND $nnnn
;----------------------------------------------------------------------------
	doABS
	opAND
	fetch 5
;----------------------------------------------------------------------------
_2E;   ROL $nnnn
;----------------------------------------------------------------------------
	doABS
	opROL
	fetch 7
;----------------------------------------------------------------------------
_2F;   BBR2 $nn,*
;----------------------------------------------------------------------------
	opBBR 2
;----------------------------------------------------------------------------
_30;   BMI
;----------------------------------------------------------------------------
	tst pce_nz,#0x80000000
	beq nobranch
	ldrsb r0,[pce_pc],#1
	add pce_pc,pce_pc,r0
	fetch 4
;----------------------------------------------------------------------------
_30y;   BMI
;----------------------------------------------------------------------------
	tst pce_nz,#0x80000000
	beq nobranch
	ldrsb r0,[pce_pc],#1
	add pce_pc,pce_pc,r0
	cmp r0,#-7						;speed hack Aoi Blue Blink
	andcs cycles,cycles,#CYC_MASK	;Save CPU bits
	fetch 4
;----------------------------------------------------------------------------
_31;   AND ($nn),Y
;----------------------------------------------------------------------------
	doIIY
	opAND
	fetch 7
;----------------------------------------------------------------------------
_32;   AND ($nn)
;----------------------------------------------------------------------------
	doZPI
	opAND
	fetch 7
;----------------------------------------------------------------------------
_34;   BIT $nn,X
;----------------------------------------------------------------------------
	doZIXf
	opBIT
	fetch 4
;----------------------------------------------------------------------------
_35;   AND $nn,X
;----------------------------------------------------------------------------
	doZIXf
	opAND
	fetch 4
;----------------------------------------------------------------------------
_36;   ROL $nn,X
;----------------------------------------------------------------------------
	doZIXf
	opROL
	fetch 6
;----------------------------------------------------------------------------
_37;   RMB3
;----------------------------------------------------------------------------
	opRMB 3
;----------------------------------------------------------------------------
_38;   SEC
;----------------------------------------------------------------------------
	orr cycles,cycles,#CYC_C
	fetch 2
;----------------------------------------------------------------------------
_39;   AND $nnnn,Y
;----------------------------------------------------------------------------
	doAIY
	opAND
	fetch 5
;----------------------------------------------------------------------------
_3A;   DEA
;----------------------------------------------------------------------------
	sub pce_a,pce_a,#0x01000000
	mov pce_nz,pce_a,asr#24		;NZ
	fetch 2
;----------------------------------------------------------------------------
_3C;   BIT $nnnn,X
;----------------------------------------------------------------------------
	doAIX
	opBIT
	fetch 5
;----------------------------------------------------------------------------
_3D;   AND $nnnn,X
;----------------------------------------------------------------------------
	doAIX
	opAND
	fetch 5
;----------------------------------------------------------------------------
_3E;   ROL $nnnn,X
;----------------------------------------------------------------------------
	doAIX
	opROL
	fetch 7
;----------------------------------------------------------------------------
_3F;   BBR3 $nn,*
;----------------------------------------------------------------------------
	opBBR 3
;----------------------------------------------------------------------------
_40;   RTI
;----------------------------------------------------------------------------
	pop8 r0		;pop h6280 flags and decode
	decodePF
	pop16		;pop the return address
	encodePC
	sub cycles,cycles,#7*3*CYCLE
	b checkirqdisable		;Fixes Neutopia II (J), Sinistron & Talespin.
;	fetch 7
;----------------------------------------------------------------------------
_41;   EOR ($nn,X)
;----------------------------------------------------------------------------
	doIIX
	opEOR
	fetch 7
;----------------------------------------------------------------------------
_42;   SAY Swap A & Y
;----------------------------------------------------------------------------
	opSWAP pce_a,pce_y
	fetch 3
;----------------------------------------------------------------------------
;_43;   TMA #$nn 	Read from Memory mapper
;----------------------------------------------------------------------------
;	in cart.s
;----------------------------------------------------------------------------
_44;   BSR *
;----------------------------------------------------------------------------
	ldr r1,lastbank
	sub r0,pce_pc,r1
	push16
	ldrsb r0,[pce_pc],#1
	add pce_pc,pce_pc,r0
	fetch 8
;----------------------------------------------------------------------------
_45;   EOR $nn
;----------------------------------------------------------------------------
	doZ
	opEOR
	fetch 4
;----------------------------------------------------------------------------
_46;   LSR $nn
;----------------------------------------------------------------------------
	doZ
	opLSR
	fetch_c 6
;----------------------------------------------------------------------------
_47;   RMB4
;----------------------------------------------------------------------------
	opRMB 4
;----------------------------------------------------------------------------
_48;   PHA
;----------------------------------------------------------------------------
	mov r0,pce_a,lsr#24
	push8 r0
	fetch 3
;----------------------------------------------------------------------------
_49;   EOR #$nn
;----------------------------------------------------------------------------
	doIMM
	opEOR
	fetch 2
;----------------------------------------------------------------------------
_4A;   LSR
;----------------------------------------------------------------------------
	movs pce_nz,pce_a,lsr#25	;Z, N never set.
	mov pce_a,pce_nz,lsl#24		;result without garbage
	orr cycles,cycles,#CYC_C	;Prepare C
	fetch_c 2
;----------------------------------------------------------------------------
_4C;   JMP $nnnn
;----------------------------------------------------------------------------
	ldrb r0,[pce_pc],#1
	ldrb r1,[pce_pc]
	orr pce_pc,r0,r1,lsl#8
	encodePC
	fetch 4
;----------------------------------------------------------------------------
_4Cx;   JMP $nnnn
;----------------------------------------------------------------------------
	ldr r2,lastbank
	ldrb r0,[pce_pc],#1
	ldrb r1,[pce_pc],#1
	sub r2,pce_pc,r2
	orr pce_pc,r0,r1,lsl#8
	sub r2,pce_pc,r2
	cmp r2,#-8						;"Circus Lido" wants -9
	andcs cycles,cycles,#CYC_MASK	;Save CPU bits

	encodePC
	fetch 4
;----------------------------------------------------------------------------
_4D;   EOR $nnnn
;----------------------------------------------------------------------------
	doABS
	opEOR
	fetch 5
;----------------------------------------------------------------------------
_4E;   LSR $nnnn
;----------------------------------------------------------------------------
	doABS
	opLSR
	fetch_c 7
;----------------------------------------------------------------------------
_4F;   BBR4 $nn,*
;----------------------------------------------------------------------------
	opBBR 4
;----------------------------------------------------------------------------
_50;   BVC *
;----------------------------------------------------------------------------
	tst cycles,#CYC_V
	bne nobranch
	ldrsb r0,[pce_pc],#1
	add pce_pc,pce_pc,r0
	fetch 4
;----------------------------------------------------------------------------
_51;   EOR ($nn),Y
;----------------------------------------------------------------------------
	doIIY
	opEOR
	fetch 7
;----------------------------------------------------------------------------
_52;   EOR ($nn)
;----------------------------------------------------------------------------
	doZPI
	opEOR
	fetch 7
;----------------------------------------------------------------------------
;_53;   TAM #$nn 	Write to Memory mapper
;----------------------------------------------------------------------------
;	in cart.s
;----------------------------------------------------------------------------
_54;   CSL Change Speed Low
;----------------------------------------------------------------------------
	ldr r0,LowCycles		;(113.666)*3
	str r0,cyclesperscanline
	fetch 3
LowCycles
 DCD 341*CYCLE
;----------------------------------------------------------------------------
_55;   EOR $nn,X
;----------------------------------------------------------------------------
	doZIXf
	opEOR
	fetch 4
;----------------------------------------------------------------------------
_56;   LSR $nn,X
;----------------------------------------------------------------------------
	doZIXf
	opLSR
	fetch_c 6
;----------------------------------------------------------------------------
_57;   RMB5
;----------------------------------------------------------------------------
	opRMB 5
;----------------------------------------------------------------------------
_58;   CLI
;----------------------------------------------------------------------------
	bic cycles,cycles,#CYC_I
;	sub cycles,cycles,#2*3*CYCLE
;	b checkirqs			;Fixes "Outrun (J)",

	ldr r0,CliFixAdr		;Check IRQ lines after next instructions
	str r0,nexttimeout
	sub cycles,cycles,#2*3*CYCLE
	str cycles,oldcycles	;save old cycles so we can use them later on.
	clearcycles				;clear cycles, save cpu bits

	fetch 0
CliFixAdr
 DCD CLI_fix
;----------------------------------------------------------------------------
_58x;   CLI, patch for "Maniac Pro Wrestling (J)"
;----------------------------------------------------------------------------
	bic cycles,cycles,#CYC_I
	fetch 2
;----------------------------------------------------------------------------
_59;   EOR $nnnn,Y
;----------------------------------------------------------------------------
	doAIY
	opEOR
	fetch 5
;----------------------------------------------------------------------------
_5A;   PHY
;----------------------------------------------------------------------------
	mov r0,pce_y,lsr#24
	push8 r0
	fetch 3
;----------------------------------------------------------------------------
_5D;   EOR $nnnn,X
;----------------------------------------------------------------------------
	doAIX
	opEOR
	fetch 5
;----------------------------------------------------------------------------
_5E;   LSR $nnnn,X
;----------------------------------------------------------------------------
	doAIX
	opLSR
	fetch_c 7
;----------------------------------------------------------------------------
_5F;   BBR5 $nn,*
;----------------------------------------------------------------------------
	opBBRx 5	;Takeda Shingen
;----------------------------------------------------------------------------
_60;   RTS
;----------------------------------------------------------------------------
	pop16
	add pce_pc,pce_pc,#1
	encodePC
	fetch 7
;----------------------------------------------------------------------------
_61;   ADC ($nn,X)
;----------------------------------------------------------------------------
	doIIX
	opADC
	fetch_c 7
;----------------------------------------------------------------------------
_62;   CLA
;----------------------------------------------------------------------------
	mov pce_a,#0
	fetch 2
;----------------------------------------------------------------------------
_64;   STZ $nn
;----------------------------------------------------------------------------
	doZ
	opSTZ
	fetch 4
;----------------------------------------------------------------------------
_65;   ADC $nn
;----------------------------------------------------------------------------
	doZ
	opADC
	fetch_c 4
;----------------------------------------------------------------------------
_66;   ROR $nn
;----------------------------------------------------------------------------
	doZ
	opROR
	fetch 6
;----------------------------------------------------------------------------
_67;   RMB6
;----------------------------------------------------------------------------
	opRMB 6
;----------------------------------------------------------------------------
_68;   PLA
;----------------------------------------------------------------------------
	pop8 pce_nz
	mov pce_a,pce_nz,lsl#24
	fetch 4
;----------------------------------------------------------------------------
_69;   ADC #$nn
;----------------------------------------------------------------------------
	doIMM
	opADC
	fetch_c 2
;----------------------------------------------------------------------------
_6A;   ROR
;----------------------------------------------------------------------------
	movs cycles,cycles,lsr#1	;get C
	mov pce_a,pce_a,rrx
	movs pce_nz,pce_a,asr#24	;NZ
	and pce_a,pce_a,#0xff000000
	adc cycles,cycles,cycles	;Set C
	fetch 2
;----------------------------------------------------------------------------
_6C;   JMP ($nnnn)
;----------------------------------------------------------------------------
	doABS
	adr r1,memmap_tbl
	and r2,addy,#0xE000
	ldr r1,[r1,r2,lsr#11]
	ldrb pce_pc,[r1,addy]!
	ldrb r0,[r1,#1]
	orr pce_pc,pce_pc,r0,lsl#8
	encodePC
	fetch 7
;----------------------------------------------------------------------------
_6D;   ADC $nnnn
;----------------------------------------------------------------------------
	doABS
	opADC
	fetch_c 5
;----------------------------------------------------------------------------
_6E;   ROR $nnnn
;----------------------------------------------------------------------------
	doABS
	opROR
	fetch 7
;----------------------------------------------------------------------------
_6F;   BBR6 $nn,*
;----------------------------------------------------------------------------
	opBBRx 6
;----------------------------------------------------------------------------
_70;   BVS *
;----------------------------------------------------------------------------
	tst cycles,#CYC_V
	beq nobranch
	ldrsb r0,[pce_pc],#1
	add pce_pc,pce_pc,r0
	fetch 4
;----------------------------------------------------------------------------
_71;   ADC ($nn),Y
;----------------------------------------------------------------------------
	doIIY
	opADC
	fetch_c 7
;----------------------------------------------------------------------------
_72;   ADC ($nn)
;----------------------------------------------------------------------------
	doZPI
	opADC
	fetch_c 7
;----------------------------------------------------------------------------
_73;   TII $nnnn,$nnnn,#$nnnn	[Transfer Inc Inc]
;----------------------------------------------------------------------------
	doTII
;----------------------------------------------------------------------------
_74;   STZ $nn,X
;----------------------------------------------------------------------------
	doZIXf
	opSTZ
	fetch 4
;----------------------------------------------------------------------------
_75;   ADC $nn,X
;----------------------------------------------------------------------------
	doZIXf
	opADC
	fetch_c 4
;----------------------------------------------------------------------------
_76;   ROR $nn,X
;----------------------------------------------------------------------------
	doZIXf
	opROR
	fetch 6
;----------------------------------------------------------------------------
_77;   RMB7 $nn
;----------------------------------------------------------------------------
	opRMB 7
;----------------------------------------------------------------------------
_78;   SEI
;----------------------------------------------------------------------------
	orr cycles,cycles,#CYC_I
	fetch 2
;----------------------------------------------------------------------------
_79;   ADC $nnnn,Y
;----------------------------------------------------------------------------
	doAIY
	opADC
	fetch_c 5
;----------------------------------------------------------------------------
_7A;   PLY
;----------------------------------------------------------------------------
	pop8 pce_nz
	mov pce_y,pce_nz,lsl#24
	fetch 4
;----------------------------------------------------------------------------
_7C;   JMP ($nnnn,X)
;----------------------------------------------------------------------------
	doAIX
	adr r1,memmap_tbl
	and r2,addy,#0xE000
	ldr r1,[r1,r2,lsr#11]
	ldrb pce_pc,[r1,addy]!
	ldrb r0,[r1,#1]
	orr pce_pc,pce_pc,r0,lsl#8
	encodePC
	fetch 7
;----------------------------------------------------------------------------
_7D;   ADC $nnnn,X
;----------------------------------------------------------------------------
	doAIX
	opADC
	fetch_c 5
;----------------------------------------------------------------------------
_7E;   ROR $nnnn,X
;----------------------------------------------------------------------------
	doAIX
	opROR
	fetch 7
;----------------------------------------------------------------------------
_7F;   BBR7 $nn,*
;----------------------------------------------------------------------------
	opBBRx 7						;speed hack version for Ninja Spirit.
;----------------------------------------------------------------------------
_80;   BRA branch always
;----------------------------------------------------------------------------
	ldrsb r0,[pce_pc],#1
	add pce_pc,pce_pc,r0
	fetch 4							;+1 if pageboundary crossed?
;----------------------------------------------------------------------------
_80y;   BRA branch always
;----------------------------------------------------------------------------
	ldrsb r0,[pce_pc],#1
	add pce_pc,pce_pc,r0
	cmp r0,#-5						;speed hack Darius, Toyshop Boys
	andcs cycles,cycles,#CYC_MASK	;Save CPU bits
	fetch 4
;----------------------------------------------------------------------------
_81;   STA ($nn,X)
;----------------------------------------------------------------------------
	doIIX
	opSTORE pce_a
	fetch 7
;----------------------------------------------------------------------------
_82;   CLX
;----------------------------------------------------------------------------
	mov pce_x,#0
	fetch 2
;----------------------------------------------------------------------------
_83;   TST #$nn,$nn
;----------------------------------------------------------------------------
	ldrb pce_nz,[pce_pc],#1
	doZ
	opTST
	fetch 7
;----------------------------------------------------------------------------
_84;   STY $nn
;----------------------------------------------------------------------------
	doZ
	opSTORE pce_y
	fetch 4
;----------------------------------------------------------------------------
_85;   STA $nn
;----------------------------------------------------------------------------
	doZ
	opSTORE pce_a
	fetch 4
;----------------------------------------------------------------------------
_86;   STX $nn
;----------------------------------------------------------------------------
	doZ
	opSTORE pce_x
	fetch 4
;----------------------------------------------------------------------------
_87;   SMB0 $nn
;----------------------------------------------------------------------------
	opSMB 0
;----------------------------------------------------------------------------
_88;   DEY
;----------------------------------------------------------------------------
	sub pce_y,pce_y,#0x01000000
	mov pce_nz,pce_y,asr#24
	fetch 2
;----------------------------------------------------------------------------
_89;   BIT #$nn
;----------------------------------------------------------------------------
	doIMM
	opBIT
	fetch 2
;----------------------------------------------------------------------------
_8A;   TXA
;----------------------------------------------------------------------------
	mov pce_a,pce_x
	mov pce_nz,pce_x,asr#24
	fetch 2
;----------------------------------------------------------------------------
_8C;   STY $nnnn
;----------------------------------------------------------------------------
	doABS
	opSTORE pce_y
	fetch 5
;----------------------------------------------------------------------------
_8D;   STA $nnnn
;----------------------------------------------------------------------------
	doABS
	opSTORE pce_a
	fetch 5
;----------------------------------------------------------------------------
_8E;   STX $nnnn
;----------------------------------------------------------------------------
	doABS
	opSTORE pce_x
	fetch 5
;----------------------------------------------------------------------------
_8F;   BBS0 $nn,*
;----------------------------------------------------------------------------
	opBBSx 0
;----------------------------------------------------------------------------
_90;   BCC *
;----------------------------------------------------------------------------
	tst cycles,#CYC_C		;Test Carry
	bne nobranch
	ldrsb r0,[pce_pc],#1
	add pce_pc,pce_pc,r0
	fetch 4
;----------------------------------------------------------------------------
_90y;   BCC *
;----------------------------------------------------------------------------
	tst cycles,#CYC_C		;Test Carry
	bne nobranch
	ldrsb r0,[pce_pc],#1
	add pce_pc,pce_pc,r0
	cmp r0,#-8						;speed hack 2 Ninja Gaiden, Super Wolleyball
	andcs cycles,cycles,#CYC_MASK	;Save CPU bits
	fetch 4
;----------------------------------------------------------------------------
_91;   STA ($nn),Y
;----------------------------------------------------------------------------
	doIIY
	opSTORE pce_a
	fetch 7
;----------------------------------------------------------------------------
_92;   STA ($nn)
;----------------------------------------------------------------------------
	doZPI
	opSTORE pce_a
	fetch 7
;----------------------------------------------------------------------------
_93;   TST #$nn,$nnnn
;----------------------------------------------------------------------------
	ldrb pce_nz,[pce_pc],#1
	doABS
	opTST
	fetch 8
;----------------------------------------------------------------------------
_94;   STY $nn,X
;----------------------------------------------------------------------------
	doZIXf
	opSTORE pce_y
	fetch 4
;----------------------------------------------------------------------------
_95;   STA $nn,X
;----------------------------------------------------------------------------
	doZIXf
	opSTORE pce_a
	fetch 4
;----------------------------------------------------------------------------
_96;   STX $nn,Y
;----------------------------------------------------------------------------
	doZIYf
	opSTORE pce_x
	fetch 4
;----------------------------------------------------------------------------
_97;   SMB1 $nn
;----------------------------------------------------------------------------
	opSMB 1
;----------------------------------------------------------------------------
_98;   TYA
;----------------------------------------------------------------------------
	mov pce_a,pce_y
	mov pce_nz,pce_y,asr#24
	fetch 2
;----------------------------------------------------------------------------
_99;   STA $nnnn,Y
;----------------------------------------------------------------------------
	doAIY
	opSTORE pce_a
	fetch 5
;----------------------------------------------------------------------------
_9A;   TXS
;----------------------------------------------------------------------------
	mov r0,pce_x,lsr#24
	strb r0,pce_s
	fetch 2
;----------------------------------------------------------------------------
_9C;   STZ $nnnn
;----------------------------------------------------------------------------
	doABS
	opSTZ
	fetch 5
;----------------------------------------------------------------------------
_9D;   STA $nnnn,X
;----------------------------------------------------------------------------
	doAIX
	opSTORE pce_a
	fetch 5
;----------------------------------------------------------------------------
_9E;   STZ $nnnn,X
;----------------------------------------------------------------------------
	doAIX
	opSTZ
	fetch 5
;----------------------------------------------------------------------------
_9F;   BBS1 $nn,*
;----------------------------------------------------------------------------
	opBBS 1
;----------------------------------------------------------------------------
_A0;   LDY #$nn
;----------------------------------------------------------------------------
	doIMM
	opLOAD pce_y
	fetch 2
;----------------------------------------------------------------------------
_A1;   LDA ($nn,X)
;----------------------------------------------------------------------------
	doIIX
	opLOAD pce_a
	fetch 7
;----------------------------------------------------------------------------
_A2;   LDX #$nn
;----------------------------------------------------------------------------
	doIMM
	opLOAD pce_x
	fetch 2
;----------------------------------------------------------------------------
_A3;   TST #$nn,$nn,X
;----------------------------------------------------------------------------
	ldrb pce_nz,[pce_pc],#1
	doZIX
	opTST
	fetch 7
;----------------------------------------------------------------------------
_A4;   LDY $nn
;----------------------------------------------------------------------------
	doZ
	opLOAD pce_y
	fetch 4
;----------------------------------------------------------------------------
_A5;   LDA $nn
;----------------------------------------------------------------------------
	doZ
	opLOAD pce_a
	fetch 4
;----------------------------------------------------------------------------
_A6;   LDX $nn
;----------------------------------------------------------------------------
	doZ
	opLOAD pce_x
	fetch 4
;----------------------------------------------------------------------------
_A7;   SMB2 $nn
;----------------------------------------------------------------------------
	opSMB 2
;----------------------------------------------------------------------------
_A8;   TAY
;----------------------------------------------------------------------------
	mov pce_y,pce_a
	mov pce_nz,pce_y,asr#24
	fetch 2
;----------------------------------------------------------------------------
_A9;   LDA #$nn
;----------------------------------------------------------------------------
	doIMM
	opLOAD pce_a
	fetch 2
;----------------------------------------------------------------------------
_AA;   TAX
;----------------------------------------------------------------------------
	mov pce_x,pce_a
	mov pce_nz,pce_x,asr#24
	fetch 2
;----------------------------------------------------------------------------
_AC;   LDY $nnnn
;----------------------------------------------------------------------------
	doABS
	opLOAD pce_y
	fetch 5
;----------------------------------------------------------------------------
_AD;   LDA $nnnn
;----------------------------------------------------------------------------
	doABS
	opLOAD pce_a
	fetch 5
;----------------------------------------------------------------------------
_AE;   LDX $nnnn
;----------------------------------------------------------------------------
	doABS
	opLOAD pce_x
	fetch 5
;----------------------------------------------------------------------------
_AF;   BBS2 $nn,*
;----------------------------------------------------------------------------
	opBBS 2
;----------------------------------------------------------------------------
_B0;   BCS *
;----------------------------------------------------------------------------
	tst cycles,#CYC_C		;Test Carry
	beq nobranch
	ldrsb r0,[pce_pc],#1
	add pce_pc,pce_pc,r0
	fetch 4
;----------------------------------------------------------------------------
_B0y;   BCS *
;----------------------------------------------------------------------------
	tst cycles,#CYC_C		;Test Carry
	beq nobranch
	ldrsb r0,[pce_pc],#1
	add pce_pc,pce_pc,r0
	cmp r0,#-8						;speed hack "Andre Panza Kick Boxing" & "Power Sports"
	andcs cycles,cycles,#CYC_MASK	;Save CPU bits
	fetch 4
;----------------------------------------------------------------------------
_B1;   LDA ($nn),Y
;----------------------------------------------------------------------------
	doIIY
	opLOAD pce_a
	fetch 7
;----------------------------------------------------------------------------
_B2;   LDA ($nn)
;----------------------------------------------------------------------------
	doZPI
	opLOAD pce_a
	fetch 7
;----------------------------------------------------------------------------
_B3;   TST #$nn,$nnnn,X
;----------------------------------------------------------------------------
	ldrb pce_nz,[pce_pc],#1
	doAIX
	opTST
	fetch 8
;----------------------------------------------------------------------------
_B4;   LDY $nn,X
;----------------------------------------------------------------------------
	doZIX
	opLOAD pce_y
	fetch 4
;----------------------------------------------------------------------------
_B5;   LDA $nn,X
;----------------------------------------------------------------------------
	doZIX
	opLOAD pce_a
	fetch 4
;----------------------------------------------------------------------------
_B6;   LDX $nn,Y
;----------------------------------------------------------------------------
	doZIY
	opLOAD pce_x
	fetch 4
;----------------------------------------------------------------------------
_B7;   SMB3 $nn
;----------------------------------------------------------------------------
	opSMB 3
;----------------------------------------------------------------------------
_B8;   CLV
;----------------------------------------------------------------------------
	bic cycles,cycles,#CYC_V
	fetch 2
;----------------------------------------------------------------------------
_B9;   LDA $nnnn,Y
;----------------------------------------------------------------------------
	doAIY
	opLOAD pce_a
	fetch 5
;----------------------------------------------------------------------------
_BA;   TSX
;----------------------------------------------------------------------------
	ldrb pce_x,pce_s
	mov pce_x,pce_x,lsl#24
	mov pce_nz,pce_x,asr#24
	fetch 2
;----------------------------------------------------------------------------
_BC;   LDY $nnnn,X
;----------------------------------------------------------------------------
	doAIX
	opLOAD pce_y
	fetch 5
;----------------------------------------------------------------------------
_BD;   LDA $nnnn,X
;----------------------------------------------------------------------------
	doAIX
	opLOAD pce_a
	fetch 5
;----------------------------------------------------------------------------
_BE;   LDX $nnnn,Y
;----------------------------------------------------------------------------
	doAIY
	opLOAD pce_x
	fetch 5
;----------------------------------------------------------------------------
_BF;   BBS3 $nn,*
;----------------------------------------------------------------------------
	opBBS 3
;----------------------------------------------------------------------------
_C0;   CPY #$nn
;----------------------------------------------------------------------------
	doIMM
	opCOMP pce_y
	fetch_c 2
;----------------------------------------------------------------------------
_C1;   CMP ($nn,X)
;----------------------------------------------------------------------------
	doIIX
	opCOMP pce_a
	fetch_c 7
;----------------------------------------------------------------------------
_C2;   CLY
;----------------------------------------------------------------------------
	mov pce_y,#0
	fetch 2
;----------------------------------------------------------------------------
_C3;   TDD $nnnn,$nnnn,#$nnnn	[Transfer Dec Dec]
;----------------------------------------------------------------------------
	doTDD
;----------------------------------------------------------------------------
_C4;   CPY $nn
;----------------------------------------------------------------------------
	doZ
	opCOMP pce_y
	fetch_c 4
;----------------------------------------------------------------------------
_C5;   CMP $nn
;----------------------------------------------------------------------------
	doZ
	opCOMP pce_a
	fetch_c 4
;----------------------------------------------------------------------------
_C6;   DEC $nn
;----------------------------------------------------------------------------
	doZ
	opDEC
	fetch 6
;----------------------------------------------------------------------------
_C7;   SMB4 $nn
;----------------------------------------------------------------------------
	opSMB 4
;----------------------------------------------------------------------------
_C8;   INY
;----------------------------------------------------------------------------
	add pce_y,pce_y,#0x01000000
	mov pce_nz,pce_y,asr#24
	fetch 2
;----------------------------------------------------------------------------
_C9;   CMP #$nn
;----------------------------------------------------------------------------
	doIMM
	opCOMP pce_a
	fetch_c 2
;----------------------------------------------------------------------------
_CA;   DEX
;----------------------------------------------------------------------------
	sub pce_x,pce_x,#0x01000000
	mov pce_nz,pce_x,asr#24
	fetch 2
;----------------------------------------------------------------------------
_CC;   CPY $nnnn
;----------------------------------------------------------------------------
	doABS
	opCOMP pce_y
	fetch_c 5
;----------------------------------------------------------------------------
_CD;   CMP $nnnn
;----------------------------------------------------------------------------
	doABS
	opCOMP pce_a
	fetch_c 5
;----------------------------------------------------------------------------
_CE;   DEC $nnnn
;----------------------------------------------------------------------------
	doABS
	opDEC
	fetch 7
;----------------------------------------------------------------------------
_CF;   BBS4 $nn,*
;----------------------------------------------------------------------------
	opBBS 4
;----------------------------------------------------------------------------
_D0;   BNE *
;----------------------------------------------------------------------------
	tst pce_nz,#0xff
	beq nobranch
	ldrsb r0,[pce_pc],#1
	add pce_pc,pce_pc,r0
	fetch 4
;----------------------------------------------------------------------------
_D0y;   BNE *
;----------------------------------------------------------------------------
	tst pce_nz,#0xff
	beq nobranch
	ldrsb r0,[pce_pc],#1
	add pce_pc,pce_pc,r0
_D0z	cmp r0,#-7					;speed hack 2 Xeviuos -7
	andcs cycles,cycles,#CYC_MASK	;Save CPU bits
	fetch 4
;----------------------------------------------------------------------------
_D1;   CMP ($nn),Y
;----------------------------------------------------------------------------
	doIIY
	opCOMP pce_a
	fetch_c 7
;----------------------------------------------------------------------------
_D2;   CMP ($nn)
;----------------------------------------------------------------------------
	doZPI
	opCOMP pce_a
	fetch_c 7
;----------------------------------------------------------------------------
_D3;   TIN $nnnn,$nnnn,#$nnnn	[Transfer Inc None]
;----------------------------------------------------------------------------
	doTIN
;----------------------------------------------------------------------------
_D4;   CSH Change Speed High
;----------------------------------------------------------------------------
	ldr r0,highcycles		;(455)*3
	str r0,cyclesperscanline
	fetch 3
;----------------------------------------------------------------------------
_D5;   CMP $nn,X
;----------------------------------------------------------------------------
	doZIXf
	opCOMP pce_a
	fetch_c 4
;----------------------------------------------------------------------------
_D6;   DEC $nn,X
;----------------------------------------------------------------------------
	doZIXf
	opDEC
	fetch 6
;----------------------------------------------------------------------------
_D7;   SMB5 $nn
;----------------------------------------------------------------------------
	opSMB 5
;----------------------------------------------------------------------------
_D8;   CLD
;----------------------------------------------------------------------------
	bic cycles,cycles,#D
	fetch 2
;----------------------------------------------------------------------------
_D9;   CMP $nnnn,Y
;----------------------------------------------------------------------------
	doAIY
	opCOMP pce_a
	fetch_c 5
;----------------------------------------------------------------------------
_DA;   PHX
;----------------------------------------------------------------------------
	mov r0,pce_x,lsr#24
	push8 r0
	fetch 3
;----------------------------------------------------------------------------
_DD;   CMP $nnnn,X
;----------------------------------------------------------------------------
	doAIX
	opCOMP pce_a
	fetch_c 5
;----------------------------------------------------------------------------
_DE;   DEC $nnnn,X
;----------------------------------------------------------------------------
	doAIX
	opDEC
	fetch 7
;----------------------------------------------------------------------------
_DF;   BBS5 $nn,*
;----------------------------------------------------------------------------
	opBBS 5
;----------------------------------------------------------------------------
_E0;   CPX #$nn
;----------------------------------------------------------------------------
	doIMM
	opCOMP pce_x
	fetch_c 2
;----------------------------------------------------------------------------
_E1;   SBC ($nn,X)
;----------------------------------------------------------------------------
	doIIX
	opSBC
	fetch_c 7
;----------------------------------------------------------------------------
_E3;   TIA $nnnn,$nnnn,#$nnnn	[Transfer Inc Alt]
;----------------------------------------------------------------------------
	doTIA
;----------------------------------------------------------------------------
_E4;   CPX $nn
;----------------------------------------------------------------------------
	doZ
	opCOMP pce_x
	fetch_c 4
;----------------------------------------------------------------------------
_E5;   SBC $nn
;----------------------------------------------------------------------------
	doZ
	opSBC
	fetch_c 4
;----------------------------------------------------------------------------
_E6;   INC $nn
;----------------------------------------------------------------------------
	doZ
	opINC
	fetch 6
;----------------------------------------------------------------------------
_E7;   SMB6 $nn
;----------------------------------------------------------------------------
	opSMB 6
;----------------------------------------------------------------------------
_E8;   INX
;----------------------------------------------------------------------------
	add pce_x,pce_x,#0x01000000
	mov pce_nz,pce_x,asr#24
	fetch 2
;----------------------------------------------------------------------------
_E9;   SBC #$nn
;----------------------------------------------------------------------------
	doIMM
	opSBC
	fetch_c 2
;----------------------------------------------------------------------------
_EA;   NOP
;----------------------------------------------------------------------------
	fetch 2
;----------------------------------------------------------------------------
_EC;   CPX $nnnn
;----------------------------------------------------------------------------
	doABS
	opCOMP pce_x
	fetch_c 5
;----------------------------------------------------------------------------
_ED;   SBC $nnnn
;----------------------------------------------------------------------------
	doABS
	opSBC
	fetch_c 5
;----------------------------------------------------------------------------
_EE;   INC $nnnn
;----------------------------------------------------------------------------
	doABS
	opINC
	fetch 7
;----------------------------------------------------------------------------
_EF;   BBS6 $nn,*
;----------------------------------------------------------------------------
	opBBS 6
;----------------------------------------------------------------------------
_F0;   BEQ *
;----------------------------------------------------------------------------
	tst pce_nz,#0xff
	bne nobranch
	ldrsb r0,[pce_pc],#1
	add pce_pc,pce_pc,r0
	fetch 4
;----------------------------------------------------------------------------
_F0y;   BEQ *
;----------------------------------------------------------------------------
	tst pce_nz,#0xff
	bne nobranch
	ldrsb r0,[pce_pc],#1
	add pce_pc,pce_pc,r0
_F0z	cmp r0,#-7					;speed hack 2 (-7)
	andcs cycles,cycles,#CYC_MASK	;Save CPU bits
	fetch 4
;----------------------------------------------------------------------------
_F1;   SBC ($nn),Y
;----------------------------------------------------------------------------
	doIIY
	opSBC
	fetch_c 7
;----------------------------------------------------------------------------
_F2;   SBC ($nn)
;----------------------------------------------------------------------------
	doZPI
	opSBC
	fetch_c 7
;----------------------------------------------------------------------------
_F3;   TAI $nnnn,$nnnn,#$nnnn	[Transfer Alt Inc]
;----------------------------------------------------------------------------
	doTAI
;----------------------------------------------------------------------------
_F4;   SET set T
;----------------------------------------------------------------------------
	ldr r1,=op_t_table
	sub cycles,cycles,#2*3*CYCLE
	ldrb r0,[pce_pc],#1
	ldr pc,[r1,r0,lsl#2]
;----------------------------------------------------------------------------
_F5;   SBC $nn,X
;----------------------------------------------------------------------------
	doZIXf
	opSBC
	fetch_c 4
;----------------------------------------------------------------------------
_F6;   INC $nn,X
;----------------------------------------------------------------------------
	doZIXf
	opINC
	fetch 6
;----------------------------------------------------------------------------
_F7;   SMB7 $nn
;----------------------------------------------------------------------------
	opSMB 7
;----------------------------------------------------------------------------
_F8;   SED
;----------------------------------------------------------------------------
	orr cycles,cycles,#D
	fetch 2
;----------------------------------------------------------------------------
_F9;   SBC $nnnn,Y
;----------------------------------------------------------------------------
	doAIY
	opSBC
	fetch_c 5
;----------------------------------------------------------------------------
_FA;   PLX
;----------------------------------------------------------------------------
	pop8 pce_nz
	mov pce_x,pce_nz,lsl#24
	fetch 4
;---------------------------------------------------------------------------
_FD;   SBC $nnnn,X
;----------------------------------------------------------------------------
	doAIX
	opSBC
	fetch_c 5
;----------------------------------------------------------------------------
_FE;   INC $nnnn,X
;----------------------------------------------------------------------------
	doAIX
	opINC
	fetch 7
;----------------------------------------------------------------------------
_FF;   BBS7 $nn,*
;----------------------------------------------------------------------------
	opBBSx 7
;----------------------------------------------------------------------------
run	;r0=0 to return after frame
;----------------------------------------------------------------------------
	mov r1,#0
	strb r1,novblankwait

	str r0,dontstop
	tst r0,#1
	stmeqfd sp!,{pce_nz-pce_pc,globalptr,pce_zpage,lr}

	ldr globalptr,=|wram_globals0$$Base|
	ldr pce_zpage,=PCE_RAM
	b line0x
;----------------------------------------------------------------------------
;cycles ran out
;----------------------------------------------------------------------------
line0
	adrl r2,cpuregs
	stmia r2,{pce_nz-pce_pc}	;save h6280 state
waitformulti
	ldr r1,=REG_P1		;refresh input every frame
	ldrh r0,[r1]
		eor r0,r0,#0xff
		eor r0,r0,#0x300	;r0=button state (raw)
	ldr r1,AGBjoypad
	eor r1,r1,r0
	and r1,r1,r0		;r1=button state (0->1)
	str r0,AGBjoypad

	ldrb r3,emuflags+1
	cmp r3,#SCALED
	bhs %F0			;if unscaled
	ldr r3,windowtop+4
	ldr r2,vblscanlinegfx	;<240
	subs r2,r2,#160
	movmi r2,#0
	tst r0,#0x100			;R=scroll down
	addne r3,r3,#2
	cmp r3,r2
	movgt r3,r2
	tst r0,#0x200			;L=scroll up
	subnes r3,r3,#2
	movmi r3,#0
	str r3,windowtop+4
0
	ldrb r2,vdchdw
	mov r2,r2,lsl#3
	sub r2,r2,#232

	ldr r3,hcenter
	tst r0,#0x100			;R=scroll left
	addne r3,r3,#2
	cmp r3,r2
	movhi r3,r2
	tst r0,#0x200			;L=scroll right
	subnes r3,r3,#2
	movmi r3,#0
	str r3,hcenter

	ldr r2,dontstop
	cmp r2,#0
	ldmeqfd sp!,{pce_nz-pce_pc,globalptr,pce_zpage,lr}	;exit here if doing single frame:
	bxeq lr							;return to rommenu()

	;----anything from here til line0x won't get executed while rom menu is active---

	mov r2,#REG_BASE
	mov r3,#0x0110
	strh r3,[r2,#REG_BLDCNT]	;stop darkened screen,OBJ blend to BG0
	mov r3,#0x1000				;BG0=16, OBJ=0
	strh r3,[r2,#REG_BLDALPHA]	;Alpha values

	adr lr,line0x			;return here after doing L/R + SEL/START

	tst r1,#0x300			;if L or R was pressed
	tstne r0,#0x100
	tstne r0,#0x200			;and both L+R are held..
	ldrne r1,=ui
	bxne r1					;do menu

	ands r3,r0,#0x300		;if either L or R is pressed (not both)
	eornes r3,r3,#0x300
	bicne r0,r0,#0x0c		;hide sel,start from PCE
	str r0,PCEjoypad
	beq line0x				;skip ahead if neither or both are pressed

	tst r0,#0x200
	tstne r1,#4				;L+SEL for BG adjust
	ldrne r2,adjustblend
	addne r2,r2,#1
	strne r2,adjustblend

	tst r0,#0x200			;L?
	tstne r1,#8				;START?
	ldrb r2,novblankwait	;0=Normal, 1=No wait, 2=Slomo
	addne r2,r2,#1
	cmp r2,#3
	moveq r2,#0
	strb r2,novblankwait

	tst r0,#0x100			;R?
	tstne r1,#8				;START:

	tst r0,#0x100			;R?
	tstne r1,#4				;SELECT:
line0x
	ldrb r0,vdchdw			;pce screen width
	bl VdcHdr_L_W			;set border
	bl refreshPCEjoypads	;Z=1 if communication ok
	bne waitformulti		;waiting on other GBA..

	ldr r0,AGBjoypad
	ldr r2,fiveminutes		;sleep after 5/10/30 minutes of inactivity
	cmp r0,#0				;(left out of the loop so waiting on multi-link
	ldrne r2,sleeptime		;doesn't accelerate time)
	subs r2,r2,#1
	str r2,fiveminutes
	bleq suspend

	bl newframe				;display update
	bl updatesound
	bl updatecdrom			;update CD counters and stuff

 [ BUILD <> "DEBUG"
	ldrb r4,novblankwait
	teq r4,#1				;NoVSync?
	beq l03
l01
	mov r0,#0				;don't wait if not necessary
	mov r1,#1				;VBL wait
	swi 0x040000			; Turn of CPU until VBLIRQ if not too late allready.
	teq r4,#2				;Slomo?
	moveq r4,#0
	beq l01

l03
 ]
	ldr r0,fpsvalue
	add r0,r0,#1
	str r0,fpsvalue

	adrl r0,cpuregs
	ldmia r0,{pce_nz-pce_pc}	;restore h6280 state

	ldr r0,cyclesperscanline
	add cycles,cycles,r0
	adr r0,line1_to_VBL
	str r0,nexttimeout
	str r0,nexttimeout_


	mov r1,#0
	ldr pc,scanlinehook

line1_to_VBL ;------------------------
	ldr r0,cyclesperscanline
	add cycles,cycles,r0

	ldr r2,vblscanlinecpu
	ldr r1,scanline
	add r1,r1,#1
	str r1,scanline
	cmp r1,r2
	ldrmi pc,scanlinehook

	adr addy,lineVBL
	str addy,nexttimeout
	str addy,nexttimeout_
	ldr pc,scanlinehook
lineVBL ;------------------------
	ldr r0,cyclesperscanline
	sub r0,r0,#1024*CYCLE
	add cycles,cycles,r0
	ldr r0,frame
	add r0,r0,#1
	str r0,frame

	adr addy,VDC_Check
	str addy,nexttimeout
	str addy,nexttimeout_

;-------------------------------------------------
	bl endframe					;display update
;-------------------------------------------------
	ldr r1,scanline
	add r1,r1,#1
	str r1,scanline
	ldr pc,scanlinehook

VDC_Check
	ldrb r0,vdcctrl1
	tst r0,#0x08		;vbl IRQ?
	movne r2,#0x20
	strneb r2,vdcstat	;vbl irq

	add cycles,cycles,#7*3*CYCLE

	adr addy,VBL_Check
	str addy,nexttimeout
	str addy,nexttimeout_
	b checkirqdisable

VBL_Check
	add cycles,cycles,#1024*CYCLE
	sub cycles,cycles,#7*3*CYCLE

	ldrb r0,vdcctrl1
	tst r0,#0x08		;vbl IRQ?
	ldrneb r2,irqPending
	orrne r2,r2,#2
	strneb r2,irqPending

	adr addy,lineVBL_to_SPR
	str addy,nexttimeout
	str addy,nexttimeout_
	b checkirqdisable

lineVBL_to_SPR ;------------------------
	ldr r0,cyclesperscanline
	add cycles,cycles,r0

	ldr r2,vblscanlinecpu
	add r2,r2,#3
	ldr r1,scanline
	add r1,r1,#1
	str r1,scanline
	cmp r1,r2
	ldrmi pc,scanlinehook
;---------------------
;	ldrb r0,dosprdma
;	cmp r0,#0
;	ldrneb r0,dmacr
	ldrb r0,dmacr
	tst r0,#0x01		;spr IRQ?
;	ldrneb r2,vdcstat	;spr IRQ.
;	orrne r2,r2,#0x08
	movne r2,#0x08
	strneb r2,vdcstat	;spr IRQ.
	ldrneb r2,irqPending
	orrne r2,r2,#2
	strneb r2,irqPending

	adr addy,lineSPR_to_end
	str addy,nexttimeout
	str addy,nexttimeout_
	ldr pc,scanlinehook
lineSPR_to_end ;------------------------
	ldr r0,cyclesperscanline
	add cycles,cycles,r0

	ldr r2,lastscanline
	ldr r1,scanline
	add r1,r1,#1
	str r1,scanline
	cmp r1,r2
	adrpl addy,line0
	strpl addy,nexttimeout
	strpl addy,nexttimeout_

	ldrb r0,dmairq
	tst r0,#0x22		;VDC bit? DMA IRQ?
	ldreq pc,scanlinehook

	mov r2,#0
	strb r2,dmairq	;clear dmairq
	ldrb r2,vdcstat
	orr r2,r2,#0x10	;DMA IRQ.
	strb r2,vdcstat

	tst r0,#2			;DMA IRQ?

	ldrneb r2,irqPending
	orrne r2,r2,#2
	strneb r2,irqPending
	ldr pc,scanlinehook

;----------------------------------------------------------
irq_scanlinehook
;----------------------------------------------------------
	ldr r2,rasterCompareCPU
	cmp r1,r2					;r1 is scanline
	bne noRasterCmp

	ldrb r0,vdcctrl1
	ands r0,r0,#0x04
	beq noRasterCmp

	ldrb r0,vdcstat	
	orr r0,r0,#0x04
	strb r0,vdcstat				;raster compare irq
	ldrb r0,irqPending
	orr r0,r0,#2
	strb r0,irqPending
noRasterCmp
;--------------------------
	ldrb r0,timerEnable
	tst r0,#1
	beq noTimer
	ldr r1,timCycles
	ldr r2,highcycles			;cycles per scanline.
	subs r0,r1,r2,lsr#CYC_SHIFT	;no flags
	bpl noTirqYet
;- - - - - - - - - - - - - - - - -
; this is trouble
;- - - - - - - - - - - - - - - - -
	add cycles,cycles,r1,lsl#CYC_SHIFT		;give some extra cycles to cpu, save C,I,V & D bits.
	ldr r2,cyclesperscanline
	sub cycles,cycles,r2

	sub r2,r2,r1,lsl#CYC_SHIFT
	str r2,oldcycles			;save old cycles so we can use them later on.
	adr r2,TIM_fix
	str r2,nexttimeout
;- - - - - - - - - - - - - - - - -
;	ldrb r2,irqPending
;	orr r2,r2,#4
;	strb r2,irqPending
	ldrb r2,timerLatch
	add r2,r2,#1
	add r2,r2,r2,lsl#1			;x3
	add r0,r0,r2,lsl#10			;Latch x 1024
noTirqYet
	str r0,timCycles
noTimer
;--------------------------
checkirqdisable
	tst cycles,#CYC_I
	bne default_scanlinehook		;we dont want no stinkin irqs
checkirqs
	ldrb r0,irqDisable
	ldrb r1,irqPending
	bic r0,r1,r0
	tst r0,#7
	bne whichirq			;which interrupt?
; - - - - - - - - - - - - - - - - - - -
default_scanlinehook
	fetch 0

;	tst r0,#0x10
;	ldrne r12,=RES_VECTOR		;Reset Vector
;	tst r0,#8
;	ldrne r12,=NMI_VECTOR		;NMI IRQ
whichirq
	tst r0,#4
	ldrne r12,=TIM_VECTOR		;Timer IRQ
	bne irq6280
	tst r0,#2
	ldrne r12,=IRQ_VECTOR		;VDC IRQ
	bne irq6280
	ldr r12,=BRK_VECTOR			;External IRQ (CD-ROM)
;----------------------------------------------------------
irq6280 ; needs irq vector in r12
;----------------------------------------------------------
	ldr r0,lastbank
	sub r0,pce_pc,r0
	push16						;save PC

	encodeP (0)					;save P
irq_cont
	push8 r0

	orr cycles,cycles,#CYC_I	;disable IRQ
	bic cycles,cycles,#CYC_D	;and decimal mode

	ldr r0,memmap_tbl+7*4
	ldrb pce_pc,[r0,r12]!
	ldrb r2,[r0,#1]
	orr pce_pc,pce_pc,r2,lsl#8
	encodePC				;get IRQ vector

	fetch 7

;----------------------------------------------------------------------------
CLI_fix;	cli should be delayed by 1 instruction.
;----------------------------------------------------------------------------
	ldr r0,oldcycles
	bic r0,r0,#CYC_MASK			; don't add any cpu bits.
	add cycles,cycles,r0
	ldr r0,nexttimeout_
	str r0,nexttimeout

	b checkirqs
;----------------------------------------------------------------------------
TIM_fix;	timer fix.
;----------------------------------------------------------------------------
	ldr r0,oldcycles
	bic r0,r0,#CYC_MASK			; don't add any cpu bits.
	add cycles,cycles,r0
	ldr r0,nexttimeout_
	str r0,nexttimeout

	ldrb r0,irqPending
	orr r0,r0,#4
	strb r0,irqPending
	b checkirqdisable

;----------------------------------------------------------------------------
_E3x;   TIA $nnnn,$nnnn,#$nnnn
;----------------------------------------------------------------------------
	ldrb r2,[pce_pc,#2]
	ldrb r0,[pce_pc,#3]
	orr r2,r2,r0		;destination
;	ldr r1,=0x404
;	cmp r2,r1		;VCE pal write
	cmp r2,#4		;VCE pal write
	beq _E3z
	cmp r2,#2		;VDC access
	bne _E3
	ldrb r2,vdcRegister
	cmp r2,#2		;VRAM write
	bne _E3
_E3z
	stmfd sp!,{r3-r7}

	ldrb r3,[pce_pc],#1
	ldrb r0,[pce_pc],#3
	orr r3,r3,r0,lsl#8	;load r3 = source
	mov r1,r3,lsr#13
	adr r4,memmap_tbl
	ldr r0,[r4,r1,lsl#2]
	add r3,r3,r0		;r3 = real address.

	ldrb r5,[pce_pc],#1
	ldrb r0,[pce_pc],#1
	orrs r5,r5,r0,lsl#8	;load r5 = length

	moveq r5,#0x10000
	mov r0,#7*3*CYCLE	;should it be 6*3 or 7*3?
	mul r0,r5,r0
	sub cycles,cycles,r0	;cycles=r8

	cmp r2,#4		;VCE pal write
	beq _E3y

	ldrb r4,vramaddrinc
	ldr addy,vram_w_adr
	mov addy,addy,asr#15

	mov r6,#-1
	ldr r7,=DIRTYSPRITES
	ldr r2,=PCE_VRAM
;	b VRAMcpy
;----------------------------------------------------------------------------
VRAMcpy
	tst addy,#0x00FF0000

	streqb r6,[r7,addy,lsr#7]	;dirty table.
	ldrb r0,[r3],#1				;Source
	ldrb r1,[r3],#1
	orreq r0,r0,r1,lsl#8
	streqh r0,[r2,addy]			;write to virtual PCE_VRAM

	add addy,addy,r4,lsl#1
	subs r5,r5,#2
	bhi VRAMcpy

;	mov addy,addy,lsl#15
;	str addy,vram_w_adr
	mov addy,addy,lsr#1
	strb addy,vram_w_adr+2
	mov addy,addy,lsr#8
	strb addy,vram_w_adr+3

	ldmfd sp!,{r3-r7}
	fetch 17

;----------------------------------------------------------------------------
_E3y;   TIA $nnnn,$nnnn,#$nnnn
;----------------------------------------------------------------------------
	ldr r2,palettePtr
	ldr r7,=PCE_PALETTE
;----------------------------------------------------------------------------
PaletteCpy
	ldrb r0,[r3],#1		;Source
	ldrb r1,[r3],#1
	orr r0,r0,r1,lsl#8

	mov r4,r2,lsr#22
	strh r0,[r7,r4]
	add r2,r2,#0x00800000
	subs r5,r5,#2
	bhi PaletteCpy

	str r2,palettePtr
	ldmfd sp!,{r3-r7}
	fetch 17
;----------------------------------------------------------------------------



fiveminutes DCD 5*60*60
sleeptime DCD 5*60*60
dontstop DCD 0
novblankwait DCB 0
	DCB 0,0,0
;----------------------------------------------------------------------------
	AREA rom_code, CODE, READONLY

pce_reset	;called by loadcart (r0-r9 are free to use)
;----------------------------------------------------------------------------
	str lr,[sp,#-4]!

	bl VDC_reset_
	bl IO_reset_
	bl Sound_reset_
	bl CD_reset_
;---Timing
	ldr r0,emuflags
	tst r0,#USEPPUHACK
	ldreq r1,=1365*CYCLE		;Fast		1364=(454.666)*3 (Aero Blaster doesn't like 1364)
;	ldreq r1,=1144*CYCLE		;Fast		1359=(453)*3
;	ldreq r1,=1404*CYCLE		;1404<=Cyber Dodge>=1434, ingame palette bad.
;	ldreq r1,=1302*CYCLE		;1302<=Wonder Momo>=1414 (474*3=1416)
	ldrne r1,=682*CYCLE			;Fast/2		(227.333)*3
	str r1,highcycles
;	ldr r1,=341*CYCLE			;Slow		(113.666)*3
	str r1,cyclesperscanline
	ldr r1,=261					;NTSC (261-262) number of lines=262+1
	str r1,lastscanline
	mov r1,#239
	str r1,vblscanlinegfx
	str r1,vblscanlinecpu
;---cpu reset
	ldr r8,hackflags
	ldr r1,midhack7
	tst r8,#0x40000000			;check hack flags for F0 hack12.
	ldrne r1,superhack12
	tst r8,#0x08000000			;check hack flags for F0 hack8.
	ldrne r1,midhack8
	tst r8,#0x04000000			;check hack flags for F0 hack11.
	ldrne r1,superhack11
	ldr r2,=_F0z
	str r1,[r2]

	ldr r1,midhack7				;D0 special hacks
	tst r8,#0x02000000			;check hack flags for D0-0xFB hack.
	ldrne r1,lowhack5
	tst r8,#0x20000000			;check hack flags for D0-0xF6 hack+.
	ldrne r1,superhack10
	tst r8,#0x10000000			;check hack flags for D0-0xFC hack-.
	ldrne r1,lowhack4
	ldr r2,=_D0z
	str r1,[r2]

	adr r2,hackops
	tst r0,#NOCPUHACK			;load opcode set
	adrne r2,normalops			;this makes all cpuhacks go away if it's choosen.
	tsteq r8,#0x80000000		;check hack flags for nojump hack.
	adreq r1,jmpops
	adrne r1,normalops
	adr r3,opindex
	mov r7,#1
	mov r4,#11					;number of hacks
nr0
	tst r8,r7,lsl r4
	ldrne r5,[r2,r4,lsl#2]		;hacks
	ldreq r5,[r1,r4,lsl#2]		;normal
	ldr r6,[r3,r4,lsl#2]
	str r5,[r6]
	subs r4,r4,#1
	bpl nr0

	ldr r0,=irq_scanlinehook
	str r0,scanlinehook

	mov pce_a,#0
	mov pce_x,#0
	mov pce_y,#0
	mov pce_nz,#0
	adr pce_rmem,readmem_tbl
	ldr r0,=PCE_RAM+0x1ff
	str r0,pce_s			;S=FF
	mov cycles,#CYC_I		;V=0, D=0, C=0, I=1 disable IRQ.

	str pce_a,frame			;frame count reset
	strb pce_a,irqDisable	;irq disable reset

	;(clear irq/nmi/res source)...

	ldr r0,memmap_tbl+7*4
	ldr r1,=RES_VECTOR
	ldrb pce_pc,[r0,r1]!
	ldrb r2,[r0,#1]
	orr pce_pc,pce_pc,r2,lsl#8
	encodePC		;get RESET vector

	adrl r0,cpuregs
	stmia r0,{pce_nz-pce_pc}
	ldr pc,[sp],#4
normalops
	DCD _10,_30,_4C,_50,_70,_80,_90,_B0,_D0,_F0,_58,_E3
jmpops
	DCD _10,_30,_4Cx,_50,_70,_80,_90,_B0,_D0,_F0,_58,_E3x
hackops
	DCD _10y,_30y,0,0,0,_80y,_90y,_B0y,_D0y,_F0y,_58x,_E3
opindex
	DCD op_table+0x10*4,op_table+0x30*4,op_table+0x4C*4,op_table+0x50*4,op_table+0x70*4
	DCD op_table+0x80*4,op_table+0x90*4,op_table+0xB0*4,op_table+0xD0*4,op_table+0xF0*4,op_table+0x58*4,op_table+0xE3*4
superhack12
	cmp r0,#-12			;speed hack+ for SF2CE, Deep Blue(D0)
superhack11
	cmp r0,#-11			;speed hack+ for Morita Shogi PC (F0)
superhack10
	cmp r0,#-10			;speed hack+ for Galaga(D0)
midhack8
	cmp r0,#-8			;speed hack normal
midhack7
	cmp r0,#-7			;speed hack normal
lowhack5
	cmp r0,#-5			;speed hack low
lowhack4
	cmp r0,#-4			;speed hack low
	LTORG

;----------------------------------------------------------------------------
opADC_Dec
;----------------------------------------------------------------------------
	opADCD
	fetch_c 5
;----------------------------------------------------------------------------
opSBC_Dec
;----------------------------------------------------------------------------
	opSBCD
	fetch_c 5
;----------------------------------------------------------------------------
opADCT_Dec
;----------------------------------------------------------------------------
	opADCTD
	fetch_c 5
;----------------------------------------------------------------------------
T01;   ORA ($nn,X)
;----------------------------------------------------------------------------
	doIIX
	opORAT
	fetch 10
;----------------------------------------------------------------------------
T05;   ORA $nn
;----------------------------------------------------------------------------
	doZ
	opORAT
	fetch 7
;----------------------------------------------------------------------------
T09;   ORA #$nn
;----------------------------------------------------------------------------
	doIMM
	opORAT
	fetch 5
;----------------------------------------------------------------------------
T0D;   ORA $nnnn
;----------------------------------------------------------------------------
	doABS
	opORAT
	fetch 8
;----------------------------------------------------------------------------
T11;   ORA ($nn),Y
;----------------------------------------------------------------------------
	doIIY
	opORAT
	fetch 10
;----------------------------------------------------------------------------
T12;   ORA ($nn)
;----------------------------------------------------------------------------
	doZPI
	opORAT
	fetch 10
;----------------------------------------------------------------------------
T15;   ORA $nn,X
;----------------------------------------------------------------------------
	doZIX
	opORAT
	fetch 7
;----------------------------------------------------------------------------
T19;   ORA $nnnn,Y
;----------------------------------------------------------------------------
	doAIY
	opORAT
	fetch 8
;----------------------------------------------------------------------------
T1D;   ORA $nnnn,X
;----------------------------------------------------------------------------
	doAIX
	opORAT
	fetch 8

;----------------------------------------------------------------------------
T21;   AND ($nn,X)
;----------------------------------------------------------------------------
	doIIX
	opANDT
	fetch 10
;----------------------------------------------------------------------------
T25;   AND $nn
;----------------------------------------------------------------------------
	doZ
	opANDT
	fetch 7
;----------------------------------------------------------------------------
T29;   AND #$nn
;----------------------------------------------------------------------------
	doIMM
	opANDT
	fetch 5
;----------------------------------------------------------------------------
T2D;   AND $nnnn
;----------------------------------------------------------------------------
	doABS
	opANDT
	fetch 8
;----------------------------------------------------------------------------
T31;   AND ($nn),Y
;----------------------------------------------------------------------------
	doIIY
	opANDT
	fetch 10
;----------------------------------------------------------------------------
T32;   AND ($nn)
;----------------------------------------------------------------------------
	doZPI
	opANDT
	fetch 10
;----------------------------------------------------------------------------
T35;   AND $nn,X
;----------------------------------------------------------------------------
	doZIX
	opANDT
	fetch 7
;----------------------------------------------------------------------------
T39;   AND $nnnn,Y
;----------------------------------------------------------------------------
	doAIY
	opANDT
	fetch 8
;----------------------------------------------------------------------------
T3D;   AND $nnnn,X
;----------------------------------------------------------------------------
	doAIX
	opANDT
	fetch 8

;----------------------------------------------------------------------------
T41;   EOR ($nn,X)
;----------------------------------------------------------------------------
	doIIX
	opEORT
	fetch 10
;----------------------------------------------------------------------------
T45;   EOR $nn
;----------------------------------------------------------------------------
	doZ
	opEORT
	fetch 7
;----------------------------------------------------------------------------
T49;   EOR #$nn
;----------------------------------------------------------------------------
	doIMM
	opEORT
	fetch 5
;----------------------------------------------------------------------------
T4D;   EOR $nnnn
;----------------------------------------------------------------------------
	doABS
	opEORT
	fetch 8
;----------------------------------------------------------------------------
T51;   EOR ($nn),Y
;----------------------------------------------------------------------------
	doIIY
	opEORT
	fetch 10
;----------------------------------------------------------------------------
T52;   EOR ($nn)
;----------------------------------------------------------------------------
	doZPI
	opEORT
	fetch 10
;----------------------------------------------------------------------------
T55;   EOR $nn,X
;----------------------------------------------------------------------------
	doZIX
	opEORT
	fetch 7
;----------------------------------------------------------------------------
T59;   EOR $nnnn,Y
;----------------------------------------------------------------------------
	doAIY
	opEORT
	fetch 8
;----------------------------------------------------------------------------
T5D;   EOR $nnnn,X
;----------------------------------------------------------------------------
	doAIX
	opEORT
	fetch 8

;----------------------------------------------------------------------------
T61;   EOR ($nn,X)
;----------------------------------------------------------------------------
	doIIX
	opEORT
	fetch 10
;----------------------------------------------------------------------------
T65;   ADC $nn
;----------------------------------------------------------------------------
	doZ
	opADCT
	fetch_c 7
;----------------------------------------------------------------------------
T69;   ADC #$nn
;----------------------------------------------------------------------------
	doIMM
	opADCT
	fetch_c 5
;----------------------------------------------------------------------------
T6D;   ADC $nnnn
;----------------------------------------------------------------------------
	doABS
	opADCT
	fetch_c 8
;----------------------------------------------------------------------------
T71;   ADC ($nn),Y
;----------------------------------------------------------------------------
	doIIY
	opADCT
	fetch_c 10
;----------------------------------------------------------------------------
T72;   ADC ($nn)
;----------------------------------------------------------------------------
	doZPI
	opADCT
	fetch_c 10
;----------------------------------------------------------------------------
T75;   ADC $nn,X
;----------------------------------------------------------------------------
	doZIX
	opADCT
	fetch_c 7
;----------------------------------------------------------------------------
T79;   ADC $nnnn,Y
;----------------------------------------------------------------------------
	doAIY
	opADCT
	fetch_c 8
;----------------------------------------------------------------------------
T7D;   ADC $nnnn,X
;----------------------------------------------------------------------------
	doAIX
	opADCT
	fetch_c 8
;----------------------------------------------------------------------------





;----------------------------------------------------------------------------
op_t_table
	DCD _00,T01,_02,_03,_04,T05,_06,_07,_08,T09,_0A,_xx,_0C,T0D,_0E,_0F
	DCD _10,T11,T12,_13,_14,T15,_16,_17,_18,T19,_1A,_xx,_1C,T1D,_1E,_1F
	DCD _20,T21,_22,_23,_24,T25,_26,_27,_28,T29,_2A,_xx,_2C,T2D,_2E,_2F
	DCD _30,T31,T32,_xx,_34,T35,_36,_37,_38,T39,_3A,_xx,_3C,T3D,_3E,_3F
	DCD _40,T41,_42,_43,_44,T45,_46,_47,_48,T49,_4A,_xx,_4C,T4D,_4E,_4F
	DCD _50,T51,T52,_53,_54,T55,_56,_57,_58,T59,_5A,_xx,_xx,T5D,_5E,_5F
	DCD _60,T61,_62,_xx,_64,T65,_66,_67,_68,T69,_6A,_xx,_6C,T6D,_6E,_6F
	DCD _70,T71,T72,_73,_74,T75,_76,_77,_78,T79,_7A,_xx,_7C,T7D,_7E,_7F
	DCD _80,_81,_82,_83,_84,_85,_86,_87,_88,_89,_8A,_xx,_8C,_8D,_8E,_8F
	DCD _90,_91,_92,_93,_94,_95,_96,_97,_98,_99,_9A,_xx,_9C,_9D,_9E,_9F
	DCD _A0,_A1,_A2,_A3,_A4,_A5,_A6,_A7,_A8,_A9,_AA,_xx,_AC,_AD,_AE,_AF
	DCD _B0,_B1,_B2,_B3,_B4,_B5,_B6,_B7,_B8,_B9,_BA,_xx,_BC,_BD,_BE,_BF
	DCD _C0,_C1,_C2,_C3,_C4,_C5,_C6,_C7,_C8,_C9,_CA,_xx,_CC,_CD,_CE,_CF
	DCD _D0,_D1,_D2,_D3,_D4,_D5,_D6,_D7,_D8,_D9,_DA,_xx,_xx,_DD,_DE,_DF
	DCD _E0,_E1,_xx,_E3,_E4,_E5,_E6,_E7,_E8,_E9,_EA,_xx,_EC,_ED,_EE,_EF
	DCD _F0,_F1,_F2,_F3,_F4,_F5,_F6,_F7,_F8,_F9,_FA,_xx,_xx,_FD,_FE,_FF
;----------------------------------------------------------------------------

	AREA wram_globals0, CODE, READWRITE

op_table
	DCD _00,_01,_02,_03,_04,_05,_06,_07,_08,_09,_0A,_xx,_0C,_0D,_0E,_0F
	DCD _10,_11,_12,_13,_14,_15,_16,_17,_18,_19,_1A,_xx,_1C,_1D,_1E,_1F
	DCD _20,_21,_22,_23,_24,_25,_26,_27,_28,_29,_2A,_xx,_2C,_2D,_2E,_2F
	DCD _30,_31,_32,_xx,_34,_35,_36,_37,_38,_39,_3A,_xx,_3C,_3D,_3E,_3F
	DCD _40,_41,_42,_43,_44,_45,_46,_47,_48,_49,_4A,_xx,_4C,_4D,_4E,_4F
	DCD _50,_51,_52,_53,_54,_55,_56,_57,_58,_59,_5A,_xx,_xx,_5D,_5E,_5F
	DCD _60,_61,_62,_xx,_64,_65,_66,_67,_68,_69,_6A,_xx,_6C,_6D,_6E,_6F
	DCD _70,_71,_72,_73,_74,_75,_76,_77,_78,_79,_7A,_xx,_7C,_7D,_7E,_7F
	DCD _80,_81,_82,_83,_84,_85,_86,_87,_88,_89,_8A,_xx,_8C,_8D,_8E,_8F
	DCD _90,_91,_92,_93,_94,_95,_96,_97,_98,_99,_9A,_xx,_9C,_9D,_9E,_9F
	DCD _A0,_A1,_A2,_A3,_A4,_A5,_A6,_A7,_A8,_A9,_AA,_xx,_AC,_AD,_AE,_AF
	DCD _B0,_B1,_B2,_B3,_B4,_B5,_B6,_B7,_B8,_B9,_BA,_xx,_BC,_BD,_BE,_BF
	DCD _C0,_C1,_C2,_C3,_C4,_C5,_C6,_C7,_C8,_C9,_CA,_xx,_CC,_CD,_CE,_CF
	DCD _D0,_D1,_D2,_D3,_D4,_D5,_D6,_D7,_D8,_D9,_DA,_xx,_xx,_DD,_DE,_DF
	DCD _E0,_E1,_xx,_E3x,_E4,_E5,_E6,_E7,_E8,_E9,_EA,_xx,_EC,_ED,_EE,_EF
	DCD _F0,_F1,_F2,_F3,_F4,_F5,_F6,_F7,_F8,_F9,_FA,_xx,_xx,_FD,_FE,_FF

	;readmem_tbl
	% 8*4		;$0000-FFFF
	;writemem_tbl
	% 8*4		;$0000-FFFF
	;memmap_tbl
rommap
	% 8*4		;$0000-FFFF
	;mapperdata
mapperstate
	% 8

cpustate
	;group these together for save/loadstate
	% 7*4 ;cpuregs (nz,c,a,x,y,cycles,pc)
	DCD 0 ;pce_s:
	DCD 0 ;lastbank: last memmap added to PC (used to calculate current PC)

	DCD 0 ;nexttimeout:  jump here when cycles runs out
	DCD 0 ;nexttimeout_:  backup of nexttimeout
	DCD 0 ;oldcycles:  backup of cycles
	DCD 0 ;scanline
	DCD 0 ;scanlinehook
frametotal		;let ui.c see frame count for savestates
	DCD 0 ;frame
	DCD 0 ;cyclesperscanline (374*CYCLE(Low) or 1416*CYCLE(High))
	DCD 0 ;lastscanline (262)
	DCD 0 ;vblscanlinegfx (240?)
	DCD 0 ;vblscanlinecpu (240?)
	DCD 0 ;highcycles
	DCD 0 ;hackflags
;----------------------------------------------------------------------------
	END

