/*
Copyright (C) 2001 StrmnNrmn

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

*/

#ifdef ZLIB_SUPPORT

#include "stdafx.h"
#include <shlwapi.h>
#include "unzip.h"

#include "DBGConsole.h"

static HRESULT UnzipRom_UnzipFile(unzFile uf, BYTE ** ppBuffer, ULONG * pnRomSize);


HRESULT __cdecl UnzipRom_Unzip(LPCSTR szZipFileName, BYTE ** ppBuffer, ULONG * pnRomSize)
{
	unzFile uf;
    int err;
	BOOL bFoundROM;
	HRESULT hr;

	CHAR szRomFileName[MAX_PATH+1];

	uf = unzOpen(szZipFileName);
	if (uf == NULL)
		return E_FAIL;

	err = unzGoToFirstFile(uf);
	if (err != UNZ_OK)
	{
		unzCloseCurrentFile(uf);
		return E_FAIL;
	}

	bFoundROM = FALSE;
	do
	{
		err = unzGetCurrentFileInfo (uf, NULL,
									 szRomFileName, MAX_PATH,
			                         NULL, 0,
									 NULL, 0);

		if (err != UNZ_OK)
			break;

		if (lstrcmpi(PathFindExtension(szRomFileName), TEXT(".rom")) == 0 ||
			lstrcmpi(PathFindExtension(szRomFileName), TEXT(".v64")) == 0 ||
			lstrcmpi(PathFindExtension(szRomFileName), TEXT(".n64")) == 0 ||
			lstrcmpi(PathFindExtension(szRomFileName), TEXT(".z64")) == 0 ||
			lstrcmpi(PathFindExtension(szRomFileName), TEXT(".jap")) == 0 ||
			lstrcmpi(PathFindExtension(szRomFileName), TEXT(".pal")) == 0 ||
			lstrcmpi(PathFindExtension(szRomFileName), TEXT(".usa")) == 0)
		{

			//DBGConsole_Msg(0, "Found rom %s in %s", szRomFileName, szZipFileName);
			bFoundROM = TRUE;
			break;
		}

	} while (unzGoToNextFile(uf) == UNZ_OK);

	if (!bFoundROM)
	{
		unzCloseCurrentFile(uf);
		return E_FAIL;
	}


	// Extract rom and return buffer;
	hr = UnzipRom_UnzipFile(uf, ppBuffer, pnRomSize);

	unzCloseCurrentFile(uf);

	return hr;

}


static HRESULT UnzipRom_UnzipFile(unzFile uf, BYTE ** ppBuffer, ULONG * pnRomSize)
{
    int err;
    BYTE * buf;
	unz_file_info file_info;
	LONG nBytesToRead;
	LONG nBytesRead;

	nBytesToRead = *pnRomSize;

	// Clear buffer to start with
	*ppBuffer = NULL;
	*pnRomSize = 0;

	err = unzGetCurrentFileInfo(uf,&file_info, NULL,0, NULL,0, NULL,0);

	if (err != UNZ_OK)
	{
		//printf("error %d with zipfile in unzGetCurrentFileInfo\n",err);
		return E_FAIL;
	}

	// If a size of 0 was specified, this indicates we should read entire file
	if (nBytesToRead == 0)
		nBytesToRead = file_info.uncompressed_size;


    buf = new BYTE[nBytesToRead];
    if (buf == NULL)
    {
        //printf("Error allocating memory\n");
        return E_OUTOFMEMORY;
    }

	err = unzOpenCurrentFile(uf);
	if (err == UNZ_OK)
	{
		nBytesRead = unzReadCurrentFile(uf, (void *)buf, nBytesToRead);
		if (nBytesRead < nBytesToRead)
			err = UNZ_ERRNO;
	}


 	if (err != UNZ_OK)
	{
		//printf("error %d with zipfile in unzOpenCurrentFile\n",err);
		delete [] buf;
		unzCloseCurrentFile(uf);
		return E_FAIL;
	}
  
	unzCloseCurrentFile(uf);

	*ppBuffer = buf;
	*pnRomSize = file_info.uncompressed_size;

    return S_OK;
}
#endif

