// stdafx.h : include file for standard system include files,
//  or project specific include files that are used frequently, but
//      are changed infrequently
//

#if !defined(AFX_STDAFX_H__D745D35D_8415_4821_9789_CD847CAF9B48__INCLUDED_)
#define AFX_STDAFX_H__D745D35D_8415_4821_9789_CD847CAF9B48__INCLUDED_

#if _MSC_VER > 1000
#pragma once
#endif // _MSC_VER > 1000

#define WIN32_LEAN_AND_MEAN		// Exclude rarely-used stuff from Windows headers

#include <stdio.h>
#include <windows.h>
#include <winnt.h>			// For 32x32To64 multiplies
#include <math.h>			// For sqrt()

#include <d3dx.h>

#include <vector>
#include <iostream.h>


// TODO: reference additional headers your program requires here


#ifndef SAFE_DELETE
#define SAFE_DELETE(p)  { if(p) { delete (p);     (p)=NULL; } }
#endif

#ifndef SAFE_RELEASE
#define SAFE_RELEASE(p)  { if(p) { (p)->Release();     (p)=NULL; } }
#endif

#ifndef SAFE_DELETEARRAY
#define SAFE_DELETEARRAY(p)  { if(p) { delete [](p);     (p)=NULL; } }
#endif

#define ARRAYSIZE(arr)   (sizeof(arr) / sizeof(arr[0]))

#include "localization.h"

#include "IniFile.h"
#include "GfxContext.h"

#define DAEDLAUS_VERSION_NO		0x007b
#define DAEDALUS_VERSION		"0.07b"
#define DAEDALUS_SITE			"http://daedalus.boob.co.uk/"

// Uncomment this to disable some of the developer functions like
// DL_PF etc for performance improvements
#define DAEDALUS_RELEASE_BUILD
//#undef DAEDALUS_RELEASE_BUILD	

extern HINSTANCE	g_hInstance;
extern HWND			g_hMainWindow;
extern HWND			g_hWndStatus;
extern TCHAR		g_szRomsDir[MAX_PATH+1];
extern TCHAR		g_szSaveDir[MAX_PATH+1];
extern TCHAR		g_szDaedalusExeDir[MAX_PATH+1];
extern TCHAR		g_szDaedalusIniFile[MAX_PATH+1];

extern char			g_szDaedalusName[256];
extern HANDLE		g_hEndBufferEvent;

#ifdef DAEDALUS_LOG
extern HANDLE		g_hOutputLog;
#endif

extern IniFile * g_pIniFile;
extern CGfxContext g_GfxContext;

// Config stuff - later move to a single struct or somethign
extern BOOL	g_bEepromPresent;

extern BOOL g_bRDPEnableGfx;		// Show graphics
extern BOOL g_bUseDynarec;			// Use dynamic recompilation
extern BOOL g_bApplyPatches;		// Apply os-hooks
extern BOOL g_bCRCCheck;			// Apply a crc-esque check to each texture each frame
extern BOOL g_bSpeedSync;			// Sync vi speed
extern BOOL g_bShowDebug;
extern BOOL g_bIncTexRectEdge;
extern BOOL g_bWarnMemoryErrors;
extern BOOL g_bRunAutomatically;
extern BOOL g_bTrapExceptions;		
extern BOOL g_bSkipFirstRSP;

extern DWORD g_dwDisplayWidth;
extern DWORD g_dwDisplayHeight;
extern BOOL  g_bDisplayFullscreen;

extern RECT g_rcMainWindow;


extern TCHAR		g_szAiPluginFileName[MAX_PATH];
extern TCHAR		g_szGfxPluginFileName[MAX_PATH];


#include "ResourceString.h"		// Useful everywhere



//{{AFX_INSERT_LOCATION}}
// Microsoft Visual C++ will insert additional declarations immediately before the previous line.

#endif // !defined(AFX_STDAFX_H__D745D35D_8415_4821_9789_CD847CAF9B48__INCLUDED_)
