/*
Copyright (C) 2001 StrmnNrmn

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

*/

#include "stdafx.h"

//#define     D3D_OVERLOADS

#include <shlwapi.h>
#include <d3dx.h>

#include "build.h"
#include "AudioPlugin.h"


#include "unziprom.h"

#include "Dump.h"
#include "Debug.h"
#include "OpCode.h"

#include "resource.h"

#include "Memory.h"
#include "ROM.h"				// ROM_Unload
#include "Interrupt.h"

#include "ConfigHandler.h"
#include "MainWindow.h"

#include "SR.h"
#include "Patch.h"
#include "DBGConsole.h"
#include "FilenameHandler.h"

//////////////////////////////////////////////////
// Globally defined strings
TCHAR					g_szDaedalusName[256];

TCHAR					g_szCurrentRomFileName[MAX_PATH] = "";
TCHAR					g_szAiPluginFileName[MAX_PATH] = "";
TCHAR					g_szGfxPluginFileName[MAX_PATH] = "";

/////////////////////////////////////////////////////////////////////
HWND					g_hMainWindow				= NULL;

HINSTANCE				g_hInstance					= NULL;
static HACCEL			g_hMainAccel				= NULL;

#ifdef DAEDALUS_LOG
HANDLE					g_hOutputLog				= INVALID_HANDLE_VALUE;
#endif

IniFile *				g_pIniFile = NULL;



// Static Declarations
int  WINAPI WinMain(HINSTANCE hThisInst, HINSTANCE hPrevInst, LPSTR lpszArgs, int nWinMode);
static void LoadStrings(void);
static int  RunMain(void);
static void DoOneTimeUpdateStuff();


TCHAR		g_szRomsDir[MAX_PATH+1];
TCHAR		g_szSaveDir[MAX_PATH+1];
TCHAR		g_szDaedalusExeDir[MAX_PATH+1];
TCHAR		g_szDaedalusIniFile[MAX_PATH+1];

ConfigHandler *	g_pConfig;

OSVERSIONINFO g_OSVersionInfo;

/////////////////////////////////////////////////////////////////////
int WINAPI WinMain(HINSTANCE hThisInst, HINSTANCE hPrevInst,
				   LPSTR lpszArgs, int nWinMode)
{
	int nResult;
	BOOL bResult;
	TCHAR szLastVersion[30+1];

	g_hInstance = hThisInst;

	g_OSVersionInfo.dwOSVersionInfoSize = sizeof(g_OSVersionInfo);
	GetVersionEx(&g_OSVersionInfo);

	LoadStrings();
	GetModuleFileName(hThisInst, g_szDaedalusExeDir, MAX_PATH);
	PathRemoveFileSpec(g_szDaedalusExeDir);
	// Generate ini filename
	PathCombine(g_szDaedalusIniFile, g_szDaedalusExeDir, TEXT("daedalus.ini"));

	// must be setup before checking for DLLs to display localized error message
	Localization_SetLanguage();


	// Check for DX8 - nice idea from Lkb!!
	// We delayload dinput8.dll (ddraw.dll is almost always likely to be found)
	// This ensures that Daedalus will start up ok.
	// We check here for dinput8.dll - if it's missing then we return
	// a more meaningful error than windows would, and quit
	{
		HINSTANCE hInstDInput;
		
		hInstDInput = LoadLibrary("dinput8.dll");
		if (hInstDInput == NULL)
		{
			MessageBox(NULL, CResourceString(IDS_NODX8),
							 g_szDaedalusName, MB_ICONSTOP|MB_OK);
			return 0;
		}
		FreeLibrary(hInstDInput);

	}

	// Load config details from the registry
	{
		ConfigHandler * pConfig = new ConfigHandler("Main");
		
		if (pConfig != NULL)
		{
			LONG nLeft, nTop, nWidth, nHeight;

			pConfig->ReadValue("ShowDebug", (DWORD*)&g_bShowDebug, FALSE);
			pConfig->ReadString("Version", szLastVersion, 30, "0.00");
			pConfig->ReadString("RomsDir", g_szRomsDir, MAX_PATH, "");
			pConfig->ReadString("SaveDir", g_szSaveDir, MAX_PATH, "");
			pConfig->ReadString("AudioPlugin", g_szAiPluginFileName, MAX_PATH, "");
			pConfig->ReadString("GraphicsPlugin", g_szGfxPluginFileName, MAX_PATH, "");
			
			// These are used internally - mainly useful for debugging
			pConfig->ReadValue("WarnMemoryErrors", (DWORD*)&g_bWarnMemoryErrors, FALSE);
			pConfig->ReadValue("TrapExceptions", (DWORD*)&g_bTrapExceptions, TRUE);
			pConfig->ReadValue("RunAutomatically", (DWORD*)&g_bRunAutomatically, TRUE);

			pConfig->ReadValue("DisplayWidth", &g_dwDisplayWidth, 640);
			pConfig->ReadValue("DisplayHeight", &g_dwDisplayHeight, 480);
			pConfig->ReadValue("DisplayFullscreen", (DWORD*)&g_bDisplayFullscreen, FALSE);

			pConfig->ReadValue("WindowLeft", (DWORD*)&nLeft, CW_USEDEFAULT);
			pConfig->ReadValue("WindowTop", (DWORD*)&nTop, CW_USEDEFAULT);
			pConfig->ReadValue("WindowWidth", (DWORD*)&nWidth, 640);
			pConfig->ReadValue("WindowHeight", (DWORD*)&nHeight, 480);

			g_rcMainWindow.left = nLeft;
			g_rcMainWindow.top = nTop;
			g_rcMainWindow.right = nLeft + nWidth;
			g_rcMainWindow.bottom = nTop + nHeight;


			switch (g_dwDisplayWidth)
			{
			case 320: case 640: case 800: case 1024:
				break;
			default:
				g_dwDisplayWidth = 320;
				break;
			}

			// Hack to force correct aspect. Later we might allow non-standard res
			g_dwDisplayHeight = (g_dwDisplayWidth * 3) / 4;


			delete pConfig;
		}
	}

	if (lstrcmpi(szLastVersion, DAEDALUS_VERSION) != 0)
	{
		DoOneTimeUpdateStuff();
	}
	
	// Load the inifile
	g_pIniFile = new IniFile(g_szDaedalusIniFile);
	if (g_pIniFile == NULL)
		return 1;


	bResult = g_pIniFile->ReadIniFile();
	if (!bResult)
	{
		MessageBox(NULL, "Unable to read IniFile from disk", g_szDaedalusName, MB_OK);
		//return 1;
	}


	// Init memory before Console (which tries to display things that
	// are refs to memory)
	if (!Memory_Init()) return 0;

	// Don't care about failures
	DBGConsole_Enable(g_bShowDebug);


	if (!InitMainWindow())
		return 1;
	if (FAILED(SR_Init(30000)))
		return 1;

	// Open the logfile for writing
	#ifdef DAEDALUS_LOG
	{
		TCHAR szLogFileName[MAX_PATH+1];

		Dump_GetDumpDirectory(szLogFileName, TEXT(""));

		PathAppend(szLogFileName, TEXT("daedalus.txt"));

		g_hOutputLog = CreateFile(szLogFileName, // open the file 
				GENERIC_WRITE,                // open for writing 
				0,                            // do not share 
				NULL,                         // no security 
				CREATE_ALWAYS,                // replace any existing file
				FILE_ATTRIBUTE_NORMAL,        // normal file 
				NULL);                        // no attr. template 
		if (g_hOutputLog == INVALID_HANDLE_VALUE)
		{ 
			return 0;
		}
	}
	#endif

	DBGConsole_Msg(0, "[cDaedalus %s Build %d] - A Nintendo64 Emulator by StrmnNrmn", DAEDALUS_VERSION, DAEDALUS_BUILD_NO);
	DBGConsole_Msg(0, "Copyright (C) 2001 StrmnNrmn");

	DBGConsole_Msg(0, "");
	DBGConsole_Msg(0, "[WDisclaimer]");
	DBGConsole_Msg(0, "[W----------]");

	DBGConsole_Msg(0, "I do not have any association with Nintendo, or");
	DBGConsole_Msg(0, "any of its affiliates.  This program was developed for");
	DBGConsole_Msg(0, "non-commercial use and is not intended to compete ");
	DBGConsole_Msg(0, "with the Nintendo 64.");
	DBGConsole_Msg(0, "The name Nintendo and various other names and");
	DBGConsole_Msg(0, "service marks are owned by either Nintendo or their ");
	DBGConsole_Msg(0, "respective owners. ");
	DBGConsole_Msg(0, "");

	DBGConsole_Msg(0, "For more information visit [B%s]", DAEDALUS_SITE);

	DBGConsole_Msg(0, "");
	DBGConsole_Msg(0, "[WConfig]");
	DBGConsole_Msg(0, "[W------]");
	DBGConsole_Msg(0, "WarnMemoryErrors: [W%s], TrapExceptions: [W%s], RunAutomatically: [W%s]",
		g_bWarnMemoryErrors ? "on" : "off",
		g_bTrapExceptions ? "on" : "off",
		g_bRunAutomatically ? "on" : "off");

	DBGConsole_Msg(0, "");

	g_hMainWindow = Main_Create(nWinMode);
	if (!IsWindow(g_hMainWindow))
		return 1;
	
	g_hMainAccel = LoadAccelerators(hThisInst, MAKEINTRESOURCE(IDR_APP_ACCELERATOR));

	try
	{
		nResult = RunMain();
	}
	catch (...)
	{
		if (g_bTrapExceptions)
			MessageBox(NULL, CResourceString(IDS_EXCEPTION), g_szDaedalusName, MB_OK);
		else 
		{
			throw;
		}
	}


	// Write config details back out to the registry
	{
		ConfigHandler * pConfig = new ConfigHandler("Main");
		
		if (pConfig != NULL)
		{
			pConfig->WriteValue("ShowDebug", g_bShowDebug);
			pConfig->WriteString("Version", DAEDALUS_VERSION);
			pConfig->WriteString("RomsDir", g_szRomsDir);
			pConfig->WriteString("SaveDir", g_szSaveDir);
			pConfig->WriteString("AudioPlugin", g_szAiPluginFileName);
			pConfig->WriteString("GraphicsPlugin", g_szGfxPluginFileName);


			pConfig->WriteValue("WarnMemoryErrors", g_bWarnMemoryErrors);
			pConfig->WriteValue("TrapExceptions", g_bTrapExceptions);
			pConfig->WriteValue("RunAutomatically", g_bRunAutomatically);


			pConfig->WriteValue("DisplayWidth", g_dwDisplayWidth);
			pConfig->WriteValue("DisplayHeight", g_dwDisplayHeight);
			pConfig->WriteValue("DisplayFullscreen", g_bDisplayFullscreen);


			pConfig->WriteValue("WindowLeft", g_rcMainWindow.left);
			pConfig->WriteValue("WindowTop", g_rcMainWindow.top);
			pConfig->WriteValue("WindowWidth", g_rcMainWindow.right - g_rcMainWindow.left);
			pConfig->WriteValue("WindowHeight", g_rcMainWindow.bottom - g_rcMainWindow.top);

			delete pConfig;
		}
	}


	SR_Fini();

	ROM_Unload();

	DBGConsole_Enable(FALSE);
	Memory_Fini();

	#ifdef _debug
	CloseHandle(g_hOutputLog);
	#endif

	delete g_pIniFile;		// Will write ini file if changed
	return nResult;
}


int RunMain(void)
{

	MSG msg;

	// Was PeekMessage - caused huge slowdown on Win9x machines.
	// (but not on Win2k machines strangely). There is no good reason
	// for PeekMessage being there. Originally the CPU was driven off the idle
	// time in this loop. When I moved the CPU stuff to its own thread, I must
	// have fogotten to change this back to GetMessage. Oops.
	while (GetMessage(&msg, (HWND)NULL, 0,0))//, PM_REMOVE))
	{

		// Disable this code so that the listview passes accelerator commands on
		//if (msg.hwnd == g_hMainWindow)
		{
			if (!TranslateAccelerator(g_hMainWindow, g_hMainAccel, &msg))
			{
				TranslateMessage(&msg);
				DispatchMessage(&msg);
			}
		}
		/*else
		{
			TranslateMessage(&msg);
			DispatchMessage(&msg);
		}*/
	}

	return 0;
}
///////////////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////////////
void
LoadStrings(void)
{
	LoadString(g_hInstance, IDS_DAEDALUS_STRING, g_szDaedalusName, 256);
}

///////////////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////////////

static BOOL __stdcall DisclaimerDialogProc(HWND hWndDlg, UINT msg, WPARAM wParam, LPARAM lParam)
{

	switch (msg)
	{
	case WM_INITDIALOG:
		SendMessage(GetDlgItem(hWndDlg, IDC_DAEDALUS_LOGO), STM_SETIMAGE, IMAGE_BITMAP, (LPARAM)LoadBitmap(g_hInstance, MAKEINTRESOURCE(IDB_DAEDALUS)));
		return TRUE;
	case WM_COMMAND:
		switch (LOWORD(wParam))
		{
		case IDOK:
			EndDialog(hWndDlg, 0);
			break;
		}
		break;	
	}

	return 0;

}
void DoOneTimeUpdateStuff()
{

	DialogBox(g_hInstance, MAKEINTRESOURCE(IDD_DISCLAIMER), NULL, DisclaimerDialogProc);

	// Here we might do other stuff like update registry keys,
	// associate filetypes or whatever

	if (lstrlen(g_szRomsDir) == 0)
	{
		// g_szRomsDir = DefaultDirectory/Daedalus
		ConfigHandler * pConfig = new ConfigHandler("Default Directory");
		if (pConfig != NULL)
		{
			pConfig->ReadString("Daedalus", g_szRomsDir, MAX_PATH, "");
			delete pConfig;
		}
		
		// If it's still empty, it is initialised when the ListView is filled
	}

	if (lstrlen(g_szSaveDir) == 0)
	{
		lstrcpyn(g_szSaveDir, g_szRomsDir, MAX_PATH);
		//Main_SelectSaveDir(g_hMainWindow);		// This is probably null?
	}

	
}


