/*
Copyright (C) 2001 StrmnNrmn

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

*/

#include "stdafx.h"

#include "Debug.h"
#include "cpu.h"


#ifdef DAEDALUS_LOG
    DWORD   g_dwDebuggingLevel = 1;
    BOOL    g_bLog = FALSE;
#else
    BOOL    g_bLog = FALSE;
#endif


#ifdef DAEDALUS_LOG
void __cdecl dprintf (DWORD dwDebugLevel, LPCTSTR szFormat, ...)
{
    TCHAR   szBuffer[500] = "";
    va_list va;

	// Check if current debug level
	if (dwDebugLevel > DEBUG_TEST_STUFF) {

		if (g_bLog && (
				//dwDebugLevel == DEBUG_MEMORY ||

				// Specific register debugging
				//dwDebugLevel == DEBUG_CAUSE ||
				//dwDebugLevel == DEBUG_COMPARE ||
				//dwDebugLevel == DEBUG_STATUS ||
				//dwDebugLevel == DEBUG_COUNT ||

				//dwDebugLevel == DEBUG_REGS ||			// Generic register info

				//dwDebugLevel == DEBUG_TLB ||
				//dwDebugLevel == DEBUG_PI ||
				//dwDebugLevel == DEBUG_SP ||
				//dwDebugLevel == DEBUG_DP ||
				//dwDebugLevel == DEBUG_MI ||
				//dwDebugLevel == DEBUG_SI ||
				//dwDebugLevel == DEBUG_VI ||
				//dwDebugLevel == DEBUG_AI ||

				//dwDebugLevel == DEBUG_ERET ||
				//dwDebugLevel == DEBUG_BREAK ||
				
				//dwDebugLevel == DEBUG_INTR_PI ||
				//dwDebugLevel == DEBUG_INTR_SP ||
				//dwDebugLevel == DEBUG_INTR_DP ||
				//dwDebugLevel == DEBUG_INTR_SI ||
				//dwDebugLevel == DEBUG_INTR_VI ||
				//dwDebugLevel == DEBUG_INTR_COMPARE ||
				//dwDebugLevel == DEBUG_INTR_AI ||


				//dwDebugLevel == DEBUG_MEMORY_RDRAM_REG ||
				//dwDebugLevel == DEBUG_MEMORY_SP_DMEM||
				//dwDebugLevel == DEBUG_MEMORY_SP_IMEM||
				//dwDebugLevel == DEBUG_MEMORY_SP_REG||
				//dwDebugLevel == DEBUG_MEMORY_MI||
				//dwDebugLevel == DEBUG_MEMORY_VI||
				//dwDebugLevel == DEBUG_MEMORY_AI||
				//dwDebugLevel == DEBUG_MEMORY_RI||
				//dwDebugLevel == DEBUG_MEMORY_SI||
				//dwDebugLevel == DEBUG_MEMORY_PI||
				dwDebugLevel == DEBUG_MEMORY_PIF||
				//dwDebugLevel == DEBUG_MEMORY_DP||

				//dwDebugLevel == DEBUG_DYNREC||
				//dwDebugLevel == DEBUG_DYNREC_STOPPAGE||
				//dwDebugLevel == DEBUG_DSOUND ||
				//dwDebugLevel == DEBUG_THANDLER ||

				//dwDebugLevel == DEBUG_OPS ||

				//dwDebugLevel == DEBUG_OS||
				//dwDebugLevel == DEBUG_UCODE||

				//dwDebugLevel == DEBUG_DP_AUD ||

				FALSE			// So we can comment stuff out
			)) {

			lstrcpy (szBuffer, START_STR);
			va_start(va, szFormat);
			vsprintf (szBuffer+lstrlen (szBuffer), szFormat, va);
			va_end(va);
			lstrcat (szBuffer, END_STR);

			DWORD dwNumWritten;
			WriteFile(g_hOutputLog, szBuffer, strlen(szBuffer), &dwNumWritten, NULL);
		}
	/*} else if (dwDebugLevel == DEBUG_MEMWARN) {
		
		lstrcpy (szBuffer, START_STR);
		va_start(va, szFormat);
		vsprintf (szBuffer+lstrlen (szBuffer), szFormat, va);
		va_end(va);
		lstrcat (szBuffer, END_STR);

		MessageBox(g_hMainWindow, szBuffer, g_szDaedalusName, MB_OK);
*/
	} else {
		if (dwDebugLevel < g_dwDebuggingLevel)
			return;

		va_start(va, szFormat);
		vsprintf (szBuffer+lstrlen (szBuffer), szFormat, va);
		va_end(va);
		DBGConsole_Msg(0, szBuffer);
	}

}
#endif // DAEDALUS_LOG



HANDLE Debug_CreateDumpFile(LPCTSTR szFileName)
{
	HANDLE hFile;
	DBGConsole_Msg(0, "Creating Dump file '%s'", szFileName);

	hFile = CreateFile(szFileName,		// open the file 
			GENERIC_WRITE,              // open for writing 
			0,                          // do not share 
			NULL,                       // no security 
			CREATE_ALWAYS,              // replace any existing file
			FILE_ATTRIBUTE_NORMAL,      // normal file 
			NULL);                      // no attr. template 

	return hFile;
}

void Debug_CloseDumpFile(HANDLE hFile)
{
	CloseHandle(hFile);
}

void Debug_DumpLine(HANDLE hFile, LPCTSTR szFormat, va_list va)
{
	DWORD dwNumWritten;
    TCHAR szBuffer[1000];

	// For float conversions, don't use wvsprintf
	vsprintf(szBuffer, szFormat, va);
	lstrcat(szBuffer, "\r\n");	
	WriteFile(hFile, szBuffer, lstrlen(szBuffer), &dwNumWritten, NULL);

}
