/*
Copyright (C) 2001 StrmnNrmn

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

*/

#include "stdafx.h"
#include <shlwapi.h>

#include "RDP.h"
#include "RDP_AUD.h"

#include "Memory.h"
#include "debug.h"
#include "Dump.h"			// For Dump_GetDumpDirectory()
#include "opcode.h"

#include "ultra_mbi.h"
#include "DBGConsole.h"


typedef void (*RDP_AUD_Instruction)();


static void RDP_AUD_Nothing();
static void RDP_AUD_SPNOOP();
static void RDP_AUD_ADPCM();
static void RDP_AUD_ClearBuff();
static void RDP_AUD_EnvMixer();
static void RDP_AUD_LoadBuff();
static void RDP_AUD_Resample();
static void RDP_AUD_SaveBuff();
static void RDP_AUD_Segment();
static void RDP_AUD_SetBuff();
static void RDP_AUD_SetVol();
static void RDP_AUD_DMEMMove();
static void RDP_AUD_LoadADPCM();
static void RDP_AUD_Mixer();
static void RDP_AUD_Interleave();
static void RDP_AUD_PoleF();
static void RDP_AUD_SetLoop();

static void RDP_AUD_LoadADPCMBuffer();
static void RDP_AUD_SaveADPCMBuffer();

static DWORD g_dwCmd0;
static DWORD g_dwCmd1;

static DWORD	g_dwAudSegment[16];

// For AUDTASK stuff
DWORD g_dwAFlags = 0;
DWORD g_dwAIn    = 0;
DWORD g_dwAOut   = 0;
DWORD g_dwACount = 0;
DWORD g_dwAIn2   = 0;
DWORD g_dwAOut2  = 0;
DWORD g_dwACount2= 0;

DWORD g_dwALoop = 0;

static void DecodeBlock(SHORT * pCurrent, DWORD dwIn, DWORD dwBitsPerCode);

#define AUDSegAddr(seg) ( g_dwAudSegment[(seg>>24)&0x0F] + (seg&0x00FFFFFF) )

RDP_AUD_Instruction AUDInstruction[256] = {
	RDP_AUD_SPNOOP,  RDP_AUD_ADPCM,   RDP_AUD_ClearBuff, RDP_AUD_EnvMixer,
	RDP_AUD_LoadBuff,RDP_AUD_Resample,RDP_AUD_SaveBuff,RDP_AUD_Segment,
	RDP_AUD_SetBuff, RDP_AUD_SetVol,  RDP_AUD_DMEMMove,RDP_AUD_LoadADPCM,
	RDP_AUD_Mixer,   RDP_AUD_Interleave, RDP_AUD_PoleF, RDP_AUD_SetLoop,
	RDP_AUD_Nothing, RDP_AUD_Nothing, RDP_AUD_Nothing, RDP_AUD_Nothing,
	RDP_AUD_LoadADPCMBuffer, RDP_AUD_SaveADPCMBuffer, RDP_AUD_Nothing, RDP_AUD_Nothing,
	RDP_AUD_Nothing, RDP_AUD_Nothing, RDP_AUD_Nothing, RDP_AUD_Nothing,
	RDP_AUD_Nothing, RDP_AUD_Nothing, RDP_AUD_Nothing, RDP_AUD_Nothing,
	RDP_AUD_Nothing, RDP_AUD_Nothing, RDP_AUD_Nothing, RDP_AUD_Nothing,
	RDP_AUD_Nothing, RDP_AUD_Nothing, RDP_AUD_Nothing, RDP_AUD_Nothing,
	RDP_AUD_Nothing, RDP_AUD_Nothing, RDP_AUD_Nothing, RDP_AUD_Nothing,
	RDP_AUD_Nothing, RDP_AUD_Nothing, RDP_AUD_Nothing, RDP_AUD_Nothing,
	RDP_AUD_Nothing, RDP_AUD_Nothing, RDP_AUD_Nothing, RDP_AUD_Nothing,
	RDP_AUD_Nothing, RDP_AUD_Nothing, RDP_AUD_Nothing, RDP_AUD_Nothing,
	RDP_AUD_Nothing, RDP_AUD_Nothing, RDP_AUD_Nothing, RDP_AUD_Nothing,
	RDP_AUD_Nothing, RDP_AUD_Nothing, RDP_AUD_Nothing, RDP_AUD_Nothing,

	RDP_AUD_Nothing, RDP_AUD_Nothing, RDP_AUD_Nothing, RDP_AUD_Nothing,
	RDP_AUD_Nothing, RDP_AUD_Nothing, RDP_AUD_Nothing, RDP_AUD_Nothing,
	RDP_AUD_Nothing, RDP_AUD_Nothing, RDP_AUD_Nothing, RDP_AUD_Nothing,
	RDP_AUD_Nothing, RDP_AUD_Nothing, RDP_AUD_Nothing, RDP_AUD_Nothing,
	RDP_AUD_Nothing, RDP_AUD_Nothing, RDP_AUD_Nothing, RDP_AUD_Nothing,
	RDP_AUD_Nothing, RDP_AUD_Nothing, RDP_AUD_Nothing, RDP_AUD_Nothing,
	RDP_AUD_Nothing, RDP_AUD_Nothing, RDP_AUD_Nothing, RDP_AUD_Nothing,
	RDP_AUD_Nothing, RDP_AUD_Nothing, RDP_AUD_Nothing, RDP_AUD_Nothing,
	RDP_AUD_Nothing, RDP_AUD_Nothing, RDP_AUD_Nothing, RDP_AUD_Nothing,
	RDP_AUD_Nothing, RDP_AUD_Nothing, RDP_AUD_Nothing, RDP_AUD_Nothing,
	RDP_AUD_Nothing, RDP_AUD_Nothing, RDP_AUD_Nothing, RDP_AUD_Nothing,
	RDP_AUD_Nothing, RDP_AUD_Nothing, RDP_AUD_Nothing, RDP_AUD_Nothing,
	RDP_AUD_Nothing, RDP_AUD_Nothing, RDP_AUD_Nothing, RDP_AUD_Nothing,
	RDP_AUD_Nothing, RDP_AUD_Nothing, RDP_AUD_Nothing, RDP_AUD_Nothing,
	RDP_AUD_Nothing, RDP_AUD_Nothing, RDP_AUD_Nothing, RDP_AUD_Nothing,
	RDP_AUD_Nothing, RDP_AUD_Nothing, RDP_AUD_Nothing, RDP_AUD_Nothing,

	RDP_AUD_Nothing, RDP_AUD_Nothing, RDP_AUD_Nothing, RDP_AUD_Nothing,
	RDP_AUD_Nothing, RDP_AUD_Nothing, RDP_AUD_Nothing, RDP_AUD_Nothing,
	RDP_AUD_Nothing, RDP_AUD_Nothing, RDP_AUD_Nothing, RDP_AUD_Nothing,
	RDP_AUD_Nothing, RDP_AUD_Nothing, RDP_AUD_Nothing, RDP_AUD_Nothing,
	RDP_AUD_Nothing, RDP_AUD_Nothing, RDP_AUD_Nothing, RDP_AUD_Nothing,
	RDP_AUD_Nothing, RDP_AUD_Nothing, RDP_AUD_Nothing, RDP_AUD_Nothing,
	RDP_AUD_Nothing, RDP_AUD_Nothing, RDP_AUD_Nothing, RDP_AUD_Nothing,
	RDP_AUD_Nothing, RDP_AUD_Nothing, RDP_AUD_Nothing, RDP_AUD_Nothing,
	RDP_AUD_Nothing, RDP_AUD_Nothing, RDP_AUD_Nothing, RDP_AUD_Nothing,
	RDP_AUD_Nothing, RDP_AUD_Nothing, RDP_AUD_Nothing, RDP_AUD_Nothing,
	RDP_AUD_Nothing, RDP_AUD_Nothing, RDP_AUD_Nothing, RDP_AUD_Nothing,
	RDP_AUD_Nothing, RDP_AUD_Nothing, RDP_AUD_Nothing, RDP_AUD_Nothing,
	RDP_AUD_Nothing, RDP_AUD_Nothing, RDP_AUD_Nothing, RDP_AUD_Nothing,
	RDP_AUD_Nothing, RDP_AUD_Nothing, RDP_AUD_Nothing, RDP_AUD_Nothing,
	RDP_AUD_Nothing, RDP_AUD_Nothing, RDP_AUD_Nothing, RDP_AUD_Nothing,
	RDP_AUD_Nothing, RDP_AUD_Nothing, RDP_AUD_Nothing, RDP_AUD_Nothing,

	RDP_AUD_Nothing, RDP_AUD_Nothing, RDP_AUD_Nothing, RDP_AUD_Nothing,
	RDP_AUD_Nothing, RDP_AUD_Nothing, RDP_AUD_Nothing, RDP_AUD_Nothing,
	RDP_AUD_Nothing, RDP_AUD_Nothing, RDP_AUD_Nothing, RDP_AUD_Nothing,
	RDP_AUD_Nothing, RDP_AUD_Nothing, RDP_AUD_Nothing, RDP_AUD_Nothing,
	RDP_AUD_Nothing, RDP_AUD_Nothing, RDP_AUD_Nothing, RDP_AUD_Nothing,
	RDP_AUD_Nothing, RDP_AUD_Nothing, RDP_AUD_Nothing, RDP_AUD_Nothing,
	RDP_AUD_Nothing, RDP_AUD_Nothing, RDP_AUD_Nothing, RDP_AUD_Nothing,
	RDP_AUD_Nothing, RDP_AUD_Nothing, RDP_AUD_Nothing, RDP_AUD_Nothing,
	RDP_AUD_Nothing, RDP_AUD_Nothing, RDP_AUD_Nothing, RDP_AUD_Nothing,
	RDP_AUD_Nothing, RDP_AUD_Nothing, RDP_AUD_Nothing, RDP_AUD_Nothing,
	RDP_AUD_Nothing, RDP_AUD_Nothing, RDP_AUD_Nothing, RDP_AUD_Nothing,
	RDP_AUD_Nothing, RDP_AUD_Nothing, RDP_AUD_Nothing, RDP_AUD_Nothing,
	RDP_AUD_Nothing, RDP_AUD_Nothing, RDP_AUD_Nothing, RDP_AUD_Nothing,
	RDP_AUD_Nothing, RDP_AUD_Nothing, RDP_AUD_Nothing, RDP_AUD_Nothing,
	RDP_AUD_Nothing, RDP_AUD_Nothing, RDP_AUD_Nothing, RDP_AUD_Nothing,
	RDP_AUD_Nothing, RDP_AUD_Nothing, RDP_AUD_Nothing, RDP_AUD_Nothing,
};

void RDP_Aud_DumpRSPCode(FILE * fp, DWORD * pBase, DWORD dwPCBase, DWORD dwLen)
{
	char opinfo[400];

	DWORD dwIndex;
	for (dwIndex = 0; dwIndex < dwLen; dwIndex+=4) {
		DWORD dwOpCode;
		DWORD pc = dwIndex&0x0FFF;
		dwOpCode = pBase[dwIndex/4];

		SprintRSPOpCodeInfo(opinfo, pc + dwPCBase, dwOpCode);

		fprintf(fp, "0x%08x: <0x%08x> %s\n", pc + dwPCBase, dwOpCode, opinfo);
	}

}

void RDP_Aud_DumpData(FILE * fp, DWORD * pBase, DWORD dwPCBase, DWORD dwLen)
{
	DWORD dwIndex;
	for (dwIndex = 0; dwIndex < dwLen; dwIndex+=4) {

		DWORD dwData = pBase[dwIndex/4];
		fprintf(fp, "0x%08x: 0x%08x\n", dwIndex + dwPCBase, dwData);
	}

}


void RDP_Aud_DumpTask(OSTask * pTask)
{
	FILE * fp;
	TCHAR szFilePath[MAX_PATH+1];

	Dump_GetDumpDirectory(szFilePath, TEXT(""));
	PathAppend(szFilePath, TEXT("aud_task_dump.txt"));

	fp = fopen(szFilePath, "w");
	if (fp == NULL)
		return;

	fprintf(fp, "Task:\n");
	fprintf(fp, " Type:0x%08x Flags:0x%08x BootCode:0x%08x BootCodeSize:0x%08x\n",
		pTask->t.type, pTask->t.flags, pTask->t.ucode_boot, pTask->t.ucode_boot_size);
	fprintf(fp, " uCode:0x%08x uCodeSize:0x%08x uCodeData:0x%08x uCodeDataSize:0x%08x\n",
		pTask->t.ucode, pTask->t.ucode_size, pTask->t.ucode_data, pTask->t.ucode_data_size);
	fprintf(fp, " Stack:0x%08x StackSize:0x%08x OutputBuff:0x%08x OutputBuffSize:0x%08x\n",
		pTask->t.dram_stack, pTask->t.dram_stack_size, pTask->t.output_buff, pTask->t.output_buff_size);
	fprintf(fp, " Data(PC):0x%08x DataSize:0x%08x YieldData:0x%08x YieldDataSize:0x%08x\n",
		pTask->t.data_ptr, pTask->t.data_size, pTask->t.yield_data_ptr, pTask->t.yield_data_size);

	fprintf(fp, "uCode Boot:\n\n");

	RDP_Aud_DumpRSPCode(fp, (DWORD*)(g_pu8RamBase + (((u32)pTask->t.ucode_boot)&0x00FFFFFF)),
		0x04001000, pTask->t.ucode_boot_size);

	fprintf(fp, "\nuCode:\n\n");

	RDP_Aud_DumpRSPCode(fp, (DWORD*)(g_pu8RamBase + (((u32)pTask->t.ucode)&0x00FFFFFF)),
		0x04001080, 0x0f7f);//pTask->t.ucode_size);

	fprintf(fp, "\nuCodeData:\n\n");
	
	RDP_Aud_DumpData(fp, (DWORD*)(g_pu8RamBase + (((u32)pTask->t.ucode_data)&0x00FFFFFF)),
		0x04000000, pTask->t.ucode_data_size);

	fclose(fp);

}


void RDP_AUD_ExecuteTask(OSTask * pTask)
{
	DWORD dwTask = pTask->t.type;

	DPF(DEBUG_DP_AUD, "####################################################");
	DPF(DEBUG_DP_AUD, "DP: Firing up RDP/AUDIO!");

	//RDP_Aud_DumpTask(pTask);
	
	Memory_DPC_SetRegister(DPC_CURRENT_REG, (u32)pTask->t.data_ptr);


	DWORD dwPC = (u32)pTask->t.data_ptr;
	DWORD dwTaskSize = pTask->t.data_size;

	DPF(DEBUG_DP_AUD, "Task: 0x%08x, %d", dwPC, dwTaskSize);
	DPF(DEBUG_DP_AUD, "Task: 0x%08x, %d", dwPC, dwTaskSize);

	while (dwTaskSize != 0)
	{		
		g_dwCmd0			= *(DWORD *)(g_pu8RamBase + dwPC+0);
		g_dwCmd1			= *(DWORD *)(g_pu8RamBase + dwPC+4);

		Memory_DPC_SetRegister(DPC_CURRENT_REG, dwPC + 8);
		dwPC = dwPC + 8;
		
		AUDInstruction[g_dwCmd0>>24]();
		// Check if we're at the end of the task
		
		dwTaskSize -= 8;

	}

	DPF(DEBUG_DP_AUD, "DP: RDP/AUDIO done!");

}



////////////////////////////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////////////////////////
//#define RDP_NOEXIST() { MessageBox(g_hMainWindow, "RDP: Instruction Unknown", g_szDaedalusName, MB_OK); RDPHalt(); }
#define RDP_NOIMPL(op) { MessageBox(g_hMainWindow, "RDP: Instruction Not Implemented", op, MB_OK); }

void RDP_AUD_Nothing()		{ DBGConsole_Msg(DEBUG_DP_AUD, "AUDTASK Unknown: Cmd0:0x%08x Cmd1:0x%08x", g_dwCmd0, g_dwCmd1);/*RDP_NOEXIST();*/}
void RDP_AUD_SPNOOP()		{ }
void RDP_AUD_PoleF()		{ RDP_NOIMPL("RDP: PoleF"); }


#define AUD_MEM_OFFSET 0x5c0
#define AUD_ADPCM_OFFSET 0x4c0

WORD g_pAudBuff[0x1000/2];

void RDP_AUD_Segment()
{
	
	DWORD dwSegment = (g_dwCmd1>>24)&0xFF;
	DWORD dwBase    = (g_dwCmd1)&0x00FFFFFF;
	
	DPF(DEBUG_DP_AUD, "Segment:     Seg[%02d] = 0x%08x", dwSegment, dwBase);

	g_dwAudSegment[dwSegment&0x0F] = dwBase;

}

void RDP_AUD_SetBuff()
{
	g_dwAFlags = (g_dwCmd0>>16)&0xFF;							// Flags

	// e.g.
	if (g_dwAFlags & A_AUX)
	{
		g_dwAIn2    = ((g_dwCmd0    )&0xFFFF)+AUD_MEM_OFFSET;		// DMEMIn
		g_dwAOut2   = ((g_dwCmd1>>16)&0xFFFF)+AUD_MEM_OFFSET;		// DMEMOut
		g_dwACount2 = (g_dwCmd1     )&0xFFFF+AUD_MEM_OFFSET;		// Count

		DPF(DEBUG_DP_AUD, "SetBuffer:   Flags:0x%02x In2:0x%04x Out2:0x%04x Count2:0x%04x",
			g_dwAFlags, g_dwAIn2-AUD_MEM_OFFSET, g_dwAOut2-AUD_MEM_OFFSET, g_dwACount2-AUD_MEM_OFFSET);

	}
	else
	{
		g_dwAIn    = ((g_dwCmd0    )&0xFFFF)+AUD_MEM_OFFSET;		// DMEMIn
		g_dwAOut   = ((g_dwCmd1>>16)&0xFFFF)+AUD_MEM_OFFSET;		// DMEMOut
		g_dwACount = (g_dwCmd1     )&0xFFFF;						// Count

		DPF(DEBUG_DP_AUD, "SetBuffer:   0x%04x -> 0x%04x (0x%04x) (Flags:0x%02x)",
			g_dwAIn-AUD_MEM_OFFSET, g_dwAOut-AUD_MEM_OFFSET, g_dwACount, g_dwAFlags);
	}

	// Need to check flags - A_AUX..
}


void RDP_AUD_SetVol() {

	DWORD dwF = (g_dwCmd0 >> 16) & 0x00FF;		// Flags?. Abi.h sugests 16-bit. I don't think so as it will conflict with cmd...
	DWORD dwV = (g_dwCmd0      ) & 0xFFFF;		// ??
	DWORD dwT = (g_dwCmd1 >> 16) & 0xFFFF;		// ??
	DWORD dwR = (g_dwCmd1      ) & 0xFFFF;		// ??

	DPF(DEBUG_DP_AUD, "SetVol:      F: 0x%02x V: 0x%04x T: 0x%04x R: 0x%04x", dwF,dwV,dwT,dwR);

	if (dwF & A_AUX)		// A_AUX = 0x08
	{
		// Store dwV in 0x1c
		// Store dwR in 0x1e
	}
	else
	{
		if (dwF & A_VOL)		// A_VOL = 0x04
		{
			if (dwF & A_LEFT)	// A_LOOP = 0x02
			{
				// Store dwV in 0x06
			} else {
				// Store dwV in 0x08
			}
		} else {
			if (dwF & A_LOOP)	// A_LEFT? = 0x02
			{
				// Store dwV in 0x10 // Loop
				// Store dwT in 0x12
				//g_dwALoop = (dwV<<16) | dwT;
			//	DBGConsole_Msg(0, "Setting vol/loop to 0x%08x", (dwV<<16) | dwT);
			//	DPF(DEBUG_DP_AUD, "    Vol/Loop: 0x%08x", (dwV<<16) | dwT);

				// Store dwR in 0x14
			} else {
				// Store dwV in 0x16
				// Store dwT in 0x18
				// Store dwR in 0x1a
			}
		}
	}

}

void RDP_AUD_SetLoop()
{ 

	DWORD dwS = AUDSegAddr(g_dwCmd1);

	g_dwALoop = dwS;

	DBGConsole_Msg(0, "Setting loop to 0x%08x", g_dwALoop);
	DPF(DEBUG_DP_AUD, "SetLoop: 0x%08x", g_dwALoop);


}


void RDP_AUD_ClearBuff()
{

	DWORD dwDest  = ((g_dwCmd0)&0x0000FFFF)+AUD_MEM_OFFSET;		// Dest?
	DWORD dwCount =  (g_dwCmd1)&0x0000FFFF;						// Count?

	DPF(DEBUG_DP_AUD, "ClearBuffer: 0x%08x (0x%08x)", dwDest-AUD_MEM_OFFSET, dwCount);

	WORD *pDst = g_pAudBuff;

	// Check for potential buffer overruns here
	for (DWORD dwI = 0; dwI < dwCount; dwI+=2) {
		pDst[((dwI + dwDest)^0x2)/2] = 0;
	}
}


void RDP_AUD_LoadBuff()
{
	DWORD dwSrcOffset = AUDSegAddr(g_dwCmd1);

	DPF(DEBUG_DP_AUD, "LoadBuffer:  0x%04x (0x%04x) <- 0x%08x",
		g_dwAIn-AUD_MEM_OFFSET, g_dwACount, dwSrcOffset);

	// So, copy g_dwACount bytes from RD_RAM+dwS -> DMEM + g_dwAIn
	WORD *pDst = g_pAudBuff;
	WORD *pSrc = g_pu16RamBase;

	for (DWORD dwI = 0; dwI < g_dwACount; dwI+=2)
	{
		pDst[((dwI + g_dwAIn)^0x2)/2] = pSrc[((dwI + dwSrcOffset)^0x2)/2];
	}

}

void RDP_AUD_SaveBuff()
{
	DWORD dwSrcOffset = AUDSegAddr(g_dwCmd1);

	DPF(DEBUG_DP_AUD, "SaveBuffer:  0x%04x (0x%04x) -> 0x%08x",
		g_dwAOut-AUD_MEM_OFFSET, g_dwACount, dwSrcOffset);

	// So, copy g_dwACount bytes from RD_RAM+dwS -> DMEM + g_dwAIn
	WORD *pSrc = g_pAudBuff;
	WORD *pDst = g_pu16RamBase;

	for (DWORD dwI = 0; dwI < g_dwACount; dwI+=2)
	{
		pDst[((dwI + dwSrcOffset)^0x2)/2] = pSrc[((dwI + g_dwAOut)^0x2)/2];
	}
}

void RDP_AUD_LoadADPCM()
{
	DWORD dwCount = g_dwCmd0 & 0x0000FFFF;
	DWORD dwSrcOffset = AUDSegAddr(g_dwCmd1);

	DPF(DEBUG_DP_AUD, "LoadADPCM:   0x%08x (%d bytes) ", dwSrcOffset, dwCount);

	if (dwCount & 0x3 != 0)
		DBGConsole_Msg(0, "ADPCM Buffer is not multiple of 4 bytes long!");

	// So, copy g_dwACount bytes from RD_RAM+dwS -> DMEM + g_dwAIn
	DWORD *pDst = (DWORD *)((BYTE *)g_pAudBuff + AUD_ADPCM_OFFSET);
	DWORD *pSrc = (DWORD *)(g_pu8RamBase + dwSrcOffset);

	for (DWORD dwI = 0; dwI < dwCount/4; dwI++)
	{
		pDst[dwI] = pSrc[dwI];

		//DPF(DEBUG_DP_AUD, "  0x%08x: 0x%08x", dwSrcOffset + dwI*4, pSrc[dwI]);
		//DBGConsole_Msg(0, "  0x%08x: 0x%08x", dwSrcOffset + dwI*4, pSrc[dwI]);
	}
}


// 
/*DPF(DEBUG_DP_AUD, "  Input:");
char str[300] = "";
char bit[300];
for (i = 0; i < 8*9; i++)
{
	BYTE b = ((BYTE *)g_pAudBuff)[g_dwAIn + i ^ 0x3];
	if (i%9 == 0)
	{
		DPF(DEBUG_DP_AUD, str);

		wsprintf(str, "");
	}

	wsprintf(bit, " 0x%02x ", b);
	lstrcat(str, bit);

}
DPF(DEBUG_DP_AUD, str);*/

void RDP_AUD_ADPCM() {

	DWORD dwFlags = (g_dwCmd0>>16) & 0xFF;
	DWORD dwS = g_dwCmd1;
	DWORD dwSrcOffset = AUDSegAddr(dwS);
	DWORD i;

	DPF(DEBUG_DP_AUD, "ADPCMdec:    0x%04x -> 0x%04x (0x%04x) State: 0x%08x (Flags: 0x%02x )",
		g_dwAIn-AUD_MEM_OFFSET, g_dwAOut-AUD_MEM_OFFSET, g_dwACount, dwSrcOffset, dwFlags);


	SHORT * pState = (SHORT *)(g_pu8RamBase + dwSrcOffset);

	//DPF(DEBUG_DP_AUD, "State:");
	//for (DWORD n = 0; n < 16; n++)
	//	DPF(DEBUG_DP_AUD, "0x%04x", pState[n]);


	//DPF(DEBUG_DP_AUD, "  State:");
	//DPF(DEBUG_DP_AUD, "  0x%08x 0x0%08x", pState[0], pState[1]);


	DWORD dwBlocks = (g_dwACount + 31)/32;

	//DPF(DEBUG_DP_AUD, "  Processing %d bytes (%d blocks)", g_dwACount, dwBlocks);

	DWORD dwIn = g_dwAIn;

	SHORT * pOut = (SHORT*)&g_pAudBuff[g_dwAOut>>1];

	// Initialise or restore the state
	if (dwFlags & A_INIT)
	{
		// Clear state..check we don't need to fiddle offsets..
		memset(pOut, 0, 32);
	}
	else
	{

		if (dwFlags & A_LOOP)
		{
			// Use value set in SetVol for loop address
			pState = (SHORT *)(g_pu8RamBase + g_dwALoop);
			dwSrcOffset = g_dwALoop;
		}
		else if (dwFlags != 0)
			DBGConsole_Msg(0, "ADPCMDEc with flags != A_INIT or 0 (0x%08x)", dwFlags);
		
		// Load state from pState into pSamples
		memcpy(pOut, pState, 32);
	}

	pOut += 16;		// Skip state
	for (i = 0; i < dwBlocks; i++)
	{
		DecodeBlock(pOut, dwIn, 4);

		//for (DWORD n = 0; n < 16; n++)
		//	DPF(DEBUG_DP_AUD, "0x%04x", pOut[n]);

		dwIn += 9;
		pOut += 16;
	}

	// Save state...save PREVIOUS samples
	memcpy(pState, pOut - 16, 32);
	{
		FILE * fp;
		TCHAR szFileName[MAX_PATH+1];
		TCHAR szFilePath[MAX_PATH+1];

		//static DWORD c = 0;
		pOut = (SHORT*)&g_pAudBuff[g_dwAOut>>1];

		//c++;
		//if (c & 1)
		{
			Dump_GetDumpDirectory(szFilePath, TEXT("adpcm_dumps"));
			wsprintf(szFileName, TEXT("adpcm_0x%08x.raw"), dwSrcOffset);
			PathAppend(szFilePath, szFileName);

			fp = fopen(szFilePath, "ab");
			if (fp)
			{
				//static const WORD szMax[4] = { 0x7fff, 0x7fff, 0x7fff, 0x7fff};
				//fwrite(szMax, 2, 4, fp);
				/*fwrite(szMax, 2, 4, fp);
				fwrite(szMax, 2, 4, fp);
				fwrite(szMax, 2, 4, fp);*/
				fwrite(pOut+16,1, g_dwACount, fp);// 2, (dwBlocks)*16, fp);
				fclose(fp);
			}
		}

	}


}

// pCurrent - The current output buffer
// dwIn - The input codes offset (we pass in an offset and not a 
//        pointer because we need to fuddle the order
void DecodeBlock(SHORT * pCurrent, DWORD dwIn, DWORD dwBitsPerCode)
{
	LONG nSamp2;
	LONG nSamp1;
	LONG nA, nB;
	BYTE ucControl;
	DWORD dwDecodeSelect;
	DWORD dwShift;
	DWORD n;

	BYTE * pInBase = (BYTE *)g_pAudBuff;
	SHORT * pADPCMData = (SHORT *)((BYTE *)g_pAudBuff + AUD_ADPCM_OFFSET);

	
	ucControl = pInBase[dwIn ^ 0x3];
	dwIn++;

	DPF(DEBUG_DP_AUD, "  Control byte is 0x%02x", ucControl);

	dwDecodeSelect = (ucControl&0xf)<<4;
	if (dwDecodeSelect > 0x70)
	{
		DPF(DEBUG_DP_AUD, "    Block Selector is 0x%02x - too large?", dwDecodeSelect);
		DBGConsole_Msg(0, "Decode Selector is > 112");
		return;
	}
	else
	{
		//DPF(DEBUG_DP_AUD, "    Block Selector is 0x%02x", dwDecodeSelect);
	}
	dwShift = (((s32)(s8)ucControl>>4) + 0x0b) - 2;
	//DPF(DEBUG_DP_AUD, "    Base is 0x%08x", dwShift);
	

	// Not sure why these are divided by two
	nA = pADPCMData[(dwDecodeSelect * 2 +  0) ^ 0x1] / 2;
	nB = pADPCMData[(dwDecodeSelect * 2 +  8) ^ 0x1] / 2;
	//DPF(DEBUG_DP_AUD, "    A = 0x%08x, B = 0x%08x", nA, nB);

	nSamp2 = pCurrent[-2];			// Initialize the previous samples
	nSamp1 = pCurrent[-1];
	//DPF(DEBUG_DP_AUD, "    S-2 = 0x%08x, S-1 = 0x%08x", nSamp2, nSamp1);
	for (n = 0; n < 16; n++)
	{
		LONG nibble;
		LONG nOutput, nFacA, nFacB;

		if ((n & 0x1) == 0)		// Even byte = get top nibble
		{	
			nibble = (pInBase[dwIn ^ 0x3]) << 24;;
		}
		else					// Odd byte = get bottom nibble
		{
			nibble = (pInBase[dwIn ^ 0x3]) << 28;
			dwIn++;		// Increment now...
		}

		nibble >>= 28;
		//DPF(DEBUG_DP_AUD, "   Nibble%02d: 0x%08x", n, nibble);

		nFacA = nSamp2 * nA;
		nFacB = nSamp1 * nB;

		nOutput = ((nibble << dwShift) + nFacA + nFacB) >> 10;

		if (nOutput < -0x7FFF)
		{
			DBGConsole_Msg(0, "Overflow -ve");
			nOutput = -0x7FFF;
		}
		else if (nOutput > 0x7FFF)
		{
			DBGConsole_Msg(0, "Overflow +ve");
			nOutput = 0x7FFF;
		}

		//DPF(DEBUG_DP_AUD, "   Output : 0x%08x = (0x%08x + 0x%08x + 0x%08x)>>10",
		//	nOutput, nibble<<dwShift, nFacA, nFacB);

		nSamp2 = nSamp1;
		nSamp1 = nOutput;

		pCurrent[n] = (SHORT)nOutput;
	}
}





void RDP_AUD_DMEMMove()
{
	DWORD dwFlags = (g_dwCmd0>>16)&0xFF;
	DWORD dwIn    = ((g_dwCmd0    )&0xFFFF)+AUD_MEM_OFFSET;		// DMEM In
	DWORD dwOut   = ((g_dwCmd1>>16)&0xFFFF)+AUD_MEM_OFFSET;		// DMEM Out
	DWORD dwCount = (g_dwCmd1    )&0xFFFF;				// Count

	DPF(DEBUG_DP_AUD, "DMEMMove:    0x%04x -> 0x%04x (0x%04x)", dwIn-AUD_MEM_OFFSET, dwOut-AUD_MEM_OFFSET, dwCount);

	for (DWORD dwI = 0; dwI < dwCount; dwI+=2)
	{
		g_pAudBuff[((dwI + dwOut)^0x2)/2] = g_pAudBuff[((dwI + dwIn)^0x2)/2];

		//DPF(DEBUG_DP_AUD, "[0x%04x] <- [0x%04x]", (((dwI + dwOut)^0x2)/2)*2,(((dwI + dwIn)^0x2)/2)*2);
	}
}

void RDP_AUD_Mixer() {

	DWORD dwF = (g_dwCmd0>>16)&0xFF;		// Flags
	DWORD dwGain = (g_dwCmd0    )&0xFFFF;	// Gain

	DWORD dwIn  = ((g_dwCmd1>>16)&0xFFFF)+AUD_MEM_OFFSET;	// DMEM In
	DWORD dwOut = ((g_dwCmd1    )&0xFFFF)+AUD_MEM_OFFSET;	// DMEM Out

	DPF(DEBUG_DP_AUD, "Mixer:       Flags:0x%02x Gain:0x%04x In:0x%04x Out:0x%04x", dwF, dwGain, dwIn-AUD_MEM_OFFSET, dwOut-AUD_MEM_OFFSET);

	// Flags seem to be ignored

	// Basic algorithm is:
	// source = (source*0x7fff/0x10000) + (dest*gain/0x10000);

	WORD *pDst = (WORD *)g_pAudBuff;
	WORD *pSrc = (WORD *)g_pAudBuff;

	for (DWORD dwI = 0; dwI < g_dwACount; dwI+=2) {	// Inc by 2 as we're operating on 16 bits at a time
		pDst[((dwI+dwOut)^0x2)/2] = (WORD)((pDst[((dwI + dwOut)^0x2)/2]*0x7FFF)/0x10000 +
								           (pSrc[((dwI + dwIn )^0x2)/2]*dwGain)/0x10000);
	}

}

void RDP_AUD_EnvMixer()
{
	DWORD dwF = (g_dwCmd0 >> 16) & 0xFF;		// Flags?
	DWORD dwS = g_dwCmd1;						// ?
	
	//dwS is the segment/offset
	DPF(DEBUG_DP_AUD, "EnvMixer:    F: 0x%02x S: 0x%08x", dwF, dwS); 

}

void RDP_AUD_Interleave()
{
	DWORD dwL = ((g_dwCmd1>>16)&0xFFFF);	// In Left
	DWORD dwR = ((g_dwCmd1    )&0xFFFF);	// In Right

	DPF(DEBUG_DP_AUD, "Interleave:  0x%04x,x%04x -> 0x%04x (0x%04x)",
		dwL, dwR, g_dwAOut-AUD_MEM_OFFSET, g_dwACount);

	// Read from L write to Out.
	// Read from R, write to Out

	DWORD dwOut = g_dwAOut - AUD_MEM_OFFSET;
	
	WORD *pDMem  = (WORD *)&g_pAudBuff[AUD_MEM_OFFSET/2];

	for (DWORD dwI = 0; dwI < g_dwACount; dwI+=2) {
		pDMem[((dwI*2 +dwOut+0)^0x2)/2] = pDMem[((dwI + dwL)^0x2)/2];
		pDMem[((dwI*2 +dwOut+1)^0x2)/2] = pDMem[((dwI + dwR)^0x2)/2];
	}
}

void RDP_AUD_Resample()
{
	DWORD dwF = ((g_dwCmd0>>16)&0xFF);		// Flags?
	DWORD dwP = ((g_dwCmd0    )&0xFFFF);	// Pitch
	DWORD dwS =   g_dwCmd1;					// ?

	DPF(DEBUG_DP_AUD, "Resample:    F: 0x%02x P: 0x%04x S: 0x%08x", dwF, dwP, dwS);
}


void RDP_AUD_LoadADPCMBuffer()
{
	DPF(DEBUG_DP_AUD, "LoadADPCMBuffer?");
}


void RDP_AUD_SaveADPCMBuffer()
{
	DPF(DEBUG_DP_AUD, "SaveADPCMBuffer?");
}
/*
void Outer(DWORD dwMem, DWORD dw3F0, DWORD dwStart, DWORD dwLen, DWORD dwFlags, BYTE * pAudBuff)
{
	dwStart = (dwStart>>1)<<1;	// Make even

	dwBlocks = (dwLen+31)/32;
	
	Wibble(dwStart, dwMem, dwFlags, pAudBuff);

	if (dwFlags & A_VOL)
	{
		00545FB2:
		if (dwBlocks == 0)
		{

		}

	}
	else
	{
00545FF4   mov         edx,ebp
00545FF7   test        edx,edx
00545FF9   je          00546038
		if (dwBlocks == 0)
		{


		}
		else
		{
			ebx = (dwStart/2) + 16;
00545FFC   mov         dword ptr [esp+1Ch],ebp		// Save blocks
00546000   shl         ebp,4						// Mult by 16

		edi = pAudBuf + ebx*2;

		ebx += ebp

00546003   lea         edi,[esi+ebx*2]
00546006   add         ebx,ebp
00546008   mov         ebp,dword ptr [esp+18h]

0054600C   push        esi
0054600D   push        4
0054600F   lea         ecx,[esi+1000h]
00546015   push        ecx
00546016   push        ebp
00546017   push        eax
00546018   push        edi
00546019   call        00545D60
0054601E   mov         ecx,dword ptr [esp+34h]
00546022   mov         eax,edi
00546024   add         esp,18h
00546027   add         ebp,9
0054602A   add         edi,20h
0054602D   dec         ecx
0054602E   mov         dword ptr [esp+1Ch],ecx
00546032   jne         0054600C
00546034   mov         edi,dword ptr [esp+20h]

00546038   mov         edx,dword ptr [esp+24h]
0054603C   mov         eax,dword ptr [esp+14h]
00546040   push        esi
00546041   push        edx
00546042   push        eax
00546043   mov         dword ptr [esi+2278h],eax
00546049   lea         eax,[ebx+ebx-20h]
0054604D   lea         ecx,[ebx+ebx]
00546050   push        eax
00546051   mov         dword ptr [esi+2280h],edi
00546057   mov         dword ptr [esi+227Ch],ecx
0054605D   call        00545CF0
00546062   add         esp,10h
00546065   pop         edi
00546066   pop         esi
00546067   pop         ebp
00546068   pop         ebx
00546069   ret

	}

}

void Wibble(DWORD dwStart, DWORD dwMem, DWORD dwFlags, BYTE * pAudBuff)
{
	if (dwFlags & A_INIT)
	{
		if (dwStart >= 0x1000)
			return;

		DWORD dwEnd = dwStart + 32;
		if (dwEnd > 0x1000)
			return;

		memset(pAudBuff + ((dwStart>>1)<<1), 0, 32);
	}
	else
	{
		if (dwFlags & A_LOOP)
		{

		}
	}

}

void Decompress(WORD * pCurrent, WORD * pPrev, DWORD dwCodes, 
				BYTE * pBuffEnd, DWORD dwNumToProcess, WORD * pAudBuff)
{
	BYTE aucCodes[10];
	DWORD dwIndex;

	if (dwNumToProsses == 4)
		dwBytes = 9;
	else dwBytes = 5;

//	//dwIndex = 0;
//	if (dwCodes & 0x1)
//	{
//		// Odd
//		ucCodes[0] = *(BYTE *)pAudBuff + dwCodes/2
//		dwIndex++;
//	}
//
	// Now copy until dwIndex == dwBytes...


	DWORD dwControl = aucCodes[0];

	DWORD dwBottom = dwControl & 0xf;
	DWORD dwTop = dwControl >> 4;

	dwBottom <<= 4;

	dwTop += 0xb;

	if (dwBottom > 0x70)
	{
		dwNumToProcess |= 0x100;
	}
	else
	{
		// Load from memory
	}

	dwTop -= 2;
}		*/