/*
Copyright (C) 2001 StrmnNrmn

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

*/

// Code to format opcodes and display them nicely
#include "stdafx.h"

#include "OpCode.h"
#include "Registers.h"
#include "Memory.h"

#include "patch.h"		// For Definition of GetCorrectOp

static const char * g_szVSelName[16] =
{
	"0a",
	"??",
	"0q?",
	"1q",
	"0h",
	"1h?",
	"2h",
	"3h?",
	"0 ",
	"1 ",
	"2 ",
	"3 ",
	"4 ",
	"5 ",
	"6 ",
	"7 "
};


static void SprintOp_Unk(char * str, DWORD dwAddr, DWORD dwOp);

static void SprintOp_Special(char * str, DWORD dwAddr, DWORD dwOp);
static void SprintOp_RegImm(char * str, DWORD dwAddr, DWORD dwOp);
static void SprintOp_J(char * str, DWORD dwAddr, DWORD dwOp);
static void SprintOp_JAL(char * str, DWORD dwAddr, DWORD dwOp);
static void SprintOp_BEQ(char * str, DWORD dwAddr, DWORD dwOp);
static void SprintOp_BNE(char * str, DWORD dwAddr, DWORD dwOp);
static void SprintOp_BLEZ(char * str, DWORD dwAddr, DWORD dwOp);
static void SprintOp_BGTZ(char * str, DWORD dwAddr, DWORD dwOp);
static void SprintOp_ADDI(char * str, DWORD dwAddr, DWORD dwOp);
static void SprintOp_ADDIU(char * str, DWORD dwAddr, DWORD dwOp);
static void SprintOp_SLTI(char * str, DWORD dwAddr, DWORD dwOp);
static void SprintOp_SLTIU(char * str, DWORD dwAddr, DWORD dwOp);
static void SprintOp_ANDI(char * str, DWORD dwAddr, DWORD dwOp);
static void SprintOp_ORI(char * str, DWORD dwAddr, DWORD dwOp);
static void SprintOp_XORI(char * str, DWORD dwAddr, DWORD dwOp);
static void SprintOp_LUI(char * str, DWORD dwAddr, DWORD dwOp);
static void SprintOp_CoPro0(char * str, DWORD dwAddr, DWORD dwOp);
static void SprintOp_CoPro1(char * str, DWORD dwAddr, DWORD dwOp);
static void SprintOp_UnOpt(char * str, DWORD dwAddr, DWORD dwOp);
static void SprintOp_Opt(char * str, DWORD dwAddr, DWORD dwOp);
static void SprintOp_NoOpt(char * str, DWORD dwAddr, DWORD dwOp);
static void SprintOp_BEQL(char * str, DWORD dwAddr, DWORD dwOp);
static void SprintOp_BNEL(char * str, DWORD dwAddr, DWORD dwOp);
static void SprintOp_BLEZL(char * str, DWORD dwAddr, DWORD dwOp);
static void SprintOp_BGTZL(char * str, DWORD dwAddr, DWORD dwOp);
static void SprintOp_DADDI(char * str, DWORD dwAddr, DWORD dwOp);
static void SprintOp_DADDIU(char * str, DWORD dwAddr, DWORD dwOp);
static void SprintOp_LDL(char * str, DWORD dwAddr, DWORD dwOp);
static void SprintOp_LDR(char * str, DWORD dwAddr, DWORD dwOp);
static void SprintOp_Patch(char * str, DWORD dwAddr, DWORD dwOp);
static void SprintOp_LB(char * str, DWORD dwAddr, DWORD dwOp);
static void SprintOp_LH(char * str, DWORD dwAddr, DWORD dwOp);
static void SprintOp_LWL(char * str, DWORD dwAddr, DWORD dwOp);
static void SprintOp_LW(char * str, DWORD dwAddr, DWORD dwOp);
static void SprintOp_LBU(char * str, DWORD dwAddr, DWORD dwOp);
static void SprintOp_LHU(char * str, DWORD dwAddr, DWORD dwOp);
static void SprintOp_LWR(char * str, DWORD dwAddr, DWORD dwOp);
static void SprintOp_LWU(char * str, DWORD dwAddr, DWORD dwOp);
static void SprintOp_SB(char * str, DWORD dwAddr, DWORD dwOp);
static void SprintOp_SH(char * str, DWORD dwAddr, DWORD dwOp);
static void SprintOp_SWL(char * str, DWORD dwAddr, DWORD dwOp);
static void SprintOp_SW(char * str, DWORD dwAddr, DWORD dwOp);
static void SprintOp_SDL(char * str, DWORD dwAddr, DWORD dwOp);
static void SprintOp_SDR(char * str, DWORD dwAddr, DWORD dwOp);
static void SprintOp_SWR(char * str, DWORD dwAddr, DWORD dwOp);
static void SprintOp_CACHE(char * str, DWORD dwAddr, DWORD dwOp);
static void SprintOp_LL(char * str, DWORD dwAddr, DWORD dwOp);
static void SprintOp_LWC1(char * str, DWORD dwAddr, DWORD dwOp);
static void SprintOp_LLD(char * str, DWORD dwAddr, DWORD dwOp);
static void SprintOp_LDC1(char * str, DWORD dwAddr, DWORD dwOp);
static void SprintOp_LDC2(char * str, DWORD dwAddr, DWORD dwOp);
static void SprintOp_LD(char * str, DWORD dwAddr, DWORD dwOp);
static void SprintOp_SC(char * str, DWORD dwAddr, DWORD dwOp);
static void SprintOp_SWC1(char * str, DWORD dwAddr, DWORD dwOp);
static void SprintOp_SCD(char * str, DWORD dwAddr, DWORD dwOp);
static void SprintOp_SDC1(char * str, DWORD dwAddr, DWORD dwOp);
static void SprintOp_SDC2(char * str, DWORD dwAddr, DWORD dwOp);
static void SprintOp_SD(char * str, DWORD dwAddr, DWORD dwOp);



static void SprintOp_Special_Unk(char * str, DWORD dwAddr, DWORD dwOp);

static void SprintOp_Special_SLL(char * str, DWORD dwAddr, DWORD dwOp);
static void SprintOp_Special_SRL(char * str, DWORD dwAddr, DWORD dwOp);
static void SprintOp_Special_SRA(char * str, DWORD dwAddr, DWORD dwOp);
static void SprintOp_Special_SLLV(char * str, DWORD dwAddr, DWORD dwOp);
static void SprintOp_Special_SRLV(char * str, DWORD dwAddr, DWORD dwOp);
static void SprintOp_Special_SRAV(char * str, DWORD dwAddr, DWORD dwOp);
static void SprintOp_Special_JR(char * str, DWORD dwAddr, DWORD dwOp);
static void SprintOp_Special_JALR(char * str, DWORD dwAddr, DWORD dwOp);
static void SprintOp_Special_SYSCALL(char * str, DWORD dwAddr, DWORD dwOp);
static void SprintOp_Special_BREAK(char * str, DWORD dwAddr, DWORD dwOp);
static void SprintOp_Special_SYNC(char * str, DWORD dwAddr, DWORD dwOp);
static void SprintOp_Special_MFHI(char * str, DWORD dwAddr, DWORD dwOp);
static void SprintOp_Special_MTHI(char * str, DWORD dwAddr, DWORD dwOp);
static void SprintOp_Special_MFLO(char * str, DWORD dwAddr, DWORD dwOp);
static void SprintOp_Special_MTLO(char * str, DWORD dwAddr, DWORD dwOp);
static void SprintOp_Special_DSLLV(char * str, DWORD dwAddr, DWORD dwOp);
static void SprintOp_Special_DSRLV(char * str, DWORD dwAddr, DWORD dwOp);
static void SprintOp_Special_DSRAV(char * str, DWORD dwAddr, DWORD dwOp);
static void SprintOp_Special_MULT(char * str, DWORD dwAddr, DWORD dwOp);
static void SprintOp_Special_MULTU(char * str, DWORD dwAddr, DWORD dwOp);
static void SprintOp_Special_DIV(char * str, DWORD dwAddr, DWORD dwOp);
static void SprintOp_Special_DIVU(char * str, DWORD dwAddr, DWORD dwOp);
static void SprintOp_Special_DMULT(char * str, DWORD dwAddr, DWORD dwOp);
static void SprintOp_Special_DMULTU(char * str, DWORD dwAddr, DWORD dwOp);
static void SprintOp_Special_DDIV(char * str, DWORD dwAddr, DWORD dwOp);
static void SprintOp_Special_DDIVU(char * str, DWORD dwAddr, DWORD dwOp);
static void SprintOp_Special_ADD(char * str, DWORD dwAddr, DWORD dwOp);
static void SprintOp_Special_ADDU(char * str, DWORD dwAddr, DWORD dwOp);
static void SprintOp_Special_SUB(char * str, DWORD dwAddr, DWORD dwOp);
static void SprintOp_Special_SUBU(char * str, DWORD dwAddr, DWORD dwOp);
static void SprintOp_Special_AND(char * str, DWORD dwAddr, DWORD dwOp);
static void SprintOp_Special_OR(char * str, DWORD dwAddr, DWORD dwOp);
static void SprintOp_Special_XOR(char * str, DWORD dwAddr, DWORD dwOp);
static void SprintOp_Special_NOR(char * str, DWORD dwAddr, DWORD dwOp);
static void SprintOp_Special_SLT(char * str, DWORD dwAddr, DWORD dwOp);
static void SprintOp_Special_SLTU(char * str, DWORD dwAddr, DWORD dwOp);
static void SprintOp_Special_DADD(char * str, DWORD dwAddr, DWORD dwOp);
static void SprintOp_Special_DADDU(char * str, DWORD dwAddr, DWORD dwOp);
static void SprintOp_Special_DSUB(char * str, DWORD dwAddr, DWORD dwOp);
static void SprintOp_Special_DSUBU(char * str, DWORD dwAddr, DWORD dwOp);
static void SprintOp_Special_TGE(char * str, DWORD dwAddr, DWORD dwOp);
static void SprintOp_Special_TGEU(char * str, DWORD dwAddr, DWORD dwOp);
static void SprintOp_Special_TLT(char * str, DWORD dwAddr, DWORD dwOp);
static void SprintOp_Special_TLTU(char * str, DWORD dwAddr, DWORD dwOp);
static void SprintOp_Special_TEQ(char * str, DWORD dwAddr, DWORD dwOp);
static void SprintOp_Special_TNE(char * str, DWORD dwAddr, DWORD dwOp);
static void SprintOp_Special_DSLL(char * str, DWORD dwAddr, DWORD dwOp);
static void SprintOp_Special_DSRL(char * str, DWORD dwAddr, DWORD dwOp);
static void SprintOp_Special_DSRA(char * str, DWORD dwAddr, DWORD dwOp);
static void SprintOp_Special_DSLL32(char * str, DWORD dwAddr, DWORD dwOp);
static void SprintOp_Special_DSRL32(char * str, DWORD dwAddr, DWORD dwOp);
static void SprintOp_Special_DSRA32(char * str, DWORD dwAddr, DWORD dwOp);


static void SprintOp_RegImm_Unk(char * str, DWORD dwAddr, DWORD dwOp);

static void SprintOp_RegImm_BLTZ(char * str, DWORD dwAddr, DWORD dwOp);
static void SprintOp_RegImm_BGEZ(char * str, DWORD dwAddr, DWORD dwOp);
static void SprintOp_RegImm_BLTZL(char * str, DWORD dwAddr, DWORD dwOp);
static void SprintOp_RegImm_BGEZL(char * str, DWORD dwAddr, DWORD dwOp);

static void SprintOp_RegImm_TGEI(char * str, DWORD dwAddr, DWORD dwOp);
static void SprintOp_RegImm_TGEIU(char * str, DWORD dwAddr, DWORD dwOp);
static void SprintOp_RegImm_TLTI(char * str, DWORD dwAddr, DWORD dwOp);
static void SprintOp_RegImm_TLTIU(char * str, DWORD dwAddr, DWORD dwOp);
static void SprintOp_RegImm_TEQI(char * str, DWORD dwAddr, DWORD dwOp);
static void SprintOp_RegImm_TNEI(char * str, DWORD dwAddr, DWORD dwOp);
static void SprintOp_RegImm_BLTZAL(char * str, DWORD dwAddr, DWORD dwOp);
static void SprintOp_RegImm_BGEZAL(char * str, DWORD dwAddr, DWORD dwOp);
static void SprintOp_RegImm_BLTZALL(char * str, DWORD dwAddr, DWORD dwOp);
static void SprintOp_RegImm_BGEZALL(char * str, DWORD dwAddr, DWORD dwOp);


static void SprintOp_Cop0_Unk(char * str, DWORD dwAddr, DWORD dwOp);
static void SprintOp_Cop0_MFC0(char * str, DWORD dwAddr, DWORD dwOp);
static void SprintOp_Cop0_MTC0(char * str, DWORD dwAddr, DWORD dwOp);
static void SprintOp_Cop0_TLB(char * str, DWORD dwAddr, DWORD dwOp);

static void SprintOp_TLB_Unk(char * str, DWORD dwAddr, DWORD dwOp);
static void SprintOp_TLB_TLBR(char * str, DWORD dwAddr, DWORD dwOp);
static void SprintOp_TLB_TLBWI(char * str, DWORD dwAddr, DWORD dwOp);
static void SprintOp_TLB_TLBWR(char * str, DWORD dwAddr, DWORD dwOp);
static void SprintOp_TLB_TLBP(char * str, DWORD dwAddr, DWORD dwOp);
static void SprintOp_TLB_ERET(char * str, DWORD dwAddr, DWORD dwOp);

static void SprintOp_Cop1_Unk(char * str, DWORD dwAddr, DWORD dwOp);
static void SprintOp_Cop1_MFC1(char * str, DWORD dwAddr, DWORD dwOp);
static void SprintOp_Cop1_DMFC1(char * str, DWORD dwAddr, DWORD dwOp);
static void SprintOp_Cop1_CFC1(char * str, DWORD dwAddr, DWORD dwOp);
static void SprintOp_Cop1_MTC1(char * str, DWORD dwAddr, DWORD dwOp);
static void SprintOp_Cop1_DMTC1(char * str, DWORD dwAddr, DWORD dwOp);
static void SprintOp_Cop1_CTC1(char * str, DWORD dwAddr, DWORD dwOp);
static void SprintOp_Cop1_BCInstr(char * str, DWORD dwAddr, DWORD dwOp);
static void SprintOp_Cop1_SInstr(char * str, DWORD dwAddr, DWORD dwOp);
static void SprintOp_Cop1_DInstr(char * str, DWORD dwAddr, DWORD dwOp);
static void SprintOp_Cop1_WInstr(char * str, DWORD dwAddr, DWORD dwOp);
static void SprintOp_Cop1_LInstr(char * str, DWORD dwAddr, DWORD dwOp);


static void SprintOp_Cop1_S_Unk(char * str, DWORD dwAddr, DWORD dwOp);
static void SprintOp_Cop1_S_ADD(char * str, DWORD dwAddr, DWORD dwOp);
static void SprintOp_Cop1_S_SUB(char * str, DWORD dwAddr, DWORD dwOp);
static void SprintOp_Cop1_S_MUL(char * str, DWORD dwAddr, DWORD dwOp);
static void SprintOp_Cop1_S_DIV(char * str, DWORD dwAddr, DWORD dwOp);
static void SprintOp_Cop1_S_SQRT(char * str, DWORD dwAddr, DWORD dwOp);
static void SprintOp_Cop1_S_ABS(char * str, DWORD dwAddr, DWORD dwOp);
static void SprintOp_Cop1_S_MOV(char * str, DWORD dwAddr, DWORD dwOp);
static void SprintOp_Cop1_S_NEG(char * str, DWORD dwAddr, DWORD dwOp);
static void SprintOp_Cop1_S_ROUND_L(char * str, DWORD dwAddr, DWORD dwOp);
static void SprintOp_Cop1_S_TRUNC_L(char * str, DWORD dwAddr, DWORD dwOp);
static void SprintOp_Cop1_S_CEIL_L(char * str, DWORD dwAddr, DWORD dwOp);
static void SprintOp_Cop1_S_FLOOR_L(char * str, DWORD dwAddr, DWORD dwOp);
static void SprintOp_Cop1_S_ROUND_W(char * str, DWORD dwAddr, DWORD dwOp);
static void SprintOp_Cop1_S_TRUNC_W(char * str, DWORD dwAddr, DWORD dwOp);
static void SprintOp_Cop1_S_CEIL_W(char * str, DWORD dwAddr, DWORD dwOp);
static void SprintOp_Cop1_S_FLOOR_W(char * str, DWORD dwAddr, DWORD dwOp);
static void SprintOp_Cop1_S_CVT_D(char * str, DWORD dwAddr, DWORD dwOp);
static void SprintOp_Cop1_S_CVT_W(char * str, DWORD dwAddr, DWORD dwOp);
static void SprintOp_Cop1_S_CVT_L(char * str, DWORD dwAddr, DWORD dwOp);
static void SprintOp_Cop1_S_F(char * str, DWORD dwAddr, DWORD dwOp);
static void SprintOp_Cop1_S_UN(char * str, DWORD dwAddr, DWORD dwOp);
static void SprintOp_Cop1_S_EQ(char * str, DWORD dwAddr, DWORD dwOp);
static void SprintOp_Cop1_S_UEQ(char * str, DWORD dwAddr, DWORD dwOp);
static void SprintOp_Cop1_S_OLT(char * str, DWORD dwAddr, DWORD dwOp);
static void SprintOp_Cop1_S_ULT(char * str, DWORD dwAddr, DWORD dwOp);
static void SprintOp_Cop1_S_OLE(char * str, DWORD dwAddr, DWORD dwOp);
static void SprintOp_Cop1_S_ULE(char * str, DWORD dwAddr, DWORD dwOp);
static void SprintOp_Cop1_S_SF(char * str, DWORD dwAddr, DWORD dwOp);
static void SprintOp_Cop1_S_NGLE(char * str, DWORD dwAddr, DWORD dwOp);
static void SprintOp_Cop1_S_SEQ(char * str, DWORD dwAddr, DWORD dwOp);
static void SprintOp_Cop1_S_NGL(char * str, DWORD dwAddr, DWORD dwOp);
static void SprintOp_Cop1_S_LT(char * str, DWORD dwAddr, DWORD dwOp);
static void SprintOp_Cop1_S_NGE(char * str, DWORD dwAddr, DWORD dwOp);
static void SprintOp_Cop1_S_LE(char * str, DWORD dwAddr, DWORD dwOp);
static void SprintOp_Cop1_S_NGT(char * str, DWORD dwAddr, DWORD dwOp);

static void SprintOp_Cop1_D_Unk(char * str, DWORD dwAddr, DWORD dwOp);
static void SprintOp_Cop1_D_ADD(char * str, DWORD dwAddr, DWORD dwOp);
static void SprintOp_Cop1_D_SUB(char * str, DWORD dwAddr, DWORD dwOp);
static void SprintOp_Cop1_D_MUL(char * str, DWORD dwAddr, DWORD dwOp);
static void SprintOp_Cop1_D_DIV(char * str, DWORD dwAddr, DWORD dwOp);
static void SprintOp_Cop1_D_SQRT(char * str, DWORD dwAddr, DWORD dwOp);
static void SprintOp_Cop1_D_ABS(char * str, DWORD dwAddr, DWORD dwOp);
static void SprintOp_Cop1_D_MOV(char * str, DWORD dwAddr, DWORD dwOp);
static void SprintOp_Cop1_D_NEG(char * str, DWORD dwAddr, DWORD dwOp);
static void SprintOp_Cop1_D_ROUND_L(char * str, DWORD dwAddr, DWORD dwOp);
static void SprintOp_Cop1_D_TRUNC_L(char * str, DWORD dwAddr, DWORD dwOp);
static void SprintOp_Cop1_D_CEIL_L(char * str, DWORD dwAddr, DWORD dwOp);
static void SprintOp_Cop1_D_FLOOR_L(char * str, DWORD dwAddr, DWORD dwOp);
static void SprintOp_Cop1_D_ROUND_W(char * str, DWORD dwAddr, DWORD dwOp);
static void SprintOp_Cop1_D_TRUNC_W(char * str, DWORD dwAddr, DWORD dwOp);
static void SprintOp_Cop1_D_CEIL_W(char * str, DWORD dwAddr, DWORD dwOp);
static void SprintOp_Cop1_D_FLOOR_W(char * str, DWORD dwAddr, DWORD dwOp);
static void SprintOp_Cop1_D_CVT_S(char * str, DWORD dwAddr, DWORD dwOp);
static void SprintOp_Cop1_D_CVT_W(char * str, DWORD dwAddr, DWORD dwOp);
static void SprintOp_Cop1_D_CVT_L(char * str, DWORD dwAddr, DWORD dwOp);
static void SprintOp_Cop1_D_F(char * str, DWORD dwAddr, DWORD dwOp);
static void SprintOp_Cop1_D_UN(char * str, DWORD dwAddr, DWORD dwOp);
static void SprintOp_Cop1_D_EQ(char * str, DWORD dwAddr, DWORD dwOp);
static void SprintOp_Cop1_D_UEQ(char * str, DWORD dwAddr, DWORD dwOp);
static void SprintOp_Cop1_D_OLT(char * str, DWORD dwAddr, DWORD dwOp);
static void SprintOp_Cop1_D_ULT(char * str, DWORD dwAddr, DWORD dwOp);
static void SprintOp_Cop1_D_OLE(char * str, DWORD dwAddr, DWORD dwOp);
static void SprintOp_Cop1_D_ULE(char * str, DWORD dwAddr, DWORD dwOp);
static void SprintOp_Cop1_D_SF(char * str, DWORD dwAddr, DWORD dwOp);
static void SprintOp_Cop1_D_NGLE(char * str, DWORD dwAddr, DWORD dwOp);
static void SprintOp_Cop1_D_SEQ(char * str, DWORD dwAddr, DWORD dwOp);
static void SprintOp_Cop1_D_NGL(char * str, DWORD dwAddr, DWORD dwOp);
static void SprintOp_Cop1_D_LT(char * str, DWORD dwAddr, DWORD dwOp);
static void SprintOp_Cop1_D_NGE(char * str, DWORD dwAddr, DWORD dwOp);
static void SprintOp_Cop1_D_LE(char * str, DWORD dwAddr, DWORD dwOp);
static void SprintOp_Cop1_D_NGT(char * str, DWORD dwAddr, DWORD dwOp);








static void SprintRSPOp_Unk(char * str, DWORD dwAddr, DWORD dwOp);

static void SprintRSPOp_Special(char * str, DWORD dwAddr, DWORD dwOp);
static void SprintRSPOp_RegImm(char * str, DWORD dwAddr, DWORD dwOp);
static void SprintRSPOp_CoPro0(char * str, DWORD dwAddr, DWORD dwOp);
static void SprintRSPOp_CoPro2(char * str, DWORD dwAddr, DWORD dwOp);
static void SprintRSPOp_Vop(char * str, DWORD dwAddr, DWORD dwOp);


static void SprintRSPOp_J(char * str, DWORD dwAddr, DWORD dwOp);
static void SprintRSPOp_JAL(char * str, DWORD dwAddr, DWORD dwOp);
static void SprintRSPOp_BEQ(char * str, DWORD dwAddr, DWORD dwOp);
static void SprintRSPOp_BNE(char * str, DWORD dwAddr, DWORD dwOp);
static void SprintRSPOp_BLEZ(char * str, DWORD dwAddr, DWORD dwOp);
static void SprintRSPOp_BGTZ(char * str, DWORD dwAddr, DWORD dwOp);
static void SprintRSPOp_ADDI(char * str, DWORD dwAddr, DWORD dwOp);
static void SprintRSPOp_ADDIU(char * str, DWORD dwAddr, DWORD dwOp);
static void SprintRSPOp_SLTI(char * str, DWORD dwAddr, DWORD dwOp);
static void SprintRSPOp_SLTIU(char * str, DWORD dwAddr, DWORD dwOp);
static void SprintRSPOp_ANDI(char * str, DWORD dwAddr, DWORD dwOp);
static void SprintRSPOp_ORI(char * str, DWORD dwAddr, DWORD dwOp);
static void SprintRSPOp_XORI(char * str, DWORD dwAddr, DWORD dwOp);
static void SprintRSPOp_LUI(char * str, DWORD dwAddr, DWORD dwOp);
static void SprintRSPOp_LB(char * str, DWORD dwAddr, DWORD dwOp);
static void SprintRSPOp_LH(char * str, DWORD dwAddr, DWORD dwOp);
static void SprintRSPOp_LW(char * str, DWORD dwAddr, DWORD dwOp);
static void SprintRSPOp_LBU(char * str, DWORD dwAddr, DWORD dwOp);
static void SprintRSPOp_LHU(char * str, DWORD dwAddr, DWORD dwOp);
static void SprintRSPOp_SB(char * str, DWORD dwAddr, DWORD dwOp);
static void SprintRSPOp_SH(char * str, DWORD dwAddr, DWORD dwOp);
static void SprintRSPOp_SW(char * str, DWORD dwAddr, DWORD dwOp);
static void SprintRSPOp_LWC2(char * str, DWORD dwAddr, DWORD dwOp);
static void SprintRSPOp_SWC2(char * str, DWORD dwAddr, DWORD dwOp);


static void SprintRSPOp_Special_Unk(char * str, DWORD dwAddr, DWORD dwOp);

static void SprintRSPOp_Special_SLL(char * str, DWORD dwAddr, DWORD dwOp);
static void SprintRSPOp_Special_SRL(char * str, DWORD dwAddr, DWORD dwOp);
static void SprintRSPOp_Special_SRA(char * str, DWORD dwAddr, DWORD dwOp);
static void SprintRSPOp_Special_SLLV(char * str, DWORD dwAddr, DWORD dwOp);
static void SprintRSPOp_Special_SRLV(char * str, DWORD dwAddr, DWORD dwOp);
static void SprintRSPOp_Special_SRAV(char * str, DWORD dwAddr, DWORD dwOp);
static void SprintRSPOp_Special_JR(char * str, DWORD dwAddr, DWORD dwOp);
static void SprintRSPOp_Special_JALR(char * str, DWORD dwAddr, DWORD dwOp);
static void SprintRSPOp_Special_BREAK(char * str, DWORD dwAddr, DWORD dwOp);
static void SprintRSPOp_Special_ADD(char * str, DWORD dwAddr, DWORD dwOp);
static void SprintRSPOp_Special_ADDU(char * str, DWORD dwAddr, DWORD dwOp);
static void SprintRSPOp_Special_SUB(char * str, DWORD dwAddr, DWORD dwOp);
static void SprintRSPOp_Special_SUBU(char * str, DWORD dwAddr, DWORD dwOp);	
static void SprintRSPOp_Special_AND(char * str, DWORD dwAddr, DWORD dwOp);
static void SprintRSPOp_Special_OR(char * str, DWORD dwAddr, DWORD dwOp);
static void SprintRSPOp_Special_XOR(char * str, DWORD dwAddr, DWORD dwOp);
static void SprintRSPOp_Special_NOR(char * str, DWORD dwAddr, DWORD dwOp);
static void SprintRSPOp_Special_SLT(char * str, DWORD dwAddr, DWORD dwOp);
static void SprintRSPOp_Special_SLTU(char * str, DWORD dwAddr, DWORD dwOp);


static void SprintRSPOp_RegImm_Unk(char * str, DWORD dwAddr, DWORD dwOp);

static void SprintRSPOp_RegImm_BLTZ(char * str, DWORD dwAddr, DWORD dwOp);
static void SprintRSPOp_RegImm_BGEZ(char * str, DWORD dwAddr, DWORD dwOp);
static void SprintRSPOp_RegImm_BLTZAL(char * str, DWORD dwAddr, DWORD dwOp);
static void SprintRSPOp_RegImm_BGEZAL(char * str, DWORD dwAddr, DWORD dwOp);


static void SprintRSPOp_Cop0_Unk(char * str, DWORD dwAddr, DWORD dwOp);
static void SprintRSPOp_Cop0_MFC0(char * str, DWORD dwAddr, DWORD dwOp);
static void SprintRSPOp_Cop0_MTC0(char * str, DWORD dwAddr, DWORD dwOp);


static void SprintRSPOp_LWC2_Unk(char * str, DWORD dwAddr, DWORD dwOp);

static void SprintRSPOp_LWC2_LSV(char * str, DWORD dwAddr, DWORD dwOp);
static void SprintRSPOp_LWC2_LLV(char * str, DWORD dwAddr, DWORD dwOp);
static void SprintRSPOp_LWC2_LDV(char * str, DWORD dwAddr, DWORD dwOp);
static void SprintRSPOp_LWC2_LQV(char * str, DWORD dwAddr, DWORD dwOp);
static void SprintRSPOp_LWC2_LTV(char * str, DWORD dwAddr, DWORD dwOp);
static void SprintRSPOp_LWC2_LBV(char * str, DWORD dwAddr, DWORD dwOp);
static void SprintRSPOp_LWC2_LRV(char * str, DWORD dwAddr, DWORD dwOp);
static void SprintRSPOp_LWC2_LPV(char * str, DWORD dwAddr, DWORD dwOp);
static void SprintRSPOp_LWC2_LUV(char * str, DWORD dwAddr, DWORD dwOp);
static void SprintRSPOp_LWC2_LHV(char * str, DWORD dwAddr, DWORD dwOp);
static void SprintRSPOp_LWC2_LFV(char * str, DWORD dwAddr, DWORD dwOp);
static void SprintRSPOp_LWC2_LWV(char * str, DWORD dwAddr, DWORD dwOp);

static void SprintRSPOp_SWC2_Unk(char * str, DWORD dwAddr, DWORD dwOp);

static void SprintRSPOp_SWC2_SSV(char * str, DWORD dwAddr, DWORD dwOp);
static void SprintRSPOp_SWC2_SLV(char * str, DWORD dwAddr, DWORD dwOp);
static void SprintRSPOp_SWC2_SDV(char * str, DWORD dwAddr, DWORD dwOp);
static void SprintRSPOp_SWC2_SQV(char * str, DWORD dwAddr, DWORD dwOp);
static void SprintRSPOp_SWC2_STV(char * str, DWORD dwAddr, DWORD dwOp);
static void SprintRSPOp_SWC2_SBV(char * str, DWORD dwAddr, DWORD dwOp);
static void SprintRSPOp_SWC2_SRV(char * str, DWORD dwAddr, DWORD dwOp);
static void SprintRSPOp_SWC2_SPV(char * str, DWORD dwAddr, DWORD dwOp);
static void SprintRSPOp_SWC2_SUV(char * str, DWORD dwAddr, DWORD dwOp);
static void SprintRSPOp_SWC2_SHV(char * str, DWORD dwAddr, DWORD dwOp);
static void SprintRSPOp_SWC2_SFV(char * str, DWORD dwAddr, DWORD dwOp);
static void SprintRSPOp_SWC2_SWV(char * str, DWORD dwAddr, DWORD dwOp);

static void SprintRSPOp_Cop2_Unk(char * str, DWORD dwAddr, DWORD dwOp);
static void SprintRSPOp_Cop2_MFC2(char * str, DWORD dwAddr, DWORD dwOp);
static void SprintRSPOp_Cop2_MTC2(char * str, DWORD dwAddr, DWORD dwOp);
static void SprintRSPOp_Cop2_VOP(char * str, DWORD dwAddr, DWORD dwOp);



static void SprintRSPOp_Vop_Unk(char * str, DWORD dwAddr, DWORD dwOp);

static void SprintRSPOp_Vop_VMULF(char * str, DWORD dwAddr, DWORD dwOp);
static void SprintRSPOp_Vop_VMULU(char * str, DWORD dwAddr, DWORD dwOp);
static void SprintRSPOp_Vop_VRNDP(char * str, DWORD dwAddr, DWORD dwOp);
static void SprintRSPOp_Vop_VMULQ(char * str, DWORD dwAddr, DWORD dwOp);
static void SprintRSPOp_Vop_VMUDL(char * str, DWORD dwAddr, DWORD dwOp);
static void SprintRSPOp_Vop_VMUDM(char * str, DWORD dwAddr, DWORD dwOp);
static void SprintRSPOp_Vop_VMUDN(char * str, DWORD dwAddr, DWORD dwOp);
static void SprintRSPOp_Vop_VMUDH(char * str, DWORD dwAddr, DWORD dwOp);
static void SprintRSPOp_Vop_VMACF(char * str, DWORD dwAddr, DWORD dwOp);
static void SprintRSPOp_Vop_VMACU(char * str, DWORD dwAddr, DWORD dwOp);
static void SprintRSPOp_Vop_VRNDN(char * str, DWORD dwAddr, DWORD dwOp);
static void SprintRSPOp_Vop_VMACQ(char * str, DWORD dwAddr, DWORD dwOp);
static void SprintRSPOp_Vop_VMADL(char * str, DWORD dwAddr, DWORD dwOp);
static void SprintRSPOp_Vop_VMADM(char * str, DWORD dwAddr, DWORD dwOp);
static void SprintRSPOp_Vop_VMADN(char * str, DWORD dwAddr, DWORD dwOp);
static void SprintRSPOp_Vop_VMADH(char * str, DWORD dwAddr, DWORD dwOp);
static void SprintRSPOp_Vop_VADD(char * str, DWORD dwAddr, DWORD dwOp);
static void SprintRSPOp_Vop_VSUB(char * str, DWORD dwAddr, DWORD dwOp);
static void SprintRSPOp_Vop_VSUT(char * str, DWORD dwAddr, DWORD dwOp);
static void SprintRSPOp_Vop_VABS(char * str, DWORD dwAddr, DWORD dwOp);
static void SprintRSPOp_Vop_VADDC(char * str, DWORD dwAddr, DWORD dwOp);
static void SprintRSPOp_Vop_VSUBC(char * str, DWORD dwAddr, DWORD dwOp);
static void SprintRSPOp_Vop_VADDB(char * str, DWORD dwAddr, DWORD dwOp);
static void SprintRSPOp_Vop_VSUBB(char * str, DWORD dwAddr, DWORD dwOp);
static void SprintRSPOp_Vop_VACCB(char * str, DWORD dwAddr, DWORD dwOp);
static void SprintRSPOp_Vop_VSUCB(char * str, DWORD dwAddr, DWORD dwOp);
static void SprintRSPOp_Vop_VSAD(char * str, DWORD dwAddr, DWORD dwOp);
static void SprintRSPOp_Vop_VSAC(char * str, DWORD dwAddr, DWORD dwOp);
static void SprintRSPOp_Vop_VSUM(char * str, DWORD dwAddr, DWORD dwOp);
static void SprintRSPOp_Vop_VSAW(char * str, DWORD dwAddr, DWORD dwOp);
static void SprintRSPOp_Vop_VLT(char * str, DWORD dwAddr, DWORD dwOp);
static void SprintRSPOp_Vop_VEQ(char * str, DWORD dwAddr, DWORD dwOp);
static void SprintRSPOp_Vop_VNE(char * str, DWORD dwAddr, DWORD dwOp);
static void SprintRSPOp_Vop_VGE(char * str, DWORD dwAddr, DWORD dwOp);
static void SprintRSPOp_Vop_VCL(char * str, DWORD dwAddr, DWORD dwOp);
static void SprintRSPOp_Vop_VCH(char * str, DWORD dwAddr, DWORD dwOp);
static void SprintRSPOp_Vop_VCR(char * str, DWORD dwAddr, DWORD dwOp);
static void SprintRSPOp_Vop_VMRG(char * str, DWORD dwAddr, DWORD dwOp);
static void SprintRSPOp_Vop_VAND(char * str, DWORD dwAddr, DWORD dwOp);
static void SprintRSPOp_Vop_VNAND(char * str, DWORD dwAddr, DWORD dwOp);
static void SprintRSPOp_Vop_VOR(char * str, DWORD dwAddr, DWORD dwOp);
static void SprintRSPOp_Vop_VNOR(char * str, DWORD dwAddr, DWORD dwOp);
static void SprintRSPOp_Vop_VXOR(char * str, DWORD dwAddr, DWORD dwOp);
static void SprintRSPOp_Vop_VNXOR(char * str, DWORD dwAddr, DWORD dwOp);
static void SprintRSPOp_Vop_VRCP(char * str, DWORD dwAddr, DWORD dwOp);
static void SprintRSPOp_Vop_VRCPL(char * str, DWORD dwAddr, DWORD dwOp);
static void SprintRSPOp_Vop_VRCPH(char * str, DWORD dwAddr, DWORD dwOp);
static void SprintRSPOp_Vop_VMOV(char * str, DWORD dwAddr, DWORD dwOp);
static void SprintRSPOp_Vop_VRSQ(char * str, DWORD dwAddr, DWORD dwOp);
static void SprintRSPOp_Vop_VRSQL(char * str, DWORD dwAddr, DWORD dwOp);
static void SprintRSPOp_Vop_VRSQH(char * str, DWORD dwAddr, DWORD dwOp);



typedef void (*SprintOpInstruction)(char * str, DWORD dwAddr, DWORD dwOp);

// Opcode Jump Table
SprintOpInstruction SprintOp_Instructions[64] = {
	SprintOp_Special, SprintOp_RegImm, SprintOp_J, SprintOp_JAL, SprintOp_BEQ, SprintOp_BNE, SprintOp_BLEZ, SprintOp_BGTZ,
	SprintOp_ADDI, SprintOp_ADDIU, SprintOp_SLTI, SprintOp_SLTIU, SprintOp_ANDI, SprintOp_ORI, SprintOp_XORI, SprintOp_LUI,
	SprintOp_CoPro0, SprintOp_CoPro1, SprintOp_Unk, SprintOp_Unk, SprintOp_BEQL, SprintOp_BNEL, SprintOp_BLEZL, SprintOp_BGTZL,
	SprintOp_DADDI, SprintOp_DADDIU, SprintOp_LDL, SprintOp_LDR, SprintOp_Patch, SprintOp_UnOpt, SprintOp_Opt, SprintOp_NoOpt,
	SprintOp_LB, SprintOp_LH, SprintOp_LWL, SprintOp_LW, SprintOp_LBU, SprintOp_LHU, SprintOp_LWR, SprintOp_LWU,
	SprintOp_SB, SprintOp_SH, SprintOp_SWL, SprintOp_SW, SprintOp_SDL, SprintOp_SDR, SprintOp_SWR, SprintOp_CACHE,
	SprintOp_LL, SprintOp_LWC1, SprintOp_Unk, SprintOp_Unk, SprintOp_LLD, SprintOp_LDC1, SprintOp_LDC2, SprintOp_LD,
	SprintOp_SC, SprintOp_SWC1, SprintOp_Unk, SprintOp_Unk, SprintOp_SCD, SprintOp_SDC1, SprintOp_SDC2, SprintOp_SD
};

SprintOpInstruction SprintOp_SpecialInstructions[64] = {
	SprintOp_Special_SLL, SprintOp_Special_Unk, SprintOp_Special_SRL, SprintOp_Special_SRA, SprintOp_Special_SLLV, SprintOp_Special_Unk, SprintOp_Special_SRLV, SprintOp_Special_SRAV,
	SprintOp_Special_JR, SprintOp_Special_JALR, SprintOp_Special_Unk, SprintOp_Special_Unk, SprintOp_Special_SYSCALL, SprintOp_Special_BREAK, SprintOp_Special_Unk, SprintOp_Special_SYNC,
	SprintOp_Special_MFHI, SprintOp_Special_MTHI, SprintOp_Special_MFLO, SprintOp_Special_MTLO, SprintOp_Special_DSLLV, SprintOp_Special_Unk, SprintOp_Special_DSRLV, SprintOp_Special_DSRAV,
	SprintOp_Special_MULT, SprintOp_Special_MULTU, SprintOp_Special_DIV, SprintOp_Special_DIVU, SprintOp_Special_DMULT, SprintOp_Special_DMULTU, SprintOp_Special_DDIV, SprintOp_Special_DDIVU,
	SprintOp_Special_ADD, SprintOp_Special_ADDU, SprintOp_Special_SUB, SprintOp_Special_SUBU, SprintOp_Special_AND, SprintOp_Special_OR, SprintOp_Special_XOR, SprintOp_Special_NOR,
	SprintOp_Special_Unk, SprintOp_Special_Unk, SprintOp_Special_SLT, SprintOp_Special_SLTU, SprintOp_Special_DADD, SprintOp_Special_DADDU, SprintOp_Special_DSUB, SprintOp_Special_DSUBU,
	SprintOp_Special_TGE, SprintOp_Special_TGEU, SprintOp_Special_TLT, SprintOp_Special_TLTU, SprintOp_Special_TEQ, SprintOp_Special_Unk, SprintOp_Special_TNE, SprintOp_Special_Unk,
	SprintOp_Special_DSLL, SprintOp_Special_Unk, SprintOp_Special_DSRL, SprintOp_Special_DSRA, SprintOp_Special_DSLL32, SprintOp_Special_Unk, SprintOp_Special_DSRL32, SprintOp_Special_DSRA32
};

SprintOpInstruction SprintOp_RegImmInstructions[32] = {
	SprintOp_RegImm_BLTZ,   SprintOp_RegImm_BGEZ,   SprintOp_RegImm_BLTZL,   SprintOp_RegImm_BGEZL,   SprintOp_RegImm_Unk,  SprintOp_RegImm_Unk, SprintOp_RegImm_Unk,  SprintOp_RegImm_Unk,
	SprintOp_RegImm_TGEI,   SprintOp_RegImm_TGEIU,  SprintOp_RegImm_TLTI,    SprintOp_RegImm_TLTIU,   SprintOp_RegImm_TEQI, SprintOp_RegImm_Unk, SprintOp_RegImm_TNEI, SprintOp_RegImm_Unk,
	SprintOp_RegImm_BLTZAL, SprintOp_RegImm_BGEZAL, SprintOp_RegImm_BLTZALL, SprintOp_RegImm_BGEZALL, SprintOp_RegImm_Unk,  SprintOp_RegImm_Unk, SprintOp_RegImm_Unk,  SprintOp_RegImm_Unk,
	SprintOp_RegImm_Unk,    SprintOp_RegImm_Unk,    SprintOp_RegImm_Unk,     SprintOp_RegImm_Unk,     SprintOp_RegImm_Unk,  SprintOp_RegImm_Unk, SprintOp_RegImm_Unk,  SprintOp_RegImm_Unk
};


SprintOpInstruction SprintOp_Cop0Instructions[32] = {
	SprintOp_Cop0_MFC0, SprintOp_Cop0_Unk, SprintOp_Cop0_Unk, SprintOp_Cop0_Unk, SprintOp_Cop0_MTC0, SprintOp_Cop0_Unk, SprintOp_Cop0_Unk, SprintOp_Cop0_Unk,
	SprintOp_Cop0_Unk, SprintOp_Cop0_Unk, SprintOp_Cop0_Unk, SprintOp_Cop0_Unk, SprintOp_Cop0_Unk, SprintOp_Cop0_Unk, SprintOp_Cop0_Unk, SprintOp_Cop0_Unk,
	SprintOp_Cop0_TLB, SprintOp_Cop0_Unk, SprintOp_Cop0_Unk, SprintOp_Cop0_Unk, SprintOp_Cop0_Unk, SprintOp_Cop0_Unk, SprintOp_Cop0_Unk, SprintOp_Cop0_Unk,
	SprintOp_Cop0_Unk, SprintOp_Cop0_Unk, SprintOp_Cop0_Unk, SprintOp_Cop0_Unk, SprintOp_Cop0_Unk, SprintOp_Cop0_Unk, SprintOp_Cop0_Unk, SprintOp_Cop0_Unk,
};


SprintOpInstruction SprintOp_TLBInstructions[64] = {
	SprintOp_TLB_Unk, SprintOp_TLB_TLBR, SprintOp_TLB_TLBWI, SprintOp_TLB_Unk, SprintOp_TLB_Unk, SprintOp_TLB_Unk, SprintOp_TLB_TLBWR, SprintOp_TLB_Unk,
	SprintOp_TLB_TLBP, SprintOp_TLB_Unk, SprintOp_TLB_Unk, SprintOp_TLB_Unk, SprintOp_TLB_Unk, SprintOp_TLB_Unk, SprintOp_TLB_Unk, SprintOp_TLB_Unk,
	SprintOp_TLB_Unk, SprintOp_TLB_Unk, SprintOp_TLB_Unk, SprintOp_TLB_Unk, SprintOp_TLB_Unk, SprintOp_TLB_Unk, SprintOp_TLB_Unk, SprintOp_TLB_Unk,
	SprintOp_TLB_ERET, SprintOp_TLB_Unk, SprintOp_TLB_Unk, SprintOp_TLB_Unk, SprintOp_TLB_Unk, SprintOp_TLB_Unk, SprintOp_TLB_Unk, SprintOp_TLB_Unk,
	SprintOp_TLB_Unk, SprintOp_TLB_Unk, SprintOp_TLB_Unk, SprintOp_TLB_Unk, SprintOp_TLB_Unk, SprintOp_TLB_Unk, SprintOp_TLB_Unk, SprintOp_TLB_Unk,
	SprintOp_TLB_Unk, SprintOp_TLB_Unk, SprintOp_TLB_Unk, SprintOp_TLB_Unk, SprintOp_TLB_Unk, SprintOp_TLB_Unk, SprintOp_TLB_Unk, SprintOp_TLB_Unk,
	SprintOp_TLB_Unk, SprintOp_TLB_Unk, SprintOp_TLB_Unk, SprintOp_TLB_Unk, SprintOp_TLB_Unk, SprintOp_TLB_Unk, SprintOp_TLB_Unk, SprintOp_TLB_Unk,
	SprintOp_TLB_Unk, SprintOp_TLB_Unk, SprintOp_TLB_Unk, SprintOp_TLB_Unk, SprintOp_TLB_Unk, SprintOp_TLB_Unk, SprintOp_TLB_Unk, SprintOp_TLB_Unk,
};

SprintOpInstruction SprintOp_Cop1Instructions[32] = {
	SprintOp_Cop1_MFC1,    SprintOp_Cop1_DMFC1,  SprintOp_Cop1_CFC1, SprintOp_Cop1_Unk, SprintOp_Cop1_MTC1,   SprintOp_Cop1_DMTC1,  SprintOp_Cop1_CTC1, SprintOp_Cop1_Unk,
	SprintOp_Cop1_BCInstr, SprintOp_Cop1_Unk,    SprintOp_Cop1_Unk,  SprintOp_Cop1_Unk, SprintOp_Cop1_Unk,    SprintOp_Cop1_Unk,    SprintOp_Cop1_Unk,  SprintOp_Cop1_Unk,
	SprintOp_Cop1_SInstr,  SprintOp_Cop1_DInstr, SprintOp_Cop1_Unk,  SprintOp_Cop1_Unk, SprintOp_Cop1_WInstr, SprintOp_Cop1_LInstr, SprintOp_Cop1_Unk,  SprintOp_Cop1_Unk,
	SprintOp_Cop1_Unk,     SprintOp_Cop1_Unk,    SprintOp_Cop1_Unk,  SprintOp_Cop1_Unk, SprintOp_Cop1_Unk,    SprintOp_Cop1_Unk,    SprintOp_Cop1_Unk,  SprintOp_Cop1_Unk
};

SprintOpInstruction SprintOp_Cop1SInstruction[64] = {
	SprintOp_Cop1_S_ADD,     SprintOp_Cop1_S_SUB,     SprintOp_Cop1_S_MUL,    SprintOp_Cop1_S_DIV,     SprintOp_Cop1_S_SQRT,    SprintOp_Cop1_S_ABS,     SprintOp_Cop1_S_MOV,    SprintOp_Cop1_S_NEG,
	SprintOp_Cop1_S_ROUND_L, SprintOp_Cop1_S_TRUNC_L,	SprintOp_Cop1_S_CEIL_L, SprintOp_Cop1_S_FLOOR_L, SprintOp_Cop1_S_ROUND_W, SprintOp_Cop1_S_TRUNC_W, SprintOp_Cop1_S_CEIL_W, SprintOp_Cop1_S_FLOOR_W,
	SprintOp_Cop1_S_Unk,     SprintOp_Cop1_S_Unk,     SprintOp_Cop1_S_Unk,    SprintOp_Cop1_S_Unk,     SprintOp_Cop1_S_Unk,     SprintOp_Cop1_S_Unk,     SprintOp_Cop1_S_Unk,    SprintOp_Cop1_S_Unk, 
	SprintOp_Cop1_S_Unk,     SprintOp_Cop1_S_Unk,     SprintOp_Cop1_S_Unk,    SprintOp_Cop1_S_Unk,     SprintOp_Cop1_S_Unk,     SprintOp_Cop1_S_Unk,     SprintOp_Cop1_S_Unk,    SprintOp_Cop1_S_Unk, 
	SprintOp_Cop1_S_Unk,     SprintOp_Cop1_S_CVT_D,   SprintOp_Cop1_S_Unk,    SprintOp_Cop1_S_Unk,     SprintOp_Cop1_S_CVT_W,   SprintOp_Cop1_S_CVT_L,   SprintOp_Cop1_S_Unk,    SprintOp_Cop1_S_Unk,
	SprintOp_Cop1_S_Unk,     SprintOp_Cop1_S_Unk,     SprintOp_Cop1_S_Unk,    SprintOp_Cop1_S_Unk,     SprintOp_Cop1_S_Unk,     SprintOp_Cop1_S_Unk,     SprintOp_Cop1_S_Unk,    SprintOp_Cop1_S_Unk, 
	SprintOp_Cop1_S_F,       SprintOp_Cop1_S_UN,      SprintOp_Cop1_S_EQ,     SprintOp_Cop1_S_UEQ,     SprintOp_Cop1_S_OLT,     SprintOp_Cop1_S_ULT,     SprintOp_Cop1_S_OLE,    SprintOp_Cop1_S_ULE,
	SprintOp_Cop1_S_SF,      SprintOp_Cop1_S_NGLE,    SprintOp_Cop1_S_SEQ,    SprintOp_Cop1_S_NGL,     SprintOp_Cop1_S_LT,      SprintOp_Cop1_S_NGE,     SprintOp_Cop1_S_LE,     SprintOp_Cop1_S_NGT
};

SprintOpInstruction SprintOp_Cop1DInstruction[64] = {
	SprintOp_Cop1_D_ADD,     SprintOp_Cop1_D_SUB,     SprintOp_Cop1_D_MUL, SprintOp_Cop1_D_DIV, SprintOp_Cop1_D_SQRT, SprintOp_Cop1_D_ABS, SprintOp_Cop1_D_MOV, SprintOp_Cop1_D_NEG,
	SprintOp_Cop1_D_ROUND_L, SprintOp_Cop1_D_TRUNC_L,	SprintOp_Cop1_D_CEIL_L, SprintOp_Cop1_D_FLOOR_L, SprintOp_Cop1_D_ROUND_W, SprintOp_Cop1_D_TRUNC_W, SprintOp_Cop1_D_CEIL_W, SprintOp_Cop1_D_FLOOR_W,
	SprintOp_Cop1_D_Unk,     SprintOp_Cop1_D_Unk,     SprintOp_Cop1_D_Unk, SprintOp_Cop1_D_Unk, SprintOp_Cop1_D_Unk, SprintOp_Cop1_D_Unk, SprintOp_Cop1_D_Unk, SprintOp_Cop1_D_Unk, 
	SprintOp_Cop1_D_Unk,     SprintOp_Cop1_D_Unk,     SprintOp_Cop1_D_Unk, SprintOp_Cop1_D_Unk, SprintOp_Cop1_D_Unk, SprintOp_Cop1_D_Unk, SprintOp_Cop1_D_Unk, SprintOp_Cop1_D_Unk, 
	SprintOp_Cop1_D_CVT_S,   SprintOp_Cop1_D_Unk,     SprintOp_Cop1_D_Unk, SprintOp_Cop1_D_Unk, SprintOp_Cop1_D_CVT_W, SprintOp_Cop1_D_CVT_L, SprintOp_Cop1_D_Unk, SprintOp_Cop1_D_Unk,
	SprintOp_Cop1_D_Unk,     SprintOp_Cop1_D_Unk,     SprintOp_Cop1_D_Unk, SprintOp_Cop1_D_Unk, SprintOp_Cop1_D_Unk, SprintOp_Cop1_D_Unk, SprintOp_Cop1_D_Unk, SprintOp_Cop1_D_Unk, 
	SprintOp_Cop1_D_F,       SprintOp_Cop1_D_UN,      SprintOp_Cop1_D_EQ, SprintOp_Cop1_D_UEQ, SprintOp_Cop1_D_OLT, SprintOp_Cop1_D_ULT, SprintOp_Cop1_D_OLE, SprintOp_Cop1_D_ULE,
	SprintOp_Cop1_D_SF,      SprintOp_Cop1_D_NGLE,    SprintOp_Cop1_D_SEQ, SprintOp_Cop1_D_NGL, SprintOp_Cop1_D_LT, SprintOp_Cop1_D_NGE, SprintOp_Cop1_D_LE, SprintOp_Cop1_D_NGT
};



#define BranchAddress(dwOp, dwAddr) ((dwAddr)+4 + (s16)imm((dwOp))*4)
#define JumpTarget(dwOp, dwAddr) (((dwAddr) & 0xF0000000) | (target((dwOp))<<2))

void SprintOp_Unk(char * str, DWORD dwAddr, DWORD dwOp) { sprintf(str, "?"); }

void SprintOp_Special(char * str, DWORD dwAddr, DWORD dwOp)		{ SprintOp_SpecialInstructions[funct(dwOp)](str, dwAddr, dwOp); }
void SprintOp_RegImm(char * str, DWORD dwAddr, DWORD dwOp)		{ SprintOp_RegImmInstructions[rt(dwOp)](str, dwAddr, dwOp); }
void SprintOp_CoPro0(char * str, DWORD dwAddr, DWORD dwOp)		{ SprintOp_Cop0Instructions[cop0fmt(dwOp)](str, dwAddr, dwOp); }
void SprintOp_CoPro1(char * str, DWORD dwAddr, DWORD dwOp)		{ SprintOp_Cop1Instructions[cop1fmt(dwOp)](str, dwAddr, dwOp); }

void SprintOp_UnOpt(char * str, DWORD dwAddr, DWORD dwOp)		{ sprintf(str, "SRHack UnOpt"); }
void SprintOp_Opt(char * str, DWORD dwAddr, DWORD dwOp)			{ sprintf(str, "SRHack Opt"); }
void SprintOp_NoOpt(char * str, DWORD dwAddr, DWORD dwOp)		{ sprintf(str, "SRHack NoOpt"); }
void SprintOp_Patch(char * str, DWORD dwAddr, DWORD dwOp)		{ sprintf(str, "Patch");


//Patch_GetJumpAddressName(JumpTarget(dwOp, dwAddr)) );

}

void SprintOp_J(char * str, DWORD dwAddr, DWORD dwOp)			{ sprintf(str, "J         0x%08x        %s", JumpTarget(dwOp, dwAddr), Patch_GetJumpAddressName(JumpTarget(dwOp, dwAddr)) ); }
void SprintOp_JAL(char * str, DWORD dwAddr, DWORD dwOp)			{ sprintf(str, "JAL       0x%08x        %s", JumpTarget(dwOp, dwAddr), Patch_GetJumpAddressName(JumpTarget(dwOp, dwAddr)) ); }
void SprintOp_BEQ(char * str, DWORD dwAddr, DWORD dwOp) {
						if (rs(dwOp) == 0 && rt(dwOp) == 0)       sprintf(str, "B         --> 0x%08x", dwAddr+4 + (s16)imm(dwOp)*4);
						else                                      sprintf(str, "BEQ       %s == %s --> 0x%08x", RegNames[rs(dwOp)], RegNames[rt(dwOp)], BranchAddress(dwOp, dwAddr)); }
void SprintOp_BNE(char * str, DWORD dwAddr, DWORD dwOp)			{ sprintf(str, "BNE       %s != %s --> 0x%08x", RegNames[rs(dwOp)], RegNames[rt(dwOp)], BranchAddress(dwOp, dwAddr)); }
void SprintOp_BLEZ(char * str, DWORD dwAddr, DWORD dwOp)		{ sprintf(str, "BLEZ      %s <= 0 --> 0x%08x", RegNames[rs(dwOp)], BranchAddress(dwOp, dwAddr)); }
void SprintOp_BGTZ(char * str, DWORD dwAddr, DWORD dwOp)		{ sprintf(str, "BGTZ      %s > 0 --> 0x%08x", RegNames[rs(dwOp)], BranchAddress(dwOp, dwAddr)); }
void SprintOp_ADDI(char * str, DWORD dwAddr, DWORD dwOp)		{ sprintf(str, "ADDI      %s = %s + 0x%04x", RegNames[rt(dwOp)], RegNames[rs(dwOp)], imm(dwOp)); }
void SprintOp_ADDIU(char * str, DWORD dwAddr, DWORD dwOp)		{ sprintf(str, "ADDIU     %s = %s + 0x%04x", RegNames[rt(dwOp)], RegNames[rs(dwOp)], imm(dwOp)); }
void SprintOp_SLTI(char * str, DWORD dwAddr, DWORD dwOp)		{ sprintf(str, "SLTI      %s = (%s < 0x%04x)", RegNames[rt(dwOp)], RegNames[rs(dwOp)], imm(dwOp)); }
void SprintOp_SLTIU(char * str, DWORD dwAddr, DWORD dwOp)		{ sprintf(str, "SLTIU     %s = (%s < 0x%04x)", RegNames[rt(dwOp)], RegNames[rs(dwOp)], imm(dwOp)); }
void SprintOp_ANDI(char * str, DWORD dwAddr, DWORD dwOp)		{ sprintf(str, "ANDI      %s = %s & 0x%04x", RegNames[rt(dwOp)], RegNames[rs(dwOp)], imm(dwOp)); }
void SprintOp_ORI(char * str, DWORD dwAddr, DWORD dwOp)			{ sprintf(str, "ORI       %s = %s | 0x%04x", RegNames[rt(dwOp)], RegNames[rs(dwOp)], imm(dwOp)); }
void SprintOp_XORI(char * str, DWORD dwAddr, DWORD dwOp)		{ sprintf(str, "XORI      %s = %s ^ 0x%04x", RegNames[rt(dwOp)], RegNames[rs(dwOp)], imm(dwOp)); }
void SprintOp_LUI(char * str, DWORD dwAddr, DWORD dwOp)			{ sprintf(str, "LUI       %s = 0x%08x", RegNames[rt(dwOp)], imm(dwOp)<<16); }
void SprintOp_BEQL(char * str, DWORD dwAddr, DWORD dwOp)		{ sprintf(str, "BEQL      %s == %s --> 0x%08x", RegNames[rs(dwOp)], RegNames[rt(dwOp)], BranchAddress(dwOp, dwAddr)); }
void SprintOp_BNEL(char * str, DWORD dwAddr, DWORD dwOp)		{ sprintf(str, "BNEL      %s != %s --> 0x%08x", RegNames[rs(dwOp)], RegNames[rt(dwOp)], BranchAddress(dwOp, dwAddr)); }
void SprintOp_BLEZL(char * str, DWORD dwAddr, DWORD dwOp)		{ sprintf(str, "BLEZL     %s <= 0 --> 0x%08x", RegNames[rs(dwOp)], BranchAddress(dwOp, dwAddr)); }
void SprintOp_BGTZL(char * str, DWORD dwAddr, DWORD dwOp)		{ sprintf(str, "BGTZL     %s > 0 --> 0x%08x", RegNames[rs(dwOp)], BranchAddress(dwOp, dwAddr)); }
void SprintOp_DADDI(char * str, DWORD dwAddr, DWORD dwOp)		{ sprintf(str, "DADDI     %s = %s + 0x%04x", RegNames[rt(dwOp)], RegNames[rs(dwOp)], imm(dwOp)); }
void SprintOp_DADDIU(char * str, DWORD dwAddr, DWORD dwOp)		{ sprintf(str, "DADDIU    %s = %s + 0x%04x", RegNames[rt(dwOp)], RegNames[rs(dwOp)], imm(dwOp)); }
void SprintOp_LDL(char * str, DWORD dwAddr, DWORD dwOp)			{ sprintf(str, "LDL       %s <- 0x%04x(%s)", RegNames[rt(dwOp)], imm(dwOp), RegNames[rs(dwOp)]); }
void SprintOp_LDR(char * str, DWORD dwAddr, DWORD dwOp)			{ sprintf(str, "LDR       %s <- 0x%04x(%s)", RegNames[rt(dwOp)], imm(dwOp), RegNames[rs(dwOp)]); }
void SprintOp_LB(char * str, DWORD dwAddr, DWORD dwOp)			{ sprintf(str, "LB        %s <- 0x%04x(%s)", RegNames[rt(dwOp)], imm(dwOp), RegNames[rs(dwOp)]); }
void SprintOp_LH(char * str, DWORD dwAddr, DWORD dwOp)			{ sprintf(str, "LH        %s <- 0x%04x(%s)", RegNames[rt(dwOp)], imm(dwOp), RegNames[rs(dwOp)]); }
void SprintOp_LWL(char * str, DWORD dwAddr, DWORD dwOp)			{ sprintf(str, "LWL       %s <- 0x%04x(%s)", RegNames[rt(dwOp)], imm(dwOp), RegNames[rs(dwOp)]); }
void SprintOp_LW(char * str, DWORD dwAddr, DWORD dwOp)			{ sprintf(str, "LW        %s <- 0x%04x(%s)", RegNames[rt(dwOp)], imm(dwOp), RegNames[rs(dwOp)]); }
void SprintOp_LBU(char * str, DWORD dwAddr, DWORD dwOp)			{ sprintf(str, "LBU       %s <- 0x%04x(%s)", RegNames[rt(dwOp)], imm(dwOp), RegNames[rs(dwOp)]); }
void SprintOp_LHU(char * str, DWORD dwAddr, DWORD dwOp)			{ sprintf(str, "LHU       %s <- 0x%04x(%s)", RegNames[rt(dwOp)], imm(dwOp), RegNames[rs(dwOp)]); }
void SprintOp_LWR(char * str, DWORD dwAddr, DWORD dwOp)			{ sprintf(str, "LWR       %s <- 0x%04x(%s)", RegNames[rt(dwOp)], imm(dwOp), RegNames[rs(dwOp)]); }
void SprintOp_LWU(char * str, DWORD dwAddr, DWORD dwOp)			{ sprintf(str, "LWU       %s <- 0x%04x(%s)", RegNames[rt(dwOp)], imm(dwOp), RegNames[rs(dwOp)]); }
void SprintOp_SB(char * str, DWORD dwAddr, DWORD dwOp)			{ sprintf(str, "SB        %s -> 0x%04x(%s)", RegNames[rt(dwOp)], imm(dwOp), RegNames[rs(dwOp)]); }
void SprintOp_SH(char * str, DWORD dwAddr, DWORD dwOp)			{ sprintf(str, "SH        %s -> 0x%04x(%s)", RegNames[rt(dwOp)], imm(dwOp), RegNames[rs(dwOp)]); }
void SprintOp_SWL(char * str, DWORD dwAddr, DWORD dwOp)			{ sprintf(str, "SWL       %s -> 0x%04x(%s)", RegNames[rt(dwOp)], imm(dwOp), RegNames[rs(dwOp)]); }
void SprintOp_SW(char * str, DWORD dwAddr, DWORD dwOp)			{ sprintf(str, "SW        %s -> 0x%04x(%s)", RegNames[rt(dwOp)], imm(dwOp), RegNames[rs(dwOp)]); }
void SprintOp_SDL(char * str, DWORD dwAddr, DWORD dwOp)			{ sprintf(str, "SDL       %s -> 0x%04x(%s)", RegNames[rt(dwOp)], imm(dwOp), RegNames[rs(dwOp)]); }
void SprintOp_SDR(char * str, DWORD dwAddr, DWORD dwOp)			{ sprintf(str, "SDR       %s -> 0x%04x(%s)", RegNames[rt(dwOp)], imm(dwOp), RegNames[rs(dwOp)]); }
void SprintOp_SWR(char * str, DWORD dwAddr, DWORD dwOp)			{ sprintf(str, "SWR       %s -> 0x%04x(%s)", RegNames[rt(dwOp)], imm(dwOp), RegNames[rs(dwOp)]); }
void SprintOp_CACHE(char * str, DWORD dwAddr, DWORD dwOp)		{ sprintf(str, "CACHE     0x%02x,0x%04x(%s)", rt(dwOp), imm(dwOp), RegNames[rs(dwOp)]); }
void SprintOp_LL(char * str, DWORD dwAddr, DWORD dwOp)			{ sprintf(str, "LL        %s <- 0x%04x(%s)", RegNames[rt(dwOp)], imm(dwOp), RegNames[rs(dwOp)]); }
void SprintOp_LWC1(char * str, DWORD dwAddr, DWORD dwOp)		{ sprintf(str, "LWC1      FP%02d <- 0x%04x(%s)", ft(dwOp), imm(dwOp), RegNames[rs(dwOp)]); }
void SprintOp_LLD(char * str, DWORD dwAddr, DWORD dwOp)			{ sprintf(str, "LLD       %s <- 0x%04x(%s)", RegNames[rt(dwOp)], imm(dwOp), RegNames[rs(dwOp)]); }
void SprintOp_LDC1(char * str, DWORD dwAddr, DWORD dwOp)		{ sprintf(str, "LDC1      FP%02d <- 0x%04x(%s)", ft(dwOp), imm(dwOp), RegNames[rs(dwOp)]); }
void SprintOp_LDC2(char * str, DWORD dwAddr, DWORD dwOp)		{ sprintf(str, "LDC2      GR%02d <- 0x%04x(%s)", ft(dwOp), imm(dwOp), RegNames[rs(dwOp)]); }
void SprintOp_LD(char * str, DWORD dwAddr, DWORD dwOp)			{ sprintf(str, "LD        %s <- 0x%04x(%s)", RegNames[rt(dwOp)], imm(dwOp), RegNames[rs(dwOp)]); }
void SprintOp_SC(char * str, DWORD dwAddr, DWORD dwOp)			{ sprintf(str, "SC        %s -> 0x%04x(%s)", RegNames[rt(dwOp)], imm(dwOp), RegNames[rs(dwOp)]); }
void SprintOp_SWC1(char * str, DWORD dwAddr, DWORD dwOp)		{ sprintf(str, "SWC1      FP%02d -> 0x%04x(%s)", ft(dwOp), imm(dwOp), RegNames[rs(dwOp)]); } 
void SprintOp_SCD(char * str, DWORD dwAddr, DWORD dwOp)			{ sprintf(str, "SCD       %s -> 0x%04x(%s)", RegNames[rt(dwOp)], imm(dwOp), RegNames[rs(dwOp)]); }
void SprintOp_SDC1(char * str, DWORD dwAddr, DWORD dwOp)		{ sprintf(str, "SDC1      FP%02d -> 0x%04x(%s)", ft(dwOp), imm(dwOp), RegNames[rs(dwOp)]); }
void SprintOp_SDC2(char * str, DWORD dwAddr, DWORD dwOp)		{ sprintf(str, "SDC2      GR%02d -> 0x%04x(%s)", ft(dwOp), imm(dwOp), RegNames[rs(dwOp)]); }
void SprintOp_SD(char * str, DWORD dwAddr, DWORD dwOp)			{ sprintf(str, "SD        %s -> 0x%04x(%s)", RegNames[rt(dwOp)], imm(dwOp), RegNames[rs(dwOp)]); }


void SprintOp_Special_Unk(char * str, DWORD dwAddr, DWORD dwOp)			{ sprintf(str, "?"); }

void SprintOp_Special_SLL(char * str, DWORD dwAddr, DWORD dwOp)			{
								if (dwOp == 0)							  sprintf(str, "NOP");
								else									  sprintf(str, "SLL       %s = %s << 0x%04x", RegNames[rd(dwOp)], RegNames[rt(dwOp)], sa(dwOp)); }
void SprintOp_Special_SRL(char * str, DWORD dwAddr, DWORD dwOp)			{ sprintf(str, "SRL       %s = %s >> 0x%04x", RegNames[rd(dwOp)], RegNames[rt(dwOp)], sa(dwOp)); }
void SprintOp_Special_SRA(char * str, DWORD dwAddr, DWORD dwOp)			{ sprintf(str, "SRA       %s = %s >> 0x%04x", RegNames[rd(dwOp)], RegNames[rt(dwOp)], sa(dwOp)); }
void SprintOp_Special_SLLV(char * str, DWORD dwAddr, DWORD dwOp)		{ sprintf(str, "SLLV      %s = %s << %s", RegNames[rd(dwOp)], RegNames[rt(dwOp)], RegNames[rs(dwOp)]); }
void SprintOp_Special_SRLV(char * str, DWORD dwAddr, DWORD dwOp)		{ sprintf(str, "SRLV      %s = %s >> %s", RegNames[rd(dwOp)], RegNames[rt(dwOp)], RegNames[rs(dwOp)]); }
void SprintOp_Special_SRAV(char * str, DWORD dwAddr, DWORD dwOp)		{ sprintf(str, "SRAV      %s = %s >> %s", RegNames[rd(dwOp)], RegNames[rt(dwOp)], RegNames[rs(dwOp)]); }
void SprintOp_Special_JR(char * str, DWORD dwAddr, DWORD dwOp)			{ sprintf(str, "JR        %s", RegNames[rs(dwOp)]); }
void SprintOp_Special_JALR(char * str, DWORD dwAddr, DWORD dwOp)		{ sprintf(str, "JALR      %s, %s", RegNames[rd(dwOp)], RegNames[rs(dwOp)]); }
void SprintOp_Special_SYSCALL(char * str, DWORD dwAddr, DWORD dwOp)		{ sprintf(str, "SYSCALL"); }
void SprintOp_Special_BREAK(char * str, DWORD dwAddr, DWORD dwOp)		{ sprintf(str, "BREAK     0x%08x", (dwOp>>6)&0xFFFFF); }
void SprintOp_Special_SYNC(char * str, DWORD dwAddr, DWORD dwOp)		{ sprintf(str, "SYNC"); }
void SprintOp_Special_MFHI(char * str, DWORD dwAddr, DWORD dwOp)		{ sprintf(str, "MFHI      %s", RegNames[rd(dwOp)]); }
void SprintOp_Special_MTHI(char * str, DWORD dwAddr, DWORD dwOp)		{ sprintf(str, "MTHI      %s", RegNames[rs(dwOp)]); }
void SprintOp_Special_MFLO(char * str, DWORD dwAddr, DWORD dwOp)		{ sprintf(str, "MFLO      %s", RegNames[rd(dwOp)]); }
void SprintOp_Special_MTLO(char * str, DWORD dwAddr, DWORD dwOp)		{ sprintf(str, "MTLO      %s", RegNames[rs(dwOp)]); }
void SprintOp_Special_DSLLV(char * str, DWORD dwAddr, DWORD dwOp)		{ sprintf(str, "DSLLV     %s = %s << %s", RegNames[rd(dwOp)], RegNames[rt(dwOp)], RegNames[rs(dwOp)]); }
void SprintOp_Special_DSRLV(char * str, DWORD dwAddr, DWORD dwOp)		{ sprintf(str, "DSRLV     %s = %s >> %s", RegNames[rd(dwOp)], RegNames[rt(dwOp)], RegNames[rs(dwOp)]); }
void SprintOp_Special_DSRAV(char * str, DWORD dwAddr, DWORD dwOp)		{ sprintf(str, "DSRAV     %s = %s >> %s", RegNames[rd(dwOp)], RegNames[rt(dwOp)], RegNames[rs(dwOp)]); }
void SprintOp_Special_MULT(char * str, DWORD dwAddr, DWORD dwOp)		{ sprintf(str, "MULT      %s * %s", RegNames[rs(dwOp)], RegNames[rt(dwOp)]); }
void SprintOp_Special_MULTU(char * str, DWORD dwAddr, DWORD dwOp)		{ sprintf(str, "MULTU     %s * %s", RegNames[rs(dwOp)], RegNames[rt(dwOp)]); }
void SprintOp_Special_DIV(char * str, DWORD dwAddr, DWORD dwOp)			{ sprintf(str, "DIV       %s / %s", RegNames[rs(dwOp)], RegNames[rt(dwOp)]); }
void SprintOp_Special_DIVU(char * str, DWORD dwAddr, DWORD dwOp)		{ sprintf(str, "DIVU      %s / %s", RegNames[rs(dwOp)], RegNames[rt(dwOp)]); }
void SprintOp_Special_DMULT(char * str, DWORD dwAddr, DWORD dwOp)		{ sprintf(str, "DMULT     %s * %s", RegNames[rs(dwOp)], RegNames[rt(dwOp)]); }
void SprintOp_Special_DMULTU(char * str, DWORD dwAddr, DWORD dwOp)		{ sprintf(str, "DMULTU    %s * %s", RegNames[rs(dwOp)], RegNames[rt(dwOp)]); }
void SprintOp_Special_DDIV(char * str, DWORD dwAddr, DWORD dwOp)		{ sprintf(str, "DDIV      %s / %s", RegNames[rs(dwOp)], RegNames[rt(dwOp)]); }
void SprintOp_Special_DDIVU(char * str, DWORD dwAddr, DWORD dwOp)		{ sprintf(str, "DDIVU     %s / %s", RegNames[rs(dwOp)], RegNames[rt(dwOp)]); }
void SprintOp_Special_ADD(char * str, DWORD dwAddr, DWORD dwOp)			{ sprintf(str, "ADD       %s = %s + %s", RegNames[rd(dwOp)], RegNames[rs(dwOp)], RegNames[rt(dwOp)]); }
void SprintOp_Special_ADDU(char * str, DWORD dwAddr, DWORD dwOp)		{ sprintf(str, "ADDU      %s = %s + %s", RegNames[rd(dwOp)], RegNames[rs(dwOp)], RegNames[rt(dwOp)]); }
void SprintOp_Special_SUB(char * str, DWORD dwAddr, DWORD dwOp)			{ sprintf(str, "SUB       %s = %s - %s", RegNames[rd(dwOp)], RegNames[rs(dwOp)], RegNames[rt(dwOp)]); }
void SprintOp_Special_SUBU(char * str, DWORD dwAddr, DWORD dwOp)		{ sprintf(str, "SUBU      %s = %s - %s", RegNames[rd(dwOp)], RegNames[rs(dwOp)], RegNames[rt(dwOp)]); }
void SprintOp_Special_AND(char * str, DWORD dwAddr, DWORD dwOp)			{ sprintf(str, "AND       %s = %s & %s", RegNames[rd(dwOp)], RegNames[rs(dwOp)], RegNames[rt(dwOp)]); }
void SprintOp_Special_OR(char * str, DWORD dwAddr, DWORD dwOp)			{
							if (rs(dwOp) == 0 && rt(dwOp) == 0)			  sprintf(str, "CLEAR     %s = 0", RegNames[rd(dwOp)]);
 							else if (rt(dwOp) == 0)						  sprintf(str, "MOV       %s = %s", RegNames[rd(dwOp)], RegNames[rs(dwOp)]);
							else										  sprintf(str, "OR        %s = %s | %s", RegNames[rd(dwOp)], RegNames[rs(dwOp)], RegNames[rt(dwOp)]); }
void SprintOp_Special_XOR(char * str, DWORD dwAddr, DWORD dwOp)			{ sprintf(str, "XOR       %s = %s ^ %s", RegNames[rd(dwOp)], RegNames[rs(dwOp)], RegNames[rt(dwOp)]); }
void SprintOp_Special_NOR(char * str, DWORD dwAddr, DWORD dwOp)			{ sprintf(str, "NOR       %s = ~(%s | %s)", RegNames[rd(dwOp)], RegNames[rs(dwOp)], RegNames[rt(dwOp)]); }
void SprintOp_Special_SLT(char * str, DWORD dwAddr, DWORD dwOp)			{ sprintf(str, "SLT       %s = (%s<%s)", RegNames[rd(dwOp)], RegNames[rs(dwOp)], RegNames[rt(dwOp)]); }
void SprintOp_Special_SLTU(char * str, DWORD dwAddr, DWORD dwOp)		{ sprintf(str, "SLTU      %s = (%s<%s)", RegNames[rd(dwOp)], RegNames[rs(dwOp)], RegNames[rt(dwOp)]); }
void SprintOp_Special_DADD(char * str, DWORD dwAddr, DWORD dwOp)		{ sprintf(str, "DADD      %s = %s + %s", RegNames[rd(dwOp)], RegNames[rs(dwOp)], RegNames[rt(dwOp)]); }
void SprintOp_Special_DADDU(char * str, DWORD dwAddr, DWORD dwOp)		{ sprintf(str, "DADDU     %s = %s + %s", RegNames[rd(dwOp)], RegNames[rs(dwOp)], RegNames[rt(dwOp)]); }
void SprintOp_Special_DSUB(char * str, DWORD dwAddr, DWORD dwOp)		{ sprintf(str, "DSUB      %s = %s - %s", RegNames[rd(dwOp)], RegNames[rs(dwOp)], RegNames[rt(dwOp)]); }
void SprintOp_Special_DSUBU(char * str, DWORD dwAddr, DWORD dwOp)		{ sprintf(str, "DSUBU     %s = %s - %s", RegNames[rd(dwOp)], RegNames[rs(dwOp)], RegNames[rt(dwOp)]); }
void SprintOp_Special_DSLL(char * str, DWORD dwAddr, DWORD dwOp)		{ sprintf(str, "DSLL      %s = %s << 0x%04x", RegNames[rd(dwOp)], RegNames[rt(dwOp)], sa(dwOp)); }
void SprintOp_Special_DSRL(char * str, DWORD dwAddr, DWORD dwOp)		{ sprintf(str, "DSRL      %s = %s >> 0x%04x", RegNames[rd(dwOp)], RegNames[rt(dwOp)], sa(dwOp)); }
void SprintOp_Special_DSRA(char * str, DWORD dwAddr, DWORD dwOp)		{ sprintf(str, "DSRA      %s = %s >> 0x%04x", RegNames[rd(dwOp)], RegNames[rt(dwOp)], sa(dwOp)); }
void SprintOp_Special_DSLL32(char * str, DWORD dwAddr, DWORD dwOp)		{ sprintf(str, "DSLL32    %s = %s << 0x%04x", RegNames[rd(dwOp)], RegNames[rt(dwOp)], sa(dwOp)+32); }
void SprintOp_Special_DSRL32(char * str, DWORD dwAddr, DWORD dwOp)		{ sprintf(str, "DSRL32    %s = %s >> 0x%04x", RegNames[rd(dwOp)], RegNames[rt(dwOp)], sa(dwOp)+32); }
void SprintOp_Special_DSRA32(char * str, DWORD dwAddr, DWORD dwOp)		{ sprintf(str, "DSRA32    %s = %s >> 0x%04x", RegNames[rd(dwOp)], RegNames[rt(dwOp)], sa(dwOp)+32); }

void SprintOp_Special_TGE(char * str, DWORD dwAddr, DWORD dwOp)			{ sprintf(str, "TGE       %s >= %s", RegNames[rs(dwOp)], RegNames[rt(dwOp)]); }
void SprintOp_Special_TGEU(char * str, DWORD dwAddr, DWORD dwOp)		{ sprintf(str, "TGEU      %s >= %s", RegNames[rs(dwOp)], RegNames[rt(dwOp)]); }
void SprintOp_Special_TLT(char * str, DWORD dwAddr, DWORD dwOp)			{ sprintf(str, "TLT       %s < %s", RegNames[rs(dwOp)], RegNames[rt(dwOp)]); }
void SprintOp_Special_TLTU(char * str, DWORD dwAddr, DWORD dwOp)		{ sprintf(str, "TLTU      %s < %s", RegNames[rs(dwOp)], RegNames[rt(dwOp)]); }
void SprintOp_Special_TEQ(char * str, DWORD dwAddr, DWORD dwOp)			{ sprintf(str, "TEQ       %s == %s", RegNames[rs(dwOp)], RegNames[rt(dwOp)]); }
void SprintOp_Special_TNE(char * str, DWORD dwAddr, DWORD dwOp)			{ sprintf(str, "TNE       %s != %s", RegNames[rs(dwOp)], RegNames[rt(dwOp)]); }

void SprintOp_RegImm_Unk(char * str, DWORD dwAddr, DWORD dwOp)			{ sprintf(str, "?"); }

void SprintOp_RegImm_BLTZ(char * str, DWORD dwAddr, DWORD dwOp)			{ sprintf(str, "BLTZ      %s < 0 --> 0x%08x", RegNames[rs(dwOp)], BranchAddress(dwOp, dwAddr)); }
void SprintOp_RegImm_BGEZ(char * str, DWORD dwAddr, DWORD dwOp)			{ sprintf(str, "BGEZ      %s >= 0 --> 0x%08x", RegNames[rs(dwOp)], BranchAddress(dwOp, dwAddr)); }
void SprintOp_RegImm_BLTZL(char * str, DWORD dwAddr, DWORD dwOp)		{ sprintf(str, "BLTZL     %s < 0 --> 0x%08x", RegNames[rs(dwOp)], BranchAddress(dwOp, dwAddr)); }
void SprintOp_RegImm_BGEZL(char * str, DWORD dwAddr, DWORD dwOp)		{ sprintf(str, "BGEZL     %s >= 0 --> 0x%08x", RegNames[rs(dwOp)], BranchAddress(dwOp, dwAddr)); }
void SprintOp_RegImm_BLTZAL(char * str, DWORD dwAddr, DWORD dwOp)		{ sprintf(str, "BLTZAL    %s < 0 --> 0x%08x", RegNames[rs(dwOp)], BranchAddress(dwOp, dwAddr)); }
void SprintOp_RegImm_BGEZAL(char * str, DWORD dwAddr, DWORD dwOp)		{ sprintf(str, "BGEZAL    %s >= 0 --> 0x%08x", RegNames[rs(dwOp)], BranchAddress(dwOp, dwAddr)); }
void SprintOp_RegImm_BLTZALL(char * str, DWORD dwAddr, DWORD dwOp)		{ sprintf(str, "BLTZALL   %s < 0 --> 0x%08x", RegNames[rs(dwOp)], BranchAddress(dwOp, dwAddr)); }
void SprintOp_RegImm_BGEZALL(char * str, DWORD dwAddr, DWORD dwOp)		{ sprintf(str, "BGEZALL   %s >= 0 --> 0x%08x", RegNames[rs(dwOp)], BranchAddress(dwOp, dwAddr)); }

void SprintOp_RegImm_TGEI(char * str, DWORD dwAddr, DWORD dwOp)			{ sprintf(str, "TGEI      %s >= 0x%04x", RegNames[rs(dwOp)], imm(dwOp)); }
void SprintOp_RegImm_TGEIU(char * str, DWORD dwAddr, DWORD dwOp)		{ sprintf(str, "TGEIU     %s >= 0x%04x", RegNames[rs(dwOp)], imm(dwOp)); }
void SprintOp_RegImm_TLTI(char * str, DWORD dwAddr, DWORD dwOp)			{ sprintf(str, "TLTI      %s < 0x%04x", RegNames[rs(dwOp)], imm(dwOp)); }
void SprintOp_RegImm_TLTIU(char * str, DWORD dwAddr, DWORD dwOp)		{ sprintf(str, "TLTIU     %s < 0x%04x", RegNames[rs(dwOp)], imm(dwOp)); }
void SprintOp_RegImm_TEQI(char * str, DWORD dwAddr, DWORD dwOp)			{ sprintf(str, "TEQI      %s == 0x%04x", RegNames[rs(dwOp)], imm(dwOp)); }
void SprintOp_RegImm_TNEI(char * str, DWORD dwAddr, DWORD dwOp)			{ sprintf(str, "TNEI      %s != 0x%04x", RegNames[rs(dwOp)], imm(dwOp)); }


void SprintOp_Cop0_Unk(char * str, DWORD dwAddr, DWORD dwOp)			{ sprintf(str, "?"); }
void SprintOp_Cop0_MFC0(char * str, DWORD dwAddr, DWORD dwOp)			{ sprintf(str, "MFC0      %s <- %s", RegNames[rt(dwOp)], Cop0RegNames[fs(dwOp)]); }
void SprintOp_Cop0_MTC0(char * str, DWORD dwAddr, DWORD dwOp)			{ sprintf(str, "MTC0      %s -> %s", RegNames[rt(dwOp)], Cop0RegNames[fs(dwOp)]); }
void SprintOp_Cop0_TLB(char * str, DWORD dwAddr, DWORD dwOp)			{ SprintOp_TLBInstructions[funct(dwOp)](str, dwAddr, dwOp); }


void SprintOp_TLB_Unk(char * str, DWORD dwAddr, DWORD dwOp)				{ sprintf(str, "?"); }
void SprintOp_TLB_TLBR(char * str, DWORD dwAddr, DWORD dwOp)			{ sprintf(str, "TLBR"); }
void SprintOp_TLB_TLBWI(char * str, DWORD dwAddr, DWORD dwOp)			{ sprintf(str, "TLBWI"); }
void SprintOp_TLB_TLBWR(char * str, DWORD dwAddr, DWORD dwOp)			{ sprintf(str, "TLBWR"); }
void SprintOp_TLB_TLBP(char * str, DWORD dwAddr, DWORD dwOp)			{ sprintf(str, "TLBP"); }
void SprintOp_TLB_ERET(char * str, DWORD dwAddr, DWORD dwOp)			{ sprintf(str, "ERET"); }

void SprintOp_Cop1_Unk(char * str, DWORD dwAddr, DWORD dwOp)			{ sprintf(str, "?"); }
void SprintOp_Cop1_MFC1(char * str, DWORD dwAddr, DWORD dwOp)			{ sprintf(str, "MFC1      %s <- FP%02d", RegNames[rt(dwOp)], fs(dwOp)); }
void SprintOp_Cop1_DMFC1(char * str, DWORD dwAddr, DWORD dwOp)			{ sprintf(str, "DMFC1     %s <- FP%02d", RegNames[rt(dwOp)], fs(dwOp)); }
void SprintOp_Cop1_CFC1(char * str, DWORD dwAddr, DWORD dwOp)			{ sprintf(str, "CFC1      %s <- CCR%02d", RegNames[rt(dwOp)], rd(dwOp)); }
void SprintOp_Cop1_MTC1(char * str, DWORD dwAddr, DWORD dwOp)			{ sprintf(str, "MTC1      %s -> FP%02d", RegNames[rt(dwOp)], fs(dwOp)); }
void SprintOp_Cop1_DMTC1(char * str, DWORD dwAddr, DWORD dwOp)			{ sprintf(str, "DMTC1     %s -> FP%02d", RegNames[rt(dwOp)], fs(dwOp)); }
void SprintOp_Cop1_CTC1(char * str, DWORD dwAddr, DWORD dwOp)			{ sprintf(str, "CTC1      %s -> CCR%02d", RegNames[rt(dwOp)], rd(dwOp)); }
void SprintOp_Cop1_BCInstr(char * str, DWORD dwAddr, DWORD dwOp)		{ sprintf(str, "%-10.10s%08x", Cop1BC1OpCodeNames[bc(dwOp)], BranchAddress(dwOp, dwAddr)); }


void SprintOp_Cop1_SInstr(char * str, DWORD dwAddr, DWORD dwOp) { SprintOp_Cop1SInstruction[funct(dwOp)](str, dwAddr, dwOp); }

void SprintOp_Cop1_S_Unk(char * str, DWORD dwAddr, DWORD dwOp)			{ sprintf(str, "?"); }
void SprintOp_Cop1_S_ADD(char * str, DWORD dwAddr, DWORD dwOp)			{ sprintf(str, "ADD.S     FP%02d = FP%02d + FP%02d", fd(dwOp), fs(dwOp), ft(dwOp)); }
void SprintOp_Cop1_S_SUB(char * str, DWORD dwAddr, DWORD dwOp)			{ sprintf(str, "SUB.S     FP%02d = FP%02d - FP%02d", fd(dwOp), fs(dwOp), ft(dwOp)); }
void SprintOp_Cop1_S_MUL(char * str, DWORD dwAddr, DWORD dwOp)			{ sprintf(str, "MUL.S     FP%02d = FP%02d * FP%02d", fd(dwOp), fs(dwOp), ft(dwOp)); }
void SprintOp_Cop1_S_DIV(char * str, DWORD dwAddr, DWORD dwOp)			{ sprintf(str, "DIV.S     FP%02d = FP%02d / FP%02d", fd(dwOp), fs(dwOp), ft(dwOp)); }
void SprintOp_Cop1_S_SQRT(char * str, DWORD dwAddr, DWORD dwOp)			{ sprintf(str, "SQRT.S    FP%02d = sqrt(FP%02d)", fd(dwOp), fs(dwOp)); }
void SprintOp_Cop1_S_ABS(char * str, DWORD dwAddr, DWORD dwOp)			{ sprintf(str, "ABS.S     FP%02d = fabs(FP%02d)", fd(dwOp), fs(dwOp)); }
void SprintOp_Cop1_S_MOV(char * str, DWORD dwAddr, DWORD dwOp)			{ sprintf(str, "MOV.S     FP%02d = FP%02d", fd(dwOp), fs(dwOp)); }
void SprintOp_Cop1_S_NEG(char * str, DWORD dwAddr, DWORD dwOp)			{ sprintf(str, "NEG.S     FP%02d = -FP%02d", fd(dwOp), fs(dwOp)); }
void SprintOp_Cop1_S_ROUND_L(char * str, DWORD dwAddr, DWORD dwOp)		{ sprintf(str, "RND.L.S   FP%02d = round(FP%02d)", fd(dwOp), fs(dwOp)); }
void SprintOp_Cop1_S_TRUNC_L(char * str, DWORD dwAddr, DWORD dwOp)		{ sprintf(str, "TRUN.L.S  FP%02d = trunc(FP%02d)", fd(dwOp), fs(dwOp)); }
void SprintOp_Cop1_S_CEIL_L(char * str, DWORD dwAddr, DWORD dwOp)		{ sprintf(str, "CEIL.L.S  FP%02d = ceil(FP%02d)", fd(dwOp), fs(dwOp)); }
void SprintOp_Cop1_S_FLOOR_L(char * str, DWORD dwAddr, DWORD dwOp)		{ sprintf(str, "FLR.L.S   FP%02d = floor(FP%02d)", fd(dwOp), fs(dwOp)); }
void SprintOp_Cop1_S_ROUND_W(char * str, DWORD dwAddr, DWORD dwOp)		{ sprintf(str, "RND.W.S   FP%02d = round(FP%02d)", fd(dwOp), fs(dwOp)); }
void SprintOp_Cop1_S_TRUNC_W(char * str, DWORD dwAddr, DWORD dwOp)		{ sprintf(str, "TRUN.W.S  FP%02d = trunc(FP%02d)", fd(dwOp), fs(dwOp)); }
void SprintOp_Cop1_S_CEIL_W(char * str, DWORD dwAddr, DWORD dwOp)		{ sprintf(str, "CEIL.W.S  FP%02d = ceil(FP%02d)", fd(dwOp), fs(dwOp)); }
void SprintOp_Cop1_S_FLOOR_W(char * str, DWORD dwAddr, DWORD dwOp)		{ sprintf(str, "FLR.W.S   FP%02d = floor(FP%02d)", fd(dwOp), fs(dwOp)); }
void SprintOp_Cop1_S_CVT_D(char * str, DWORD dwAddr, DWORD dwOp)		{ sprintf(str, "CVT.D.S   FP%02d = (d)FP%02d", fd(dwOp), fs(dwOp)); }
void SprintOp_Cop1_S_CVT_W(char * str, DWORD dwAddr, DWORD dwOp)		{ sprintf(str, "CVT.W.S   FP%02d = (w)FP%02d", fd(dwOp), fs(dwOp)); }
void SprintOp_Cop1_S_CVT_L(char * str, DWORD dwAddr, DWORD dwOp)		{ sprintf(str, "CVT.L.S   FP%02d = (l)FP%02d", fd(dwOp), fs(dwOp)); }

void SprintOp_Cop1_S_F(char * str, DWORD dwAddr, DWORD dwOp)			{ sprintf(str, "C.F.S     FP%02d ? FP%02d", fs(dwOp), ft(dwOp)); }
void SprintOp_Cop1_S_UN(char * str, DWORD dwAddr, DWORD dwOp)			{ sprintf(str, "C.UN.S    FP%02d ? FP%02d", fs(dwOp), ft(dwOp)); }
void SprintOp_Cop1_S_EQ(char * str, DWORD dwAddr, DWORD dwOp)			{ sprintf(str, "C.EQ.S    FP%02d ? FP%02d", fs(dwOp), ft(dwOp)); }
void SprintOp_Cop1_S_UEQ(char * str, DWORD dwAddr, DWORD dwOp)			{ sprintf(str, "C.UEQ.S   FP%02d ? FP%02d", fs(dwOp), ft(dwOp)); }
void SprintOp_Cop1_S_OLT(char * str, DWORD dwAddr, DWORD dwOp)			{ sprintf(str, "C.OLT.S   FP%02d ? FP%02d", fs(dwOp), ft(dwOp)); }
void SprintOp_Cop1_S_ULT(char * str, DWORD dwAddr, DWORD dwOp)			{ sprintf(str, "C.ULT.S   FP%02d ? FP%02d", fs(dwOp), ft(dwOp)); }
void SprintOp_Cop1_S_OLE(char * str, DWORD dwAddr, DWORD dwOp)			{ sprintf(str, "C.OLE.S   FP%02d ? FP%02d", fs(dwOp), ft(dwOp)); }
void SprintOp_Cop1_S_ULE(char * str, DWORD dwAddr, DWORD dwOp)			{ sprintf(str, "C.ULE.S   FP%02d ? FP%02d", fs(dwOp), ft(dwOp)); }
void SprintOp_Cop1_S_SF(char * str, DWORD dwAddr, DWORD dwOp)			{ sprintf(str, "C.SF.S    FP%02d ? FP%02d", fs(dwOp), ft(dwOp)); }
void SprintOp_Cop1_S_NGLE(char * str, DWORD dwAddr, DWORD dwOp)			{ sprintf(str, "C.NGLE.S  FP%02d ? FP%02d", fs(dwOp), ft(dwOp)); }
void SprintOp_Cop1_S_SEQ(char * str, DWORD dwAddr, DWORD dwOp)			{ sprintf(str, "C.SEQ.S   FP%02d ? FP%02d", fs(dwOp), ft(dwOp)); }
void SprintOp_Cop1_S_NGL(char * str, DWORD dwAddr, DWORD dwOp)			{ sprintf(str, "C.NGL.S   FP%02d ? FP%02d", fs(dwOp), ft(dwOp)); }
void SprintOp_Cop1_S_LT(char * str, DWORD dwAddr, DWORD dwOp)			{ sprintf(str, "C.LT.S    FP%02d < FP%02d", fs(dwOp), ft(dwOp)); }
void SprintOp_Cop1_S_NGE(char * str, DWORD dwAddr, DWORD dwOp)			{ sprintf(str, "C.NGE.S   FP%02d ? FP%02d", fs(dwOp), ft(dwOp)); }
void SprintOp_Cop1_S_LE(char * str, DWORD dwAddr, DWORD dwOp) 			{ sprintf(str, "C.LE.S    FP%02d <= FP%02d", fs(dwOp), ft(dwOp)); }
void SprintOp_Cop1_S_NGT(char * str, DWORD dwAddr, DWORD dwOp) 			{ sprintf(str, "C.NGT.S   FP%02d ? FP%02d", fs(dwOp), ft(dwOp)); }

void SprintOp_Cop1_DInstr(char * str, DWORD dwAddr, DWORD dwOp) { SprintOp_Cop1DInstruction[funct(dwOp)](str, dwAddr, dwOp); }

void SprintOp_Cop1_D_Unk(char * str, DWORD dwAddr, DWORD dwOp)			{ sprintf(str, "?"); }
void SprintOp_Cop1_D_ADD(char * str, DWORD dwAddr, DWORD dwOp)			{ sprintf(str, "ADD.D     FP%02d = FP%02d + FP%02d", fd(dwOp), fs(dwOp), ft(dwOp)); }
void SprintOp_Cop1_D_SUB(char * str, DWORD dwAddr, DWORD dwOp)			{ sprintf(str, "SUB.D     FP%02d = FP%02d - FP%02d", fd(dwOp), fs(dwOp), ft(dwOp)); }
void SprintOp_Cop1_D_MUL(char * str, DWORD dwAddr, DWORD dwOp)			{ sprintf(str, "MUL.D     FP%02d = FP%02d * FP%02d", fd(dwOp), fs(dwOp), ft(dwOp)); }
void SprintOp_Cop1_D_DIV(char * str, DWORD dwAddr, DWORD dwOp)			{ sprintf(str, "DIV.D     FP%02d = FP%02d / FP%02d", fd(dwOp), fs(dwOp), ft(dwOp)); }
void SprintOp_Cop1_D_SQRT(char * str, DWORD dwAddr, DWORD dwOp)			{ sprintf(str, "SQRT.D    FP%02d = sqrt(FP%02d)", fd(dwOp), fs(dwOp)); }
void SprintOp_Cop1_D_ABS(char * str, DWORD dwAddr, DWORD dwOp)			{ sprintf(str, "ABS.D     FP%02d = fabs(FP%02d)", fd(dwOp), fs(dwOp)); }
void SprintOp_Cop1_D_MOV(char * str, DWORD dwAddr, DWORD dwOp)			{ sprintf(str, "MOV.D     FP%02d = FP%02d", fd(dwOp), fs(dwOp)); }
void SprintOp_Cop1_D_NEG(char * str, DWORD dwAddr, DWORD dwOp)			{ sprintf(str, "NEG.D     FP%02d = -FP%02d", fd(dwOp), fs(dwOp)); }
void SprintOp_Cop1_D_ROUND_L(char * str, DWORD dwAddr, DWORD dwOp)		{ sprintf(str, "RND.L.D   FP%02d = round(FP%02d)", fd(dwOp), fs(dwOp)); }
void SprintOp_Cop1_D_TRUNC_L(char * str, DWORD dwAddr, DWORD dwOp)		{ sprintf(str, "TRUN.L.D  FP%02d = trunc(FP%02d)", fd(dwOp), fs(dwOp)); }
void SprintOp_Cop1_D_CEIL_L(char * str, DWORD dwAddr, DWORD dwOp)		{ sprintf(str, "CEIL.L.D  FP%02d = ceil(FP%02d)", fd(dwOp), fs(dwOp)); }
void SprintOp_Cop1_D_FLOOR_L(char * str, DWORD dwAddr, DWORD dwOp)		{ sprintf(str, "FLR.L.D   FP%02d = floor(FP%02d)", fd(dwOp), fs(dwOp)); }
void SprintOp_Cop1_D_ROUND_W(char * str, DWORD dwAddr, DWORD dwOp)		{ sprintf(str, "RND.W.D   FP%02d = round(FP%02d)", fd(dwOp), fs(dwOp)); }
void SprintOp_Cop1_D_TRUNC_W(char * str, DWORD dwAddr, DWORD dwOp)		{ sprintf(str, "TRUN.W.D  FP%02d = trunc(FP%02d)", fd(dwOp), fs(dwOp)); }
void SprintOp_Cop1_D_CEIL_W(char * str, DWORD dwAddr, DWORD dwOp)		{ sprintf(str, "CEIL.W.D  FP%02d = ceil(FP%02d)", fd(dwOp), fs(dwOp)); }
void SprintOp_Cop1_D_FLOOR_W(char * str, DWORD dwAddr, DWORD dwOp)		{ sprintf(str, "FLR.W.D   FP%02d = floor(FP%02d)", fd(dwOp), fs(dwOp)); }
void SprintOp_Cop1_D_CVT_S(char * str, DWORD dwAddr, DWORD dwOp)		{ sprintf(str, "CVT.S.D   FP%02d = (s)FP%02d", fd(dwOp), fs(dwOp)); }
void SprintOp_Cop1_D_CVT_W(char * str, DWORD dwAddr, DWORD dwOp)		{ sprintf(str, "CVT.W.D   FP%02d = (w)FP%02d", fd(dwOp), fs(dwOp)); }
void SprintOp_Cop1_D_CVT_L(char * str, DWORD dwAddr, DWORD dwOp)		{ sprintf(str, "CVT.L.D   FP%02d = (l)FP%02d", fd(dwOp), fs(dwOp)); }

void SprintOp_Cop1_D_F(char * str, DWORD dwAddr, DWORD dwOp)			{ sprintf(str, "C.F.D     FP%02d ? FP%02d", fs(dwOp), ft(dwOp)); }
void SprintOp_Cop1_D_UN(char * str, DWORD dwAddr, DWORD dwOp)			{ sprintf(str, "C.UN.D    FP%02d ? FP%02d", fs(dwOp), ft(dwOp)); }
void SprintOp_Cop1_D_EQ(char * str, DWORD dwAddr, DWORD dwOp)			{ sprintf(str, "C.EQ.D    FP%02d ? FP%02d", fs(dwOp), ft(dwOp)); }
void SprintOp_Cop1_D_UEQ(char * str, DWORD dwAddr, DWORD dwOp)			{ sprintf(str, "C.UEQ.D   FP%02d ? FP%02d", fs(dwOp), ft(dwOp)); }
void SprintOp_Cop1_D_OLT(char * str, DWORD dwAddr, DWORD dwOp)			{ sprintf(str, "C.OLT.D   FP%02d ? FP%02d", fs(dwOp), ft(dwOp)); }
void SprintOp_Cop1_D_ULT(char * str, DWORD dwAddr, DWORD dwOp)			{ sprintf(str, "C.ULT.D   FP%02d ? FP%02d", fs(dwOp), ft(dwOp)); }
void SprintOp_Cop1_D_OLE(char * str, DWORD dwAddr, DWORD dwOp)			{ sprintf(str, "C.OLE.D   FP%02d ? FP%02d", fs(dwOp), ft(dwOp)); }
void SprintOp_Cop1_D_ULE(char * str, DWORD dwAddr, DWORD dwOp)			{ sprintf(str, "C.ULE.D   FP%02d ? FP%02d", fs(dwOp), ft(dwOp)); }
void SprintOp_Cop1_D_SF(char * str, DWORD dwAddr, DWORD dwOp)			{ sprintf(str, "C.DF.D    FP%02d ? FP%02d", fs(dwOp), ft(dwOp)); }
void SprintOp_Cop1_D_NGLE(char * str, DWORD dwAddr, DWORD dwOp)			{ sprintf(str, "C.NGLE.D  FP%02d ? FP%02d", fs(dwOp), ft(dwOp)); }
void SprintOp_Cop1_D_SEQ(char * str, DWORD dwAddr, DWORD dwOp)			{ sprintf(str, "C.DEQ.D   FP%02d ? FP%02d", fs(dwOp), ft(dwOp)); }
void SprintOp_Cop1_D_NGL(char * str, DWORD dwAddr, DWORD dwOp)			{ sprintf(str, "C.NGL.D   FP%02d ? FP%02d", fs(dwOp), ft(dwOp)); }
void SprintOp_Cop1_D_LT(char * str, DWORD dwAddr, DWORD dwOp)			{ sprintf(str, "C.LT.D    FP%02d < FP%02d", fs(dwOp), ft(dwOp)); }
void SprintOp_Cop1_D_NGE(char * str, DWORD dwAddr, DWORD dwOp)			{ sprintf(str, "C.NGE.D   FP%02d ? FP%02d", fs(dwOp), ft(dwOp)); }
void SprintOp_Cop1_D_LE(char * str, DWORD dwAddr, DWORD dwOp) 			{ sprintf(str, "C.LE.D    FP%02d <= FP%02d", fs(dwOp), ft(dwOp)); }
void SprintOp_Cop1_D_NGT(char * str, DWORD dwAddr, DWORD dwOp) 			{ sprintf(str, "C.NGT.D   FP%02d ? FP%02d", fs(dwOp), ft(dwOp)); }


void SprintOp_Cop1_WInstr(char * str, DWORD dwAddr, DWORD dwOp)
{
	sprintf(str, "%-10.10sFP%02d,FP%02d", Cop1WOpCodeNames[funct(dwOp)], fd(dwOp), fs(dwOp));

}
void SprintOp_Cop1_LInstr(char * str, DWORD dwAddr, DWORD dwOp)
{
	sprintf(str, "%-10.10sFP%02d,FP%02d", Cop1LOpCodeNames[funct(dwOp)], fd(dwOp), fs(dwOp));
}
	





//////////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////////
//////////////////////////////// RSP /////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////////


// Opcode Jump Table
SprintOpInstruction SprintRSPOp_Instructions[64] = {
	SprintRSPOp_Special, SprintRSPOp_RegImm, SprintRSPOp_J,      SprintRSPOp_JAL,   SprintRSPOp_BEQ,  SprintRSPOp_BNE, SprintRSPOp_BLEZ, SprintRSPOp_BGTZ,
	SprintRSPOp_ADDI,    SprintRSPOp_ADDIU,  SprintRSPOp_SLTI,   SprintRSPOp_SLTIU, SprintRSPOp_ANDI, SprintRSPOp_ORI, SprintRSPOp_XORI, SprintRSPOp_LUI,
	SprintRSPOp_CoPro0,  SprintRSPOp_Unk,    SprintRSPOp_CoPro2, SprintRSPOp_Unk,   SprintRSPOp_Unk,  SprintRSPOp_Unk, SprintRSPOp_Unk,  SprintRSPOp_Unk,
	SprintRSPOp_Unk,     SprintRSPOp_Unk,    SprintRSPOp_Unk,    SprintRSPOp_Unk,   SprintRSPOp_Unk,  SprintRSPOp_Unk, SprintRSPOp_Unk,  SprintRSPOp_Unk,
	SprintRSPOp_LB,      SprintRSPOp_LH,     SprintRSPOp_Unk,    SprintRSPOp_LW,    SprintRSPOp_LBU,  SprintRSPOp_LHU, SprintRSPOp_Unk,  SprintRSPOp_Unk,
	SprintRSPOp_SB,      SprintRSPOp_SH,     SprintRSPOp_Unk,    SprintRSPOp_SW,    SprintRSPOp_Unk,  SprintRSPOp_Unk, SprintRSPOp_Unk,  SprintRSPOp_Unk,
	SprintRSPOp_Unk,     SprintRSPOp_Unk,    SprintRSPOp_LWC2,   SprintRSPOp_Unk,   SprintRSPOp_Unk,  SprintRSPOp_Unk, SprintRSPOp_Unk,  SprintRSPOp_Unk,
	SprintRSPOp_Unk,     SprintRSPOp_Unk,    SprintRSPOp_SWC2,   SprintRSPOp_Unk,   SprintRSPOp_Unk,  SprintRSPOp_Unk, SprintRSPOp_Unk,  SprintRSPOp_Unk
};

SprintOpInstruction SprintRSPOp_SpecialInstructions[64] = {
	SprintRSPOp_Special_SLL, SprintRSPOp_Special_Unk,  SprintRSPOp_Special_SRL, SprintRSPOp_Special_SRA,  SprintRSPOp_Special_SLLV, SprintRSPOp_Special_Unk,   SprintRSPOp_Special_SRLV, SprintRSPOp_Special_SRAV,
	SprintRSPOp_Special_JR,  SprintRSPOp_Special_JALR, SprintRSPOp_Special_Unk, SprintRSPOp_Special_Unk,  SprintRSPOp_Special_Unk,  SprintRSPOp_Special_BREAK, SprintRSPOp_Special_Unk,  SprintRSPOp_Special_Unk,
	SprintRSPOp_Special_Unk, SprintRSPOp_Special_Unk,  SprintRSPOp_Special_Unk, SprintRSPOp_Special_Unk,  SprintRSPOp_Special_Unk,  SprintRSPOp_Special_Unk,   SprintRSPOp_Special_Unk,  SprintRSPOp_Special_Unk,
	SprintRSPOp_Special_Unk, SprintRSPOp_Special_Unk,  SprintRSPOp_Special_Unk, SprintRSPOp_Special_Unk,  SprintRSPOp_Special_Unk,  SprintRSPOp_Special_Unk,   SprintRSPOp_Special_Unk,  SprintRSPOp_Special_Unk,
	SprintRSPOp_Special_ADD, SprintRSPOp_Special_ADDU, SprintRSPOp_Special_SUB, SprintRSPOp_Special_SUBU, SprintRSPOp_Special_AND,  SprintRSPOp_Special_OR,    SprintRSPOp_Special_XOR,  SprintRSPOp_Special_NOR,
	SprintRSPOp_Special_Unk, SprintRSPOp_Special_Unk,  SprintRSPOp_Special_SLT, SprintRSPOp_Special_SLTU, SprintRSPOp_Special_Unk,  SprintRSPOp_Special_Unk,   SprintRSPOp_Special_Unk,  SprintRSPOp_Special_Unk,
	SprintRSPOp_Special_Unk, SprintRSPOp_Special_Unk,  SprintRSPOp_Special_Unk, SprintRSPOp_Special_Unk,  SprintRSPOp_Special_Unk,  SprintRSPOp_Special_Unk,   SprintRSPOp_Special_Unk,  SprintRSPOp_Special_Unk,
	SprintRSPOp_Special_Unk, SprintRSPOp_Special_Unk,  SprintRSPOp_Special_Unk, SprintRSPOp_Special_Unk,  SprintRSPOp_Special_Unk,  SprintRSPOp_Special_Unk,   SprintRSPOp_Special_Unk,  SprintRSPOp_Special_Unk
};

SprintOpInstruction SprintRSPOp_RegImmInstructions[32] = {
	SprintRSPOp_RegImm_BLTZ,   SprintRSPOp_RegImm_BGEZ,   SprintRSPOp_RegImm_Unk,  SprintRSPOp_RegImm_Unk, SprintRSPOp_RegImm_Unk, SprintRSPOp_RegImm_Unk, SprintRSPOp_RegImm_Unk, SprintRSPOp_RegImm_Unk,
	SprintRSPOp_RegImm_Unk,    SprintRSPOp_RegImm_Unk,    SprintRSPOp_RegImm_Unk,  SprintRSPOp_RegImm_Unk, SprintRSPOp_RegImm_Unk, SprintRSPOp_RegImm_Unk, SprintRSPOp_RegImm_Unk, SprintRSPOp_RegImm_Unk,
	SprintRSPOp_RegImm_BLTZAL, SprintRSPOp_RegImm_BGEZAL, SprintRSPOp_RegImm_Unk,  SprintRSPOp_RegImm_Unk, SprintRSPOp_RegImm_Unk, SprintRSPOp_RegImm_Unk, SprintRSPOp_RegImm_Unk, SprintRSPOp_RegImm_Unk,
	SprintRSPOp_RegImm_Unk,    SprintRSPOp_RegImm_Unk,    SprintRSPOp_RegImm_Unk,  SprintRSPOp_RegImm_Unk, SprintRSPOp_RegImm_Unk, SprintRSPOp_RegImm_Unk, SprintRSPOp_RegImm_Unk, SprintRSPOp_RegImm_Unk
};

SprintOpInstruction SprintRSPOp_Cop0Instructions[32] = {
	SprintRSPOp_Cop0_MFC0, SprintRSPOp_Cop0_Unk, SprintRSPOp_Cop0_Unk, SprintRSPOp_Cop0_Unk, SprintRSPOp_Cop0_MTC0, SprintRSPOp_Cop0_Unk, SprintRSPOp_Cop0_Unk, SprintRSPOp_Cop0_Unk,
	SprintRSPOp_Cop0_Unk, SprintRSPOp_Cop0_Unk, SprintRSPOp_Cop0_Unk, SprintRSPOp_Cop0_Unk, SprintRSPOp_Cop0_Unk, SprintRSPOp_Cop0_Unk, SprintRSPOp_Cop0_Unk, SprintRSPOp_Cop0_Unk,
	SprintRSPOp_Cop0_Unk, SprintRSPOp_Cop0_Unk, SprintRSPOp_Cop0_Unk, SprintRSPOp_Cop0_Unk, SprintRSPOp_Cop0_Unk, SprintRSPOp_Cop0_Unk, SprintRSPOp_Cop0_Unk, SprintRSPOp_Cop0_Unk,
	SprintRSPOp_Cop0_Unk, SprintRSPOp_Cop0_Unk, SprintRSPOp_Cop0_Unk, SprintRSPOp_Cop0_Unk, SprintRSPOp_Cop0_Unk, SprintRSPOp_Cop0_Unk, SprintRSPOp_Cop0_Unk, SprintRSPOp_Cop0_Unk,
};

SprintOpInstruction SprintRSPOp_LWC2Instructions[32] = {
	SprintRSPOp_LWC2_LBV, SprintRSPOp_LWC2_LSV, SprintRSPOp_LWC2_LLV, SprintRSPOp_LWC2_LDV, SprintRSPOp_LWC2_LQV, SprintRSPOp_LWC2_LRV, SprintRSPOp_LWC2_LPV, SprintRSPOp_LWC2_LUV,
	SprintRSPOp_LWC2_LHV, SprintRSPOp_LWC2_LFV, SprintRSPOp_LWC2_LWV, SprintRSPOp_LWC2_LTV, SprintRSPOp_LWC2_Unk, SprintRSPOp_LWC2_Unk, SprintRSPOp_LWC2_Unk, SprintRSPOp_LWC2_Unk,
	SprintRSPOp_LWC2_Unk, SprintRSPOp_LWC2_Unk, SprintRSPOp_LWC2_Unk, SprintRSPOp_LWC2_Unk, SprintRSPOp_LWC2_Unk, SprintRSPOp_LWC2_Unk, SprintRSPOp_LWC2_Unk, SprintRSPOp_LWC2_Unk,
	SprintRSPOp_LWC2_Unk, SprintRSPOp_LWC2_Unk, SprintRSPOp_LWC2_Unk, SprintRSPOp_LWC2_Unk, SprintRSPOp_LWC2_Unk, SprintRSPOp_LWC2_Unk, SprintRSPOp_LWC2_Unk, SprintRSPOp_LWC2_Unk,
};

SprintOpInstruction SprintRSPOp_SWC2Instructions[32] = {
	SprintRSPOp_SWC2_SBV, SprintRSPOp_SWC2_SSV, SprintRSPOp_SWC2_SLV, SprintRSPOp_SWC2_SDV, SprintRSPOp_SWC2_SQV, SprintRSPOp_SWC2_SRV, SprintRSPOp_SWC2_SPV, SprintRSPOp_SWC2_SUV,
	SprintRSPOp_SWC2_SHV, SprintRSPOp_SWC2_SFV, SprintRSPOp_SWC2_SWV, SprintRSPOp_SWC2_STV, SprintRSPOp_SWC2_Unk, SprintRSPOp_SWC2_Unk, SprintRSPOp_SWC2_Unk, SprintRSPOp_SWC2_Unk,
	SprintRSPOp_SWC2_Unk, SprintRSPOp_SWC2_Unk, SprintRSPOp_SWC2_Unk, SprintRSPOp_SWC2_Unk, SprintRSPOp_SWC2_Unk, SprintRSPOp_SWC2_Unk, SprintRSPOp_SWC2_Unk, SprintRSPOp_SWC2_Unk,
	SprintRSPOp_SWC2_Unk, SprintRSPOp_SWC2_Unk, SprintRSPOp_SWC2_Unk, SprintRSPOp_SWC2_Unk, SprintRSPOp_SWC2_Unk, SprintRSPOp_SWC2_Unk, SprintRSPOp_SWC2_Unk, SprintRSPOp_SWC2_Unk,
};

SprintOpInstruction SprintRSPOp_Cop2Instructions[64] =
{
	SprintRSPOp_Cop2_MFC2, SprintRSPOp_Cop2_Unk, SprintRSPOp_Cop2_Unk, SprintRSPOp_Cop2_Unk, SprintRSPOp_Cop2_MTC2, SprintRSPOp_Cop2_Unk, SprintRSPOp_Cop2_Unk, SprintRSPOp_Cop2_Unk,
	SprintRSPOp_Cop2_Unk,  SprintRSPOp_Cop2_Unk, SprintRSPOp_Cop2_Unk, SprintRSPOp_Cop2_Unk, SprintRSPOp_Cop2_Unk, SprintRSPOp_Cop2_Unk, SprintRSPOp_Cop2_Unk, SprintRSPOp_Cop2_Unk,
	SprintRSPOp_Cop2_VOP,  SprintRSPOp_Cop2_VOP, SprintRSPOp_Cop2_VOP, SprintRSPOp_Cop2_VOP, SprintRSPOp_Cop2_VOP, SprintRSPOp_Cop2_VOP, SprintRSPOp_Cop2_VOP, SprintRSPOp_Cop2_VOP,
	SprintRSPOp_Cop2_VOP,  SprintRSPOp_Cop2_VOP, SprintRSPOp_Cop2_VOP, SprintRSPOp_Cop2_VOP, SprintRSPOp_Cop2_VOP, SprintRSPOp_Cop2_VOP, SprintRSPOp_Cop2_VOP, SprintRSPOp_Cop2_VOP
};

SprintOpInstruction SprintRSPOp_VopInstructions[64] = {
	SprintRSPOp_Vop_VMULF, SprintRSPOp_Vop_VMULU, SprintRSPOp_Vop_VRNDP, SprintRSPOp_Vop_VMULQ, SprintRSPOp_Vop_VMUDL, SprintRSPOp_Vop_VMUDM, SprintRSPOp_Vop_VMUDN, SprintRSPOp_Vop_VMUDH,
	SprintRSPOp_Vop_VMACF, SprintRSPOp_Vop_VMACU, SprintRSPOp_Vop_VRNDN, SprintRSPOp_Vop_VMACQ, SprintRSPOp_Vop_VMADL, SprintRSPOp_Vop_VMADM, SprintRSPOp_Vop_VMADN, SprintRSPOp_Vop_VMADH,
	SprintRSPOp_Vop_VADD,  SprintRSPOp_Vop_VSUB,  SprintRSPOp_Vop_VSUT,  SprintRSPOp_Vop_VABS,  SprintRSPOp_Vop_VADDC, SprintRSPOp_Vop_VSUBC, SprintRSPOp_Vop_VADDB, SprintRSPOp_Vop_VSUBB,
	SprintRSPOp_Vop_VACCB, SprintRSPOp_Vop_VSUCB, SprintRSPOp_Vop_VSAD,  SprintRSPOp_Vop_VSAC,  SprintRSPOp_Vop_VSUM,  SprintRSPOp_Vop_VSAW,  SprintRSPOp_Vop_Unk,   SprintRSPOp_Vop_Unk,
	SprintRSPOp_Vop_VLT,   SprintRSPOp_Vop_VEQ,   SprintRSPOp_Vop_VNE,   SprintRSPOp_Vop_VGE,   SprintRSPOp_Vop_VCL,   SprintRSPOp_Vop_VCH,   SprintRSPOp_Vop_VCR,   SprintRSPOp_Vop_VMRG,
	SprintRSPOp_Vop_VAND,  SprintRSPOp_Vop_VNAND, SprintRSPOp_Vop_VOR,   SprintRSPOp_Vop_VNOR,  SprintRSPOp_Vop_VXOR,  SprintRSPOp_Vop_VNXOR, SprintRSPOp_Vop_Unk,   SprintRSPOp_Vop_Unk,
	SprintRSPOp_Vop_VRCP,  SprintRSPOp_Vop_VRCPL, SprintRSPOp_Vop_VRCPH, SprintRSPOp_Vop_VMOV,  SprintRSPOp_Vop_VRSQ,  SprintRSPOp_Vop_VRSQL, SprintRSPOp_Vop_VRSQH, SprintRSPOp_Vop_Unk,
	SprintRSPOp_Vop_Unk,   SprintRSPOp_Vop_Unk,   SprintRSPOp_Vop_Unk,   SprintRSPOp_Vop_Unk,   SprintRSPOp_Vop_Unk,   SprintRSPOp_Vop_Unk,   SprintRSPOp_Vop_Unk,   SprintRSPOp_Vop_Unk
};

#define RSPJumpTarget(dwOp, dwAddr) (target((dwOp))<<2)



void SprintRSPOp_Unk(char * str, DWORD dwAddr, DWORD dwOp)		{ sprintf(str, "?"); }


void SprintRSPOp_Special(char * str, DWORD dwAddr, DWORD dwOp)	{ SprintRSPOp_SpecialInstructions[funct(dwOp)](str, dwAddr, dwOp); }
void SprintRSPOp_RegImm(char * str, DWORD dwAddr, DWORD dwOp)	{ SprintRSPOp_RegImmInstructions[rt(dwOp)](str, dwAddr, dwOp); }
void SprintRSPOp_CoPro0(char * str, DWORD dwAddr, DWORD dwOp)	{ SprintRSPOp_Cop0Instructions[cop0fmt(dwOp)](str, dwAddr, dwOp); }
void SprintRSPOp_CoPro2(char * str, DWORD dwAddr, DWORD dwOp)	{ SprintRSPOp_Cop2Instructions[cop2fmt(dwOp)](str, dwAddr, dwOp); }
void SprintRSPOp_LWC2(char * str, DWORD dwAddr, DWORD dwOp)		{ SprintRSPOp_LWC2Instructions[rd(dwOp)](str, dwAddr, dwOp); }
void SprintRSPOp_SWC2(char * str, DWORD dwAddr, DWORD dwOp)		{ SprintRSPOp_SWC2Instructions[rd(dwOp)](str, dwAddr, dwOp); }

void SprintRSPOp_Cop2_VOP(char * str, DWORD dwAddr, DWORD dwOp)	{ SprintRSPOp_VopInstructions[funct(dwOp)](str, dwAddr, dwOp); }

void SprintRSPOp_J(char * str, DWORD dwAddr, DWORD dwOp)		{ sprintf(str, "J         0x%04x        %s", RSPJumpTarget(dwOp, dwAddr), "?" ); }
void SprintRSPOp_JAL(char * str, DWORD dwAddr, DWORD dwOp)		{ sprintf(str, "JAL       0x%04x        %s", RSPJumpTarget(dwOp, dwAddr), "?" ); }
void SprintRSPOp_BEQ(char * str, DWORD dwAddr, DWORD dwOp) {
						if (rs(dwOp) == 0 && rt(dwOp) == 0)       sprintf(str, "B         --> 0x%04x", dwAddr+4 + (s16)imm(dwOp)*4);
						else                                      sprintf(str, "BEQ       %s == %s --> 0x%04x", RegNames[rs(dwOp)], RegNames[rt(dwOp)], BranchAddress(dwOp, dwAddr)); }
void SprintRSPOp_BNE(char * str, DWORD dwAddr, DWORD dwOp)		{ sprintf(str, "BNE       %s != %s --> 0x%04x", RegNames[rs(dwOp)], RegNames[rt(dwOp)], BranchAddress(dwOp, dwAddr)); }
void SprintRSPOp_BLEZ(char * str, DWORD dwAddr, DWORD dwOp)		{ sprintf(str, "BLEZ      %s <= 0 --> 0x%04x", RegNames[rs(dwOp)], BranchAddress(dwOp, dwAddr)); }
void SprintRSPOp_BGTZ(char * str, DWORD dwAddr, DWORD dwOp)		{ sprintf(str, "BGTZ      %s > 0 --> 0x%04x", RegNames[rs(dwOp)], BranchAddress(dwOp, dwAddr)); }
void SprintRSPOp_ADDI(char * str, DWORD dwAddr, DWORD dwOp)		{ sprintf(str, "ADDI      %s = %s + 0x%04x", RegNames[rt(dwOp)], RegNames[rs(dwOp)], imm(dwOp)); }
void SprintRSPOp_ADDIU(char * str, DWORD dwAddr, DWORD dwOp)	{ sprintf(str, "ADDIU     %s = %s + 0x%04x", RegNames[rt(dwOp)], RegNames[rs(dwOp)], imm(dwOp)); }
void SprintRSPOp_SLTI(char * str, DWORD dwAddr, DWORD dwOp)		{ sprintf(str, "SLTI      %s = (%s < 0x%04x)", RegNames[rt(dwOp)], RegNames[rs(dwOp)], imm(dwOp)); }
void SprintRSPOp_SLTIU(char * str, DWORD dwAddr, DWORD dwOp)	{ sprintf(str, "SLTIU     %s = (%s < 0x%04x)", RegNames[rt(dwOp)], RegNames[rs(dwOp)], imm(dwOp)); }
void SprintRSPOp_ANDI(char * str, DWORD dwAddr, DWORD dwOp)		{ sprintf(str, "ANDI      %s = %s & 0x%04x", RegNames[rt(dwOp)], RegNames[rs(dwOp)], imm(dwOp)); }
void SprintRSPOp_ORI(char * str, DWORD dwAddr, DWORD dwOp)		{ sprintf(str, "ORI       %s = %s | 0x%04x", RegNames[rt(dwOp)], RegNames[rs(dwOp)], imm(dwOp)); }
void SprintRSPOp_XORI(char * str, DWORD dwAddr, DWORD dwOp)		{ sprintf(str, "XORI      %s = %s ^ 0x%04x", RegNames[rt(dwOp)], RegNames[rs(dwOp)], imm(dwOp)); }
void SprintRSPOp_LUI(char * str, DWORD dwAddr, DWORD dwOp)		{ sprintf(str, "LUI       %s = 0x%08x", RegNames[rt(dwOp)], imm(dwOp)<<16); }
void SprintRSPOp_LB(char * str, DWORD dwAddr, DWORD dwOp)		{ sprintf(str, "LB        %s <- 0x%04x(%s)", RegNames[rt(dwOp)], imm(dwOp), RegNames[rs(dwOp)]); }
void SprintRSPOp_LH(char * str, DWORD dwAddr, DWORD dwOp)		{ sprintf(str, "LH        %s <- 0x%04x(%s)", RegNames[rt(dwOp)], imm(dwOp), RegNames[rs(dwOp)]); }
void SprintRSPOp_LW(char * str, DWORD dwAddr, DWORD dwOp)		{ sprintf(str, "LW        %s <- 0x%04x(%s)", RegNames[rt(dwOp)], imm(dwOp), RegNames[rs(dwOp)]); }
void SprintRSPOp_LBU(char * str, DWORD dwAddr, DWORD dwOp)		{ sprintf(str, "LBU       %s <- 0x%04x(%s)", RegNames[rt(dwOp)], imm(dwOp), RegNames[rs(dwOp)]); }
void SprintRSPOp_LHU(char * str, DWORD dwAddr, DWORD dwOp)		{ sprintf(str, "LHU       %s <- 0x%04x(%s)", RegNames[rt(dwOp)], imm(dwOp), RegNames[rs(dwOp)]); }
void SprintRSPOp_SB(char * str, DWORD dwAddr, DWORD dwOp)		{ sprintf(str, "SB        %s -> 0x%04x(%s)", RegNames[rt(dwOp)], imm(dwOp), RegNames[rs(dwOp)]); }
void SprintRSPOp_SH(char * str, DWORD dwAddr, DWORD dwOp)		{ sprintf(str, "SH        %s -> 0x%04x(%s)", RegNames[rt(dwOp)], imm(dwOp), RegNames[rs(dwOp)]); }
void SprintRSPOp_SW(char * str, DWORD dwAddr, DWORD dwOp)		{ sprintf(str, "SW        %s -> 0x%04x(%s)", RegNames[rt(dwOp)], imm(dwOp), RegNames[rs(dwOp)]); }

void SprintRSPOp_Special_Unk(char * str, DWORD dwAddr, DWORD dwOp)		{ sprintf(str, "?"); }

void SprintRSPOp_Special_SLL(char * str, DWORD dwAddr, DWORD dwOp)		{
								if (dwOp == 0)							  sprintf(str, "NOP");
								else									  sprintf(str, "SLL       %s = %s << 0x%04x", RegNames[rd(dwOp)], RegNames[rt(dwOp)], sa(dwOp)); }
void SprintRSPOp_Special_SRL(char * str, DWORD dwAddr, DWORD dwOp)		{ sprintf(str, "SRL       %s = %s >> 0x%04x", RegNames[rd(dwOp)], RegNames[rt(dwOp)], sa(dwOp)); }
void SprintRSPOp_Special_SRA(char * str, DWORD dwAddr, DWORD dwOp)		{ sprintf(str, "SRA       %s = %s >> 0x%04x", RegNames[rd(dwOp)], RegNames[rt(dwOp)], sa(dwOp)); }
void SprintRSPOp_Special_SLLV(char * str, DWORD dwAddr, DWORD dwOp)		{ sprintf(str, "SLLV      %s = %s << %s", RegNames[rd(dwOp)], RegNames[rt(dwOp)], RegNames[rs(dwOp)]); }
void SprintRSPOp_Special_SRLV(char * str, DWORD dwAddr, DWORD dwOp)		{ sprintf(str, "SRLV      %s = %s >> %s", RegNames[rd(dwOp)], RegNames[rt(dwOp)], RegNames[rs(dwOp)]); }
void SprintRSPOp_Special_SRAV(char * str, DWORD dwAddr, DWORD dwOp)		{ sprintf(str, "SRAV      %s = %s >> %s", RegNames[rd(dwOp)], RegNames[rt(dwOp)], RegNames[rs(dwOp)]); }
void SprintRSPOp_Special_JR(char * str, DWORD dwAddr, DWORD dwOp)		{ sprintf(str, "JR        %s", RegNames[rs(dwOp)]); }
void SprintRSPOp_Special_JALR(char * str, DWORD dwAddr, DWORD dwOp)		{ sprintf(str, "JALR      %s, %s", RegNames[rd(dwOp)], RegNames[rs(dwOp)]); }
void SprintRSPOp_Special_BREAK(char * str, DWORD dwAddr, DWORD dwOp)	{ sprintf(str, "BREAK     0x%08x", (dwOp>>6)&0xFFFFF); }
void SprintRSPOp_Special_ADD(char * str, DWORD dwAddr, DWORD dwOp)		{ sprintf(str, "ADD       %s = %s + %s", RegNames[rd(dwOp)], RegNames[rs(dwOp)], RegNames[rt(dwOp)]); }
void SprintRSPOp_Special_ADDU(char * str, DWORD dwAddr, DWORD dwOp)		{ sprintf(str, "ADDU      %s = %s + %s", RegNames[rd(dwOp)], RegNames[rs(dwOp)], RegNames[rt(dwOp)]); }
void SprintRSPOp_Special_SUB(char * str, DWORD dwAddr, DWORD dwOp)		{ sprintf(str, "SUB       %s = %s - %s", RegNames[rd(dwOp)], RegNames[rs(dwOp)], RegNames[rt(dwOp)]); }
void SprintRSPOp_Special_SUBU(char * str, DWORD dwAddr, DWORD dwOp)		{ sprintf(str, "SUBU      %s = %s - %s", RegNames[rd(dwOp)], RegNames[rs(dwOp)], RegNames[rt(dwOp)]); }
void SprintRSPOp_Special_AND(char * str, DWORD dwAddr, DWORD dwOp)		{ sprintf(str, "AND       %s = %s & %s", RegNames[rd(dwOp)], RegNames[rs(dwOp)], RegNames[rt(dwOp)]); }
void SprintRSPOp_Special_OR(char * str, DWORD dwAddr, DWORD dwOp)		{
							if (rs(dwOp) == 0 && rt(dwOp) == 0)			  sprintf(str, "CLEAR     %s = 0", RegNames[rd(dwOp)]);
 							else if (rt(dwOp) == 0)						  sprintf(str, "MOV       %s = %s", RegNames[rd(dwOp)], RegNames[rs(dwOp)]);
							else										  sprintf(str, "OR        %s = %s | %s", RegNames[rd(dwOp)], RegNames[rs(dwOp)], RegNames[rt(dwOp)]); }
void SprintRSPOp_Special_XOR(char * str, DWORD dwAddr, DWORD dwOp)		{ sprintf(str, "XOR       %s = %s ^ %s", RegNames[rd(dwOp)], RegNames[rs(dwOp)], RegNames[rt(dwOp)]); }
void SprintRSPOp_Special_NOR(char * str, DWORD dwAddr, DWORD dwOp)		{ sprintf(str, "NOR       %s = ~(%s | %s)", RegNames[rd(dwOp)], RegNames[rs(dwOp)], RegNames[rt(dwOp)]); }
void SprintRSPOp_Special_SLT(char * str, DWORD dwAddr, DWORD dwOp)		{ sprintf(str, "SLT       %s = (%s<%s)", RegNames[rd(dwOp)], RegNames[rs(dwOp)], RegNames[rt(dwOp)]); }
void SprintRSPOp_Special_SLTU(char * str, DWORD dwAddr, DWORD dwOp)		{ sprintf(str, "SLTU      %s = (%s<%s)", RegNames[rd(dwOp)], RegNames[rs(dwOp)], RegNames[rt(dwOp)]); }




void SprintRSPOp_RegImm_Unk(char * str, DWORD dwAddr, DWORD dwOp)		{ sprintf(str, "?"); }

void SprintRSPOp_RegImm_BLTZ(char * str, DWORD dwAddr, DWORD dwOp)		{ sprintf(str, "BLTZ      %s < 0 --> 0x%04x", RegNames[rs(dwOp)], BranchAddress(dwOp, dwAddr)); }
void SprintRSPOp_RegImm_BGEZ(char * str, DWORD dwAddr, DWORD dwOp)		{ sprintf(str, "BGEZ      %s >= 0 --> 0x%04x", RegNames[rs(dwOp)], BranchAddress(dwOp, dwAddr)); }
void SprintRSPOp_RegImm_BLTZAL(char * str, DWORD dwAddr, DWORD dwOp)	{ sprintf(str, "BLTZAL    %s < 0 --> 0x%04x", RegNames[rs(dwOp)], BranchAddress(dwOp, dwAddr)); }
void SprintRSPOp_RegImm_BGEZAL(char * str, DWORD dwAddr, DWORD dwOp)	{ sprintf(str, "BGEZAL    %s >= 0 --> 0x%04x", RegNames[rs(dwOp)], BranchAddress(dwOp, dwAddr)); }


void SprintRSPOp_Cop0_Unk(char * str, DWORD dwAddr, DWORD dwOp)			{ sprintf(str, "?"); }

static LPCTSTR g_szRSPControlReg[16] =
{
	"SP_MEM_ADDR_REG",
	"SP_DRAM_ADDR_REG",
	"SP_RD_LEN_REG",
	"SP_WR_LEN_REG",
	"SP_STATUS_REG",
	"SP_DMA_FULL_REG",
	"SP_DMA_BUSY_REG",
	"SP_SEMAPHORE_REG",
	"DPC_START_REG",
	"DPC_END_REG",
	"DPC_CURRENT_REG",
	"DPC_STATUS_REG",
	"DPC_CLOCK_REG",
	"DPC_BUFBUSY_REG",
	"DPC_PIPEBUSY_REG",
	"DPC_TMEM_REG"
};


void SprintRSPOp_Cop0_MFC0(char * str, DWORD dwAddr, DWORD dwOp)		{ sprintf(str, "MFC0      %s <- [%s]", RegNames[rt(dwOp)], g_szRSPControlReg[fs(dwOp)&0x0F]); }
void SprintRSPOp_Cop0_MTC0(char * str, DWORD dwAddr, DWORD dwOp)		{ sprintf(str, "MTC0      %s -> [%s]", RegNames[rt(dwOp)], g_szRSPControlReg[fs(dwOp)&0x0F]); }

void SprintRSPOp_LWC2_Unk(char * str, DWORD dwAddr, DWORD dwOp)			{ sprintf(str, "?"); }

void SprintRSPOp_LWC2_LSV(char * str, DWORD dwAddr, DWORD dwOp)			{ sprintf(str, "LSV       vec%02d[%d ] <- 0x%04x(%s)", dest(dwOp), sel(dwOp)>>1, offset(dwOp)<<1, RegNames[base(dwOp)]); }
void SprintRSPOp_LWC2_LLV(char * str, DWORD dwAddr, DWORD dwOp)			{ sprintf(str, "LLV       vec%02d[%dq] <- 0x%04x(%s)", dest(dwOp), sel(dwOp)>>1, offset(dwOp)<<2, RegNames[base(dwOp)]); }
void SprintRSPOp_LWC2_LDV(char * str, DWORD dwAddr, DWORD dwOp)			{ sprintf(str, "LDV       vec%02d[%dh] <- 0x%04x(%s)", dest(dwOp), sel(dwOp)>>1, offset(dwOp)<<3, RegNames[base(dwOp)]); }
void SprintRSPOp_LWC2_LQV(char * str, DWORD dwAddr, DWORD dwOp)			{ sprintf(str, "LQV       vec%02d[%da] <- 0x%04x(%s)", dest(dwOp), sel(dwOp)>>1, offset(dwOp)<<4, RegNames[base(dwOp)]); }
void SprintRSPOp_LWC2_LTV(char * str, DWORD dwAddr, DWORD dwOp)			{ sprintf(str, "LTV       vec%02d[%d ] <- 0x%04x(%s)", dest(dwOp), sel(dwOp)>>1, offset(dwOp)<<4, RegNames[base(dwOp)]); }
void SprintRSPOp_LWC2_LBV(char * str, DWORD dwAddr, DWORD dwOp)			{ sprintf(str, "LBV       vec%02d[%d?] <- 0x%04x*size(%s)", dest(dwOp), sel(dwOp), offset(dwOp), RegNames[base(dwOp)]); }
void SprintRSPOp_LWC2_LRV(char * str, DWORD dwAddr, DWORD dwOp)			{ sprintf(str, "LRV       vec%02d[%d?] <- 0x%04x*size(%s)", dest(dwOp), sel(dwOp), offset(dwOp), RegNames[base(dwOp)]); }
void SprintRSPOp_LWC2_LPV(char * str, DWORD dwAddr, DWORD dwOp)			{ sprintf(str, "LPV       vec%02d[%d?] <- 0x%04x*size(%s)", dest(dwOp), sel(dwOp), offset(dwOp), RegNames[base(dwOp)]); }
void SprintRSPOp_LWC2_LUV(char * str, DWORD dwAddr, DWORD dwOp)			{ sprintf(str, "LUV       vec%02d[%d?] <- 0x%04x*size(%s)", dest(dwOp), sel(dwOp), offset(dwOp), RegNames[base(dwOp)]); }
void SprintRSPOp_LWC2_LHV(char * str, DWORD dwAddr, DWORD dwOp)			{ sprintf(str, "LHV       vec%02d[%d?] <- 0x%04x*size(%s)", dest(dwOp), sel(dwOp), offset(dwOp), RegNames[base(dwOp)]); }
void SprintRSPOp_LWC2_LFV(char * str, DWORD dwAddr, DWORD dwOp)			{ sprintf(str, "LFV       vec%02d[%d?] <- 0x%04x*size(%s)", dest(dwOp), sel(dwOp), offset(dwOp), RegNames[base(dwOp)]); }
void SprintRSPOp_LWC2_LWV(char * str, DWORD dwAddr, DWORD dwOp)			{ sprintf(str, "LWV       vec%02d[%d?] <- 0x%04x*size(%s)", dest(dwOp), sel(dwOp), offset(dwOp), RegNames[base(dwOp)]); }

void SprintRSPOp_SWC2_Unk(char * str, DWORD dwAddr, DWORD dwOp)			{ sprintf(str, "?"); }

void SprintRSPOp_SWC2_SSV(char * str, DWORD dwAddr, DWORD dwOp)			{ sprintf(str, "SSV       vec%02d[%d ] -> 0x%04x(%s)", dest(dwOp), sel(dwOp)>>1, offset(dwOp)<<1, RegNames[base(dwOp)]); }
void SprintRSPOp_SWC2_SLV(char * str, DWORD dwAddr, DWORD dwOp)			{ sprintf(str, "SLV       vec%02d[%dq] -> 0x%04x(%s)", dest(dwOp), sel(dwOp)>>1, offset(dwOp)<<2, RegNames[base(dwOp)]); }
void SprintRSPOp_SWC2_SDV(char * str, DWORD dwAddr, DWORD dwOp)			{ sprintf(str, "SDV       vec%02d[%dh] -> 0x%04x(%s)", dest(dwOp), sel(dwOp)>>1, offset(dwOp)<<3, RegNames[base(dwOp)]); }
void SprintRSPOp_SWC2_SQV(char * str, DWORD dwAddr, DWORD dwOp)			{ sprintf(str, "SQV       vec%02d[%da] -> 0x%04x(%s)", dest(dwOp), sel(dwOp)>>1, offset(dwOp)<<4, RegNames[base(dwOp)]); }
void SprintRSPOp_SWC2_STV(char * str, DWORD dwAddr, DWORD dwOp)			{ sprintf(str, "STV       vec%02d[%d ] -> 0x%04x(%s)", dest(dwOp), sel(dwOp)>>1, offset(dwOp)<<4, RegNames[base(dwOp)]); }
void SprintRSPOp_SWC2_SBV(char * str, DWORD dwAddr, DWORD dwOp)			{ sprintf(str, "SBV       vec%02d[%d?] -> 0x%04x*size(%s)", dest(dwOp), sel(dwOp), offset(dwOp), RegNames[base(dwOp)]); }
void SprintRSPOp_SWC2_SRV(char * str, DWORD dwAddr, DWORD dwOp)			{ sprintf(str, "SRV       vec%02d[%d?] -> 0x%04x*size(%s)", dest(dwOp), sel(dwOp), offset(dwOp), RegNames[base(dwOp)]); }
void SprintRSPOp_SWC2_SPV(char * str, DWORD dwAddr, DWORD dwOp)			{ sprintf(str, "SPV       vec%02d[%d?] -> 0x%04x*size(%s)", dest(dwOp), sel(dwOp), offset(dwOp), RegNames[base(dwOp)]); }
void SprintRSPOp_SWC2_SUV(char * str, DWORD dwAddr, DWORD dwOp)			{ sprintf(str, "SUV       vec%02d[%d?] -> 0x%04x*size(%s)", dest(dwOp), sel(dwOp), offset(dwOp), RegNames[base(dwOp)]); }
void SprintRSPOp_SWC2_SHV(char * str, DWORD dwAddr, DWORD dwOp)			{ sprintf(str, "SHV       vec%02d[%d?] -> 0x%04x*size(%s)", dest(dwOp), sel(dwOp), offset(dwOp), RegNames[base(dwOp)]); }
void SprintRSPOp_SWC2_SFV(char * str, DWORD dwAddr, DWORD dwOp)			{ sprintf(str, "SFV       vec%02d[%d?] -> 0x%04x*size(%s)", dest(dwOp), sel(dwOp), offset(dwOp), RegNames[base(dwOp)]); }
void SprintRSPOp_SWC2_SWV(char * str, DWORD dwAddr, DWORD dwOp)			{ sprintf(str, "SWV       vec%02d[%d?] -> 0x%04x*size(%s)", dest(dwOp), sel(dwOp), offset(dwOp), RegNames[base(dwOp)]); }

void SprintRSPOp_Cop2_Unk(char * str, DWORD dwAddr, DWORD dwOp)			{ sprintf(str, "?"); }
void SprintRSPOp_Cop2_MFC2(char * str, DWORD dwAddr, DWORD dwOp)		{ sprintf(str, "MFC2      %s <- vec%d[%d]", RegNames[rt(dwOp)], rd(dwOp), vmovoff(dwOp)); }
void SprintRSPOp_Cop2_MTC2(char * str, DWORD dwAddr, DWORD dwOp)		{ sprintf(str, "MTC2      %s -> vec%d[%d]", RegNames[rt(dwOp)], rd(dwOp), vmovoff(dwOp)); }

void SprintRSPOp_Vop_Unk(char * str, DWORD dwAddr, DWORD dwOp)			{ sprintf(str, "?"); }

void SprintRSPOp_Vop_VMULF(char * str, DWORD dwAddr, DWORD dwOp)		{ sprintf(str, "VMULF     vec%02d  = vec%02d * vec%02d[%s]", vdest(dwOp), vs1(dwOp), vs2(dwOp), g_szVSelName[ve1(dwOp)]); }
void SprintRSPOp_Vop_VMULU(char * str, DWORD dwAddr, DWORD dwOp)		{ sprintf(str, "VMULU     vec%02d  = vec%02d ? vec%02d[%s]", vdest(dwOp), vs1(dwOp), vs2(dwOp), g_szVSelName[ve1(dwOp)]); }
void SprintRSPOp_Vop_VRNDP(char * str, DWORD dwAddr, DWORD dwOp)		{ sprintf(str, "VRNDP     vec%02d  = vec%02d ? vec%02d[%s]", vdest(dwOp), vs1(dwOp), vs2(dwOp), g_szVSelName[ve1(dwOp)]); }
void SprintRSPOp_Vop_VMULQ(char * str, DWORD dwAddr, DWORD dwOp)		{ sprintf(str, "VMULQ     vec%02d  = vec%02d ? vec%02d[%s]", vdest(dwOp), vs1(dwOp), vs2(dwOp), g_szVSelName[ve1(dwOp)]); }
void SprintRSPOp_Vop_VMUDL(char * str, DWORD dwAddr, DWORD dwOp)		{ sprintf(str, "VMUDL     vec%02d  = ( acc  = vec%02d * vec%02d[%s]       )", vdest(dwOp), vs1(dwOp), vs2(dwOp), g_szVSelName[ve1(dwOp)]); }
void SprintRSPOp_Vop_VMUDM(char * str, DWORD dwAddr, DWORD dwOp)		{ sprintf(str, "VMUDM     vec%02d  = ( acc  = vec%02d * vec%02d[%s] >> 16 )", vdest(dwOp), vs1(dwOp), vs2(dwOp), g_szVSelName[ve1(dwOp)]); }
void SprintRSPOp_Vop_VMUDN(char * str, DWORD dwAddr, DWORD dwOp)		{ sprintf(str, "VMUDN     vec%02d  = ( acc  = vec%02d * vec%02d[%s]       ) >> 16", vdest(dwOp), vs1(dwOp), vs2(dwOp), g_szVSelName[ve1(dwOp)]); }
void SprintRSPOp_Vop_VMUDH(char * str, DWORD dwAddr, DWORD dwOp)		{ sprintf(str, "VMUDH     vec%02d  = ( acc  = vec%02d * vec%02d[%s] >> 16 ) >> 16", vdest(dwOp), vs1(dwOp), vs2(dwOp), g_szVSelName[ve1(dwOp)]); }

void SprintRSPOp_Vop_VMACF(char * str, DWORD dwAddr, DWORD dwOp)		{ sprintf(str, "VMACF     vec%02d += vec%02d * vec%02d[%s]", vdest(dwOp), vs1(dwOp), vs2(dwOp), g_szVSelName[ve1(dwOp)]); }
void SprintRSPOp_Vop_VMACU(char * str, DWORD dwAddr, DWORD dwOp)		{ sprintf(str, "VMACU     vec%02d  = vec%02d ? vec%02d[%s]", vdest(dwOp), vs1(dwOp), vs2(dwOp), g_szVSelName[ve1(dwOp)]); }
void SprintRSPOp_Vop_VRNDN(char * str, DWORD dwAddr, DWORD dwOp)		{ sprintf(str, "VRNDN     vec%02d  = vec%02d ? vec%02d[%s]", vdest(dwOp), vs1(dwOp), vs2(dwOp), g_szVSelName[ve1(dwOp)]); }
void SprintRSPOp_Vop_VMACQ(char * str, DWORD dwAddr, DWORD dwOp)		{ sprintf(str, "VMACQ     vec%02d  = vec%02d ? vec%02d[%s]", vdest(dwOp), vs1(dwOp), vs2(dwOp), g_szVSelName[ve1(dwOp)]); }
void SprintRSPOp_Vop_VMADL(char * str, DWORD dwAddr, DWORD dwOp)		{ sprintf(str, "VMADL     vec%02d  = ( acc += vec%02d * vec%02d[%s]       )", vdest(dwOp), vs1(dwOp), vs2(dwOp), g_szVSelName[ve1(dwOp)]); }
void SprintRSPOp_Vop_VMADM(char * str, DWORD dwAddr, DWORD dwOp)		{ sprintf(str, "VMADM     vec%02d  = ( acc += vec%02d * vec%02d[%s] >> 16 )", vdest(dwOp), vs1(dwOp), vs2(dwOp), g_szVSelName[ve1(dwOp)]); }
void SprintRSPOp_Vop_VMADN(char * str, DWORD dwAddr, DWORD dwOp)		{ sprintf(str, "VMADN     vec%02d  = ( acc += vec%02d * vec%02d[%s]       ) >> 16", vdest(dwOp), vs1(dwOp), vs2(dwOp), g_szVSelName[ve1(dwOp)]); }
void SprintRSPOp_Vop_VMADH(char * str, DWORD dwAddr, DWORD dwOp)		{ sprintf(str, "VMADH     vec%02d  = ( acc += vec%02d * vec%02d[%s] >> 16 ) >> 16", vdest(dwOp), vs1(dwOp), vs2(dwOp), g_szVSelName[ve1(dwOp)]); }

void SprintRSPOp_Vop_VADD(char * str, DWORD dwAddr, DWORD dwOp)			{ sprintf(str, "VADD      vec%02d  = vec%02d + vec%02d[%s]", vdest(dwOp), vs1(dwOp), vs2(dwOp), g_szVSelName[ve1(dwOp)]); }
void SprintRSPOp_Vop_VSUB(char * str, DWORD dwAddr, DWORD dwOp)			{ sprintf(str, "VSUB      vec%02d  = vec%02d - vec%02d[%s]", vdest(dwOp), vs1(dwOp), vs2(dwOp), g_szVSelName[ve1(dwOp)]); }
void SprintRSPOp_Vop_VSUT(char * str, DWORD dwAddr, DWORD dwOp)			{ sprintf(str, "VSUT      vec%02d  = vec%02d ? vec%02d[%s]", vdest(dwOp), vs1(dwOp), vs2(dwOp), g_szVSelName[ve1(dwOp)]); }
void SprintRSPOp_Vop_VABS(char * str, DWORD dwAddr, DWORD dwOp)			{ sprintf(str, "VABS      vec%02d  = vec%02d ? vec%02d[%s]", vdest(dwOp), vs1(dwOp), vs2(dwOp), g_szVSelName[ve1(dwOp)]); }
void SprintRSPOp_Vop_VADDC(char * str, DWORD dwAddr, DWORD dwOp)		{ sprintf(str, "VADDC     vec%02d  = vec%02d ? vec%02d[%s]", vdest(dwOp), vs1(dwOp), vs2(dwOp), g_szVSelName[ve1(dwOp)]); }
void SprintRSPOp_Vop_VSUBC(char * str, DWORD dwAddr, DWORD dwOp)		{ sprintf(str, "VSUBC     vec%02d  = vec%02d ? vec%02d[%s]", vdest(dwOp), vs1(dwOp), vs2(dwOp), g_szVSelName[ve1(dwOp)]); }
void SprintRSPOp_Vop_VADDB(char * str, DWORD dwAddr, DWORD dwOp)		{ sprintf(str, "VADDB     vec%02d  = vec%02d ? vec%02d[%s]", vdest(dwOp), vs1(dwOp), vs2(dwOp), g_szVSelName[ve1(dwOp)]); }
void SprintRSPOp_Vop_VSUBB(char * str, DWORD dwAddr, DWORD dwOp)		{ sprintf(str, "VSUBB     vec%02d  = vec%02d ? vec%02d[%s]", vdest(dwOp), vs1(dwOp), vs2(dwOp), g_szVSelName[ve1(dwOp)]); }

void SprintRSPOp_Vop_VACCB(char * str, DWORD dwAddr, DWORD dwOp)		{ sprintf(str, "VACCB     vec%02d  = vec%02d ? vec%02d[%s]", vdest(dwOp), vs1(dwOp), vs2(dwOp), g_szVSelName[ve1(dwOp)]); }
void SprintRSPOp_Vop_VSUCB(char * str, DWORD dwAddr, DWORD dwOp)		{ sprintf(str, "VSUCB     vec%02d  = vec%02d ? vec%02d[%s]", vdest(dwOp), vs1(dwOp), vs2(dwOp), g_szVSelName[ve1(dwOp)]); }
void SprintRSPOp_Vop_VSAD(char * str, DWORD dwAddr, DWORD dwOp)			{ sprintf(str, "VSAD      vec%02d  = vec%02d ? vec%02d[%s]", vdest(dwOp), vs1(dwOp), vs2(dwOp), g_szVSelName[ve1(dwOp)]); }
void SprintRSPOp_Vop_VSAC(char * str, DWORD dwAddr, DWORD dwOp)			{ sprintf(str, "VSAC      vec%02d  = vec%02d ? vec%02d[%s]", vdest(dwOp), vs1(dwOp), vs2(dwOp), g_szVSelName[ve1(dwOp)]); }
void SprintRSPOp_Vop_VSUM(char * str, DWORD dwAddr, DWORD dwOp)			{ sprintf(str, "VSUM      vec%02d  = vec%02d ? vec%02d[%s]", vdest(dwOp), vs1(dwOp), vs2(dwOp), g_szVSelName[ve1(dwOp)]); }
void SprintRSPOp_Vop_VSAW(char * str, DWORD dwAddr, DWORD dwOp)			{ sprintf(str, "VSAW      vec%02d  = vec%02d ? vec%02d[%s]", vdest(dwOp), vs1(dwOp), vs2(dwOp), g_szVSelName[ve1(dwOp)]); }

void SprintRSPOp_Vop_VLT(char * str, DWORD dwAddr, DWORD dwOp)			{ sprintf(str, "VLT       vec%02d  = vec%02d <  vec%02d[%s]", vdest(dwOp), vs1(dwOp), vs2(dwOp), g_szVSelName[ve1(dwOp)]); }
void SprintRSPOp_Vop_VEQ(char * str, DWORD dwAddr, DWORD dwOp)			{ sprintf(str, "VEQ       vec%02d  = vec%02d == vec%02d[%s]", vdest(dwOp), vs1(dwOp), vs2(dwOp), g_szVSelName[ve1(dwOp)]); }
void SprintRSPOp_Vop_VNE(char * str, DWORD dwAddr, DWORD dwOp)			{ sprintf(str, "VNE       vec%02d  = vec%02d != vec%02d[%s]", vdest(dwOp), vs1(dwOp), vs2(dwOp), g_szVSelName[ve1(dwOp)]); }
void SprintRSPOp_Vop_VGE(char * str, DWORD dwAddr, DWORD dwOp)			{ sprintf(str, "VGE       vec%02d  = vec%02d >= vec%02d[%s]", vdest(dwOp), vs1(dwOp), vs2(dwOp), g_szVSelName[ve1(dwOp)]); }
void SprintRSPOp_Vop_VCL(char * str, DWORD dwAddr, DWORD dwOp)			{ sprintf(str, "VCL       vec%02d  = vec%02d ? vec%02d[%s]", vdest(dwOp), vs1(dwOp), vs2(dwOp), g_szVSelName[ve1(dwOp)]); }
void SprintRSPOp_Vop_VCH(char * str, DWORD dwAddr, DWORD dwOp)			{ sprintf(str, "VCH       vec%02d  = vec%02d ? vec%02d[%s]", vdest(dwOp), vs1(dwOp), vs2(dwOp), g_szVSelName[ve1(dwOp)]); }
void SprintRSPOp_Vop_VCR(char * str, DWORD dwAddr, DWORD dwOp)			{ sprintf(str, "VCR       vec%02d  = vec%02d ? vec%02d[%s]", vdest(dwOp), vs1(dwOp), vs2(dwOp), g_szVSelName[ve1(dwOp)]); }
void SprintRSPOp_Vop_VMRG(char * str, DWORD dwAddr, DWORD dwOp)			{ sprintf(str, "VMRG      vec%02d  = vec%02d ? vec%02d[%s]", vdest(dwOp), vs1(dwOp), vs2(dwOp), g_szVSelName[ve1(dwOp)]); }
void SprintRSPOp_Vop_VAND(char * str, DWORD dwAddr, DWORD dwOp)			{ sprintf(str, "VAND      vec%02d  = vec%02d & vec%02d[%s]", vdest(dwOp), vs1(dwOp), vs2(dwOp), g_szVSelName[ve1(dwOp)]); }
void SprintRSPOp_Vop_VNAND(char * str, DWORD dwAddr, DWORD dwOp)		{ sprintf(str, "VNAND     vec%02d  = ~(vec%02d & vec%02d[%s])", vdest(dwOp), vs1(dwOp), vs2(dwOp), g_szVSelName[ve1(dwOp)]); }
void SprintRSPOp_Vop_VOR(char * str, DWORD dwAddr, DWORD dwOp)			{ sprintf(str, "VOR       vec%02d  = vec%02d | vec%02d[%s]", vdest(dwOp), vs1(dwOp), vs2(dwOp), g_szVSelName[ve1(dwOp)]); }
void SprintRSPOp_Vop_VNOR(char * str, DWORD dwAddr, DWORD dwOp)			{ sprintf(str, "VNOR      vec%02d  = ~(vec%02d | vec%02d[%s])", vdest(dwOp), vs1(dwOp), vs2(dwOp), g_szVSelName[ve1(dwOp)]); }
void SprintRSPOp_Vop_VXOR(char * str, DWORD dwAddr, DWORD dwOp)			{ sprintf(str, "VXOR      vec%02d  = vec%02d ^ vec%02d[%s]", vdest(dwOp), vs1(dwOp), vs2(dwOp), g_szVSelName[ve1(dwOp)]); }
void SprintRSPOp_Vop_VNXOR(char * str, DWORD dwAddr, DWORD dwOp)		{ sprintf(str, "VNXOR     vec%02d  = ~(vec%02d ^ vec%02d[%s])", vdest(dwOp), vs1(dwOp), vs2(dwOp), g_szVSelName[ve1(dwOp)]); }
void SprintRSPOp_Vop_VRCP(char * str, DWORD dwAddr, DWORD dwOp)			{ sprintf(str, "VRCP      vec%02d  = vec%02d ? vec%02d[%s]", vdest(dwOp), vs1(dwOp), vs2(dwOp), g_szVSelName[ve1(dwOp)]); }
void SprintRSPOp_Vop_VRCPL(char * str, DWORD dwAddr, DWORD dwOp)		{ sprintf(str, "VRCPL     vec%02d  = vec%02d ? vec%02d[%s]", vdest(dwOp), vs1(dwOp), vs2(dwOp), g_szVSelName[ve1(dwOp)]); }
void SprintRSPOp_Vop_VRCPH(char * str, DWORD dwAddr, DWORD dwOp)		{ sprintf(str, "VRCPH     vec%02d  = vec%02d ? vec%02d[%s]", vdest(dwOp), vs1(dwOp), vs2(dwOp), g_szVSelName[ve1(dwOp)]); }
void SprintRSPOp_Vop_VMOV(char * str, DWORD dwAddr, DWORD dwOp)			{ sprintf(str, "VMOV      vec%02d  = vec%02d ? vec%02d[%s]", vdest(dwOp), vs1(dwOp), vs2(dwOp), g_szVSelName[ve1(dwOp)]); }
void SprintRSPOp_Vop_VRSQ(char * str, DWORD dwAddr, DWORD dwOp)			{ sprintf(str, "VRSQ      vec%02d  = vec%02d ? vec%02d[%s]", vdest(dwOp), vs1(dwOp), vs2(dwOp), g_szVSelName[ve1(dwOp)]); }
void SprintRSPOp_Vop_VRSQL(char * str, DWORD dwAddr, DWORD dwOp)		{ sprintf(str, "VRSQL     vec%02d  = vec%02d ? vec%02d[%s]", vdest(dwOp), vs1(dwOp), vs2(dwOp), g_szVSelName[ve1(dwOp)]); }
void SprintRSPOp_Vop_VRSQH(char * str, DWORD dwAddr, DWORD dwOp)		{ sprintf(str, "VRSQH     vec%02d  = vec%02d ? vec%02d[%s]", vdest(dwOp), vs1(dwOp), vs2(dwOp), g_szVSelName[ve1(dwOp)]); }





void
SprintOpCodeInfo(char *str, DWORD dwAddr, DWORD dwOp)
{
	dwOp = GetCorrectOp(dwOp);
	SprintOp_Instructions[op(dwOp)](str, dwAddr, dwOp);
}




void
SprintRSPOpCodeInfo(char *str, DWORD dwAddr, DWORD dwOp) {

	SprintRSPOp_Instructions[op(dwOp)](str, dwAddr, dwOp);

}



