/*
Copyright (C) 2001 Lkb

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

*/

#pragma once

/* 
// #Include this in stdafx.h for localization support
// This must be added after system headers and before Daedalus headers

*/

#ifndef NO_LOCALIZATION
#undef LoadString
#define LoadString Localization_LoadString
#undef LoadMenu
#define LoadMenu Localization_LoadMenu
#undef DialogBox
#define DialogBox Localization_DialogBox
#undef DialogBoxParam
#define DialogBoxParam Localization_DialogBoxParam
#undef CreateDialog
#define CreateDialog Localization_CreateDialog
#undef CreateDialogParam
#define CreateDialogParam Localization_CreateDialogParam
#define LOCALIZATION_ENABLED
#endif

struct ResourceModuleEntry
{
	HINSTANCE hInstance;
	BOOL bCurrentVersion; // if true, the DLL has the same version number of Daedalus
	TCHAR szLanguage[6]; // en-us\0
};

extern std::vector<ResourceModuleEntry> g_vhResourceModules;

BOOL Localization_SetLanguage(LPCTSTR pLanguage = NULL); // NULL sets default language

HINSTANCE Localization_GetResourceModule(LPCTSTR lpName, LPCTSTR lpType, BOOL bMustBeCurrent);
HINSTANCE Localization_GetResourceModule(HINSTANCE hInstance, LPCTSTR lpName, LPCTSTR lpType, BOOL bMustBeCurrent);
int Localization_LoadString(HINSTANCE hInstance /*ignored*/, UINT uID, LPTSTR lpBuffer, int nBufferMax);
HMENU Localization_LoadMenu(HINSTANCE hInstance /*ignored*/, LPCTSTR lpMenuName);
INT_PTR Localization_DialogBox(HINSTANCE hInstance, LPCTSTR lpTemplate, HWND hWndParent, DLGPROC lpDialogFunc);
INT_PTR Localization_DialogBoxParam(HINSTANCE hInstance, LPCTSTR lpTemplate, HWND hWndParent, DLGPROC lpDialogFunc, LPARAM dwInitParam);
HWND Localization_CreateDialog(HINSTANCE hInstance, LPCTSTR lpTemplate, HWND hWndParent, DLGPROC lpDialogFunc);
HWND Localization_CreateDialogParam(HINSTANCE hInstance, LPCTSTR lpTemplate, HWND hWndParent, DLGPROC lpDialogFunc, LPARAM dwInitParam);
