/*
Copyright (C) 2001 Lkb

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

*/

// Set this file to "Not using precompiled header"

#define WIN32_LEAN_AND_MEAN		// Exclude rarely-used stuff from Windows headers

// Localization must be disabled to avoid infinite recursion

#define NO_LOCALIZATION
#include "stdafx.h"

#ifdef LOCALIZATION_ENABLED
#error Localization.cpp must be compiled with "Not using precompiled header"
#endif

#include "resource.h"
#include "LanguageTable.h"

using namespace std;

extern TCHAR		g_szDaedalusExeDir[MAX_PATH+1];

extern HINSTANCE g_hInstance;

extern OSVERSIONINFO g_OSVersionInfo;

// currently we only have at most two localization dlls loaded, so the vector is not very useful

vector<ResourceModuleEntry> g_vhResourceModules;

// internal
BOOL Localization_AddLanguage(LPCTSTR pLanguage)
{
	if(strlen(pLanguage) > 5)
	{
		return FALSE;
	}

	vector<ResourceModuleEntry>::const_iterator iter;

	for(iter = g_vhResourceModules.begin(); iter < g_vhResourceModules.end(); iter++)
	{
		if(strcmp((*iter).szLanguage, pLanguage) == 0)
		{
			// already loaded
			return FALSE;
		}
	}

	// based on code in AudioDialog.cpp
	// Windows is not case sensitive so don't care about it
	TCHAR szFileSpec[MAX_PATH+1];
	lstrcpyn(szFileSpec, g_szDaedalusExeDir, MAX_PATH);
	PathAppend(szFileSpec, TEXT("Localization"));

	PathAppend(szFileSpec, TEXT("Daedalus_"));

	// Daedalus.en-us.dll
	strcat(szFileSpec, pLanguage);
	strcat(szFileSpec, ".dll");

	ResourceModuleEntry entry;
	if(g_OSVersionInfo.dwPlatformId == VER_PLATFORM_WIN32_NT)
	{
		// this doesn't execute anything, but it's only available in WinNT
		entry.hInstance = LoadLibraryEx(szFileSpec, NULL, DONT_RESOLVE_DLL_REFERENCES);
		//entry.hInstance = LoadLibrary(szFileSpec);
	}
	else
	{
		// SECURITY PROBLEM: this executes DllMain
		// TODO: if possible, find DllMain and fail if it's present to avoid executing code that may be malicious
		entry.hInstance = LoadLibrary(szFileSpec);
	}
	if(entry.hInstance == NULL)
		return FALSE;

	TCHAR szVersion[256];
	LoadString(entry.hInstance, IDS_LOCALIZATION_DLL_FOR_VERSION, szVersion, 256);

	entry.bCurrentVersion = (_strcmpi(szVersion, DAEDALUS_VERSION) == 0);
	strcpy(entry.szLanguage, pLanguage);

	g_vhResourceModules.push_back(entry);
	return TRUE;
}

// internal
BOOL Localization_ClearLanguages()
{
	vector<ResourceModuleEntry>::const_iterator iter;
	for(iter = g_vhResourceModules.begin(); iter < g_vhResourceModules.end(); iter++)
	{
		FreeLibrary((*iter).hInstance);
	}
	g_vhResourceModules.clear();
	return TRUE;
}

// supports either "en-us" or "en" language names
BOOL Localization_SetLanguage(LPCTSTR pLanguage) // NULL sets default language
{
	TCHAR szLanguageName[256];
	Localization_ClearLanguages();
	szLanguageName[0] = 0;
	if(pLanguage == NULL)
	{
		LCID locale = GetUserDefaultLCID();
		// Win9x doesn't support LOCALE_SISO639LANGNAME and LOCALE_SISO3166CTRYNAME, but we try anyways
		GetLocaleInfo(locale, LOCALE_SISO639LANGNAME  , szLanguageName, 256);
		if(szLanguageName[0] != 0)
		{
			strcat(szLanguageName, "-");
			GetLocaleInfo(locale, LOCALE_SISO3166CTRYNAME , szLanguageName + strlen(szLanguageName), 256);
			pLanguage = szLanguageName;
		}
		else
		{
			// TODO: Is there a better way to do this in Win9x?
			WORD langID = GetUserDefaultLangID();
			langID = MAKELANGID(PRIMARYLANGID(langID), (SUBLANGID(langID) == 0) ? 1 : SUBLANGID(langID));
			for(int n = 0; g_LanguageTable[n].pszLanguageName != NULL; n++)
			{
				if(g_LanguageTable[n].nLangID == langID)
				{
					pLanguage = g_LanguageTable[n].pszLanguageName;
				}
			}
			if(pLanguage == NULL)
				pLanguage = "en-us";
		}
	}

	if(pLanguage != szLanguageName)
	{
		strcpy(szLanguageName, pLanguage);
		pLanguage = szLanguageName;
	}
	LPTSTR pSeparator = strchr(szLanguageName, '-');
	if(pSeparator != NULL)
	{
		Localization_AddLanguage(szLanguageName);
		*pSeparator = 0;
		Localization_AddLanguage(szLanguageName);
	}
	else
	{
		Localization_AddLanguage(pLanguage);
	}
	return TRUE;
}

HINSTANCE Localization_GetResourceModule(LPCTSTR lpName, LPCTSTR lpType, BOOL bMustBeCurrent)
{
	vector<ResourceModuleEntry>::const_iterator iter;
	for(iter = g_vhResourceModules.begin(); iter < g_vhResourceModules.end(); iter++)
	{
		if(!((*iter).bCurrentVersion) && bMustBeCurrent)
		{
			continue;
		}
		// the docs are not clear, I hope this finds resources in any language
		if(FindResource((*iter).hInstance, lpName, lpType) != NULL)
		{
			return (*iter).hInstance;
		}
	}
	return g_hInstance;
}

HINSTANCE Localization_GetResourceModule(HINSTANCE hInstance, LPCTSTR lpName, LPCTSTR lpType, BOOL bMustBeCurrent)
{
	if(hInstance != g_hInstance)
		return hInstance;
	else
		return Localization_GetResourceModule(lpName, lpType, bMustBeCurrent);
}

int Localization_LoadString(HINSTANCE hInstance, UINT uID, LPTSTR lpBuffer, int nBufferMax)
{
	// strings need special handling (not sure it's necessary, but it doesn't hurt)
	if(hInstance == g_hInstance)
	{
		vector<ResourceModuleEntry>::const_iterator iter;
		for(iter = g_vhResourceModules.begin(); iter < g_vhResourceModules.end(); iter++)
		{
			if(FindResource((*iter).hInstance, MAKEINTRESOURCE((uID >> 4) + 1), RT_STRING) != NULL)
			{
				int nStringLen = LoadString((*iter).hInstance, uID, lpBuffer, nBufferMax);
				if(nStringLen > 0)
					return nStringLen;
			}
		}
	}
	return LoadString(hInstance, uID, lpBuffer, nBufferMax);
}

HMENU Localization_LoadMenu(HINSTANCE hInstance /*ignored*/, LPCTSTR lpMenuName)
{
	// menus must be from matching version DLLs, otherwise new menu items are not available
	return LoadMenu(
		Localization_GetResourceModule(hInstance, lpMenuName, RT_MENU, TRUE),
		lpMenuName);
}

INT_PTR Localization_DialogBox(HINSTANCE hInstance, LPCTSTR lpTemplate, HWND hWndParent, DLGPROC lpDialogFunc)
{
	return DialogBox(
		Localization_GetResourceModule(hInstance, lpTemplate, RT_DIALOG, TRUE),
		lpTemplate, hWndParent, lpDialogFunc);
}

INT_PTR Localization_DialogBoxParam(HINSTANCE hInstance, LPCTSTR lpTemplate, HWND hWndParent, DLGPROC lpDialogFunc, LPARAM dwInitParam)
{
	return DialogBoxParam(
		Localization_GetResourceModule(hInstance, lpTemplate, RT_DIALOG, TRUE),
		lpTemplate, hWndParent, lpDialogFunc, dwInitParam);
}

HWND Localization_CreateDialog(HINSTANCE hInstance, LPCTSTR lpTemplate, HWND hWndParent, DLGPROC lpDialogFunc)
{
	return CreateDialog(
		Localization_GetResourceModule(hInstance, lpTemplate, RT_DIALOG, TRUE),
		lpTemplate, hWndParent, lpDialogFunc);
}

HWND Localization_CreateDialogParam(HINSTANCE hInstance, LPCTSTR lpTemplate, HWND hWndParent, DLGPROC lpDialogFunc, LPARAM dwInitParam)
{
	return CreateDialogParam(
		Localization_GetResourceModule(hInstance, lpTemplate, RT_DIALOG, TRUE),
		lpTemplate, hWndParent, lpDialogFunc, dwInitParam);
}
