/*
Copyright (C) 2001 StrmnNrmn

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

*/

#include "stdafx.h"
#include <shlwapi.h>
#include <windowsx.h>		// ComboBox_ defines
#include <commctrl.h>		// LVITEM etc
#include "resource.h"
#include "InputSelectDialog.h"
#include "InputDialog.h"
#include "DBGConsole.h"
#include "DInputHandler.h"

static BOOL CALLBACK InputSelectDialogProc(HWND hWndDlg, UINT uMsg, WPARAM wParam, LPARAM lParam);
static BOOL InputSelectDialog_OnInitDialog(HWND hWndDlg, WPARAM wParam, LPARAM lParam);
static void InputDialog_FillConfigCombo(HWND hWndDlg);


void InputSelectDialog_DoModal(HWND hWndParent)
{
	DialogBox(g_hInstance, MAKEINTRESOURCE(IDD_INPUTSELECT), hWndParent, InputSelectDialogProc);
}




BOOL CALLBACK InputSelectDialogProc(HWND hWndDlg, UINT uMsg, WPARAM wParam, LPARAM lParam)
{
	BOOL bResult;
	LONG nRetVal;
	LONG nSelectedConfig;
	LONG iConfig;
	InputConfiguration ic;

	switch (uMsg)
	{
	case WM_INITDIALOG:
		return InputSelectDialog_OnInitDialog(hWndDlg, wParam, lParam);

	case WM_COMMAND:
		switch (LOWORD(wParam))
		{
		case IDC_NEW_BUTTON:
			nSelectedConfig =  ComboBox_GetCurSel(GetDlgItem(hWndDlg, IDC_CONFIG_COMBO));
			if (nSelectedConfig == CB_ERR)
			{
				Input_NewConfig(ic);
			}
			else
			{
				// Create a new configuration bases on the selected config
				iConfig = ComboBox_GetItemData(GetDlgItem(hWndDlg, IDC_CONFIG_COMBO), nSelectedConfig);
				if (iConfig == -1)
				{
					Input_NewConfig(ic);
				}
				else
				{
					TCHAR szFileName[MAX_PATH+1];

					Input_GetConfig(iConfig, ic);

					// Change filename from abc.din to abcCopy.din
					lstrcpyn(szFileName, ic.szFileName, MAX_PATH);
					PathRemoveExtension(szFileName);
					lstrcat(szFileName, TEXT("Copy"));
					PathAddExtension(szFileName, TEXT(".din"));
					lstrcpyn(ic.szFileName, szFileName, MAX_PATH);
				}

			}

			nRetVal = InputDialog_DoModal(hWndDlg, &ic, FALSE);
			if (nRetVal == IDOK)
			{
				// Add to global list
				iConfig = Input_AddConfig(ic);

				Input_SaveConfig(iConfig);

				// Refresh
				InputDialog_FillConfigCombo(hWndDlg);
			}

			break;
		case IDC_EDIT_BUTTON:

			// 
			nSelectedConfig =  ComboBox_GetCurSel(GetDlgItem(hWndDlg, IDC_CONFIG_COMBO));
			if (nSelectedConfig != CB_ERR)
			{
				BOOL bIsCurrent;

				iConfig = ComboBox_GetItemData(GetDlgItem(hWndDlg, IDC_CONFIG_COMBO), nSelectedConfig);

				bIsCurrent = iConfig == -1;

				bResult = Input_GetConfig(iConfig, ic);
				if (bResult)
				{
					nRetVal = InputDialog_DoModal(hWndDlg, &ic, bIsCurrent);
					if (nRetVal == IDOK)
					{
						// Update global list - works for iConfig == -1 too
						Input_SetConfig(iConfig, ic);

						if (iConfig != -1)
							Input_SaveConfig(iConfig);
						// Refresh
						InputDialog_FillConfigCombo(hWndDlg);
					}
				}
			}


			break;
		case IDOK:
			// Copy our copy of the data back, setting up the new values
			nSelectedConfig =  ComboBox_GetCurSel(GetDlgItem(hWndDlg, IDC_CONFIG_COMBO));
			if (nSelectedConfig != CB_ERR)
			{
				iConfig = ComboBox_GetItemData(GetDlgItem(hWndDlg, IDC_CONFIG_COMBO), nSelectedConfig);

				bResult = Input_GetConfig(iConfig, ic);
				if (bResult)
				{
					// Do this even if iConfig = -1. This will force the
					// input handler to recreate its devices
					Input_SetConfig(-1, ic);
				}
			}
			EndDialog(hWndDlg, IDOK);
			return TRUE;
		case IDCANCEL:
			EndDialog(hWndDlg, IDCANCEL);
			return TRUE;
		}
		break;
	case WM_DESTROY:
		// Free resources that were allocated
		return TRUE;

	}


	return FALSE;
}

BOOL InputSelectDialog_OnInitDialog(HWND hWndDlg, WPARAM wParam, LPARAM lParam)
{
	// Load up all the configuration data
	Input_LoadAllInputConfigs();

	// Initialise the lists
	InputDialog_FillConfigCombo(hWndDlg);

	SetFocus(GetDlgItem(hWndDlg, IDC_CONFIG_COMBO));

	// We set the focus, return false
	return FALSE;
}

void InputDialog_FillConfigCombo(HWND hWndDlg)
{

	LONG i;
	HWND hWndCombo;
	CHAR szName[MAX_PATH+1];
	LONG nIndex;
	LONG nDefault;
	BOOL bResult;
	LONG nNumConfigs;
	InputConfiguration ic;

	hWndCombo = GetDlgItem(hWndDlg, IDC_CONFIG_COMBO);

	ComboBox_ResetContent(hWndCombo);

	nNumConfigs = Input_GetNumConfigs();
	// entry -1 is the current config
	for (i = -1; i < nNumConfigs; i++)
	{
		bResult = Input_GetConfig(i, ic);
		if (bResult)
		{
			if (i == -1)
			{
				// Just copy default name
				lstrcpyn(szName, ic.szFileName, MAX_PATH);
			}
			else
			{
				// Get name from path
				lstrcpyn(szName, PathFindFileName(ic.szFileName), MAX_PATH);
				PathRemoveExtension(szName);
			}
			
			nIndex = ComboBox_InsertString(hWndCombo, -1, szName);

			if (nIndex != CB_ERR && nIndex != CB_ERRSPACE)
			{
				// Set item data
				ComboBox_SetItemData(hWndCombo, nIndex, i);
			}

			if (i == -1)
				nDefault = nIndex;
		}
	}
	ComboBox_SetCurSel(hWndCombo, nDefault);

}