/*
Copyright (C) 2001 StrmnNrmn

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

*/

#include "stdafx.h"
#include <shlwapi.h>
#include <windowsx.h>		// ComboBox_ defines
#include <commctrl.h>		// LVITEM etc
#include "resource.h"
#include "InputDialog.h"
#include "DBGConsole.h"
#include "DInputHandler.h"

static BOOL CALLBACK InputDialogProc(HWND hWndDlg, UINT uMsg, WPARAM wParam, LPARAM lParam);
static BOOL InputDialog_OnInitDialog(HWND hWndDlg, WPARAM wParam, LPARAM lParam);

static void InputDialog_FillControllerCombo(HWND hWndDlg);
static void InputDialog_FillButtonList(HWND hWndDlg);
static void InputDialog_FillMapCombo(HWND hWndDlg);

static void InputDialog_AssignA(DWORD iButton, DWORD dwCont, DWORD iControl);
static void InputDialog_AssignB(DWORD iButton, DWORD dwCont, DWORD iControl);

static void InputDialog_SelectMapComboEntry(HWND hWndDl, DWORD dwCont, DWORD dwID);

static ControlList s_CL;
static LONG g_nUnassignedIndex = 0;
static LONG g_nUnassignedIndex2 = 0;
static InputConfiguration * g_pIC = NULL;
static BOOL g_bIsCurrent = FALSE;

LONG InputDialog_DoModal(HWND hWndParent, InputConfiguration * pIC, BOOL bIsCurrent)
{
	LONG nRetVal;

	g_pIC = pIC;
	g_bIsCurrent = bIsCurrent;

	Input_AddMissingDevices(*pIC);

	nRetVal = DialogBox(g_hInstance, MAKEINTRESOURCE(IDD_INPUT), hWndParent, InputDialogProc);

	s_CL.controls.clear();

	return nRetVal;
}

#define CheckBox_GetCheck(hwnd)			SendMessage(hwnd, BM_GETCHECK, 0,0)
#define CheckBox_SetCheck(hwnd, state)	SendMessage(hwnd, BM_SETCHECK, (WPARAM)state,0)


BOOL CALLBACK InputDialogProc(HWND hWndDlg, UINT uMsg, WPARAM wParam, LPARAM lParam)
{
	BOOL bChecked;
	LONG iButton;
	LONG iController;
	LONG iControl;
	LONG nSelectedButton;
	LONG nSelectedController;
	LONG nSelectedControl;

	switch (uMsg)
	{
	case WM_INITDIALOG:
		return InputDialog_OnInitDialog(hWndDlg, wParam, lParam);

	case WM_COMMAND:
		switch (LOWORD(wParam))
		{
		case IDC_RESET_BUTTON:
			{
				Input_ResetConfig(*g_pIC);

				// Update devices!
				//Input_GetConfig(-1, *g_pIC);

				// Refresh
				nSelectedController =  ComboBox_GetCurSel(GetDlgItem(hWndDlg, IDC_CONTROLLER_COMBO));
				nSelectedButton = ListBox_GetCurSel(GetDlgItem(hWndDlg, IDC_BUTTON_LIST));
				if (nSelectedButton != LB_ERR)
				{
					iController = ComboBox_GetItemData(GetDlgItem(hWndDlg, IDC_CONTROLLER_COMBO), nSelectedController);
					iButton = ListBox_GetItemData(GetDlgItem(hWndDlg, IDC_BUTTON_LIST), nSelectedButton);
					InputDialog_SelectMapComboEntry(hWndDlg, iController, iButton);
				}

			}
			break;

		case IDC_C1_CHECK:
			bChecked = CheckBox_GetCheck(GetDlgItem(hWndDlg, IDC_C1_CHECK)) == BST_CHECKED;
			g_pIC->bConnected[0] = bChecked;
			break;

		case IDC_C2_CHECK:
			bChecked = CheckBox_GetCheck(GetDlgItem(hWndDlg, IDC_C2_CHECK)) == BST_CHECKED;
			g_pIC->bConnected[1] = bChecked;
			break;

		case IDC_C3_CHECK:
			bChecked = CheckBox_GetCheck(GetDlgItem(hWndDlg, IDC_C3_CHECK)) == BST_CHECKED;
			g_pIC->bConnected[2] = bChecked;
			break;

		case IDC_C4_CHECK:
			bChecked = CheckBox_GetCheck(GetDlgItem(hWndDlg, IDC_C4_CHECK)) == BST_CHECKED;
			g_pIC->bConnected[3] = bChecked;
			break;

		case IDC_BUTTON_LIST:
			if (HIWORD(wParam) == LBN_SELCHANGE)
			{
				nSelectedController =  ComboBox_GetCurSel(GetDlgItem(hWndDlg, IDC_CONTROLLER_COMBO));
				nSelectedButton = ListBox_GetCurSel(GetDlgItem(hWndDlg, IDC_BUTTON_LIST));
				if (nSelectedButton != LB_ERR)
				{
					iController = ComboBox_GetItemData(GetDlgItem(hWndDlg, IDC_CONTROLLER_COMBO), nSelectedController);
					iButton = ListBox_GetItemData(GetDlgItem(hWndDlg, IDC_BUTTON_LIST), nSelectedButton);
					InputDialog_SelectMapComboEntry(hWndDlg, iController, iButton);
				}
			}
			break;
		case IDC_CONTROLLER_COMBO:
			if (HIWORD(wParam) == CBN_SELCHANGE)
			{
				nSelectedController =  ComboBox_GetCurSel(GetDlgItem(hWndDlg, IDC_CONTROLLER_COMBO));
				nSelectedButton = ListBox_GetCurSel(GetDlgItem(hWndDlg, IDC_BUTTON_LIST));
				if (nSelectedButton != LB_ERR)
				{
					iController = ComboBox_GetItemData(GetDlgItem(hWndDlg, IDC_CONTROLLER_COMBO), nSelectedController);
					iButton = ListBox_GetItemData(GetDlgItem(hWndDlg, IDC_BUTTON_LIST), nSelectedButton);
					InputDialog_SelectMapComboEntry(hWndDlg, iController, iButton);
				}
			}
			break;

		case IDC_FIRST_MAP_COMBO:
			if (HIWORD(wParam) == CBN_SELCHANGE)
			{
				nSelectedController =  ComboBox_GetCurSel(GetDlgItem(hWndDlg, IDC_CONTROLLER_COMBO));
				nSelectedControl = ComboBox_GetCurSel(GetDlgItem(hWndDlg, IDC_FIRST_MAP_COMBO));
				nSelectedButton = ListBox_GetCurSel(GetDlgItem(hWndDlg, IDC_BUTTON_LIST));

				if (nSelectedController != CB_ERR &&
					nSelectedControl != CB_ERR &&
					nSelectedButton != LB_ERR)
				{
					iController = ComboBox_GetItemData(GetDlgItem(hWndDlg, IDC_CONTROLLER_COMBO), nSelectedController);
					iControl = ComboBox_GetItemData(GetDlgItem(hWndDlg, IDC_FIRST_MAP_COMBO), nSelectedControl);
					iButton = ListBox_GetItemData(GetDlgItem(hWndDlg, IDC_BUTTON_LIST), nSelectedButton);

					// iControl is index into s_CL.controls
					InputDialog_AssignA(iButton, iController, iControl);

					// Refresh
					InputDialog_SelectMapComboEntry(hWndDlg, iController, iButton);
				}
			}
			break;

		case IDC_SECOND_MAP_COMBO:
			if (HIWORD(wParam) == CBN_SELCHANGE)
			{
				nSelectedController =  ComboBox_GetCurSel(GetDlgItem(hWndDlg, IDC_CONTROLLER_COMBO));
				nSelectedControl = ComboBox_GetCurSel(GetDlgItem(hWndDlg, IDC_SECOND_MAP_COMBO));
				nSelectedButton = ListBox_GetCurSel(GetDlgItem(hWndDlg, IDC_BUTTON_LIST));

				if (nSelectedController != CB_ERR &&
					nSelectedControl != CB_ERR &&
					nSelectedButton != LB_ERR)
				{
					iController = ComboBox_GetItemData(GetDlgItem(hWndDlg, IDC_CONTROLLER_COMBO), nSelectedController);
					iControl = ComboBox_GetItemData(GetDlgItem(hWndDlg, IDC_SECOND_MAP_COMBO), nSelectedControl);
					iButton = ListBox_GetItemData(GetDlgItem(hWndDlg, IDC_BUTTON_LIST), nSelectedButton);

					// iControl is index into s_CL.controls
					InputDialog_AssignB(iButton, iController, iControl);

					// Refresh
					//InputDialog_SelectMapComboEntry(hWndDlg, iController, iButton);
				}
			}
			break;

		case IDOK:
			{
				// Copy our copy of the data back, setting up the new values
				// Do this in SelectInput dialog now!

				// We set the szFileName param of ic. This is not quite right -
				// as the new name does not include path info.
				// When this dialog returns, the caller calls Input_SetConfig, which calls
				// Input_RenameConfig(ic, ic.szFileName) to update the filename correctly
				if (!g_bIsCurrent)
					GetDlgItemText(hWndDlg, IDC_NAME_EDIT, g_pIC->szFileName, MAX_PATH);


				EndDialog(hWndDlg, IDOK);
			}
			return TRUE;
		case IDCANCEL:
			EndDialog(hWndDlg, IDCANCEL);
			return TRUE;
		}
		break;
	case WM_DESTROY:
		// Free any plugins that were found
		return TRUE;

	}
	return FALSE;
}

BOOL InputDialog_OnInitDialog(HWND hWndDlg, WPARAM wParam, LPARAM lParam)
{
	TCHAR szName[MAX_PATH+1];

	// Make a copy of the data
	if (g_bIsCurrent)
	{
		lstrcpyn(szName, g_pIC->szFileName, MAX_PATH);
		EnableWindow(GetDlgItem(hWndDlg, IDC_NAME_EDIT), FALSE);
	}
	else
	{
		lstrcpyn(szName, PathFindFileName(g_pIC->szFileName), MAX_PATH);
		PathRemoveExtension(szName);
		EnableWindow(GetDlgItem(hWndDlg, IDC_NAME_EDIT), TRUE);

	}
	SetDlgItemText(hWndDlg, IDC_NAME_EDIT, szName);

	// Initialise the checkboxes
	CheckBox_SetCheck(GetDlgItem(hWndDlg, IDC_C1_CHECK), g_pIC->bConnected[0] ? BST_CHECKED : BST_UNCHECKED);
	CheckBox_SetCheck(GetDlgItem(hWndDlg, IDC_C2_CHECK), g_pIC->bConnected[1] ? BST_CHECKED : BST_UNCHECKED);
	CheckBox_SetCheck(GetDlgItem(hWndDlg, IDC_C3_CHECK), g_pIC->bConnected[2] ? BST_CHECKED : BST_UNCHECKED);
	CheckBox_SetCheck(GetDlgItem(hWndDlg, IDC_C4_CHECK), g_pIC->bConnected[3] ? BST_CHECKED : BST_UNCHECKED);


	// Initialise the lists
	InputDialog_FillControllerCombo(hWndDlg);
	InputDialog_FillMapCombo(hWndDlg);			// Have to do this before button list is filled
	InputDialog_FillButtonList(hWndDlg);


	SetFocus(GetDlgItem(hWndDlg, IDC_CONTROLLER_COMBO));

	// We set the focus, return false
	return FALSE;
}


void InputDialog_FillControllerCombo(HWND hWndDlg)
{

	LONG i;
	HWND hWndCombo;
	CHAR szName[100];
	LONG nIndex;
	LONG nSelection;

	hWndCombo = GetDlgItem(hWndDlg, IDC_CONTROLLER_COMBO);

	ComboBox_ResetContent(hWndCombo);

	nSelection = -1;

	for (i = 0; i < 4; i++)
	{
		wsprintf(szName, "Controller %d", i+1);

		nIndex = ComboBox_InsertString(hWndCombo, -1, szName);

		if (nIndex != CB_ERR && nIndex != CB_ERRSPACE)
		{
			// Controller 1 is the initial selection
			if (i == 0)
			{
				nSelection = nIndex;
			}

			// Set item data
			ComboBox_SetItemData(hWndCombo, nIndex, i);
		}
	}

	if (nSelection == -1)
		nSelection = 0;

	ComboBox_SetCurSel(hWndCombo, nSelection);

}

void InputDialog_FillButtonList(HWND hWndDlg)
{

	LONG i;
	HWND hWndList;
	LONG nSelection;
	LONG nIndex;

	hWndList = GetDlgItem(hWndDlg, IDC_BUTTON_LIST);

	ListBox_ResetContent(hWndList);

	// Set selected item to first in list
	nSelection = -1;

	for (i = 0; i < NUM_INPUT_IDS; i++)
	{
		nIndex = ListBox_AddString(hWndList, g_N64Buttons[i].szName);
		if (nIndex != LB_ERR && nIndex != LB_ERRSPACE)
		{
			if (i == 0)
			{
				nSelection = nIndex;
			}

			// Set item data
			ListBox_SetItemData(hWndList, nIndex, i);	// The item data is the ID value

		}
	}
	if (nSelection == -1)
		nSelection = 0;

	ListBox_SetCurSel(hWndList, nSelection);
	InputDialog_SelectMapComboEntry(hWndDlg, 0, 0);

}

static int __cdecl InputDialog_CompareControls(const void * p1, const void * p2) 
{
	ControlID * cid1 = (ControlID *)p1;
	ControlID * cid2 = (ControlID *)p2;

	return (int)lstrcmpi(cid1->szName, cid2->szName);
}

void InputDialog_FillMapCombo(HWND hWndDlg)
{
	LONG i;
	HRESULT hr;
	HWND hWndCombo;
	HWND hWndCombo2;
	LONG nIndex;

	hr = Input_GenerateAllObjects(*g_pIC, &s_CL);
	if (FAILED(hr))
		return;

	// Sort the items
	qsort(&s_CL.controls[0],
		s_CL.controls.size(),
		sizeof(s_CL.controls[0]),
		InputDialog_CompareControls);

	hWndCombo = GetDlgItem(hWndDlg, IDC_FIRST_MAP_COMBO);
	hWndCombo2 = GetDlgItem(hWndDlg, IDC_SECOND_MAP_COMBO);

	ComboBox_ResetContent(hWndCombo);
	ComboBox_ResetContent(hWndCombo2);

	g_nUnassignedIndex = ComboBox_InsertString(hWndCombo, -1, "<Unassigned>");
	ComboBox_SetItemData(hWndCombo, g_nUnassignedIndex, -1);

	g_nUnassignedIndex2 = ComboBox_InsertString(hWndCombo2, -1, "<Unassigned>");
	ComboBox_SetItemData(hWndCombo, g_nUnassignedIndex2, -1);

	for (i = 0; i < s_CL.controls.size(); i++)
	{
		nIndex = ComboBox_InsertString(hWndCombo, -1, s_CL.controls[i].szName);

		if (nIndex != CB_ERR && nIndex != CB_ERRSPACE)
		{
			// Set data to the index of this item
			s_CL.controls[i].dwData = nIndex;

			// Set item data
			ComboBox_SetItemData(hWndCombo, nIndex, i);
		}

		nIndex = ComboBox_InsertString(hWndCombo2, -1, s_CL.controls[i].szName);

		if (nIndex != CB_ERR && nIndex != CB_ERRSPACE)
		{
			// Set data to the index of this item
			s_CL.controls[i].dwData2 = nIndex;

			// Set item data
			ComboBox_SetItemData(hWndCombo2, nIndex, i);
		}
	}


}

void InputDialog_SelectMapComboEntry(HWND hWndDlg, DWORD dwCont, DWORD dwID)
{
	HWND hWndCombo;
	HWND hWndCombo2;
	DWORD dwDevice;
	DWORD dwOfsA;
	DWORD dwOfsB;
	LONG i;
	BOOL bNeedTwoCombos;
	BOOL bFirstIsAxis;

	// Check the ID is in range
	if (dwID >= NUM_INPUT_IDS)
		return;

	hWndCombo = GetDlgItem(hWndDlg, IDC_FIRST_MAP_COMBO);
	hWndCombo2 = GetDlgItem(hWndDlg, IDC_SECOND_MAP_COMBO);

	// Get the currently assigned control/offset
	dwDevice = g_pIC->buttons[dwCont][dwID].dwDevice;
	dwOfsA   = g_pIC->buttons[dwCont][dwID].dwOfsA;
	dwOfsB   = g_pIC->buttons[dwCont][dwID].dwOfsB;


	// Search through list of controls, looking for the correct index
	bFirstIsAxis = FALSE;
	if (dwOfsA == ~0)
	{
		// Select <unassigned> entry
		ComboBox_SetCurSel(hWndCombo, g_nUnassignedIndex);
	}
	else
	{
		for (i = 0; i < s_CL.controls.size(); i++)
		{
			if (s_CL.controls[i].dwDevice == dwDevice &&
				s_CL.controls[i].dwOfs    == dwOfsA)
			{
				// The data item is the index of the specified control
				ComboBox_SetCurSel(hWndCombo, s_CL.controls[i].dwData);

				bFirstIsAxis = s_CL.controls[i].bIsAxis;
				break;

			}
		}
	}

	if (g_N64Buttons[dwID].bIsAxis && !bFirstIsAxis)
		bNeedTwoCombos = TRUE;
	else
		bNeedTwoCombos = FALSE;

	// Enable the second combo if this is an axis and the first control
	// is a button
	if (bNeedTwoCombos)
	{
		EnableWindow(hWndCombo2, TRUE);
		EnableWindow(GetDlgItem(hWndDlg, IDC_SECOND_MAP_STATIC), TRUE);

		if (dwOfsB == ~0)
		{
			// Select <unassigned> entry
			ComboBox_SetCurSel(hWndCombo2, g_nUnassignedIndex2);

		}
		else
		{
			// Fill in second combo
			for (i = 0; i < s_CL.controls.size(); i++)
			{
				if (s_CL.controls[i].dwDevice == dwDevice &&
					s_CL.controls[i].dwOfs    == dwOfsB)
				{
					// The data item is the index of the specified control
					ComboBox_SetCurSel(hWndCombo2, s_CL.controls[i].dwData2);
					break;

				}
			}
		}

	}
	else
	{
		EnableWindow(hWndCombo2, FALSE);
		EnableWindow(GetDlgItem(hWndDlg, IDC_SECOND_MAP_STATIC), FALSE);

		// Clear second combo?
		ComboBox_SetCurSel(hWndCombo2, g_nUnassignedIndex2);
	}


	// Not found!
}

void InputDialog_AssignA(DWORD iButton, DWORD dwCont, DWORD iControl)
{
	g_pIC->buttons[dwCont][iButton].dwDevice = s_CL.controls[iControl].dwDevice;
	g_pIC->buttons[dwCont][iButton].dwOfsA   = s_CL.controls[iControl].dwOfs;
	g_pIC->buttons[dwCont][iButton].bIsAxis  = s_CL.controls[iControl].bIsAxis;

	DBGConsole_Msg(0, "Assigning %s (%d %d %d) to %s",
		s_CL.controls[iControl].szName, g_pIC->buttons[dwCont][iButton].dwDevice,
		g_pIC->buttons[dwCont][iButton].dwOfsA, g_pIC->buttons[dwCont][iButton].bIsAxis,
		g_N64Buttons[iButton].szName);
}

void InputDialog_AssignB(DWORD iButton, DWORD dwCont, DWORD iControl)
{
	g_pIC->buttons[dwCont][iButton].dwDevice = s_CL.controls[iControl].dwDevice;
	g_pIC->buttons[dwCont][iButton].dwOfsB   = s_CL.controls[iControl].dwOfs;
	g_pIC->buttons[dwCont][iButton].bIsAxis  = s_CL.controls[iControl].bIsAxis;

	DBGConsole_Msg(0, "Assigning %s (%d %d %d) to %s",
		s_CL.controls[iControl].szName, g_pIC->buttons[dwCont][iButton].dwDevice,
		g_pIC->buttons[dwCont][iButton].dwOfsB, g_pIC->buttons[dwCont][iButton].bIsAxis,
		g_N64Buttons[iButton].szName);
}
