// GraphicsPlugin.h: interface for the CGraphicsPlugin class.
//
//////////////////////////////////////////////////////////////////////

#ifndef __GRAPHICSPLUGIN_H__
#define __GRAPHICSPLUGIN_H__

#if _MSC_VER > 1000
#pragma once
#endif // _MSC_VER > 1000

#include "GraphicsPlugin_Spec.h"
#include "CritSect.h"
#include "DBGConsole.h"

#define PLUGIN_SPEC_CALL		__cdecl


#define GFX_LOCK		Lock();
#define GFX_UNLOCK	Unlock();

#define GFX_TRY		try
#define GFX_CATCH	catch(...)								\
		{													\
				DBGConsole_Msg(0, "Exception in [C%s]", szModuleName);	\
				Close();									\
				throw;			\
		}


class CGraphicsPlugin : protected CCritSect
{
public:
	CGraphicsPlugin(LPCTSTR szDllName);
	virtual ~CGraphicsPlugin();

public:


	//EXPORT void CALL ViWidthChanged (void);
	void ViWidthChanged()
	{
		GFX_LOCK
		if (pViWidthChanged)
		{
			GFX_TRY { pViWidthChanged(); }
			GFX_CATCH
		}
		GFX_UNLOCK
	}

	//EXPORT void CALL ViStatusChanged (void);
	void ViStatusChanged()
	{
		GFX_LOCK
		if (pViStatusChanged)
		{
			GFX_TRY { pViStatusChanged(); }
			GFX_CATCH
		}
		GFX_UNLOCK
	}

	//EXPORT void CALL MoveScreen(int xpos, int ypos);
	void MoveScreen(int xpos, int ypos)
	{
		GFX_LOCK
		if (pMoveScreen)
		{
			GFX_TRY { pMoveScreen(xpos, ypos); }
			GFX_CATCH
		}
		GFX_UNLOCK
	}

	//EXPORT void CALL DrawScreen (void);
	void DrawScreen()
	{
		GFX_LOCK
		if (pDrawScreen)
		{
			GFX_TRY { pDrawScreen(); }
			GFX_CATCH
		}
		GFX_UNLOCK
	}



	//EXPORT void CALL ChangeWindow (void);
	void ChangeWindow()
	{
		GFX_LOCK
		if (pChangeWindow)
		{
			GFX_TRY { pChangeWindow(); }
			GFX_CATCH
		}
		GFX_UNLOCK
	}


	//EXPORT void CALL UpdateScreen (void);
	void UpdateScreen()
	{
		GFX_LOCK
		if (pUpdateScreen)
		{
			GFX_TRY { pUpdateScreen(); }
			GFX_CATCH
		}
		GFX_UNLOCK
	}

	//EXPORT void CALL DllAbout ( HWND hParent );
	void DllAbout(HWND hWndParent)
	{
		GFX_LOCK
		if (pDllAbout)
		{
			GFX_TRY { pDllAbout(hWndParent); }
			GFX_CATCH
		}
		GFX_UNLOCK
	}

	//EXPORT void CALL DllConfig ( HWND hParent );
	void DllConfig(HWND hWndParent)
	{
		GFX_LOCK
		if (pDllConfig)
		{
			GFX_TRY { pDllConfig(hWndParent); }
			GFX_CATCH
		}
		GFX_UNLOCK
	}

	//EXPORT void CALL DllTest ( HWND hParent );
	void DllTest(HWND hWndParent)
	{
		GFX_LOCK
		if (pDllTest)
		{
			GFX_TRY { pDllTest(hWndParent); }
			GFX_CATCH
		}
		GFX_UNLOCK
	}

	//EXPORT void CALL GetDllInfo ( PLUGIN_INFO * PluginInfo );
	void GetDllInfo(PLUGIN_INFO * p)
	{
		GFX_LOCK
		if (pGetDllInfo)
		{
			GFX_TRY { pGetDllInfo(p); }
			GFX_CATCH
		}
		GFX_UNLOCK
	}

	//EXPORT BOOL CALL InitiateGFX (GFX_INFO Gfx_Info);
	BOOL InitiateGFX(GFX_INFO gi)
	{
		BOOL bInit = FALSE;

		GFX_LOCK
		if (pInitiateGFX)
		{
			GFX_TRY { bInit = pInitiateGFX(gi); }
			GFX_CATCH
		}
		GFX_UNLOCK
	
		return bInit;
	}

	//EXPORT void CALL ProcessDList(void);
	void ProcessDList(void)
	{
		GFX_LOCK
		if (pProcessDList)
		{
			GFX_TRY { pProcessDList(); }
			GFX_CATCH
		}
		GFX_UNLOCK
	}


	//EXPORT void CALL RomClosed (void);
	void RomClosed(void)
	{
		GFX_LOCK
		if (pRomClosed)
		{
			GFX_TRY { pRomClosed(); }
			GFX_CATCH
		}
		GFX_UNLOCK
	}

	//EXPORT void CALL RomOpen (void);
	void RomOpen(void)
	{
		GFX_LOCK
		if (pRomOpen)
		{
			GFX_TRY { pRomOpen(); }
			GFX_CATCH
		}
		GFX_UNLOCK
	}
	
	
	BOOL LoadedOk()
	{
		return bLoadedOk;
	}

	// szName must be 100 chars
	void GetPluginName(LPSTR szName)
	{
		if (!bLoadedOk)
			lstrcpy(szName, "?");
		else
			lstrcpy(szName, pi.Name);

	}

	BOOL ReInit()
	{
		GFX_LOCK
		Close();
		if (Open())
			return Init();

		return FALSE;
		GFX_UNLOCK
	}

	BOOL Open();
	BOOL Init();

	void Close();

	//EXPORT void CALL CloseDLL (void);
	void CloseDll()
	{
		GFX_LOCK
		if (pCloseDll)
		{
			GFX_TRY { pCloseDll(); }
			GFX_CATCH
		}
		GFX_UNLOCK
	}


protected:
	void   (PLUGIN_SPEC_CALL * pViWidthChanged)(void);
	void   (PLUGIN_SPEC_CALL * pViStatusChanged)(void);
	void   (PLUGIN_SPEC_CALL * pMoveScreen)(int, int);
	void   (PLUGIN_SPEC_CALL * pDrawScreen)(void);
	void   (PLUGIN_SPEC_CALL * pChangeWindow)(void);
	void   (PLUGIN_SPEC_CALL * pUpdateScreen)();
	void   (PLUGIN_SPEC_CALL * pCloseDll)();
	void   (PLUGIN_SPEC_CALL * pDllAbout)(HWND);
	void   (PLUGIN_SPEC_CALL * pDllConfig)(HWND);
	void   (PLUGIN_SPEC_CALL * pDllTest)(HWND);
	void   (PLUGIN_SPEC_CALL * pGetDllInfo)(PLUGIN_INFO *);
	BOOL   (PLUGIN_SPEC_CALL * pInitiateGFX)(GFX_INFO);
	void   (PLUGIN_SPEC_CALL * pProcessDList)(void);
	void   (PLUGIN_SPEC_CALL * pRomClosed)(void);
	void   (PLUGIN_SPEC_CALL * pRomOpen)(void);

	HINSTANCE hModule;
	PLUGIN_INFO pi;
	BOOL bLoadedOk;
	TCHAR szModuleName[MAX_PATH+1];

};

#endif // __GRAPHICSPLUGIN_H__
