// GraphicsPlugin.cpp: implementation of the CGraphicsPlugin class.
//
//////////////////////////////////////////////////////////////////////

#include "stdafx.h"
#include "GraphicsPlugin.h"

#include "CPU.h"
#include "Memory.h"
#include "ROM.h"

#define DPC_REG_ADDRESS(reg)		\
	&((DWORD *)g_pMemoryBuffers[MEM_DP_COMMAND_REG])[(reg - DPC_BASE_REG) / 4]

#define MI_REG_ADDRESS(reg)		\
	&((DWORD *)g_pMemoryBuffers[MEM_MI_REG])[(reg - MI_BASE_REG) / 4]

#define VI_REG_ADDRESS(reg)		\
	&((DWORD *)g_pMemoryBuffers[MEM_VI_REG])[(reg - VI_BASE_REG) / 4]




//////////////////////////////////////////////////////////////////////
// Construction/Destruction
//////////////////////////////////////////////////////////////////////

CGraphicsPlugin::CGraphicsPlugin(LPCTSTR szDllName) :
	pViWidthChanged(NULL),
	pViStatusChanged(NULL),
	pMoveScreen(NULL),
	pDrawScreen(NULL),
	pChangeWindow(NULL),
	pUpdateScreen(NULL),
	pCloseDll(NULL),
	pDllAbout(NULL),
	pDllConfig(NULL),
	pDllTest(NULL),
	pGetDllInfo(NULL),
	pInitiateGFX(NULL),
	pProcessDList(NULL),
	pRomClosed(NULL),
	pRomOpen(NULL),

	hModule(NULL),
	bLoadedOk(FALSE)

{
	lstrcpyn(szModuleName, szDllName, MAX_PATH);
}


static void __cdecl CheckInterrupts(void)
{
	//DBGConsole_Msg(0, "GFX Plugin called Check Interrupts");

	// Or check postponed?
	AddCPUJob(CPU_CHECK_INTERRUPTS);
}


CGraphicsPlugin::~CGraphicsPlugin()
{
	Close();
}


BOOL CGraphicsPlugin::Open()
{
	hModule = LoadLibrary(szModuleName);
	if (hModule == NULL)
		return FALSE;


	pGetDllInfo = (void (PLUGIN_SPEC_CALL *)(PLUGIN_INFO *))GetProcAddress(hModule, "GetDllInfo");
	if (pGetDllInfo == NULL)
		return FALSE;

	pGetDllInfo(&pi);
	if (pi.Type != PLUGIN_TYPE_GFX)
	{
		return FALSE;
	}

    pViWidthChanged = (void   (PLUGIN_SPEC_CALL * )(void))GetProcAddress(hModule, "ViWidthChanged");
    pViStatusChanged= (void   (PLUGIN_SPEC_CALL * )(void))GetProcAddress(hModule, "ViStatusChanged");
    pMoveScreen     = (void   (PLUGIN_SPEC_CALL * )(int,int))GetProcAddress(hModule, "MoveScreen");
    pDrawScreen     = (void   (PLUGIN_SPEC_CALL * )(void))GetProcAddress(hModule, "DrawScreen");
    pChangeWindow   = (void   (PLUGIN_SPEC_CALL * )(void))GetProcAddress(hModule, "ChangeWindow");
    pUpdateScreen   = (void   (PLUGIN_SPEC_CALL * )(void))GetProcAddress(hModule, "UpdateScreen");
    pCloseDll       = (void   (PLUGIN_SPEC_CALL * )(void))GetProcAddress(hModule, "CloseDLL");
    pDllAbout       = (void   (PLUGIN_SPEC_CALL * )(HWND))GetProcAddress(hModule, "DllAbout");
    pDllConfig      = (void   (PLUGIN_SPEC_CALL * )(HWND))GetProcAddress(hModule, "DllConfig");
    pDllTest        = (void   (PLUGIN_SPEC_CALL * )(HWND))GetProcAddress(hModule, "DllTest");
    pInitiateGFX	= (BOOL   (PLUGIN_SPEC_CALL * )(GFX_INFO))GetProcAddress(hModule, "InitiateGFX");
    pProcessDList   = (void   (PLUGIN_SPEC_CALL * )(void))GetProcAddress(hModule, "ProcessDList");
    pRomClosed      = (void   (PLUGIN_SPEC_CALL * )(void))GetProcAddress(hModule, "RomClosed");
    pRomOpen		= (void   (PLUGIN_SPEC_CALL * )(void))GetProcAddress(hModule, "RomOpen");

	bLoadedOk = TRUE;

	return TRUE;

}

void CGraphicsPlugin::Close()
{
	bLoadedOk = FALSE;


	if (hModule != NULL)
	{
		//CloseDll();
		FreeLibrary(hModule);
	}


	pGetDllInfo = NULL;
    pViWidthChanged = NULL;
    pViStatusChanged = NULL;
    pMoveScreen = NULL;
    pDrawScreen = NULL;
    pChangeWindow = NULL;
    pUpdateScreen = NULL;
    pCloseDll = NULL;
    pDllAbout = NULL;
    pDllConfig = NULL;
    pDllTest = NULL;
    pInitiateGFX = NULL;
    pProcessDList = NULL;
    pRomClosed = NULL;
    pRomOpen = NULL;
	hModule = NULL;
}




BOOL CGraphicsPlugin::Init()
{
	GFX_INFO gfx;

	gfx.hWnd = g_hMainWindow;
	gfx.hStatusBar = g_hWndStatus;
	gfx.MemoryBswaped = TRUE;
	gfx.HEADER = (BYTE*)&g_ROM.rh;
	gfx.RDRAM = (BYTE*)g_pMemoryBuffers[MEM_RD_RAM];
	gfx.DMEM = (BYTE*)g_pMemoryBuffers[MEM_SP_MEM] + SP_DMA_DMEM;
	gfx.IMEM = (BYTE*)g_pMemoryBuffers[MEM_SP_MEM] + SP_DMA_IMEM;

	gfx.xMI_INTR_REG = MI_REG_ADDRESS(MI_INTR_REG);

	gfx.xDPC_START_REG = DPC_REG_ADDRESS(DPC_START_REG);
	gfx.xDPC_END_REG = DPC_REG_ADDRESS(DPC_END_REG);
	gfx.xDPC_CURRENT_REG = DPC_REG_ADDRESS(DPC_CURRENT_REG);
	gfx.xDPC_STATUS_REG = DPC_REG_ADDRESS(DPC_STATUS_REG);
	gfx.xDPC_CLOCK_REG = DPC_REG_ADDRESS(DPC_CLOCK_REG);
	gfx.xDPC_BUFBUSY_REG = DPC_REG_ADDRESS(DPC_BUFBUSY_REG);
	gfx.xDPC_PIPEBUSY_REG = DPC_REG_ADDRESS(DPC_PIPEBUSY_REG);
	gfx.xDPC_TMEM_REG = DPC_REG_ADDRESS(DPC_TMEM_REG);

	gfx.xVI_STATUS_REG = VI_REG_ADDRESS(VI_STATUS_REG);
	gfx.xVI_ORIGIN_REG = VI_REG_ADDRESS(VI_ORIGIN_REG);
	gfx.xVI_WIDTH_REG = VI_REG_ADDRESS(VI_WIDTH_REG);
	gfx.xVI_INTR_REG = VI_REG_ADDRESS(VI_INTR_REG);
	gfx.xVI_V_CURRENT_LINE_REG = VI_REG_ADDRESS(VI_V_CURRENT_LINE_REG);
	gfx.xVI_TIMING_REG = VI_REG_ADDRESS(VI_TIMING_REG);
	gfx.xVI_V_SYNC_REG = VI_REG_ADDRESS(VI_V_SYNC_REG);
	gfx.xVI_H_SYNC_REG = VI_REG_ADDRESS(VI_H_SYNC_REG);
	gfx.xVI_LEAP_REG = VI_REG_ADDRESS(VI_LEAP_REG);
	gfx.xVI_H_START_REG = VI_REG_ADDRESS(VI_H_START_REG);
	gfx.xVI_V_START_REG = VI_REG_ADDRESS(VI_V_START_REG);
	gfx.xVI_V_BURST_REG = VI_REG_ADDRESS(VI_V_BURST_REG);
	gfx.xVI_X_SCALE_REG = VI_REG_ADDRESS(VI_X_SCALE_REG);
	gfx.xVI_Y_SCALE_REG = VI_REG_ADDRESS(VI_Y_SCALE_REG);


	gfx.CheckInterrupts = CheckInterrupts;

	BOOL bGFX = InitiateGFX(gfx);
	if (!bGFX)
	{
		DBGConsole_Msg(0, "Unable to initialise gfx plugin");
		return FALSE;
	}
	else
	{	
		DBGConsole_Msg(0, "Graphics plugin initialised ok");
		return TRUE;
	}

	RomClosed();

}

