/*
Copyright (C) 2001 StrmnNrmn

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

*/

#include "stdafx.h"
#include "resource.h"
#include "GraphicsDialog.h"
#include "CPU.h"			// g_pGfxPlugin
#include <shlwapi.h>
#include <windowsx.h>		// ComboBox_ defines
#include "DBGConsole.h"
#include "ConfigHandler.h"

static BOOL CALLBACK GraphicsDialogProc(HWND hWndDlg, UINT uMsg, WPARAM wParam, LPARAM lParam);
static BOOL GraphicsDialog_OnInitDialog(HWND hWndDlg, WPARAM wParam, LPARAM lParam);

static void GraphicsDialog_FreePluginList();
static BOOL GraphicsDialog_InitPluginList();
static void GraphicsDialog_FillPluginCombo(HWND hWndDlg);
static void GraphicsDialog_EnableControls(HWND hWndDlg, BOOL bEnabled);

typedef struct 
{
	TCHAR	szFileName[MAX_PATH+1];
	CGraphicsPlugin * pPlugin;
	BOOL bCurrentlyInUse;

} GraphicsPluginInfo;

typedef std::vector< GraphicsPluginInfo > GraphicsPluginVector;

static GraphicsPluginVector g_GraphicsPlugins;
static LONG g_nCurSelection = -1;


void GraphicsDialog_DoModal(HWND hWndParent)
{
	DialogBox(g_hInstance, MAKEINTRESOURCE(IDD_GRAPHICS), hWndParent, GraphicsDialogProc);

}

#define CheckBox_GetCheck(hwnd)			SendMessage(hwnd, BM_GETCHECK, 0,0)
#define CheckBox_SetCheck(hwnd, state)	SendMessage(hwnd, BM_SETCHECK, (WPARAM)state,0)


BOOL CALLBACK GraphicsDialogProc(HWND hWndDlg, UINT uMsg, WPARAM wParam, LPARAM lParam)
{
	LONG nSelection;
	LONG nIndex;
	LONG nCheckedState;

	switch (uMsg)
	{
	case WM_INITDIALOG:
		return GraphicsDialog_OnInitDialog(hWndDlg, wParam, lParam);

	case WM_COMMAND:
		switch (LOWORD(wParam))
		{
		case IDC_GRAPHICS_CHECK:

			nCheckedState = CheckBox_GetCheck(GetDlgItem(hWndDlg, IDC_GRAPHICS_CHECK));
			if (nCheckedState == BST_CHECKED)
			{
				GraphicsDialog_EnableControls(hWndDlg, TRUE);
			}
			else if (nCheckedState == BST_UNCHECKED)
			{
				GraphicsDialog_EnableControls(hWndDlg, FALSE);
			}

			return TRUE;

		/*case IDC_PLUGIN_COMBO:

			return TRUE;*/
			// File menu commands
		case IDC_ABOUT_BUTTON:
			nSelection = ComboBox_GetCurSel(GetDlgItem(hWndDlg, IDC_PLUGIN_COMBO));
			nIndex = ComboBox_GetItemData(GetDlgItem(hWndDlg, IDC_PLUGIN_COMBO), nSelection);
			if (nIndex != CB_ERR && nIndex < g_GraphicsPlugins.size())
			{
				if (g_GraphicsPlugins[nIndex].pPlugin != NULL)
				{
					g_GraphicsPlugins[nIndex].pPlugin->DllAbout(hWndDlg);
				}
			}
			return TRUE;
		case IDC_CONFIG_BUTTON:
			if (g_pGfxPlugin == NULL)
			{
				MessageBox(hWndDlg, CResourceString(IDS_CONFIGGFX), g_szDaedalusName, MB_OK);
			}
			else
			{
				nSelection = ComboBox_GetCurSel(GetDlgItem(hWndDlg, IDC_PLUGIN_COMBO));
				nIndex = ComboBox_GetItemData(GetDlgItem(hWndDlg, IDC_PLUGIN_COMBO), nSelection);
				if (nIndex != CB_ERR && nIndex < g_GraphicsPlugins.size())
				{
					if (g_GraphicsPlugins[nIndex].pPlugin != NULL)
					{
						g_GraphicsPlugins[nIndex].pPlugin->DllConfig(hWndDlg);
					}
				}
			}
			return TRUE;

		case IDOK:
			nCheckedState = CheckBox_GetCheck(GetDlgItem(hWndDlg, IDC_GRAPHICS_CHECK));
			nSelection = ComboBox_GetCurSel(GetDlgItem(hWndDlg, IDC_PLUGIN_COMBO));

			nIndex = ComboBox_GetItemData(GetDlgItem(hWndDlg, IDC_PLUGIN_COMBO), nSelection);
			if (nIndex != CB_ERR && nIndex < g_GraphicsPlugins.size())
			{
				// Update main plugin!
				// Write to config!!!
				// Reinitialise!
				TCHAR szNewFileName[MAX_PATH+1];

				if (nCheckedState == BST_CHECKED)
				{
					lstrcpyn(szNewFileName, g_GraphicsPlugins[nIndex].szFileName, MAX_PATH);
				}
				else if (nCheckedState == BST_UNCHECKED)
				{
					lstrcpyn(szNewFileName, TEXT(""), MAX_PATH);
				}

				{
					// NULL - Write to registry
					ConfigHandler * pConfig = new ConfigHandler("Main");
					
					if (pConfig != NULL)
					{
						pConfig->WriteString("GraphicsPlugin", szNewFileName);
						delete pConfig;
					}
				}

				DBGConsole_Msg(0, "Graphics plugin [C%s] selected", szNewFileName);
				if (lstrcmpi(szNewFileName, g_szGfxPluginFileName) != 0)
				{
					lstrcpyn(g_szGfxPluginFileName, szNewFileName, MAX_PATH);

					//g_bReloadGfxPlugin = TRUE;
					if (g_bCPURunning)
						MessageBox(hWndDlg, CResourceString(IDS_STOPSTARTCPU), g_szDaedalusName, MB_OK);
				}

				// Set to null so that it is not deleted when we clean up
				//g_GraphicsPlugins[nSelection].pPlugin = NULL;
			}
			EndDialog(hWndDlg, IDOK);
			return TRUE;
		case IDCANCEL:
			EndDialog(hWndDlg, IDCANCEL);
			return TRUE;
		}
		break;
	case WM_DESTROY:
		// Free any plugins that were found
		GraphicsDialog_FreePluginList();
		return TRUE;

	}


	return FALSE;
}

BOOL GraphicsDialog_OnInitDialog(HWND hWndDlg, WPARAM wParam, LPARAM lParam)
{

	// Initialise the 
	if (GraphicsDialog_InitPluginList())
		GraphicsDialog_FillPluginCombo(hWndDlg);

	if (lstrlen(g_szGfxPluginFileName) == 0)
	{
		CheckBox_SetCheck(GetDlgItem(hWndDlg, IDC_GRAPHICS_CHECK), BST_UNCHECKED);
		GraphicsDialog_EnableControls(hWndDlg, FALSE);
	}
	else
	{
		CheckBox_SetCheck(GetDlgItem(hWndDlg, IDC_GRAPHICS_CHECK), BST_CHECKED);
		GraphicsDialog_EnableControls(hWndDlg, TRUE);
	}


	SetFocus(GetDlgItem(hWndDlg, IDC_PLUGIN_COMBO));

	// We set the foucus, return false
	return FALSE;
}

// Free all plugins in list
void GraphicsDialog_FreePluginList()
{
	LONG i;
	LONG nNumPlugins;

	nNumPlugins = g_GraphicsPlugins.size();
	for (i = 0; i < nNumPlugins; i++)
	{
		if (g_GraphicsPlugins[i].pPlugin != NULL &&
			!g_GraphicsPlugins[i].bCurrentlyInUse)
		{
			delete g_GraphicsPlugins[i].pPlugin;
		}
	}
	g_GraphicsPlugins.clear();
}

// Scan
BOOL GraphicsDialog_InitPluginList()
{
	HANDLE hFind;
	WIN32_FIND_DATA fd;
	TCHAR szFileSpec[MAX_PATH+1];
	GraphicsPluginInfo api;

	// Delete existing plugins
	GraphicsDialog_FreePluginList();

	lstrcpyn(szFileSpec, g_szDaedalusExeDir, MAX_PATH);
	PathAppend(szFileSpec, TEXT("Plugins"));
	PathAppend(szFileSpec, TEXT("*.dll"));


	hFind = FindFirstFile(szFileSpec, &fd);
	if (hFind == INVALID_HANDLE_VALUE)
		return FALSE;

	do
	{
		lstrcpyn(api.szFileName, szFileSpec, MAX_PATH);
		PathRemoveFileSpec(api.szFileName);
		PathAppend(api.szFileName, fd.cFileName);

		/*if (lstrcmpi(api.szFileName, g_szGfxPluginFileName) == 0)
		{
			api.pPlugin = g_pAiPlugin;
			api.bCurrentlyInUse = TRUE;
		}
		else*/
		{
			api.pPlugin = new CGraphicsPlugin(api.szFileName);
			if (api.pPlugin != NULL)
				api.pPlugin->Open();
			api.bCurrentlyInUse = FALSE;
		}

		if (api.pPlugin == NULL)
			continue;

		if (api.pPlugin->LoadedOk())
			g_GraphicsPlugins.push_back(api);
		else if (!api.bCurrentlyInUse)
			delete api.pPlugin;

	} while (FindNextFile(hFind, &fd));

	FindClose(hFind);

	return TRUE;
}


void GraphicsDialog_FillPluginCombo(HWND hWndDlg)
{

	LONG i;
	LONG nNumPlugins;
	HWND hWndCombo;
	CHAR szName[100];
	LONG nIndex;
	LONG nSelection;

	hWndCombo = GetDlgItem(hWndDlg, IDC_PLUGIN_COMBO);
	nNumPlugins = g_GraphicsPlugins.size();

	ComboBox_ResetContent(hWndCombo);

	nSelection = -1;

	for (i = 0; i < nNumPlugins; i++)
	{
		if (g_GraphicsPlugins[i].pPlugin == NULL)
			continue;

		g_GraphicsPlugins[i].pPlugin->GetPluginName(szName);

		nIndex = ComboBox_InsertString(hWndCombo, -1, szName);

		if (nIndex != CB_ERR && nIndex != CB_ERRSPACE)
		{
			// Record the index if this is the current selection
			if (lstrcmpi(g_GraphicsPlugins[i].szFileName, 
				g_szGfxPluginFileName) == 0)
			{
				nSelection = nIndex;
			}

			// Set item data
			ComboBox_SetItemData(hWndCombo, nIndex, i);
		}
	}

	if (nSelection == -1)
		nSelection = 0;

	ComboBox_SetCurSel(hWndCombo, nSelection);

}


void GraphicsDialog_EnableControls(HWND hWndDlg, BOOL bEnabled)
{
	EnableWindow(GetDlgItem(hWndDlg, IDC_PLUGIN_COMBO), bEnabled);
	EnableWindow(GetDlgItem(hWndDlg, IDC_ABOUT_BUTTON), bEnabled);
	EnableWindow(GetDlgItem(hWndDlg, IDC_CONFIG_BUTTON), bEnabled);

}