// GfxContext.h: interface for the CGfxContext class.
//
//////////////////////////////////////////////////////////////////////

#if !defined(AFX_GFXCONTEXT_H__B59609D3_D6F8_4C85_AF86_EE3E0ADE39B7__INCLUDED_)
#define AFX_GFXCONTEXT_H__B59609D3_D6F8_4C85_AF86_EE3E0ADE39B7__INCLUDED_

#if _MSC_VER > 1000
#pragma once
#endif // _MSC_VER > 1000

#include <d3dx.h>
#include "CritSect.h"

// This class basically provides an extra level of security for our
// multithreaded code. Threads can Grab the GfxContext to prevent
// other threads from changing/releasing any of the pointers while it is
// running.

// It is based on CCritSect for Lock() and Unlock()
class CGfxContext : public CCritSect
{
public:
	CGfxContext();
	virtual ~CGfxContext();

	BOOL Ready() { return m_bReady; }

	void SetReady(BOOL bReady) { m_bReady = bReady; }

	void Cleanup()
	{
		SAFE_RELEASE(m_pDD);
		SAFE_RELEASE(m_pD3DDev);
		SAFE_RELEASE(m_pD3DX);
		m_bReady = FALSE;
	}

	ID3DXContext * GetD3DX()
	{	
		// Assert we're locked
		return m_pD3DX;
	}
	LPDIRECTDRAW7 GetDD()
	{
		// Assert we're locked
		return m_pDD;
	}

	LPDIRECT3DDEVICE7 GetD3DDev()
	{
		// Assert we're locked
		return m_pD3DDev;
	}

	void Clear(DWORD dwFlags)
	{
		Lock();
		if (m_pD3DX != NULL)
			m_pD3DX->Clear(dwFlags);
		Unlock();
	}

	HRESULT UpdateFrame(DWORD dwFlags)
	{
		HRESULT hr;
		
		Lock();
		if (m_pD3DX != NULL)
			hr = m_pD3DX->UpdateFrame( dwFlags );
		else
			hr = E_FAIL;
		Unlock();

		return hr;
	}

	HRESULT TestCooperativeLevel()
	{
		HRESULT hr;

		Lock();
		if (m_pDD != NULL)
			hr = m_pDD->TestCooperativeLevel();
		else
			hr = E_FAIL;
		Unlock();

		return hr;
	}

	HRESULT RestoreAllSurfaces()
	{
		HRESULT hr;

		Lock();
		if (m_pDD != NULL)
			hr = m_pDD->RestoreAllSurfaces();
		else
			hr = E_FAIL;
		Unlock();

		return hr;
	}

	HRESULT SetD3DX(ID3DXContext * pD3DX)
	{
		// Assert locked!
		// Assert pointers are currently null!

		m_pD3DX = pD3DX;

		m_pD3DDev = m_pD3DX->GetD3DDevice();
		if( m_pD3DDev == NULL )
			return E_FAIL;

		m_pDD = m_pD3DX->GetDD();
		if( m_pDD == NULL )
			return E_FAIL;

		Clear(D3DCLEAR_TARGET|D3DCLEAR_ZBUFFER);

	    m_bReady = TRUE;

		return S_OK;
	}

protected:

	BOOL m_bReady;
	
	LPDIRECT3DDEVICE7 m_pD3DDev;
	ID3DXContext * m_pD3DX;
	LPDIRECTDRAW7 m_pDD;


};

#endif // !defined(AFX_GFXCONTEXT_H__B59609D3_D6F8_4C85_AF86_EE3E0ADE39B7__INCLUDED_)
