/*
Copyright (C) 2001 StrmnNrmn

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

*/

// Takes care of various DirectSound issues, such as initialisation, playing
//  sounds and so on

#include "stdafx.h"

#include <mmreg.h>		// WAVEFORMATEX needs defining 
#include <d3d.h>
#include <dsound.h>

#include "Debug.h"
#include "CPU.h"

#include "DSoundHandler.h"

#define DSBUFFER_SIZE	262144			// The maximum length of sample we can play (maybe should * 2)

static LPDIRECTSOUND           g_lpDS = NULL;
static LPDIRECTSOUNDBUFFER     g_lpDSBuffer = NULL;
static LPDIRECTSOUNDNOTIFY		g_lpDSNotify = NULL;

struct SoundInfo {
	WORD *pSrc;
	DWORD dwLength;
	// Other info, e.g. DACRATE, BITRATE
	BOOL bInUse;
};

static SoundInfo	g_SoundBuffers[2];

BOOL DSound_Initialise(void) {

    DSCAPS dscaps;
	HRESULT dsRetVal;

	g_SoundBuffers[0].bInUse = FALSE;
	g_SoundBuffers[1].bInUse = FALSE;
	
	dsRetVal = DirectSoundCreate( NULL, &g_lpDS, NULL );
	if (FAILED(dsRetVal)) {
		DPF(DEBUG_DSOUND,"WARN: DirectSoundCreate Failed");
		goto generic_error;
	}

    ZeroMemory( &dscaps, sizeof(dscaps));
    dscaps.dwSize = sizeof(dscaps);

    if (FAILED( dsRetVal = g_lpDS->GetCaps(&dscaps))) {
		DPF(DEBUG_DSOUND,"WARN: DirectSound::GetCaps failed");
		goto generic_error;
	}

    if (dscaps.dwFlags & DSCAPS_EMULDRIVER) {   
		DPF(DEBUG_DSOUND,"INFO: DirectSound: Card is emulated.");
		// Don't fail?
    }

    dsRetVal = g_lpDS->SetCooperativeLevel(g_hMainWindow, DSSCL_PRIORITY);
    if (FAILED(dsRetVal)) {
		DPF(DEBUG_DSOUND,"WARN: DirectSound::SetCooperativeLevel failed.");
		goto generic_error;
	}


	DPF(DEBUG_DSOUND,"INFO: DirectSound: Initialisation Ok.");

	return TRUE;
generic_error:

	SAFE_RELEASE(g_lpDSNotify);
	SAFE_RELEASE(g_lpDSBuffer);
	SAFE_RELEASE(g_lpDS);
	return FALSE;
}

void DSound_Finalise(void) {

	SAFE_RELEASE(g_lpDSNotify);
	// Check if a buffer already exists
	if ( g_lpDSBuffer ) {
		g_lpDSBuffer->Stop();
		g_lpDSBuffer->Release();
		g_lpDSBuffer = NULL;
	}

	SAFE_RELEASE(g_lpDS);


}

BOOL DSound_IsFIFOFull(void) {
	return FALSE;
	return (g_SoundBuffers[0].bInUse && g_SoundBuffers[1].bInUse) ? TRUE:FALSE;
	//return FALSE;
}

BOOL DSound_AddSound(WORD *pSamples, DWORD dwLength) {

	Memory_MI_SetRegisterBits(MI_INTR_REG, MI_INTR_AI);
	AddCPUJob(CPU_CHECK_INTERRUPTS);

	return TRUE;

	if (dwLength < 2*10) return FALSE;

	if (g_SoundBuffers[0].bInUse) {
		if (g_SoundBuffers[1].bInUse) {
			// Both buffers in use - we can't play it
			return FALSE;
		}
		// Buffer 0 playing, buffer 1 not
		g_SoundBuffers[1].pSrc = pSamples;
		g_SoundBuffers[1].dwLength = dwLength;
		g_SoundBuffers[1].bInUse = TRUE;
		return TRUE;
	} else {
		// Sound buffer 0 is free - add and start playing
		g_SoundBuffers[0].pSrc = pSamples;
		g_SoundBuffers[0].dwLength = dwLength;
		g_SoundBuffers[0].bInUse = TRUE;

		DSound_PlaySound(pSamples, dwLength);
	}
	return TRUE;
}

DWORD DSound_GetLengthLeftToPlay(void) {
	return 0;

	if (g_SoundBuffers[0].bInUse) {
		if (g_lpDSBuffer) {
			DWORD dwPos;
			g_lpDSBuffer->GetCurrentPosition(&dwPos, NULL);
			if (dwPos < g_SoundBuffers[0].dwLength) {
				return g_SoundBuffers[0].dwLength - dwPos;
			} else {
				return 0;
			}
		} else {
			return 0;
		}
	} else {
		return 0;
	}

}
void DSound_NotifyBufferFinished(void) {
	// We're notified when our buffer has finished playing.
	// We need to check is buffer 1 has any contents, and if so, start playing that
	// Push through FIFO
	g_SoundBuffers[0].pSrc		= g_SoundBuffers[1].pSrc;
	g_SoundBuffers[0].dwLength	= g_SoundBuffers[1].dwLength;
	g_SoundBuffers[0].bInUse	= g_SoundBuffers[1].bInUse;
	g_SoundBuffers[1].bInUse = FALSE;

	if (g_lpDSBuffer)
		g_lpDSBuffer->Stop();
	if (g_SoundBuffers[0].bInUse)
	{
		DSound_PlaySound(g_SoundBuffers[0].pSrc, g_SoundBuffers[0].dwLength);

		// Set length to new length
		Memory_AI_SetRegister(AI_LEN_REG, g_SoundBuffers[0].dwLength);

	} else {
		Memory_AI_SetRegister(AI_LEN_REG, 0);
		// Set length to 0
	}

	// Generate AI interrupt here?
	//Memory_MI_SetRegisterBits(MI_INTR_REG, MI_INTR_AI);
	//AddCPUJob(CPU_CHECK_INTERRUPTS);
}

BOOL DSound_PlaySound(WORD *pSamples, DWORD dwLength) {

	if (pSamples == NULL) return FALSE;
	if (dwLength < 4) return FALSE;
	if (g_lpDS == NULL) return FALSE;
	//if (g_lpDSBuffer == NULL) return FALSE;
	//if (g_lpDSNotify == NULL) return FALSE;
	if (dwLength > 200) dwLength = 200;

	SAFE_RELEASE(g_lpDSBuffer);
	SAFE_RELEASE(g_lpDSNotify);
		
	/*DWORD dwStatus;
	if (FAILED(g_lpDSBuffer->GetStatus(&dwStatus))) {
		DPF(DEBUG_DSOUND, "WARN: DirectSound: Couldn't get current buffer's status.");
		return FALSE;
	}
	if ((dwStatus & DSBSTATUS_PLAYING)) {
		// It's still playing
		DPF(DEBUG_DSOUND, "WARN: DirectSound: Current buffer is still playing.");
		return FALSE;
	}*/

	////// Set up static buffer
	DSBUFFERDESC	dsbdesc;
	WAVEFORMATEX	wfx;

	wfx.wFormatTag = WAVE_FORMAT_PCM;
	wfx.nChannels = 2;
	wfx.nSamplesPerSec = 22050;
	wfx.wBitsPerSample = 16;
	wfx.nBlockAlign = (wfx.nChannels*wfx.wBitsPerSample)/8;
	wfx.nAvgBytesPerSec = wfx.nSamplesPerSec*wfx.nBlockAlign;

	wfx.cbSize = 0;	// Length of extended info (of which there is none)

	// We've got this far, so we can create a new buffer.
	ZeroMemory(&dsbdesc, sizeof(dsbdesc));
	dsbdesc.dwSize = sizeof(dsbdesc);

	dsbdesc.dwFlags = DSBCAPS_LOCSOFTWARE|DSBCAPS_CTRLPOSITIONNOTIFY;
	dsbdesc.dwBufferBytes = dwLength;
	dsbdesc.lpwfxFormat = &wfx;

	if (FAILED(g_lpDS->CreateSoundBuffer(&dsbdesc, &g_lpDSBuffer, NULL))) {
		DPF(DEBUG_DSOUND, "WARN: DirectSound: Couldn't get create a new buffer");
		return FALSE;
	}

	// Set up notification

	if (FAILED(g_lpDSBuffer->QueryInterface(IID_IDirectSoundNotify, (LPVOID *)&g_lpDSNotify))) {
		DPF(DEBUG_DSOUND, "WARN: DirectSound: Couldn't query IDirectSoundNotify from buffer");
		return FALSE;
	}

	LPVOID lpvAudio1;//, lpvAudio2;
	DWORD  dwBytes1;//, dwBytes2;
		//g_lpDSStreamBuffer->Restore();
	
	HRESULT hr;
	int count = 0;
	// Copy data to buffer
	while (FAILED(hr = g_lpDSBuffer->Lock(
		0,				// Start Offset	(ignored, as we specif from the write cursor)
		dwLength,		// Size of lock
		&lpvAudio1,		// Address of lock start
		&dwBytes1,		// Number of bytes locked
		NULL, //&lpvAudio2,		// Address of wraparound buffer
		NULL, //&dwBytes2,		// Number of wraparound bytes
		DSBLOCK_ENTIREBUFFER )))//DSBLOCK_FROMWRITECURSOR)))
	{
		switch (hr) {
			case DSERR_BUFFERLOST:
				DPF(DEBUG_DSOUND, "WARN: DirectSound: Couldn't lock the buffer - DSERR_BUFFERLOST. Trying again");
				g_lpDSBuffer->Restore();
				break;
			case DSERR_INVALIDCALL:
				DPF(DEBUG_DSOUND, "WARN: DirectSound: Couldn't lock the buffer - DSERR_INVALIDCALL");
				return FALSE;
			case DSERR_INVALIDPARAM:
				DPF(DEBUG_DSOUND, "WARN: DirectSound: Couldn't lock the buffer - DSERR_INVALIDPARAM");
				return FALSE;
			case DSERR_PRIOLEVELNEEDED:
				DPF(DEBUG_DSOUND, "WARN: DirectSound: Couldn't lock the buffer - DSERR_PRIOLEVELNEEDED");
				return FALSE;
			default:
				DPF(DEBUG_DSOUND, "WARN: DirectSound: Couldn't lock the buffer - Unknown Reason");
				return FALSE;
		}
		if (count++ > 5) return FALSE; // Give up trying

	}

	// Copy dwBytes1 bytes to lpvAudio1
	// Copy dwBytes2 bytes to lpvAudio2
	if (lpvAudio1 && dwBytes1) {	// A bit paranoid to check lpvAudio1?
		//memcpy((BYTE *)lpvAudio1, (BYTE *)pSamples + 0, dwBytes1);
		for (DWORD i = 0; i < dwBytes1/2; i++) {

			WORD w = pSamples[i];
			short s;
			if (w & 0x4000) s = w |  0x8000; //-(short)(0x8000-w);
			else            s = w & ~0x8000;
			((WORD *)lpvAudio1)[i] = s;		
		
		}
	}
	//if (lpvAudio2 && dwBytes2) {	// lpvAudio2 may be NULL if there is no wraparound
	//	memcpy((BYTE *)lpvAudio2, (BYTE *)pSamples + dwBytes1, dwBytes2);
	//}

	g_lpDSBuffer->Unlock(lpvAudio1, dwBytes1, NULL, 0);//lpvAudio2, dwBytes2);

	// Set up notification so we know when it's finished
	//DWORD dwWritePos, dwEndPos;
	//g_lpDSBuffer->GetCurrentPosition(NULL, &dwWritePos);

	//dwEndPos = (dwWritePos + dwLength) % DSBUFFER_SIZE;

	DSBPOSITIONNOTIFY dsbpn;
	dsbpn.dwOffset = DSBPN_OFFSETSTOP;//dwEndPos;
	dsbpn.hEventNotify = g_hEndBufferEvent;
	if (FAILED(hr = g_lpDSNotify->SetNotificationPositions(1, &dsbpn))) {
		DBGConsole_Msg(0, "SetNotificationPosition failed");
		// Don't play?
	}


	g_lpDSBuffer->SetCurrentPosition(0);
	g_lpDSBuffer->Play(0,0,0);		// Don't loop

	return TRUE;

}


BOOL DSound_PlaySoundNoNotify(WORD *pSamples, DWORD dwLength) {

	if (dwLength < 4) return FALSE;
	if (g_lpDS == NULL) return FALSE;
	//if (g_lpDSBuffer == NULL) return FALSE;
	//if (g_lpDSNotify == NULL) return FALSE;
	if (dwLength > 200) dwLength = 200;

	SAFE_RELEASE(g_lpDSBuffer);
	SAFE_RELEASE(g_lpDSNotify);

	////// Set up static buffer
	DSBUFFERDESC	dsbdesc;
	WAVEFORMATEX	wfx;

	wfx.wFormatTag = WAVE_FORMAT_PCM;
	wfx.nChannels = 2;
	wfx.nSamplesPerSec = 22050;
	wfx.wBitsPerSample = 16;
	wfx.nBlockAlign = (wfx.nChannels*wfx.wBitsPerSample)/8;
	wfx.nAvgBytesPerSec = wfx.nSamplesPerSec*wfx.nBlockAlign;

	wfx.cbSize = 0;	// Length of extended info (of which there is none)

	// We've got this far, so we can create a new buffer.
	ZeroMemory(&dsbdesc, sizeof(dsbdesc));
	dsbdesc.dwSize = sizeof(dsbdesc);

	dsbdesc.dwFlags = DSBCAPS_LOCSOFTWARE|DSBCAPS_CTRLPOSITIONNOTIFY;
	dsbdesc.dwBufferBytes = dwLength;
	dsbdesc.lpwfxFormat = &wfx;

	if (FAILED(g_lpDS->CreateSoundBuffer(&dsbdesc, &g_lpDSBuffer, NULL))) {
		DPF(DEBUG_DSOUND, "WARN: DirectSound: Couldn't get create a new buffer");
		return FALSE;
	}

	// Set up notification

	LPVOID lpvAudio1;//, lpvAudio2;
	DWORD  dwBytes1;//, dwBytes2;
		//g_lpDSStreamBuffer->Restore();
	
	HRESULT hr;
	int count = 0;
	// Copy data to buffer
	while (FAILED(hr = g_lpDSBuffer->Lock(
		0,				// Start Offset	(ignored, as we specif from the write cursor)
		dwLength,		// Size of lock
		&lpvAudio1,		// Address of lock start
		&dwBytes1,		// Number of bytes locked
		NULL, //&lpvAudio2,		// Address of wraparound buffer
		NULL, //&dwBytes2,		// Number of wraparound bytes
		DSBLOCK_ENTIREBUFFER )))//DSBLOCK_FROMWRITECURSOR)))
	{
		switch (hr) {
			case DSERR_BUFFERLOST:
				DPF(DEBUG_DSOUND, "WARN: DirectSound: Couldn't lock the buffer - DSERR_BUFFERLOST. Trying again");
				g_lpDSBuffer->Restore();
				break;
			case DSERR_INVALIDCALL:
				DPF(DEBUG_DSOUND, "WARN: DirectSound: Couldn't lock the buffer - DSERR_INVALIDCALL");
				return FALSE;
			case DSERR_INVALIDPARAM:
				DPF(DEBUG_DSOUND, "WARN: DirectSound: Couldn't lock the buffer - DSERR_INVALIDPARAM");
				return FALSE;
			case DSERR_PRIOLEVELNEEDED:
				DPF(DEBUG_DSOUND, "WARN: DirectSound: Couldn't lock the buffer - DSERR_PRIOLEVELNEEDED");
				return FALSE;
			default:
				DPF(DEBUG_DSOUND, "WARN: DirectSound: Couldn't lock the buffer - Unknown Reason");
				return FALSE;
		}
		if (count++ > 5) return FALSE; // Give up trying

	}

	// Copy dwBytes1 bytes to lpvAudio1
	// Copy dwBytes2 bytes to lpvAudio2
	if (lpvAudio1 && dwBytes1) {	// A bit paranoid to check lpvAudio1?
		//memcpy((BYTE *)lpvAudio1, (BYTE *)pSamples + 0, dwBytes1);
		for (DWORD i = 0; i < dwBytes1/2; i++) {

			WORD w = pSamples[i];
			short s = w;
			//if (w & 0x4000) s = w |  0x8000; //-(short)(0x8000-w);
			//else            s = w & ~0x8000;
			((WORD *)lpvAudio1)[i] = s;		
		
		}
	}
	g_lpDSBuffer->Unlock(lpvAudio1, dwBytes1, NULL, 0);//lpvAudio2, dwBytes2);
	g_lpDSBuffer->SetCurrentPosition(0);
	g_lpDSBuffer->Play(0,0,0);		// Don't loop

	return TRUE;

}