#ifndef __DINPUTHANDLER_H__
#define __DINPUTHANDLER_H__

#include "ultra_os.h"

enum
{
	INPUT_ID_STICK_X = 0,
	INPUT_ID_STICK_Y,
	INPUT_ID_DPAD_UP,
	INPUT_ID_DPAD_DOWN,
	INPUT_ID_DPAD_LEFT,
	INPUT_ID_DPAD_RIGHT,
	INPUT_ID_A_BUTTON,
	INPUT_ID_B_BUTTON,
	INPUT_ID_Z_TRIG,
	INPUT_ID_L_TRIG,
	INPUT_ID_R_TRIG,
	INPUT_ID_C_UP,
	INPUT_ID_C_DOWN,
	INPUT_ID_C_LEFT,
	INPUT_ID_C_RIGHT,
	INPUT_ID_START,

	NUM_INPUT_IDS
};

typedef struct
{
	TCHAR szName[50+1];
	WORD button;		// Button - 0 for stick values
	BOOL bIsAxis;		// 
} N64Button;

// This structure specifies a device for each input field.
// If g_N64Buttons[i].bIsButton is true, only dwOfsA is used
// If g_N64Buttons[i].bIsButton is false, both dwOfsA and dwOfsB are used
//    (unles the user has selected an axis on the joystick for the
//     input, in which case dwOfsA is used)
typedef struct
{
	DWORD dwDevice;		// Indexes g_CurrInputConfig.guidDevices. 0 is always the keyboard
	BOOL bIsAxis;		// TRUE if dwOfsA is axis (in which case dwOfsB is ignored)

	DWORD dwOfsA;
	DWORD dwOfsB;
} ButtonAssignment;

typedef struct
{
	DWORD dwDevice;
	DWORD dwOfs;

	BOOL bIsAxis;			// Used to indicate ofs points to byte value

	TCHAR szName[MAX_PATH+1];	// Id

	// For caller to use
	DWORD dwData;
	DWORD dwData2;
} ControlID;

typedef struct
{
	std::vector< ControlID > controls;
	
} ControlList;

typedef struct
{
	TCHAR szFileName[MAX_PATH+1];

	std::vector< GUID > guidDevices;
	BOOL bConnected[4];
	ButtonAssignment buttons[4][NUM_INPUT_IDS];


} InputConfiguration;

extern N64Button g_N64Buttons[NUM_INPUT_IDS];
extern InputConfiguration g_CurrInputConfig;


HRESULT Input_Initialise( HWND hWnd );
void Input_Finalise();
HRESULT Input_GetState( OSContPad pPad[4] );

void Input_Unaquire();

HRESULT Input_GenerateAllObjects(InputConfiguration & ic, ControlList * pCL);


HRESULT Input_CheckKeyboard( HWND hWnd );

void Input_ResetConfig(InputConfiguration & ic);

void Input_AddMissingDevices(InputConfiguration & ic);
void Input_LoadAllInputConfigs();
void Input_SaveAllInputConfigs();


void Input_NewConfig(InputConfiguration & ic);
HRESULT Input_LoadConfig(InputConfiguration & ic);
HRESULT Input_SaveConfig(LONG iConfig);

void Input_RenameConfig(InputConfiguration & ic, LPCTSTR szNewName);
LONG Input_AddConfig(InputConfiguration & ic);
LONG Input_GetNumConfigs();
BOOL Input_GetConfig(LONG iConfig, InputConfiguration & ic);
void Input_SetConfig(LONG iConfig, InputConfiguration & ic);


#endif // __DINPUTHANDLER_H__