/*
Copyright (C) 2001 StrmnNrmn

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

*/

#include "stdafx.h"

#include <d3d.h>

#include "ultra_mbi.h"

#include "D3DRender.h"
#include "DBGConsole.h"
#include "RDP_GFX.h"

#include "Memory.h"			// We access the memory buffers


//static BOOL g_bHiliteRGBAHack = FALSE;

static const char * sc_colcombtypes32[32] =
{
	"Combined    ", "Texel0      ",
	"Texel1      ", "Primitive   ", 
	"Shade       ", "Environment ",
	"1           ", "CombAlp     ",
	"Texel0_Alpha", "Texel1_Alpha",
	"Prim_Alpha  ", "Shade_Alpha ",
	"Env_Alpha   ", "LOD_Fraction",
	"PrimLODFrac ", "K5          ",
	"?           ", "?           ",
	"?           ", "?           ",
	"?           ", "?           ",
	"?           ", "?           ",
	"?           ", "?           ",
	"?           ", "?           ",
	"?           ", "?           ",
	"?           ",	"0           "
};
static const char *sc_colcombtypes16[16] =
{
	"Combined    ", "Texel0      ",
	"Texel1      ", "Prim        ", 
	"Shade       ", "Environment ",
	"1           ", "CombAlp     ",
	"Texel0_Alpha", "Texel1_Alpha",
	"Prim_Alp    ", "Shade_Alpha ",
	"Env_Alpha   ", "LOD_Fraction",
	"PrimLOD_Frac", "0           "
};
static const char *sc_colcombtypes8[8] =
{
	"Combined    ", "Texel0      ",
	"Texel1      ", "Primitive   ", 
	"Shade       ", "Environment ",
	"1           ", "0           ",
};

class CombineStage 
{
public:
	DWORD dwColorOp, dwColorArg1, dwColorArg2;
	DWORD dwAlphaOp, dwAlphaArg1, dwAlphaArg2;

	BOOL operator!=(const CombineStage & cs) const { return !(operator==(cs)); }
	BOOL operator==(const CombineStage & cs) const 
	{
		return (
			cs.dwAlphaArg1 == dwAlphaArg1 &&
			cs.dwAlphaArg2 == dwAlphaArg2 &&
			cs.dwAlphaOp == dwAlphaOp &&
			cs.dwColorArg1 == dwColorArg1 &&
			cs.dwColorArg2 == dwColorArg2 &&
			cs.dwColorOp == dwColorOp);

	}

};	


enum MuxVal
{
	MUX_0 = 0,
	MUX_1,
	MUX_COMBINED,
	MUX_TEXEL0,
	MUX_TEXEL1,
	MUX_PRIM,
	MUX_SHADE,
	MUX_ENV,
	MUX_COMBALPHA,
	MUX_T0_ALPHA,
	MUX_T1_ALPHA,
	MUX_PRIM_ALPHA,
	MUX_SHADE_ALPHA,
	MUX_ENV_ALPHA,
	MUX_LODFRAC,
	MUX_PRIMLODFRAC,
	MUX_UNK
};

class SetCombineInfo
{
public:
	u64 mux;
	LONG nStages;

	BOOL  bAlphaEnabled;

	// Added by Orkin - tells InitBlendMode() what to set the texture factor to
	MuxVal TFactor;

	CombineStage stages[8];

	BOOL operator!=(const SetCombineInfo & sci) const { return !(operator==(sci)); }
	BOOL operator==(const SetCombineInfo & sci) const 
	{
		LONG i;

		if (sci.nStages != nStages)
			return FALSE;
		if (sci.bAlphaEnabled != bAlphaEnabled)
			return FALSE;

		for (i = 0; i < nStages; i++)
		{
			if (sci.stages[i] != stages[i])
				return FALSE;
		}
		return TRUE;
	}


};



static std::vector<u64> g_UnkMux;
static std::vector<u64> g_FoundMux;
static std::vector<u64> g_MismatchedMux;
static std::vector<SetCombineInfo> g_GeneratedMux;


static const sc_MuxValToD3D[] = 
{
	D3DTA_DIFFUSE,		// 0
	D3DTA_DIFFUSE,		// 1
	D3DTA_CURRENT,		// Combined
	D3DTA_TEXTURE,		// T0
	D3DTA_TEXTURE,		// T1
	D3DTA_TFACTOR,		// Prim
	D3DTA_DIFFUSE,		// Shade
	D3DTA_TFACTOR,		// Env
	D3DTA_DIFFUSE,		// Combined Alpha
	D3DTA_TEXTURE,		// T0 Alpha
	D3DTA_TEXTURE,		// T1 Alpha
	D3DTA_DIFFUSE,		// Prim Alpha -- Was TFACTOR
	D3DTA_DIFFUSE,		// Shade Alpha
	D3DTA_TFACTOR,		// Env Alpha 
	D3DTA_DIFFUSE,		// LodFrac
	D3DTA_DIFFUSE,		// PrimLodFrac
	D3DTA_DIFFUSE,		// Unk
};

static const MuxVal sc_Mux32[32] = 
{
	MUX_COMBINED, MUX_TEXEL0,   MUX_TEXEL1, MUX_PRIM,
	MUX_SHADE,    MUX_ENV,      MUX_1,      MUX_COMBALPHA,
	MUX_T0_ALPHA, MUX_T1_ALPHA, MUX_PRIM_ALPHA, MUX_SHADE_ALPHA,
	MUX_ENV_ALPHA, MUX_LODFRAC, MUX_PRIMLODFRAC, MUX_UNK,		// Actually k5
	MUX_UNK, MUX_UNK, MUX_UNK, MUX_UNK,
	MUX_UNK, MUX_UNK, MUX_UNK, MUX_UNK,
	MUX_UNK, MUX_UNK, MUX_UNK, MUX_UNK,
	MUX_UNK, MUX_UNK, MUX_UNK, MUX_0
};

static const MuxVal sc_Mux16[16] = 
{
	MUX_COMBINED, MUX_TEXEL0,   MUX_TEXEL1, MUX_PRIM,
	MUX_SHADE,    MUX_ENV,      MUX_1,      MUX_COMBALPHA,
	MUX_T0_ALPHA, MUX_T1_ALPHA, MUX_PRIM_ALPHA, MUX_SHADE_ALPHA,
	MUX_ENV_ALPHA, MUX_LODFRAC, MUX_PRIMLODFRAC, MUX_0	
};
static const MuxVal sc_Mux8[8] = 
{
	MUX_COMBINED, MUX_TEXEL0,   MUX_TEXEL1, MUX_PRIM,
	MUX_SHADE,    MUX_ENV,      MUX_1,      MUX_0
};

static const char * sc_szMux[] =
{
	"0", "1",
	"Combined", "Texel0", 
	"Texel1", "Primitive",
	"Shade", "Env",
	"CombAlpha", "T0 Alpha",
	"T1 Alpha", "Prim Alpha",
	"Shade Alpha", "Env Alpha",
	"LOD Frac", "Prim LOD Frac",
	"Unk"
};
enum MuxType
{
	MUX_CONST,
	MUX_MODULATE,
	MUX_MODULATE_ADD,
	MUX_ADD,
	MUX_SUB_MODULATE,
	MUX_SUB_MODULATE_ADD
};

static void SimplifyMux(DWORD & a, DWORD & b, DWORD & c, DWORD & d)
{
	// Hack - (T1-T0)*M + C = C 
	if ((a == MUX_TEXEL0 && b == MUX_TEXEL1) ||
		(a == MUX_TEXEL1 && b == MUX_TEXEL0))
	{
		a = MUX_0;
		b = MUX_0;
		c = MUX_0;
	}

	// Hack 1-0 * M + 0 = M 
	if (a == MUX_1 && b == MUX_0 && d == MUX_0)
	{
		a = MUX_0;
		b = MUX_0;
		d = c;	// Set d to the constant
		c = MUX_0;
	}
}

static MuxType GetMuxType(LPCTSTR szName, DWORD a, DWORD b, DWORD c, DWORD d)
{
	MuxType mt;

	/////////////////////////////////////////
	//  = (a - b) * c + d
	if (c == MUX_0)
	{
		DL_PF("%s: %s", szName, sc_szMux[d]);
		mt = MUX_CONST;
	}
	else if (b == MUX_0)
	{
		if (d == MUX_0)
		{
			DL_PF("%s: %s * %s", szName, sc_szMux[a], sc_szMux[c]);
			mt = MUX_MODULATE;
		}
		else if (a == MUX_1)	// (1-0)*M + C = M + C
		{
			DL_PF("%s: %s + %s", szName, sc_szMux[c], sc_szMux[d]);
			mt = MUX_ADD;
		}
		else
		{
			DL_PF("%s: (%s * %s) + %s", szName, sc_szMux[a], sc_szMux[c], sc_szMux[d]);
			mt = MUX_MODULATE_ADD;
		}
	}
	else
	{
		if (d == MUX_0)
		{
			DL_PF("%s: (%s - %s) * %s", szName, sc_szMux[a], sc_szMux[b], sc_szMux[c]);
			mt = MUX_SUB_MODULATE;
		}
		else
		{
			DL_PF("%s: ((%s - %s) * %s) + %s", szName, sc_szMux[a], sc_szMux[b],
				sc_szMux[c], sc_szMux[d]);

			mt = MUX_SUB_MODULATE_ADD;
		}
	}

	return mt;

}



static BOOL AssessMux(u64 mux, SetCombineInfo & sci)
{
	BOOL bHandled;
	MuxType mtc0;
	MuxType mta0;
	MuxType mtc1;
	MuxType mta1;
	LONG nNumCycles;
	LONG nNumColorStages;
	LONG nNumAlphaStages;

	DWORD aRGB0  = sc_Mux16[(mux>>52)&0x0F];	// c1 c1		// a0
	DWORD bRGB0  = sc_Mux16[(mux>>28)&0x0F];	// c1 c2		// b0
	DWORD cRGB0  = sc_Mux32[(mux>>47)&0x1F];	// c1 c3		// c0
	DWORD dRGB0  = sc_Mux8[(mux>>15)&0x07];	// c1 c4		// d0

	DWORD aA0    = sc_Mux8[(mux>>44)&0x07];	// c1 a1		// Aa0
	DWORD bA0    = sc_Mux8[(mux>>12)&0x07];	// c1 a2		// Ab0
	DWORD cA0    = sc_Mux8[(mux>>41)&0x07];	// c1 a3		// Ac0
	DWORD dA0    = sc_Mux8[(mux>>9 )&0x07];	// c1 a4		// Ad0

	DWORD aRGB1  = sc_Mux16[(mux>>37)&0x0F];	// c2 c1		// a1
	DWORD bRGB1  = sc_Mux16[(mux>>24)&0x0F];	// c2 c2		// b1
	DWORD cRGB1  = sc_Mux32[(mux>>32)&0x1F];	// c2 c3		// c1
	DWORD dRGB1  = sc_Mux8[(mux>>6  )&0x07];	// c2 c4		// d1
	
	DWORD aA1    = sc_Mux8[(mux>>21)&0x07];	// c2 a1		// Aa1
	DWORD bA1    = sc_Mux8[(mux>>3 )&0x07];	// c2 a2		// Ab1
	DWORD cA1    = sc_Mux8[(mux>>18)&0x07];	// c2 a3		// Ac1
	DWORD dA1    = sc_Mux8[(mux    )&0x07];	// c2 a4		// Ad1

	sci.mux = mux;

	// Types:
	// CONST
	// A * B
	// A * B + CONST
	// (A - B) * C
	// ((A - B) * C) + CONST

	SimplifyMux(aRGB0, bRGB0, cRGB0, dRGB0);
	SimplifyMux(aA0, bA0, cA0, dA0);

	SimplifyMux(aRGB1, bRGB1, cRGB1, dRGB1);
	SimplifyMux(aA1, bA1, cA1, dA1);

	mtc0 = GetMuxType("RGB0", aRGB0, bRGB0, cRGB0, dRGB0);
	mta0 = GetMuxType("A0", aA0, bA0, cA0, dA0);

	mtc1 = GetMuxType("RGB1", aRGB1, bRGB1, cRGB1, dRGB1);
	mta1 = GetMuxType("A1", aA1, bA1, cA1, dA1);

	bHandled = TRUE;

	nNumCycles = 2;

	if (mtc1 == MUX_CONST && dRGB1 == MUX_COMBINED)
	{
		nNumCycles = 1;
	}

	if (aRGB0 == aRGB1 &&
		bRGB0 == bRGB1 &&
		cRGB0 == cRGB1 &&
		dRGB0 == dRGB1)
	{
		nNumCycles = 1;
	}

	DL_PF("%d cycle mode", nNumCycles);

	if (nNumCycles > 1)
		bHandled = FALSE;


	switch (mtc0)
	{
	case MUX_CONST:
		// d
		nNumColorStages = 1;
		sci.stages[0].dwColorOp = D3DTOP_SELECTARG1;
		sci.stages[0].dwColorArg1 = sc_MuxValToD3D[dRGB0];
		sci.stages[0].dwColorArg2 = ~0;		// No change
		break;
	case MUX_MODULATE:
		// a * c
		nNumColorStages = 1;
		sci.stages[0].dwColorOp = D3DTOP_MODULATE;
		if (sc_MuxValToD3D[aRGB0] == D3DTA_TEXTURE)
		{
			sci.stages[0].dwColorArg1 = sc_MuxValToD3D[aRGB0];
			sci.stages[0].dwColorArg2 = sc_MuxValToD3D[cRGB0];
		}
		else
		{
			sci.stages[0].dwColorArg2 = sc_MuxValToD3D[aRGB0];
			sci.stages[0].dwColorArg1 = sc_MuxValToD3D[cRGB0];
		}
		break;
	case MUX_ADD:
		// c + d
		nNumColorStages = 1;
		sci.stages[0].dwColorOp = D3DTOP_ADD;
		if (sc_MuxValToD3D[cRGB0] == D3DTA_TEXTURE)
		{
			sci.stages[0].dwColorArg1 = sc_MuxValToD3D[cRGB0];
			sci.stages[0].dwColorArg2 = sc_MuxValToD3D[dRGB0];
		}
		else
		{
			sci.stages[0].dwColorArg2 = sc_MuxValToD3D[cRGB0];
			sci.stages[0].dwColorArg1 = sc_MuxValToD3D[dRGB0];
		}
		break;
	default:
		nNumColorStages = 0;
		bHandled = FALSE;
		break;
	}

	// Do alpha
	sci.bAlphaEnabled = TRUE;

	switch (mta0)
	{
	case MUX_CONST:
		// d
		if (dA0 == MUX_1)
		{
			sci.bAlphaEnabled = FALSE;
			nNumAlphaStages = 1;
			sci.stages[0].dwAlphaOp = D3DTOP_MODULATE;		// Or disable?
			sci.stages[0].dwAlphaArg2 = ~0;
			sci.stages[0].dwAlphaArg1 = ~0;
		}
		else
		{
			nNumAlphaStages = 1;
			sci.stages[0].dwAlphaOp = D3DTOP_SELECTARG1;
			sci.stages[0].dwAlphaArg1 = sc_MuxValToD3D[dA0];
			sci.stages[0].dwAlphaArg2 = ~0;		// No change
		}
		break;
	case MUX_MODULATE:
		// a * c
		nNumAlphaStages = 1;
		sci.stages[0].dwAlphaOp = D3DTOP_MODULATE;
		if ( sc_MuxValToD3D[aA0] == D3DTA_TEXTURE)
		{
			sci.stages[0].dwAlphaArg1 = sc_MuxValToD3D[aA0];
			sci.stages[0].dwAlphaArg2 = sc_MuxValToD3D[cA0];
		}
		else
		{
			sci.stages[0].dwAlphaArg2 = sc_MuxValToD3D[aA0];
			sci.stages[0].dwAlphaArg1 = sc_MuxValToD3D[cA0];
		}
		break;
	case MUX_ADD:
		// c + d
		nNumAlphaStages = 1;
		sci.stages[0].dwAlphaOp = D3DTOP_ADD;
		if (sc_MuxValToD3D[cA0] == D3DTA_TEXTURE)
		{
			sci.stages[0].dwAlphaArg1 = sc_MuxValToD3D[cA0];
			sci.stages[0].dwAlphaArg2 = sc_MuxValToD3D[dA0];
		}
		else
		{
			sci.stages[0].dwAlphaArg2 = sc_MuxValToD3D[cA0];
			sci.stages[0].dwAlphaArg1 = sc_MuxValToD3D[dA0];
		}
		break;
	default:
		nNumAlphaStages = 0;
		bHandled = FALSE;
		break;
	}

	if (nNumAlphaStages != nNumColorStages)
		bHandled = FALSE;

	sci.nStages = nNumColorStages;

	return bHandled;

}




/*
// Control
D3DTOP_DISABLE              = 1,      // disables stage
D3DTOP_SELECTARG1           = 2,      // the default
D3DTOP_SELECTARG2           = 3,

// Modulate
D3DTOP_MODULATE             = 4,      // multiply args together
D3DTOP_MODULATE2X           = 5,      // multiply and  1 bit
D3DTOP_MODULATE4X           = 6,      // multiply and  2 bits

// Add
D3DTOP_ADD                  =  7,   // add arguments together
D3DTOP_ADDSIGNED            =  8,   // add with -0.5 bias
D3DTOP_ADDSIGNED2X          =  9,   // as above but left  1 bit
D3DTOP_SUBTRACT             = 10,   // Arg1 - Arg2, with no saturation
D3DTOP_ADDSMOOTH            = 11,   // add 2 args, subtract product
                                    // Arg1 + Arg2 - Arg1*Arg2
                                    // = Arg1 + (1-Arg1)*Arg2


#define D3DTA_SELECTMASK        0x0000000f  // mask for arg selector
#define D3DTA_DIFFUSE           0x00000000  // select diffuse color (read only)
#define D3DTA_CURRENT           0x00000001  // select stage destination register (read/write)
#define D3DTA_TEXTURE           0x00000002  // select texture color (read only)
#define D3DTA_TFACTOR           0x00000003  // select RENDERSTATE_TEXTUREFACTOR (read only)
#define D3DTA_SPECULAR          0x00000004  // select specular color (read only)
#define D3DTA_TEMP              0x00000005  // select temporary register color (read/write)
#define D3DTA_COMPLEMENT        0x00000010  // take 1.0 - x (read modifier)
#define D3DTA_ALPHAREPLICATE    0x00000020  // replicate alpha to color components (read modifier)



*/


#define D3DTA_IGNORE ~0


#define SCENTRY(m, ca1, ca2, aa1, aa2) \
	{ m, 1, TRUE, MUX_0, {D3DTOP_MODULATE, D3DTA_##ca1, D3DTA_##ca2, \
				   D3DTOP_MODULATE, D3DTA_##aa1, D3DTA_##aa2} },

#define SCENTRY_NOALPHA(m, ca1, ca2 ) \
	{ m, 1, FALSE, MUX_0, {D3DTOP_MODULATE, D3DTA_##ca1, D3DTA_##ca2, \
					D3DTOP_MODULATE, D3DTA_IGNORE, D3DTA_IGNORE} },

#define SCENTRY_SELECTCOL1_NOALPHA(m, ca1 ) \
	{ m, 1, FALSE, MUX_0, {D3DTOP_SELECTARG1, D3DTA_##ca1, D3DTA_IGNORE, \
				    D3DTOP_MODULATE, D3DTA_IGNORE, D3DTA_IGNORE} },

	
#define SCENTRY_COLOP_SELECTALP(m, cop, ca1, ca2, aa1 ) \
	{ m, 1, TRUE, MUX_0, {D3DTOP_##cop, D3DTA_##ca1, D3DTA_##ca2, \
				   D3DTOP_SELECTARG1, D3DTA_##aa1, D3DTA_IGNORE}  },

// Select arg1 for col
#define SCENTRY_SELECTCOL(m, ca1, aa1, aa2 ) \
	{ m, 1, TRUE, MUX_0, {D3DTOP_SELECTARG1, D3DTA_##ca1, D3DTA_IGNORE, \
				  D3DTOP_MODULATE,   D3DTA_##aa1, D3DTA_##aa2} },


// Select arg1 for alpha/col
#define SCENTRY_SELECTCOLALP(m, ca1, aa1 ) \
	{ m, 1, TRUE, MUX_0, {D3DTOP_SELECTARG1, D3DTA_##ca1, D3DTA_IGNORE, \
				   D3DTOP_SELECTARG1, D3DTA_##aa1, D3DTA_IGNORE}  },

// Select arg1 for alpha
#define SCENTRY_SELECTALPHA(m, ca1, ca2, aa1 ) \
	{ m, 1, TRUE, MUX_0, {D3DTOP_MODULATE, D3DTA_##ca1, D3DTA_##ca2, \
				   D3DTOP_SELECTARG1, D3DTA_##aa1, D3DTA_IGNORE}   },

#define SCENTRY_DEFAULT(m) \
	{ m, 1, TRUE, MUX_0, {D3DTOP_SELECTARG2, ~0, D3DTA_DIFFUSE, \
				   D3DTOP_SELECTARG2, ~0, D3DTA_DIFFUSE}  }

/*

SetCombine: Unknown Mux: Mux0=0x00121a44fffffe38
            aRGB0: (Texel0       - 0           ) * Shade        + 0
            aA0  : (Texel0       - 0           ) * Environment  + 0
            aRGB1: (Texel1       - 0           ) * Shade        + Combined
            aA1  : (0            - 0           ) * 0            + Combined
SetCombine: Unknown Mux: Mux0=0x0026a0041ffc93f8
            aRGB0: (Texel1       - Texel0      ) * LOD_Fraction + Texel0
            aA0  : (Texel1       - Texel0      ) * Combined     + Texel0
            aRGB1: (Combined     - 0           ) * Shade        + 0
            aA1  : (0            - 0           ) * 0            + Combined
SetCombine: Unknown Mux: Mux0=0x0012fffffffffa38
            aRGB0: (Texel0       - 0           ) * Environment  + 0
            aA0  : (0            - 0           ) * 0            + Environment
            aRGB1: (0            - 0           ) * 0            + Combined
            aA1  : (0            - 0           ) * 0            + Combined
SetCombine: Unknown Mux: Mux0=0x0030b3ff5ffeda38
            aRGB0: (Prim         - Environment ) * Texel0       + Environment
            aA0  : (Primitive    - Environment ) * Texel0       + Environment
            aRGB1: (0            - 0           ) * 0            + Combined
            aA1  : (0            - 0           ) * 0            + Combined
SetCombine: Unknown Mux: Mux0=0x00fffffffffffe38
            aRGB0: (0            - 0           ) * 0            + 0
            aA0  : (0            - 0           ) * 0            + 0
            aRGB1: (0            - 0           ) * 0            + Combined
            aA1  : (0            - 0           ) * 0            + Combined

SetCombine: Unknown Mux: Mux0=0x002527ff1ffc9238
            aRGB0: (Texel1       - Texel0      ) * Prim_Alpha   + Texel0
            aA0  : (Texel1       - Texel0      ) * Primitive    + Texel0
            aRGB1: (0            - 0           ) * 0            + Combined
            aA1  : (0            - 0           ) * 0            + Combined




SetCombine: Unknown Mux: Mux0=0x00262a041f5893f8
            aRGB0: (Texel1       - Texel0      ) * Env_Alpha    + Texel0
            aA0  : (Texel1       - Texel0      ) * Environment  + Texel0
            aRGB1: (Combined     - 0           ) * Shade        + 0
            aA1  : (Texel1       - 0           ) * 1            + Combined

SetCombine: Unknown Mux: Mux0=0x00272a8013fc92f8
            aRGB0: (Texel1       - Texel0      ) * PrimLODFrac  + Texel0
            aA0  : (Texel1       - Texel0      ) * Environment  + Texel0
            aRGB1: (Shade        - Prim        ) * Combined     + Primitive
            aA1  : (0            - 0           ) * 0            + Combined
SetCombine: Unknown Mux: Mux0=0x00127e60f5fffd78
            aRGB0: (Texel0       - 0           ) * Shade        + 0
            aA0  : (0            - 0           ) * 0            + 1
            aRGB1: (Prim         - Environment ) * Combined     + Environment
            aA1  : (0            - 0           ) * 0            + Combined

SetCombine: Unknown Mux: Mux0=0x003099ff5ffefe38
            aRGB0: (Prim         - Environment ) * Texel0       + Environment
            aA0  : (Texel0       - 0           ) * Shade        + 0
            aRGB1: (0            - 0           ) * 0            + Combined
            aA1  : (0            - 0           ) * 0            + Combined
SetCombine: Unknown Mux: Mux0=0x00fffffffffcf438
            aRGB0: (0            - 0           ) * 0            + Texel0
            aA0  : (0            - 0           ) * 0            + Texel1
            aRGB1: (0            - 0           ) * 0            + Combined
            aA1  : (0            - 0           ) * 0            + Combined


  // 007
SetCombine: Unknown Mux: Mux0=0x0026a0041f1093fb
            aRGB0: (Texel1       - Texel0      ) * LOD_Fraction + Texel0
            aA0  : (Texel1       - Texel0      ) * Combined     + Texel0
            aRGB1: (Combined     - 0           ) * Shade        + 0
            aA1  : (Combined     - 0           ) * Shade        + Primitive
SetCombine: Unknown Mux: Mux0=0x0026a0041f1493ff
            aRGB0: (Texel1       - Texel0      ) * LOD_Fraction + Texel0
            aA0  : (Texel1       - Texel0      ) * Combined     + Texel0
            aRGB1: (Combined     - 0           ) * Shade        + 0
            aA1  : (Combined     - 0           ) * Environment  + 0



*/

#define NUM_SCINFO		126
static SetCombineInfo	g_SCInfo[NUM_SCINFO] =
{
	// Redone by Orkin - I wanted to start from scratch, it was easier than studying
	//					 your code. Most of these could be done with a modified
	//					 AssessMux() (one that works with the new combine mode format)
	///					 I wish I had commented better...

    // aRGB0: (Texel0       - 0           ) * Texel0       + 0
	// aA0  : (0            - 0           ) * 0            + Texel0
	// aRGB1: (Combined     - 0           ) * Primitive    + 0
	// aA1  : (0            - 0           ) * 0            + Combined
	{0x0010fe03fffff3f8, 2, TRUE, MUX_PRIM, {
		{D3DTOP_MODULATE, D3DTA_TEXTURE, D3DTA_TEXTURE,
		 D3DTOP_SELECTARG1, D3DTA_TEXTURE, D3DTA_IGNORE},
		{D3DTOP_MODULATE, D3DTA_CURRENT, D3DTA_TFACTOR,
		 D3DTOP_DISABLE, D3DTA_IGNORE, D3DTA_IGNORE}}},

	// aRGB0: (Texel0       - 0           ) * Primitive    + 0
	// aA0  : (Texel0       - 0           ) * Primitive    + 0
	// aRGB1: (Combined     - 0           ) * Shade        + 0
	// aA1  : (0            - 0           ) * 0            + Combined
	{0x00119604fffffff8, 2, TRUE, MUX_PRIM, {
		{D3DTOP_MODULATE, D3DTA_TEXTURE, D3DTA_TFACTOR,
		 D3DTOP_MODULATE, D3DTA_TEXTURE, D3DTA_TFACTOR},
		{D3DTOP_MODULATE, D3DTA_CURRENT, D3DTA_DIFFUSE,
		 D3DTOP_DISABLE, D3DTA_IGNORE, D3DTA_IGNORE}}},

	// aRGB0: (Texel0       - 0           ) * Primitive    + 0
	// aA0  : (Texel0       - 0           ) * Primitive    + 0
	// aRGB1: (Texel0       - 0           ) * Primitive    + 0
	// aA1  : (Texel0       - 0           ) * Primitive    + 0
	{0x00119623ff2fffff, 1, TRUE, MUX_PRIM,
		{D3DTOP_MODULATE, D3DTA_TEXTURE, D3DTA_TFACTOR,
		 D3DTOP_MODULATE, D3DTA_TEXTURE, D3DTA_TFACTOR}},

	// aRGB0: (Texel0       - 0           ) * Primitive    + 0
	// aA0  : (Texel0       - 0           ) * Primitive    + 0
	// aRGB1: (0            - 0           ) * 0            + Combined
	// aA1  : (0            - 0           ) * 0            + Combined
	{0x001197fffffffe38, 1, TRUE, MUX_PRIM,
		{D3DTOP_MODULATE, D3DTA_TEXTURE, D3DTA_TFACTOR,
		 D3DTOP_MODULATE, D3DTA_TEXTURE, D3DTA_TFACTOR}},

	// aRGB0: (Texel0       - 0           ) * Primitive    + 0
	// aA0  : (Shade        - 0           ) * Texel0       + 0
	// aRGB1: (Texel0       - 0           ) * Primitive    + 0
	// aA1  : (Shade        - 0           ) * Texel0       + 0
	{0x0011c223ff87ffff, 1, TRUE, MUX_PRIM,
		{D3DTOP_MODULATE, D3DTA_TEXTURE, D3DTA_TFACTOR,
		 D3DTOP_MODULATE, D3DTA_TEXTURE, D3DTA_DIFFUSE}},

	// aRGB0: (Texel0       - 0           ) * Primitive    + 0
	// aA0  : (0            - 0           ) * 0            + Texel0
	// aRGB1: (Combined     - 0           ) * Shade        + 0
	// aA1  : (0            - 0           ) * 0            + Combined
	{0x0011fe04fffff3f8, 2, TRUE, MUX_PRIM, {
		{D3DTOP_MODULATE, D3DTA_TEXTURE, D3DTA_TFACTOR,
		 D3DTOP_SELECTARG1, D3DTA_TEXTURE, D3DTA_IGNORE},
		{D3DTOP_MODULATE, D3DTA_CURRENT, D3DTA_DIFFUSE,
		 D3DTOP_DISABLE, D3DTA_IGNORE, D3DTA_IGNORE}}},

	// aRGB0: (Texel0       - 0           ) * Primitive    + 0
	// aA0  : (0            - 0           ) * 0            + Primitive
	// aRGB1: (Combined     - 0           ) * Shade        + 0
	// aA1  : (0            - 0           ) * 0            + Combined
	{0x0011fe04fffff7f8, 2, TRUE, MUX_PRIM, {
		{D3DTOP_MODULATE, D3DTA_TEXTURE, D3DTA_TFACTOR,
		 D3DTOP_SELECTARG1, D3DTA_TFACTOR, D3DTA_IGNORE},
		{D3DTOP_MODULATE, D3DTA_CURRENT, D3DTA_DIFFUSE,
		 D3DTOP_DISABLE, D3DTA_IGNORE, D3DTA_IGNORE}}},

	// aRGB0: (Texel0       - 0           ) * Primitive    + 0
	// aA0  : (0            - 0           ) * 0            + Texel0
	// aRGB1: (Texel0       - 0           ) * Primitive    + 0
	// aA1  : (0            - 0           ) * 0            + Texel0
	{0x0011fe23fffff3f9, 1, TRUE, MUX_PRIM,
		{D3DTOP_MODULATE, D3DTA_TEXTURE, D3DTA_TFACTOR,
		 D3DTOP_SELECTARG1, D3DTA_TEXTURE, D3DTA_IGNORE}},

	// aRGB0: (Texel0       - 0           ) * Primitive    + 0
	// aA0  : (0            - 0           ) * 0            + Primitive
	// aRGB1: (Texel0       - 0           ) * Primitive    + 0
	// aA1  : (0            - 0           ) * 0            + Primitive
	{0x0011fe23fffff7fb, 1, TRUE, MUX_PRIM,
		{D3DTOP_MODULATE, D3DTA_TEXTURE, D3DTA_TFACTOR,
		 D3DTOP_SELECTARG1, D3DTA_TFACTOR, D3DTA_IGNORE}},

	// aRGB0: (Texel0       - 0           ) * Primitive    + 0
	// aA0  : (0            - 0           ) * 0            + 1
	// aRGB1: (Texel0       - 0           ) * Primitive    + 0
	// aA1  : (0            - 0           ) * 0            + Combined
	{0x0011fe23fffffdf8, 1, FALSE, MUX_PRIM,
		{D3DTOP_MODULATE, D3DTA_TEXTURE, D3DTA_TFACTOR,
		 D3DTOP_DISABLE, D3DTA_IGNORE, D3DTA_IGNORE}},

	// Added by StrmnNrmn - Incorrect (uses T1)
	// aRGB0: (Texel0       - Texel1      ) * Primitive    + Texel1
	// aA0  : (0            - 0           ) * 0            + 1
	// aRGB1: (0            - 0           ) * 0            + Combined
	// aA1  : (0            - 0           ) * 0            + Combined
	{0x0011ffff2ffd7c38, 1, FALSE, MUX_PRIM,
		{D3DTOP_MODULATE, D3DTA_TEXTURE, D3DTA_TFACTOR,
		 D3DTOP_SELECTARG1, D3DTA_TEXTURE, D3DTA_IGNORE}},

	// aRGB0: (Texel0       - 0           ) * Primitive    + 0
	// aA0  : (0            - 0           ) * 0            + Texel0
	// aRGB1: (0            - 0           ) * 0            + Combined
	// aA1  : (0            - 0           ) * 0            + Combined
	{0x0011fffffffff238, 1, TRUE, MUX_PRIM,
		{D3DTOP_MODULATE, D3DTA_TEXTURE, D3DTA_TFACTOR,
		 D3DTOP_SELECTARG1, D3DTA_TEXTURE, D3DTA_IGNORE}},

	// aRGB0: (Texel0       - 0           ) * Primitive    + 0
	// aA0  : (0            - 0           ) * 0            + Primitive
	// aRGB1: (0            - 0           ) * 0            + Combined
	// aA1  : (0            - 0           ) * 0            + Combined
	{0x0011fffffffff638, 1, TRUE, MUX_PRIM,
		{D3DTOP_MODULATE, D3DTA_TEXTURE, D3DTA_TFACTOR,
		 D3DTOP_SELECTARG1, D3DTA_TFACTOR, D3DTA_IGNORE}},

	// aRGB0: (Texel0       - 0           ) * Primitive    + 0
	// aA0  : (0            - 0           ) * 0            + 1
	// aRGB1: (0            - 0           ) * 0            + Combined
	// aA1  : (0            - 0           ) * 0            + Combined
	{0x0011fffffffffc38, 1, FALSE, MUX_PRIM,
		{D3DTOP_MODULATE, D3DTA_TEXTURE, D3DTA_TFACTOR,
		 D3DTOP_DISABLE, D3DTA_IGNORE, D3DTA_IGNORE}},

	// Added by StrmnNrmn - Needs T1
	// aRGB0: (Texel0       - 0           ) * Shade        + 0
	// aA0  : (Texel0       - 0           ) * Primitive    + 0
	// aRGB1: (Combined     - 0           ) * Primitive    + 0
	// aA1  : (Texel1       - 0           ) * 1            + Combined
	{0x00121603ff5bfff8, 2, TRUE, MUX_PRIM, {
		{D3DTOP_MODULATE, D3DTA_TEXTURE, D3DTA_DIFFUSE,
		 D3DTOP_MODULATE, D3DTA_TEXTURE, D3DTA_TFACTOR},
		{D3DTOP_MODULATE, D3DTA_CURRENT, D3DTA_TFACTOR,
		 D3DTOP_DISABLE, D3DTA_IGNORE, D3DTA_IGNORE}}},
		
	// aRGB0: (Texel0       - 0           ) * Shade        + 0
	// aA0  : (Texel0       - 0           ) * Primitive    + 0
	// aRGB1: (Combined     - 0           ) * Primitive    + 0
	// aA1  : (0            - 0           ) * 0            + Combined
	{0x00121603fffffff8, 2, TRUE, MUX_PRIM, {
		{D3DTOP_MODULATE, D3DTA_TEXTURE, D3DTA_DIFFUSE,
		 D3DTOP_MODULATE, D3DTA_TEXTURE, D3DTA_TFACTOR},
		{D3DTOP_MODULATE, D3DTA_CURRENT, D3DTA_TFACTOR,
		 D3DTOP_DISABLE, D3DTA_IGNORE, D3DTA_IGNORE}}},

	// aRGB0: (Texel0       - 0           ) * Shade        + 0
	// aA0  : (Texel0       - 0           ) * Primitive    + 0
	// aRGB1: (Texel0       - 0           ) * Shade        + 0
	// aA1  : (Texel0       - 0           ) * Primitive    + 0
	{0x00121624ff2fffff, 1, TRUE, MUX_PRIM,
		{D3DTOP_MODULATE, D3DTA_TEXTURE, D3DTA_DIFFUSE,
		 D3DTOP_MODULATE, D3DTA_TEXTURE, D3DTA_TFACTOR}},

	// aRGB0: (Texel0       - 0           ) * Shade        + 0
	// aA0  : (Texel0       - 0           ) * Primitive    + 0
	// aRGB1: (0            - 0           ) * 0            + Combined
	// aA1  : (0            - 0           ) * 0            + Combined
	{0x001217fffffffe38, 1, TRUE, MUX_PRIM,
		{D3DTOP_MODULATE, D3DTA_TEXTURE, D3DTA_DIFFUSE,
		 D3DTOP_MODULATE, D3DTA_TEXTURE, D3DTA_TFACTOR}},

	// aRGB0: (Texel0       - 0           ) * Shade        + 0
	// aA0  : (Texel0       - 0           ) * Shade        + 0
	// aRGB1: (Combined     - 0           ) * Primitive    + 0
	// aA1  : (Combined     - 0           ) * Primitive    + 0
	{0x00121803ff0fffff, 2, TRUE, MUX_PRIM, {
		{D3DTOP_MODULATE, D3DTA_TEXTURE, D3DTA_DIFFUSE,
		 D3DTOP_MODULATE, D3DTA_TEXTURE, D3DTA_DIFFUSE},
		{D3DTOP_MODULATE, D3DTA_CURRENT, D3DTA_TFACTOR,
		 D3DTOP_MODULATE, D3DTA_CURRENT, D3DTA_TFACTOR}}},

	// aRGB0: (Texel0       - 0           ) * Shade        + 0
	// aA0  : (Texel0       - 0           ) * Shade        + 0
	// aRGB1: (Texel0       - 0           ) * Shade        + 0
	// aA1  : (Texel0       - 0           ) * Shade        + 0
	{0x00121824ff33ffff, 1, TRUE, MUX_0,
		{D3DTOP_MODULATE, D3DTA_TEXTURE, D3DTA_DIFFUSE,
		 D3DTOP_MODULATE, D3DTA_TEXTURE, D3DTA_DIFFUSE}},

	// aRGB0: (Texel0       - 0           ) * Shade        + 0
	// aA0  : (Texel0       - 0           ) * Environment  + 0
	// aRGB1: (Texel0       - 0           ) * Shade        + 0
	// aA1  : (Texel0       - 0           ) * Environment  + 0
	{0x00121a24ff37ffff, 1, TRUE, MUX_ENV,
		{D3DTOP_MODULATE, D3DTA_TEXTURE, D3DTA_DIFFUSE,
		 D3DTOP_MODULATE, D3DTA_TEXTURE, D3DTA_TFACTOR}},

	// aRGB0: (Texel0       - 0           ) * Shade        + 0
	// aA0  : (0            - 0           ) * 0            + Texel0
	// aRGB1: (Combined     - 0           ) * Primitive    + 0
	// aA1  : (Combined     - 0           ) * Primitive    + 0
	{0x00127e03ff0ff3ff, 2, TRUE, MUX_PRIM, {
		{D3DTOP_MODULATE, D3DTA_TEXTURE, D3DTA_DIFFUSE,
		 D3DTOP_MODULATE, D3DTA_TEXTURE, D3DTA_TFACTOR},
		{D3DTOP_MODULATE, D3DTA_CURRENT, D3DTA_TFACTOR,
		 D3DTOP_DISABLE, D3DTA_IGNORE, D3DTA_IGNORE}}},

	// aRGB0: (Texel0       - 0           ) * Shade        + 0
	// aA0  : (0            - 0           ) * 0            + Texel0
	// aRGB1: (Combined     - 0           ) * Primitive    + 0
	// aA1  : (0            - 0           ) * 0            + Combined
	{0x00127e03fffff3f8, 2, TRUE, MUX_PRIM, {
		{D3DTOP_MODULATE, D3DTA_TEXTURE, D3DTA_DIFFUSE,
		 D3DTOP_SELECTARG1, D3DTA_TEXTURE, D3DTA_IGNORE},
		{D3DTOP_MODULATE, D3DTA_CURRENT, D3DTA_TFACTOR,
		 D3DTOP_DISABLE, D3DTA_IGNORE, D3DTA_IGNORE}}},

	// aRGB0: (Texel0       - 0           ) * Shade        + 0
	// aA0  : (0            - 0           ) * 0            + Shade
	// aRGB1: (Combined     - 0           ) * Primitive    + 0
	// aA1  : (0            - 0           ) * 0            + Primitive
	{0x00127e03fffff9fb, 2, TRUE, MUX_PRIM, {
		{D3DTOP_MODULATE, D3DTA_TEXTURE, D3DTA_DIFFUSE,
		 D3DTOP_ADD, D3DTA_DIFFUSE, D3DTA_TFACTOR},
		{D3DTOP_MODULATE, D3DTA_CURRENT, D3DTA_TFACTOR,
		 D3DTOP_DISABLE, D3DTA_IGNORE, D3DTA_IGNORE}}},

	// Incorrect - Alpha should be set to Env, but it uses Env and Prim so I had to pick the best one
	// aRGB0: (Texel0       - 0           ) * Shade        + 0
	// aA0  : (0            - 0           ) * 0            + Environment
	// aRGB1: (Combined     - 0           ) * Primitive    + 0
	// aA1  : (0            - 0           ) * 0            + Combined
	{0x00127e03fffffbf8, 2, FALSE, MUX_PRIM, {
		{D3DTOP_MODULATE, D3DTA_TEXTURE, D3DTA_DIFFUSE,
		 D3DTOP_DISABLE, D3DTA_IGNORE, D3DTA_IGNORE},
		{D3DTOP_MODULATE, D3DTA_CURRENT, D3DTA_TFACTOR,
		 D3DTOP_DISABLE, D3DTA_IGNORE, D3DTA_IGNORE}}},

	// aRGB0: (Texel0       - 0           ) * Shade        + 0
	// aA0  : (0            - 0           ) * 0            + 1
	// aRGB1: (Combined     - 0           ) * Primitive    + 0
	// aA1  : (0            - 0           ) * 0            + Combined
	{0x00127e03fffffdf8, 2, FALSE, MUX_PRIM, {
		{D3DTOP_MODULATE, D3DTA_TEXTURE, D3DTA_DIFFUSE,
		 D3DTOP_DISABLE, D3DTA_IGNORE, D3DTA_IGNORE},
		{D3DTOP_MODULATE, D3DTA_CURRENT, D3DTA_TFACTOR,
		 D3DTOP_DISABLE, D3DTA_IGNORE, D3DTA_IGNORE}}},

	// aRGB0: (Texel0       - 0           ) * Shade        + 0
	// aA0  : (0            - 0           ) * 0            + Texel0
	// aRGB1: (Combined     - 0           ) * Environment  + 0
	// aA1  : (Combined     - 0           ) * Environment  + 0
	{0x00127e05ff17f3ff, 2, TRUE, MUX_ENV, {
		{D3DTOP_MODULATE, D3DTA_TEXTURE, D3DTA_DIFFUSE,
		 D3DTOP_MODULATE, D3DTA_TEXTURE, D3DTA_TFACTOR},
		{D3DTOP_MODULATE, D3DTA_CURRENT, D3DTA_TFACTOR,
		 D3DTOP_DISABLE, D3DTA_IGNORE, D3DTA_IGNORE}}},

	// aRGB0: (Texel0       - 0           ) * Shade        + 0
	// aA0  : (0            - 0           ) * 0            + Texel0
	// aRGB1: (Combined     - 0           ) * Environment  + 0
	// aA1  : (0            - 0           ) * 0            + Combined
	{0x00127e05fffff3f8, 2, TRUE, MUX_ENV, {
		{D3DTOP_MODULATE, D3DTA_TEXTURE, D3DTA_DIFFUSE,
		 D3DTOP_SELECTARG1, D3DTA_TEXTURE, D3DTA_IGNORE},
		{D3DTOP_MODULATE, D3DTA_CURRENT, D3DTA_TFACTOR,
		 D3DTOP_DISABLE, D3DTA_IGNORE, D3DTA_IGNORE}}},

 	// aRGB0: (Texel0       - 0           ) * Shade        + 0
	// aA0  : (0            - 0           ) * 0            + Environment
	// aRGB1: (Combined     - 0           ) * Environment  + 0
	// aA1  : (0            - 0           ) * 0            + Combined
	{0x00127e05fffffbf8, 2, TRUE, MUX_ENV, {
		{D3DTOP_MODULATE, D3DTA_TEXTURE, D3DTA_DIFFUSE,
		 D3DTOP_SELECTARG1, D3DTA_TFACTOR, D3DTA_IGNORE},
		{D3DTOP_MODULATE, D3DTA_CURRENT, D3DTA_TFACTOR,
		 D3DTOP_DISABLE, D3DTA_IGNORE, D3DTA_IGNORE}}},

	// aRGB0: (Texel0       - 0           ) * Shade        + 0
	// aA0  : (0            - 0           ) * 0            + 1
	// aRGB1: (Combined     - 0           ) * Environment  + 0
	// aA1  : (0            - 0           ) * 0            + Combined
	{0x00127e05fffffdf8, 2, FALSE, MUX_ENV, {
		{D3DTOP_MODULATE, D3DTA_TEXTURE, D3DTA_DIFFUSE,
		 D3DTOP_DISABLE, D3DTA_IGNORE, D3DTA_IGNORE},
		{D3DTOP_MODULATE, D3DTA_CURRENT, D3DTA_TFACTOR,
		 D3DTOP_DISABLE, D3DTA_IGNORE, D3DTA_IGNORE}}},

	// Added by StrmnNrmn - Incorrect (blend T0/Prim by Shade)
	// aRGB0: (Texel0       - Prim        ) * Shade        + Primitive
	// aA0  : (0            - 0           ) * 0            + Shade
	// aRGB1: (Texel0       - Prim        ) * Shade        + Primitive
	// aA1  : (0            - 0           ) * 0            + Shade
//	{0x00127e2433fdf8fc, 1, TRUE, MUX_PRIM,
//		{D3DTOP_MODULATE, D3DTA_TEXTURE, D3DTA_DIFFUSE,
//		 D3DTOP_SELECTARG1, D3DTA_DIFFUSE, D3DTA_IGNORE}},


	// aRGB0: (Texel0       - 0           ) * Shade        + 0
	// aA0  : (0            - 0           ) * 0            + Texel0
	// aRGB1: (Texel0       - 0           ) * Shade        + 0
	// aA1  : (0            - 0           ) * 0            + Texel0
	{0x00127e24fffff3f9, 1, TRUE, MUX_0,
		{D3DTOP_MODULATE, D3DTA_TEXTURE, D3DTA_DIFFUSE,
		 D3DTOP_SELECTARG1, D3DTA_TEXTURE, D3DTA_IGNORE}},

	// aRGB0: (Texel0       - 0           ) * Shade        + 0
	// aA0  : (0            - 0           ) * 0            + Shade
	// aRGB1: (Texel0       - 0           ) * Shade        + 0
	// aA1  : (0            - 0           ) * 0            + Shade
	{0x00127e24fffff9fc, 1, TRUE, MUX_0,
		{D3DTOP_MODULATE, D3DTA_TEXTURE, D3DTA_DIFFUSE,
		 D3DTOP_SELECTARG1, D3DTA_DIFFUSE, D3DTA_IGNORE}},

	// aRGB0: (Texel0       - 0           ) * Shade        + 0
	// aA0  : (0            - 0           ) * 0            + Environment
	// aRGB1: (Texel0       - 0           ) * Shade        + 0
	// aA1  : (0            - 0           ) * 0            + Environment
	{0x00127e24fffffbfd, 1, TRUE, MUX_ENV,
		{D3DTOP_MODULATE, D3DTA_TEXTURE, D3DTA_DIFFUSE,
		 D3DTOP_SELECTARG1, D3DTA_TFACTOR, D3DTA_IGNORE}},

	// Added by StrmnNrmn - Incorrect - need to add second texture in
	// Special cased below anyway
	// aRGB0: (Texel0       - 0           ) * Shade        + 0
	// aA0  : (0            - 0           ) * 0            + Texel0
	// aRGB1: (Texel1       - 0           ) * Shade        + Combined
	// aA1  : (0            - 0           ) * 0            + Combined
	{0x00127e44fffff238, 1, TRUE, MUX_0,
		{D3DTOP_MODULATE, D3DTA_TEXTURE, D3DTA_DIFFUSE,
		 D3DTOP_SELECTARG1, D3DTA_TEXTURE, D3DTA_IGNORE}},

	// Incorrect, should modulate Texel0 by Env in alpha
	// aRGB0: (Texel0       - 0           ) * Shade        + 0
	// aA0  : (0            - 0           ) * 0            + Texel0
	// aRGB1: (Prim         - 0           ) * Combined     + 0
	// aA1  : (Combined     - 0           ) * Environment  + 0
	{0x00127e60ff17f3ff, 2, TRUE, MUX_PRIM, {
		{D3DTOP_MODULATE, D3DTA_TEXTURE, D3DTA_DIFFUSE,
		 D3DTOP_SELECTARG1, D3DTA_TEXTURE, D3DTA_IGNORE},
		{D3DTOP_MODULATE, D3DTA_CURRENT, D3DTA_TFACTOR,
		 D3DTOP_DISABLE, D3DTA_IGNORE, D3DTA_IGNORE}}},

	// aRGB0: (Texel0       - 0           ) * Shade        + 0
	// aA0  : (0            - 0           ) * 0            + Texel0
	// aRGB1: (Prim         - 0           ) * Combined     + 0
	// aA1  : (0            - 0           ) * 0            + Combined
	{0x00127e60fffff3f8, 2, TRUE, MUX_PRIM, {
		{D3DTOP_MODULATE, D3DTA_TEXTURE, D3DTA_DIFFUSE,
		 D3DTOP_SELECTARG1, D3DTA_TEXTURE, D3DTA_IGNORE},
		{D3DTOP_MODULATE, D3DTA_CURRENT, D3DTA_TFACTOR,
		 D3DTOP_DISABLE, D3DTA_IGNORE, D3DTA_IGNORE}}},

	// aRGB0: (Texel0       - 0           ) * Shade        + 0
	// aA0  : (0            - 0           ) * 0            + Texel0
	// aRGB1: (Environment  - 0           ) * Combined     + 0
	// aA1  : (Combined     - 0           ) * Environment  + 0
	{0x00127ea0ff17f3ff, 2, TRUE, MUX_ENV, {
		{D3DTOP_MODULATE, D3DTA_TEXTURE, D3DTA_DIFFUSE,
		 D3DTOP_MODULATE, D3DTA_TEXTURE, D3DTA_TFACTOR},
		{D3DTOP_MODULATE, D3DTA_CURRENT, D3DTA_TFACTOR,
		 D3DTOP_DISABLE, D3DTA_IGNORE, D3DTA_IGNORE}}},

	// aRGB0: (Texel0       - 0           ) * Shade        + 0
	// aA0  : (0            - 0           ) * 0            + Texel0
	// aRGB1: (Environment  - 0           ) * Combined     + 0
	// aA1  : (0            - 0           ) * 0            + Combined
	{0x00127ea0fffff3f8, 2, TRUE, MUX_ENV, {
		{D3DTOP_MODULATE, D3DTA_TEXTURE, D3DTA_DIFFUSE,
		 D3DTOP_SELECTARG1, D3DTA_TEXTURE, D3DTA_IGNORE},
		{D3DTOP_MODULATE, D3DTA_CURRENT, D3DTA_TFACTOR,
		 D3DTOP_DISABLE, D3DTA_IGNORE, D3DTA_IGNORE}}},

	// aRGB0: (Texel0       - 0           ) * Shade        + 0
	// aA0  : (0            - 0           ) * 0            + Texel0
	// aRGB1: (0            - 0           ) * 0            + Combined
	// aA1  : (0            - 0           ) * 0            + Combined
	{0x00127ffffffff238, 1, TRUE, MUX_0,
		{D3DTOP_MODULATE, D3DTA_TEXTURE, D3DTA_DIFFUSE,
		 D3DTOP_SELECTARG1, D3DTA_TEXTURE, D3DTA_IGNORE}},

	// aRGB0: (Texel0       - 0           ) * Shade        + 0
	// aA0  : (0            - 0           ) * 0            + Shade
	// aRGB1: (0            - 0           ) * 0            + Combined
	// aA1  : (0            - 0           ) * 0            + Combined
	{0x00127ffffffff838, 1, TRUE, MUX_0,
		{D3DTOP_MODULATE, D3DTA_TEXTURE, D3DTA_DIFFUSE,
		 D3DTOP_SELECTARG1, D3DTA_DIFFUSE, D3DTA_IGNORE}},

	// Added by StrmnNrmn - Needs fixing (Env/Prim)
	// aRGB0: (Texel0       - Prim        ) * Environment  + Primitive
	// aA0  : (Texel0       - 0           ) * Primitive    + 0
	// aRGB1: (Texel0       - Prim        ) * Environment  + Primitive
	// aA1  : (Texel0       - 0           ) * Primitive    + 0
	{0x00129625332dfeff, 1, TRUE, MUX_PRIM,
		{D3DTOP_SELECTARG1, D3DTA_TEXTURE, D3DTA_IGNORE,
		 D3DTOP_MODULATE, D3DTA_TEXTURE, D3DTA_TFACTOR}},

	// aRGB0: (Texel0       - 0           ) * Environment  + 0
	// aA0  : (Texel0       - 0           ) * Shade        + 0
	// aRGB1: (Texel0       - 0           ) * Environment  + 0
	// aA1  : (Texel0       - 0           ) * Shade        + 0
	{0x00129825ff33ffff, 1, TRUE, MUX_ENV,
		{D3DTOP_MODULATE, D3DTA_TEXTURE, D3DTA_TFACTOR,
		 D3DTOP_MODULATE, D3DTA_TEXTURE, D3DTA_DIFFUSE}},

	// aRGB0: (Texel0       - 0           ) * Environment  + 0
	// aA0  : (Texel0       - 0           ) * Environment  + 0
	// aRGB1: (Texel0       - 0           ) * Environment  + 0
	// aA1  : (Texel0       - 0           ) * Environment  + 0
	{0x00129a25ff37ffff, 1, TRUE, MUX_ENV,
		{D3DTOP_MODULATE, D3DTA_TEXTURE, D3DTA_TFACTOR,
		 D3DTOP_MODULATE, D3DTA_TEXTURE, D3DTA_TFACTOR}},

	// aRGB0: (Texel0       - 0           ) * Environment  + 0
	// aA0  : (0            - 0           ) * 0            + Texel0
	// aRGB1: (Texel0       - 0           ) * Environment  + 0
	// aA1  : (0            - 0           ) * 0            + Texel0
	{0x0012fe25fffff3f9, 1, TRUE, MUX_ENV,
		{D3DTOP_MODULATE, D3DTA_TEXTURE, D3DTA_TFACTOR,
		 D3DTOP_SELECTARG1, D3DTA_TEXTURE, D3DTA_IGNORE}},

	// aRGB0: (Texel0       - 0           ) * Environment  + 0
	// aA0  : (0            - 0           ) * 0            + 1
	// aRGB1: (Texel0       - 0           ) * Environment  + 0
	// aA1  : (0            - 0           ) * 0            + 1
	{0x0012fe25fffffdfe, 1, FALSE, MUX_ENV,
		{D3DTOP_MODULATE, D3DTA_TEXTURE, D3DTA_TFACTOR,
		 D3DTOP_DISABLE, D3DTA_IGNORE, D3DTA_IGNORE}},

	// aRGB0: (Texel0       - Shade       ) * Texel0_Alpha + Shade
	// aA0  : (0            - 0           ) * 0            + Shade
	// aRGB1: (Texel0       - Shade       ) * Texel0_Alpha + Shade
	// aA1  : (0            - 0           ) * 0            + Shade
	{0x00147e2844fe793c, 1, TRUE, MUX_0,
		{D3DTOP_BLENDTEXTUREALPHA, D3DTA_TEXTURE, D3DTA_DIFFUSE,
		 D3DTOP_SELECTARG1, D3DTA_DIFFUSE, D3DTA_IGNORE}},

	// aRGB0: (Texel0       - Shade       ) * Texel0_Alpha + Shade
	// aA0  : (0            - 0           ) * 0            + Environment
	// aRGB1: (Texel0       - Shade       ) * Texel0_Alpha + Shade
	// aA1  : (0            - 0           ) * 0            + Environment
	{0x00147e2844fe7b3d, 1, TRUE, MUX_ENV, 
		{D3DTOP_BLENDTEXTUREALPHA, D3DTA_TEXTURE, D3DTA_DIFFUSE,
		 D3DTOP_SELECTARG1, D3DTA_TFACTOR, D3DTA_IGNORE}},


	// Added by StrmnNrmn - For alpha just selected Texture?
	// aRGB0: (Texel0       - Environment ) * Shade_Alpha  + Environment
	// aA0  : (Texel0       - Environment ) * Shade        + Environment
	// aRGB1: (Combined     - 0           ) * Shade        + 0
	// aA1  : (0            - 0           ) * 0            + Combined
	{0x001598045ffedbf8, 1, TRUE, MUX_ENV,
		{D3DTOP_BLENDDIFFUSEALPHA, D3DTA_TEXTURE, D3DTA_TFACTOR,
		 D3DTOP_BLENDDIFFUSEALPHA, D3DTA_TEXTURE, D3DTA_TFACTOR}},

	// Added by StrmnNrmn - Uses both Prim and Env
	// aRGB0: (Texel0       - Prim        ) * Env_Alpha    + Primitive
	// aA0  : (0            - 0           ) * 0            + Primitive
	// aRGB1: (Texel0       - Prim        ) * Env_Alpha    + Primitive
	// aA1  : (0            - 0           ) * 0            + Primitive
	{0x00167e2c33fdf6fb, 1, TRUE, MUX_PRIM,
		{D3DTOP_SELECTARG1, D3DTA_TEXTURE, D3DTA_IGNORE,
		 D3DTOP_SELECTARG1, D3DTA_TFACTOR, D3DTA_IGNORE}},

	// Incorrect - Uses both Prim and Env
	// aRGB0: (Texel0       - Prim        ) * Env_Alpha    + Texel0
	// aA0  : (0            - 0           ) * 0            + 0
	// aRGB1: (Prim         - Environment ) * Combined     + Environment
	// aA1  : (0            - 0           ) * 0            + 1
	{0x00167e6035fcff7e, 1, FALSE, MUX_ENV,
		{D3DTOP_MODULATE, D3DTA_TFACTOR, D3DTA_TEXTURE,
		 D3DTOP_DISABLE, D3DTA_IGNORE, D3DTA_IGNORE}},
	




	// Added by StrmnNrmn - T0-T0??
	// aRGB0: (Texel0       - Texel0      ) * LOD_Fraction + Texel0
	// aA0  : (Texel0       - Texel0      ) * Combined     + Texel0
	// aRGB1: (Combined     - 0           ) * Primitive    + 0
	// aA1  : (Combined     - 0           ) * Primitive    + 0
	{0x001690031f0c93ff, 1, TRUE, MUX_PRIM,
		{D3DTOP_MODULATE, D3DTA_TFACTOR, D3DTA_TEXTURE,
		 D3DTOP_MODULATE, D3DTA_TFACTOR, D3DTA_TEXTURE}},


	// Incorrect - doesn't use Texel1
	// aRGB0: (Texel1       - Texel0      ) * Environment  + Texel0
	// aA0  : (0            - 0           ) * 0            + Environment
	// aRGB1: (0            - 0           ) * 0            + Combined
	// aA1  : (0            - 0           ) * 0            + Combined
	{0x0022ffff1ffcfa38, 1, TRUE, MUX_ENV,
		{D3DTOP_ADDSMOOTH, D3DTA_TEXTURE, D3DTA_TFACTOR,
		 D3DTOP_SELECTARG1, D3DTA_TFACTOR, D3DTA_IGNORE}},

	// Added by StrmnNrmn - This is incorrect (we need to blend between two textures
	// using the primitive alpha - for now we just select T0)
	// aRGB0: (Texel1       - Texel0      ) * Prim_Alpha   + Texel0
	// aA0  : (Texel1       - Texel0      ) * Primitive    + Texel0
	// aRGB1: (0            - 0           ) * 0            + Combined
	// aA1  : (0            - 0           ) * 0            + Combined
	{0x002527ff1ffc9238, 1, TRUE, MUX_PRIM,
		{D3DTOP_SELECTARG1, D3DTA_TEXTURE, D3DTA_IGNORE,
		 D3DTOP_SELECTARG1, D3DTA_TEXTURE, D3DTA_IGNORE}},

	// Added by StrmnNrmn - Incorrect at moment - we need two textures and
	// env/prim simultaneously
	// aRGB0: (Texel1       - Texel0      ) * Env_Alpha    + Texel0
	// aA0  : (Texel1       - Texel0      ) * Environment  + Texel0
	// aRGB1: (Prim         - Environment ) * Combined     + Environment
	// aA1  : (Combined     - 0           ) * Primitive    + 0
	{0x00262a60150c937f, 1, TRUE, MUX_PRIM,
		{D3DTOP_SELECTARG1, D3DTA_TEXTURE, D3DTA_TFACTOR,
		 D3DTOP_SELECTARG1, D3DTA_TEXTURE, D3DTA_TFACTOR}},
	

	// Added by StrmnNrmn - Incorrect - needs T1
	// aRGB0: (Texel1       - Texel0      ) * Env_Alpha    + Texel0
	// aA0  : (0            - 0           ) * 0            + 1
	// aRGB1: (Combined     - 0           ) * Shade        + 0
	// aA1  : (Combined     - 0           ) * Primitive    + 0
	{0x00267e041f0cfdff, 1, TRUE, MUX_PRIM,
		{D3DTOP_MODULATE, D3DTA_TEXTURE, D3DTA_DIFFUSE,
		 D3DTOP_SELECTARG2, D3DTA_IGNORE, D3DTA_TFACTOR}},


	// Added by StrmnNrmn - Incorrect - needs T1
	// aRGB0: (Texel1       - Texel0      ) * Env_Alpha    + Texel0
	// aA0  : (0            - 0           ) * 0            + 1
	// aRGB1: (Combined     - 0           ) * Shade        + 0
	// aA1  : (0            - 0           ) * 0            + Combined
	{0x00267e041ffcfdf8, 1, FALSE, MUX_ENV,
		{D3DTOP_MODULATE, D3DTA_TEXTURE, D3DTA_DIFFUSE,
		 D3DTOP_SELECTARG1, D3DTA_IGNORE, D3DTA_IGNORE}},


	// Incorrect - Uses Texel1 AND uses both Prim and Env
	// aRGB0: (Texel1       - Prim        ) * Env_Alpha    + Texel0
	// aA0  : (0            - 0           ) * 0            + Texel0
	// aRGB1: (Prim         - Environment ) * Combined     + Environment
	// aA1  : (Combined     - 0           ) * Primitive    + 0
	{0x00267e60350cf37f, 1, TRUE, MUX_ENV,
		{D3DTOP_MODULATE, D3DTA_TFACTOR, D3DTA_TEXTURE,
		 D3DTOP_SELECTARG1, D3DTA_TEXTURE, D3DTA_IGNORE}},


	// Added by StrmnNrmn - Incorrect uses T1
	// aRGB0: (Texel1       - Texel0      ) * LOD_Fraction + Texel0
	// aA0  : (Texel1       - Texel0      ) * Combined     + Texel0
	// aRGB1: (Combined     - 0           ) * Shade        + 0
	// aA1  : (Combined     - 0           ) * Shade        + 0
	{0x0026a0041f1093ff, 1, TRUE, MUX_0,
		{D3DTOP_MODULATE, D3DTA_DIFFUSE, D3DTA_TEXTURE,
		 D3DTOP_MODULATE, D3DTA_DIFFUSE, D3DTA_TEXTURE}},


	// Added by StrmnNrmn - Incorrect uses T1
	// aRGB0: (Texel1       - Texel0      ) * LOD_Fraction + Texel0
	// aA0  : (Texel1       - Texel0      ) * Combined     + Texel0
	// aRGB1: (Combined     - 0           ) * Shade        + 0
	// aA1  : (0            - 0           ) * 0            + Shade
	{0x0026a0041ffc93fc, 1, TRUE, MUX_0,
		{D3DTOP_MODULATE, D3DTA_DIFFUSE, D3DTA_TEXTURE,
		 D3DTOP_SELECTARG1, D3DTA_DIFFUSE, D3DTA_IGNORE}},


	// Added by StrmnNrmn - Incorrect uses Prim/Env/T1
	// aRGB0: (Texel1       - Prim        ) * PrimLODFrac  + Texel0
	// aA0  : (Texel1       - 1           ) * 1            + Texel0
	// aRGB1: (Prim         - Environment ) * Combined     + Environment
	// aA1  : (Combined     - 0           ) * Primitive    + 0
	{0x00272c60350ce37f, 1, TRUE, MUX_PRIM,
		{D3DTOP_MODULATE, D3DTA_TFACTOR, D3DTA_TEXTURE,
		 D3DTOP_MODULATE, D3DTA_TEXTURE, D3DTA_TFACTOR}}, 

	// Added by StrmnNrmn - Incorrect at moment (need both env and prim)
	// aRGB0: (Prim         - Environment ) * Texel0       + Environment
	// aA0  : (Texel0       - 0           ) * Primitive    + 0
	// aRGB1: (Prim         - Environment ) * Texel0       + Environment
	// aA1  : (Texel0       - 0           ) * Primitive    + 0
	{0x00309661552eff7f, 1, TRUE, MUX_PRIM,
		{D3DTOP_MODULATE, D3DTA_TFACTOR, D3DTA_TEXTURE,
		 D3DTOP_MODULATE, D3DTA_TEXTURE, D3DTA_TFACTOR}},

	// Added by StrmnNrmn - Incorrect at moment (need both env and prim)
	// aRGB0: (Prim         - Environment ) * Texel0       + Environment
	// aA0  : (Texel0       - 0           ) * Primitive    + 0
	// aRGB1: (0            - 0           ) * 0            + Combined
	// aA1  : (0            - 0           ) * 0            + Combined
	{0x003097ff5ffefe38, 1, TRUE, MUX_PRIM,
		{D3DTOP_MODULATE, D3DTA_TFACTOR, D3DTA_TEXTURE,
		 D3DTOP_MODULATE, D3DTA_TEXTURE, D3DTA_TFACTOR}},

	// aRGB0: (Prim         - 0           ) * Texel0       + 0
	// aA0  : (Texel0       - 0           ) * Primitive    + 0
	// aRGB1: (0            - 0           ) * 0            + Combined
	// aA1  : (0            - 0           ) * 0            + Combined
	{0x003097fffffffe38, 1, TRUE, MUX_PRIM,
		{D3DTOP_MODULATE, D3DTA_TFACTOR, D3DTA_TEXTURE,
		 D3DTOP_MODULATE, D3DTA_TEXTURE, D3DTA_TFACTOR}},


	// Added by StrmnNrmn - incorrect (needs Prim/Env)
	// aRGB0: (Prim         - Environment ) * Texel0       + Environment
	// aA0  : (Primitive    - 0           ) * Texel0       + 0
	// aRGB1: (Combined     - 0           ) * Shade        + 0
	// aA1  : (0            - 0           ) * 0            + Combined
	{0x0030b2045ffefff8, 2, TRUE, MUX_PRIM, {
		{D3DTOP_MODULATE, D3DTA_TFACTOR, D3DTA_TEXTURE,
		 D3DTOP_MODULATE, D3DTA_TEXTURE, D3DTA_TFACTOR},
		{D3DTOP_MODULATE, D3DTA_CURRENT, D3DTA_DIFFUSE,
		 D3DTOP_SELECTARG1, D3DTA_CURRENT, D3DTA_IGNORE}}},

	// Incorrect? - I think this is as close as we can get
	// aRGB0: (Prim         - Shade       ) * Texel0       + Shade
	// aA0  : (Primitive    - Shade       ) * Texel0       + Shade
	// aRGB1: (Prim         - Shade       ) * Texel0       + Shade
	// aA1  : (Primitive    - Shade       ) * Texel0       + Shade
	{0x0030b26144664924, 1, TRUE, MUX_0,
		{D3DTOP_ADDSMOOTH, D3DTA_TEXTURE, D3DTA_DIFFUSE,
		 D3DTOP_ADDSMOOTH, D3DTA_TEXTURE, D3DTA_DIFFUSE}},


	// Added by StrmnNrmn - Incorrect at moment (need env and prim)
	// aRGB0: (Prim         - Environment ) * Texel0       + Environment
	// aA0  : (Primitive    - 0           ) * Texel0       + 0
	// aRGB1: (Prim         - Environment ) * Texel0       + Environment
	// aA1  : (Primitive    - 0           ) * Texel0       + 0
	{0x0030b2615566ff7f, 1, TRUE, MUX_PRIM,
		{D3DTOP_MODULATE, D3DTA_TFACTOR, D3DTA_TEXTURE,
		 D3DTOP_MODULATE, D3DTA_TFACTOR, D3DTA_TEXTURE}},

	// Added by StrmnNrmn
	// aRGB0: (Prim         - 0           ) * Texel0       + 0
	// aA0  : (Primitive    - 0           ) * Texel0       + 0
	// aRGB1: (0            - 0           ) * 0            + Combined
	// aA1  : (0            - 0           ) * 0            + Combined
	{0x0030b3fffffffe38, 1, TRUE, MUX_PRIM,
		{D3DTOP_MODULATE, D3DTA_TFACTOR, D3DTA_TEXTURE,
		 D3DTOP_MODULATE, D3DTA_TFACTOR, D3DTA_TEXTURE}},

	// aRGB0: (Prim         - 0           ) * Shade        + 0
	// aA0  : (Texel0       - 0           ) * Primitive    + 0
	// aRGB1: (0            - 0           ) * 0            + Combined
	// aA1  : (0            - 0           ) * 0            + Combined
	{0x003217fffffffe38, 1, TRUE, MUX_PRIM,
		{D3DTOP_MODULATE, D3DTA_TFACTOR, D3DTA_DIFFUSE,
		 D3DTOP_MODULATE, D3DTA_TFACTOR, D3DTA_TEXTURE}},

	// aRGB0: (Prim         - 0           ) * Shade        + 0
	// aA0  : (Primitive    - 0           ) * Shade        + 0
	// aRGB1: (Prim         - 0           ) * Shade        + 0
	// aA1  : (Primitive    - 0           ) * Shade        + 0
	{0x00323864ff73ffff, 1, TRUE, MUX_PRIM,
		{D3DTOP_MODULATE, D3DTA_TFACTOR, D3DTA_DIFFUSE,
		 D3DTOP_MODULATE, D3DTA_TFACTOR, D3DTA_DIFFUSE}},

	// aRGB0: (Prim         - 0           ) * Shade        + 0
	// aA0  : (0            - 0           ) * 0            + Shade
	// aRGB1: (Prim         - 0           ) * Shade        + 0
	// aA1  : (0            - 0           ) * 0            + Shade
	{0x00327e64fffff9fc, 1, TRUE, MUX_PRIM,
		{D3DTOP_MODULATE, D3DTA_TFACTOR, D3DTA_DIFFUSE,
		 D3DTOP_SELECTARG1, D3DTA_DIFFUSE, D3DTA_IGNORE}},

	// aRGB0: (Prim         - 0           ) * Shade        + 0
	// aA0  : (0            - 0           ) * 0            + Texel0
	// aRGB1: (0            - 0           ) * 0            + Combined
	// aA1  : (0            - 0           ) * 0            + Combined
	{0x00327ffffffff238, 1, TRUE, MUX_PRIM,
		{D3DTOP_MODULATE, D3DTA_DIFFUSE, D3DTA_TFACTOR,
		 D3DTOP_SELECTARG1, D3DTA_TEXTURE, D3DTA_IGNORE}},

	// aRGB0: (Prim         - 0           ) * Shade        + 0
	// aA0  : (0            - 0           ) * 0            + Primitive
	// aRGB1: (0            - 0           ) * 0            + Combined
	// aA1  : (0            - 0           ) * 0            + Combined
	{0x00327ffffffff638, 1, TRUE, MUX_PRIM,
		{D3DTOP_MODULATE, D3DTA_DIFFUSE, D3DTA_TFACTOR,
		 D3DTOP_SELECTARG1, D3DTA_TFACTOR, D3DTA_IGNORE}},

	// aRGB0: (Prim         - 0           ) * Shade        + 0
	// aA0  : (0            - 0           ) * 0            + 1
	// aRGB1: (0            - 0           ) * 0            + Combined
	// aA1  : (0            - 0           ) * 0            + Combined
	{0x00327ffffffffc38, 1, FALSE, MUX_PRIM,
		{D3DTOP_MODULATE, D3DTA_DIFFUSE, D3DTA_TFACTOR,
		 D3DTOP_DISABLE, D3DTA_IGNORE, D3DTA_IGNORE}},

	// aRGB0: (Shade        - 0           ) * Texel0       + 0
	// aA0  : (Texel0       - 0           ) * Primitive    + 0
	// aRGB1: (Combined     - 0           ) * Primitive    + 0
	// aA1  : (0            - 0           ) * 0            + Combined
	{0x00409603fffffff8, 2, TRUE, MUX_PRIM, {
		{D3DTOP_MODULATE, D3DTA_DIFFUSE, D3DTA_TEXTURE,
		 D3DTOP_MODULATE, D3DTA_TEXTURE, D3DTA_TFACTOR},
		{D3DTOP_MODULATE, D3DTA_CURRENT, D3DTA_TFACTOR,
		 D3DTOP_DISABLE, D3DTA_IGNORE, D3DTA_IGNORE}}},

	// aRGB0: (Shade        - 0           ) * Texel0       + 0
	// aA0  : (Texel0       - 0           ) * Environment  + 0
	// aRGB1: (0            - 0           ) * 0            + Combined
	// aA1  : (0            - 0           ) * 0            + Combined
	{0x00409bfffffffe38, 1, TRUE, MUX_ENV,
		{D3DTOP_MODULATE, D3DTA_DIFFUSE, D3DTA_TEXTURE,
		 D3DTOP_MODULATE, D3DTA_TEXTURE, D3DTA_TFACTOR}},

	// aRGB0: (Shade        - 0           ) * Texel0       + 0
	// aA0  : (0            - 0           ) * 0            + Texel0
	// aRGB1: (Shade        - 0           ) * Texel0       + 0
	// aA1  : (0            - 0           ) * 0            + Texel0
	{0x0040fe81fffff3f9, 1, TRUE, MUX_0,
		{D3DTOP_MODULATE, D3DTA_DIFFUSE, D3DTA_TEXTURE,
		 D3DTOP_SELECTARG1, D3DTA_TEXTURE, D3DTA_IGNORE}},

	// aRGB0: (Shade        - 0           ) * Texel0       + 0
	// aA0  : (0            - 0           ) * 0            + Texel0
	// aRGB1: (0            - 0           ) * 0            + Combined
	// aA1  : (0            - 0           ) * 0            + Combined
	{0x0040fffffffff238, 1, TRUE, MUX_0, 
		{D3DTOP_MODULATE, D3DTA_DIFFUSE, D3DTA_TEXTURE,
		 D3DTOP_SELECTARG1, D3DTA_TEXTURE, D3DTA_IGNORE}},

	// aRGB0: (Shade        - 0           ) * Texel0       + 0
	// aA0  : (0            - 0           ) * 0            + Texel0
	// aRGB1: (0            - 0           ) * 0            + Combined
	// aA1  : (0            - 0           ) * 0            + Texel0
	{0x0040fffffffff239, 1, TRUE, MUX_0,
		{D3DTOP_MODULATE, D3DTA_DIFFUSE, D3DTA_TEXTURE,
		 D3DTOP_SELECTARG1, D3DTA_TEXTURE, D3DTA_IGNORE}},

	// aRGB0: (Shade        - 0           ) * Texel0       + 0
	// aA0  : (0            - 0           ) * 0            + Environment
	// aRGB1: (0            - 0           ) * 0            + Combined
	// aA1  : (0            - 0           ) * 0            + Environment
	{0x0040fffffffffa3d, 1, TRUE, MUX_ENV,
		{D3DTOP_MODULATE, D3DTA_DIFFUSE, D3DTA_TEXTURE,
		 D3DTOP_SELECTARG1, D3DTA_TFACTOR, D3DTA_IGNORE}},
		
	// aRGB0: (Shade        - 0           ) * Primitive    + 0
	// aA0  : (Shade        - 0           ) * Primitive    + 0
	// aRGB1: (Shade        - 0           ) * Primitive    + 0
	// aA1  : (Shade        - 0           ) * Primitive    + 0
	{0x0041c683ff8fffff, 1, TRUE, MUX_PRIM,
		{D3DTOP_MODULATE, D3DTA_DIFFUSE, D3DTA_TFACTOR,
		 D3DTOP_MODULATE, D3DTA_DIFFUSE, D3DTA_TFACTOR}},

	// aRGB0: (Shade        - 0           ) * Primitive    + 0
	// aA0  : (0            - 0           ) * 0            + 1
	// aRGB1: (0            - 0           ) * 0            + Combined
	// aA1  : (0            - 0           ) * 0            + Combined
	{0x0041fffffffffc38, 1, FALSE, MUX_PRIM,
		{D3DTOP_MODULATE, D3DTA_DIFFUSE, D3DTA_TFACTOR,
		 D3DTOP_DISABLE, D3DTA_IGNORE, D3DTA_IGNORE}},

	// aRGB0: (Shade        - 0           ) * Environment  + 0
	// aA0  : (Shade        - 0           ) * Environment  + 0
	// aRGB1: (Shade        - 0           ) * Environment  + 0
	// aA1  : (Shade        - 0           ) * Environment  + 0
	{0x0042ca85ff97ffff, 1, TRUE, MUX_ENV,
		{D3DTOP_MODULATE, D3DTA_DIFFUSE, D3DTA_TFACTOR,
		 D3DTOP_MODULATE, D3DTA_DIFFUSE, D3DTA_TFACTOR}},

	// VERY INCORRECT - used in Waverace
	// aRGB0: (Environment  - Texel0      ) * Env_Alpha    + Texel0
	// aA0  : (0            - 0           ) * 0            + Texel0
	// aRGB1: (Environment  - Texel0      ) * Env_Alpha    + Texel0
	// aA1  : (0            - 0           ) * 0            + Texel0
	{0x00567eac11fcf279, 1, TRUE, MUX_ENV,
		{D3DTOP_SUBTRACT, D3DTA_TFACTOR, D3DTA_TEXTURE,
		 D3DTOP_SELECTARG1, D3DTA_TEXTURE, D3DTA_IGNORE}},

	// aRGB0: (1            - 0           ) * Primitive    + 0
	// aA0  : (Texel0       - 0           ) * Primitive    + 0
	// aRGB1: (1            - 0           ) * Primitive    + 0
	// aA1  : (Texel0       - 0           ) * Primitive    + 0
	{0x006196c3ff2fffff, 1, TRUE, MUX_PRIM,
		{D3DTOP_SELECTARG1, D3DTA_TFACTOR, D3DTA_IGNORE,
		 D3DTOP_MODULATE, D3DTA_TEXTURE, D3DTA_TFACTOR}},

	// aRGB0: (1            - 0           ) * 0            + Shade
	// aA0  : (Texel0       - 0           ) * Primitive    + 0
	// aRGB1: (1            - 0           ) * 0            + Shade
	// aA1  : (Texel0       - 0           ) * Primitive    + 0
	{0x006f96dfff2e7f3f, 1, TRUE, MUX_PRIM,
		{D3DTOP_SELECTARG1, D3DTA_DIFFUSE, D3DTA_IGNORE,
		 D3DTOP_MODULATE, D3DTA_TEXTURE, D3DTA_TFACTOR}},

	// aRGB0: (0            - 0           ) * 0            + Primitive
	// aA0  : (Texel0       - 0           ) * Primitive    + 0
	// aRGB1: (Combined     - 0           ) * Shade        + 0
	// aA1  : (0            - 0           ) * 0            + Combined
	{0x00ff9604fffdfff8, 1, TRUE, MUX_PRIM,
		{D3DTOP_MODULATE, D3DTA_TFACTOR, D3DTA_DIFFUSE,
		 D3DTOP_MODULATE, D3DTA_TEXTURE, D3DTA_TFACTOR}},

	// aRGB0: (0            - 0           ) * 0            + Texel0
	// aA0  : (Texel0       - 0           ) * Primitive    + 0
	// aRGB1: (0            - 0           ) * 0            + Texel0
	// aA1  : (Texel0       - 0           ) * Primitive    + 0
	{0x00ff97ffff2cfe7f, 1, TRUE, MUX_PRIM,
		{D3DTOP_SELECTARG1, D3DTA_TEXTURE, D3DTA_IGNORE,
		 D3DTOP_MODULATE, D3DTA_TEXTURE, D3DTA_TFACTOR}},

	// aRGB0: (0            - 0           ) * 0            + Primitive
	// aA0  : (Texel0       - 0           ) * Primitive    + 0
	// aRGB1: (0            - 0           ) * 0            + Primitive
	// aA1  : (Texel0       - 0           ) * Primitive    + 0
	{0x00ff97ffff2dfeff, 1, TRUE, MUX_PRIM,
		{D3DTOP_SELECTARG1, D3DTA_TFACTOR, D3DTA_IGNORE,
		 D3DTOP_MODULATE, D3DTA_TEXTURE, D3DTA_TFACTOR}},

	// aRGB0: (0            - 0           ) * 0            + Shade
	// aA0  : (Texel0       - 0           ) * Primitive    + 0
	// aRGB1: (0            - 0           ) * 0            + Shade
	// aA1  : (Texel0       - 0           ) * Primitive    + 0
	{0x00ff97ffff2e7f3f, 1, TRUE, MUX_PRIM,
		{D3DTOP_SELECTARG1, D3DTA_DIFFUSE, D3DTA_IGNORE,
		 D3DTOP_MODULATE, D3DTA_TEXTURE, D3DTA_TFACTOR}},

	// aRGB0: (0            - 0           ) * 0            + Primitive
	// aA0  : (Texel0       - 0           ) * Primitive    + 0
	// aRGB1: (0            - 0           ) * 0            + Combined
	// aA1  : (0            - 0           ) * 0            + Combined
	{0x00ff97fffffdfe38, 1, TRUE, MUX_PRIM,
		{D3DTOP_SELECTARG1, D3DTA_TFACTOR, D3DTA_IGNORE,
		 D3DTOP_MODULATE, D3DTA_TEXTURE, D3DTA_TFACTOR}},

	// aRGB0: (0            - 0           ) * 0            + Shade
	// aA0  : (Texel0       - 0           ) * Shade        + 0
	// aRGB1: (0            - 0           ) * 0            + Shade
	// aA1  : (Texel0       - 0           ) * Shade        + 0
	{0x00ff99ffff327f3f, 1, TRUE, MUX_0,
		{D3DTOP_SELECTARG1, D3DTA_DIFFUSE, D3DTA_IGNORE,
		 D3DTOP_MODULATE, D3DTA_TEXTURE, D3DTA_DIFFUSE}},

	// aRGB0: (0            - 0           ) * 0            + Texel0
	// aA0  : (Texel0       - 0           ) * Environment  + 0
	// aRGB1: (0            - 0           ) * 0            + Texel0
	// aA1  : (Texel0       - 0           ) * Environment  + 0
	{0x00ff9bffff34fe7f, 1, TRUE, MUX_ENV,
		{D3DTOP_SELECTARG1, D3DTA_TEXTURE, D3DTA_IGNORE,
		 D3DTOP_MODULATE, D3DTA_TEXTURE, D3DTA_TFACTOR}},

	// aRGB0: (0            - 0           ) * 0            + Environment
	// aA0  : (Texel0       - 0           ) * Environment  + 0
	// aRGB1: (0            - 0           ) * 0            + Environment
	// aA1  : (Texel0       - 0           ) * Environment  + 0
	{0x00ff9bffff36ff7f, 1, TRUE, MUX_ENV,
		{D3DTOP_SELECTARG1, D3DTA_TFACTOR, D3DTA_IGNORE,
		 D3DTOP_MODULATE, D3DTA_TEXTURE, D3DTA_TFACTOR}},

	// aRGB0: (0            - 0           ) * 0            + Texel0
	// aA0  : (Environment  - 0           ) * Texel0       + 0
	// aRGB1: (0            - 0           ) * 0            + Texel0
	// aA1  : (Environment  - 0           ) * Texel0       + 0
	{0x00ffd3ffffa4fe7f, 1, TRUE, MUX_ENV,
		{D3DTOP_SELECTARG1, D3DTA_TEXTURE, D3DTA_IGNORE,
		 D3DTOP_MODULATE, D3DTA_TEXTURE, D3DTA_TFACTOR}},

	// aRGB0: (0            - 0           ) * 0            + Shade
	// aA0  : (0            - 0           ) * 0            + Shade
	// aRGB1: (Combined     - 0           ) * Environment  + 0
	// aA1  : (Combined     - 0           ) * Environment  + 0
	{0x00fffe05ff1679ff, 1, TRUE, MUX_ENV,
		{D3DTOP_MODULATE, D3DTA_DIFFUSE, D3DTA_TFACTOR,
		 D3DTOP_MODULATE, D3DTA_DIFFUSE, D3DTA_TFACTOR}},

	// aRGB0: (0            - 0           ) * 0            + Shade
	// aA0  : (0            - 0           ) * 0            + 1
	// aRGB1: (Combined     - 0           ) * Environment  + 0
	// aA1  : (Combined     - 0           ) * Environment  + 0
	{0x00fffe05ff167dff, 1, TRUE, MUX_ENV,
		{D3DTOP_MODULATE, D3DTA_DIFFUSE, D3DTA_TFACTOR,
		 D3DTOP_SELECTARG1, D3DTA_TFACTOR, D3DTA_IGNORE}},

	// aRGB0: (0            - 0           ) * 0            + Texel0
	// aA0  : (0            - 0           ) * 0            + Texel0
	// aRGB1: (Prim         - 0           ) * Combined     + 0
	// aA1  : (0            - 0           ) * 0            + Combined
	{0x00fffe60fffcf3f8, 1, TRUE, MUX_PRIM,
		{D3DTOP_MODULATE, D3DTA_TEXTURE, D3DTA_TFACTOR,
		 D3DTOP_SELECTARG1, D3DTA_TEXTURE, D3DTA_IGNORE}},

	// aRGB0: (0            - 0           ) * 0            + Texel0
	// aA0  : (0            - 0           ) * 0            + Texel0
	// aRGB1: (0            - 0           ) * 1            + Texel0
	// aA1  : (0            - 0           ) * 0            + Texel0
	{0x00ffffe6fffcf279, 1, TRUE, MUX_0,
		{D3DTOP_SELECTARG1, D3DTA_TEXTURE, D3DTA_IGNORE,
		 D3DTOP_SELECTARG1, D3DTA_TEXTURE, D3DTA_IGNORE}},

	// aRGB0: (0            - 0           ) * 0            + Texel0
	// aA0  : (0            - 0           ) * 0            + Environment
	// aRGB1: (0            - 0           ) * 1            + Texel0
	// aA1  : (0            - 0           ) * 0            + Environment
	{0x00ffffe6fffcfa7d, 1, TRUE, MUX_ENV,
		{D3DTOP_SELECTARG1, D3DTA_TEXTURE, D3DTA_IGNORE,
		 D3DTOP_SELECTARG1, D3DTA_TFACTOR, D3DTA_IGNORE}},

	// aRGB0: (0            - 0           ) * 0            + Environment
	// aA0  : (0            - 0           ) * 0            + Environment
	// aRGB1: (0            - 0           ) * 1            + Environment
	// aA1  : (0            - 0           ) * 0            + Environment
	{0x00ffffe6fffefb7d, 1, TRUE, MUX_ENV,
		{D3DTOP_SELECTARG1, D3DTA_TFACTOR, D3DTA_IGNORE,
		 D3DTOP_SELECTARG1, D3DTA_TFACTOR, D3DTA_IGNORE}},

	// Added by StrmnNrmn
	// aRGB0: (0            - 0           ) * 0            + Primitive
	// aA0  : (0            - 0           ) * 0            + Primitive
	// aRGB1: (0            - 0           ) * 0            + Combined
	// aA1  : (Combined     - 0           ) * Texel1       + 0
	{0x00ffffffff09f63f, 1, TRUE, MUX_PRIM,
		{D3DTOP_SELECTARG1, D3DTA_TFACTOR, D3DTA_IGNORE,
		 D3DTOP_MODULATE,   D3DTA_TEXTURE, D3DTA_TFACTOR}},
		

	// aRGB0: (0            - 0           ) * 0            + Texel0
	// aA0  : (0            - 0           ) * 0            + Texel0
	// aRGB1: (0            - 0           ) * 0            + Combined
	// aA1  : (0            - 0           ) * 0            + Combined
	{0x00fffffffffcf238, 1, TRUE, MUX_0,
		{D3DTOP_SELECTARG1, D3DTA_TEXTURE, D3DTA_IGNORE,
		 D3DTOP_SELECTARG1, D3DTA_TEXTURE, D3DTA_IGNORE}},

	// aRGB0: (0            - 0           ) * 0            + Texel0
	// aA0  : (0            - 0           ) * 0            + Texel0
	// aRGB1: (0            - 0           ) * 0            + Texel0
	// aA1  : (0            - 0           ) * 0            + Texel0
	{0x00fffffffffcf279, 1, TRUE, MUX_0,
		{D3DTOP_SELECTARG1, D3DTA_TEXTURE, D3DTA_IGNORE,
		 D3DTOP_SELECTARG1, D3DTA_TEXTURE, D3DTA_IGNORE}},

	// aRGB0: (0            - 0           ) * 0            + Texel0
	// aA0  : (0            - 0           ) * 0            + Shade
	// aRGB1: (0            - 0           ) * 0            + Combined
	// aA1  : (0            - 0           ) * 0            + Combined
	{0x00fffffffffcf838, 1, TRUE, MUX_0,
		{D3DTOP_SELECTARG1, D3DTA_TEXTURE, D3DTA_IGNORE,
		 D3DTOP_SELECTARG1, D3DTA_DIFFUSE, D3DTA_IGNORE}},

	// aRGB0: (0            - 0           ) * 0            + Texel0
	// aA0  : (0            - 0           ) * 0            + Shade
	// aRGB1: (0            - 0           ) * 0            + Texel0
	// aA1  : (0            - 0           ) * 0            + Shade
	{0x00fffffffffcf87c, 1, TRUE, MUX_0,
		{D3DTOP_SELECTARG1, D3DTA_TEXTURE, D3DTA_IGNORE,
		 D3DTOP_SELECTARG1, D3DTA_DIFFUSE, D3DTA_IGNORE}},
	
	// aRGB0: (0            - 0           ) * 0            + Texel0
	// aA0  : (0            - 0           ) * 0            + Environment
	// aRGB1: (0            - 0           ) * 0            + Texel0
	// aA1  : (0            - 0           ) * 0            + Environment
	{0x00fffffffffcfa7d, 1, TRUE, MUX_ENV,
		{D3DTOP_SELECTARG1, D3DTA_TEXTURE, D3DTA_IGNORE,
		 D3DTOP_SELECTARG1, D3DTA_TFACTOR, D3DTA_IGNORE}},

	// aRGB0: (0            - 0           ) * 0            + Texel0
	// aA0  : (0            - 0           ) * 0            + 1
	// aRGB1: (0            - 0           ) * 0            + Texel0
	// aA1  : (0            - 0           ) * 0            + 1
	{0x00fffffffffcfc7e, 1, FALSE, MUX_0,
		{D3DTOP_SELECTARG1, D3DTA_TEXTURE, D3DTA_IGNORE,
		 D3DTOP_DISABLE, D3DTA_IGNORE, D3DTA_IGNORE}},

	// Alpha of zero?
	// aRGB0: (0            - 0           ) * 0            + Texel0
	// aA0  : (0            - 0           ) * 0            + 0
	// aRGB1: (0            - 0           ) * 0            + Texel0
	// aA1  : (0            - 0           ) * 0            + 0
	{0x00fffffffffcfe7f, 1, FALSE, MUX_0,
		{D3DTOP_SELECTARG1, D3DTA_TEXTURE, D3DTA_IGNORE,
		 D3DTOP_DISABLE, D3DTA_IGNORE, D3DTA_IGNORE}},

	// aRGB0: (0            - 0           ) * 0            + Primitive
	// aA0  : (0            - 0           ) * 0            + Texel0
	// aRGB1: (0            - 0           ) * 0            + Primitive
	// aA1  : (0            - 0           ) * 0            + Texel0
	{0x00fffffffffdf2f9, 1, TRUE, MUX_PRIM,
		{D3DTOP_SELECTARG1, D3DTA_TFACTOR, D3DTA_IGNORE,
		 D3DTOP_SELECTARG1, D3DTA_TEXTURE, D3DTA_IGNORE}},

	// aRGB0: (0            - 0           ) * 0            + Primitive
	// aA0  : (0            - 0           ) * 0            + Primitive
	// aRGB1: (0            - 0           ) * 0            + Combined
	// aA1  : (0            - 0           ) * 0            + Combined
	{0x00fffffffffdf638, 1, TRUE, MUX_PRIM,
		{D3DTOP_SELECTARG1, D3DTA_TFACTOR, D3DTA_IGNORE,
		 D3DTOP_SELECTARG1, D3DTA_TFACTOR, D3DTA_IGNORE}},

	// aRGB0: (0            - 0           ) * 0            + Primitive
	// aA0  : (0            - 0           ) * 0            + Primitive
	// aRGB1: (0            - 0           ) * 0            + Primitive
	// aA1  : (0            - 0           ) * 0            + Primitive
	{0x00fffffffffdf6fb, 1, TRUE, MUX_PRIM,
		{D3DTOP_SELECTARG1, D3DTA_TFACTOR, D3DTA_IGNORE,
		 D3DTOP_SELECTARG1, D3DTA_TFACTOR, D3DTA_IGNORE}},

	// aRGB0: (0            - 0           ) * 0            + Primitive
	// aA0  : (0            - 0           ) * 0            + Shade
	// aRGB1: (0            - 0           ) * 0            + Primitive
	// aA1  : (0            - 0           ) * 0            + Shade
	{0x00fffffffffdf8fc, 1, TRUE, MUX_PRIM,
		{D3DTOP_SELECTARG1, D3DTA_TFACTOR, D3DTA_IGNORE,
		 D3DTOP_SELECTARG1, D3DTA_DIFFUSE, D3DTA_IGNORE}},

	// aRGB0: (0            - 0           ) * 0            + Primitive
	// aA0  : (0            - 0           ) * 0            + 1
	// aRGB1: (0            - 0           ) * 0            + Combined
	// aA1  : (0            - 0           ) * 0            + Combined
	{0x00fffffffffdfc38, 1, FALSE, MUX_PRIM,
		{D3DTOP_SELECTARG1, D3DTA_TFACTOR, D3DTA_IGNORE,
		 D3DTOP_DISABLE, D3DTA_IGNORE, D3DTA_IGNORE}},

	// aRGB0: (0            - 0           ) * 0            + Primitive
	// aA0  : (0            - 0           ) * 0            + 1
	// aRGB1: (0            - 0           ) * 0            + Primitive
	// aA1  : (0            - 0           ) * 0            + 1
	{0x00fffffffffdfcfe, 1, FALSE, MUX_PRIM,
		{D3DTOP_SELECTARG1, D3DTA_TFACTOR, D3DTA_IGNORE,
		 D3DTOP_DISABLE, D3DTA_IGNORE, D3DTA_IGNORE}},

	// aRGB0: (0            - 0           ) * 0            + Shade
	// aA0  : (0            - 0           ) * 0            + Texel0
	// aRGB1: (0            - 0           ) * 0            + Shade
	// aA1  : (0            - 0           ) * 0            + Texel0
	{0x00fffffffffe7339, 1, TRUE, MUX_0,
		{D3DTOP_SELECTARG1, D3DTA_DIFFUSE, D3DTA_IGNORE,
		 D3DTOP_SELECTARG1, D3DTA_TEXTURE, D3DTA_IGNORE}},

 	// aRGB0: (0            - 0           ) * 0            + Shade
	// aA0  : (0            - 0           ) * 0            + Primitive
	// aRGB1: (0            - 0           ) * 0            + Combined
	// aA1  : (0            - 0           ) * 0            + Combined
	{0x00fffffffffe7638, 1, TRUE, MUX_PRIM,
		{D3DTOP_SELECTARG1, D3DTA_DIFFUSE, D3DTA_IGNORE,
		 D3DTOP_SELECTARG1, D3DTA_TFACTOR, D3DTA_IGNORE}},

	// aRGB0: (0            - 0           ) * 0            + Shade
	// aA0  : (0            - 0           ) * 0            + Primitive
	// aRGB1: (0            - 0           ) * 0            + Shade
	// aA1  : (0            - 0           ) * 0            + Primitive
	{0x00fffffffffe773b, 1, TRUE, MUX_PRIM,
		{D3DTOP_SELECTARG1, D3DTA_DIFFUSE, D3DTA_IGNORE,
		 D3DTOP_SELECTARG1, D3DTA_TFACTOR, D3DTA_IGNORE}},


	// Added by StrmnNrmn
	// aRGB0: (0            - 0           ) * 0            + Shade
	// aA0  : (0            - 0           ) * 0            + Shade
	// aRGB1: (0            - 0           ) * 0            + Combined
	// aA1  : (0            - 0           ) * 0            + Combined
	{0x00fffffffffe7838, 1, TRUE, MUX_0,
		{D3DTOP_SELECTARG1, D3DTA_DIFFUSE, D3DTA_IGNORE,
		 D3DTOP_SELECTARG1, D3DTA_DIFFUSE, D3DTA_IGNORE}},


	// aRGB0: (0            - 0           ) * 0            + Shade
	// aA0  : (0            - 0           ) * 0            + Shade
	// aRGB1: (0            - 0           ) * 0            + Shade
	// aA1  : (0            - 0           ) * 0            + Shade
	{0x00fffffffffe793c, 1, TRUE, MUX_0,
		{D3DTOP_SELECTARG1, D3DTA_DIFFUSE, D3DTA_IGNORE,
		 D3DTOP_SELECTARG1, D3DTA_DIFFUSE, D3DTA_IGNORE}},

	// aRGB0: (0            - 0           ) * 0            + Shade
	// aA0  : (0            - 0           ) * 0            + Environment
	// aRGB1: (0            - 0           ) * 0            + Shade
	// aA1  : (0            - 0           ) * 0            + Environment
	{0x00fffffffffe7b3d, 1, TRUE, MUX_ENV,
		{D3DTOP_SELECTARG1, D3DTA_DIFFUSE, D3DTA_IGNORE,
		 D3DTOP_SELECTARG1, D3DTA_TFACTOR, D3DTA_IGNORE}},

	// aRGB0: (0            - 0           ) * 0            + Shade
	// aA0  : (0            - 0           ) * 0            + 1
	// aRGB1: (0            - 0           ) * 0            + Combined
	// aA1  : (0            - 0           ) * 0            + Combined
	{0x00fffffffffe7c38, 1, FALSE, MUX_0,
		{D3DTOP_SELECTARG1, D3DTA_DIFFUSE, D3DTA_IGNORE,
		 D3DTOP_DISABLE, D3DTA_IGNORE, D3DTA_IGNORE}},

	// aRGB0: (0            - 0           ) * 0            + Shade
	// aA0  : (0            - 0           ) * 0            + 1
	// aRGB1: (0            - 0           ) * 0            + Shade
	// aA1  : (0            - 0           ) * 0            + 1
	{0x00fffffffffe7d3e, 1, FALSE, MUX_0,
		{D3DTOP_SELECTARG1, D3DTA_DIFFUSE, D3DTA_IGNORE,
		 D3DTOP_DISABLE, D3DTA_IGNORE, D3DTA_IGNORE}},

	// aRGB0: (0            - 0           ) * 0            + Environment
	// aA0  : (0            - 0           ) * 0            + Texel0
	// aRGB1: (0            - 0           ) * 0            + Combined
	// aA1  : (0            - 0           ) * 0            + Combined
	{0x00fffffffffef238, 1, TRUE, MUX_ENV,
		{D3DTOP_SELECTARG1, D3DTA_TFACTOR, D3DTA_IGNORE,
		 D3DTOP_SELECTARG1, D3DTA_TEXTURE, D3DTA_IGNORE}},

	// aRGB0: (0            - 0           ) * 0            + Environment
	// aA0  : (0            - 0           ) * 0            + Environment
	// aRGB1: (0            - 0           ) * 0            + Environment
	// aA1  : (0            - 0           ) * 0            + Environment
	{0x00fffffffffefb7d, 1, TRUE, MUX_ENV,
		{D3DTOP_SELECTARG1, D3DTA_TFACTOR, D3DTA_IGNORE,
		 D3DTOP_SELECTARG1, D3DTA_TFACTOR, D3DTA_IGNORE}},

	// aRGB0: (0            - 0           ) * 0            + 1
	// aA0  : (0            - 0           ) * 0            + Texel0
	// aRGB1: (0            - 0           ) * 0            + 1
	// aA1  : (0            - 0           ) * 0            + Texel0
	{0x00ffffffffff73b9, 1, TRUE, MUX_1,
		{D3DTOP_SELECTARG1, D3DTA_TFACTOR, D3DTA_IGNORE,
		 D3DTOP_SELECTARG1, D3DTA_TEXTURE, D3DTA_IGNORE}},
		

	// Default
	SCENTRY_DEFAULT(~0)

};
/*
#define NUM_SCINFO		41
static SetCombineInfo	g_SCInfo[NUM_SCINFO] =
{

	// TEXEL0, TEXEL1, PRIM, TEXEL1 0,0,0,1 -- COMBINED STUFF	
	// NEEDS FIXING	
	SCENTRY_NOALPHA(0x0011ffff2ffd7c38, TEXTURE, TFACTOR )


	// T0,0,0,0  0,0,0,1  COMB, 0, PRIM, 0     0,0,0,COMB
	SCENTRY_NOALPHA(0x00127e03fffffdf8, TEXTURE, TFACTOR )


	// TEXEL0, PRIM,SHADE,PRIM  0,0,0,SHADE -- Used in Wetrix, incorrect at mo
	// Special cased below
	SCENTRY_SELECTALPHA(0x00127e2433fdf8fc, TEXTURE, DIFFUSE,
											   DIFFUSE )


	// Spiderman - doesn't work unless it's not modulated - probably the t0/t1 stuff
    //RGB0: (Texel0       - 0           ) * Shade        + 0           
    //A0  : (0            - 0           ) * 0            + Texel0      
    //RGB1: (Texel1       - 0           ) * Shade        + Combined    
    //A1  : (0            - 0           ) * 0            + Combined  
//	SCENTRY_SELECTCOLALP(0x00127e44fffff238, TEXTURE, /*DIFFUSE,* /
//											   TEXTURE )

	SCENTRY_SELECTALPHA(0x00127e44fffff238, TEXTURE, DIFFUSE,     TEXTURE )
	//SCENTRY(0x00127e44fffff238, TEXTURE, DIFFUSE,     TEXTURE, DIFFUSE )


	// Tony Hawk
    //        aRGB0: (Texel0       - 0           ) * Shade        + 0
    //        aA0  : (0            - 0           ) * 0            + Texel0
    //        aRGB1: (Texel1       - 0           ) * Shade        + Combined
    //        aA1  : (0            - 0           ) * 0            + 0
	SCENTRY_SELECTALPHA(0x00127e44fffff23f, TEXTURE, DIFFUSE,    TEXTURE)


	// TEXEL0,0,SHADE,0, 0,0,0,TEXEL0 Starfox, Aeroguage
	// Same as below, but uses texel for alpha and not shade
	// This seems to fuck up - I think d3d is using the rgb values for the alpha,
	// and not the texture alpha?
	//SCENTRY_SELECTALPHA(0x00127fff, 0xfffff238, TEXTURE, DIFFUSE,
	//										   TEXTURE )
	SCENTRY_NOALPHA(0x00127ffffffff238, TEXTURE, DIFFUSE)

	// TEXEL0, PRIM, ENV, PRIM  TEXEL0, 0, PRIM, 0	
	// NEEDS FIXING - Env and Prim!
	SCENTRY_SELECTCOLALP(0x00129625332dfeff, TEXTURE,
												   TEXTURE )

	// TEXEL0,SHADE,TEXEL0_ALPHA,SHADE, 0,0,0,ENVIRONMENT		
	// Need to add shade....								   
	SCENTRY_COLOP_SELECTALP(0x00147e2844fe7b3d, BLENDTEXTUREALPHA, TEXTURE, DIFFUSE, 
													 TFACTOR )

	// Uses Shade_Alpha etc T0, ENV, SHADE_ALPHA, ENV, 
	// NEEDS FIXING?
	SCENTRY_COLOP_SELECTALP(0x001598045ffedbf8, BLENDDIFFUSEALPHA, TEXTURE, TFACTOR,
													 TEXTURE )

	// TEXEL0, PRIM, ENVALPHA, PRIM 0,0,0,PRIM		
	// NEEDS FIXING
	SCENTRY_SELECTALPHA(0x00167e2c33fdf6fb, TEXTURE, TFACTOR,
													 TEXTURE )
		
	// Zelda - incorrect!!
	// T0,PRIM,ENV_A,T0   0,0,0,0    PRIM,ENV,COMB,ENV     PRIM,ENV,COMB,ENV, 0,0,0,1
	SCENTRY_NOALPHA(0x00167e6035fcff7e, TEXTURE, TFACTOR )


	//SetCombine: Unknown Mux: Mux0=0x00167fff Mux1=0xfffcf238
	// Spiderman
    //aRGB0: (Texel0       - 0           ) * Env_Alpha    + Texel0
    //aA0  : (0            - 0           ) * 0            + Texel0
	SCENTRY_COLOP_SELECTALP(0x00167ffffffcf238, BLENDFACTORALPHA, TEXTURE, TFACTOR,
													 TEXTURE )




	// Texel0 Texel0 LOD_Fraction Texel0  Alpha: Texel0, Texel0, LOD_Fraction Texel0 || Funky combined cycle2 stuff modulates with primitive
	// NEEDS FIXING
	SCENTRY(0x001690031f0c93ff, TEXTURE, TFACTOR,
									TEXTURE, TFACTOR )


	// Zelda - incorrect
	// T1, PRIM, ENV_A, T0   0,0,0,T0      PRIM,ENV,COMB,ENV   COMB,0,PRIM,0
	SCENTRY_SELECTALPHA(0x00267e60350cf37f, TEXTURE, TFACTOR,
									           TEXTURE )


	// See comments above. Uses TEXEL1 (Tetrisphere)
	// Think this is right now
	SCENTRY(0x0026a0041f0c93ff, TEXTURE, DIFFUSE,
									TEXTURE, TFACTOR )

	// See comments above. Uses TEXEL1
	// NEEDS FIXING
	SCENTRY(0x0026a0041f1093fb, TEXTURE, DIFFUSE,
									TEXTURE, DIFFUSE )	// And add prim!

	// See comments above. Uses TEXEL1
	// NEEDS FIXING - might be ok
	SCENTRY_SELECTCOL1_NOALPHA(0x0026a0041f1093ff, TEXTURE)//,
								//	TEXTURE )


	// See comments above. Uses TEXEL1
	// NEEDS FIXING
	SCENTRY(0x0026a0041f1493ff, TEXTURE, DIFFUSE,
									TEXTURE, TFACTOR )

	//CYRUS64-SFRUSH-WIP (In-game)
	// T1,T0,LODFrac,T0  T1,T0,LODFrac,T0
	// Comb,0,SHADE,0  0,0,0,ENV
	SCENTRY(0x0026a0041ffc93f8, TEXTURE, DIFFUSE,
									TEXTURE, TFACTOR)

	// See comments above. Uses TEXEL1
	// NEEDS FIXING
	SCENTRY_SELECTALPHA(0x0026a0041ffc93fc, TEXTURE, DIFFUSE, DIFFUSE )

	// Goldeneye - Needs fixing
	// T1,T0,LODFrac,T0  T1,T0,LODFrac,T0
	// Comb,0,SHADE,0  0,0,0,ENV
	SCENTRY_SELECTALPHA(0x0026a0041ffc93fd, TEXTURE, DIFFUSE, TFACTOR )


	// Goldeneye - Ok now?
	// TEXEL1, TEXEL0, PRIM_LOD_FRACTION, TEXEL0   TEXEL1, TEXEL0, PRIM_LOD_FRACTION, TEXEL0
	// Combined,0,SHADE,0  COMBINED,0,SHADE,0
	SCENTRY(0x00272c041f1093ff, TEXTURE, DIFFUSE,
									TEXTURE, DIFFUSE )




	// PRIMITIVE,ENVIRONMENT,TEXEL0,ENVIRONMENT,   TEXEL0,0,PRIMITIVE,0
	// Incorrect at the moment - 
	//  needs to mulitpass?  -- MarioKart
	SCENTRY(0x00309661552eff7f, TEXTURE, TFACTOR, TEXTURE, TFACTOR )


	// Spiderman - incorrect
	//aRGB0: (Prim - Environment) * Texel0        + Environment
    //aA0  : (Texel0) * Shade
	SCENTRY(0x003099ff5ffefe38, TEXTURE, TFACTOR,
								    TEXTURE, DIFFUSE)

	// G_CC_HILITERGBA - Mario's Head										   
	//         PRIMITIVE,SHADE,TEXEL0,SHADE,  PRIMITIVE,SHADE,TEXEL0,SHADE
	// Incorrect at the moment - 
	//  needs to modulate Prim/Shad using Texel0?
	//SCENTRY_SELECTCOLALP(0x0030b26144664924, DIFFUSE,
	//											   DIFFUSE ) 

	{ 0x0030b26144664924, TRUE, 1,
				{D3DTOP_ADD, D3DTA_TEXTURE, D3DTA_DIFFUSE,
				 D3DTOP_ADD, D3DTA_TEXTURE, D3DTA_DIFFUSE} },


	// Spiderman - incorrect
    //        aRGB0: (Prim         - Environment ) * Texel0       + Environment
    //        aA0  : (Primitive    - Environment ) * Texel0       + Environment
    //        aRGB1: (0            - 0           ) * 0            + Combined
    //        aA1  : (0            - 0           ) * 0            + Combined
	SCENTRY(0x0030b3ff5ffeda38, TEXTURE, TFACTOR, TEXTURE, TFACTOR)




	//CYRUS64-SFRUSH-COMPLETE (Menu text displays)
	// PRIM, ENV, TEXEL0, ENV, 0, 0, 0, TEXEL0
	SCENTRY_SELECTCOLALP(0x0030fe6155fef379, TEXTURE,
											   TEXTURE/*, TFACTOR* /)

			

    //        aRGB0: (Prim         - Environment ) * Texel1       + Environment
    //        aA0  : (Primitive    - Environment ) * Texel1       + Environment
    //        aRGB1: (0            - 0           ) * 0            + Combined
    //        aA1  : (Combined     - 0           ) * Texel1       + 0
	SCENTRY_SELECTCOLALP(0x003135ff5f0ada3f, TEXTURE, TEXTURE)

	// ENV,PRIM,TEXEL1,PRIM  TEXEL0,0,PRIM,0 -- Extreme G intro
	SCENTRY_SELECTCOL(0x005117ff3ffdfe38, TEXTURE,
											   TEXTURE, TFACTOR)


	// WAVERACE - Needs fixing
	// ENV,T0,ENV_A,T0  0,0,0,T0 * 2
	SCENTRY_SELECTALPHA(0x00567eac11fcf279, TEXTURE, TFACTOR,
									           TEXTURE )   


	// 1,ENVIRONMENT,TEXEL0,PRIMITIVE,  PRIMITIVE,0,TEXEL0,0 -- MarioKart
	SCENTRY_SELECTCOL(0x0060b2c15565feff, TEXTURE,
											   TEXTURE, TFACTOR )


	// Spiderman - Incorrect
    //        aRGB0: (1            - Environment ) * Texel0       + Environment
    //        aA0  : (0            - 0           ) * 0            + Texel0
    //        aRGB1: (0            - 0           ) * 0            + Combined
    //        aA1  : (0            - 0           ) * 0            + Combined
	SCENTRY_SELECTALPHA(0x0060ffff5ffef238, TEXTURE, TFACTOR,    TEXTURE)


	// Spiderman - Incorrect
    //        aRGB0: (CombAlp      - 0           ) * Environment  + 0
    //        aA0  : (0            - 0           ) * 0            + 1
    //        aRGB1: (Combined     - Texel1      ) * Combined     + Texel1
    //        aA1  : (0            - 0           ) * 0            + Combined
	SCENTRY_NOALPHA(0x0072fe00f2fffcb8, TEXTURE, TFACTOR)


	// 0,0,0,TEXEL0, TEXEL0,0,ENVIRONMENT,0	
	SCENTRY_SELECTCOL(0x00ff9bffff34fe7f, TEXTURE,
											   TEXTURE, TFACTOR )

	//CYRUS64-SFRUSH-WIP (In-game)
	// 0,0,0,T0,  T1,T0,ENV,T0
	SCENTRY_SELECTCOLALP(0x00FFABfffffc9238, TEXTURE,
											   TEXTURE)





    //        aRGB0: (0            - 0           ) * 0            + Texel0
    //        aA0  : (0            - 0           ) * 0            + Texel0
    //        aRGB1: (Texel1       - 0           ) * Shade        + Combined
    //        aA1  : (0            - 0           ) * 0            + Combined
	// T0 + T1 * SHADE
	SCENTRY_SELECTCOLALP(0x00fffe44fffcf238, TEXTURE, TEXTURE)


    //        aRGB0: (0            - 0           ) * 0            + Texel0
    //        aA0  : (0            - 0           ) * 0            + 1
    //        aRGB1: (Texel1       - 0           ) * Shade        + Combined
    //        aA1  : (0            - 0           ) * 0            + Combined
	SCENTRY_SELECTCOL1_NOALPHA(0x00fffe44fffcfc38, TEXTURE)


	// Incorrect
    //        aRGB0: (0            - 0           ) * 0            + Primitive
    //        aA0  : (0            - 0           ) * 0            + Texel0
    //        aRGB1: (Texel1       - 0           ) * Shade        + Combined
    //        aA1  : (0            - 0           ) * 0            + Combined
	SCENTRY_SELECTCOLALP(0x00fffe44fffdf238, TFACTOR, TEXTURE)


	// Tony Hawk menus
    //        RGB0: (0            - 0           ) * 0            + Primitive   
    //        A0  : (0            - 0           ) * 0            + Primitive   
    //        RGB1: (0            - 0           ) * 0            + Combined    
    //        A1  : (Combined     - 0           ) * Texel1       + 0           
	SCENTRY_SELECTCOL(0x00ffffffff09f63f, TEXTURE, TEXTURE, TFACTOR)


	// 0,0,0,TEXEL0, 0,0,0,PRIMITIVE -- Used by Quake	
	SCENTRY_SELECTCOLALP(0x00FFFFFFfffcf67b, TEXTURE, TFACTOR )



	// Default
	SCENTRY_DEFAULT(~0)

};
*/


static BOOL FindCombineMode(u64 mux, SetCombineInfo & sci)
{
	//Perform a binary search to find the correct mux
	DWORD dwMin = 0;
	DWORD dwMax = (NUM_SCINFO - 1)-1; // Remember, last entry is default values
	DWORD index;
	BOOL bFound;
	LONG i;

	index = ~0;


	while (TRUE)
	{
		DWORD dwRange = dwMax - dwMin;
		DWORD dwIndex = dwMin + (dwRange/2);

		if (g_SCInfo[dwIndex].mux == mux)
		{
			index = dwIndex;
			break;
		}

		// If the range is 0, and we didn't match above, then it must be unmatched
		if (dwRange == 0) 
			break;

		// If lower, check from min..index
		// If higher, check from index..max
		if (mux < g_SCInfo[dwIndex].mux)
		{
			// Lower
			//dwMin = dwMin;
			dwMax = dwIndex;
		}
		else
		{
			// Higher
			dwMin = dwIndex + 1;
			//dwMax = dwMax;
		}
	}

	// Search in g_GeneratedMux
	bFound = FALSE;
	/*for (i = 0; i < g_GeneratedMux.size(); i++)
	{
		if (g_GeneratedMux[i].mux == mux)
		{
			sci = g_GeneratedMux[i];
			bFound = TRUE;
			break;
		}
	}
	if (!bFound)
	{
		bFound = AssessMux(mux, sci);
		if (bFound)
		{
			g_GeneratedMux.push_back(sci);
		}

	}*/

	// Onlyreturn this mux if it is not already in the override table
	if (bFound)
	{
		if (index == ~0)
		{
			// Return this sc info
			return TRUE;
		}
	}




	if (index == ~0)
	{	
		bFound = FALSE;

		// See if we've come across this unknown mux before:
		for (i = 0; i < g_UnkMux.size(); i++)
		{
			if (mux == g_UnkMux[i])
			{
				bFound = TRUE;
				break;
			}
		}

		if (!bFound)
		{
			DWORD dwMux0 = (DWORD)(mux>>32);
			DWORD dwMux1 = (DWORD)(mux);
			
			DWORD aRGB0  = (dwMux0>>20)&0x0F;	// c1 c1		// a0
			DWORD bRGB0  = (dwMux1>>28)&0x0F;	// c1 c2		// b0
			DWORD cRGB0  = (dwMux0>>15)&0x1F;	// c1 c3		// c0
			DWORD dRGB0  = (dwMux1>>15)&0x07;	// c1 c4		// d0

			DWORD aA0    = (dwMux0>>12)&0x07;	// c1 a1		// Aa0
			DWORD bA0    = (dwMux1>>12)&0x07;	// c1 a2		// Ab0
			DWORD cA0    = (dwMux0>>9 )&0x07;	// c1 a3		// Ac0
			DWORD dA0    = (dwMux1>>9 )&0x07;	// c1 a4		// Ad0

			DWORD aRGB1  = (dwMux0>>5 )&0x0F;	// c2 c1		// a1
			DWORD bRGB1  = (dwMux1>>24)&0x0F;	// c2 c2		// b1
			DWORD cRGB1  = (dwMux0    )&0x1F;	// c2 c3		// c1
			DWORD dRGB1  = (dwMux1>>6 )&0x07;	// c2 c4		// d1
			
			DWORD aA1    = (dwMux1>>21)&0x07;	// c2 a1		// Aa1
			DWORD bA1    = (dwMux1>>3 )&0x07;	// c2 a2		// Ab1
			DWORD cA1    = (dwMux1>>18)&0x07;	// c2 a3		// Ac1
			DWORD dA1    = (dwMux1    )&0x07;	// c2 a4		// Ad1

			DBGConsole_Msg(0, "SetCombine: Unknown Mux: Mux0=0x%08x%08x", dwMux0, dwMux1);

			DBGConsole_Msg(0, "            aRGB0: (%s - %s) * %s + %s", sc_colcombtypes16[aRGB0], sc_colcombtypes16[bRGB0], sc_colcombtypes32[cRGB0], sc_colcombtypes8[dRGB0]);		
			DBGConsole_Msg(0, "            aA0  : (%s - %s) * %s + %s", sc_colcombtypes8[aA0], sc_colcombtypes8[bA0], sc_colcombtypes8[cA0], sc_colcombtypes8[dA0]);
			DBGConsole_Msg(0, "            aRGB1: (%s - %s) * %s + %s", sc_colcombtypes16[aRGB1], sc_colcombtypes16[bRGB1], sc_colcombtypes32[cRGB1], sc_colcombtypes8[dRGB1]);		
			DBGConsole_Msg(0, "            aA1  : (%s - %s) * %s + %s", sc_colcombtypes8[aA1],  sc_colcombtypes8[bA1], sc_colcombtypes8[cA1],  sc_colcombtypes8[dA1]);

			// Add to table of unknown muxs
			g_UnkMux.push_back(mux);
		}

		return FALSE;
	}

	sci = g_SCInfo[index];

	return TRUE;
}	


D3DRender::D3DRender() :
	m_pD3DDev(NULL),

	m_fScreenMultX(2.0f),
	m_fScreenMultY(2.0f),

	m_dwProjectionTop(0),
	m_dwModelViewTop(0),
		
	m_dwNumStages(0),

	m_dwAmbientLight(D3DRGBA(255,255,255,255)),
	m_dwTextureFactor(D3DRGBA(255,255,255,255)),

	m_bCullFront(FALSE),
	m_bCullBack(TRUE),

	m_dwShadeMode(D3DSHADE_GOURAUD),

	m_bTextureEnable(FALSE),
	m_bLightingEnable(FALSE),
	m_dwNumLights(0),
	
	m_bZBuffer(FALSE),
	m_bZUpdate(FALSE),
	m_bZCompare(FALSE),

	m_dwrsZEnable(D3DZB_FALSE),
	m_dwrsZWriteEnable(FALSE),
	
	m_dwTexturePerspective(FALSE),
	m_bAlphaTestEnable(FALSE),

	m_dwAlpha(0xFF),

	m_lpsTexture(NULL),
	m_dwTileWidth(64),		// Value doesn't really matter, as tex not set
	m_dwTileHeight(64),
	m_fTexWidth(64.0f),		// Value doesn't really matter, as tex not set
	m_fTexHeight(64.0f),
	m_fTexScaleX(1.0f),
	m_fTexScaleY(1.0f),

	m_bTextureGen(FALSE),
	m_bZModeDecal(FALSE),


	m_dwNumVertices(0),

	m_fFogMult(0.0f),			// * 0 + 0 = 0
	m_fFogOffset(0.0f),
	m_bFogEnable(FALSE),
	m_dwFogColor(0x00FFFFFF)
	
{
	//D3DXMATRIX m_mProjection;
	//D3DXMATRIX m_mModelView[10];

	DWORD i;
	for (i = 0; i < 8; i++)
	{
		m_TSSInfo[i].dwColorOp = D3DTOP_MODULATE;
		m_TSSInfo[i].dwColorArg1 = D3DTA_TEXTURE;
		m_TSSInfo[i].dwColorArg2 = D3DTA_DIFFUSE;
		m_TSSInfo[i].dwAlphaOp = D3DTOP_MODULATE;
		m_TSSInfo[i].dwAlphaArg1 = D3DTA_TEXTURE;
		m_TSSInfo[i].dwAlphaArg2 = D3DTA_DIFFUSE;

		m_TSSInfo[i].dwMinFilter = D3DTFN_LINEAR;
		m_TSSInfo[i].dwMagFilter = D3DTFG_LINEAR;

		m_TSSInfo[i].dwAddressUMode = D3DTADDRESS_WRAP;
		m_TSSInfo[i].dwAddressVMode = D3DTADDRESS_WRAP;
	}



	
}

D3DRender::~D3DRender()
{	
	if (m_lpsTexture)		// We keep a reference to the most recently selected texture
	{
		m_pD3DDev->SetTexture( 0, NULL );
		m_lpsTexture->Release();
		m_lpsTexture = NULL;
	}

	SAFE_RELEASE(m_pD3DDev);
}
	

HRESULT
D3DRender::Initialize()
{
	LPDIRECT3DDEVICE7 pD3DDev;

	SAFE_RELEASE(m_pD3DDev);

	// Grab a copy of the d3d device - lock the context while we addref
	g_GfxContext.Lock();

		pD3DDev = g_GfxContext.GetD3DDev();
		if (pD3DDev != NULL)
			pD3DDev->AddRef();

	g_GfxContext.Unlock();

	if (pD3DDev == NULL)
		return E_POINTER;
	
	m_pD3DDev = pD3DDev;

	// We never change these

	// No longer Needed for mario menu screen
	//m_pD3DDev->SetRenderState( D3DRENDERSTATE_LASTPIXEL, TRUE);
	//m_pD3DDev->SetRenderState(D3DRENDERSTATE_FILLMODE, D3DFILL_WIREFRAME );
	m_pD3DDev->SetRenderState( D3DRENDERSTATE_DITHERENABLE, TRUE ); // Re-enabled by Orkin - Makes 16-bit look nicer
	//m_pD3DDev->SetRenderState( D3DRENDERSTATE_SPECULARENABLE, FALSE );


	//m_pD3DDev->SetRenderState( D3DRENDERSTATE_CLIPPING,   FALSE);

	// We do our own culling
	m_pD3DDev->SetRenderState( D3DRENDERSTATE_CULLMODE,   D3DCULL_NONE );

	// We do our own lighting
	m_pD3DDev->SetRenderState(  D3DRENDERSTATE_AMBIENT, RGB_MAKE(255,255,255) );
	m_pD3DDev->SetRenderState( D3DRENDERSTATE_LIGHTING,	  FALSE);


	m_pD3DDev->SetRenderState( D3DRENDERSTATE_ALPHABLENDENABLE, TRUE );
	m_pD3DDev->SetRenderState( D3DRENDERSTATE_SRCBLEND,   D3DBLEND_SRCALPHA);
	m_pD3DDev->SetRenderState( D3DRENDERSTATE_DESTBLEND,  D3DBLEND_INVSRCALPHA);

	m_pD3DDev->SetRenderState( D3DRENDERSTATE_ZFUNC, D3DCMP_LESSEQUAL);
	

	// Initialise all the renderstate to our defaults.
	m_pD3DDev->SetRenderState( D3DRENDERSTATE_SHADEMODE,  m_dwShadeMode );
	m_pD3DDev->SetRenderState(D3DRENDERSTATE_TEXTUREFACTOR, m_dwTextureFactor );

	m_pD3DDev->SetRenderState( D3DRENDERSTATE_FOGCOLOR, m_dwFogColor ); 
	//m_pD3DDev->SetRenderState (D3DRENDERSTATE_FOGVERTEXMODE, D3DFOG_LINEAR );
        
	// Dafault is ZBuffer disabled
	m_pD3DDev->SetRenderState( D3DRENDERSTATE_ZENABLE,      m_dwrsZEnable );
	m_pD3DDev->SetRenderState( D3DRENDERSTATE_ZWRITEENABLE, m_dwrsZWriteEnable );

	m_pD3DDev->SetRenderState( D3DRENDERSTATE_TEXTUREPERSPECTIVE , m_dwTexturePerspective );
	
	//m_pD3DDev->SetRenderState( D3DRENDERSTATE_ALPHATESTENABLE, m_bAlphaTestEnable );
	//m_pD3DDev->SetRenderState(D3DRENDERSTATE_ALPHAREF, m_dwAlpha);
    m_pD3DDev->SetRenderState( D3DRENDERSTATE_ALPHATESTENABLE, TRUE );
    m_pD3DDev->SetRenderState( D3DRENDERSTATE_ALPHAREF,        0x04 );
    m_pD3DDev->SetRenderState( D3DRENDERSTATE_ALPHAFUNC, D3DCMP_GREATEREQUAL );

	// Texturing stuff
	// Thanks Lkb
	for(int n = 0; n < 8; n++) 
	{ 
		// Texturing stuff 
		m_pD3DDev->SetTextureStageState( n, D3DTSS_MINFILTER, m_TSSInfo[n].dwMinFilter ); 
		m_pD3DDev->SetTextureStageState( n, D3DTSS_MAGFILTER, m_TSSInfo[n].dwMagFilter ); 
		
		m_pD3DDev->SetTextureStageState( n, D3DTSS_ADDRESSU, m_TSSInfo[n].dwAddressUMode ); 
		m_pD3DDev->SetTextureStageState( n, D3DTSS_ADDRESSV, m_TSSInfo[n].dwAddressVMode ); 
		
		if(n == 0) 
		{ 
			m_pD3DDev->SetTextureStageState( n, D3DTSS_COLORARG1, m_TSSInfo[n].dwColorArg1 ); 
			m_pD3DDev->SetTextureStageState( n, D3DTSS_COLORARG2, m_TSSInfo[n].dwColorArg2 ); 
			m_pD3DDev->SetTextureStageState( n, D3DTSS_COLOROP, m_TSSInfo[n].dwColorOp ); 
			m_pD3DDev->SetTextureStageState( n, D3DTSS_ALPHAARG1, m_TSSInfo[n].dwAlphaArg1 ); 
			m_pD3DDev->SetTextureStageState( n, D3DTSS_ALPHAARG2, m_TSSInfo[n].dwAlphaArg2 ); 
			m_pD3DDev->SetTextureStageState( n, D3DTSS_ALPHAOP, m_TSSInfo[n].dwAlphaOp ); 
		} 
		else 
		{ 
			m_pD3DDev->SetTextureStageState( n, D3DTSS_COLOROP, D3DTOP_DISABLE ); 
			m_pD3DDev->SetTextureStageState( n, D3DTSS_ALPHAOP, D3DTOP_DISABLE ); 
		} 
	} 

	return S_OK;	
}








void D3DRender::InitBlendMode()
{
	// if (m_bBlendModeValid) return;
	static BOOL bChecked = FALSE;

	// Perform a quick test to ensure the table is correctly ordered
	if (!bChecked)
	{
		LONG i;
		u64 muxlast = g_SCInfo[0].mux;
		u64 mux;

		for (i = 1; i < NUM_SCINFO; i++)
		{
			mux = g_SCInfo[i].mux;
			if (mux <= muxlast)
			{
				CHAR str[300];
				wsprintf(str, "Warning, g_SCInfo table is not ordered: %08x%08x",
					(u32)(mux>>32), (u32)mux);
				MessageBox(NULL, str, g_szDaedalusName, MB_OK);
				break;
			}
			muxlast = mux;
		}
		bChecked = TRUE;
	}
	
	//g_bHiliteRGBAHack = FALSE;


	if ((m_dwCycleType << G_MDSFT_CYCLETYPE) == G_CYC_COPY)
	{		
		DL_PF("CycleType: Copy");

		m_pD3DDev->SetTextureStageState( 1, D3DTSS_COLOROP,   D3DTOP_DISABLE );
		m_pD3DDev->SetTextureStageState( 1, D3DTSS_ALPHAOP,   D3DTOP_DISABLE );

		m_pD3DDev->SetRenderState( D3DRENDERSTATE_ALPHABLENDENABLE,   TRUE);
		m_pD3DDev->SetRenderState( D3DRENDERSTATE_ALPHATESTENABLE,   TRUE);
		
		SetNumStages(0);

		m_pD3DDev->SetTexture( 0, m_lpsTexture );


		SetColorOp( 0, D3DTOP_SELECTARG1 );
		SetColorArg1( 0, D3DTA_TEXTURE );

		SetAlphaOp( 0, D3DTOP_SELECTARG1 );
		SetAlphaArg1( 0, D3DTA_TEXTURE );
	}	
	else if ((m_dwCycleType << G_MDSFT_CYCLETYPE) == G_CYC_FILL)
	{
		m_pD3DDev->SetTextureStageState( 1, D3DTSS_COLOROP,   D3DTOP_DISABLE );
		m_pD3DDev->SetTextureStageState( 1, D3DTSS_ALPHAOP,   D3DTOP_DISABLE );

		DL_PF("CycleType: Fill");

		m_pD3DDev->SetRenderState( D3DRENDERSTATE_ALPHABLENDENABLE,   TRUE);
		m_pD3DDev->SetRenderState( D3DRENDERSTATE_ALPHATESTENABLE,   TRUE);
		
		SetNumStages(0);

		m_pD3DDev->SetTexture( 0, NULL );

		SetColorOp( 0, D3DTOP_SELECTARG2 );
		SetColorArg2( 0, D3DTA_DIFFUSE );

		SetAlphaOp( 0, D3DTOP_SELECTARG2 );
		SetAlphaArg2( 0, D3DTA_DIFFUSE );
	}



	else if ((m_dwCycleType << G_MDSFT_CYCLETYPE) == G_CYC_1CYCLE ||
		     (m_dwCycleType << G_MDSFT_CYCLETYPE) == G_CYC_2CYCLE)
	{
		if ((m_dwCycleType << G_MDSFT_CYCLETYPE) == G_CYC_1CYCLE)
		{
			DL_PF("CycleType: 1");
		}
		else
		{
			DL_PF("CycleType: 2");
		}

		/*else if (mux == 0x0030b26144664924)
		{
			g_bHiliteRGBAHack = TRUE;
		}*/
		
		{
			SetCombineInfo sci;

			BOOL bFound = FindCombineMode(m_Mux, sci);
			
			if (!bFound)
			{
				m_pD3DDev->SetTextureStageState( 1, D3DTSS_COLOROP,   D3DTOP_DISABLE );
				m_pD3DDev->SetTextureStageState( 1, D3DTSS_ALPHAOP,   D3DTOP_DISABLE );

				m_pD3DDev->SetRenderState( D3DRENDERSTATE_ALPHABLENDENABLE, TRUE);
				m_pD3DDev->SetRenderState( D3DRENDERSTATE_ALPHATESTENABLE, TRUE);
			
				// Set to defaults
				SetNumStages(0);

				m_pD3DDev->SetTexture( 0, m_lpsTexture );

				SetColorOp( 0, D3DTOP_MODULATE );
				SetColorArg1( 0, D3DTA_TEXTURE );
				SetColorArg2( 0, D3DTA_DIFFUSE );

				SetAlphaOp( 0, D3DTOP_MODULATE );
				SetAlphaArg1( 0, D3DTA_TEXTURE );
				SetAlphaArg2( 0, D3DTA_DIFFUSE );
			}
			else // Redone by Orkin - allows for multiple texture stages
			{
				//SetNumStages(sci.nStages); - don't need this anymore

				m_pD3DDev->SetRenderState( D3DRENDERSTATE_ALPHABLENDENABLE, sci.bAlphaEnabled);
				m_pD3DDev->SetRenderState( D3DRENDERSTATE_ALPHATESTENABLE, sci.bAlphaEnabled);

				// Allows a combine mode to select what TFACTOR should be
				switch (sci.TFactor)
				{
					case MUX_0:
						SetTextureFactor(RGBA_MAKE(0, 0, 0, 0));
						break;
					case MUX_1:
						SetTextureFactor(RGBA_MAKE(1, 1, 1, 1));
						break;
					case MUX_PRIM:
						SetTextureFactor(m_dwPrimitiveColor);
						break;
					case MUX_ENV:
						SetTextureFactor(m_dwEnvColor);
						break;
				}

				for (int i = 0; i < sci.nStages; i++)
				{
					m_pD3DDev->SetTextureStageState( i, D3DTSS_COLOROP,   sci.stages[i].dwColorOp );
					m_pD3DDev->SetTextureStageState( i, D3DTSS_ALPHAOP,   sci.stages[i].dwAlphaOp );

					m_pD3DDev->SetTexture( i, m_lpsTexture );

					SetColorOp( i, sci.stages[i].dwColorOp );
					SetColorArg1( i, sci.stages[i].dwColorArg1 );
					SetColorArg2( i, sci.stages[i].dwColorArg2 );

					if (sci.bAlphaEnabled)
					{
						SetAlphaOp( i, sci.stages[i].dwAlphaOp );
						SetAlphaArg1( i, sci.stages[i].dwAlphaArg1 );
						SetAlphaArg2( i, sci.stages[i].dwAlphaArg2 );
					}
				}
				// Cap off the texture stages
				m_pD3DDev->SetTextureStageState( sci.nStages, D3DTSS_COLOROP,   D3DTOP_DISABLE );
				m_pD3DDev->SetTextureStageState( sci.nStages, D3DTSS_ALPHAOP,   D3DTOP_DISABLE );
			}


			/*else 
			{
				SetNumStages(0);

				m_pD3DDev->SetTexture( 0, m_lpsTexture );		

				SetColorOp( 0, sci.stages[0].dwColorOp );
				SetColorArg1( 0, sci.stages[0].dwColorArg1 );
				SetColorArg2( 0, sci.stages[0].dwColorArg2 );

				if (sci.bAlphaEnabled)
				{
					m_pD3DDev->SetRenderState( D3DRENDERSTATE_ALPHABLENDENABLE, TRUE);
					m_pD3DDev->SetRenderState( D3DRENDERSTATE_ALPHATESTENABLE, TRUE);
			
					SetAlphaOp( 0, sci.stages[0].dwAlphaOp );
					SetAlphaArg1( 0, sci.stages[0].dwAlphaArg1 );
					SetAlphaArg2( 0, sci.stages[0].dwAlphaArg2 );
				}
				else
				{
					m_pD3DDev->SetRenderState( D3DRENDERSTATE_ALPHABLENDENABLE, FALSE);
					m_pD3DDev->SetRenderState( D3DRENDERSTATE_ALPHATESTENABLE, FALSE);
				}
			}*/
		}
	}

}




#define DAEDALUSFVF_TEXRECTVERTEX ( D3DFVF_XYZRHW | /*D3DFVF_DIFFUSE |*/ D3DFVF_TEX1 )
 typedef struct _TEXRECTVERTEX {
	D3DVALUE x,y,z;
	D3DVALUE rhw;
	D3DVALUE  tu, tv;
} TEXRECTVERTEX, *LPTEXRECTVERTEX;


HRESULT
D3DRender::TexRect(LONG nX0, LONG nY0, LONG nX1, LONG nY1,
				   float fS0, float fT0, float fS1, float fT1)
{

	HRESULT hr;
	
	// Save ZBuffer state
	BOOL bZEnabled = m_bZBuffer;
	DWORD dwMinFilter = m_TSSInfo[0].dwMinFilter;
	DWORD dwMagFilter = m_TSSInfo[0].dwMagFilter;
	
	ZBufferEnable( FALSE );

	// Mariokart hack to make bg on main screen work well
	// Can do this or just clamp values
	SetMinFilter(0, D3DTFN_POINT);
	SetMagFilter(0, D3DTFG_POINT);

	// Goldeneye HACK
	if (nY1 - nY0 < 2) nY1 = nY1+2;

	float fTexULX;
	float fTexLRX;
	float fTexULY;
	float fTexLRY;

	// Scale to Actual texture coords
	// The two cases are to handle the oversized textures hack on voodoos
	if ((float)m_dwTileWidth > (float)m_fTexWidth)
	{
		fTexULX = (fS0 / (float)(m_dwTileWidth-0));
		fTexLRX = (fS1 / (float)(m_dwTileWidth-0));
	}
	else
	{
		fTexULX = (fS0 / (float)(m_fTexWidth-0));
		fTexLRX = (fS1 / (float)(m_fTexWidth-0));
	}

	if ((float)m_dwTileHeight > (float)m_fTexHeight)
	{
		fTexULY = (fT0 / (float)(m_dwTileHeight-0));
		fTexLRY = (fT1 / (float)(m_dwTileHeight-0));
	}
	else
	{
		fTexULY = (fT0 / (float)(m_fTexHeight-0));
		fTexLRY = (fT1 / (float)(m_fTexHeight-0));
	}
	

	DL_PF("  %f,%f -> %f,%f", fTexULX, fTexULY, fTexLRX, fTexLRY);

	TEXRECTVERTEX trv[4];

	trv[0].x = (float)nX0*m_fScreenMultX;
	trv[0].y = (float)nY0*m_fScreenMultY;
	trv[0].tu = fTexULX;
	trv[0].tv = fTexULY;

	trv[1].x = (float)nX1*m_fScreenMultX;
	trv[1].y = (float)nY0*m_fScreenMultY;
	trv[1].tu = fTexLRX;
	trv[1].tv = fTexULY;

	trv[2].x = (float)nX1*m_fScreenMultX;
	trv[2].y = (float)nY1*m_fScreenMultY;
	trv[2].tu = fTexLRX;
	trv[2].tv = fTexLRY;

	trv[3].x = (float)nX0*m_fScreenMultX;
	trv[3].y = (float)nY1*m_fScreenMultY;
	trv[3].tu = fTexULX;
	trv[3].tv = fTexLRY;

	trv[0].z = trv[1].z = trv[2].z = trv[3].z = 1.0f;
	trv[0].rhw = trv[1].rhw = trv[2].rhw = trv[3].rhw = 1.0f;

	WORD wIndices[2*3] = {1,0,2, 2,0,3};

	InitBlendMode();

	hr = m_pD3DDev->DrawIndexedPrimitive(
		D3DPT_TRIANGLELIST,
		DAEDALUSFVF_TEXRECTVERTEX,			// Vertex type
		trv,4,
		wIndices, 6, 0);

	// Restore state
	ZBufferEnable( bZEnabled );
	SetMinFilter(0, dwMinFilter);
	SetMagFilter(0, dwMagFilter);

	return hr;
	
}

#define DAEDALUSFVF_TEXRECTFVERTEX ( D3DFVF_XYZRHW | /*D3DFVF_DIFFUSE |*/ D3DFVF_TEX1 )
 typedef struct _TEXRECTFVERTEX {
	D3DVALUE x,y,z;
	D3DVALUE rhw;
	//D3DCOLOR  dcDiffuse;
	D3DVALUE  tu, tv;
} TEXRECTFVERTEX, *LPTEXRECTFVERTEX;


HRESULT
D3DRender::TexRectFlip(LONG nX0, LONG nY0, LONG nX1, LONG nY1,
					   float fS0, float fT0, float fS1, float fT1)
{

	HRESULT hr;
	
	// Save ZBuffer state
	BOOL bZEnabled = m_bZBuffer;
		
	ZBufferEnable( FALSE );


	float tu0 = fS0 / (float)m_dwTileWidth;
	float tv0 = fT0 / (float)m_dwTileHeight;

	float tu1 = fS1 / (float)m_dwTileWidth;
	float tv1 = fT1 / (float)m_dwTileHeight;

	// TODO - In 1/2cycle mode, skip bottom/right edges!?

	const float fTexULX = tu0 * (float)m_dwTileWidth / m_fTexWidth;		// Scale to PowerOf2 coords!
	const float fTexULY = tv0 * (float)m_dwTileHeight / m_fTexHeight;

	const float fTexLRX = tu1 * (float)m_dwTileWidth / m_fTexWidth;
	const float fTexLRY = tv1 * (float)m_dwTileHeight / m_fTexHeight;

	TEXRECTFVERTEX trv[4];

	// Same as TexRect, but with texcoords 0,2 swapped
	trv[0].x = (float)nX0*m_fScreenMultX;
	trv[0].y = (float)nY0*m_fScreenMultY;
	trv[0].tu = fTexULX;
	trv[0].tv = fTexULY;
	
	trv[1].x = (float)nX1*m_fScreenMultX;
	trv[1].y = (float)nY0*m_fScreenMultY;
	trv[1].tu = fTexULX;		// In TexRect this is LRX
	trv[1].tv = fTexLRY;		//                    ULY

	trv[2].x = (float)nX1*m_fScreenMultX;
	trv[2].y = (float)nY1*m_fScreenMultY;
	trv[2].tu = fTexLRX;
	trv[2].tv = fTexLRY;
	
	trv[3].x = (float)nX0*m_fScreenMultX;
	trv[3].y = (float)nY1*m_fScreenMultY;
	trv[3].tu = fTexLRX;		//					ULX
	trv[3].tv = fTexULY;		//					LRY


	
	trv[0].z = trv[1].z = trv[2].z = trv[3].z = 1.0f;
	trv[0].rhw = trv[1].rhw = trv[2].rhw = trv[3].rhw = 1.0f;

	WORD wIndices[2*3] = {1,0,2, 2,0,3};

	InitBlendMode();

	hr = m_pD3DDev->DrawIndexedPrimitive(
		D3DPT_TRIANGLELIST,
		DAEDALUSFVF_TEXRECTFVERTEX,			// Vertex type
		trv,4,
		wIndices, 6, 0);

	// Restore state
	ZBufferEnable( bZEnabled );

	return hr;
}


#define DAEDALUSFVF_FILLRECTVERTEX ( D3DFVF_XYZRHW | D3DFVF_DIFFUSE  )
 typedef struct _FILLRECTVERTEX {
	D3DVALUE x,y,z;
	D3DVALUE rhw;
	D3DCOLOR  dcDiffuse;
} FILLRECTVERTEX, *LPFILLRECTVERTEX;

HRESULT
D3DRender::FillRect(LONG nX0, LONG nY0, LONG nX1, LONG nY1, DWORD dwColor)
{
	HRESULT hr;

	// Save ZBuffer state
	BOOL bZEnabled = m_bZBuffer;

	ZBufferEnable( FALSE );
	
	//g_Renderer->SetCullMode(D3DCULL_NONE);

	float fx0 = (float)nX0 * m_fScreenMultX;
	float fx1 = (float)nX1 * m_fScreenMultX;
	float fy0 = (float)nY0 * m_fScreenMultY;
	float fy1 = (float)nY1 * m_fScreenMultY;


	// Divide by 2 instead of 4, because screen is magnified by two
	FILLRECTVERTEX frv[4] = {   {fx0, fy0, -1, 1, dwColor},
								{fx1, fy0, -1, 1, dwColor},
								{fx1, fy1, -1, 1, dwColor},
								{fx0, fy1, -1, 1, dwColor}  };

	static WORD wIndices[2*3] = {1,0,2, 2,0,3};

	InitBlendMode();

	hr = m_pD3DDev->DrawIndexedPrimitive(
		D3DPT_TRIANGLELIST,
		DAEDALUSFVF_FILLRECTVERTEX,
		frv,4,
		wIndices, 6, 0);

	// Restore ZBuffer state
	ZBufferEnable( bZEnabled );
	
	return hr;
}




		/*if (g_hRDPDumpHandle != INVALID_HANDLE_VALUE)
		{
			FILE * fh;
			fh = fopen("c:\\temp\\tris.txt", "a");
			if (fh)
			{
				fprintf(fh, "%f %f %f,\n", p[m_dwNumVertices + 0].pos.x,
										p[m_dwNumVertices + 0].pos.y,
										p[m_dwNumVertices + 0].pos.z);
				fprintf(fh, "%f %f %f,\n", p[m_dwNumVertices + 1].pos.x,
										p[m_dwNumVertices + 1].pos.y,
										p[m_dwNumVertices + 1].pos.z);
				fprintf(fh, "%f %f %f,\n", p[m_dwNumVertices + 2].pos.x,
										p[m_dwNumVertices + 2].pos.y,
										p[m_dwNumVertices + 2].pos.z);
				fclose(fh);
			}
			fh = fopen("c:\\temp\\faces.txt", "a");
			if (fh)
			{
				fprintf(fh, "%d, %d, %d, -1,\n", ncount, ncount+1, ncount+2);
				ncount+=3;
				fclose(fh);
			}

		}*/

// Bits
// +-+-+-
// xxyyzz
/*
#define Z_NEG  0x01
#define Z_POS  0x02
#define Y_NEG  0x04
#define Y_POS  0x08
#define X_NEG  0x10
#define X_POS  0x20*/

// Returns TRUE if it thinks the triangle is visible
// Returns FALSE if it is clipped
BOOL D3DRender::TestTri(DWORD dwV0, DWORD dwV1, DWORD dwV2)
{
	// Check vertices are valid!
	if (dwV0 >= 32 || dwV1 >= 32 || dwV2 >= 32)
		return FALSE;

	// Here we AND all the flags. If any of the bits is set for all
	// 3 vertices, it means that all three x, y or z lie outside of
	// the current viewing volume.
	// Currently disabled - still seems a bit dodgy
#if CLIPPING
	if (m_dwVecFlags[dwV0] & m_dwVecFlags[dwV1] & m_dwVecFlags[dwV2])
	{
		//DL_PF("0x%04x 0x%04x 0x%04x", m_dwVecFlags[dwV0], m_dwVecFlags[dwV1], m_dwVecFlags[dwV2]);
		return FALSE;
	}
	else
#endif
	if ((m_bCullFront || m_bCullBack) && !m_bZModeDecal)
	{
		D3DXVECTOR3 & v0 = m_vecProjected[dwV0];
		D3DXVECTOR3 & v1 = m_vecProjected[dwV1];
		D3DXVECTOR3 & v2 = m_vecProjected[dwV2];

		/*if (m_fRHW[dwV0] < 0)
			v0 = -m_vecProjected[dwV0];
		else
			v0 = +m_vecProjected[dwV0];

		if (m_fRHW[dwV1] < 0)
			v1 = -m_vecProjected[dwV1];
		else
			v1 = +m_vecProjected[dwV1];

		if (m_fRHW[dwV2] < 0)
			v2 = -m_vecProjected[dwV2];
		else
			v2 = +m_vecProjected[dwV2];*/

		// Only try to clip if the tri is onscreen. For some reason, this
		// method doesnt' work well when the z value is outside of screenspace
		if (v0.z < 1 && v1.z < 1 && v2.z < 1)
		{
			float V1 = v2.x - v0.x;
			float V2 = v2.y - v0.y;
			
			float W1 = v2.x - v1.x;
			float W2 = v2.y - v1.y;

			float fDirection = (V1 * W2) - (V2 * W1);

			if (fDirection < 0 && m_bCullBack)
				return FALSE;
			else if (fDirection > 0 && m_bCullFront)
				return FALSE;
		}
	}
	return TRUE;
}

DWORD D3DRender::LightVert(D3DXVECTOR3 & norm)
{
	float r,g,b,a;
	float fCosT;
	DWORD l;

	D3DXVec3Normalize(&norm, &norm);

	// Ip = Light intensity
	// Ia = Ambient light intensity
	// Ka = Material ambient reflective property
	// Kd = Material diffuse reflective property
	// L = normalised light direction
	// N = vertex normal

	// I = IaKa + IpKd (N . L)

	// Do ambient
	float Iar = (float)RGBA_GETRED(m_dwAmbientLight);
	float Iag = (float)RGBA_GETGREEN(m_dwAmbientLight);
	float Iab = (float)RGBA_GETBLUE(m_dwAmbientLight);
	//float Iaa = (float)RGBA_GETALPHA(m_dwAmbientLight);

	r = Iar;
	g = Iag;
	b = Iab;
	//a = Iaa;

	for (l = 0; l < m_dwNumLights; l++)
	{
		fCosT = D3DXVec3Dot(&norm, &m_Lights[l].dir);
			
		if (fCosT > 0)
		{
			r += m_Lights[l].col.r * fCosT;
			g += m_Lights[l].col.g * fCosT;
			b += m_Lights[l].col.b * fCosT;
		//	a += m_Lights[l].col.a * fCosT;
		}
	}

	if (r > 255.0f) r = 255.0f;
	if (g > 255.0f) g = 255.0f;
	if (b > 255.0f) b = 255.0f;

	//if (a < 0) a = 0;
	//else if (a > 255.0f) a = 255.0f;
	a = 255.0f;

	return RGBA_MAKE((LONG)r, (LONG)g, (LONG)b, (LONG)a);

}

inline void D3DRender::InitTLitVertex(TLITVERTEX & v, DWORD dwV)
{
	//DBGConsole_Msg(0, "%dx%d %d,%d", m_nVPWidth, m_nVPHeight, m_nVPLeft, m_nVPTop);

	v.pos.x = ( (m_vecProjected[dwV].x+1) * m_nVPWidth/2) + m_nVPLeft;
	v.pos.y = ( (-m_vecProjected[dwV].y+1) * m_nVPHeight/2) + m_nVPTop;
	v.pos.z = (m_vecProjected[dwV].z + 1.0f) * 0.5f;
	v.rhw = m_fRHW[dwV];
	
	// If the vert is already lit, then there is no normal (and hence we can't generate tex coord)
	// Only scale if not generated automatically
	if (m_bTextureGen && m_bLightingEnable)
	{
		v.tu = m_vecTexture[dwV].x;
		v.tv = m_vecTexture[dwV].y;
	}
	else
	{
		v.tu = (m_vecTexture[dwV].x - m_fTexLeft) / m_fTexWidth;
		v.tv = (m_vecTexture[dwV].y - m_fTexTop) / m_fTexHeight;
		//DL_PF("%d: %f-%f/%f = %f", dwV, m_vecTexture[dwV].x, m_fTexLeft, m_fTexWidth, v.tu);
		//DL_PF("    %f-%f/%f = %f",      m_vecTexture[dwV].y, m_fTexTop, m_fTexHeight, v.tv);
	}


	v.dcDiffuse = m_dwVecCol[dwV];
}

inline void D3DRender::InitLitVertex(LITVERTEX & v, DWORD dwV)
{
	//DBGConsole_Msg(0, "%dx%d %d,%d", m_nVPWidth, m_nVPHeight, m_nVPLeft, m_nVPTop);

	v.pos.x = ( (m_vecProjected[dwV].x+1) * m_nVPWidth/2) + m_nVPLeft;
	v.pos.y = ( (-m_vecProjected[dwV].y+1) * m_nVPHeight/2) + m_nVPTop;
	v.pos.z = (m_vecProjected[dwV].z + 1.0f) * 0.5f;
	v.rhw = m_fRHW[dwV];
	v.dcDiffuse = m_dwVecCol[dwV];
}


void D3DRender::AddTri(DWORD dwV0, DWORD dwV1, DWORD dwV2)
{
	//DL_PF("Tri1: 0x%08x 0x%08x %d,%d,%d", dwCmd0, dwCmd1, dwV0, dwV1, dwV2);

	if (m_bTextureEnable)
	{
		// Add to textured, lit buffer
		TLITVERTEX * p = (TLITVERTEX *)m_ucVertexBuffer;
		
		InitTLitVertex(p[m_dwNumVertices + 0], dwV0);
		InitTLitVertex(p[m_dwNumVertices + 1], dwV1);
		InitTLitVertex(p[m_dwNumVertices + 2], dwV2);

		if (m_bZModeDecal)
		{
			// Bias points by normal
			p[m_dwNumVertices + 0].pos.z -= 0.0001f;
			p[m_dwNumVertices + 1].pos.z -= 0.0001f;
			p[m_dwNumVertices + 2].pos.z -= 0.0001f;
		}
	}
	else
	{
		// No textures...
		// Untextured, lit
		LITVERTEX * p = (LITVERTEX *)m_ucVertexBuffer;
		
		InitLitVertex(p[m_dwNumVertices + 0], dwV0);
		InitLitVertex(p[m_dwNumVertices + 1], dwV1);
		InitLitVertex(p[m_dwNumVertices + 2], dwV2);
	}

	m_dwNumVertices += 3;

}


static const DWORD sc_dwVertTypes[2] =
{
	DAEDALUSFVF_LITVERTEX, DAEDALUSFVF_TLITVERTEX	// m_bTextureEnable
};

HRESULT D3DRender::FlushTris()
{
	HRESULT hr;
	DWORD dwVertexType;

	if (m_dwNumVertices == 0)
		return S_OK;

	InitBlendMode();

	dwVertexType = sc_dwVertTypes[m_bTextureEnable? 1:0];


	if (m_Mux == 0x00127e2433fdf8fc)
	{
          // aRGB0: (Texel0       - Prim        ) * Shade        + Primitive
          // aA0  : (0            - 0           ) * 0            + Shade
          // aRGB1: (Texel0       - Prim        ) * Shade        + Primitive
          // aA1  : (0            - 0           ) * 0            + Shade


		//(T0 - Prim) * Shade + Prim,   Shade

		// TEXEL0,PRIM,SHADE,PRIM  0,0,0,SHADE -- Used in Wetrix, incorrect at mo
		// (T0 - PRIM) * DIFFUSE + PRIM

		m_pD3DDev->SetRenderState( D3DRENDERSTATE_ALPHABLENDENABLE,   TRUE);
		m_pD3DDev->SetRenderState( D3DRENDERSTATE_ALPHATESTENABLE,   TRUE);

		SetNumStages(0);

		// T0 - PRIM
		// SHADE
		m_pD3DDev->SetTexture( 0, m_lpsTexture );
		SetTextureFactor(m_dwPrimitiveColor);
		
		SetColorOp( 0, D3DTOP_MODULATE );
		SetColorArg1( 0, D3DTA_TEXTURE );
		SetColorArg2( 0, D3DTA_DIFFUSE );
		
		SetAlphaOp( 0, D3DTOP_SELECTARG2 );
		SetAlphaArg2( 0, D3DTA_TFACTOR );		// DIFFUSE

		hr = m_pD3DDev->DrawPrimitive(D3DPT_TRIANGLELIST,
									dwVertexType,
									m_ucVertexBuffer,
									m_dwNumVertices,
									0);	


		// CURRENT * DIFFUSE
		m_pD3DDev->SetRenderState( D3DRENDERSTATE_SRCBLEND,   D3DBLEND_ONE);
		m_pD3DDev->SetRenderState( D3DRENDERSTATE_DESTBLEND,  D3DBLEND_ONE);

		m_pD3DDev->SetTexture( 0, NULL );

		SetColorOp( 0, D3DTOP_MODULATE );
		SetColorArg1( 0, D3DTA_COMPLEMENT|D3DTA_DIFFUSE );		// 1 - DIFFUSE
		SetColorArg2( 0, D3DTA_TFACTOR );

		
		//SetAlphaOp( 0, D3DTOP_DISABLE );
		SetAlphaOp( 0, D3DTOP_SELECTARG2 );
		SetAlphaArg2( 0, D3DTA_TFACTOR );		// DIFFUSE
	
		hr = m_pD3DDev->DrawPrimitive(D3DPT_TRIANGLELIST,
									dwVertexType,
									m_ucVertexBuffer,
									m_dwNumVertices,
									0);

		// Restore blend mode
		m_pD3DDev->SetRenderState( D3DRENDERSTATE_SRCBLEND,   D3DBLEND_SRCALPHA);
		m_pD3DDev->SetRenderState( D3DRENDERSTATE_DESTBLEND,  D3DBLEND_INVSRCALPHA);
	
	}
	else if (m_Mux == 0x00127e44fffff238)
	{

		// Spiderman/TH
    //RGB0: (Texel0       - 0           ) * Shade        + 0           
    //A0  : (0            - 0           ) * 0            + Texel0      
    //RGB1: (Texel1       - 0           ) * Shade        + Combined    
    //A1  : (0            - 0           ) * 0            + Combined  

		m_pD3DDev->SetRenderState( D3DRENDERSTATE_ALPHABLENDENABLE,   TRUE);
		m_pD3DDev->SetRenderState( D3DRENDERSTATE_ALPHATESTENABLE,   TRUE);

		m_pD3DDev->SetRenderState( D3DRENDERSTATE_SRCBLEND,   D3DBLEND_ONE);
		m_pD3DDev->SetRenderState( D3DRENDERSTATE_DESTBLEND,  D3DBLEND_ZERO);
		SetNumStages(0);

		// T0 * SHADE
		// T0
		m_pD3DDev->SetTexture( 0, m_lpsTexture );
		
		SetColorOp( 0, D3DTOP_MODULATE );
		SetColorArg1( 0, D3DTA_TEXTURE );
		SetColorArg2( 0, D3DTA_DIFFUSE );
		
		SetAlphaOp( 0, D3DTOP_SELECTARG1 );
		SetAlphaArg2( 0, D3DTA_TEXTURE );

		hr = m_pD3DDev->DrawPrimitive(D3DPT_TRIANGLELIST,
									dwVertexType,
									m_ucVertexBuffer,
									m_dwNumVertices,
									0);	


		// T1 * SHADE
		// T0
		m_pD3DDev->SetRenderState( D3DRENDERSTATE_SRCBLEND,   D3DBLEND_ONE);
		m_pD3DDev->SetRenderState( D3DRENDERSTATE_DESTBLEND,  D3DBLEND_ONE);

		m_pD3DDev->SetTexture( 0, m_lpsTexture );

		SetColorOp( 0, D3DTOP_MODULATE );
		SetColorArg1( 0, D3DTA_TEXTURE );
		SetColorArg2( 0, D3DTA_DIFFUSE );

		
		SetAlphaOp( 0, D3DTOP_SELECTARG1 );
		SetAlphaArg2( 0, D3DTA_TEXTURE );
	
		hr = m_pD3DDev->DrawPrimitive(D3DPT_TRIANGLELIST,
									dwVertexType,
									m_ucVertexBuffer,
									m_dwNumVertices,
									0);	

		m_pD3DDev->SetRenderState( D3DRENDERSTATE_SRCBLEND,   D3DBLEND_SRCALPHA);
		m_pD3DDev->SetRenderState( D3DRENDERSTATE_DESTBLEND,  D3DBLEND_INVSRCALPHA);

	}
	else
	{
		// Changed by Orkin - Removed the envcolor hack, shouldn't be needed anymore
		hr = m_pD3DDev->DrawPrimitive(D3DPT_TRIANGLELIST,
									dwVertexType,
									m_ucVertexBuffer,
									m_dwNumVertices,
									0);	
	}

	// Reset index
	m_dwNumVertices = 0;

	return hr;

}

// Draw nodes on vertices
/*D3DXVECTOR3 a, b, c;

a.x = (v0.x * 160) + 160; a.y = (-v0.y * 120) + 120;
b.x = (v1.x * 160) + 160; b.y = (-v1.y * 120) + 120;
c.x = (v2.x * 160) + 160; c.y = (-v2.y * 120) + 120;

g_Renderer->FillRect(a.x, a.y, a.x+2, a.y+2, RGBA_MAKE(255,0,255,255));
g_Renderer->FillRect(b.x, b.y, b.x+2, b.y+2, RGBA_MAKE(255,0,255,255));
g_Renderer->FillRect(c.x, c.y, c.x+2, c.y+2, RGBA_MAKE(255,0,255,255));* /
*/
