/*
Copyright (C) 2001 StrmnNrmn

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

*/

#include "stdafx.h"
#include "ConvertImage.h"
#include "DBGConsole.h"



void ConvertRGBA16(SurfaceHandler *pSurf,
					  WORD *pSrc,
					  DWORD dwPitch, 
					  DWORD dwSrcX, DWORD dwSrcY,
					  DWORD dwWidth, DWORD dwHeight,
					  BOOL bSwapped)
{
	DrawInfo dst;
	DWORD x, y;
	LONG nFiddle;

	// Copy of the base pointer
	BYTE * pByteSrc = (BYTE *)pSrc;

	if (!pSurf->StartUpdate(&dst))
		return;

	if (bSwapped)
	{
		for (y = 0; y < dwHeight; y++)
		{
			if ((y%2) == 0)
				nFiddle = 0x2;
			else
				nFiddle = 0x2 | 0x4;

			// dwDst points to start of destination row
			DWORD * dwDst = (DWORD *)((BYTE *)dst.lpSurface + y*dst.lPitch);

			// DWordOffset points to the current dword we're looking at
			// (process 2 pixels at a time). May be a problem if we don't start on even pixel
			DWORD dwWordOffset = ((y+dwSrcY) * dwPitch) + (dwSrcX * 2);

			for (x = 0; x < dwWidth; x++)
			{
				WORD w = *(WORD *)&pByteSrc[dwWordOffset ^ nFiddle];

				dwDst[x] = Convert555ToRGBA(w);
				
				// Increment word offset to point to the next two pixels
				dwWordOffset += 2;
			}
		}
	}
	else
	{
		for (y = 0; y < dwHeight; y++)
		{
			// dwDst points to start of destination row
			DWORD * dwDst = (DWORD *)((BYTE *)dst.lpSurface + y*dst.lPitch);

			// DWordOffset points to the current dword we're looking at
			// (process 2 pixels at a time). May be a problem if we don't start on even pixel
			DWORD dwWordOffset = ((y+dwSrcY) * dwPitch) + (dwSrcX * 2);

			for (x = 0; x < dwWidth; x++)
			{
				WORD w = *(WORD *)&pByteSrc[dwWordOffset ^ 0x2];

				dwDst[x] = Convert555ToRGBA(w);
				
				// Increment word offset to point to the next two pixels
				dwWordOffset += 2;
			}
		}
	}

	pSurf->EndUpdate(&dst);
}

void ConvertRGBA32(SurfaceHandler *pSurf,
					  DWORD *pSrc,
					  DWORD dwPitch,
					  DWORD dwSrcX, DWORD dwSrcY,
					  DWORD dwWidth, DWORD dwHeight,
					  BOOL bSwapped)
{
	DrawInfo dst;
	if (!pSurf->StartUpdate(&dst))
		return;

	if (bSwapped)
	{
		for (DWORD y = 0; y < dwHeight; y++)
		{
			if ((y%2) == 0)
			{

				BYTE *pD = (BYTE *)dst.lpSurface + y * dst.lPitch;
				BYTE *pS = (BYTE *)pSrc + (y+dwSrcY) * dwPitch + (dwSrcX*4);
				
				for (DWORD x = 0; x < dwWidth; x++)
				{
					pD[0] = pS[1];	// Blue
					pD[1] = pS[2];	// Green
					pD[2] = pS[3];	// Red
					pD[3] = pS[0];	// Alpha
					pS+=4;
					pD+=4;
				}
			}
			else
			{

				DWORD *pD = (DWORD *)((BYTE *)dst.lpSurface + y * dst.lPitch);
				BYTE *pS = (BYTE *)pSrc;
				LONG n;
				
				n = (y+dwSrcY) * dwPitch + (dwSrcX*4);
				for (DWORD x = 0; x < dwWidth; x++)
				{
					*pD++ = RGBA_MAKE(pS[(n+3)^0x8],
									  pS[(n+2)^0x8],
									  pS[(n+1)^0x8],
									  pS[(n+0)^0x8]);

					n += 4;
				}
			}
		}
	}
	else
	{
		for (DWORD y = 0; y < dwHeight; y++)
		{
			BYTE *pD = (BYTE *)dst.lpSurface + y * dst.lPitch;
			BYTE *pS = (BYTE *)pSrc + (y+dwSrcY) * dwPitch + (dwSrcX*4);
			
			for (DWORD x = 0; x < dwWidth; x++)
			{
				pD[0] = pS[1];	// Blue
				pD[1] = pS[2];	// Green
				pD[2] = pS[3];	// Red
				pD[3] = pS[0];	// Alpha
				pS+=4;
				pD+=4;
			}
		}

	}
	pSurf->EndUpdate(&dst);

}

// E.g. Dear Mario text
// Copy, Score etc
void ConvertIA4(SurfaceHandler *pSurf,
					   BYTE *pSrc,
					   DWORD dwPitch,
					   DWORD dwSrcX, DWORD dwSrcY,
					   DWORD dwWidth, DWORD dwHeight,
					  BOOL bSwapped)
{
	DrawInfo dst;
	LONG nFiddle;

	if (!pSurf->StartUpdate(&dst))
		return;

	if (bSwapped)
	{
		for (DWORD y = 0; y < dwHeight; y++)
		{
			BYTE *pD = (BYTE *)dst.lpSurface + y * dst.lPitch;

			// For odd lines, swap words too
			if ((y%2) == 0)
				nFiddle = 0x3;
			else
				nFiddle = 0x7;


			// This may not work if X is not even?
			DWORD dwByteOffset = (y+dwSrcY) * dwPitch + (dwSrcX/2);

			// Do two pixels at a time
			for (DWORD x = 0; x < dwWidth; x+=2)
			{
				BYTE b = pSrc[dwByteOffset ^ nFiddle];

				// Even
				*pD++ = TwoToEight[(b & 0xc0) >> 6];
				*pD++ = TwoToEight[(b & 0xc0) >> 6];
				*pD++ = TwoToEight[(b & 0xc0) >> 6];
				*pD++ = TwoToEight[(b & 0x30) >> 4];	
				// Odd
				*pD++ = TwoToEight[(b & 0x0c) >> 2];
				*pD++ = TwoToEight[(b & 0x0c) >> 2];
				*pD++ = TwoToEight[(b & 0x0c) >> 2];
				*pD++ = TwoToEight[(b & 0x03)     ];

				dwByteOffset++;

			}

		}
	}
	else
	{
		for (DWORD y = 0; y < dwHeight; y++)
		{
			BYTE *pD = (BYTE *)dst.lpSurface + (y * dst.lPitch);

			// This may not work if X is not even?
			DWORD dwByteOffset = (y+dwSrcY) * dwPitch + (dwSrcX/2);

			// Do two pixels at a time
			for (DWORD x = 0; x < dwWidth; x+=2)
			{
				BYTE b = pSrc[dwByteOffset ^ 0x3];

				// Even
				*pD++ = TwoToEight[(b & 0xc0) >> 6];
				*pD++ = TwoToEight[(b & 0xc0) >> 6];
				*pD++ = TwoToEight[(b & 0xc0) >> 6];
				*pD++ = TwoToEight[(b & 0x30) >> 4];	
				// Odd
				*pD++ = TwoToEight[(b & 0x0c) >> 2];
				*pD++ = TwoToEight[(b & 0x0c) >> 2];
				*pD++ = TwoToEight[(b & 0x0c) >> 2];
				*pD++ = TwoToEight[(b & 0x03)     ];

				dwByteOffset++;

			}
		}	
	}
	
	pSurf->EndUpdate(&dst);

}

// E.g Mario's head textures
void ConvertIA8(SurfaceHandler *pSurf,
					   BYTE *pSrc,
					   DWORD dwPitch,
					   DWORD dwSrcX, DWORD dwSrcY,
					   DWORD dwWidth, DWORD dwHeight,
					  BOOL bSwapped)
{
	DrawInfo dst;
	LONG nFiddle;

	if (!pSurf->StartUpdate(&dst))
		return;

	if (bSwapped)
	{
		for (DWORD y = 0; y < dwHeight; y++)
		{
			// For odd lines, swap words too
			if ((y%2) == 0)
				nFiddle = 0x3;
			else
				nFiddle = 0x7;


			BYTE *pD = (BYTE *)dst.lpSurface + y * dst.lPitch;
			// Points to current byte
			DWORD dwByteOffset = ((y+dwSrcY) * dwPitch) + dwSrcX;

			for (DWORD x = 0; x < dwWidth; x++)
			{
				BYTE b = pSrc[dwByteOffset ^ nFiddle];

				*pD++ = FourToEight[(b & 0xf0)>>4];
				*pD++ = FourToEight[(b & 0xf0)>>4];
				*pD++ = FourToEight[(b & 0xf0)>>4];
				*pD++ = FourToEight[(b & 0x0f)   ];

				dwByteOffset++;
				}

		}		
	}
	else
	{

		for (DWORD y = 0; y < dwHeight; y++)
		{
			BYTE *pD = (BYTE *)dst.lpSurface + y * dst.lPitch;


			// Points to current byte
			DWORD dwByteOffset = ((y+dwSrcY) * dwPitch) + dwSrcX;

			for (DWORD x = 0; x < dwWidth; x++)
			{
				BYTE b = pSrc[dwByteOffset ^ 0x3];

				*pD++ = FourToEight[(b & 0xf0)>>4];
				*pD++ = FourToEight[(b & 0xf0)>>4];
				*pD++ = FourToEight[(b & 0xf0)>>4];
				*pD++ = FourToEight[(b & 0x0f)   ];

				dwByteOffset++;
			}
		}
	}	
	
	pSurf->EndUpdate(&dst);

}

// E.g. camera's clouds, shadows
void ConvertIA16(SurfaceHandler *pSurf,
						WORD *pSrc,
						DWORD dwPitch,
					    DWORD dwSrcX, DWORD dwSrcY,
						DWORD dwWidth, DWORD dwHeight,
					  BOOL bSwapped)
{
	DrawInfo dst;
	LONG nFiddle;

	BYTE * pByteSrc = (BYTE *)pSrc;

	if (!pSurf->StartUpdate(&dst))
		return;

	if (bSwapped)
	{
		
		for (DWORD y = 0; y < dwHeight; y++)
		{
			BYTE *pD = (BYTE *)dst.lpSurface + y * dst.lPitch;

			if ((y%2) == 0)
				nFiddle = 0x2;
			else
				nFiddle = 0x4 | 0x2;

			// Points to current word
			DWORD dwWordOffset = ((y+dwSrcY) * dwPitch) + (dwSrcX * 2);

			for (DWORD x = 0; x < dwWidth; x++)
			{
				WORD w = *(WORD *)&pByteSrc[dwWordOffset^nFiddle];

				*pD++ = (BYTE)(w >> 8);
				*pD++ = (BYTE)(w >> 8);
				*pD++ = (BYTE)(w >> 8);
				*pD++ = (BYTE)(w & 0xFF);

				dwWordOffset += 2;
			}
		}		
	}
	else
	{
		for (DWORD y = 0; y < dwHeight; y++)
		{
			BYTE *pD = (BYTE *)dst.lpSurface + y * dst.lPitch;

			// Points to current word
			DWORD dwWordOffset = ((y+dwSrcY) * dwPitch) + (dwSrcX * 2);

			for (DWORD x = 0; x < dwWidth; x++)
			{
				WORD w = *(WORD *)&pByteSrc[dwWordOffset^0x2];

				*pD++ = (BYTE)(w >> 8);
				*pD++ = (BYTE)(w >> 8);
				*pD++ = (BYTE)(w >> 8);
				*pD++ = (BYTE)(w & 0xFF);

				dwWordOffset += 2;
			}
		}		

	}


	pSurf->EndUpdate(&dst);
}



// Used by MarioKart
void ConvertI4(SurfaceHandler *pSurf,
					  BYTE *pSrc,
					  DWORD dwPitch,
					  DWORD dwSrcX, DWORD dwSrcY,
					  DWORD dwWidth, DWORD dwHeight,
					  BOOL bSwapped)
{
	DrawInfo dst;
	LONG nFiddle;

	if (!pSurf->StartUpdate(&dst))
		return;

	if (bSwapped)
	{

		for (DWORD y = 0; y < dwHeight; y++)
		{
			BYTE *pD = (BYTE *)dst.lpSurface + y * dst.lPitch;

			// Might not work with non-even starting X
			DWORD dwByteOffset = ((y+dwSrcY) * dwPitch) + (dwSrcX / 2);

			// For odd lines, swap words too
			if ((y%2) == 0)
				nFiddle = 0x3;
			else
				nFiddle = 0x7;

			for (DWORD x = 0; x < dwWidth; x+=2)
			{
				BYTE b = pSrc[dwByteOffset ^ nFiddle];

				// Even
				*pD++ = FourToEight[(b & 0xF0)>>4];	// Other implementations seem to or in (b&0xF0)>>4
				*pD++ = FourToEight[(b & 0xF0)>>4]; // why?
				*pD++ = FourToEight[(b & 0xF0)>>4];
				*pD++ = FourToEight[(b & 0xF0)>>4];	
				// Odd
				*pD++ = FourToEight[(b & 0x0F)];
				*pD++ = FourToEight[(b & 0x0F)];
				*pD++ = FourToEight[(b & 0x0F)];
				*pD++ = FourToEight[(b & 0x0F)];

				dwByteOffset++;
			}

		}	

	}
	else
	{

		for (DWORD y = 0; y < dwHeight; y++)
		{
			BYTE *pD = (BYTE *)dst.lpSurface + y * dst.lPitch;

			// Might not work with non-even starting X
			DWORD dwByteOffset = ((y+dwSrcY) * dwPitch) + (dwSrcX / 2);

			for (DWORD x = 0; x < dwWidth; x+=2)
			{
				BYTE b = pSrc[dwByteOffset ^ 0x3];

				// Even
				*pD++ = FourToEight[(b & 0xF0)>>4];	// Other implementations seem to or in (b&0xF0)>>4
				*pD++ = FourToEight[(b & 0xF0)>>4]; // why?
				*pD++ = FourToEight[(b & 0xF0)>>4];
				*pD++ = FourToEight[(b & 0xF0)>>4];	
				// Odd
				*pD++ = FourToEight[(b & 0x0F)];
				*pD++ = FourToEight[(b & 0x0F)];
				*pD++ = FourToEight[(b & 0x0F)];
				*pD++ = FourToEight[(b & 0x0F)];

				dwByteOffset++;
			}
		}
	}
	pSurf->EndUpdate(&dst);
}

// Used by MarioKart
void ConvertI8(SurfaceHandler *pSurf,
					  BYTE *pSrc,
					  DWORD dwPitch,
					  DWORD dwSrcX, DWORD dwSrcY,
					  DWORD dwWidth, DWORD dwHeight,
					  BOOL bSwapped)
{
	DrawInfo dst;
	LONG nFiddle;

	if (!pSurf->StartUpdate(&dst))
		return;

	if (bSwapped)
	{
		for (DWORD y = 0; y < dwHeight; y++)
		{
			if ((y%2) == 0)
				nFiddle = 0x3;
			else
				nFiddle = 0x7;

			BYTE *pD = (BYTE *)dst.lpSurface + y * dst.lPitch;

			DWORD dwByteOffset = ((y+dwSrcY) * dwPitch) + dwSrcX;

			for (DWORD x = 0; x < dwWidth; x++)
			{
				BYTE b = pSrc[dwByteOffset ^ nFiddle];

				*pD++ = b;
				*pD++ = b;
				*pD++ = b;
				*pD++ = b;		// Alpha not 255?

				dwByteOffset++;
			}
		}	
	}
	else
	{
		for (DWORD y = 0; y < dwHeight; y++)
		{
			BYTE *pD = (BYTE *)dst.lpSurface + y * dst.lPitch;

			DWORD dwByteOffset = ((y+dwSrcY) * dwPitch) + dwSrcX;

			for (DWORD x = 0; x < dwWidth; x++)
			{
				BYTE b = pSrc[dwByteOffset ^ 0x3];

				*pD++ = b;
				*pD++ = b;
				*pD++ = b;
				*pD++ = b;		// Alpha not 255?

				dwByteOffset++;
			}
		}	

	}
	pSurf->EndUpdate(&dst);

}


// Used by Starfox intro
void ConvertCI4_RGBA16(SurfaceHandler *pSurf,
					   BYTE *pSrc,
					   DWORD dwPitch, 
					   WORD * pPal, 
					   DWORD dwSrcX, DWORD dwSrcY,
					   DWORD dwWidth, DWORD dwHeight,
					  BOOL bSwapped)
{
	DrawInfo dst;
	LONG nFiddle;

	if (!pSurf->StartUpdate(&dst))
		return;

	if (bSwapped)
	{

		for (DWORD y = 0; y <  dwHeight; y++)
		{
			if ((y%2) == 0)
				nFiddle = 0x3;
			else
				nFiddle = 0x7;


			DWORD * pD = (DWORD *)((BYTE *)dst.lpSurface + y * dst.lPitch);

			DWORD dwByteOffset = ((y+dwSrcY) * dwPitch) + (dwSrcX / 2);

			for (DWORD x = 0; x < dwWidth; x+=2)
			{
				BYTE b = pSrc[dwByteOffset ^ nFiddle];

				BYTE bhi = (b&0xf0)>>4;
				BYTE blo = (b&0x0f);

				pD[0] = Convert555ToRGBA(pPal[bhi^0x1]);	// Remember palette is in different endian order!
				pD[1] = Convert555ToRGBA(pPal[blo^0x1]);	// Remember palette is in different endian order!
				pD+=2;

				dwByteOffset++;
			}
		}	
		
	}
	else
	{

		for (DWORD y = 0; y <  dwHeight; y++)
		{
			DWORD * pD = (DWORD *)((BYTE *)dst.lpSurface + y * dst.lPitch);

			DWORD dwByteOffset = ((y+dwSrcY) * dwPitch) + (dwSrcX / 2);

			for (DWORD x = 0; x < dwWidth; x+=2)
			{
				BYTE b = pSrc[dwByteOffset ^ 0x3];

				BYTE bhi = (b&0xf0)>>4;
				BYTE blo = (b&0x0f);

				pD[0] = Convert555ToRGBA(pPal[bhi^0x1]);	// Remember palette is in different endian order!
				pD[1] = Convert555ToRGBA(pPal[blo^0x1]);	// Remember palette is in different endian order!
				pD+=2;

				dwByteOffset++;
			}
		}	

	}
	pSurf->EndUpdate(&dst);
}

// Used by Starfox intro
void ConvertCI4_IA16(SurfaceHandler *pSurf,
					   BYTE *pSrc,
					   DWORD dwPitch, 
					   WORD * pPal,
					   DWORD dwSrcX, DWORD dwSrcY,
					   DWORD dwWidth, DWORD dwHeight,
					  BOOL bSwapped)
{
	DrawInfo dst;
	LONG nFiddle;

	if (!pSurf->StartUpdate(&dst))
		return;

	if (bSwapped)
	{

		for (DWORD y = 0; y <  dwHeight; y++)
		{
			if ((y%2) == 0)
				nFiddle = 0x3;
			else
				nFiddle = 0x7;


			DWORD * pD = (DWORD *)((BYTE *)dst.lpSurface + y * dst.lPitch);

			DWORD dwByteOffset = ((y+dwSrcY) * dwPitch) + (dwSrcX / 2);

			for (DWORD x = 0; x < dwWidth; x+=2)
			{
				BYTE b = pSrc[dwByteOffset ^ nFiddle];

				BYTE bhi = (b&0xf0)>>4;
				BYTE blo = (b&0x0f);

				pD[0] = ConvertIA16ToRGBA(pPal[bhi^0x1]);	// Remember palette is in different endian order!
				pD[1] = ConvertIA16ToRGBA(pPal[blo^0x1]);	// Remember palette is in different endian order!
				pD+=2;

				dwByteOffset++;
			}
		}	
		
	}
	else
	{

		for (DWORD y = 0; y <  dwHeight; y++)
		{
			DWORD * pD = (DWORD *)((BYTE *)dst.lpSurface + y * dst.lPitch);

			DWORD dwByteOffset = ((y+dwSrcY) * dwPitch) + (dwSrcX / 2);

			for (DWORD x = 0; x < dwWidth; x+=2)
			{
				BYTE b = pSrc[dwByteOffset ^ 0x3];

				BYTE bhi = (b&0xf0)>>4;
				BYTE blo = (b&0x0f);

				pD[0] = ConvertIA16ToRGBA(pPal[bhi^0x1]);	// Remember palette is in different endian order!
				pD[1] = ConvertIA16ToRGBA(pPal[blo^0x1]);	// Remember palette is in different endian order!
				pD+=2;

				dwByteOffset++;
			}
		}	

	}
	pSurf->EndUpdate(&dst);
}




// Used by MarioKart for Cars etc
void ConvertCI8_RGBA16(SurfaceHandler *pSurf,
					   BYTE *pSrc,
					   DWORD dwPitch, 
					   WORD * pPal, 
					   DWORD dwSrcX, DWORD dwSrcY,
					   DWORD dwWidth, DWORD dwHeight,
					  BOOL bSwapped)
{
	DrawInfo dst;
	LONG nFiddle;

	if (!pSurf->StartUpdate(&dst))
		return;

	if (bSwapped)
	{


		for (DWORD y = 0; y < dwHeight; y++)
		{
			if ((y%2) == 0)
				nFiddle = 0x3;
			else
				nFiddle = 0x7;

			DWORD *pD = (DWORD *)((BYTE *)dst.lpSurface + y * dst.lPitch);

			DWORD dwByteOffset = ((y+dwSrcY) * dwPitch) + dwSrcX;
			
			for (DWORD x = 0; x < dwWidth; x++)
			{
				BYTE b = pSrc[dwByteOffset ^ nFiddle];

				*pD++ = Convert555ToRGBA(pPal[b^0x1]);	// Remember palette is in different endian order!

				dwByteOffset++;
			}
		}	
	

	}
	else
	{

		for (DWORD y = 0; y < dwHeight; y++)
		{
			DWORD *pD = (DWORD *)((BYTE *)dst.lpSurface + y * dst.lPitch);

			DWORD dwByteOffset = ((y+dwSrcY) * dwPitch) + dwSrcX;
			
			for (DWORD x = 0; x < dwWidth; x++)
			{
				BYTE b = pSrc[dwByteOffset ^ 0x3];

				*pD++ = Convert555ToRGBA(pPal[b^0x1]);	// Remember palette is in different endian order!

				dwByteOffset++;
			}
		}
	}
	pSurf->EndUpdate(&dst);

}



// Used by MarioKart for Cars etc
void ConvertCI8_IA16(SurfaceHandler *pSurf,
					   BYTE *pSrc,
					   DWORD dwPitch, 
					   WORD * pPal, 
					   DWORD dwSrcX, DWORD dwSrcY,
					   DWORD dwWidth, DWORD dwHeight,
					  BOOL bSwapped)
{
	DrawInfo dst;
	LONG nFiddle;

	if (!pSurf->StartUpdate(&dst))
		return;

	if (bSwapped)
	{
		for (DWORD y = 0; y < dwHeight; y++)
		{
			if ((y%2) == 0)
				nFiddle = 0x3;
			else
				nFiddle = 0x7;

			DWORD *pD = (DWORD *)((BYTE *)dst.lpSurface + y * dst.lPitch);

			DWORD dwByteOffset = ((y+dwSrcY) * dwPitch) + dwSrcX;
			
			for (DWORD x = 0; x < dwWidth; x++)
			{
				BYTE b = pSrc[dwByteOffset ^ nFiddle];

				*pD++ = ConvertIA16ToRGBA(pPal[b^0x1]);	// Remember palette is in different endian order!

				dwByteOffset++;
			}
		}	
	}
	else
	{
		for (DWORD y = 0; y < dwHeight; y++)
		{
			DWORD *pD = (DWORD *)((BYTE *)dst.lpSurface + y * dst.lPitch);

			DWORD dwByteOffset = ((y+dwSrcY) * dwPitch) + dwSrcX;
			
			for (DWORD x = 0; x < dwWidth; x++)
			{
				BYTE b = pSrc[dwByteOffset ^ 0x3];

				*pD++ = ConvertIA16ToRGBA(pPal[b^0x1]);	// Remember palette is in different endian order!

				dwByteOffset++;
			}
		}
	}
	pSurf->EndUpdate(&dst);
}


