/*
Copyright (C) 2001 StrmnNrmn

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

*/

#include "stdafx.h"
#include "resource.h"
#include "AudioDialog.h"
#include "CPU.h"			// g_bReloadAiPlugin
#include <shlwapi.h>
#include <windowsx.h>		// ComboBox_ defines
#include "DBGConsole.h"
#include "ConfigHandler.h"

static BOOL CALLBACK AudioDialogProc(HWND hWndDlg, UINT uMsg, WPARAM wParam, LPARAM lParam);
static BOOL AudioDialog_OnInitDialog(HWND hWndDlg, WPARAM wParam, LPARAM lParam);

static void AudioDialog_FreePluginList();
static BOOL AudioDialog_InitPluginList();
static void AudioDialog_FillPluginCombo(HWND hWndDlg);
static void AudioDialog_EnableControls(HWND hWndDlg, BOOL bEnabled);

typedef struct 
{
	TCHAR	szFileName[MAX_PATH+1];
	CAudioPlugin * pPlugin;
	BOOL bCurrentlyInUse;

} AudioPluginInfo;

typedef std::vector< AudioPluginInfo > AudioPluginVector;

static AudioPluginVector g_AudioPlugins;
static LONG g_nCurSelection = -1;


void AudioDialog_DoModal(HWND hWndParent)
{
	DialogBox(g_hInstance, MAKEINTRESOURCE(IDD_AUDIO), hWndParent, AudioDialogProc);

}

#define CheckBox_GetCheck(hwnd)			SendMessage(hwnd, BM_GETCHECK, 0,0)
#define CheckBox_SetCheck(hwnd, state)	SendMessage(hwnd, BM_SETCHECK, (WPARAM)state,0)


BOOL CALLBACK AudioDialogProc(HWND hWndDlg, UINT uMsg, WPARAM wParam, LPARAM lParam)
{
	LONG nSelection;
	LONG nIndex;
	LONG nCheckedState;

	switch (uMsg)
	{
	case WM_INITDIALOG:
		return AudioDialog_OnInitDialog(hWndDlg, wParam, lParam);

	case WM_COMMAND:
		switch (LOWORD(wParam))
		{
		case IDC_AUDIO_CHECK:

			nCheckedState = CheckBox_GetCheck(GetDlgItem(hWndDlg, IDC_AUDIO_CHECK));
			if (nCheckedState == BST_CHECKED)
			{
				AudioDialog_EnableControls(hWndDlg, TRUE);
			}
			else if (nCheckedState == BST_UNCHECKED)
			{
				AudioDialog_EnableControls(hWndDlg, FALSE);
			}

			return TRUE;

		/*case IDC_PLUGIN_COMBO:

			return TRUE;*/
			// File menu commands
		case IDC_ABOUT_BUTTON:
			nSelection = ComboBox_GetCurSel(GetDlgItem(hWndDlg, IDC_PLUGIN_COMBO));
			nIndex = ComboBox_GetItemData(GetDlgItem(hWndDlg, IDC_PLUGIN_COMBO), nSelection);
			if (nIndex != CB_ERR && nIndex < g_AudioPlugins.size())
			{
				if (g_AudioPlugins[nIndex].pPlugin != NULL)
				{
					g_AudioPlugins[nIndex].pPlugin->DllAbout(hWndDlg);
				}
			}
			return TRUE;
		case IDC_CONFIG_BUTTON:
			nSelection = ComboBox_GetCurSel(GetDlgItem(hWndDlg, IDC_PLUGIN_COMBO));
			nIndex = ComboBox_GetItemData(GetDlgItem(hWndDlg, IDC_PLUGIN_COMBO), nSelection);
			if (nIndex != CB_ERR && nIndex < g_AudioPlugins.size())
			{
				if (g_AudioPlugins[nIndex].pPlugin != NULL)
				{
					g_AudioPlugins[nIndex].pPlugin->DllConfig(hWndDlg);
				}
			}
			return TRUE;

		case IDOK:
			nCheckedState = CheckBox_GetCheck(GetDlgItem(hWndDlg, IDC_AUDIO_CHECK));
			nSelection = ComboBox_GetCurSel(GetDlgItem(hWndDlg, IDC_PLUGIN_COMBO));

			nIndex = ComboBox_GetItemData(GetDlgItem(hWndDlg, IDC_PLUGIN_COMBO), nSelection);
			if (nIndex != CB_ERR && nIndex < g_AudioPlugins.size())
			{
				// Update main plugin!
				// Write to config!!!
				// Reinitialise!
				TCHAR szNewFileName[MAX_PATH+1];

				if (nCheckedState == BST_CHECKED)
				{
					lstrcpyn(szNewFileName, g_AudioPlugins[nIndex].szFileName, MAX_PATH);
				}
				else if (nCheckedState == BST_UNCHECKED)
				{
					lstrcpyn(szNewFileName, TEXT(""), MAX_PATH);
				}

				{
					// NULL - Write to registry
					ConfigHandler * pConfig = new ConfigHandler("Main");
					
					if (pConfig != NULL)
					{
						pConfig->WriteString("AudioPlugin", szNewFileName);
						delete pConfig;
					}
				}

				DBGConsole_Msg(0, "Audio plugin [C%s] selected", szNewFileName);
				if (lstrcmpi(szNewFileName, g_szAiPluginFileName) != 0)
				{
					lstrcpyn(g_szAiPluginFileName, szNewFileName, MAX_PATH);

					g_bReloadAiPlugin = TRUE;
				}

				// Set to null so that it is not deleted when we clean up
				//g_AudioPlugins[nSelection].pPlugin = NULL;
			}
			EndDialog(hWndDlg, IDOK);
			return TRUE;
		case IDCANCEL:
			EndDialog(hWndDlg, IDCANCEL);
			return TRUE;
		}
		break;
	case WM_DESTROY:
		// Free any plugins that were found
		AudioDialog_FreePluginList();
		return TRUE;

	}


	return FALSE;
}

BOOL AudioDialog_OnInitDialog(HWND hWndDlg, WPARAM wParam, LPARAM lParam)
{

	// Initialise the 
	if (AudioDialog_InitPluginList())
		AudioDialog_FillPluginCombo(hWndDlg);

	if (lstrlen(g_szAiPluginFileName) == 0)
	{
		CheckBox_SetCheck(GetDlgItem(hWndDlg, IDC_AUDIO_CHECK), BST_UNCHECKED);
		AudioDialog_EnableControls(hWndDlg, FALSE);
	}
	else
	{
		CheckBox_SetCheck(GetDlgItem(hWndDlg, IDC_AUDIO_CHECK), BST_CHECKED);
		AudioDialog_EnableControls(hWndDlg, TRUE);
	}


	SetFocus(GetDlgItem(hWndDlg, IDC_PLUGIN_COMBO));

	// We set the foucus, return false
	return FALSE;
}

// Free all plugins in list
void AudioDialog_FreePluginList()
{
	LONG i;
	LONG nNumPlugins;

	nNumPlugins = g_AudioPlugins.size();
	for (i = 0; i < nNumPlugins; i++)
	{
		if (g_AudioPlugins[i].pPlugin != NULL &&
			!g_AudioPlugins[i].bCurrentlyInUse)
		{
			delete g_AudioPlugins[i].pPlugin;
		}
	}
	g_AudioPlugins.clear();
}

// Scan
BOOL AudioDialog_InitPluginList()
{
	HANDLE hFind;
	WIN32_FIND_DATA fd;
	TCHAR szFileSpec[MAX_PATH+1];
	AudioPluginInfo api;

	// Delete existing plugins
	AudioDialog_FreePluginList();

	lstrcpyn(szFileSpec, g_szDaedalusExeDir, MAX_PATH);
	PathAppend(szFileSpec, TEXT("Plugins"));
	PathAppend(szFileSpec, TEXT("*.dll"));


	hFind = FindFirstFile(szFileSpec, &fd);
	if (hFind == INVALID_HANDLE_VALUE)
		return FALSE;

	do
	{
		lstrcpyn(api.szFileName, szFileSpec, MAX_PATH);
		PathRemoveFileSpec(api.szFileName);
		PathAppend(api.szFileName, fd.cFileName);

		/*if (lstrcmpi(api.szFileName, g_szAiPluginFileName) == 0)
		{
			api.pPlugin = g_pAiPlugin;
			api.bCurrentlyInUse = TRUE;
		}
		else*/
		{
			api.pPlugin = new CAudioPlugin(api.szFileName);
			if (api.pPlugin != NULL)
				api.pPlugin->Open();
			api.bCurrentlyInUse = FALSE;
		}

		if (api.pPlugin == NULL)
			continue;

		if (api.pPlugin->LoadedOk())
			g_AudioPlugins.push_back(api);
		else if (!api.bCurrentlyInUse)
			delete api.pPlugin;

	} while (FindNextFile(hFind, &fd));

	FindClose(hFind);

	return TRUE;
}


void AudioDialog_FillPluginCombo(HWND hWndDlg)
{

	LONG i;
	LONG nNumPlugins;
	HWND hWndCombo;
	CHAR szName[100];
	LONG nIndex;
	LONG nSelection;

	hWndCombo = GetDlgItem(hWndDlg, IDC_PLUGIN_COMBO);
	nNumPlugins = g_AudioPlugins.size();

	ComboBox_ResetContent(hWndCombo);

	nSelection = -1;

	for (i = 0; i < nNumPlugins; i++)
	{
		if (g_AudioPlugins[i].pPlugin == NULL)
			continue;

		g_AudioPlugins[i].pPlugin->GetPluginName(szName);

		nIndex = ComboBox_InsertString(hWndCombo, -1, szName);

		if (nIndex != CB_ERR && nIndex != CB_ERRSPACE)
		{
			// Record the index if this is the current selection
			if (lstrcmpi(g_AudioPlugins[i].szFileName, 
				g_szAiPluginFileName) == 0)
			{
				nSelection = nIndex;
			}

			// Set item data
			ComboBox_SetItemData(hWndCombo, nIndex, i);
		}
	}

	if (nSelection == -1)
		nSelection = 0;

	ComboBox_SetCurSel(hWndCombo, nSelection);

}


void AudioDialog_EnableControls(HWND hWndDlg, BOOL bEnabled)
{
	EnableWindow(GetDlgItem(hWndDlg, IDC_PLUGIN_COMBO), bEnabled);
	EnableWindow(GetDlgItem(hWndDlg, IDC_ABOUT_BUTTON), bEnabled);
	EnableWindow(GetDlgItem(hWndDlg, IDC_CONFIG_BUTTON), bEnabled);

}