// main.h
#include <windows.h>
#include <stdio.h>
#include <SDL.h>

// OpenGL
#include <gl\gl.h>								// Header File For The OpenGL32 Library
#include <gl\glu.h>								// Header File For The GLu32 Library
// #include <gl\glaux.h>								// Header File For The GLaux Library
#define OPENGL

#include "reg.h"
#include "log.h"

typedef short bool;
#define true 1
#define false 0

// #define PRINT_ASM
// #define LOGGING
// #define JOYSTICK
// #define ASM_DEBUG
// #define DEBUG_MOV
// #define DEBUG_MOV_MOVA
// #define DEBUG_BRANCH
// #define DEBUG_BRANCH_JSR
// #define DEBUG_ARITH
// #define DEBUG_ARITH_CMP
// #define DEBUG_ARITH_DMUL
// #define DEBUG_SHIFT
// #define DEBUG_FLOAT_SIMPLE
// #define DEBUG_FLOAT_GRAPH
// #define DEBUG_SYSCONTROL
// #define DEBUG_SYSCONTROL_STS
// #define DEBUG_FLOAT_CONTROL
// #define DEBUG_MEM
// #define DEBUG_MEM_READ
// #define DEBUG_MEM_WRITE
// #define DEBUG_LOGIC
// #define DEBUG_MEM_REGISTERS
// #define DEBUG_MEM_VIDEO
// #define EXTRA_REG_DEBUG
// #define DEBUG_VERTEX
// #define FULL_DEBUG_FROM		(0x8c018980)
// #define FULL_DEBUG_TO		(0x8c018996)
// #define CHECK_VALUE			(0x8c021410)

extern int filelogging;
#define FILELOG_OPCODES		1
#define FILELOG_REGISTERS	2
#define FILELOG_CALLS		4
#define FILELOG_MEMREADS	8
#define FILELOG_MEMWRITES	16

#define CHECK_BIT(reg,bit) { if (*reg & bit) logmsg(#reg ": " #bit " activado\r\n"); else logmsg(#reg ": " #bit " desactivado\r\n"); }
// #define COPY_REG(a, b) memcpy(&a, &b, sizeof(DWORD))
#define COPY_REG(a, b) ((DWORD) (a) = (DWORD) (b))

struct opcode_log_params
{
    int		pos;
    WORD	arg;
    DWORD	PC;
};

typedef void opcode_log_f(struct opcode_log_params * params);
typedef struct opcode_log_params opcode_log_params;

extern unsigned char * str_PC;

struct opcode_log_str
{
    opcode_log_f * func;
    opcode_log_params params;
};

typedef void opcode_f (WORD);

#define OPCODE(instr) void instr (WORD arg)
extern char lastop[128];

#define OPMAXCNT 10
extern struct opcode_log_str ultop[OPMAXCNT];
extern short ultopcnt;

struct st_cmd
{
	const long		op;
	const long		mask;
	const char *	opdesc;
//	const int		params;
	opcode_log_f *	logfunc;
	opcode_f *		funcion;
	const long		restriccion;
	unsigned long	llamadas;
};

typedef void PC_f(void);
extern PC_f * PC_func;
void PC_f_normal(void);
void PC_f_delayslot(void);
void PC_f_nextpc(void);

extern struct st_cmd opcodes[];

#define REG_SET_BIT(reg, bit) {*reg |= bit;}
#define SET_BIT(reg, bit) (reg |= (bit))
#define REMOVE_BIT(reg, bit) (reg &= ~(bit))
#define IS_SET(val, bit) ((val) & (bit))
#define IS_SET_REG(reg, bit) ((*reg) & (bit))

#define SET_T {SR = SR | SR_T;}
#define UNSET_T {SR = SR & ~SR_T;}

#define IS_SR_MD()	(SR & SR_MD)
#define IS_SR_T() (SR & SR_T)
#define IS_SR_Q() (SR & SR_Q)
#define IS_SR_M() (SR & SR_M)

#define SR_MD (1 << 30)
#define SR_RB (1 << 29)
#define SR_BL (1 << 28)
#define SR_FD (1 << 15)
#define SR_M  (1 << 9)
#define SR_Q  (1 << 8)
#define SR_IMASK (0x000000F0)
#define SR_S  (1 << 1)
#define SR_T  (1 << 0)

#define flunpack(x) (*(float *)x)
#define lunpack(x) (*(DWORD *)x)
#define wunpack(x) (*(WORD *)x)
#define SignExtend8(c) (((c) & 0x80) ? (0xFFFFFF00 | (c)) : (c))
#define SignExtend16(c) (((c) & 0x8000) ? (0xFFFF0000 | (c)) : (c))
#define SignExtend12(c) (((c) & 0x0800) ? (0xFFFFF000 | (c)) : (c))

#define LOG(str) { fprintf(logfp, "PC: %8x " #str " %8x\r\n", PC, str); }

#define MEMORY_MACROS

// memory.cpp
#ifdef MEMORY_MACROS
#include "mem.h"
#define ReadMemoryF(a,b) memread(a, b, sizeof(DWORD))
#define ReadMemoryB(a,b) memread(a, b, sizeof(BYTE))
#define ReadMemoryW(a,b) memread(a, b, sizeof(WORD))
#define ReadMemoryL(a,b) memread(a, b, sizeof(DWORD))
#define WriteMemoryF(a,b) memwrite(a, b, sizeof(DWORD))
#define WriteMemoryB(a,b) memwrite(a, b, sizeof(BYTE))
#define WriteMemoryW(a,b) memwrite(a, b, sizeof(WORD))
#define WriteMemoryL(a,b) memwrite(a, b, sizeof(DWORD))
#else
extern void ReadMemoryF(unsigned long direccion, float * valor);
extern void ReadMemoryB(unsigned long direccion, unsigned char * valor);
extern void ReadMemoryL(unsigned long direccion, DWORD * valor);
extern void ReadMemoryW(unsigned long direccion, WORD * valor);
extern void WriteMemoryW(unsigned long direccion, WORD * valor);
extern void WriteMemoryL(unsigned long direccion, DWORD * valor);
extern void WriteMemoryB(unsigned long direccion, BYTE * valor);
extern void WriteMemoryF(unsigned long direccion, float * valor);
#endif

// graficos.cpp
// extern void PutPixel(Uint32 pos, Uint32 pixel);
// extern void PutPixelW(Uint32 pos, WORD pixel);
// extern void PutPixelL(Uint32 pos, DWORD pixel);
extern void PutPixelN(Uint32 pos, void * data, size_t size);
extern void ReadPixelN(Uint32 pos, void * data, size_t size);
extern SDL_Surface *screen;
extern SDL_Surface *backscreen;
extern SDL_Surface *glscreen;
extern BYTE * screenbase;
extern bool logmem;
extern bool logmemreg;
extern bool logvideomem;

// constantes
#define mem_base		0x8C000000
#define mem_n_base		0x0C000000
#define mem_offset		0x00010000
#define ip_offset		0x00008000
#define ip_bs1_offset	0x0000B800
#define ip_bs2_offset	0x0000E000
#define mem_ram_base	0x0C000000
#define mem_n_ram_base	0x0C000000
#define mem_ram_size	0x01000000
#define CACHE_SIZE		(4096 * 1024) // 1024 kb
#define bios_size		(2048 * 1024) // 2 MB

#define video_base		0xa5000000
#define n_video_base	0x05000000
#define video_size		(8 * 1024 * 1024)
#define mem_size		(16 * 1024 * 1024)

#define HACK_BASE		0x8C000100
#define HACK_ROMFONT	0x000
#define HACK_GDROM		0x100

#define SYSCALL_ROMFONT	0x8C0000B4
#define SYSCALL_GDROM	0x8C0000BC

extern unsigned char * memoria;
extern unsigned char * video_mem;
extern unsigned char * regmem;
extern unsigned char * bios_mem;
extern unsigned char * ta_mem;
#define BIOS_SIZE (4200930) // (?)
#define TA_SIZE		(512)
// extern opcode_f * opcode_cache[cache_size];
extern FILE * logfp, * serialfp, * memfp;
extern bool pausa;
extern long instrucciones;
extern bool refresh_screen;
extern int screenbits;
extern int screenwidth;
extern int screenheight;
extern int framebuffer_size;

// registros CPU
// extern long registers[32];
extern float float_registers[32];
// extern signed long registers[24];
extern DWORD registers[];
// extern DWORD float_registers[32];
extern unsigned long SR; // Status Register
extern unsigned long SSR; // Saved Status Register
extern unsigned long SPC; // Saved Program Counter
extern unsigned long GBR; // Global Base Register
extern unsigned long VBR; // Vector Base Register
extern unsigned long SGR; // Saved General Register 15
extern unsigned long DBR; // Debug Base Register

extern DWORD *	PTEL;			// Page Table Entry Low register

extern DWORD *	CCR;			// Cache Control Register
extern WORD *	SCFSR2;
extern DWORD *	QACR0;			// Queue Address Control Register 0
extern DWORD *	QACR1;			// Queue Address Control Register 0
extern DWORD    SQ0[8];         // Store Queue 0
extern DWORD    SQ1[8];         // Store Queue 1
extern DWORD *	INTEVT;		// Interrupt Event Register
extern DWORD *	EXPEVT;		// Exception Event Register
extern DWORD *	TRA;		// TRAPA exception register

extern DWORD *	CHCR2;			// DMA Channel Control Register 2

extern WORD *	ICR;			// Interrupt Control Register
extern WORD *	IPRA;			// Interrupt Priority Register A
extern WORD *	IPRB;			// Interrupt Priority Register B
extern WORD *	IPRC;			// Interrupt Priority Register C

extern DWORD *	PCTRA;			// Port Control Register A
extern WORD *	PDTRA;			// Port Data Register A
extern DWORD *	PCTRB;			// Port Control Register B
extern WORD *	PDTRB;			// Port data Register B

/*** Serial Communications Interface ***/
extern WORD *	SCSMR2;			// Serial Mode Register
extern BYTE *	SCBRR2;			// Bit Rate Register
extern WORD *	SCSCR2;			// Serial Control Register
extern BYTE *	SCFTDR2;		// Transmit FIFO Data Register
extern WORD *	SCFSR2;			// Serial Status Register
extern BYTE *	SCFRDR2;		// Receive FIFO Data Register
extern WORD *	SCFCR2;			// FIFO Control Register
extern WORD *	SCFDR2;			// FIFO Data Count Register
extern WORD *	SCSPTR2;		// Serial Port Register
extern WORD *	SCLSR2;			// Line Status Register

// BITFIELDS
// SCSMR2
#define CHR		(0x0040)
#define PE		(0x0020)
#define PM		(0x0010)
#define STOP	(0x0008)
#define CKS1	(0x0002)
#define CKS0	(0x0000)

// SCSCR2
#define TIE		(0x0080)
#define RIE		(0x0040)
#define TE		(0x0020)
#define RE		(0x0010)
#define REIE	(0x0008)
#define CKE1	(0x0002)

// SCFSR2
#define SCFSR2_PER3	(0x8000)
#define SCFSR2_PER2	(0x4000)
#define SCFSR2_PER1	(0x2000)
#define SCFSR2_PER0	(0x1000)
#define SCFSR2_FER3	(0x0800)
#define SCFSR2_FER2	(0x0400)
#define SCFSR2_FER1	(0x0200)
#define SCFSR2_FER0	(0x0100)
#define SCFSR2_ER	(0x0080)
#define SCFSR2_TEND	(0x0040)
#define SCFSR2_TDFE	(0x0020)
#define SCFSR2_BRK	(0x0010)
#define SCFSR2_FER	(0x0008)
#define SCFSR2_PER	(0x0004)
#define SCFSR2_RDF	(0x0002)
#define SCFSR2_DR	(0x0001)
/*** FIN Serial Communications Interface ***/

/*** DMA ***/
extern	DWORD *	SAR0;		// DMA source address register 0
extern	DWORD *	DAR0;		// DMA destination address register 0
extern	DWORD *	DMATCR0;	// DMA transfer count register 0
extern	DWORD *	CHCR0;		// DMA channel control register 0
extern	DWORD *	SAR1;		// DMA source address register 0
extern	DWORD *	DAR1;		// DMA destination address register 0
extern	DWORD *	DMATCR1;	// DMA transfer count register 0
extern	DWORD *	CHCR1;		// DMA channel control register 0
extern	DWORD *	SAR2;		// DMA source address register 0
extern	DWORD *	DAR2;		// DMA destination address register 0
extern	DWORD *	DMATCR2;	// DMA transfer count register 0
extern	DWORD *	CHCR2;		// DMA channel control register 0
extern	DWORD *	SAR3;		// DMA source address register 0
extern	DWORD *	DAR3;		// DMA destination address register 0
extern	DWORD *	DMATCR3;	// DMA transfer count register 0
extern	DWORD *	CHCR3;		// DMA channel control register 0
extern	DWORD *	DMAOR;		// DMA operation register

#define DME		1
#define DE		1
/*** FIN DMA ***/

/*** TMU ***/
extern  BYTE *	TOCR;
extern  BYTE *	TSTR;
extern  DWORD *	TCOR0;
extern  DWORD *	TCNT0;
extern  WORD *	TCR0;
extern  DWORD *	TCOR1;
extern  DWORD *	TCNT1;
extern  WORD *	TCR1;
extern  DWORD *	TCOR2;
extern  DWORD *	TCNT2;
extern  WORD *	TCR2;
extern  DWORD *	TCPR2;

#define UNF 0x0100
/*** FIN TMU ***/

extern DWORD G2_FIFO;		// G2 FIFO
#define AICA_FIFO		(0x01)
#define EXTERNAL_FIFO	(0x10)

extern DWORD MAPLE_DMAADDR;		// 0xa05f6c04
extern DWORD MAPLE_RESET2;		// 0xa05f6c10
extern DWORD MAPLE_ENABLE;		// 0xa05f6c14
extern DWORD MAPLE_STATE;		// 0xa05f6c18
extern DWORD MAPLE_SPEED;		// 0xa05f6c80
extern DWORD MAPLE_RESET1;		// 0xa05f6c8c

extern DWORD snd_dbg;			// ...

extern unsigned long MACH; // Multiply-And-Accumulate register High
extern unsigned long MACL; // Multiply-And-Accumulate register Low
extern DWORD FPUL;
// extern float FPUL;
extern unsigned long PR;   // Procedure Register
extern unsigned long PC;   // Program Counter
extern unsigned long FPSCR; // Floating Point Status/Control Register
extern unsigned long delayslot;
extern unsigned long NEXTPC;

// #define R(n)		(registers[((n) > 7) ? ((n) + 8) : (IS_SET(SR, SR_MD) ? (n) : (IS_SET(SR, SR_RB) ? ((n) + 8) : (n)))])
#define R(n)		(registers[((n) > 7) ? ((n) + 8) : ((IS_SET(SR, SR_MD) && IS_SET(SR, SR_RB)) ? ((n) + 8) : (n))])
// #define R(n)		(registers[(n)])
// #define R_BANK(n)	(registers[IS_SET(SR, SR_MD) ? (IS_SET(SR, SR_RB) ? (n) : ((n) + 8)) : ((n) + 8)])
#define R_BANK(n)	(registers[((n) > 7) ? ((n) + 8) : ((IS_SET(SR, SR_MD) && IS_SET(SR, SR_RB)) ? ((n)) : (n + 8))])
// #define FR(n) ((FPSCR & FPSCR_FR) ? (float_registers[n + 16]) : (float_R(n)))
#define FR(n) (float_registers[(FPSCR & FPSCR_FR) ? ((n) + 16) : (n)])
#define FR_index(n) ((FPSCR & FPSCR_FR) ? ((n) + 16) : (n))
#define DR(n) (FR((n)*2))
#define DR_index(z) (FR_index((z)*2))
// #define XF(n) ((FPSCR & FPSCR_FR) ? (float_R(n)) : (float_registers[n + 16]))
#define XF(n) (float_registers[(FPSCR & FPSCR_FR) ? (n) : ((n) + 16)])
#define XF_index(n) ((FPSCR & FPSCR_FR) ? (n) : ((n) + 16))
#define XD(n) (XF((n)*2))
#define XD_index(n) (XF_index((n)*2))

// FPSCR
#define FPSCR_PR        (1<<19)
#define FPSCR_SZ        (1<<20)
#define FPSCR_FR        (1<<21)

// joystick
extern WORD joystick;

#define CONT_C  		(1<<0)
#define CONT_B  		(1<<1)
#define CONT_A  		(1<<2)
#define CONT_START		(1<<3)
#define CONT_DPAD_UP	(1<<4)
#define CONT_DPAD_DOWN  (1<<5)
#define CONT_DPAD_LEFT  (1<<6)
#define CONT_DPAD_RIGHT (1<<7)
#define CONT_Z  		   (1<<8)
#define CONT_Y  		   (1<<9)
#define CONT_X  		   (1<<10)
#define CONT_D  		   (1<<11)
#define CONT_DPAD2_UP		   (1<<12)
#define CONT_DPAD2_DOWN 	   (1<<13)
#define CONT_DPAD2_LEFT 	   (1<<14)
#define CONT_DPAD2_RIGHT	   (1<<15)

typedef struct {
	DWORD		func;
	DWORD		function_data[3];
	BYTE		area_code;
	BYTE		connector_direction;
	char		product_name[30];
	char		product_license[60];
	WORD		standby_power;
	WORD		max_power;
} maple_devinfo_t;

/* controller condition structure */
typedef struct {
	WORD buttons;			/* buttons bitfield */
	BYTE rtrig;			/* right trigger */
	BYTE ltrig;			/* left trigger */
	BYTE joyx;			/* joystick X */
	BYTE joyy;			/* joystick Y */
	BYTE joy2x;			/* second joystick X */
	BYTE joy2y;			/* second joystick Y */
} cont_cond_t;

struct TOC {
  unsigned int entry[99];
  unsigned int first, last;
  unsigned int dunno;
};

