{
   agbeBank - A rombank generator for the agbe emulator
   Author: Bruno Freitas (aka Sparrow) - 04/2004
   Contact: bootsector@ig.com.br

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2 of the License, or
   (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
}

unit uRom;

interface

uses SysUtils;

type

TRom = class
   private
      RomFileName: String;
      RomMenuName: String;
      procedure SetFileName(cFileName: String);
      procedure SetMenuName(cMenuName: String);

   public
      property FileName: String read RomFileName write SetFileName;
      property MenuName: String read RomMenuName write SetMenuName;
      constructor Create(cFileName: String; cMenuName: String);
end;

implementation


procedure TRom.SetFileName(cFileName: String);
begin
   RomFileName := cFileName;
end;

procedure TRom.SetMenuName(cMenuName: String);
begin
   //cMenuName := ReplaceRegExpr('\[.*\]'    , cMenuName, '');
   //cMenuName := ReplaceRegExpr('\(.*\)'    , cMenuName, '');
   //cMenuName := ReplaceRegExpr('\.[Gg][Bb]', cMenuName, '');

   RomMenuName := Trim(Copy(cMenuName, 1, 28));
end;

constructor TRom.Create(cFileName: String; cMenuName: String);
begin
   SetFileName(cFileName);
   SetMenuName(cMenuName);
end;

end.
