{
   agbeBank - A rombank generator for the agbe emulator
   Author: Bruno Freitas (aka Sparrow) - 04/2004
   Contact: bootsector@ig.com.br

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2 of the License, or
   (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
}

unit uFrmMain;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, Buttons, StdCtrls, ComCtrls;

type
  TfrmMain = class(TForm)
    GroupBox1: TGroupBox;
    SpeedButton1: TSpeedButton;
    SpeedButton2: TSpeedButton;
    SpeedButton3: TSpeedButton;
    GroupBox2: TGroupBox;
    SpeedButton4: TSpeedButton;
    SpeedButton5: TSpeedButton;
    SpeedButton6: TSpeedButton;
    RadioButton1: TRadioButton;
    RadioButton2: TRadioButton;
    GroupBox3: TGroupBox;
    ListBox1: TListBox;
    GroupBox4: TGroupBox;
    Edit1: TEdit;
    Label1: TLabel;
    Label2: TLabel;
    OpenDialog1: TOpenDialog;
    OpenDialog2: TOpenDialog;
    SaveDialog1: TSaveDialog;
    SpeedButton9: TSpeedButton;
    GroupBox5: TGroupBox;
    Edit2: TEdit;
    SpeedButton10: TSpeedButton;
    Label3: TLabel;
    Label4: TLabel;
    Edit3: TEdit;
    SpeedButton7: TSpeedButton;
    SpeedButton8: TSpeedButton;
    Label5: TLabel;
    Label6: TLabel;
    Edit4: TEdit;
    SpeedButton11: TSpeedButton;
    GroupBox6: TGroupBox;
    SpeedButton12: TSpeedButton;
    SpeedButton13: TSpeedButton;
    SpeedButton14: TSpeedButton;
    SpeedButton15: TSpeedButton;
    ProgressBar1: TProgressBar;
    procedure FormCreate(Sender: TObject);
    procedure SpeedButton1Click(Sender: TObject);
    procedure ListBox1Click(Sender: TObject);
    procedure Edit1Change(Sender: TObject);
    procedure SpeedButton2Click(Sender: TObject);
    procedure SpeedButton3Click(Sender: TObject);
    procedure SpeedButton4Click(Sender: TObject);
    procedure SpeedButton5Click(Sender: TObject);
    procedure SpeedButton6Click(Sender: TObject);
    procedure SpeedButton7Click(Sender: TObject);
    procedure SpeedButton8Click(Sender: TObject);
    procedure SpeedButton9Click(Sender: TObject);
    procedure SpeedButton10Click(Sender: TObject);
    procedure SpeedButton13Click(Sender: TObject);
    procedure SpeedButton15Click(Sender: TObject);
    procedure SpeedButton11Click(Sender: TObject);
    procedure SpeedButton12Click(Sender: TObject);
    procedure SpeedButton14Click(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  frmMain: TfrmMain;

const
  AGBE_VERSION = '1.1';
  SECTOR_SIZE = 2048;

type
  TTOCEntry = record
     RomName: array[0..27] of Char;
     RomSize: LongWord;
     RomOffSet: LongWord;
  end;

implementation

uses uBrowseForFolder, uRom, Math, RegExpr, uIsFunctions, CRC32,
  uFrmExtractRoms, uFrmISOMaker;

{$R *.dfm}

var
   RomsList: TList;

function SimpleExp(Exp: String): String;
var
   i: Integer;
begin
   Result := '';

   for i := 1 to Length(Exp) do begin
      if isAlpha(Exp[i]) then begin
         Result := Result + '[' + UpperCase(Exp[i]) + LowerCase(Exp[i]) + ']';
      end
      else if isNumber(Exp[i]) then begin
         Result := Result + Exp[i];
      end
      else if Exp[i] = '*' then begin
         Result := Result + '.*';
      end
      else begin
         Result := Result + '\' + Exp[i];
      end;
   end;
end;

function CSV(texto: String; delimitador: String; coluna: integer; total_colunas: integer): String;
var
   Lista: TStringList;
   valor: String;
   i: Integer;
   dentro_aspas: Boolean;
begin
   Result := '';

   if (coluna < 1) or (coluna > total_colunas) then Exit;
   if Length(Trim(texto)) = 0 then Exit;

   Lista := TStringList.Create;

   valor := '';
   dentro_aspas := False;
   for i := 1 to Length(texto) do begin
      if texto[i] = '"' then dentro_aspas := not dentro_aspas;
      if (texto[i] = delimitador) and (not dentro_aspas) then begin
         if Lista.Count < total_colunas then Lista.Add(valor);
         valor := '';
      end else
         if texto[i] <> '"' then valor := valor + texto[i];
   end;
   if Lista.Count < total_colunas then Lista.Add(valor);

   while Lista.Count < total_colunas do Lista.Add('');

   Result := Lista[coluna-1];

   Lista.Free;
end;


function GetROMSize(FileName: String): Integer;
const
 // Translation between ROM size byte contained in the ROM header, and the number
 // of 16Kb ROM banks the cartridge will contain

   romSizeTable: array[0..10] of array[0..1] of Integer =
             ((0, 2), (1, 4), (2, 8), (3, 16), (4, 32),
             (5, 64), (6, 128), (7, 256), ($52, 72), ($53, 80), ($54, 96));

var
   RomFile: TFileStream;
   SizeByte: Byte;
   i: Integer;
begin
   RomFile := TFileStream.Create(FileName, fmOpenRead);

   RomFile.Seek($148, soFromBeginning);
   RomFile.Read(SizeByte, 1);
   RomFile.Free;

   Result := -1;

   for i := 0 to 10 do begin
      if SizeByte = romSizeTable[i][0] then begin
         Result := romSizetable[i][1];
         break;
      end;
   end;
end;

procedure GenerateRomBank(Dir: String);
const
   FileName = 'agbebank.bin';

var
   TocEntry: TTOCEntry;
   i, j: integer;
   SECSize, TOCSize, PADSize: LongWord;
   OffSet: LongWord;
   RomFile, RBFile: TFileStream;
   PADByte: Byte;
begin
   // Add a backslash to Dir, if it is the case...
   if Copy(Dir, length(Dir), 1) <> '\' then
      Dir := Dir + '\';

   // Create Rombank bin file
   RBFile := TFileStream.Create(Dir + FileName, fmOpenReadWrite or fmCReate);

   TOCSize := Ceil((RomsList.Count + 1) * 36 / SECTOR_SIZE) * SECTOR_SIZE; // Total size of TOC
   OffSet := TOCSize;

   for i := 0 to RomsList.Count-1 do begin
      // Gets rom Name
      FillChar(TocEntry.RomName, 28, ' ');

      for j := 1 to length(TRom(RomsList[i]).MenuName) do
         TocEntry.RomName[j-1] := TRom(RomsList[i]).MenuName[j];

      // Gets rom file size...
      RomFile := TFileStream.Create(TRom(RomsList[i]).FileName, fmOpenRead);

      TocEntry.RomSize := RomFile.Size;

      RomFile.Free;

      TocEntry.RomOffSet := OffSet;

      OffSet := OffSet + LongWord((Ceil(TocEntry.RomSize / SECTOR_SIZE) * SECTOR_SIZE));

      RBFile.Write(TocEntry, SizeOf(TocEntry));

      // Update Progress Bar...
      //frmMain.ProgressBar1.Position := (i+1) * 100 div RomsList.Count;
   end;

   // Ending TOC Entry...
   FillChar(TocEntry.RomName, 28, 255);
   TocEntry.RomSize := 0;
   TocEntry.RomOffSet := 0;

   RBFile.Write(TocEntry, SizeOf(TocEntry));

   // Pads the TOC, so it can be a multipe of SECTOR_SIZE bytes...
   PADByte := $00;
   PADSize := TOCSize - LongWord(((RomsList.Count + 1) * 36));

   for i := 1 to PADSize do begin
      RBfile.Write(PADByte, 1);
   end;


   // Write the contents...

   for i := 0 to RomsList.Count-1 do begin
      // Open ROM file...
      RomFile := TFileStream.Create(TRom(RomsList[i]).FileName, fmOpenRead);

      RBFile.CopyFrom(RomFile, RomFile.Size);

      // PADs contents, if needed...
      SECSize := Ceil(RomFile.Size / SECTOR_SIZE) * SECTOR_SIZE;
      PADSize := SECSize - RomFile.Size;

      for j := 1 to PADSize do begin
         RBfile.Write(PADByte, 1);
      end;

      RomFile.Free;

      // Update Progress Bar...
      frmMain.ProgressBar1.Position := (i+1) * 100 div RomsList.Count;
      frmMain.Repaint;
   end;

   // Restart Progress Bar
   frmMain.ProgressBar1.Position := 0;

   RBFile.Free;
end;

function compareByFileName(Item1: Pointer; Item2: Pointer): Integer;
var
   Rom1, Rom2: TRom;
begin
   Rom1 := TRom(Item1);
   Rom2 := TRom(Item2);

   if UpperCase(Rom1.FileName) > UpperCase(Rom2.FileName) then
      Result := 1
   else if UpperCase(Rom1.FileName) = UpperCase(Rom2.FileName) then
      Result := 0
   else
      Result := -1;
end;

function compareByMenuName(Item1: Pointer; Item2: Pointer): Integer;
var
   Rom1, Rom2: TRom;
begin
   Rom1 := TRom(Item1);
   Rom2 := TRom(Item2);

   if UpperCase(Rom1.MenuName) > UpperCase(Rom2.MenuName) then
      Result := 1
   else if UpperCase(Rom1.MenuName) = UpperCase(Rom2.MenuName) then
      Result := 0
   else
      Result := -1;
end;

procedure UpdateList(CurPos: Integer);
var
   i: integer;
begin
   frmMain.ListBox1.Items.Clear;

   for i := 0 to RomsList.Count-1 do begin
      frmMain.ListBox1.Items.Add(TRom(RomsList[i]).FileName);
   end;

   frmMain.ListBox1.ItemIndex := CurPos;
   if CurPos <> -1 then
      frmMain.ListBox1.Selected[CurPos] := True;
   frmMain.ListBox1.SetFocus;
   frmMain.ListBox1Click(frmMain.ListBox1);
end;

procedure EmptyRomsList;
var
   i: Integer;
begin
   for i := 0 to RomsList.Count-1 do
      TRom(RomsList[i]).Free;

   RomsList.Clear;
end;

procedure AddROMsFolder(folder: String);
var
   sr: TSearchRec;
begin
   // Add a backslash to folder, if it is the case...
   if Copy(folder, length(folder), 1) <> '\' then
      folder := folder + '\';

   if FindFirst(folder + '*.gb', faAnyFile, sr) = 0 then begin

      repeat
         RomsList.Add(TRom.Create(folder + sr.Name, sr.Name));
      until FindNext(sr) <> 0;

      FindClose(sr);

      UpdateList(0);
   end else
      Application.MessageBox('No ROMs were found in the selected folder!', 'Alert', 0);
end;

procedure TfrmMain.FormCreate(Sender: TObject);
begin
   FrmMain.Caption := 'agbeBank v' + AGBE_VERSION;
   RomsList := Tlist.Create;
   ListBox1.ItemIndex := -1;
end;

procedure TfrmMain.SpeedButton1Click(Sender: TObject);
var
   dir: String;
begin
   dir := BrowseForFolder('Select the ROMs directory...');

   if dir <> '' then
      AddROMsFolder(dir);
end;

procedure TfrmMain.ListBox1Click(Sender: TObject);
begin
   if ListBox1.ItemIndex <> -1 then
      Edit1.Text := TRom(RomsList[ListBox1.ItemIndex]).MenuName
   else
      Edit1.Clear;
end;

procedure TfrmMain.Edit1Change(Sender: TObject);
begin
   if ListBox1.ItemIndex <> -1 then
      TRom(RomsList[ListBox1.ItemIndex]).MenuName := Edit1.Text;
end;

procedure TfrmMain.SpeedButton2Click(Sender: TObject);
begin
   if OpenDialog1.Execute then begin
      RomsList.Add(TRom.Create(OpenDialog1.FileName, ExtractFileName(OpenDialog1.FileName)));
      UpdateList(0);
   end;
end;

procedure TfrmMain.SpeedButton3Click(Sender: TObject);
var
   i: integer;
begin
   if ListBox1.ItemIndex <> -1 then begin
      for i := ListBox1.Count-1 downto 0 do begin
         if ListBox1.Selected[i] then begin
            TRom(RomsList[i]).Free;
            RomsList.Delete(i);
         end;
      end;
      UpdateList(-1);
   end;
end;

procedure TfrmMain.SpeedButton4Click(Sender: TObject);
begin
   if ListBox1.ItemIndex <> -1 then begin
      if ListBox1.ItemIndex > 0 then begin
         RomsList.Exchange(ListBox1.ItemIndex, ListBox1.ItemIndex-1);
         UpdateList(ListBox1.ItemIndex-1);
      end;
   end;
end;

procedure TfrmMain.SpeedButton5Click(Sender: TObject);
begin
   if ListBox1.ItemIndex <> -1 then begin
      if ListBox1.ItemIndex < ListBox1.Items.Count-1 then begin
         RomsList.Exchange(ListBox1.ItemIndex, ListBox1.ItemIndex+1);
         UpdateList(ListBox1.ItemIndex+1);
      end;
   end;
end;

procedure TfrmMain.SpeedButton6Click(Sender: TObject);
begin
   if RadioButton1.Checked then
      RomsList.Sort(compareByFileName)
   else
      RomsList.Sort(compareByMenuName);

   UpdateList(ListBox1.ItemIndex);
end;

procedure TfrmMain.SpeedButton7Click(Sender: TObject);
var
   OutFile: TextFile;
   i: integer;
   line: String;
begin
   if RomsList.Count < 1 then begin
      Application.MessageBox('There are no ROMs in the list. Please, add some ROMs first!', 'Alert', 0);
      Exit;
   end;

   if not SaveDialog1.Execute then exit;

   AssignFile(OutFile, SaveDialog1.FileName);
   Rewrite(OutFile);

   Writeln(OutFile, '#CRC32  |ROM MENU NAME               |ROM FILENAME');    
   for i := 0 to RomsList.Count-1 do begin
      line := IntToHex(CalculateCRC(TRom(RomsList[i]).FileName), 4) + '|' + TRom(RomsList[i]).MenuName + StringOfChar(' ', 28-length(TRom(RomsList[i]).MenuName)) + '|' + TRom(RomsList[i]).FileName;
      Writeln(OutFile, line);
   end;

   CloseFile(OutFile);

   Application.MessageBox('ROMs List saved successfully!', 'Message', 0);
end;

procedure TfrmMain.SpeedButton8Click(Sender: TObject);
var
   InFile: TextFile;
   line: String;
begin
   if OpenDialog2.Execute then begin
      if Application.MessageBox('All current ROMs are about to be excluded from the list. Do you want to continue?', 'Confirmation', MB_YESNO + MB_DEFBUTTON2) = mrNO then
         Exit;

      EmptyRomsList;

      AssignFile(InFile, OpenDialog2.FileName);
      Reset(InFile);

      Readln(InFile, line); // Ignore first line
      while not EOF(InFile) do begin
         Readln(InFile, line);

         if not FileExists(CSV(line, '|', 3, 3)) then begin
            Application.MessageBox(PChar('ROM File ' + CSV(line, '|', 3, 3) + ' not found! Skipped...'), 'Error', 0);
         end else begin
            if LongWord(StrToInt('$'+CSV(line, '|', 1, 3))) <> CalculateCRC(CSV(line, '|', 3, 3)) then begin
               Application.MessageBox(PChar('CRC32 from file ' + CSV(line, '|', 3, 3) + ' mismatch! Adding it anyway...'), 'Alert', 0);
            end;
            RomsList.Add(TRom.Create(CSV(line, '|', 3, 3), CSV(line, '|', 2, 3)));
         end
      end;

      CloseFile(InFile);

      UpdateList(0);

      Application.MessageBox('The ROMs list was loaded successfully!', 'Message', 0);
   end;
end;

procedure TfrmMain.SpeedButton9Click(Sender: TObject);
begin
   if ListBox1.Count < 1 then exit;

   if Application.MessageBox('Are you sure you want to clear the ROMs List?', 'Confirmation', MB_YESNO + MB_DEFBUTTON2) = MRYES then begin
      EmptyRomsList;
      UpdateList(-1);
   end;
end;

procedure TfrmMain.SpeedButton10Click(Sender: TObject);
var
   Filter: String;
   FilterCount: Integer;
   i, j: Integer;
begin

   if RomsList.Count < 1 then Exit;

   if Trim(Edit2.Text) = '' then begin
      Application.MessageBox('You must define the filters before apply them!', 'Alert', 0);
      Edit2.SetFocus;
      Exit;
   end;

   Filter := Edit2.Text;
   FilterCount := 0;

   for i := 1 to Length(Filter) do begin
      if Copy(Filter, i, 1) = ';' then
         Inc(FilterCount);
   end;

   Inc(FilterCount);

   // Check if values in filter are correct
   for i := 1 to FilterCount do begin
      Try
         StrToInt(CSV(Filter, ';', i, i));
      except
         Application.MessageBox('There are invalid values in Filters field!', 'Alert', 0);
         Exit;
      end;
   end;

   for i := RomsList.Count-1 downto 0 do begin
      for j := 1 to FilterCount do begin
         if GetROMSize(TRom(RomsList[i]).FileName) = StrToInt(CSV(Filter, ';', j, j)) then begin
            TRom(RomsList[i]).Free;
            RomsList.Delete(i);
            break;
         end;
      end;
   end;

   UpdateList(-1);
end;

procedure TfrmMain.SpeedButton13Click(Sender: TObject);
var
   dir: String;
begin
   if RomsList.Count < 1 then begin
      Application.MessageBox('There are no ROMs in the list. Please, add some ROMs first!', 'Alert', 0);
      Exit;
   end;

   dir := BrowseForFolder('Select the AGBEBANK.BIN destination directory...', ExtractFilePath(Application.ExeName));

   if dir <> '' then begin
      Screen.Cursor := crHourGlass;
      SpeedButton13.Enabled := False;
      GenerateRomBank(Dir);
      Application.MessageBox('AGBEBANK.BIN created successfully!', 'Message', 0);
      SpeedButton13.Enabled := True;
      Screen.Cursor := crDefault;
   end;
end;

procedure TfrmMain.SpeedButton15Click(Sender: TObject);
var
   Filter: String;
   FilterCount: Integer;
   i, j: Integer;
   tmp_name: String;
begin

   if RomsList.Count < 1 then Exit;

   if Trim(Edit3.Text) = '' then begin
      Application.MessageBox('You must define the Tag Removal List before apply!', 'Alert', 0);
      Edit3.SetFocus;
      Exit;
   end;

   Filter := Edit3.Text;
   FilterCount := 0;

   for i := 1 to Length(Filter) do begin
      if Copy(Filter, i, 1) = ';' then
         Inc(FilterCount);
   end;

   Inc(FilterCount);

   for i := RomsList.Count-1 downto 0 do begin

      tmp_name := ExtractFileName(TRom(RomsList[i]).FileName);

      for j := 1 to FilterCount do begin
         tmp_name := ReplaceRegExpr(SimpleExp(CSV(Filter, ';', j, j)), tmp_name, '');
      end;

      TRom(RomsList[i]).MenuName := tmp_name;
   end;

   UpdateList(0);
end;

procedure TfrmMain.SpeedButton11Click(Sender: TObject);
var
   Filter: String;
   FilterCount: Integer;
   i, j: Integer;
   tmp_name: String;
begin

   if RomsList.Count < 1 then Exit;

   if Trim(Edit4.Text) = '' then begin
      Application.MessageBox('You must define the Tag List before apply!', 'Alert', 0);
      Edit4.SetFocus;
      Exit;
   end;

   Filter := Edit4.Text;
   FilterCount := 0;

   for i := 1 to Length(Filter) do begin
      if Copy(Filter, i, 1) = ';' then
         Inc(FilterCount);
   end;

   Inc(FilterCount);

   for i := RomsList.Count-1 downto 0 do begin

      for j := 1 to FilterCount do begin
         tmp_name := ReplaceRegExpr(SimpleExp(CSV(Filter, ';', j, j)), ExtractFileName(TRom(RomsList[i]).FileName), '');

         if UpperCase(tmp_name) <> UpperCase(ExtractFileName(TRom(RomsList[i]).FileName)) then begin
            TRom(RomsList[i]).Free;
            RomsList.Delete(i);
            break;
         end;
      end;
   end;

   UpdateList(-1);
end;

procedure TfrmMain.SpeedButton12Click(Sender: TObject);
begin
   Application.CreateForm(TFrmISOMaker, FrmISOMaker);
   FrmISOMaker.ShowModal;
end;

procedure TfrmMain.SpeedButton14Click(Sender: TObject);
begin
   Application.CreateForm(TFrmExtractRoms, FrmExtractRoms);
   FrmExtractRoms.ShowModal;
end;

end.
