unit uFrmISOMaker;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, Buttons, StdCtrls, ExtCtrls, ComCtrls;

type
  TFrmISOMaker = class(TForm)
    GroupBox1: TGroupBox;
    Label1: TLabel;
    Edit1: TEdit;
    Label2: TLabel;
    Edit2: TEdit;
    SpeedButton1: TSpeedButton;
    SpeedButton2: TSpeedButton;
    GroupBox2: TGroupBox;
    Image1: TImage;
    Image2: TImage;
    Image3: TImage;
    Label3: TLabel;
    Label4: TLabel;
    Label5: TLabel;
    RadioButton1: TRadioButton;
    RadioButton2: TRadioButton;
    RadioButton3: TRadioButton;
    BitBtn1: TBitBtn;
    StatusBar1: TStatusBar;
    Label8: TLabel;
    Edit3: TEdit;
    BitBtn2: TBitBtn;
    procedure FormCreate(Sender: TObject);
    procedure Image1Click(Sender: TObject);
    procedure Image2Click(Sender: TObject);
    procedure Image3Click(Sender: TObject);
    procedure BitBtn1Click(Sender: TObject);
    procedure SpeedButton1Click(Sender: TObject);
    procedure SpeedButton2Click(Sender: TObject);
    procedure Edit3KeyPress(Sender: TObject; var Key: Char);
    procedure BitBtn2Click(Sender: TObject);
    procedure FormClose(Sender: TObject; var Action: TCloseAction);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  FrmISOMaker: TFrmISOMaker;

implementation

uses uResources, uBrowseForFolder, uFrmMain;

const
   PROGRAM_VERSION = '1.0';

var
   TEMP_PATH: String;

{$R *.dfm}

function CheckFiles(path: String): boolean;
begin
   path := IncludeTrailingBackslash(path);

   Result := True;

   if not FileExists(path + 'MAIN.EXE') then begin
      Application.MessageBox('File MAIN.EXE not found in the Source Directory', 'Error', 0);
      Result := False;
      Exit;
   end;
   if not FileExists(path + 'SYSTEM.CNF') then begin
      Application.MessageBox('File SYSTEM.CNF not found in the Source Directory', 'Error', 0);
      Result := False;
      Exit;
   end;
   if not FileExists(path + 'AGBEBANK.BIN') then begin
      Application.MessageBox('File AGBEBANK.BIN not found in the Source Directory. Please, go back to the main screen and generate the AGBEBANK.BIN file!', 'Error', 0);
      Result := False;
      Exit;
   end;
end;

procedure CleanUP;
begin
   DeleteFile(IncludeTrailingBackslash(TEMP_PATH) + 'psxiso_tmp.iso');
   DeleteFile(IncludeTrailingBackslash(TEMP_PATH) + 'mkisofs.exe');
   DeleteFile(IncludeTrailingBackslash(TEMP_PATH) + 'cygwin1.dll');
end;

procedure GenerateCue;
var
   CueFile: TextFile;
begin
   AssignFile(CueFile, IncludeTrailingBackslash(FrmISOMaker.Edit2.Text) + 'psxiso.cue');
   Rewrite(CueFile);

   WriteLn(CueFile, 'FILE "' + IncludeTrailingBackslash(FrmISOMaker.Edit2.Text) + 'psxiso.bin' + '" BINARY');
   WriteLn(CueFile, '  TRACK 01 MODE2/2352');
   WriteLn(CueFile, '    INDEX 01 00:00:00');

   CloseFile(CueFile);
end;

procedure LicenseFile;
var
   binfile: TFileStream;
begin
   binfile := TFileStream.Create(IncludeTrailingBackslash(FrmISOMaker.Edit2.Text) + 'psxiso.bin', fmOpenReadWrite);

   if FrmISOMaker.RadioButton1.Checked then
      binfile.Write(INFOUSA_DAT, sizeof(INFOUSA_DAT));

   if FrmISOMaker.RadioButton2.Checked then
      binfile.Write(INFOJAP_DAT, sizeof(INFOJAP_DAT));

   if FrmISOMaker.RadioButton3.Checked then
      binfile.Write(INFOEUR_DAT, sizeof(INFOEUR_DAT));

   binfile.Free;
end;

procedure Iso2Raw;
var
   sec: array[0..15] of Byte;
   sub: array[0..7] of Byte;
   buf: array[0..2047] of Byte;
   edc: array[0..3] of Byte;
   ecc: array[0..275] of Byte;

   infile, outfile: TFileStream;
   c: Integer;
   thesec: Integer;
   filesize: LongInt;

begin
   FillChar(sec, SizeOf(sec), $FF);
   sec[0]  := 0;
   sec[11] := 0;
   sec[12] := 0;
   sec[13] := 2;
   sec[14] := 0;
   sec[15] := 2;

   FillChar(sub, SizeOf(sub), $00);
   FillChar(edc, SizeOf(edc), $01);
   FillChar(ecc, SizeOf(ecc), $02);

   thesec := 0;

   infile := TFileStream.Create(IncludeTrailingBackslash(TEMP_PATH) + 'psxiso_tmp.iso', fmOpenRead);

   filesize := infile.Size;

   if (filesize mod 2048) <> 0 then begin
      Application.MessageBox('Standard ISO File Size is not Valid!', 'Error', 0);
      infile.Free;
      Exit;
   end;

   outfile := TFileStream.Create(IncludeTrailingBackslash(FrmISOMaker.Edit2.Text) + 'psxiso.bin', fmOpenReadWrite or fmCReate);

   while true do begin
      c := infile.read(buf, sizeof(buf));
      if (c = 0) then break;

      outfile.write(sec, sizeof(sec));
      outfile.write(sub, sizeof(sub));
      outfile.write(buf, c);
      outfile.write(edc, sizeof(edc));
      outfile.write(ecc, sizeof(ecc));

      Inc(thesec);

      if (thesec > 74) then begin
         thesec := 0;
         Inc(sec[13]);
      end;

      sec[14] := StrToInt('$'+IntToStr(thesec)); // (byte)Integer.parseInt(Integer.toString(thesec), 16);
   end;

   infile.Free;
   outfile.Free;
end;

procedure ExecuteMKISOFS;
var
   SUInfo: TStartupInfo;
   ProcInfo: TProcessInformation;
   commandline: string;
   Return: Boolean;
begin
   // This procedure executes MKISOFS.EXE and wait until it finishes

   commandline := '"' + IncludeTrailingBackslash(TEMP_PATH) + 'mkisofs.exe"' + ' -o ' + '"' + IncludeTrailingBackslash(TEMP_PATH) + 'psxiso_tmp.iso"' + ' -V ' + FrmISOMaker.Edit3.Text + ' -sysid PLAYSTATION ' + '"' + IncludeTrailingBackslash(FrmISOMaker.Edit1.Text) + '"';

   FillChar(SUInfo, SizeOf(SUInfo), #0);
   with SUInfo do begin
      cb := SizeOf(SUInfo);
      dwFlags := STARTF_USESHOWWINDOW;
      wShowWindow := SW_HIDE;
   end;

   Return := CreateProcess(NIL, PChar(commandline), NIL, NIL, FALSE,
              CREATE_NEW_CONSOLE or NORMAL_PRIORITY_CLASS, NIL,
              PChar(IncludeTrailingBackslash(ExtractFileDir(Application.EXEName))), SUInfo, ProcInfo);

   // Wait program termination
   if Return then begin
      WaitForSingleObject(ProcInfo.hProcess, INFINITE);
      // Clear Handles
      CloseHandle(ProcInfo.hProcess);
      CloseHandle(ProcInfo.hThread);
   end else
      Application.MessageBox('Error executing MKISOFS.EXE...', 'Erro!', MB_OK);
end;

procedure ExtractMKISOFS;
var
   exe, dll: TFileStream;
begin
   exe := TFileStream.Create(IncludeTrailingBackslash(TEMP_PATH) + 'mkisofs.exe', fmOpenReadWrite or fmCReate);
   dll := TFileStream.Create(IncludeTrailingBackslash(TEMP_PATH) + 'cygwin1.dll', fmOpenReadWrite or fmCReate);

   exe.Write(MKISOFS_EXE, SizeOf(MKISOFS_EXE));
   dll.Write(CYGWIN1_DLL, SizeOf(CYGWIN1_DLL));

   exe.Free;
   dll.Free;
end;

function TempPath: String;
var
   path: array[0..MAX_PATH] of Char;
begin
   GetTempPath(SizeOf(path), @path);
   Result := StrPas(path);
end;

procedure TFrmISOMaker.FormCreate(Sender: TObject);
begin
   Edit2.Text := ExtractFilePath(Application.ExeName);
   TEMP_PATH := TempPath;
end;

procedure TFrmISOMaker.Image1Click(Sender: TObject);
begin
   RadioButton1.Checked := True;
end;

procedure TFrmISOMaker.Image2Click(Sender: TObject);
begin
   RadioButton2.Checked := True;
end;

procedure TFrmISOMaker.Image3Click(Sender: TObject);
begin
   RadioButton3.Checked := True;
end;

procedure TFrmISOMaker.BitBtn1Click(Sender: TObject);
begin
   if Trim(Edit1.Text) = '' then begin
      Application.MessageBox('You must select the Source Directory!', 'Error', 0);
      Edit1.SetFocus;
      Exit;
   end;

   if not DirectoryExists(Edit1.Text) then begin
      Application.MessageBox('The Source Directory specified does not exist!', 'Error', 0);
      Edit1.SetFocus;
      Exit;
   end;

   if Trim(Edit2.Text) = '' then begin
      Application.MessageBox('You must select the Destination Directory!', 'Error', 0);
      Edit2.SetFocus;
      Exit;
   end;

   if not DirectoryExists(Edit2.Text) then begin
      Application.MessageBox('The Destination Directory specified does not exist!', 'Error', 0);
      Edit2.SetFocus;
      Exit;
   end;

   if Trim(Edit3.Text) = '' then begin
      Application.MessageBox('You must define the CD Label!', 'Error', 0);
      Edit3.SetFocus;
      Exit;
   end;

   if Application.MessageBox(PChar('Make sure you have ONLY the following files inside Source Directory.' + #13#13 + 'MAIN.EXE' + #13 + 'SYSTEM.CNF' + #13 + 'AGBEBANK.BIN' + #13#13 + 'The Source Directory may not contain subfolders, as well. Do you want proceed with ISO creation?'), 'Confirmation', MB_YESNO + MB_DEFBUTTON2) = MRNO then begin
      Exit;
   end;

   if not CheckFiles(Edit1.Text) then begin
      Edit1.SetFocus;
      Exit;
   end;

   BitBtn1.Enabled := False;
   BitBtn2.Enabled := False;
   Screen.Cursor := crHourGlass;

   StatusBar1.SimpleText := 'Setting up environment...';
   FrmISOMaker.Repaint;

   ExtractMKISOFS;

   StatusBar1.SimpleText := 'Generatig Standard ISO9660 File...';
   FrmISOMaker.Repaint;

   ExecuteMKISOFS;

   StatusBar1.SimpleText := 'Converting Standard ISO to MODE2/XA (PSX Format)...';
   FrmISOMaker.Repaint;

   Iso2Raw;

   StatusBar1.SimpleText := 'Licensing File...';
   FrmISOMaker.Repaint;

   LicenseFile;

   StatusBar1.SimpleText := 'Generating CUE File...';
   FrmISOMaker.Repaint;

   GenerateCue;

   StatusBar1.SimpleText := 'Finishing, Closing, and Going Home...';
   FrmISOMaker.Repaint;

   CleanUP;

   StatusBar1.SimpleText := 'Idle';
   FrmISOMaker.Repaint;

   BitBtn1.Enabled := True;
   BitBtn2.Enabled := True;
   Screen.Cursor := crDefault;

   Application.MessageBox(PChar('PSX ISO generated successfully! Now you just need to launch your favorite burning software and start burning the following .CUE file:' + #13#13 + IncludeTrailingBackslash(FrmISOMaker.Edit2.Text) + 'psxiso.cue'), 'Message', 0)
end;

procedure TFrmISOMaker.SpeedButton1Click(Sender: TObject);
var
   dir: String;
begin
   dir := BrowseForFolder('Select the Source Directory...');

   if dir <> '' then
      Edit1.Text := dir;
end;

procedure TFrmISOMaker.SpeedButton2Click(Sender: TObject);
var
   dir: String;
begin
   dir := BrowseForFolder('Select the PSXISO Destination Directory...');

   if dir <> '' then
      Edit2.Text := dir;
end;

procedure TFrmISOMaker.Edit3KeyPress(Sender: TObject; var Key: Char);
begin
   if Key = ' ' then Key := '_';
end;

procedure TFrmISOMaker.BitBtn2Click(Sender: TObject);
begin
   Close;
end;

procedure TFrmISOMaker.FormClose(Sender: TObject;
  var Action: TCloseAction);
begin
   Action := caFree;
end;

end.
