{
   agbeBank - A rombank generator for the agbe emulator
   Author: Bruno Freitas (aka Sparrow) - 04/2004
   Contact: bootsector@ig.com.br

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2 of the License, or
   (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
}

unit uFrmExtractRoms;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, Buttons, StdCtrls, ComCtrls;

type
  TFrmExtractRoms = class(TForm)
    GroupBox1: TGroupBox;
    Label1: TLabel;
    Edit1: TEdit;
    SpeedButton8: TSpeedButton;
    Label2: TLabel;
    Edit2: TEdit;
    SpeedButton1: TSpeedButton;
    OpenDialog1: TOpenDialog;
    BitBtn1: TBitBtn;
    ProgressBar1: TProgressBar;
    BitBtn2: TBitBtn;
    procedure FormClose(Sender: TObject; var Action: TCloseAction);
    procedure SpeedButton8Click(Sender: TObject);
    procedure SpeedButton1Click(Sender: TObject);
    procedure BitBtn1Click(Sender: TObject);
    procedure BitBtn2Click(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  FrmExtractRoms: TFrmExtractRoms;

implementation

uses uBrowseForFolder, uFrmMain;

{$R *.dfm}

procedure ExtractROMs(rombank:String; dest: String);
var
   bankfile: TFileStream;
   romfile: TFileStream;
   romscount, i: Integer;
   Pos: Int64;
   TOC: TTOCEntry;
   RomName: array[0..28] of Char;
begin
   bankfile := TFileStream.Create(rombank, fmOpenRead);
   dest := IncludeTrailingBackslash(dest);

   // Obtains how many roms there are inside rombank...
   romscount := 0;
   bankfile.Read(TOC, SizeOf(TOC));
   while (TOC.RomName[0] <> Chr($FF)) do begin
      Inc(romscount);
      bankfile.Read(TOC, SizeOf(TOC));
   end;

   bankfile.Seek(0, soFromBeginning);
   FrmExtractRoms.ProgressBar1.Position := 0;

   i := 0;
   bankfile.Read(TOC, SizeOf(TOC));
   while (TOC.RomName[0] <> Chr($FF)) do begin
      Pos := bankfile.Position;
      bankfile.Seek(TOC.RomOffSet, soFromBeginning);

      StrCopy(RomName, TOC.RomName);
      RomName[28] := Chr($00);
      
      romfile := TFileStream.Create(dest+Trim(StrPas(RomName))+'.gb', fmOpenReadWrite or fmCReate);
      romfile.CopyFrom(bankfile, TOC.RomSize);
      romfile.Free;

      bankfile.Seek(Pos, soFromBeginning);
      bankfile.Read(TOC, SizeOf(TOC));

      FrmExtractRoms.ProgressBar1.Position := (i+1) * 100 div romscount;
      FrmExtractRoms.Repaint;
      Inc(i);
   end;

   bankfile.Free;
end;

procedure TFrmExtractRoms.FormClose(Sender: TObject;
  var Action: TCloseAction);
begin
   Action := caFree;
   FrmExtractRoms := nil;
end;

procedure TFrmExtractRoms.SpeedButton8Click(Sender: TObject);
begin
   if OpenDialog1.Execute then begin
      Edit1.Text := OpenDialog1.FileName;
      Edit1.SetFocus;
   end;
end;

procedure TFrmExtractRoms.SpeedButton1Click(Sender: TObject);
var
   dir: String;
begin
   dir := BrowseForFolder('Select the extracted ROMs destination directory...');

   if dir <> '' then begin
      Edit2.Text := dir;
      Edit2.SetFocus;
   end;
end;

procedure TFrmExtractRoms.BitBtn1Click(Sender: TObject);
begin

   if Trim(Edit1.Text) = '' then begin
      Application.MessageBox('You must select aGBe Bank File', 'Error', 0);
      Edit1.SetFocus;
      Exit;
   end;

   if Trim(Edit2.Text) = '' then begin
      Application.MessageBox('You must select the destination directory', 'Error', 0);
      Edit2.SetFocus;
      Exit;
   end;

   if not FileExists(Edit1.Text) then begin
      Application.MessageBox('aGBe Rom Bank file not found!', 'Error', 0);
      Edit1.SetFocus;
      Exit;
   end;

   if not DirectoryExists(Edit2.Text) then begin
      Application.MessageBox('Destination directory not valid!', 'Error', 0);
      Edit2.SetFocus;
      Exit;
   end;

   Screen.Cursor := crHourGlass;
   BitBtn1.Enabled := False;
   BitBtn2.Enabled := False;

   ExtractROMs(Edit1.Text, Edit2.Text);

   ProgressBar1.Position := 0;

   Screen.Cursor := crDefault;
   BitBtn1.Enabled := True;
   BitBtn2.Enabled := True;

   Application.MessageBox('ROMs extracted successfully!', 'Message', 0);
end;

procedure TFrmExtractRoms.BitBtn2Click(Sender: TObject);
begin
   Close;
end;

end.
