/***********************************************************************************
  Snes9x - Portable Super Nintendo Entertainment System (TM) emulator.

  (c) Copyright 1996 - 2002  Gary Henderson (gary.henderson@ntlworld.com),
                             Jerremy Koot (jkoot@snes9x.com)

  (c) Copyright 2002 - 2004  Matthew Kendora

  (c) Copyright 2002 - 2005  Peter Bortas (peter@bortas.org)

  (c) Copyright 2004 - 2005  Joel Yliluoma (http://iki.fi/bisqwit/)

  (c) Copyright 2001 - 2006  John Weidman (jweidman@slip.net)

  (c) Copyright 2002 - 2006  funkyass (funkyass@spam.shaw.ca),
                             Kris Bleakley (codeviolation@hotmail.com)

  (c) Copyright 2002 - 2010  Brad Jorsch (anomie@users.sourceforge.net),
                             Nach (n-a-c-h@users.sourceforge.net),

  (c) Copyright 2002 - 2011  zones (kasumitokoduck@yahoo.com)

  (c) Copyright 2006 - 2007  nitsuja

  (c) Copyright 2009 - 2016  BearOso,
                             OV2


  BS-X C emulator code
  (c) Copyright 2005 - 2006  Dreamer Nom,
                             zones

  C4 x86 assembler and some C emulation code
  (c) Copyright 2000 - 2003  _Demo_ (_demo_@zsnes.com),
                             Nach,
                             zsKnight (zsknight@zsnes.com)

  C4 C++ code
  (c) Copyright 2003 - 2006  Brad Jorsch,
                             Nach

  DSP-1 emulator code
  (c) Copyright 1998 - 2006  _Demo_,
                             Andreas Naive (andreasnaive@gmail.com),
                             Gary Henderson,
                             Ivar (ivar@snes9x.com),
                             John Weidman,
                             Kris Bleakley,
                             Matthew Kendora,
                             Nach,
                             neviksti (neviksti@hotmail.com)

  DSP-2 emulator code
  (c) Copyright 2003         John Weidman,
                             Kris Bleakley,
                             Lord Nightmare (lord_nightmare@users.sourceforge.net),
                             Matthew Kendora,
                             neviksti

  DSP-3 emulator code
  (c) Copyright 2003 - 2006  John Weidman,
                             Kris Bleakley,
                             Lancer,
                             z80 gaiden

  DSP-4 emulator code
  (c) Copyright 2004 - 2006  Dreamer Nom,
                             John Weidman,
                             Kris Bleakley,
                             Nach,
                             z80 gaiden

  OBC1 emulator code
  (c) Copyright 2001 - 2004  zsKnight,
                             pagefault (pagefault@zsnes.com),
                             Kris Bleakley
                             Ported from x86 assembler to C by sanmaiwashi

  SPC7110 and RTC C++ emulator code used in 1.39-1.51
  (c) Copyright 2002         Matthew Kendora with research by
                             zsKnight,
                             John Weidman,
                             Dark Force

  SPC7110 and RTC C++ emulator code used in 1.52+
  (c) Copyright 2009         byuu,
                             neviksti

  S-DD1 C emulator code
  (c) Copyright 2003         Brad Jorsch with research by
                             Andreas Naive,
                             John Weidman

  S-RTC C emulator code
  (c) Copyright 2001 - 2006  byuu,
                             John Weidman

  ST010 C++ emulator code
  (c) Copyright 2003         Feather,
                             John Weidman,
                             Kris Bleakley,
                             Matthew Kendora

  Super FX x86 assembler emulator code
  (c) Copyright 1998 - 2003  _Demo_,
                             pagefault,
                             zsKnight

  Super FX C emulator code
  (c) Copyright 1997 - 1999  Ivar,
                             Gary Henderson,
                             John Weidman

  Sound emulator code used in 1.5-1.51
  (c) Copyright 1998 - 2003  Brad Martin
  (c) Copyright 1998 - 2006  Charles Bilyue'

  Sound emulator code used in 1.52+
  (c) Copyright 2004 - 2007  Shay Green (gblargg@gmail.com)

  S-SMP emulator code used in 1.54+
  (c) Copyright 2016         byuu

  SH assembler code partly based on x86 assembler code
  (c) Copyright 2002 - 2004  Marcus Comstedt (marcus@mc.pp.se)

  2xSaI filter
  (c) Copyright 1999 - 2001  Derek Liauw Kie Fa

  HQ2x, HQ3x, HQ4x filters
  (c) Copyright 2003         Maxim Stepin (maxim@hiend3d.com)

  NTSC filter
  (c) Copyright 2006 - 2007  Shay Green

  GTK+ GUI code
  (c) Copyright 2004 - 2016  BearOso

  Win32 GUI code
  (c) Copyright 2003 - 2006  blip,
                             funkyass,
                             Matthew Kendora,
                             Nach,
                             nitsuja
  (c) Copyright 2009 - 2016  OV2

  Mac OS GUI code
  (c) Copyright 1998 - 2001  John Stiles
  (c) Copyright 2001 - 2011  zones


  Specific ports contains the works of other authors. See headers in
  individual files.


  Snes9x homepage: http://www.snes9x.com/

  Permission to use, copy, modify and/or distribute Snes9x in both binary
  and source form, for non-commercial purposes, is hereby granted without
  fee, providing that this license information and copyright notice appear
  with all copies and any derived work.

  This software is provided 'as-is', without any express or implied
  warranty. In no event shall the authors be held liable for any damages
  arising from the use of this software or it's derivatives.

  Snes9x is freeware for PERSONAL USE only. Commercial users should
  seek permission of the copyright holders first. Commercial use includes,
  but is not limited to, charging money for Snes9x or software derived from
  Snes9x, including Snes9x or derivatives in commercial game bundles, and/or
  using Snes9x as a promotion for your commercial product.

  The copyright holders request that bug fixes and improvements to the code
  should be forwarded to them so everyone can benefit from the modifications
  in future versions.

  Super NES and Super Nintendo Entertainment System are trademarks of
  Nintendo Co., Limited and its subsidiary companies.
 ***********************************************************************************/


#include "snes9x.h"
#include "epx.h"


void EPX_16 (uint8 *srcPtr, int srcRowBytes, uint8 *dstPtr, int dstRowBytes, int width, int height)
{
	uint16	colorX, colorA, colorB, colorC, colorD;
	uint16	*sP, *uP, *lP;
	uint32	*dP1, *dP2;
	int		w;

	height -= 2;

	//   D
	// A X C
	//   B

	// top edge

	sP  = (uint16 *) srcPtr;
	lP  = (uint16 *) (srcPtr + srcRowBytes);
	dP1 = (uint32 *) dstPtr;
	dP2 = (uint32 *) (dstPtr + dstRowBytes);

	// left edge

	colorX = *sP;
	colorC = *++sP;
	colorB = *lP++;

	if ((colorX != colorC) && (colorB != colorX))
	{
	#ifdef MSB_FIRST
		*dP1 = (colorX << 16) + colorX;
		*dP2 = (colorX << 16) + ((colorB == colorC) ? colorB : colorX);
	#else
		*dP1 = colorX + (colorX << 16);
		*dP2 = colorX + (((colorB == colorC) ? colorB : colorX) << 16);
	#endif
	}
	else
		*dP1 = *dP2 = (colorX << 16) + colorX;

	dP1++;
	dP2++;

	//

	for (w = width - 2; w; w--)
	{
		colorA = colorX;
		colorX = colorC;
		colorC = *++sP;
		colorB = *lP++;

		if ((colorA != colorC) && (colorB != colorX))
		{
		#ifdef MSB_FIRST
			*dP1 = (colorX << 16) + colorX;
			*dP2 = (((colorA == colorB) ? colorA : colorX) << 16) + ((colorB == colorC) ? colorB : colorX);
		#else
			*dP1 = colorX + (colorX << 16);
			*dP2 = ((colorA == colorB) ? colorA : colorX) + (((colorB == colorC) ? colorB : colorX) << 16);
		#endif
		}
		else
			*dP1 = *dP2 = (colorX << 16) + colorX;

		dP1++;
		dP2++;
	}

	// right edge

	colorA = colorX;
	colorX = colorC;
	colorB = *lP;

	if ((colorA != colorX) && (colorB != colorX))
	{
	#ifdef MSB_FIRST
		*dP1 = (colorX << 16) + colorX;
		*dP2 = (((colorA == colorB) ? colorA : colorX) << 16) + colorX;
	#else
		*dP1 = colorX + (colorX << 16);
		*dP2 = ((colorA == colorB) ? colorA : colorX) + (colorX << 16);
	#endif
	}
	else
		*dP1 = *dP2 = (colorX << 16) + colorX;

	srcPtr += srcRowBytes;
	dstPtr += dstRowBytes << 1;

	//

	for (; height; height--)
	{
		sP  = (uint16 *) srcPtr;
		uP  = (uint16 *) (srcPtr - srcRowBytes);
		lP  = (uint16 *) (srcPtr + srcRowBytes);
		dP1 = (uint32 *) dstPtr;
		dP2 = (uint32 *) (dstPtr + dstRowBytes);

		// left edge

		colorX = *sP;
		colorC = *++sP;
		colorB = *lP++;
		colorD = *uP++;

		if ((colorX != colorC) && (colorB != colorD))
		{
		#ifdef MSB_FIRST
			*dP1 = (colorX << 16) + ((colorC == colorD) ? colorC : colorX);
			*dP2 = (colorX << 16) + ((colorB == colorC) ? colorB : colorX);
		#else
			*dP1 = colorX + (((colorC == colorD) ? colorC : colorX) << 16);
			*dP2 = colorX + (((colorB == colorC) ? colorB : colorX) << 16);
		#endif
		}
		else
			*dP1 = *dP2 = (colorX << 16) + colorX;

		dP1++;
		dP2++;

		//

		for (w = width - 2; w; w--)
		{
			colorA = colorX;
			colorX = colorC;
			colorC = *++sP;
			colorB = *lP++;
			colorD = *uP++;

			if ((colorA != colorC) && (colorB != colorD))
			{
			#ifdef MSB_FIRST
				*dP1 = (((colorD == colorA) ? colorD : colorX) << 16) + ((colorC == colorD) ? colorC : colorX);
				*dP2 = (((colorA == colorB) ? colorA : colorX) << 16) + ((colorB == colorC) ? colorB : colorX);
			#else
				*dP1 = ((colorD == colorA) ? colorD : colorX) + (((colorC == colorD) ? colorC : colorX) << 16);
				*dP2 = ((colorA == colorB) ? colorA : colorX) + (((colorB == colorC) ? colorB : colorX) << 16);
			#endif
			}
			else
				*dP1 = *dP2 = (colorX << 16) + colorX;

			dP1++;
			dP2++;
		}

		// right edge

		colorA = colorX;
		colorX = colorC;
		colorB = *lP;
		colorD = *uP;

		if ((colorA != colorX) && (colorB != colorD))
		{
		#ifdef MSB_FIRST
			*dP1 = (((colorD == colorA) ? colorD : colorX) << 16) + colorX;
			*dP2 = (((colorA == colorB) ? colorA : colorX) << 16) + colorX;
		#else
			*dP1 = ((colorD == colorA) ? colorD : colorX) + (colorX << 16);
			*dP2 = ((colorA == colorB) ? colorA : colorX) + (colorX << 16);
		#endif
		}
		else
			*dP1 = *dP2 = (colorX << 16) + colorX;

		srcPtr += srcRowBytes;
		dstPtr += dstRowBytes << 1;
	}

	// bottom edge

	sP  = (uint16 *) srcPtr;
	uP  = (uint16 *) (srcPtr - srcRowBytes);
	dP1 = (uint32 *) dstPtr;
	dP2 = (uint32 *) (dstPtr + dstRowBytes);

	// left edge

	colorX = *sP;
	colorC = *++sP;
	colorD = *uP++;

	if ((colorX != colorC) && (colorX != colorD))
	{
	#ifdef MSB_FIRST
		*dP1 = (colorX << 16) + ((colorC == colorD) ? colorC : colorX);
		*dP2 = (colorX << 16) + colorX;
	#else
		*dP1 = colorX + (((colorC == colorD) ? colorC : colorX) << 16);
		*dP2 = colorX + (colorX << 16);
	#endif
	}
	else
		*dP1 = *dP2 = (colorX << 16) + colorX;

	dP1++;
	dP2++;

	//

	for (w = width - 2; w; w--)
	{
		colorA = colorX;
		colorX = colorC;
		colorC = *++sP;
		colorD = *uP++;

		if ((colorA != colorC) && (colorX != colorD))
		{
		#ifdef MSB_FIRST
			*dP1 = (((colorD == colorA) ? colorD : colorX) << 16) + ((colorC == colorD) ? colorC : colorX);
			*dP2 = (colorX << 16) + colorX;
		#else
			*dP1 = ((colorD == colorA) ? colorD : colorX) + (((colorC == colorD) ? colorC : colorX) << 16);
			*dP2 = colorX + (colorX << 16);
		#endif
		}
		else
			*dP1 = *dP2 = (colorX << 16) + colorX;

		dP1++;
		dP2++;
	}

	// right edge

	colorA = colorX;
	colorX = colorC;
	colorD = *uP;

	if ((colorA != colorX) && (colorX != colorD))
	{
	#ifdef MSB_FIRST
		*dP1 = (((colorD == colorA) ? colorD : colorX) << 16) + colorX;
		*dP2 = (colorX << 16) + colorX;
	#else
		*dP1 = ((colorD == colorA) ? colorD : colorX) + (colorX << 16);
		*dP2 = colorX + (colorX << 16);
	#endif
	}
	else
		*dP1 = *dP2 = (colorX << 16) + colorX;
}
