/***********************************************************************************
 **
 ** Atari++ emulator (c) 2002 THOR-Software, Thomas Richter
 **
 ** $Id: basdist.cpp,v 1.43 2015/11/04 12:05:11 thor Exp $
 **
 ** In this module: The built-in Basic ROM.
 **********************************************************************************/

/// Includes
#include "basdist.hpp"
///

/// The Basic ROM hex dump.
const unsigned char basdist[] =
{
	0xa5,0xca,0xd0,0x06,0xe6,0x92,0xa5,0x08,0xd0,0x11,0x48,0x20,0x30,0xa5,0x68,0xd0,
	0x0a,0xa9,0xbf,0xa0,0xd3,0x20,0x79,0xb7,0x20,0x15,0xb3,0x20,0xca,0xb6,0x20,0x01,
	0xb8,0x20,0xa3,0xb7,0xa9,0xbf,0xa0,0xa0,0x20,0x79,0xb7,0xa2,0xff,0x9a,0xa5,0xca,
	0xd0,0xce,0x8d,0xfe,0x02,0x20,0xe0,0xb6,0x20,0xf6,0xb7,0xf0,0x0a,0xa5,0xc1,0xf0,
	0xea,0x20,0xf0,0xb6,0x4c,0x4b,0xb0,0x85,0xf2,0x85,0x9f,0x85,0x94,0x85,0xa6,0x85,
	0xb3,0x85,0xb1,0xa5,0x84,0x85,0xad,0xa5,0x85,0x85,0xae,0x20,0xa1,0xdb,0x20,0x31,
	0xa1,0x20,0x4c,0xa1,0xa5,0xa1,0x10,0x02,0x85,0xa6,0x20,0xa1,0xdb,0xa4,0xf2,0x84,
	0xa8,0xb1,0xf3,0xc9,0x9b,0xd0,0x12,0x24,0xa6,0x30,0xb0,0x20,0x74,0xa4,0xb0,0x06,
	0x20,0xb4,0xa4,0x20,0x26,0xa1,0x4c,0x2b,0xa0,0xa5,0x94,0x85,0xa7,0x20,0x4c,0xa1,
	0x20,0xa1,0xdb,0x20,0x73,0xa1,0x86,0xf2,0xa5,0xaf,0x20,0x4c,0xa1,0x20,0xa1,0xdb,
	0x20,0xf7,0xa1,0x90,0x03,0x20,0x3a,0xa4,0xa5,0x94,0xa4,0xa7,0x91,0x80,0xa4,0xf2,
	0x88,0xb1,0xf3,0xc9,0x9b,0xd0,0xd2,0xa0,0x02,0xa5,0x94,0x91,0x80,0x20,0xf4,0xa0,
	0x24,0xa6,0x50,0x28,0xa5,0xb1,0x0a,0x0a,0x0a,0xa8,0xa2,0x88,0x20,0x8d,0xb9,0x38,
	0xa5,0x84,0xe5,0xad,0xa8,0xa5,0x85,0xe5,0xae,0xa2,0x84,0x20,0x8f,0xb9,0x24,0xa6,
	0x10,0x05,0x20,0x8c,0xae,0xb0,0x0a,0x20,0x89,0xae,0xb0,0x05,0x10,0x03,0x4c,0xdd,
	0xa4,0x4c,0x2b,0xa0,0x20,0x74,0xa4,0xa9,0x00,0xb0,0x03,0x20,0xb4,0xa4,0x38,0xe5,
	0x94,0xf0,0x18,0xb0,0x13,0x49,0xff,0xa8,0xc8,0xa2,0x8a,0x20,0x0b,0xb9,0xa5,0x97,
	0x85,0x8a,0xa5,0x98,0x85,0x8b,0xd0,0x03,0x20,0x26,0xa1,0xa4,0x94,0x88,0xb1,0x80,
	0x91,0x8a,0x98,0xd0,0xf8,0x60,0x48,0x20,0xb9,0xa4,0x68,0xa8,0xa2,0x8a,0x4c,0x8d,
	0xb9,0x20,0x00,0xd8,0x90,0x08,0xa9,0x00,0x85,0xf2,0xa0,0x80,0x30,0x05,0x20,0x33,
	0xa6,0x30,0xf3,0x84,0xa1,0x85,0xa0,0x20,0x4c,0xa1,0xa5,0xa1,0xa4,0x94,0x91,0x80,
	0xe6,0x94,0xf0,0x01,0x60,0x20,0x05,0xba,0x0e,0xaa,0xc9,0x36,0x90,0x07,0xe8,0xc9,
	0x48,0xd0,0x02,0xa2,0x36,0x86,0xaf,0xa2,0x02,0xa9,0xba,0xa0,0x5f,0x20,0xd2,0xa1,
	0x4c,0x72,0xb7,0xa9,0xba,0xa0,0x5f,0xa2,0x02,0x20,0x8d,0xa1,0xa4,0xaf,0xb0,0x09,
	0xc0,0x36,0x90,0x08,0x18,0xd0,0x02,0xa0,0x49,0x88,0x84,0xaf,0x60,0x86,0xaa,0xa2,
	0xff,0x86,0xaf,0x20,0xf2,0xa1,0xe6,0xaf,0xa6,0xf2,0xa4,0xaa,0xb1,0x95,0x38,0xf0,
	0x30,0xa9,0x00,0x08,0xbd,0x80,0x05,0xc9,0x1b,0xf0,0x1b,0x29,0x7f,0xc9,0x2e,0xf0,
	0x11,0x51,0x95,0x0a,0xd0,0x10,0xc8,0xe8,0x90,0xea,0x28,0xf0,0x13,0x20,0xe9,0xa1,
	0x90,0xd4,0xa5,0xaa,0xd0,0x02,0x68,0x08,0xb1,0x95,0xc8,0x0a,0x90,0xfa,0xb0,0xe7,
	0x18,0x60,0x86,0xaa,0x20,0xf2,0xa1,0xa4,0xaa,0xc6,0xaf,0x30,0x0c,0x88,0xc8,0xb1,
	0x95,0x10,0xfb,0xc8,0x20,0xe9,0xa1,0x90,0xee,0x98,0x18,0x65,0x95,0xa8,0xa9,0x00,
	0x65,0x96,0x85,0x96,0x84,0x95,0x60,0xa0,0x01,0xb1,0x95,0x85,0xbf,0x88,0x84,0xb0,
	0xb1,0x95,0x85,0xbe,0x88,0x84,0xb3,0xa2,0x00,0x86,0xa9,0x20,0xdb,0xa2,0x20,0xf9,
	0xa2,0x30,0x18,0xc9,0x01,0x90,0x25,0xd0,0x07,0x20,0xf0,0xa2,0x90,0xf0,0xb0,0x28,
	0xc9,0x05,0x90,0x51,0x20,0x8a,0xa2,0x90,0xe5,0xb0,0x1d,0x38,0xa2,0x00,0xe9,0xc1,
	0xb0,0x01,0xca,0x18,0x65,0xbe,0xa8,0x8a,0x65,0xbf,0xd0,0x07,0x20,0xf9,0xa2,0xa8,
	0x20,0xf9,0xa2,0x20,0xc5,0xa2,0x90,0xc6,0x20,0xf9,0xa2,0x30,0xfb,0xc9,0x02,0xb0,
	0x08,0x20,0xf9,0xa2,0x20,0xf9,0xa2,0x90,0xef,0xc9,0x03,0xf0,0x18,0xb0,0xe9,0xa5,
	0xf2,0xc5,0x9f,0x90,0x02,0x85,0x9f,0xa6,0xa9,0xbd,0x80,0x04,0x85,0xf2,0xbd,0xc0,
	0x04,0x85,0x94,0xd0,0x99,0xa6,0xa9,0xf0,0x10,0xbd,0x00,0x05,0x85,0xbe,0xbd,0x40,
	0x05,0x85,0xbf,0xc6,0xa9,0xb0,0xc1,0x90,0x85,0x60,0xc9,0x0f,0xf0,0x08,0xb0,0x10,
	0xa0,0x5b,0xa9,0xbc,0xd0,0x2f,0x20,0xf9,0xa2,0xa4,0x94,0x88,0x91,0x80,0x18,0x60,
	0x20,0xa1,0xdb,0x20,0x04,0xa3,0xb0,0x1c,0xa0,0x00,0xb1,0xbe,0xc5,0xb0,0xf0,0x0a,
	0xc9,0x44,0xd0,0x0f,0xa5,0xb0,0xc9,0x44,0x90,0x09,0x20,0x4c,0xa1,0xa6,0xb2,0x86,
	0xf2,0x18,0x60,0x38,0x60,0xe6,0xa9,0xa6,0xa9,0xe0,0x40,0xb0,0x0a,0x48,0x20,0xdb,
	0xa2,0x68,0x85,0xbf,0x84,0xbe,0x60,0x20,0x05,0xba,0x0a,0xa5,0xf2,0x9d,0x80,0x04,
	0xa5,0x94,0x9d,0xc0,0x04,0xa5,0xbe,0x9d,0x00,0x05,0xa5,0xbf,0x9d,0x40,0x05,0x60,
	0x20,0xf9,0xa2,0x48,0x20,0xf9,0xa2,0x48,0x60,0xe6,0xbe,0xd0,0x02,0xe6,0xbf,0xa2,
	0x00,0xa1,0xbe,0x60,0xa2,0x00,0xa5,0xf2,0xc5,0xb3,0xf0,0x14,0x85,0xb3,0xa9,0xbb,
	0xa0,0xc2,0x20,0x8d,0xa1,0xb0,0x06,0x86,0xb2,0xa5,0xaf,0x69,0x12,0x85,0xb0,0x60,
	0xe4,0xb0,0x60,0xa4,0xf2,0xb1,0xf3,0xc9,0x41,0x90,0x03,0xc9,0x5b,0x60,0x38,0x60,
	0x20,0x00,0xd8,0xb0,0x10,0xa9,0x0e,0x20,0x4c,0xa1,0xa2,0xfa,0xb5,0xda,0x20,0x4c,
	0xa1,0xe8,0xd0,0xf8,0x18,0x60,0x20,0xa1,0xdb,0xa4,0xf2,0xb1,0xf3,0xc9,0x22,0xf0,
	0x02,0x38,0x60,0xa9,0x0f,0x20,0x4c,0xa1,0xa5,0x94,0x85,0xab,0x20,0x4c,0xa1,0xe6,
	0xf2,0xa4,0xf2,0xb1,0xf3,0xc9,0x9b,0xf0,0x0b,0xc9,0x22,0xf0,0x05,0x20,0x4c,0xa1,
	0xd0,0xed,0xe6,0xf2,0x18,0xa5,0x94,0xe5,0xab,0xa4,0xab,0x91,0x80,0x18,0x60,0xa9,
	0x00,0x2c,0xa9,0x80,0x85,0xd2,0x20,0xa1,0xdb,0xa5,0xf2,0x85,0xac,0x20,0x23,0xa3,
	0xb0,0x1f,0x20,0x04,0xa3,0x90,0x04,0xa5,0xac,0x85,0xb2,0xe6,0xf2,0x20,0x23,0xa3,
	0x90,0xf9,0x20,0xaf,0xdb,0x90,0xf4,0xb1,0xf3,0xc9,0x24,0xf0,0x06,0x24,0xd2,0x10,
	0x0d,0x38,0x60,0x24,0xd2,0x10,0xfa,0xc8,0xc4,0xb2,0xf0,0xf5,0xd0,0x0d,0xc4,0xb2,
	0xf0,0xef,0xc9,0x28,0xd0,0x05,0xc8,0xa9,0x40,0x85,0xd2,0xa5,0xac,0x84,0xac,0x85,
	0xf2,0xa5,0x83,0xa4,0x82,0xa2,0x00,0x20,0x8d,0xa1,0xb0,0x0c,0xe4,0xac,0xf0,0x3d,
	0x20,0xe9,0xa1,0x20,0x96,0xa1,0xf0,0xf2,0xa5,0xaf,0x30,0x43,0x85,0xd3,0xa0,0x08,
	0xa2,0x88,0x20,0x0b,0xb9,0xe6,0xb1,0x38,0xa5,0xac,0xe5,0xf2,0x85,0xf2,0xa8,0xa2,
	0x84,0x20,0x0b,0xb9,0xa4,0xf2,0xa6,0xac,0x88,0xa9,0x80,0x1d,0x7f,0x05,0x91,0x97,
	0xca,0xbd,0x7f,0x05,0x88,0x10,0xf7,0x20,0x44,0xda,0x20,0x1c,0xa8,0xa4,0xac,0x24,
	0xd2,0x50,0x01,0x88,0x84,0xf2,0xa5,0xaf,0x09,0x80,0x20,0x4c,0xa1,0x18,0x60,0x20,
	0x05,0xba,0x04,0x20,0x62,0xa4,0x68,0x68,0x18,0x60,0xa4,0x9f,0xb1,0xf3,0xc9,0x9b,
	0xd0,0x06,0xc8,0x91,0xf3,0xa9,0x20,0x88,0x09,0x80,0x91,0xf3,0xa9,0x40,0x05,0xa6,
	0x85,0xa6,0xa4,0xa8,0x84,0xf2,0xa2,0x03,0x86,0xa7,0xe8,0x86,0x94,0xa9,0x37,0x20,
	0x4c,0xa1,0xa4,0xf2,0xb1,0xf3,0x20,0x4c,0xa1,0xe6,0xf2,0xc9,0x9b,0xd0,0xf3,0x60,
	0x85,0xa0,0x84,0xa1,0xa5,0x8a,0x85,0xbe,0xa5,0x8b,0x85,0xbf,0xa0,0x00,0xa5,0xa0,
	0xd1,0x8a,0xc8,0xa5,0xa1,0xf1,0x8a,0xb0,0x16,0xa4,0x88,0xa5,0x89,0x84,0x8a,0x85,
	0x8b,0xd0,0x0c,0xa0,0x02,0xb1,0x8a,0x65,0x8a,0x85,0x8a,0x90,0x02,0xe6,0x8b,0xa0,
	0x01,0xb1,0x8a,0xc5,0xa1,0x90,0xec,0xd0,0x0a,0x88,0xb1,0x8a,0xc5,0xa0,0x90,0xe3,
	0xd0,0x01,0x18,0x60,0xa0,0x02,0xb1,0x8a,0x60,0x18,0x65,0x8a,0x85,0x8a,0x90,0x02,
	0xe6,0x8b,0x60,0xa6,0xa8,0xe8,0xe4,0xa7,0x60,0xa0,0x01,0xb1,0x8a,0x60,0x20,0xc9,
	0xa4,0x30,0x07,0x85,0xbb,0x88,0xb1,0x8a,0x85,0xba,0x4c,0x01,0xb8,0x20,0x26,0xa5,
	0x20,0xf6,0xb7,0xd0,0x28,0xa4,0xa7,0xc4,0x9f,0xb0,0x10,0xb1,0x8a,0x85,0xa7,0xc8,
	0xb1,0x8a,0xc8,0x84,0xa8,0x20,0x13,0xa5,0x18,0x90,0xe5,0x20,0xc9,0xa4,0x30,0x10,
	0xa5,0x9f,0x20,0xb9,0xa4,0x20,0xc9,0xa4,0x10,0xd3,0x4c,0x5e,0xb0,0x4c,0x4b,0xb0,
	0x4c,0x21,0xa0,0xc9,0x48,0xd0,0x02,0xa9,0x38,0xaa,0xbd,0x7c,0xbe,0x48,0xbd,0x43,
	0xbe,0x48,0x60,0x20,0x74,0xa4,0xa0,0x02,0xb1,0x8a,0x85,0x9f,0xc8,0x84,0xa7,0x60,
	0xae,0xe7,0x02,0xac,0xe8,0x02,0x86,0x80,0x84,0x81,0x20,0x01,0xb8,0x85,0xca,0x85,
	0x92,0xc8,0x8a,0xa2,0x10,0x95,0x80,0x94,0x81,0xca,0xca,0xd0,0xf8,0xa2,0x86,0xa0,
	0x01,0x20,0x0b,0xb9,0xa2,0x8c,0xa0,0x03,0x20,0x0b,0xb9,0xa9,0x00,0xa8,0x91,0x84,
	0x91,0x8a,0xc8,0xa9,0x80,0x91,0x8a,0xc8,0xa9,0x03,0x91,0x8a,0xa9,0x0a,0x85,0xc9,
	0xa0,0x00,0x84,0xba,0x84,0xfb,0x84,0xb6,0x84,0xb7,0x84,0xb8,0x88,0x84,0xbd,0x84,
	0xbb,0x84,0x11,0x60,0xa4,0xa8,0xe6,0xa8,0xb1,0x8a,0x30,0x22,0xc9,0x0f,0x90,0x09,
	0xd0,0x1b,0xc8,0xb1,0x8a,0xa2,0x8a,0xd0,0x0b,0x20,0xd0,0xa5,0xc8,0x98,0xa2,0x00,
	0x86,0xd2,0xf0,0x06,0x20,0xdb,0xa5,0x98,0x65,0xd6,0x85,0xa8,0x18,0x60,0x20,0xba,
	0xa5,0xb1,0x9d,0x99,0xd2,0x00,0x88,0x10,0xf8,0x60,0x0a,0x2a,0x2a,0x2a,0xa8,0x29,
	0xf0,0x6a,0x65,0x86,0x85,0x9d,0x98,0x29,0x03,0x65,0x87,0x85,0x9e,0xa0,0x07,0x60,
	0xa2,0xfa,0xc8,0xb1,0x8a,0x95,0xda,0xe8,0xd0,0xf8,0x60,0x85,0xd6,0x85,0xd8,0xc8,
	0x98,0x18,0x75,0x00,0x85,0xd4,0xa9,0x00,0x85,0xd7,0x85,0xd9,0x85,0xd3,0x75,0x01,
	0x85,0xd5,0xa2,0x83,0x86,0xd2,0x60,0x20,0x3b,0xa6,0xaa,0xf0,0x09,0xc9,0x08,0xb0,
	0x05,0x85,0xc1,0x4c,0x4a,0xb7,0x20,0x05,0xba,0x14,0x20,0x2d,0xa6,0x30,0x01,0x60,
	0x20,0x05,0xba,0x07,0x20,0x30,0xa6,0xd0,0x03,0xaa,0xf0,0x01,0x60,0x20,0x05,0xba,
	0x05,0x20,0x30,0xa6,0xd0,0x1d,0x60,0x20,0xea,0xa6,0x4c,0x4d,0xa6,0x20,0xea,0xa6,
	0x20,0x4d,0xa6,0x20,0x26,0xb4,0xa5,0xd4,0xa4,0xd5,0x60,0xe6,0xa8,0x20,0x2d,0xa6,
	0xd0,0x01,0x60,0x20,0x05,0xba,0x03,0x20,0x4d,0xa6,0x20,0xb6,0xdd,0xc6,0xaa,0xa6,
	0xaa,0xbd,0x80,0x04,0x85,0xd2,0xbd,0xa0,0x04,0x85,0xd3,0xbd,0xc0,0x04,0x85,0xd4,
	0xbd,0xe0,0x04,0x85,0xd5,0xbd,0x00,0x05,0x85,0xd6,0xbd,0x20,0x05,0x85,0xd7,0xbd,
	0x40,0x05,0x85,0xd8,0xbd,0x60,0x05,0x85,0xd9,0x60,0x85,0xd4,0x84,0xd5,0x20,0xaa,
	0xd9,0xa9,0x00,0x85,0xd2,0xa6,0xaa,0xa5,0xd2,0x9d,0x80,0x04,0xa5,0xd3,0x9d,0xa0,
	0x04,0xa5,0xd4,0x9d,0xc0,0x04,0xa5,0xd5,0x9d,0xe0,0x04,0xa5,0xd6,0x9d,0x00,0x05,
	0xa5,0xd7,0x9d,0x20,0x05,0xa5,0xd8,0x9d,0x40,0x05,0xa5,0xd9,0x9d,0x60,0x05,0xe6,
	0xaa,0xf0,0x01,0x60,0x20,0x05,0xba,0x0a,0x85,0xb1,0xa0,0xff,0xa9,0x11,0x91,0x80,
	0x84,0xa9,0xc8,0x84,0xb0,0x84,0xaa,0x60,0xa0,0x00,0x85,0xd4,0x84,0xd5,0x20,0xaa,
	0xd9,0x20,0x85,0xa6,0xa5,0xd2,0x30,0x0c,0xd0,0x03,0x4c,0xed,0xa8,0xa9,0x80,0x85,
	0xb1,0x4c,0x1e,0xaa,0x4c,0x00,0xa9,0xa9,0x40,0x2c,0xa9,0x00,0x20,0xb8,0xa6,0x2c,
	0xa4,0xa9,0x98,0xd0,0x27,0x20,0x84,0xa5,0xb0,0x05,0x20,0x85,0xa6,0xd0,0xf6,0x85,
	0xab,0xaa,0xbd,0x15,0xbf,0x4a,0x4a,0x4a,0x4a,0x85,0xac,0xa4,0xa9,0xb1,0x80,0xaa,
	0xbd,0x15,0xbf,0x29,0x0f,0xc5,0xac,0x90,0x0d,0xaa,0xf0,0x13,0xb1,0x80,0xe6,0xa9,
	0x20,0x30,0xa7,0x18,0x90,0xe5,0x88,0x84,0xa9,0xa5,0xab,0x91,0x80,0x90,0xc6,0x60,
	0xaa,0xbd,0xd0,0xbe,0x48,0xbd,0x98,0xbe,0x48,0x60,0xa4,0xa9,0x88,0xb1,0x80,0xc9,
	0x2f,0xb0,0x20,0x20,0x47,0xa6,0x20,0x32,0xb4,0xa2,0xd4,0x2c,0xa2,0xe0,0xb5,0x00,
	0x29,0x7f,0xd0,0x0c,0xb5,0x01,0x15,0x02,0x15,0x03,0x15,0x04,0x15,0x05,0xf0,0x02,
	0x15,0x00,0x60,0x20,0xa7,0xa7,0x20,0xb6,0xdd,0x20,0xa7,0xa7,0xa0,0x00,0xa2,0xd6,
	0x20,0x99,0xa7,0x08,0xa2,0xe2,0x20,0x99,0xa7,0xf0,0x14,0x28,0xf0,0x15,0xb1,0xd4,
	0xd1,0xe0,0x90,0x0f,0xd0,0x10,0xc8,0xd0,0xe5,0xe6,0xd5,0xe6,0xe1,0xd0,0xdf,0x28,
	0xd0,0x04,0x60,0xa9,0x80,0x60,0xa9,0x01,0x60,0xb5,0x00,0xd0,0x06,0xb5,0x01,0xf0,
	0x05,0xd6,0x01,0xd6,0x00,0x8a,0x60,0x20,0x4d,0xa6,0xa9,0x02,0x24,0xd2,0xd0,0x15,
	0x05,0xd2,0x85,0xd2,0x6a,0x90,0x61,0x18,0xa5,0xd4,0x65,0x8c,0x85,0xd4,0xa8,0xa5,
	0xd5,0x65,0x8d,0x85,0xd5,0x60,0xa0,0x00,0x84,0xf7,0x84,0xf8,0xc4,0xd9,0xd0,0x05,
	0xc8,0xc4,0xd8,0xf0,0x25,0xa0,0x10,0xa5,0xf5,0x4a,0x90,0x0e,0x18,0xa2,0xfe,0xb5,
	0xf9,0x75,0xda,0x95,0xf9,0xe8,0xd0,0xf7,0xb0,0x2e,0xa2,0x03,0x76,0xf5,0xca,0x10,
	0xfb,0x88,0xd0,0xe3,0xa5,0xf7,0x05,0xf8,0xd0,0x1e,0x60,0x06,0xf5,0x26,0xf6,0xb0,
	0x17,0xa4,0xf6,0xa5,0xf5,0x06,0xf5,0x26,0xf6,0xb0,0x0d,0x18,0x65,0xf5,0x85,0xf5,
	0x98,0x65,0xf6,0x85,0xf6,0xb0,0x01,0x60,0x20,0x05,0xba,0x09,0xa5,0xd3,0x20,0xba,
	0xa5,0xb9,0xd2,0x00,0x91,0x9d,0x88,0x10,0xf8,0x60,0x20,0xea,0xa6,0x20,0xa7,0xa7,
	0xa0,0xff,0xa5,0xd7,0xf0,0x02,0x84,0xd6,0xc8,0xc4,0xd6,0xb0,0x09,0xb1,0xd4,0x99,
	0x80,0x05,0xc8,0x10,0xf4,0x88,0xa9,0x9b,0x99,0x80,0x05,0x4c,0x51,0xda,0x20,0x3a,
	0xa7,0x30,0x60,0xf0,0x5e,0x10,0x52,0x20,0x3a,0xa7,0xf0,0x4d,0xd0,0x55,0x20,0x3a,
	0xa7,0x30,0x50,0x10,0x44,0x20,0x3a,0xa7,0x30,0x3f,0xf0,0x3d,0x10,0x45,0x20,0x3a,
	0xa7,0x30,0x36,0x10,0x3e,0x20,0x3a,0xa7,0xf0,0x39,0xd0,0x2d,0x20,0x47,0xa6,0x20,
	0x49,0xa7,0xf0,0x25,0xd0,0x08,0x20,0x47,0xa6,0x20,0x49,0xa7,0xd0,0x25,0x20,0x4c,
	0xa7,0xd0,0x20,0xf0,0x14,0x20,0x4d,0xa6,0x20,0x49,0xa7,0x30,0x11,0xd0,0x14,0xf0,
	0x08,0x20,0x4d,0xa6,0x20,0x49,0xa7,0xf0,0x0a,0x20,0x44,0xda,0xf0,0x13,0x20,0x35,
	0xb5,0xf0,0x0e,0x20,0x38,0xb5,0xf0,0x09,0x20,0x4d,0xa6,0xa5,0xd4,0x29,0x7f,0x85,
	0xd4,0x4c,0x81,0xa6,0x20,0x47,0xa6,0x20,0x2c,0xb4,0x90,0xf5,0x20,0x47,0xa6,0x20,
	0x32,0xb4,0x90,0xed,0x20,0x47,0xa6,0x20,0x38,0xb4,0x90,0xe5,0x20,0x47,0xa6,0x20,
	0x3e,0xb4,0x90,0xdd,0x20,0x4d,0xa6,0x20,0x74,0xb4,0x4c,0x81,0xa6,0xa4,0xa9,0xc8,
	0xd0,0x09,0x20,0x47,0xa6,0x20,0x47,0xb5,0x4c,0x1c,0xa8,0xa9,0x80,0x85,0xb1,0x60,
	0x20,0xa7,0xa7,0xa5,0xd4,0x85,0x99,0xa5,0xd5,0x85,0x9a,0xa5,0xd6,0x85,0xa2,0xa5,
	0xd7,0x85,0xa3,0xa4,0xa9,0xc8,0xf0,0x0f,0xa9,0x80,0x85,0xb1,0x20,0xf0,0xa6,0xa5,
	0xd7,0xa4,0xd6,0x26,0xb1,0xb0,0x07,0x20,0xa7,0xa7,0xa5,0xd9,0xa4,0xd8,0xc5,0xa3,
	0x90,0x06,0xd0,0x08,0xc4,0xa2,0xb0,0x04,0x85,0xa3,0x84,0xa2,0x18,0xa5,0xd4,0x65,
	0xa2,0xa8,0xa5,0xd5,0x65,0xa3,0xaa,0x38,0x98,0xe5,0x8c,0xa8,0x8a,0xe5,0x8d,0x48,
	0x98,0x48,0xa9,0x00,0xe5,0xa2,0x85,0xa2,0xa2,0xd4,0x20,0xcf,0xb9,0xa5,0xd3,0x20,
	0xae,0xa5,0x38,0x68,0xe5,0xd4,0xa8,0x68,0xe5,0xd5,0xaa,0xa9,0x02,0x24,0xb1,0xf0,
	0x08,0x98,0xc5,0xd6,0x8a,0xe5,0xd7,0x90,0x07,0x84,0xd6,0x86,0xd7,0x4c,0x1c,0xa8,
	0x60,0xe6,0xb0,0x68,0x68,0x4c,0xf0,0xa6,0xa5,0xb0,0xf0,0x07,0x20,0x14,0xa6,0x85,
	0x97,0x84,0x98,0x20,0x14,0xa6,0x38,0xe9,0x01,0x85,0xf5,0x98,0xe9,0x00,0x85,0xf6,
	0x20,0x4d,0xa6,0xa4,0xd7,0xa5,0xd6,0x24,0xb1,0x10,0x0a,0xa5,0xb1,0x05,0xb0,0x85,
	0xb1,0xa4,0xd9,0xa5,0xd8,0xa6,0xb0,0xf0,0x0d,0xc6,0xb0,0xc5,0x97,0x98,0xe5,0x98,
	0x90,0x30,0xa5,0x97,0xa4,0x98,0x38,0xe5,0xf5,0x85,0xd6,0x98,0xe5,0xf6,0x85,0xd7,
	0x90,0x20,0x24,0xb1,0x10,0x04,0x05,0xd6,0xf0,0x18,0x20,0xaa,0xa7,0x18,0xa5,0xd4,
	0x65,0xf5,0x85,0xd4,0xa5,0xd5,0x65,0xf6,0x85,0xd5,0x24,0xb1,0x30,0x03,0x20,0x85,
	0xa6,0x60,0x20,0x05,0xba,0x05,0xa9,0x00,0xa8,0xc5,0xb0,0xf0,0x03,0x20,0x30,0xa6,
	0x85,0x97,0x84,0x98,0x20,0x30,0xa6,0x85,0xf5,0x84,0xf6,0x20,0x4d,0xa6,0xa5,0xd2,
	0x4a,0x45,0xb0,0x90,0x05,0x4a,0xb0,0x72,0x90,0x03,0x0a,0x85,0xd2,0x60,0xa5,0xaa,
	0x48,0x24,0xb1,0x10,0x02,0xc6,0xaa,0x20,0xf6,0xa9,0x68,0x24,0xb1,0x50,0x07,0xa4,
	0xaa,0xd0,0x07,0x85,0xaa,0x60,0x10,0x02,0x85,0xaa,0x66,0xd2,0x90,0x4c,0xa5,0xf5,
	0xc5,0xd6,0xa5,0xf6,0xe5,0xd7,0xb0,0x42,0xa5,0x97,0xc5,0xd8,0xa5,0x98,0xe5,0xd9,
	0xb0,0x38,0x20,0xc6,0xa7,0xa5,0x97,0xa4,0x98,0x20,0x0b,0xa8,0x20,0xfb,0xa7,0xa5,
	0xd4,0xa4,0xd5,0x20,0x0b,0xa8,0xa5,0x8c,0xa4,0x8d,0x20,0x0b,0xa8,0x24,0xb1,0x10,
	0x0a,0x20,0x4d,0xa6,0xa6,0xf5,0xa4,0xf6,0x4c,0xa7,0xdd,0xa6,0xf5,0xa4,0xf6,0x20,
	0x89,0xdd,0xc8,0x84,0xd2,0x84,0xb0,0x4c,0x85,0xa6,0x20,0x05,0xba,0x09,0x20,0x4d,
	0xa6,0x20,0xe6,0xd8,0xa5,0xaa,0x0a,0x0a,0x0a,0x0a,0x29,0x30,0x69,0x1f,0xaa,0x86,
	0xf7,0xa0,0xff,0xc8,0xe8,0xb1,0xf3,0x9d,0x80,0x05,0x10,0xf7,0x29,0x7f,0x9d,0x80,
	0x05,0xc8,0x20,0x51,0xda,0x98,0xa4,0xf7,0xd0,0x15,0x20,0x21,0xa6,0x48,0x20,0x51,
	0xda,0xa5,0xaa,0x29,0x0f,0x09,0x10,0xa8,0x68,0x99,0x80,0x05,0xa9,0x01,0x88,0xa2,
	0xf3,0x20,0xdb,0xa5,0x4c,0x85,0xa6,0x20,0xe0,0xaa,0x20,0xaa,0xd9,0x4c,0x85,0xa6,
	0xa5,0xb0,0x85,0xc6,0x20,0x30,0xa6,0xc6,0xc6,0x30,0x09,0xa5,0xd4,0x48,0xa5,0xd5,
	0x48,0x18,0x90,0xf0,0xa5,0xb0,0x48,0x6c,0xd4,0x00,0x20,0xa7,0xa7,0xa5,0xd6,0x05,
	0xd7,0xf0,0x07,0xa0,0x00,0xb1,0xd4,0x4c,0x7a,0xa6,0x20,0x05,0xba,0x05,0x20,0xa7,
	0xa7,0xa5,0xd4,0xa4,0xd5,0x4c,0x7a,0xa6,0x20,0xa7,0xa7,0xa5,0xd6,0xa4,0xd7,0x4c,
	0x7a,0xa6,0x20,0x30,0xa6,0xa0,0x00,0xb1,0xd4,0x4c,0x7a,0xa6,0xa2,0x6a,0xa0,0xbf,
	0x20,0x98,0xdd,0x20,0x4d,0xa6,0xad,0x0a,0xd2,0x85,0xd5,0xad,0x0a,0xd2,0x85,0xd4,
	0x20,0xaa,0xd9,0x20,0x28,0xdb,0x4c,0x81,0xa6,0x20,0x4d,0xa6,0x38,0xad,0xe5,0x02,
	0xe5,0x90,0x85,0xd4,0xad,0xe6,0x02,0xe5,0x91,0x85,0xd5,0x4c,0x7e,0xa6,0xa9,0x00,
	0x2c,0xa9,0x08,0x2c,0xa9,0x0c,0x2c,0xa9,0x14,0x48,0x20,0x21,0xa6,0x68,0x18,0x65,
	0xd4,0xaa,0xbd,0x70,0x02,0xa0,0x00,0x4c,0x7a,0xa6,0x20,0x05,0xba,0x03,0x20,0x2d,
	0xa8,0xa9,0x00,0x85,0xf2,0x20,0x00,0xd8,0x90,0x5c,0x20,0x05,0xba,0x12,0x20,0x4d,
	0xa6,0x20,0x48,0xb4,0xb0,0x53,0x90,0x4e,0x20,0x4d,0xa6,0x20,0xc0,0xdd,0xb0,0x49,
	0x90,0x44,0x20,0x4d,0xa6,0x20,0x26,0xac,0xf0,0x3c,0x20,0xcd,0xde,0xb0,0x3a,0x90,
	0x35,0x20,0x4d,0xa6,0x20,0x26,0xac,0xf0,0x2d,0x20,0xd1,0xde,0xb0,0x2b,0x90,0x26,
	0x20,0x4d,0xa6,0x20,0x50,0xb6,0xb0,0x21,0x90,0x1c,0x20,0x4d,0xa6,0x20,0xd8,0xb5,
	0xb0,0x17,0x90,0x12,0x20,0x4d,0xa6,0x20,0xe1,0xb5,0xb0,0x0d,0x90,0x08,0x20,0x4d,
	0xa6,0x20,0x6e,0xb5,0xb0,0x03,0x4c,0x81,0xa6,0x20,0x05,0xba,0x03,0x20,0x47,0xa6,
	0x20,0x4c,0xa7,0xf0,0x0b,0x08,0x20,0x49,0xa7,0xd0,0x0b,0x28,0x10,0xe8,0x30,0xe9,
	0x4c,0xb3,0xa8,0x4c,0xa9,0xa8,0x28,0x10,0x16,0xa5,0xe0,0x29,0x7f,0x85,0xe0,0x20,
	0x81,0xb4,0xd0,0xef,0x20,0xb6,0xdd,0x20,0x38,0xb5,0x20,0x3e,0xb4,0x90,0xc7,0x20,
	0x81,0xb4,0xd0,0xc5,0xf0,0xc0,0xa5,0xd4,0xc9,0x40,0xd0,0x12,0xa5,0xd5,0x49,0x01,
	0x05,0xd6,0x05,0xd7,0x05,0xd8,0x05,0xd9,0xd0,0x04,0x85,0xd4,0x85,0xd5,0x60,0x60,
	0x20,0xe7,0xa6,0xa5,0xd2,0x30,0x0c,0x20,0x00,0xd8,0xb0,0x26,0x20,0x3c,0xad,0xd0,
	0x21,0xf0,0x1c,0xc6,0xf2,0xa4,0xf2,0x84,0xf5,0xa2,0xff,0xe8,0x20,0x3a,0xad,0xd0,
	0xfa,0xb0,0x04,0x24,0xa6,0x50,0xf4,0xa4,0xf5,0x8a,0xa2,0xf3,0x20,0xdb,0xa5,0x4c,
	0xd1,0xa6,0xa9,0x00,0x85,0xb4,0x20,0x05,0xba,0x08,0xa9,0x00,0x85,0xca,0x20,0x84,
	0xa5,0xc6,0xa8,0x90,0x05,0x20,0x3b,0xa6,0x85,0xb4,0xa5,0xb4,0xd0,0x05,0xa9,0x3f,
	0x20,0xab,0xb7,0x20,0xe0,0xb6,0xa5,0x11,0xf0,0x17,0xa0,0x00,0x84,0xf2,0x84,0xa6,
	0x20,0x40,0xac,0x20,0xc3,0xa4,0xb0,0x09,0x20,0x3c,0xad,0xb0,0xdd,0xe6,0xf2,0x90,
	0xef,0xa9,0x00,0x85,0xb4,0x60,0x20,0x5a,0xb8,0x20,0x2c,0xb8,0xa5,0xb7,0xa4,0xb8,
	0x20,0x70,0xa4,0x90,0x04,0xa9,0x00,0x85,0xb6,0xa5,0x8a,0xa4,0x8b,0x20,0x08,0xb8,
	0x20,0x68,0xb8,0xc8,0x84,0xa8,0xa9,0x40,0x85,0xa6,0xa0,0x00,0x84,0xf2,0x20,0x3c,
	0xad,0x85,0xb7,0x20,0x3a,0xad,0x85,0xb8,0x20,0x3a,0xad,0x85,0xf5,0x20,0x3a,0xad,
	0xaa,0x20,0x3a,0xad,0x49,0x01,0xf0,0x1b,0xe4,0xf5,0xca,0x86,0xf2,0x90,0xee,0xa5,
	0xb8,0x30,0x33,0xa5,0xf2,0x65,0xf3,0x85,0xf3,0xa9,0x00,0x85,0xb6,0x65,0xf4,0x85,
	0xf4,0x90,0xc7,0xaa,0xe4,0xb6,0xb0,0x0a,0x20,0x3a,0xad,0xd0,0xfb,0xb0,0xe0,0xe8,
	0xd0,0xf2,0xe6,0xf2,0x20,0x40,0xac,0xe6,0xb6,0x20,0xc3,0xa4,0xb0,0x07,0x20,0x3c,
	0xad,0x90,0xef,0xb0,0xca,0x60,0x20,0x05,0xba,0x06,0xe6,0xf2,0xa4,0xf2,0xb1,0xf3,
	0xc9,0x2c,0x18,0xf0,0x02,0xc9,0x9b,0x60,0xa5,0xc9,0x85,0xaf,0xa9,0x00,0x85,0x94,
	0x85,0xa6,0xa4,0xa8,0xb1,0x8a,0xc9,0x16,0xf0,0x76,0xc9,0x14,0xf0,0x72,0x85,0xa6,
	0xc9,0x12,0xf0,0x42,0xc9,0x15,0xf0,0x5b,0xc9,0x1c,0xf0,0x5b,0x20,0x27,0xa6,0xc6,
	0xa8,0xa9,0x00,0x85,0xf2,0x24,0xd2,0x30,0x14,0x20,0xe6,0xd8,0xa4,0xf2,0xb1,0xf3,
	0x48,0xe6,0xf2,0x29,0x7f,0x20,0xa9,0xb7,0x68,0x10,0xf1,0x30,0xc5,0x20,0xaa,0xa7,
	0xa2,0xd6,0x20,0x99,0xa7,0xf0,0xbb,0xa4,0xf2,0xb1,0xd4,0x20,0xa9,0xb7,0xe6,0xf2,
	0xd0,0xee,0xe6,0xd5,0xd0,0xea,0xa4,0x94,0xc8,0xc4,0xaf,0x90,0x09,0x18,0xa5,0xc9,
	0x65,0xaf,0x85,0xaf,0x90,0xf0,0xa4,0x94,0xc4,0xaf,0xb0,0x07,0xa9,0x20,0x20,0xa9,
	0xb7,0x10,0xf3,0xe6,0xa8,0xd0,0x8b,0x20,0x3b,0xa6,0x85,0xb5,0xc6,0xa8,0xd0,0x82,
	0xa5,0xa6,0xc9,0x12,0xf0,0x09,0xc9,0x15,0xf0,0x05,0xa9,0x9b,0x20,0xab,0xb7,0xa9,
	0x00,0x85,0xb5,0x60,0xa9,0xb9,0xa0,0xbf,0x20,0x08,0xb8,0xa2,0x07,0x86,0xb5,0xa0,
	0x08,0x20,0x0c,0xb7,0x20,0xc4,0xb7,0x20,0x48,0xad,0x4c,0xf0,0xb6,0xa9,0x04,0x20,
	0x3d,0xb2,0xa9,0x07,0x85,0xb4,0xe6,0x92,0x4c,0x2b,0xa0,0xa0,0x00,0x84,0xa0,0x84,
	0xa1,0xa9,0x9b,0x8d,0xfe,0x02,0x20,0xab,0xb7,0x20,0x5a,0xb8,0xa6,0xa8,0x8a,0xe8,
	0xe4,0xa7,0xb0,0x24,0x48,0x20,0x27,0xa6,0x68,0x85,0xa8,0xa5,0xd2,0x10,0x0b,0xa9,
	0x08,0x20,0x3d,0xb2,0xa9,0x07,0x85,0xb5,0x10,0xe2,0x20,0x0a,0xa6,0x84,0xa1,0x85,
	0xa0,0xa6,0xa8,0xe4,0xa7,0xf0,0x0c,0xe8,0xa0,0x7f,0xa9,0xff,0xe4,0xa7,0xb0,0x03,
	0x20,0x0a,0xa6,0x84,0xad,0x85,0xac,0x20,0x2c,0xb8,0x20,0x74,0xa4,0x20,0xc9,0xa4,
	0x30,0x1a,0xa0,0x00,0xa5,0xac,0xd1,0x8a,0xa5,0xad,0xc8,0xf1,0x8a,0x90,0x0d,0x20,
	0x89,0xae,0x20,0xb4,0xa4,0x20,0xb9,0xa4,0xa5,0x11,0xd0,0xe1,0x20,0xf0,0xb6,0xa9,
	0x00,0x85,0xb5,0x8d,0xfe,0x02,0x4c,0x68,0xb8,0x20,0x58,0xb7,0x20,0xb4,0xa4,0x85,
	0x9f,0xc8,0xb1,0x8a,0x85,0xa7,0xc8,0x84,0xa8,0x20,0xa3,0xae,0xa4,0xa7,0xc4,0x9f,
	0x90,0xf0,0x60,0x20,0x3a,0xaf,0xc9,0x36,0xf0,0x16,0x20,0x59,0xa1,0x20,0x3a,0xaf,
	0xc9,0x37,0xf0,0x04,0xc9,0x02,0xb0,0x08,0x20,0x38,0xaf,0x20,0xab,0xb7,0x10,0xf8,
	0x20,0x38,0xaf,0x10,0x19,0x29,0x7f,0x85,0xaf,0xa2,0x00,0xa5,0x83,0xa4,0x82,0x20,
	0xd2,0xa1,0x20,0x7d,0xb7,0xc9,0xa8,0xd0,0xe7,0x20,0x38,0xaf,0x90,0xe2,0xc9,0x0f,
	0xf0,0x13,0xb0,0x30,0x20,0xd0,0xa5,0x84,0xa8,0x20,0xe6,0xd8,0x20,0x0d,0xb8,0x20,
	0x7d,0xb7,0x18,0x90,0xcb,0x20,0x38,0xaf,0x85,0xaf,0xa9,0x22,0x20,0xab,0xb7,0xa5,
	0xaf,0xf0,0x0a,0x20,0x38,0xaf,0x20,0xab,0xb7,0xc6,0xaf,0xd0,0xf6,0xa9,0x22,0x20,
	0xab,0xb7,0x10,0xac,0xe9,0x12,0x85,0xaf,0xa2,0x00,0xa9,0xbb,0xa0,0xc2,0x20,0xd2,
	0xa1,0x20,0x3a,0xaf,0xc9,0x3d,0xb0,0xc7,0xa0,0x00,0xb1,0x95,0x29,0x7f,0x20,0x27,
	0xa3,0xb0,0xbc,0x20,0x6f,0xb7,0x10,0x88,0xe6,0xa8,0xa4,0xa8,0xc4,0xa7,0xb0,0x03,
	0xb1,0x8a,0x60,0x68,0x68,0x60,0x20,0x5a,0xb8,0x20,0x3d,0xa6,0xa5,0xd4,0xf0,0x1c,
	0x85,0xb2,0xa4,0xa8,0x88,0xb1,0x8a,0xc9,0x17,0x08,0x20,0x0a,0xa6,0xc6,0xb2,0xd0,
	0x05,0x28,0xf0,0x35,0xd0,0x1f,0x20,0xc3,0xa4,0x90,0xef,0x28,0x60,0x20,0x27,0xa6,
	0xa5,0xd4,0xf0,0x06,0x20,0xc3,0xa4,0x90,0x1d,0x60,0xa5,0x9f,0x85,0xa7,0x60,0x20,
	0x5a,0xb8,0x20,0x0a,0xa6,0x20,0x2c,0xb8,0xa5,0xd4,0xa4,0xd5,0x20,0x70,0xa4,0x90,
	0x0d,0x20,0x68,0xb8,0xf0,0x0e,0x20,0x0a,0xa6,0x20,0x70,0xa4,0xb0,0x06,0xa2,0xff,
	0x9a,0x4c,0xdd,0xa4,0x20,0xc0,0xb8,0x20,0x05,0xba,0x0c,0x20,0x5a,0xb8,0x20,0xea,
	0xa6,0xa5,0xd3,0x09,0x80,0x85,0xc7,0x20,0x5f,0xb8,0x20,0xc9,0xb8,0xb0,0x08,0xf0,
	0x06,0xc5,0xc7,0xd0,0xf5,0xf0,0x08,0xa5,0xc4,0x85,0x90,0xa5,0xc5,0x85,0x91,0xa9,
	0x0c,0x20,0x05,0xb9,0x20,0x27,0xa6,0xa0,0x00,0x20,0x16,0xb8,0x20,0x38,0xb5,0x20,
	0xc3,0xa4,0xb0,0x03,0x20,0x27,0xa6,0xa0,0x06,0x20,0x16,0xb8,0xa5,0xc7,0x4c,0x2e,
	0xb8,0xa4,0xa8,0xb1,0x8a,0x85,0xc7,0x20,0xc9,0xb8,0xb0,0x37,0xf0,0x35,0xc5,0xc7,
	0xd0,0xf5,0xa0,0x06,0x20,0x21,0xb8,0xa5,0xe0,0x29,0x80,0x85,0xc6,0xa5,0xc7,0x20,
	0xae,0xa5,0x20,0x2c,0xb4,0x20,0x1c,0xa8,0xa0,0x00,0x20,0x21,0xb8,0x20,0x46,0xa7,
	0xf0,0x04,0x45,0xc6,0x10,0x0c,0xa9,0x13,0x20,0x05,0xb9,0x20,0x87,0xb8,0xc9,0x08,
	0xd0,0x01,0x60,0x20,0x05,0xba,0x0d,0x20,0x2d,0xa6,0x85,0xbc,0x84,0xbd,0x60,0x20,
	0xca,0xb6,0x4c,0x71,0xe4,0x20,0xca,0xb6,0x6c,0x0a,0x00,0x20,0xce,0xa4,0x20,0xa3,
	0xb7,0xa9,0xbf,0xa0,0xa6,0x20,0x79,0xb7,0x4c,0x41,0xba,0x20,0x30,0xa5,0xa9,0x80,
	0x85,0xbb,0x4c,0x1b,0xa0,0x20,0x05,0xba,0x11,0x20,0xc9,0xa4,0x10,0x20,0xa4,0xbb,
	0x30,0xf0,0xa5,0xba,0x20,0x70,0xa4,0xb0,0x0b,0x20,0xc9,0xa4,0x30,0xe4,0x20,0xb4,
	0xa4,0x20,0xb9,0xa4,0x20,0xc9,0xa4,0x30,0xd9,0xe6,0x92,0x4c,0x26,0xa5,0x4c,0x01,
	0xb8,0xa4,0xa8,0xc4,0xa7,0xb0,0x5d,0x20,0xea,0xa6,0xa5,0xd2,0x6a,0xb0,0x56,0x38,
	0x2a,0x85,0xd2,0x30,0x22,0xa4,0xf5,0xa6,0xf6,0x20,0xf9,0xb0,0x84,0xf5,0x86,0xf6,
	0x84,0xd6,0x86,0xd7,0xa4,0x97,0xa6,0x98,0x20,0xf9,0xb0,0x84,0xd8,0x86,0xd9,0x20,
	0xc6,0xa7,0x20,0xfb,0xa7,0x90,0x12,0xa9,0x00,0x85,0xd6,0x85,0xd7,0xa5,0xf5,0x85,
	0xd8,0xa5,0xf6,0x85,0xd9,0x05,0xf5,0xf0,0x1c,0xa4,0xf5,0xa5,0xf6,0xa2,0x8e,0x20,
	0x0d,0xb9,0x38,0xa5,0x97,0xe5,0x8c,0x85,0xd4,0xa5,0x98,0xe5,0x8d,0x85,0xd5,0x20,
	0x1c,0xa8,0x30,0x9d,0x60,0x20,0x05,0xba,0x09,0xc8,0xd0,0x03,0xe8,0xf0,0xf6,0x60,
	0x20,0xc3,0xa4,0xb0,0x03,0x20,0x33,0xb3,0x20,0xca,0xb6,0xa9,0x00,0x85,0xa0,0x85,
	0xa1,0x20,0x23,0xa5,0x20,0xc9,0xa4,0x10,0x03,0x4c,0x1b,0xa0,0x20,0x70,0xa5,0xa5,
	0x86,0x85,0xf5,0xa5,0x87,0x85,0xf6,0xa5,0xf5,0xc5,0x88,0xa5,0xf6,0xe5,0x89,0xb0,
	0x1f,0xa0,0x00,0xb1,0xf5,0x29,0xfe,0x91,0xf5,0xc8,0xc8,0xa9,0x00,0x91,0xf5,0xc8,
	0xc0,0x08,0x90,0xf9,0x98,0x18,0x65,0xf5,0x85,0xf5,0x90,0xdb,0xe6,0xf6,0xb0,0xd7,
	0xa9,0x00,0x85,0x92,0xa5,0x8c,0x85,0x8e,0x85,0x90,0x85,0x0e,0xa5,0x8d,0x85,0x8f,
	0x85,0x91,0x85,0x0f,0x60,0x20,0x2d,0xa6,0x85,0x95,0x84,0x96,0x20,0x3d,0xa6,0xa5,
	0xd4,0xa0,0x00,0x91,0x95,0x60,0xa9,0x06,0x2c,0xa9,0x00,0x85,0xfb,0x60,0xa9,0x00,
	0xa8,0x85,0xb6,0x20,0xc3,0xa4,0xb0,0x03,0x20,0x2d,0xa6,0x85,0xb7,0x84,0xb8,0x60,
	0x20,0x3d,0xa6,0x85,0xc8,0x60,0x20,0x3d,0xa6,0xc9,0x05,0xb0,0x18,0x48,0x20,0x2d,
	0xa6,0x0a,0x0a,0x0a,0x0a,0x48,0x20,0x2d,0xa6,0x68,0x18,0x65,0xd4,0xa8,0x68,0xaa,
	0x98,0x9d,0xc4,0x02,0x60,0x20,0x05,0xba,0x03,0x20,0x3d,0xa6,0xc9,0x04,0xb0,0xf5,
	0x0a,0x85,0xb3,0xad,0x32,0x02,0x29,0x07,0x8d,0x32,0x02,0x8d,0x0f,0xd2,0xa9,0x00,
	0x8d,0x08,0xd2,0x20,0x2d,0xa6,0xa6,0xb3,0x9d,0x00,0xd2,0x20,0x3d,0xa6,0x0a,0x0a,
	0x0a,0x0a,0x48,0x20,0x2d,0xa6,0x68,0xa6,0xb3,0x18,0x65,0xd4,0x9d,0x01,0xd2,0x60,
	0x20,0x3d,0xa6,0xa9,0x06,0x85,0xc1,0x20,0xf0,0xb6,0xa9,0xb6,0xa0,0xbf,0x20,0x08,
	0xb8,0xa2,0x06,0xa5,0xd4,0x29,0xf0,0x49,0x1c,0xa8,0xa5,0xd4,0x20,0x10,0xb7,0x4c,
	0xc4,0xb7,0x20,0x3d,0xa6,0x2c,0xa9,0x03,0x85,0xc0,0x20,0xf7,0xa5,0x20,0x3d,0xa6,
	0x48,0x20,0x3d,0xa6,0xa8,0x68,0x48,0x98,0x48,0x20,0x2a,0xa8,0x20,0x4a,0xb7,0x68,
	0x9d,0x4b,0x03,0x68,0x9d,0x4a,0x03,0x20,0x1e,0xb7,0x4c,0xc4,0xb7,0x48,0x20,0x2a,
	0xa8,0x68,0xa8,0x20,0x0c,0xb7,0x4c,0xc4,0xb7,0xa9,0x0c,0x85,0xc0,0x20,0xf7,0xa5,
	0x20,0x37,0xb7,0x4c,0xc4,0xb7,0x20,0xf7,0xa5,0x20,0xe7,0xa6,0xa9,0x0d,0x20,0x39,
	0xb7,0x20,0x3f,0xb7,0x4c,0xc8,0xa6,0xa9,0x26,0x20,0x4b,0xb2,0x20,0xe7,0xa6,0x20,
	0x4a,0xb7,0xbd,0x4c,0x03,0xbc,0x4d,0x03,0x20,0xca,0xa6,0x20,0xe7,0xa6,0x20,0x4a,
	0xb7,0xbd,0x4e,0x03,0x4c,0xc8,0xa6,0x20,0xf7,0xa5,0x20,0x2d,0xa6,0x20,0x4a,0xb7,
	0xa5,0xd4,0x9d,0x4c,0x03,0xa5,0xd5,0x9d,0x4d,0x03,0x20,0x3d,0xa6,0x20,0x4a,0xb7,
	0xa5,0xd4,0x9d,0x4e,0x03,0xa9,0x25,0x20,0x39,0xb7,0x4c,0xc4,0xb7,0x20,0xf7,0xa5,
	0x20,0x3d,0xa6,0xa6,0xc1,0x4c,0xad,0xb7,0x20,0xf7,0xa5,0xa9,0x07,0x85,0xc0,0x20,
	0x51,0xda,0xa0,0x01,0x20,0x23,0xb7,0x20,0xc4,0xb7,0x20,0xe7,0xa6,0xa0,0x00,0xb1,
	0xf3,0x4c,0xca,0xa6,0x20,0x2d,0xa6,0x85,0x55,0x84,0x56,0x20,0x3d,0xa6,0x85,0x54,
	0x60,0x20,0xd4,0xb2,0xa5,0xc8,0xa2,0x06,0x4c,0xad,0xb7,0x20,0xd4,0xb2,0xa5,0xc8,
	0x8d,0xfb,0x02,0xa9,0x11,0xa2,0x06,0x20,0x46,0xb7,0x20,0x37,0xb7,0x4c,0xc4,0xb7,
	0x20,0xd4,0xb2,0xa2,0x06,0x20,0x48,0xb7,0xd0,0xb1,0xa0,0x04,0x20,0xfa,0xb6,0x20,
	0x38,0xb3,0x4c,0x1b,0xa0,0xa9,0xc5,0xa0,0xbf,0x20,0x08,0xb8,0xa0,0x04,0x20,0x0c,
	0xb7,0x30,0x09,0x20,0x38,0xb3,0x20,0x08,0xb1,0x4c,0xdd,0xa4,0x60,0x20,0x33,0xb3,
	0x4c,0x1b,0xa0,0xa9,0x04,0x20,0x3d,0xb2,0xa9,0x07,0x85,0xc0,0x20,0x51,0xda,0x20,
	0x4a,0xb7,0xa0,0x0e,0x20,0x23,0xb7,0x20,0xc4,0xb7,0xad,0x80,0x05,0x0d,0x81,0x05,
	0xd0,0x34,0xa2,0x0c,0x86,0xca,0x18,0xbd,0x80,0x05,0x65,0x80,0xa8,0xbd,0x81,0x05,
	0x65,0x81,0x48,0xcc,0xe5,0x02,0xed,0xe6,0x02,0xb0,0x14,0x68,0x95,0x81,0x94,0x80,
	0xca,0xca,0xd0,0xe2,0x20,0xc0,0xb3,0x20,0x1f,0xb1,0xa9,0x00,0x85,0xca,0x60,0x20,
	0xf0,0xb6,0x20,0x05,0xba,0x13,0x20,0xf0,0xb6,0x20,0x05,0xba,0x15,0xa0,0x08,0x20,
	0xfa,0xb6,0x10,0x05,0xa9,0x08,0x20,0x3d,0xb2,0xa9,0x0b,0x85,0xc0,0x20,0x51,0xda,
	0xa2,0x0c,0x38,0xb5,0x80,0xe5,0x80,0x9d,0x80,0x05,0xb5,0x81,0xe5,0x81,0x9d,0x81,
	0x05,0xca,0xca,0x10,0xed,0x20,0x4a,0xb7,0xa0,0x0e,0x20,0x23,0xb7,0x20,0xc4,0xb7,
	0xa5,0x11,0xf0,0x18,0x20,0x4a,0xb7,0xa5,0x82,0xa4,0x83,0x20,0x08,0xb8,0xac,0x8d,
	0x05,0x88,0x98,0xac,0x8c,0x05,0x20,0x25,0xb7,0x20,0xc4,0xb7,0x4c,0xf0,0xb6,0xa9,
	0xbf,0xa0,0xbf,0x20,0x08,0xb8,0x20,0xc3,0xa4,0xb0,0x03,0x20,0x2a,0xa8,0xa0,0x06,
	0x20,0x0c,0xb7,0x20,0xc4,0xb7,0x20,0x51,0xda,0xa9,0x05,0xa2,0x07,0x20,0x46,0xb7,
	0x20,0x1e,0xb7,0xc0,0x88,0xf0,0x1c,0x20,0xc4,0xb7,0xa5,0x11,0xf0,0x15,0xa0,0x00,
	0x84,0xf2,0xa4,0xf2,0xb1,0xf3,0x48,0x20,0xab,0xb7,0xe6,0xf2,0x68,0xc9,0x9b,0xd0,
	0xf1,0xf0,0xd6,0x4c,0xf0,0xb6,0x20,0xd2,0xd9,0xb0,0x19,0x60,0x20,0x66,0xda,0xb0,
	0x13,0x60,0x20,0x60,0xda,0xb0,0x0d,0x60,0x20,0xdb,0xda,0xb0,0x07,0x60,0x20,0x28,
	0xdb,0xb0,0x01,0x60,0x20,0x05,0xba,0x0b,0xa5,0xd4,0xa0,0x00,0x29,0x7f,0x38,0xe9,
	0x3f,0xb0,0x01,0x98,0xaa,0x98,0xe0,0x05,0xb0,0x07,0x15,0xd5,0x94,0xd5,0xe8,0xd0,
	0xf5,0xa6,0xd4,0x10,0x0c,0xaa,0xf0,0x09,0x20,0xb6,0xdd,0x20,0x35,0xb5,0x4c,0x66,
	0xda,0x4c,0x00,0xdc,0xa5,0xd4,0x49,0x80,0x85,0xd4,0x60,0x20,0xb6,0xdd,0x4c,0xdb,
	0xda,0xa9,0x00,0x85,0x9b,0x20,0x85,0xa6,0x20,0x47,0xb5,0x20,0x48,0xb4,0x90,0x02,
	0xe6,0x9b,0x20,0x85,0xa6,0x20,0xd2,0xd9,0x90,0x02,0xe6,0x9b,0xa5,0xd4,0x85,0x99,
	0xa5,0xd5,0x85,0x9a,0x20,0x4d,0xa6,0x20,0x32,0xb4,0x20,0x74,0xb4,0x20,0xb6,0xdd,
	0x20,0x4d,0xa6,0xa2,0xf2,0xa0,0x05,0x20,0xa7,0xdd,0x20,0xe2,0xb4,0x90,0x02,0xe6,
	0x9b,0x20,0x85,0xa6,0xa2,0xf2,0xa0,0x05,0x20,0x89,0xdd,0x20,0x04,0xb5,0x90,0x02,
	0xe6,0x9b,0x20,0xb6,0xdd,0x20,0x4d,0xa6,0x20,0xdb,0xda,0x90,0x02,0xe6,0x9b,0xa5,
	0x9b,0x60,0x20,0x4c,0xa7,0xf0,0x18,0x20,0x5c,0xb5,0x20,0xd1,0xde,0xb0,0x0c,0x20,
	0x67,0xb5,0x20,0xdb,0xda,0xb0,0x03,0x20,0xcc,0xdd,0x60,0x20,0x05,0xba,0x03,0x20,
	0x38,0xb5,0x18,0x60,0xa5,0x9a,0xd0,0x07,0xa4,0x99,0xf0,0xf3,0x88,0xf0,0xf3,0x46,
	0x9a,0x66,0x99,0x08,0x20,0x85,0xa6,0x20,0x04,0xb5,0xb0,0x14,0x20,0x7b,0xb4,0xb0,
	0x0f,0x28,0x90,0x09,0x20,0xb6,0xdd,0x20,0x4d,0xa6,0x4c,0xdb,0xda,0xc6,0xaa,0x60,
	0xc6,0xaa,0x28,0x38,0x60,0xa9,0xc0,0x2c,0xa9,0x40,0xa0,0x01,0x85,0xd4,0x84,0xd5,
	0xa0,0x04,0xa2,0xd6,0x4c,0x48,0xda,0xa2,0xe0,0xa0,0x00,0x4c,0x89,0xdd,0xa2,0xe6,
	0xa0,0x05,0x4c,0xa7,0xdd,0xa2,0xe6,0xa0,0x05,0x4c,0x98,0xdd,0xa2,0x05,0xb5,0xe0,
	0x9d,0xec,0x05,0xca,0x10,0xf8,0x60,0xa2,0xec,0xa0,0x05,0x4c,0x98,0xdd,0xa9,0x00,
	0x85,0xf0,0xa5,0xd4,0x29,0x7f,0xc9,0x40,0x90,0x14,0xaa,0xa5,0xd4,0x29,0x80,0x09,
	0x40,0x85,0xf0,0x86,0xd4,0xa2,0xea,0xa0,0xdf,0x20,0x95,0xde,0xb0,0x49,0x20,0x4e,
	0xb5,0x20,0x7b,0xb4,0xa9,0x0b,0xa2,0xae,0xa0,0xdf,0x20,0x40,0xdd,0x20,0x55,0xb5,
	0x20,0xdb,0xda,0x24,0xf0,0x50,0x12,0xa2,0xf0,0xa0,0xdf,0x20,0x98,0xdd,0x20,0x66,
	0xda,0xa5,0xf0,0x29,0x80,0x05,0xd4,0x85,0xd4,0xa5,0xfb,0xf0,0x1a,0xa2,0x70,0xa0,
	0xbf,0x20,0x98,0xdd,0x20,0xdb,0xda,0xa5,0xd4,0x29,0x7f,0x49,0x40,0xd0,0x08,0xa5,
	0xd5,0x49,0x90,0xd0,0x02,0x85,0xd9,0x60,0xa9,0x04,0x24,0xd4,0x10,0x02,0xa9,0x02,
	0x2c,0xa9,0x01,0x85,0xf0,0xa5,0xd4,0x29,0x7f,0x85,0xd4,0xa9,0x94,0x18,0x65,0xfb,
	0xaa,0xa0,0xbf,0x20,0x98,0xdd,0x20,0x28,0xdb,0xb0,0x54,0xa5,0xd4,0x29,0x7f,0x38,
	0xe9,0x40,0x90,0x21,0xc9,0x04,0xb0,0x47,0xaa,0xb5,0xd5,0x85,0xf1,0x29,0x10,0xf0,
	0x02,0xa9,0x02,0x65,0xf1,0x29,0x03,0x65,0xf0,0x85,0xf0,0xa9,0x00,0x95,0xd5,0xca,
	0x10,0xfb,0x20,0x00,0xdc,0x46,0xf0,0x90,0x09,0x20,0xb6,0xdd,0x20,0x38,0xb5,0x20,
	0x60,0xda,0x20,0x4e,0xb5,0x20,0x7b,0xb4,0xa9,0x06,0xa2,0x76,0xa0,0xbf,0x20,0x40,
	0xdd,0x20,0x55,0xb5,0x20,0xdb,0xda,0x46,0xf0,0x90,0x04,0x20,0x74,0xb4,0x18,0x60,
	0x20,0x49,0xa7,0xf0,0x65,0x38,0x30,0x65,0xa5,0xd4,0xe9,0x40,0x85,0xed,0xa0,0x00,
	0xa2,0x04,0xb5,0xd5,0x95,0xe5,0x94,0xe0,0x94,0xd5,0xca,0x10,0xf5,0x84,0xea,0x84,
	0xeb,0xa2,0x09,0x46,0xed,0x90,0x01,0xe8,0x86,0xf1,0xf8,0x20,0x5c,0xb5,0x18,0x20,
	0xbe,0xb6,0x90,0x12,0x20,0xbe,0xb6,0x90,0x0d,0xa2,0x05,0xb5,0xd4,0x69,0x00,0x95,
	0xd4,0xca,0xd0,0xf7,0xf0,0xe5,0xc6,0xf1,0xf0,0x17,0x20,0x67,0xb5,0xa2,0x00,0xb5,
	0xe1,0x95,0xe0,0xe8,0xe0,0x0b,0x90,0xf7,0x20,0xeb,0xdb,0xa9,0x00,0x85,0xeb,0xf0,
	0xca,0xd8,0xa5,0xed,0x69,0x40,0x29,0x7f,0x85,0xd4,0x20,0x00,0xdc,0x60,0xa2,0x05,
	0xb5,0xe0,0xf5,0xd4,0x95,0xe0,0xca,0xd0,0xf7,0x60,0xa9,0x00,0xa2,0x07,0x9d,0x00,
	0xd2,0xca,0x10,0xfa,0xa0,0x07,0x84,0xc1,0x20,0xf0,0xb6,0xc6,0xc1,0xd0,0xf9,0x60,
	0x20,0x51,0xda,0xa6,0xb4,0xa9,0x05,0x20,0x46,0xb7,0x20,0x1e,0xb7,0x4c,0xc4,0xb7,
	0x20,0x4a,0xb7,0xf0,0x04,0xa9,0x0c,0xd0,0x40,0x60,0xa2,0xbc,0x86,0xf3,0xa2,0xbf,
	0x86,0xf4,0xa9,0x80,0xa2,0x07,0x20,0x10,0xb7,0x4c,0xc4,0xb7,0xa2,0x07,0xa9,0x00,
	0x48,0xa9,0x03,0x20,0x46,0xb7,0x68,0x9d,0x4b,0x03,0x98,0x9d,0x4a,0x03,0xa0,0xff,
	0x2c,0xa0,0x00,0xa9,0x00,0x9d,0x49,0x03,0x98,0x9d,0x48,0x03,0xa5,0xf4,0xa4,0xf3,
	0x9d,0x45,0x03,0x98,0x9d,0x44,0x03,0xa5,0xc0,0x9d,0x42,0x03,0x4c,0x56,0xe4,0x20,
	0x4a,0xb7,0xbd,0x43,0x03,0x60,0x85,0xc0,0x86,0xc1,0xa5,0xc1,0x0a,0x0a,0x0a,0x0a,
	0xaa,0x30,0x01,0x60,0x20,0x05,0xba,0x14,0xa0,0x01,0xb1,0x8a,0xaa,0x88,0xb1,0x8a,
	0x85,0xd4,0x86,0xd5,0x20,0xaa,0xd9,0x20,0xe6,0xd8,0x20,0x0d,0xb8,0xd0,0x03,0x20,
	0x75,0xb7,0x20,0x7d,0xb7,0xa9,0x20,0xd0,0x32,0x85,0x96,0x84,0x95,0xa0,0xff,0x84,
	0xaf,0xe6,0xaf,0xa4,0xaf,0xb1,0x95,0x48,0xc9,0x9b,0xf0,0x04,0x29,0x7f,0xf0,0x03,
	0x20,0xab,0xb7,0x68,0x10,0xeb,0x60,0xbd,0x47,0x03,0x48,0xbd,0x46,0x03,0x48,0x98,
	0xa0,0x92,0x60,0xa9,0x9b,0xa2,0x00,0xf0,0x04,0xe6,0x94,0xa6,0xb5,0x48,0x20,0x48,
	0xb7,0xbd,0x4a,0x03,0x85,0x2a,0xbd,0x4b,0x03,0x85,0x2b,0x68,0xa8,0x20,0x97,0xb7,
	0x98,0x30,0x07,0x60,0x20,0x3f,0xb7,0x30,0x01,0x60,0xa4,0xc1,0xc9,0x88,0xd0,0x03,
	0xba,0xe0,0xfd,0x08,0x85,0xc3,0xc0,0x07,0xd0,0x03,0x20,0xf0,0xb6,0x20,0x01,0xb8,
	0x28,0xf0,0x10,0xa5,0xc3,0xc9,0x80,0xd0,0x07,0xa5,0xca,0xd0,0x03,0x85,0x11,0x60,
	0x4c,0x11,0xba,0x4c,0x21,0xa0,0xa0,0x00,0xa5,0x11,0xd0,0x03,0x88,0x84,0x11,0x98,
	0x60,0xa9,0x00,0x85,0xb4,0x85,0xb5,0x60,0x85,0xf3,0x84,0xf4,0x60,0xa5,0xf3,0x85,
	0x95,0xa5,0xf4,0x85,0x96,0x60,0xa2,0xfa,0xb5,0xda,0x91,0xc4,0xc8,0xe8,0xd0,0xf8,
	0x60,0xa2,0xfa,0xb1,0x90,0x95,0xe6,0xc8,0xe8,0xd0,0xf8,0x60,0xa9,0x00,0x48,0xa9,
	0x07,0x20,0x05,0xb9,0x68,0xa0,0x00,0x91,0xc4,0xb1,0x8a,0xc8,0x91,0xc4,0xb1,0x8a,
	0xc8,0x91,0xc4,0xa6,0xb3,0xc8,0xca,0x8a,0x91,0xc4,0xc8,0xa5,0x92,0x91,0xc4,0xc8,
	0xa5,0x8a,0x91,0xc4,0xc8,0xa5,0x8b,0x91,0xc4,0x60,0xa4,0xa8,0x84,0xb3,0x60,0xa6,
	0x90,0x86,0xc4,0xa6,0x91,0x86,0xc5,0x60,0x20,0xc9,0xb8,0xb0,0x16,0xd0,0xf9,0x20,
	0x87,0xb8,0xc9,0x0c,0xf0,0x0c,0xc9,0x1e,0xf0,0x08,0xc9,0x04,0xf0,0x04,0xc9,0x22,
	0xd0,0x37,0x60,0x20,0x05,0xba,0x10,0xa5,0x92,0xc5,0x93,0xd0,0x1c,0xa0,0x00,0xb1,
	0x95,0xc5,0xa0,0xd0,0x14,0xc8,0xb1,0x95,0xc5,0xa1,0xd0,0x0d,0xa5,0x95,0x85,0x8a,
	0xa5,0x96,0x85,0x8b,0x20,0x26,0xa5,0xd0,0x05,0x20,0x23,0xa5,0xb0,0x0b,0xa4,0xb2,
	0x88,0xb1,0x8a,0x85,0xa7,0xc8,0xb1,0x8a,0x60,0x20,0xc0,0xb8,0x20,0x05,0xba,0x0f,
	0xa5,0xbe,0x85,0x8a,0xa5,0xbf,0x85,0x8b,0x60,0xa5,0x8e,0xc5,0x90,0xa5,0x8f,0xe5,
	0x91,0xb0,0x31,0xa9,0x07,0x20,0x8a,0xb9,0xa0,0x06,0xb1,0x90,0x85,0x96,0x88,0xb1,
	0x90,0x85,0x95,0x88,0xb1,0x90,0x85,0x93,0x88,0xb1,0x90,0x85,0xb2,0x88,0xb1,0x90,
	0x85,0xa1,0x88,0xb1,0x90,0x85,0xa0,0x88,0xb1,0x90,0xf0,0x07,0x48,0xa9,0x0c,0x20,
	0x8a,0xb9,0x68,0x18,0x60,0x20,0x5f,0xb8,0xa8,0xa2,0x90,0xa9,0x00,0x84,0xa4,0x85,
	0xa5,0x18,0xa5,0x90,0x65,0xa4,0xa8,0xa5,0x91,0x65,0xa5,0xcc,0xe5,0x02,0xed,0xe6,
	0x02,0x90,0x04,0x20,0x05,0xba,0x02,0xe0,0x8c,0xb0,0x02,0xe6,0xca,0x38,0xa5,0x90,
	0xf5,0x00,0x85,0xa2,0xa5,0x91,0xf5,0x01,0x85,0xa3,0x18,0x75,0x01,0x85,0x9a,0xb5,
	0x00,0x85,0x97,0x85,0x99,0x65,0xa4,0x85,0x9b,0xb5,0x01,0x85,0x98,0x65,0xa5,0x65,
	0xa3,0x85,0x9c,0xb5,0x00,0x65,0xa4,0x95,0x00,0xb5,0x01,0x65,0xa5,0x95,0x01,0xe8,
	0xe8,0xe0,0x92,0x90,0xee,0x85,0x0f,0xa5,0x90,0x85,0x0e,0xa6,0xa3,0xe8,0xa4,0xa2,
	0xd0,0x0b,0xf0,0x10,0xc6,0x9a,0xc6,0x9c,0x88,0xb1,0x99,0x91,0x9b,0x88,0xd0,0xf9,
	0xb1,0x99,0x91,0x9b,0xca,0xd0,0xed,0x86,0xca,0x60,0xa8,0xa2,0x90,0xa9,0x00,0x84,
	0xa4,0x85,0xa5,0xe0,0x8c,0xb0,0x02,0x86,0xca,0x38,0xa5,0x90,0xf5,0x00,0x49,0xff,
	0xa8,0xc8,0x84,0xa2,0xa5,0x91,0xf5,0x01,0x85,0xa3,0xb5,0x00,0x85,0x99,0xb5,0x01,
	0x85,0x9a,0x8a,0x48,0x38,0xb5,0x00,0xe5,0xa4,0x95,0x00,0xb5,0x01,0xe5,0xa5,0x95,
	0x01,0xe8,0xe8,0xe0,0x92,0x90,0xed,0x85,0x0f,0xa5,0x90,0x85,0x0e,0x68,0xaa,0x38,
	0xa5,0x99,0xe5,0xa2,0x85,0x99,0xa5,0x9a,0xe9,0x00,0x85,0x9a,0xb5,0x00,0xe5,0xa2,
	0x85,0x9b,0xb5,0x01,0xe9,0x00,0x85,0x9c,0xa6,0xa3,0xe8,0xa4,0xa2,0xd0,0x09,0xca,
	0xd0,0x06,0xf0,0x0e,0xe6,0x9a,0xe6,0x9c,0xb1,0x99,0x91,0x9b,0xc8,0xd0,0xf9,0xca,
	0xd0,0xf2,0x86,0xca,0x60,0x68,0x85,0x95,0x68,0x85,0x96,0xa0,0x01,0xb1,0x95,0x85,
	0xc3,0xa4,0xca,0xd0,0x1b,0xa5,0xb4,0x48,0x20,0xce,0xa4,0x68,0xd0,0x05,0x20,0xc9,
	0xa4,0x30,0x0d,0xa4,0xbd,0x30,0x09,0xa2,0x80,0x86,0xbd,0xa5,0xbc,0x4c,0x99,0xaf,
	0x84,0x11,0x20,0xa3,0xb7,0xa9,0x37,0x20,0x59,0xa1,0xa2,0x00,0xa5,0xc3,0x20,0x60,
	0xb7,0xa5,0xca,0xd0,0x17,0x20,0xc9,0xa4,0x30,0x0c,0xa9,0xbf,0xa0,0xae,0x20,0x79,
	0xb7,0x20,0x58,0xb7,0xe6,0x92,0x20,0xa3,0xb7,0x4c,0x2b,0xa0,0x4c,0x00,0xa0,0x15,
	0xbe,0x52,0x45,0xcd,0x15,0xbe,0x44,0x41,0x54,0xc1,0x43,0xbd,0x49,0x4e,0x50,0x55,
	0xd4,0x0b,0xbd,0x43,0x4f,0x4c,0x4f,0xd2,0x81,0xbd,0x4c,0x49,0x53,0xd4,0x72,0xbd,
	0x45,0x4e,0x54,0x45,0xd2,0x0e,0xbd,0x4c,0x45,0xd4,0xdf,0xbd,0x49,0xc6,0x20,0xbd,
	0x46,0x4f,0xd2,0x39,0xbd,0x4e,0x45,0x58,0xd4,0x0b,0xbd,0x47,0x4f,0x54,0xcf,0x0b,
	0xbd,0x47,0x4f,0x20,0x54,0xcf,0x0b,0xbd,0x47,0x4f,0x53,0x55,0xc2,0x0b,0xbd,0x54,
	0x52,0x41,0xd0,0x0c,0xbd,0x42,0x59,0xc5,0x0c,0xbd,0x43,0x4f,0x4e,0xd4,0xac,0xbd,
	0x43,0x4f,0xcd,0x6f,0xbd,0x43,0x4c,0x4f,0x53,0xc5,0x0c,0xbd,0x43,0x4c,0xd2,0x0c,
	0xbd,0x44,0x45,0xc7,0xac,0xbd,0x44,0x49,0xcd,0x0c,0xbd,0x45,0x4e,0xc4,0x0c,0xbd,
	0x4e,0x45,0xd7,0x68,0xbd,0x4f,0x50,0x45,0xce,0x72,0xbd,0x4c,0x4f,0x41,0xc4,0x72,
	0xbd,0x53,0x41,0x56,0xc5,0x8f,0xbd,0x53,0x54,0x41,0x54,0x55,0xd3,0x98,0xbd,0x4e,
	0x4f,0x54,0xc5,0x2d,0xbe,0x50,0x4f,0x49,0x4e,0xd4,0x66,0xbd,0x58,0x49,0xcf,0xaf,
	0xbd,0x4f,0xce,0xa9,0xbd,0x50,0x4f,0x4b,0xc5,0x4b,0xbd,0x50,0x52,0x49,0x4e,0xd4,
	0x0c,0xbd,0x52,0x41,0xc4,0x44,0xbd,0x52,0x45,0x41,0xc4,0x3e,0xbd,0x52,0x45,0x53,
	0x54,0x4f,0x52,0xc5,0x0c,0xbd,0x52,0x45,0x54,0x55,0x52,0xce,0x75,0xbd,0x52,0x55,
	0xce,0x0c,0xbd,0x53,0x54,0x4f,0xd0,0x0c,0xbd,0x50,0x4f,0xd0,0x4b,0xbd,0xbf,0x8f,
	0xbd,0x47,0x45,0xd4,0x08,0xbd,0x50,0x55,0xd4,0x0b,0xbd,0x47,0x52,0x41,0x50,0x48,
	0x49,0x43,0xd3,0xa9,0xbd,0x50,0x4c,0x4f,0xd4,0xa9,0xbd,0x50,0x4f,0x53,0x49,0x54,
	0x49,0x4f,0xce,0x0c,0xbd,0x44,0x4f,0xd3,0xa9,0xbd,0x44,0x52,0x41,0x57,0x54,0xcf,
	0xa7,0xbd,0x53,0x45,0x54,0x43,0x4f,0x4c,0x4f,0xd2,0x30,0xbd,0x4c,0x4f,0x43,0x41,
	0x54,0xc5,0xa5,0xbd,0x53,0x4f,0x55,0x4e,0xc4,0x4f,0xbd,0x4c,0x50,0x52,0x49,0x4e,
	0xd4,0x0c,0xbd,0x43,0x53,0x41,0x56,0xc5,0x0c,0xbd,0x43,0x4c,0x4f,0x41,0xc4,0x38,
	0xbe,0x44,0x49,0xd2,0x0e,0xbd,0x00,0x80,0xff,0xff,0x45,0x52,0x52,0x4f,0x52,0x2d,
	0x20,0xa0,0xac,0xa4,0xba,0xbb,0x9b,0x47,0x4f,0x54,0xcf,0x47,0x4f,0x53,0x55,0xc2,
	0x54,0xcf,0x53,0x54,0x45,0xd0,0x54,0x48,0x45,0xce,0xa3,0x3c,0xbd,0x3c,0xbe,0x3e,
	0xbd,0xbc,0xbe,0xbd,0xde,0xaa,0xab,0xad,0xaf,0x4e,0x4f,0xd4,0x4f,0xd2,0x41,0x4e,
	0xc4,0xa8,0xa9,0xbd,0xbd,0x3c,0xbd,0x3c,0xbe,0x3e,0xbd,0xbc,0xbe,0xbd,0xab,0xad,
	0xa8,0xa8,0xa8,0xa8,0xa8,0xac,0x53,0x54,0x52,0xa4,0x43,0x48,0x52,0xa4,0x55,0x53,
	0xd2,0x41,0x53,0xc3,0x56,0x41,0xcc,0x4c,0x45,0xce,0x41,0x44,0xd2,0x41,0x54,0xce,
	0x43,0x4f,0xd3,0x50,0x45,0x45,0xcb,0x53,0x49,0xce,0x52,0x4e,0xc4,0x46,0x52,0xc5,
	0x45,0x58,0xd0,0x4c,0x4f,0xc7,0x43,0x4c,0x4f,0xc7,0x53,0x51,0xd2,0x53,0x47,0xce,
	0x41,0x42,0xd3,0x49,0x4e,0xd4,0x50,0x41,0x44,0x44,0x4c,0xc5,0x53,0x54,0x49,0x43,
	0xcb,0x50,0x54,0x52,0x49,0xc7,0x53,0x54,0x52,0x49,0xc7,0x00,0x2b,0xbf,0x2c,0xde,
	0x02,0xd0,0xdb,0x02,0xc3,0xb7,0x03,0x25,0x0f,0x35,0x02,0x26,0x0f,0x36,0x02,0x28,
	0x03,0xfd,0x02,0xe8,0x02,0x01,0xa3,0x2f,0x02,0x00,0xcc,0xbc,0x03,0xc4,0x9e,0x02,
	0x03,0x23,0x02,0x25,0x02,0x26,0x02,0x24,0x02,0x27,0x02,0x1d,0x02,0x1f,0x02,0x1e,
	0x02,0x20,0x02,0x21,0x02,0x22,0x02,0x2a,0x02,0x29,0x03,0x01,0xa3,0x7e,0xc2,0x03,
	0x2b,0x0f,0x38,0x0e,0xc4,0x2c,0x02,0x03,0x12,0x0f,0x3c,0x0e,0x02,0x03,0x44,0xd2,
	0x02,0x00,0x18,0xbe,0xd3,0x02,0xc2,0x03,0x3f,0x2b,0x0f,0x3a,0x00,0x24,0xbe,0x2c,
	0x03,0x2b,0x0f,0x3a,0x0e,0x2c,0x03,0x2b,0x0f,0x3a,0xc7,0x2c,0x03,0xc4,0xe3,0xc2,
	0x03,0xc8,0x02,0xcb,0x02,0x01,0xa3,0x45,0x03,0x00,0x20,0xbe,0xa5,0x03,0x01,0xa3,
	0x81,0xc2,0x03,0x2b,0x0f,0x37,0x0e,0xc4,0x2c,0x02,0x03,0x12,0x0f,0x3c,0x0e,0x02,
	0x03,0x1d,0x0f,0x2f,0x02,0x1f,0x0f,0x31,0x02,0x1e,0x0f,0x30,0x02,0x20,0x0f,0x32,
	0x02,0x21,0x0f,0x33,0x02,0x22,0x0f,0x34,0x03,0x1c,0x0e,0x12,0x0e,0xfb,0x03,0x00,
	0x9a,0xbc,0x22,0x0f,0x2d,0x0e,0xf2,0x02,0x86,0x22,0x0f,0x2e,0x00,0xd0,0xbc,0xe9,
	0x03,0x01,0xa3,0x7e,0x22,0x0f,0x2d,0x0e,0x19,0x0e,0xc3,0xdd,0x03,0x1a,0x0e,0x02,
	0x03,0x0e,0x12,0x0e,0x12,0x00,0x9a,0xbc,0xd0,0x03,0x01,0xa3,0x7e,0xcb,0x03,0x0e,
	0xc8,0x02,0xc6,0x03,0xf7,0xdb,0xc2,0x03,0x14,0x02,0x16,0x03,0xc9,0xbb,0x02,0xec,
	0x00,0xeb,0xbd,0xb5,0x03,0x1c,0x0e,0x03,0x00,0x9a,0xbc,0x02,0x01,0xa3,0x81,0x03,
	0xb8,0xc2,0x03,0x12,0xbc,0x02,0x03,0x0e,0x12,0xac,0x12,0xf7,0x12,0xf1,0x9a,0x03,
	0xa5,0x97,0x03,0xeb,0x94,0x03,0xe8,0x91,0x02,0x8f,0x03,0x9a,0x12,0x02,0x97,0x15,
	0x02,0x03,0xdc,0x85,0x02,0xd9,0x12,0xc4,0x02,0xc2,0x03,0x00,0x0b,0xbe,0xf2,0x03,
	0xc3,0xef,0x03,0x82,0x12,0x00,0x9a,0xbc,0x03,0xba,0x12,0xba,0xe4,0x03,0x00,0xd0,
	0xbc,0x03,0x0e,0x12,0x0e,0x03,0x0e,0x12,0x0e,0x12,0xb8,0xd5,0x03,0xec,0xd2,0x03,
	0x0e,0xc4,0xc7,0xcd,0x03,0x17,0x02,0x18,0x03,0x0e,0xc2,0x03,0x12,0xbc,0x02,0x03,
	0x14,0x02,0x16,0x03,0x01,0xa3,0x7e,0x2b,0x0f,0x39,0x0e,0x00,0xa7,0xbc,0x2c,0x02,
	0x01,0xa3,0x81,0x2b,0x0f,0x3b,0x0e,0x2c,0x03,0xab,0xc2,0x03,0x12,0xbc,0x02,0x03,
	0x0e,0x1b,0xc3,0x9d,0x03,0x01,0xa3,0x2f,0x02,0x01,0xa4,0x35,0xc9,0x02,0xd4,0xc3,
	0x02,0x03,0xc3,0x02,0x03,0xc3,0xc8,0x03,0x0e,0x02,0x00,0xd0,0xbc,0x03,0xc4,0xb3,
	0x02,0x03,0xc6,0xc2,0x03,0xbd,0x02,0x03,0x12,0x02,0x15,0x03,0x0e,0xc3,0x02,0x03,
	0x12,0x0e,0x02,0x12,0x02,0x03,0x01,0xa4,0x32,0x40,0x02,0x43,0x02,0x41,0x02,0x42,
	0x03,0x3d,0x02,0x3e,0x03,0x0e,0xc2,0x03,0x12,0x0f,0x3c,0xba,0x02,0x03,0x00,0x54,
	0xbd,0x12,0x0e,0x12,0x0e,0x00,0xbf,0xbd,0x03,0xc5,0x00,0xbf,0xbd,0x03,0x00,0x9d,
	0xbd,0x02,0x03,0x3e,0x3e,0x79,0x8f,0x0a,0xfc,0xe9,0x6c,0xaa,0xf0,0x95,0x95,0x7e,
	0x36,0x3e,0x68,0x90,0x48,0x1e,0x75,0x90,0x5d,0x5a,0x15,0x2c,0x93,0x55,0x66,0x86,
	0x11,0x45,0x64,0x47,0x78,0xb5,0x7d,0x67,0xff,0x4a,0xc8,0x47,0xb7,0xac,0xef,0xe0,
	0xd3,0x44,0xea,0x95,0xff,0xb8,0xe3,0x8c,0x09,0xe9,0x64,0xde,0xac,0xac,0xac,0xb1,
	0xae,0xad,0xa6,0xaf,0xaf,0xaf,0xaf,0xaf,0xaf,0xb0,0xb0,0xb0,0xb0,0xb2,0xb1,0xb1,
	0xb0,0xb0,0xb0,0xb2,0xb3,0xb3,0xb2,0xb2,0xb2,0xb2,0xaf,0xb1,0xad,0xb1,0xac,0xb1,
	0xb8,0xb0,0xb0,0xb8,0xad,0xb2,0xb2,0xb1,0xb2,0xb2,0xb0,0xb2,0xb1,0xb2,0xb1,0xad,
	0xb3,0xb3,0xa6,0xb0,0xb3,0x4d,0x56,0x6d,0x5d,0x64,0x74,0xec,0xd3,0xc3,0xcb,0xdb,
	0xa0,0x85,0x7b,0xfe,0x82,0xec,0xff,0x4d,0x56,0x6d,0x5d,0x64,0x74,0xfe,0xe3,0x87,
	0x1d,0xf5,0x82,0xf5,0x80,0x8d,0xb9,0xd6,0xf9,0x7d,0x17,0x0d,0xdd,0xd3,0x21,0xc9,
	0x2b,0x48,0x97,0xa1,0xb0,0xbf,0x94,0xb7,0x8d,0x5d,0x60,0x63,0x66,0xa8,0xa8,0xa8,
	0xa8,0xa8,0xa8,0xab,0xa8,0xa8,0xa8,0xa8,0xa8,0xa8,0xa8,0xa8,0xa9,0xa8,0xa8,0xa8,
	0xa8,0xa8,0xa8,0xa8,0xa8,0xa8,0xa8,0xa9,0xaa,0xa9,0xa9,0xa9,0xa9,0xaa,0xaa,0xaa,
	0xaa,0xab,0xab,0xab,0xab,0xab,0xab,0xab,0xab,0xab,0xab,0xab,0xab,0xab,0xa8,0xa8,
	0xab,0xab,0xab,0xab,0xab,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
	0x00,0x00,0x77,0x77,0x77,0x77,0x77,0x77,0xaa,0x99,0x88,0x88,0x99,0xdc,0x55,0x66,
	0xf2,0x4e,0xf1,0xf1,0xee,0xee,0xee,0xee,0xee,0xee,0xdc,0xdc,0xf2,0xf2,0xf2,0xf2,
	0xf2,0x43,0xf2,0xf2,0xf2,0xf2,0xf2,0xf2,0xf2,0xf2,0xf2,0xf2,0xf2,0xf2,0xf2,0xf2,
	0xf2,0xf2,0xf2,0xf2,0xf2,0xf2,0xf2,0xf2,0xf2,0xf2,0x42,0x06,0x55,0x36,0x00,0x00,
	0x40,0x57,0x29,0x57,0x79,0x51,0xbd,0x03,0x55,0x14,0x99,0x39,0x3e,0x01,0x60,0x44,
	0x27,0x52,0xbe,0x46,0x81,0x75,0x43,0x55,0x3f,0x07,0x96,0x92,0x62,0x39,0xbf,0x64,
	0x59,0x64,0x08,0x67,0x40,0x01,0x57,0x07,0x96,0x32,0x40,0x90,0x00,0x00,0x00,0x00,
	0x52,0x45,0x41,0x44,0x59,0x9b,0x53,0x54,0x4f,0x50,0x50,0x45,0x44,0xa0,0x41,0x54,
	0x20,0x4c,0x49,0x4e,0x45,0xa0,0x53,0x3a,0x9b,0x50,0x3a,0x9b,0x43,0x3a,0x9b,0x44,
	0x3a,0x2a,0x2e,0x2a,0x9b,0x44,0x3a,0x41,0x55,0x54,0x4f,0x52,0x55,0x4e,0x2e,0x42,
	0x41,0x53,0x9b,0x42,0x61,0x73,0x69,0x63,0x2b,0x2b,0x20,0x31,0x2e,0x30,0x33,0x20,
	0x62,0x79,0x20,0x53,0x4d,0x49,0x20,0x31,0x39,0x37,0x39,0x2c,0x20,0x54,0x48,0x4f,
	0x52,0x20,0x32,0x30,0x31,0x35,0x9b,0x00,0x00,0x00,0x00,0xa0,0x00,0x05,0x3f,0xac
};
///
