; -- kat5200.iss --
; 
; Complile with InnoSetup

[Setup]
AppName=kat5200
AppVerName=kat5200 version 0.6.2
UsePreviousAppDir=yes
PrivilegesRequired=admin
DefaultDirName={pf}\kat5200
DefaultGroupName=kat5200
UninstallDisplayIcon={app}\kat5200.exe
Compression=lzma
SolidCompression=yes
OutputDir=.
OutputBaseFilename=kat5200-0.6.2-setup

[Files]
Source: "Release\kat5200.exe"; DestDir: "{app}"

;For SDL, I assume the compiled one has been copied over to the program release
Source: "Release\SDL.dll"; DestDir: "{app}"

Source: "src\sql\kat5200.db3"; DestDir: "{app}"; Flags : confirmoverwrite
Source: "src\fonts\default.bmp"; DestDir: "{app}"
Source: "resources\kat5200.bmp"; DestDir: "{app}"
Source: "src\roms\colors.bin"; DestDir: "{app}"
Source: "doc\kat5200.html\*.html"; DestDir: "{app}\doc"

[Messages]
FileExists=Configuration file exists.  Overwriting will delete %nall user settings. %n%nWould you like Setup to overwrite it? (Recommend No)

[Icons]
Name: "{group}\kat5200"; Filename: "{app}\kat5200.exe"
Name: "{group}\Manual"; Filename: "{app}\doc\index.html"
Name: "{group}\Uninstall kat5200"; Filename: "{uninstallexe}"

[Code]
procedure CurStepChanged(CurStep: TSetupStep);
var
	ErrorCode: Integer;
begin
if CurStep = ssPostInstall then
  begin
  if MsgBox('Please ensure that the Visual C++ 2008 SP1 Redistributable package is installed on your system.' #13#13 'Visit the Microsoft download site now?', mbConfirmation, mb_YESNO) = IDYES then
    ShellExec('open', 'http://www.microsoft.com/downloads/details.aspx?familyid=A5C84275-3B97-4AB7-A40D-3802B2AF5FC2&displaylang=en', '', '', 1, ewNoWait, ErrorCode);
  end;
end;

[UninstallDelete]
Type: files; Name: "{app}\kat5200.log"
Type: files; Name: "{app}\tmp_font.bmp"
Type: files; Name: "{app}\tmp_font.bmp.gz"
