/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Canvas;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.image.ColorModel;
import java.awt.image.IndexColorModel;
import java.awt.image.MemoryImageSource;
import java.util.Arrays;
import java.util.Hashtable;
import java.util.Vector;
import org.ibex.nestedvm.Runtime;

class AtariCanvas
extends Canvas
implements KeyListener {
    byte[] pixels;
    MemoryImageSource mis;
    IndexColorModel icm;
    Image image;
    int atari_width;
    int atari_height;
    int atari_visible_width;
    int atari_left_margin;
    int width;
    int height;
    int scalew;
    int scaleh;
    int size;
    boolean windowClosed = false;
    Vector keyqueue;
    Hashtable kbhits;
    byte[][] paletteTable;
    byte[] temp;

    AtariCanvas() {
    }

    @Override
    public void paint(Graphics graphics) {
        this.update(graphics);
    }

    @Override
    public void update(Graphics graphics) {
        graphics.drawImage(this.image, 0, 0, this.width * this.scalew, this.height * this.scaleh, null);
    }

    public void init() {
        this.width = this.atari_visible_width;
        this.temp = new byte[this.width];
        this.height = this.atari_height;
        this.size = this.width * this.height;
        this.pixels = new byte[this.size];
        for (int i = 0; i < this.size; ++i) {
            this.pixels[i] = 0;
        }
        this.keyqueue = new Vector();
        this.addKeyListener(this);
        this.kbhits = new Hashtable();
    }

    public void initPalette(Runtime runtime, int n) {
        this.paletteTable = new byte[3][256];
        int n2 = 0;
        for (int i = 0; i < 256; ++i) {
            try {
                n2 = runtime.memRead(n + i * 4);
            }
            catch (Exception exception) {
                System.err.println(exception);
            }
            this.paletteTable[0][i] = (byte)(n2 >>> 16 & 0xFF);
            this.paletteTable[1][i] = (byte)(n2 >>> 8 & 0xFF);
            this.paletteTable[2][i] = (byte)(n2 & 0xFF);
        }
        this.icm = new IndexColorModel(8, 256, this.paletteTable[0], this.paletteTable[1], this.paletteTable[2]);
        this.mis = new MemoryImageSource(this.width, this.height, (ColorModel)this.icm, this.pixels, 0, this.width);
        this.mis.setAnimated(true);
        this.mis.setFullBufferUpdates(true);
        this.image = this.createImage(this.mis);
    }

    public void displayScreen(Runtime runtime, int n) {
        int n2 = n + this.atari_left_margin;
        int n3 = 0;
        for (int i = 0; i < 240; ++i) {
            try {
                runtime.copyin(n2, this.temp, this.width);
                System.arraycopy(this.temp, 0, this.pixels, n3, this.width);
            }
            catch (Exception exception) {
                System.err.println(exception);
            }
            n2 += this.atari_width;
            n3 += this.width;
        }
        this.mis.newPixels();
        this.repaint();
    }

    public void setWindowClosed() {
        this.windowClosed = true;
    }

    @Override
    public void keyPressed(KeyEvent keyEvent) {
        char c = keyEvent.getKeyChar();
        int n = keyEvent.getKeyCode();
        int n2 = keyEvent.getKeyLocation();
        this.keyqueue.addElement(keyEvent);
        Integer[] integerArray = new Integer[]{new Integer(n), new Integer(n2)};
        this.kbhits.put(Arrays.asList(integerArray), new Boolean(true));
    }

    @Override
    public void keyReleased(KeyEvent keyEvent) {
        char c = keyEvent.getKeyChar();
        int n = keyEvent.getKeyCode();
        int n2 = keyEvent.getKeyLocation();
        this.keyqueue.addElement(keyEvent);
        Integer[] integerArray = new Integer[]{new Integer(n), new Integer(n2)};
        this.kbhits.remove(Arrays.asList(integerArray));
    }

    @Override
    public void keyTyped(KeyEvent keyEvent) {
    }

    int getKbhits(int n, int n2) {
        Integer[] integerArray = new Integer[]{new Integer(n), new Integer(n2)};
        if (this.kbhits.get(Arrays.asList(integerArray)) != null) {
            return 1;
        }
        return 0;
    }

    int pollKeyEvent(Runtime runtime, int n) {
        if (this.keyqueue.isEmpty()) {
            return 0;
        }
        KeyEvent keyEvent = (KeyEvent)this.keyqueue.firstElement();
        this.keyqueue.removeElement(keyEvent);
        int n2 = keyEvent.getID();
        int n3 = keyEvent.getKeyCode();
        char c = keyEvent.getKeyChar();
        int n4 = keyEvent.getKeyLocation();
        try {
            runtime.memWrite(n + 0, n2);
            runtime.memWrite(n + 4, n3);
            runtime.memWrite(n + 8, c);
            runtime.memWrite(n + 12, n4);
        }
        catch (Exception exception) {
            System.err.println(exception);
        }
        return 1;
    }

    int getWindowClosed() {
        return this.windowClosed ? 1 : 0;
    }
}

