//============================================================================
//
//   SSSS    tt          lll  lll       
//  SS  SS   tt           ll   ll        
//  SS     tttttt  eeee   ll   ll   aaaa 
//   SSSS    tt   ee  ee  ll   ll      aa
//      SS   tt   eeeeee  ll   ll   aaaaa  --  "An Atari 2600 VCS Emulator"
//  SS  SS   tt   ee      ll   ll  aa  aa
//   SSSS     ttt  eeeee llll llll  aaaaa
//
// Copyright (c) 1995-2015 by Bradford W. Mott, Stephen Anthony
// and the Stella Team
//
// See the file "License.txt" for information on usage and redistribution of
// this file, and for a DISCLAIMER OF ALL WARRANTIES.
//
// $Id: CartMCWidget.hxx 3182 2015-07-10 18:59:03Z stephena $
//============================================================================

#ifndef CARTRIDGEMC_WIDGET_HXX
#define CARTRIDGEMC_WIDGET_HXX

class CartridgeMC;
class PopUpWidget;

#include "CartDebugWidget.hxx"

class CartridgeMCWidget : public CartDebugWidget
{
  public:
    CartridgeMCWidget(GuiObject* boss, const GUI::Font& lfont,
                      const GUI::Font& nfont,
                      int x, int y, int w, int h,
                      CartridgeMC& cart);
    virtual ~CartridgeMCWidget() { }

  private:
    CartridgeMC& myCart;
    PopUpWidget *mySlice0, *mySlice1, *mySlice2, *mySlice3;

    enum {
      kSlice0Changed = 's0CH',
      kSlice1Changed = 's1CH',
      kSlice2Changed = 's2CH',
      kSlice3Changed = 's3CH'
    };

  private:
    void loadConfig() override;
    void handleCommand(CommandSender* sender, int cmd, int data, int id) override;

    string bankState() override;

    // Following constructors and assignment operators not supported
    CartridgeMCWidget() = delete;
    CartridgeMCWidget(const CartridgeMCWidget&) = delete;
    CartridgeMCWidget(CartridgeMCWidget&&) = delete;
    CartridgeMCWidget& operator=(const CartridgeMCWidget&) = delete;
    CartridgeMCWidget& operator=(CartridgeMCWidget&&) = delete;
};

#endif
