// license:BSD-3-Clause
// copyright-holders:Olivier Galibert, R. Belmont, Couriersud
#ifndef GET_GLFUNC
#ifndef MANGLE

/***************************************************************
 *
 * Standard Header
 *
 ***************************************************************/

	#ifndef _OSD_OPENGL_H
	#define _OSD_OPENGL_H

	#if USE_OPENGL

	/* equivalent to #include <GL/gl.h>
	 * #include <GL/glext.h>
	 */
	#ifdef OSD_WINDOWS
		#ifdef _MSC_VER
			#include <windows.h>
			#include "SDL1211_opengl.h"
		#else
			#include "GL/gl.h"
			#include "GL/glext.h"
			#ifndef USE_DISPATCH_GL
			#include "GL/wglext.h"
			#endif
		#endif
	#else
	#if (SDLMAME_SDL2)
	#include <SDL2/SDL_version.h>
	#else
	#include <SDL/SDL_version.h>
	#endif

	#if (SDL_VERSION_ATLEAST(1,2,10))
	#if defined(SDLMAME_WIN32)
		// Avoid that winnt.h (included via sdl_opengl.h, windows.h, windef.h includes intrin.h
		#define __INTRIN_H_
	#endif
	#if (SDLMAME_SDL2)
	#include <SDL2/SDL_opengl.h>
	#else
	#include <SDL/SDL_opengl.h>
	#endif
	#else
	/*
	 * SDL 1.2.9 does not provide everything we need
	 * We therefore distribute it ourselves
	 */
	#include "SDL1211_opengl.h"
	#endif
	#endif

	class osd_gl_context
	{
	public:
		osd_gl_context() { }
		virtual ~osd_gl_context() { }
		virtual void MakeCurrent() = 0;
		virtual const char *LastErrorMsg() = 0;
		virtual void *getProcAddress(const char *proc) = 0;
		/*
		 *  0 for immediate updates,
		 *  1 for updates synchronized with the vertical retrace,
		 *  -1 for late swap tearing
		 *
		 *  returns -1 if swap interval is not supported
		 *
		 */
		virtual int SetSwapInterval(const int swap) = 0;
		virtual void SwapBuffer() = 0;
	};


	#ifdef USE_DISPATCH_GL

#ifdef MACOSX_USE_LIBSDL
	#ifndef APIENTRY
	#define APIENTRY
	#endif

	#include <OpenGL/gl.h>
	#include <OpenGL/glext.h>

	typedef void (APIENTRY * PFNGLACTIVETEXTUREARBPROC) (GLenum target);
#endif

	#define OSD_GL(ret,func,params) ret (APIENTRY *func) params;
	#define OSD_GL_UNUSED(ret,func,params)

#ifdef _MSC_VER
	extern "C" {
#endif
		struct osd_gl_dispatch
		{
			#define GET_GLFUNC 1
			#include "osd_opengl.h"
			#undef GET_GLFUNC
		};
#ifdef _MSC_VER
	}
#endif

	#undef OSD_GL
	#undef OSD_GL_UNUSED

#ifdef _MSC_VER
	extern "C" osd_gl_dispatch *gl_dispatch;
#endif
	extern osd_gl_dispatch *gl_dispatch;

	/*
	 * Use gl_mangle to map function names
	 */

	#define MANGLE(x) gl_dispatch->gl ## x
	#include "osd_opengl.h"

	#endif /* USE_DISPATCH_GL */

	#endif /* USE_OPENGL */

	#endif /* _OSD_OPENGL_H */

#else /* MANGLE */
	/***************************************************************
	 *
	 * Used to redefine opengl functions
	 *
	 * Credits: taken from gl_mangle.h
	 *
	 ***************************************************************/

	#define glAccum     MANGLE(Accum)
	#define glActiveStencilFaceEXT      MANGLE(ActiveStencilFaceEXT)
	#define glActiveTextureARB      MANGLE(ActiveTextureARB)
	#define glActiveTexture     MANGLE(ActiveTexture)
	#define glAlphaFragmentOp1ATI       MANGLE(AlphaFragmentOp1ATI)
	#define glAlphaFragmentOp2ATI       MANGLE(AlphaFragmentOp2ATI)
	#define glAlphaFragmentOp3ATI       MANGLE(AlphaFragmentOp3ATI)
	#define glAlphaFunc     MANGLE(AlphaFunc)
	#define glApplyTextureEXT       MANGLE(ApplyTextureEXT)
	#define glAreProgramsResidentNV     MANGLE(AreProgramsResidentNV)
	#define glAreTexturesResidentEXT        MANGLE(AreTexturesResidentEXT)
	#define glAreTexturesResident       MANGLE(AreTexturesResident)
	#define glArrayElementEXT       MANGLE(ArrayElementEXT)
	#define glArrayElement      MANGLE(ArrayElement)
	#define glArrayObjectATI        MANGLE(ArrayObjectATI)
	#define glAsyncMarkerSGIX       MANGLE(AsyncMarkerSGIX)
	#define glAttachObjectARB       MANGLE(AttachObjectARB)
	#define glAttachShader      MANGLE(AttachShader)
	#define glBeginFragmentShaderATI        MANGLE(BeginFragmentShaderATI)
	#define glBegin     MANGLE(Begin)
	#define glBeginOcclusionQueryNV     MANGLE(BeginOcclusionQueryNV)
	#define glBeginQueryARB     MANGLE(BeginQueryARB)
	#define glBeginQuery        MANGLE(BeginQuery)
	#define glBeginVertexShaderEXT      MANGLE(BeginVertexShaderEXT)
	#define glBindAttribLocationARB     MANGLE(BindAttribLocationARB)
	#define glBindAttribLocation        MANGLE(BindAttribLocation)
	#define glBindBufferARB     MANGLE(BindBufferARB)
	#define glBindBuffer        MANGLE(BindBuffer)
	#define glBindFragmentShaderATI     MANGLE(BindFragmentShaderATI)
	#define glBindFramebufferEXT        MANGLE(BindFramebufferEXT)
	#define glBindLightParameterEXT     MANGLE(BindLightParameterEXT)
	#define glBindMaterialParameterEXT      MANGLE(BindMaterialParameterEXT)
	#define glBindParameterEXT      MANGLE(BindParameterEXT)
	#define glBindProgramARB        MANGLE(BindProgramARB)
	#define glBindProgramNV     MANGLE(BindProgramNV)
	#define glBindRenderbufferEXT       MANGLE(BindRenderbufferEXT)
	#define glBindTexGenParameterEXT        MANGLE(BindTexGenParameterEXT)
	#define glBindTextureEXT        MANGLE(BindTextureEXT)
	#define glBindTexture       MANGLE(BindTexture)
	#define glBindTextureUnitParameterEXT       MANGLE(BindTextureUnitParameterEXT)
	#define glBindVertexArrayAPPLE      MANGLE(BindVertexArrayAPPLE)
	#define glBindVertexShaderEXT       MANGLE(BindVertexShaderEXT)
	#define glBinormal3bEXT     MANGLE(Binormal3bEXT)
	#define glBinormal3bvEXT        MANGLE(Binormal3bvEXT)
	#define glBinormal3dEXT     MANGLE(Binormal3dEXT)
	#define glBinormal3dvEXT        MANGLE(Binormal3dvEXT)
	#define glBinormal3fEXT     MANGLE(Binormal3fEXT)
	#define glBinormal3fvEXT        MANGLE(Binormal3fvEXT)
	#define glBinormal3iEXT     MANGLE(Binormal3iEXT)
	#define glBinormal3ivEXT        MANGLE(Binormal3ivEXT)
	#define glBinormal3sEXT     MANGLE(Binormal3sEXT)
	#define glBinormal3svEXT        MANGLE(Binormal3svEXT)
	#define glBinormalPointerEXT        MANGLE(BinormalPointerEXT)
	#define glBitmap        MANGLE(Bitmap)
	#define glBlendColorEXT     MANGLE(BlendColorEXT)
	#define glBlendColor        MANGLE(BlendColor)
	#define glBlendEquationEXT      MANGLE(BlendEquationEXT)
	#define glBlendEquation     MANGLE(BlendEquation)
	#define glBlendEquationSeparateATI      MANGLE(BlendEquationSeparateATI)
	#define glBlendEquationSeparateEXT      MANGLE(BlendEquationSeparateEXT)
	#define glBlendEquationSeparate     MANGLE(BlendEquationSeparate)
	#define glBlendFunc     MANGLE(BlendFunc)
	#define glBlendFuncSeparateEXT      MANGLE(BlendFuncSeparateEXT)
	#define glBlendFuncSeparateINGR     MANGLE(BlendFuncSeparateINGR)
	#define glBlendFuncSeparate     MANGLE(BlendFuncSeparate)
	#define glBlitFramebufferEXT        MANGLE(BlitFramebufferEXT)
	#define glBufferDataARB     MANGLE(BufferDataARB)
	#define glBufferData        MANGLE(BufferData)
	#define glBufferSubDataARB      MANGLE(BufferSubDataARB)
	#define glBufferSubData     MANGLE(BufferSubData)
	#define glCallList      MANGLE(CallList)
	#define glCallLists     MANGLE(CallLists)
	#define glCheckFramebufferStatusEXT     MANGLE(CheckFramebufferStatusEXT)
	#define glClampColorARB     MANGLE(ClampColorARB)
	#define glClearAccum        MANGLE(ClearAccum)
	#define glClearColor        MANGLE(ClearColor)
	#define glClearDebugLogMESA     MANGLE(ClearDebugLogMESA)
	#define glClearDepth        MANGLE(ClearDepth)
	#define glClearIndex        MANGLE(ClearIndex)
	#define glClear     MANGLE(Clear)
	#define glClearStencil      MANGLE(ClearStencil)
	#define glClientActiveTextureARB        MANGLE(ClientActiveTextureARB)
	#define glClientActiveTexture       MANGLE(ClientActiveTexture)
	#define glClientActiveVertexStreamATI       MANGLE(ClientActiveVertexStreamATI)
	#define glClipPlane     MANGLE(ClipPlane)
	#define glColor3b       MANGLE(Color3b)
	#define glColor3bv      MANGLE(Color3bv)
	#define glColor3d       MANGLE(Color3d)
	#define glColor3dv      MANGLE(Color3dv)
	#define glColor3f       MANGLE(Color3f)
	#define glColor3fVertex3fSUN        MANGLE(Color3fVertex3fSUN)
	#define glColor3fVertex3fvSUN       MANGLE(Color3fVertex3fvSUN)
	#define glColor3fv      MANGLE(Color3fv)
	#define glColor3hNV     MANGLE(Color3hNV)
	#define glColor3hvNV        MANGLE(Color3hvNV)
	#define glColor3i       MANGLE(Color3i)
	#define glColor3iv      MANGLE(Color3iv)
	#define glColor3s       MANGLE(Color3s)
	#define glColor3sv      MANGLE(Color3sv)
	#define glColor3ub      MANGLE(Color3ub)
	#define glColor3ubv     MANGLE(Color3ubv)
	#define glColor3ui      MANGLE(Color3ui)
	#define glColor3uiv     MANGLE(Color3uiv)
	#define glColor3us      MANGLE(Color3us)
	#define glColor3usv     MANGLE(Color3usv)
	#define glColor4b       MANGLE(Color4b)
	#define glColor4bv      MANGLE(Color4bv)
	#define glColor4d       MANGLE(Color4d)
	#define glColor4dv      MANGLE(Color4dv)
	#define glColor4f       MANGLE(Color4f)
	#define glColor4fNormal3fVertex3fSUN        MANGLE(Color4fNormal3fVertex3fSUN)
	#define glColor4fNormal3fVertex3fvSUN       MANGLE(Color4fNormal3fVertex3fvSUN)
	#define glColor4fv      MANGLE(Color4fv)
	#define glColor4hNV     MANGLE(Color4hNV)
	#define glColor4hvNV        MANGLE(Color4hvNV)
	#define glColor4i       MANGLE(Color4i)
	#define glColor4iv      MANGLE(Color4iv)
	#define glColor4s       MANGLE(Color4s)
	#define glColor4sv      MANGLE(Color4sv)
	#define glColor4ub      MANGLE(Color4ub)
	#define glColor4ubVertex2fSUN       MANGLE(Color4ubVertex2fSUN)
	#define glColor4ubVertex2fvSUN      MANGLE(Color4ubVertex2fvSUN)
	#define glColor4ubVertex3fSUN       MANGLE(Color4ubVertex3fSUN)
	#define glColor4ubVertex3fvSUN      MANGLE(Color4ubVertex3fvSUN)
	#define glColor4ubv     MANGLE(Color4ubv)
	#define glColor4ui      MANGLE(Color4ui)
	#define glColor4uiv     MANGLE(Color4uiv)
	#define glColor4us      MANGLE(Color4us)
	#define glColor4usv     MANGLE(Color4usv)
	#define glColorFragmentOp1ATI       MANGLE(ColorFragmentOp1ATI)
	#define glColorFragmentOp2ATI       MANGLE(ColorFragmentOp2ATI)
	#define glColorFragmentOp3ATI       MANGLE(ColorFragmentOp3ATI)
	#define glColorMask     MANGLE(ColorMask)
	#define glColorMaterial     MANGLE(ColorMaterial)
	#define glColorPointerEXT       MANGLE(ColorPointerEXT)
	#define glColorPointerListIBM       MANGLE(ColorPointerListIBM)
	#define glColorPointer      MANGLE(ColorPointer)
	#define glColorPointervINTEL        MANGLE(ColorPointervINTEL)
	#define glColorSubTableEXT      MANGLE(ColorSubTableEXT)
	#define glColorSubTable     MANGLE(ColorSubTable)
	#define glColorTableEXT     MANGLE(ColorTableEXT)
	#define glColorTable        MANGLE(ColorTable)
	#define glColorTableParameterfv     MANGLE(ColorTableParameterfv)
	#define glColorTableParameterfvSGI      MANGLE(ColorTableParameterfvSGI)
	#define glColorTableParameteriv     MANGLE(ColorTableParameteriv)
	#define glColorTableParameterivSGI      MANGLE(ColorTableParameterivSGI)
	#define glColorTableSGI     MANGLE(ColorTableSGI)
	#define glCombinerInputNV       MANGLE(CombinerInputNV)
	#define glCombinerOutputNV      MANGLE(CombinerOutputNV)
	#define glCombinerParameterfNV      MANGLE(CombinerParameterfNV)
	#define glCombinerParameterfvNV     MANGLE(CombinerParameterfvNV)
	#define glCombinerParameteriNV      MANGLE(CombinerParameteriNV)
	#define glCombinerParameterivNV     MANGLE(CombinerParameterivNV)
	#define glCombinerStageParameterfvNV        MANGLE(CombinerStageParameterfvNV)
	#define glCompileShaderARB      MANGLE(CompileShaderARB)
	#define glCompileShader     MANGLE(CompileShader)
	#define glCompressedTexImage1DARB       MANGLE(CompressedTexImage1DARB)
	#define glCompressedTexImage1D      MANGLE(CompressedTexImage1D)
	#define glCompressedTexImage2DARB       MANGLE(CompressedTexImage2DARB)
	#define glCompressedTexImage2D      MANGLE(CompressedTexImage2D)
	#define glCompressedTexImage3DARB       MANGLE(CompressedTexImage3DARB)
	#define glCompressedTexImage3D      MANGLE(CompressedTexImage3D)
	#define glCompressedTexSubImage1DARB        MANGLE(CompressedTexSubImage1DARB)
	#define glCompressedTexSubImage1D       MANGLE(CompressedTexSubImage1D)
	#define glCompressedTexSubImage2DARB        MANGLE(CompressedTexSubImage2DARB)
	#define glCompressedTexSubImage2D       MANGLE(CompressedTexSubImage2D)
	#define glCompressedTexSubImage3DARB        MANGLE(CompressedTexSubImage3DARB)
	#define glCompressedTexSubImage3D       MANGLE(CompressedTexSubImage3D)
	#define glConvolutionFilter1DEXT        MANGLE(ConvolutionFilter1DEXT)
	#define glConvolutionFilter1D       MANGLE(ConvolutionFilter1D)
	#define glConvolutionFilter2DEXT        MANGLE(ConvolutionFilter2DEXT)
	#define glConvolutionFilter2D       MANGLE(ConvolutionFilter2D)
	#define glConvolutionParameterfEXT      MANGLE(ConvolutionParameterfEXT)
	#define glConvolutionParameterf     MANGLE(ConvolutionParameterf)
	#define glConvolutionParameterfvEXT     MANGLE(ConvolutionParameterfvEXT)
	#define glConvolutionParameterfv        MANGLE(ConvolutionParameterfv)
	#define glConvolutionParameteriEXT      MANGLE(ConvolutionParameteriEXT)
	#define glConvolutionParameteri     MANGLE(ConvolutionParameteri)
	#define glConvolutionParameterivEXT     MANGLE(ConvolutionParameterivEXT)
	#define glConvolutionParameteriv        MANGLE(ConvolutionParameteriv)
	#define glCopyColorSubTableEXT      MANGLE(CopyColorSubTableEXT)
	#define glCopyColorSubTable     MANGLE(CopyColorSubTable)
	#define glCopyColorTable        MANGLE(CopyColorTable)
	#define glCopyColorTableSGI     MANGLE(CopyColorTableSGI)
	#define glCopyConvolutionFilter1DEXT        MANGLE(CopyConvolutionFilter1DEXT)
	#define glCopyConvolutionFilter1D       MANGLE(CopyConvolutionFilter1D)
	#define glCopyConvolutionFilter2DEXT        MANGLE(CopyConvolutionFilter2DEXT)
	#define glCopyConvolutionFilter2D       MANGLE(CopyConvolutionFilter2D)
	#define glCopyPixels        MANGLE(CopyPixels)
	#define glCopyTexImage1DEXT     MANGLE(CopyTexImage1DEXT)
	#define glCopyTexImage1D        MANGLE(CopyTexImage1D)
	#define glCopyTexImage2DEXT     MANGLE(CopyTexImage2DEXT)
	#define glCopyTexImage2D        MANGLE(CopyTexImage2D)
	#define glCopyTexSubImage1DEXT      MANGLE(CopyTexSubImage1DEXT)
	#define glCopyTexSubImage1D     MANGLE(CopyTexSubImage1D)
	#define glCopyTexSubImage2DEXT      MANGLE(CopyTexSubImage2DEXT)
	#define glCopyTexSubImage2D     MANGLE(CopyTexSubImage2D)
	#define glCopyTexSubImage3DEXT      MANGLE(CopyTexSubImage3DEXT)
	#define glCopyTexSubImage3D     MANGLE(CopyTexSubImage3D)
	#define glCreateDebugObjectMESA     MANGLE(CreateDebugObjectMESA)
	#define glCreateProgram     MANGLE(CreateProgram)
	#define glCreateProgramObjectARB        MANGLE(CreateProgramObjectARB)
	#define glCreateShader      MANGLE(CreateShader)
	#define glCreateShaderObjectARB     MANGLE(CreateShaderObjectARB)
	#define glCullFace      MANGLE(CullFace)
	#define glCullParameterdvEXT        MANGLE(CullParameterdvEXT)
	#define glCullParameterfvEXT        MANGLE(CullParameterfvEXT)
	#define glCurrentPaletteMatrixARB       MANGLE(CurrentPaletteMatrixARB)
	#define glDeformationMap3dSGIX      MANGLE(DeformationMap3dSGIX)
	#define glDeformationMap3fSGIX      MANGLE(DeformationMap3fSGIX)
	#define glDeformSGIX        MANGLE(DeformSGIX)
	#define glDeleteAsyncMarkersSGIX        MANGLE(DeleteAsyncMarkersSGIX)
	#define glDeleteBuffersARB      MANGLE(DeleteBuffersARB)
	#define glDeleteBuffers     MANGLE(DeleteBuffers)
	#define glDeleteFencesAPPLE     MANGLE(DeleteFencesAPPLE)
	#define glDeleteFencesNV        MANGLE(DeleteFencesNV)
	#define glDeleteFragmentShaderATI       MANGLE(DeleteFragmentShaderATI)
	#define glDeleteFramebuffersEXT     MANGLE(DeleteFramebuffersEXT)
	#define glDeleteLists       MANGLE(DeleteLists)
	#define glDeleteObjectARB       MANGLE(DeleteObjectARB)
	#define glDeleteOcclusionQueriesNV      MANGLE(DeleteOcclusionQueriesNV)
	#define glDeleteProgram     MANGLE(DeleteProgram)
	#define glDeleteProgramsARB     MANGLE(DeleteProgramsARB)
	#define glDeleteProgramsNV      MANGLE(DeleteProgramsNV)
	#define glDeleteQueriesARB      MANGLE(DeleteQueriesARB)
	#define glDeleteQueries     MANGLE(DeleteQueries)
	#define glDeleteRenderbuffersEXT        MANGLE(DeleteRenderbuffersEXT)
	#define glDeleteShader      MANGLE(DeleteShader)
	#define glDeleteTexturesEXT     MANGLE(DeleteTexturesEXT)
	#define glDeleteTextures        MANGLE(DeleteTextures)
	#define glDeleteVertexArraysAPPLE       MANGLE(DeleteVertexArraysAPPLE)
	#define glDeleteVertexShaderEXT     MANGLE(DeleteVertexShaderEXT)
	#define glDepthBoundsEXT        MANGLE(DepthBoundsEXT)
	#define glDepthFunc     MANGLE(DepthFunc)
	#define glDepthMask     MANGLE(DepthMask)
	#define glDepthRange        MANGLE(DepthRange)
	#define glDetachObjectARB       MANGLE(DetachObjectARB)
	#define glDetachShader      MANGLE(DetachShader)
	#define glDetailTexFuncSGIS     MANGLE(DetailTexFuncSGIS)
	#define glDisableClientState        MANGLE(DisableClientState)
	#define glDisable       MANGLE(Disable)
	#define glDisableVariantClientStateEXT      MANGLE(DisableVariantClientStateEXT)
	#define glDisableVertexAttribArrayARB       MANGLE(DisableVertexAttribArrayARB)
	#define glDisableVertexAttribArray      MANGLE(DisableVertexAttribArray)
	#define glDrawArraysEXT     MANGLE(DrawArraysEXT)
	#define glDrawArrays        MANGLE(DrawArrays)
	#define glDrawBuffer        MANGLE(DrawBuffer)
	#define glDrawBuffersARB        MANGLE(DrawBuffersARB)
	#define glDrawBuffersATI        MANGLE(DrawBuffersATI)
	#define glDrawBuffers       MANGLE(DrawBuffers)
	#define glDrawElementArrayAPPLE     MANGLE(DrawElementArrayAPPLE)
	#define glDrawElementArrayATI       MANGLE(DrawElementArrayATI)
	#define glDrawElements      MANGLE(DrawElements)
	#define glDrawMeshArraysSUN     MANGLE(DrawMeshArraysSUN)
	#define glDrawPixels        MANGLE(DrawPixels)
	#define glDrawRangeElementArrayAPPLE        MANGLE(DrawRangeElementArrayAPPLE)
	#define glDrawRangeElementArrayATI      MANGLE(DrawRangeElementArrayATI)
	#define glDrawRangeElementsEXT      MANGLE(DrawRangeElementsEXT)
	#define glDrawRangeElements     MANGLE(DrawRangeElements)
	#define glEdgeFlag      MANGLE(EdgeFlag)
	#define glEdgeFlagPointerEXT        MANGLE(EdgeFlagPointerEXT)
	#define glEdgeFlagPointerListIBM        MANGLE(EdgeFlagPointerListIBM)
	#define glEdgeFlagPointer       MANGLE(EdgeFlagPointer)
	#define glEdgeFlagv     MANGLE(EdgeFlagv)
	#define glElementPointerAPPLE       MANGLE(ElementPointerAPPLE)
	#define glElementPointerATI     MANGLE(ElementPointerATI)
	#define glEnableClientState     MANGLE(EnableClientState)
	#define glEnable        MANGLE(Enable)
	#define glEnableVariantClientStateEXT       MANGLE(EnableVariantClientStateEXT)
	#define glEnableVertexAttribArrayARB        MANGLE(EnableVertexAttribArrayARB)
	#define glEnableVertexAttribArray       MANGLE(EnableVertexAttribArray)
	#define glEndFragmentShaderATI      MANGLE(EndFragmentShaderATI)
	#define glEndList       MANGLE(EndList)
	#define glEnd       MANGLE(End)
	#define glEndOcclusionQueryNV       MANGLE(EndOcclusionQueryNV)
	#define glEndQueryARB       MANGLE(EndQueryARB)
	#define glEndQuery      MANGLE(EndQuery)
	#define glEndVertexShaderEXT        MANGLE(EndVertexShaderEXT)
	#define glEvalCoord1d       MANGLE(EvalCoord1d)
	#define glEvalCoord1dv      MANGLE(EvalCoord1dv)
	#define glEvalCoord1f       MANGLE(EvalCoord1f)
	#define glEvalCoord1fv      MANGLE(EvalCoord1fv)
	#define glEvalCoord2d       MANGLE(EvalCoord2d)
	#define glEvalCoord2dv      MANGLE(EvalCoord2dv)
	#define glEvalCoord2f       MANGLE(EvalCoord2f)
	#define glEvalCoord2fv      MANGLE(EvalCoord2fv)
	#define glEvalMapsNV        MANGLE(EvalMapsNV)
	#define glEvalMesh1     MANGLE(EvalMesh1)
	#define glEvalMesh2     MANGLE(EvalMesh2)
	#define glEvalPoint1        MANGLE(EvalPoint1)
	#define glEvalPoint2        MANGLE(EvalPoint2)
	#define glExecuteProgramNV      MANGLE(ExecuteProgramNV)
	#define glExtractComponentEXT       MANGLE(ExtractComponentEXT)
	#define glFeedbackBuffer        MANGLE(FeedbackBuffer)
	#define glFinalCombinerInputNV      MANGLE(FinalCombinerInputNV)
	#define glFinishAsyncSGIX       MANGLE(FinishAsyncSGIX)
	#define glFinishFenceAPPLE      MANGLE(FinishFenceAPPLE)
	#define glFinishFenceNV     MANGLE(FinishFenceNV)
	#define glFinish        MANGLE(Finish)
	#define glFinishObjectAPPLE     MANGLE(FinishObjectAPPLE)
	#define glFinishTextureSUNX     MANGLE(FinishTextureSUNX)
	#define glFlush     MANGLE(Flush)
	#define glFlushPixelDataRangeNV     MANGLE(FlushPixelDataRangeNV)
	#define glFlushRasterSGIX       MANGLE(FlushRasterSGIX)
	#define glFlushVertexArrayRangeAPPLE        MANGLE(FlushVertexArrayRangeAPPLE)
	#define glFlushVertexArrayRangeNV       MANGLE(FlushVertexArrayRangeNV)
	#define glFogCoorddEXT      MANGLE(FogCoorddEXT)
	#define glFogCoordd     MANGLE(FogCoordd)
	#define glFogCoorddvEXT     MANGLE(FogCoorddvEXT)
	#define glFogCoorddv        MANGLE(FogCoorddv)
	#define glFogCoordfEXT      MANGLE(FogCoordfEXT)
	#define glFogCoordf     MANGLE(FogCoordf)
	#define glFogCoordfvEXT     MANGLE(FogCoordfvEXT)
	#define glFogCoordfv        MANGLE(FogCoordfv)
	#define glFogCoordhNV       MANGLE(FogCoordhNV)
	#define glFogCoordhvNV      MANGLE(FogCoordhvNV)
	#define glFogCoordPointerEXT        MANGLE(FogCoordPointerEXT)
	#define glFogCoordPointerListIBM        MANGLE(FogCoordPointerListIBM)
	#define glFogCoordPointer       MANGLE(FogCoordPointer)
	#define glFogf      MANGLE(Fogf)
	#define glFogFuncSGIS       MANGLE(FogFuncSGIS)
	#define glFogfv     MANGLE(Fogfv)
	#define glFogi      MANGLE(Fogi)
	#define glFogiv     MANGLE(Fogiv)
	#define glFragmentColorMaterialSGIX     MANGLE(FragmentColorMaterialSGIX)
	#define glFragmentLightfSGIX        MANGLE(FragmentLightfSGIX)
	#define glFragmentLightfvSGIX       MANGLE(FragmentLightfvSGIX)
	#define glFragmentLightiSGIX        MANGLE(FragmentLightiSGIX)
	#define glFragmentLightivSGIX       MANGLE(FragmentLightivSGIX)
	#define glFragmentLightModelfSGIX       MANGLE(FragmentLightModelfSGIX)
	#define glFragmentLightModelfvSGIX      MANGLE(FragmentLightModelfvSGIX)
	#define glFragmentLightModeliSGIX       MANGLE(FragmentLightModeliSGIX)
	#define glFragmentLightModelivSGIX      MANGLE(FragmentLightModelivSGIX)
	#define glFragmentMaterialfSGIX     MANGLE(FragmentMaterialfSGIX)
	#define glFragmentMaterialfvSGIX        MANGLE(FragmentMaterialfvSGIX)
	#define glFragmentMaterialiSGIX     MANGLE(FragmentMaterialiSGIX)
	#define glFragmentMaterialivSGIX        MANGLE(FragmentMaterialivSGIX)
	#define glFramebufferRenderbufferEXT        MANGLE(FramebufferRenderbufferEXT)
	#define glFramebufferTexture1DEXT       MANGLE(FramebufferTexture1DEXT)
	#define glFramebufferTexture2DEXT       MANGLE(FramebufferTexture2DEXT)
	#define glFramebufferTexture3DEXT       MANGLE(FramebufferTexture3DEXT)
	#define glFrameZoomSGIX     MANGLE(FrameZoomSGIX)
	#define glFreeObjectBufferATI       MANGLE(FreeObjectBufferATI)
	#define glFrontFace     MANGLE(FrontFace)
	#define glFrustum       MANGLE(Frustum)
	#define glGenAsyncMarkersSGIX       MANGLE(GenAsyncMarkersSGIX)
	#define glGenBuffersARB     MANGLE(GenBuffersARB)
	#define glGenBuffers        MANGLE(GenBuffers)
	#define glGenerateMipmapEXT     MANGLE(GenerateMipmapEXT)
	#define glGenFencesAPPLE        MANGLE(GenFencesAPPLE)
	#define glGenFencesNV       MANGLE(GenFencesNV)
	#define glGenFragmentShadersATI     MANGLE(GenFragmentShadersATI)
	#define glGenFramebuffersEXT        MANGLE(GenFramebuffersEXT)
	#define glGenLists      MANGLE(GenLists)
	#define glGenOcclusionQueriesNV     MANGLE(GenOcclusionQueriesNV)
	#define glGenProgramsARB        MANGLE(GenProgramsARB)
	#define glGenProgramsNV     MANGLE(GenProgramsNV)
	#define glGenQueriesARB     MANGLE(GenQueriesARB)
	#define glGenQueries        MANGLE(GenQueries)
	#define glGenRenderbuffersEXT       MANGLE(GenRenderbuffersEXT)
	#define glGenSymbolsEXT     MANGLE(GenSymbolsEXT)
	#define glGenTexturesEXT        MANGLE(GenTexturesEXT)
	#define glGenTextures       MANGLE(GenTextures)
	#define glGenVertexArraysAPPLE      MANGLE(GenVertexArraysAPPLE)
	#define glGenVertexShadersEXT       MANGLE(GenVertexShadersEXT)
	#define glGetActiveAttribARB        MANGLE(GetActiveAttribARB)
	#define glGetActiveAttrib       MANGLE(GetActiveAttrib)
	#define glGetActiveUniformARB       MANGLE(GetActiveUniformARB)
	#define glGetActiveUniform      MANGLE(GetActiveUniform)
	#define glGetArrayObjectfvATI       MANGLE(GetArrayObjectfvATI)
	#define glGetArrayObjectivATI       MANGLE(GetArrayObjectivATI)
	#define glGetAttachedObjectsARB     MANGLE(GetAttachedObjectsARB)
	#define glGetAttachedShaders        MANGLE(GetAttachedShaders)
	#define glGetAttribLocationARB      MANGLE(GetAttribLocationARB)
	#define glGetAttribLocation     MANGLE(GetAttribLocation)
	#define glGetBooleanv       MANGLE(GetBooleanv)
	#define glGetBufferParameterivARB       MANGLE(GetBufferParameterivARB)
	#define glGetBufferParameteriv      MANGLE(GetBufferParameteriv)
	#define glGetBufferPointervARB      MANGLE(GetBufferPointervARB)
	#define glGetBufferPointerv     MANGLE(GetBufferPointerv)
	#define glGetBufferSubDataARB       MANGLE(GetBufferSubDataARB)
	#define glGetBufferSubData      MANGLE(GetBufferSubData)
	#define glGetClipPlane      MANGLE(GetClipPlane)
	#define glGetColorTableEXT      MANGLE(GetColorTableEXT)
	#define glGetColorTable     MANGLE(GetColorTable)
	#define glGetColorTableParameterfvEXT       MANGLE(GetColorTableParameterfvEXT)
	#define glGetColorTableParameterfv      MANGLE(GetColorTableParameterfv)
	#define glGetColorTableParameterfvSGI       MANGLE(GetColorTableParameterfvSGI)
	#define glGetColorTableParameterivEXT       MANGLE(GetColorTableParameterivEXT)
	#define glGetColorTableParameteriv      MANGLE(GetColorTableParameteriv)
	#define glGetColorTableParameterivSGI       MANGLE(GetColorTableParameterivSGI)
	#define glGetColorTableSGI      MANGLE(GetColorTableSGI)
	#define glGetCombinerInputParameterfvNV     MANGLE(GetCombinerInputParameterfvNV)
	#define glGetCombinerInputParameterivNV     MANGLE(GetCombinerInputParameterivNV)
	#define glGetCombinerOutputParameterfvNV        MANGLE(GetCombinerOutputParameterfvNV)
	#define glGetCombinerOutputParameterivNV        MANGLE(GetCombinerOutputParameterivNV)
	#define glGetCombinerStageParameterfvNV     MANGLE(GetCombinerStageParameterfvNV)
	#define glGetCompressedTexImageARB      MANGLE(GetCompressedTexImageARB)
	#define glGetCompressedTexImage     MANGLE(GetCompressedTexImage)
	#define glGetConvolutionFilterEXT       MANGLE(GetConvolutionFilterEXT)
	#define glGetConvolutionFilter      MANGLE(GetConvolutionFilter)
	#define glGetConvolutionParameterfvEXT      MANGLE(GetConvolutionParameterfvEXT)
	#define glGetConvolutionParameterfv     MANGLE(GetConvolutionParameterfv)
	#define glGetConvolutionParameterivEXT      MANGLE(GetConvolutionParameterivEXT)
	#define glGetConvolutionParameteriv     MANGLE(GetConvolutionParameteriv)
	#define glGetDebugLogLengthMESA     MANGLE(GetDebugLogLengthMESA)
	#define glGetDebugLogMESA       MANGLE(GetDebugLogMESA)
	#define glGetDetailTexFuncSGIS      MANGLE(GetDetailTexFuncSGIS)
	#define glGetDoublev        MANGLE(GetDoublev)
	#define glGetError      MANGLE(GetError)
	#define glGetFenceivNV      MANGLE(GetFenceivNV)
	#define glGetFinalCombinerInputParameterfvNV        MANGLE(GetFinalCombinerInputParameterfvNV)
	#define glGetFinalCombinerInputParameterivNV        MANGLE(GetFinalCombinerInputParameterivNV)
	#define glGetFloatv     MANGLE(GetFloatv)
	#define glGetFogFuncSGIS        MANGLE(GetFogFuncSGIS)
	#define glGetFragmentLightfvSGIX        MANGLE(GetFragmentLightfvSGIX)
	#define glGetFragmentLightivSGIX        MANGLE(GetFragmentLightivSGIX)
	#define glGetFragmentMaterialfvSGIX     MANGLE(GetFragmentMaterialfvSGIX)
	#define glGetFragmentMaterialivSGIX     MANGLE(GetFragmentMaterialivSGIX)
	#define glGetFramebufferAttachmentParameterivEXT        MANGLE(GetFramebufferAttachmentParameterivEXT)
	#define glGetHandleARB      MANGLE(GetHandleARB)
	#define glGetHistogramEXT       MANGLE(GetHistogramEXT)
	#define glGetHistogram      MANGLE(GetHistogram)
	#define glGetHistogramParameterfvEXT        MANGLE(GetHistogramParameterfvEXT)
	#define glGetHistogramParameterfv       MANGLE(GetHistogramParameterfv)
	#define glGetHistogramParameterivEXT        MANGLE(GetHistogramParameterivEXT)
	#define glGetHistogramParameteriv       MANGLE(GetHistogramParameteriv)
	#define glGetImageTransformParameterfvHP        MANGLE(GetImageTransformParameterfvHP)
	#define glGetImageTransformParameterivHP        MANGLE(GetImageTransformParameterivHP)
	#define glGetInfoLogARB     MANGLE(GetInfoLogARB)
	#define glGetInstrumentsSGIX        MANGLE(GetInstrumentsSGIX)
	#define glGetIntegerv       MANGLE(GetIntegerv)
	#define glGetInvariantBooleanvEXT       MANGLE(GetInvariantBooleanvEXT)
	#define glGetInvariantFloatvEXT     MANGLE(GetInvariantFloatvEXT)
	#define glGetInvariantIntegervEXT       MANGLE(GetInvariantIntegervEXT)
	#define glGetLightfv        MANGLE(GetLightfv)
	#define glGetLightiv        MANGLE(GetLightiv)
	#define glGetListParameterfvSGIX        MANGLE(GetListParameterfvSGIX)
	#define glGetListParameterivSGIX        MANGLE(GetListParameterivSGIX)
	#define glGetLocalConstantBooleanvEXT       MANGLE(GetLocalConstantBooleanvEXT)
	#define glGetLocalConstantFloatvEXT     MANGLE(GetLocalConstantFloatvEXT)
	#define glGetLocalConstantIntegervEXT       MANGLE(GetLocalConstantIntegervEXT)
	#define glGetMapAttribParameterfvNV     MANGLE(GetMapAttribParameterfvNV)
	#define glGetMapAttribParameterivNV     MANGLE(GetMapAttribParameterivNV)
	#define glGetMapControlPointsNV     MANGLE(GetMapControlPointsNV)
	#define glGetMapdv      MANGLE(GetMapdv)
	#define glGetMapfv      MANGLE(GetMapfv)
	#define glGetMapiv      MANGLE(GetMapiv)
	#define glGetMapParameterfvNV       MANGLE(GetMapParameterfvNV)
	#define glGetMapParameterivNV       MANGLE(GetMapParameterivNV)
	#define glGetMaterialfv     MANGLE(GetMaterialfv)
	#define glGetMaterialiv     MANGLE(GetMaterialiv)
	#define glGetMinmaxEXT      MANGLE(GetMinmaxEXT)
	#define glGetMinmax     MANGLE(GetMinmax)
	#define glGetMinmaxParameterfvEXT       MANGLE(GetMinmaxParameterfvEXT)
	#define glGetMinmaxParameterfv      MANGLE(GetMinmaxParameterfv)
	#define glGetMinmaxParameterivEXT       MANGLE(GetMinmaxParameterivEXT)
	#define glGetMinmaxParameteriv      MANGLE(GetMinmaxParameteriv)
	#define glGetObjectBufferfvATI      MANGLE(GetObjectBufferfvATI)
	#define glGetObjectBufferivATI      MANGLE(GetObjectBufferivATI)
	#define glGetObjectParameterfvARB       MANGLE(GetObjectParameterfvARB)
	#define glGetObjectParameterivARB       MANGLE(GetObjectParameterivARB)
	#define glGetOcclusionQueryivNV     MANGLE(GetOcclusionQueryivNV)
	#define glGetOcclusionQueryuivNV        MANGLE(GetOcclusionQueryuivNV)
	#define glGetPixelMapfv     MANGLE(GetPixelMapfv)
	#define glGetPixelMapuiv        MANGLE(GetPixelMapuiv)
	#define glGetPixelMapusv        MANGLE(GetPixelMapusv)
	#define glGetPixelTexGenParameterfvSGIS     MANGLE(GetPixelTexGenParameterfvSGIS)
	#define glGetPixelTexGenParameterivSGIS     MANGLE(GetPixelTexGenParameterivSGIS)
	#define glGetPointervEXT        MANGLE(GetPointervEXT)
	#define glGetPointerv       MANGLE(GetPointerv)
	#define glGetPolygonStipple     MANGLE(GetPolygonStipple)
	#define glGetProgramEnvParameterdvARB       MANGLE(GetProgramEnvParameterdvARB)
	#define glGetProgramEnvParameterfvARB       MANGLE(GetProgramEnvParameterfvARB)
	#define glGetProgramInfoLog     MANGLE(GetProgramInfoLog)
	#define glGetProgramivARB       MANGLE(GetProgramivARB)
	#define glGetProgramiv      MANGLE(GetProgramiv)
	#define glGetProgramivNV        MANGLE(GetProgramivNV)
	#define glGetProgramLocalParameterdvARB     MANGLE(GetProgramLocalParameterdvARB)
	#define glGetProgramLocalParameterfvARB     MANGLE(GetProgramLocalParameterfvARB)
	#define glGetProgramNamedParameterdvNV      MANGLE(GetProgramNamedParameterdvNV)
	#define glGetProgramNamedParameterfvNV      MANGLE(GetProgramNamedParameterfvNV)
	#define glGetProgramParameterdvNV       MANGLE(GetProgramParameterdvNV)
	#define glGetProgramParameterfvNV       MANGLE(GetProgramParameterfvNV)
	#define glGetProgramRegisterfvMESA      MANGLE(GetProgramRegisterfvMESA)
	#define glGetProgramStringARB       MANGLE(GetProgramStringARB)
	#define glGetProgramStringNV        MANGLE(GetProgramStringNV)
	#define glGetQueryivARB     MANGLE(GetQueryivARB)
	#define glGetQueryiv        MANGLE(GetQueryiv)
	#define glGetQueryObjecti64vEXT     MANGLE(GetQueryObjecti64vEXT)
	#define glGetQueryObjectivARB       MANGLE(GetQueryObjectivARB)
	#define glGetQueryObjectiv      MANGLE(GetQueryObjectiv)
	#define glGetQueryObjectui64vEXT        MANGLE(GetQueryObjectui64vEXT)
	#define glGetQueryObjectuivARB      MANGLE(GetQueryObjectuivARB)
	#define glGetQueryObjectuiv     MANGLE(GetQueryObjectuiv)
	#define glGetRenderbufferParameterivEXT     MANGLE(GetRenderbufferParameterivEXT)
	#define glGetSeparableFilterEXT     MANGLE(GetSeparableFilterEXT)
	#define glGetSeparableFilter        MANGLE(GetSeparableFilter)
	#define glGetShaderInfoLog      MANGLE(GetShaderInfoLog)
	#define glGetShaderiv       MANGLE(GetShaderiv)
	#define glGetShaderSourceARB        MANGLE(GetShaderSourceARB)
	#define glGetShaderSource       MANGLE(GetShaderSource)
	#define glGetSharpenTexFuncSGIS     MANGLE(GetSharpenTexFuncSGIS)
	#define glGetString     MANGLE(GetString)
	#define glGetTexBumpParameterfvATI      MANGLE(GetTexBumpParameterfvATI)
	#define glGetTexBumpParameterivATI      MANGLE(GetTexBumpParameterivATI)
	#define glGetTexEnvfv       MANGLE(GetTexEnvfv)
	#define glGetTexEnviv       MANGLE(GetTexEnviv)
	#define glGetTexFilterFuncSGIS      MANGLE(GetTexFilterFuncSGIS)
	#define glGetTexGendv       MANGLE(GetTexGendv)
	#define glGetTexGenfv       MANGLE(GetTexGenfv)
	#define glGetTexGeniv       MANGLE(GetTexGeniv)
	#define glGetTexImage       MANGLE(GetTexImage)
	#define glGetTexLevelParameterfv        MANGLE(GetTexLevelParameterfv)
	#define glGetTexLevelParameteriv        MANGLE(GetTexLevelParameteriv)
	#define glGetTexParameterfv     MANGLE(GetTexParameterfv)
	#define glGetTexParameteriv     MANGLE(GetTexParameteriv)
	#define glGetTrackMatrixivNV        MANGLE(GetTrackMatrixivNV)
	#define glGetUniformfvARB       MANGLE(GetUniformfvARB)
	#define glGetUniformfv      MANGLE(GetUniformfv)
	#define glGetUniformivARB       MANGLE(GetUniformivARB)
	#define glGetUniformiv      MANGLE(GetUniformiv)
	#define glGetUniformLocationARB     MANGLE(GetUniformLocationARB)
	#define glGetUniformLocation        MANGLE(GetUniformLocation)
	#define glGetVariantArrayObjectfvATI        MANGLE(GetVariantArrayObjectfvATI)
	#define glGetVariantArrayObjectivATI        MANGLE(GetVariantArrayObjectivATI)
	#define glGetVariantBooleanvEXT     MANGLE(GetVariantBooleanvEXT)
	#define glGetVariantFloatvEXT       MANGLE(GetVariantFloatvEXT)
	#define glGetVariantIntegervEXT     MANGLE(GetVariantIntegervEXT)
	#define glGetVariantPointervEXT     MANGLE(GetVariantPointervEXT)
	#define glGetVertexAttribArrayObjectfvATI       MANGLE(GetVertexAttribArrayObjectfvATI)
	#define glGetVertexAttribArrayObjectivATI       MANGLE(GetVertexAttribArrayObjectivATI)
	#define glGetVertexAttribdvARB      MANGLE(GetVertexAttribdvARB)
	#define glGetVertexAttribdv     MANGLE(GetVertexAttribdv)
	#define glGetVertexAttribdvNV       MANGLE(GetVertexAttribdvNV)
	#define glGetVertexAttribfvARB      MANGLE(GetVertexAttribfvARB)
	#define glGetVertexAttribfv     MANGLE(GetVertexAttribfv)
	#define glGetVertexAttribfvNV       MANGLE(GetVertexAttribfvNV)
	#define glGetVertexAttribivARB      MANGLE(GetVertexAttribivARB)
	#define glGetVertexAttribiv     MANGLE(GetVertexAttribiv)
	#define glGetVertexAttribivNV       MANGLE(GetVertexAttribivNV)
	#define glGetVertexAttribPointervARB        MANGLE(GetVertexAttribPointervARB)
	#define glGetVertexAttribPointerv       MANGLE(GetVertexAttribPointerv)
	#define glGetVertexAttribPointervNV     MANGLE(GetVertexAttribPointervNV)
	#define glGlobalAlphaFactorbSUN     MANGLE(GlobalAlphaFactorbSUN)
	#define glGlobalAlphaFactordSUN     MANGLE(GlobalAlphaFactordSUN)
	#define glGlobalAlphaFactorfSUN     MANGLE(GlobalAlphaFactorfSUN)
	#define glGlobalAlphaFactoriSUN     MANGLE(GlobalAlphaFactoriSUN)
	#define glGlobalAlphaFactorsSUN     MANGLE(GlobalAlphaFactorsSUN)
	#define glGlobalAlphaFactorubSUN        MANGLE(GlobalAlphaFactorubSUN)
	#define glGlobalAlphaFactoruiSUN        MANGLE(GlobalAlphaFactoruiSUN)
	#define glGlobalAlphaFactorusSUN        MANGLE(GlobalAlphaFactorusSUN)
	#define glHint      MANGLE(Hint)
	#define glHintPGI       MANGLE(HintPGI)
	#define glHistogramEXT      MANGLE(HistogramEXT)
	#define glHistogram     MANGLE(Histogram)
	#define glIglooInterfaceSGIX        MANGLE(IglooInterfaceSGIX)
	#define glImageTransformParameterfHP        MANGLE(ImageTransformParameterfHP)
	#define glImageTransformParameterfvHP       MANGLE(ImageTransformParameterfvHP)
	#define glImageTransformParameteriHP        MANGLE(ImageTransformParameteriHP)
	#define glImageTransformParameterivHP       MANGLE(ImageTransformParameterivHP)
	#define glIndexd        MANGLE(Indexd)
	#define glIndexdv       MANGLE(Indexdv)
	#define glIndexf        MANGLE(Indexf)
	#define glIndexFuncEXT      MANGLE(IndexFuncEXT)
	#define glIndexfv       MANGLE(Indexfv)
	#define glIndexi        MANGLE(Indexi)
	#define glIndexiv       MANGLE(Indexiv)
	#define glIndexMask     MANGLE(IndexMask)
	#define glIndexMaterialEXT      MANGLE(IndexMaterialEXT)
	#define glIndexPointerEXT       MANGLE(IndexPointerEXT)
	#define glIndexPointerListIBM       MANGLE(IndexPointerListIBM)
	#define glIndexPointer      MANGLE(IndexPointer)
	#define glIndexs        MANGLE(Indexs)
	#define glIndexsv       MANGLE(Indexsv)
	#define glIndexub       MANGLE(Indexub)
	#define glIndexubv      MANGLE(Indexubv)
	#define glInitNames     MANGLE(InitNames)
	#define glInsertComponentEXT        MANGLE(InsertComponentEXT)
	#define glInstrumentsBufferSGIX     MANGLE(InstrumentsBufferSGIX)
	#define glInterleavedArrays     MANGLE(InterleavedArrays)
	#define glIsAsyncMarkerSGIX     MANGLE(IsAsyncMarkerSGIX)
	#define glIsBufferARB       MANGLE(IsBufferARB)
	#define glIsBuffer      MANGLE(IsBuffer)
	#define glIsEnabled     MANGLE(IsEnabled)
	#define glIsFenceAPPLE      MANGLE(IsFenceAPPLE)
	#define glIsFenceNV     MANGLE(IsFenceNV)
	#define glIsFramebufferEXT      MANGLE(IsFramebufferEXT)
	#define glIsList        MANGLE(IsList)
	#define glIsObjectBufferATI     MANGLE(IsObjectBufferATI)
	#define glIsOcclusionQueryNV        MANGLE(IsOcclusionQueryNV)
	#define glIsProgramARB      MANGLE(IsProgramARB)
	#define glIsProgram     MANGLE(IsProgram)
	#define glIsProgramNV       MANGLE(IsProgramNV)
	#define glIsQueryARB        MANGLE(IsQueryARB)
	#define glIsQuery       MANGLE(IsQuery)
	#define glIsRenderbufferEXT     MANGLE(IsRenderbufferEXT)
	#define glIsShader      MANGLE(IsShader)
	#define glIsTextureEXT      MANGLE(IsTextureEXT)
	#define glIsTexture     MANGLE(IsTexture)
	#define glIsVariantEnabledEXT       MANGLE(IsVariantEnabledEXT)
	#define glIsVertexArrayAPPLE        MANGLE(IsVertexArrayAPPLE)
	#define glLightEnviSGIX     MANGLE(LightEnviSGIX)
	#define glLightf        MANGLE(Lightf)
	#define glLightfv       MANGLE(Lightfv)
	#define glLighti        MANGLE(Lighti)
	#define glLightiv       MANGLE(Lightiv)
	#define glLightModelf       MANGLE(LightModelf)
	#define glLightModelfv      MANGLE(LightModelfv)
	#define glLightModeli       MANGLE(LightModeli)
	#define glLightModeliv      MANGLE(LightModeliv)
	#define glLineStipple       MANGLE(LineStipple)
	#define glLineWidth     MANGLE(LineWidth)
	#define glLinkProgramARB        MANGLE(LinkProgramARB)
	#define glLinkProgram       MANGLE(LinkProgram)
	#define glListBase      MANGLE(ListBase)
	#define glListParameterfSGIX        MANGLE(ListParameterfSGIX)
	#define glListParameterfvSGIX       MANGLE(ListParameterfvSGIX)
	#define glListParameteriSGIX        MANGLE(ListParameteriSGIX)
	#define glListParameterivSGIX       MANGLE(ListParameterivSGIX)
	#define glLoadIdentityDeformationMapSGIX        MANGLE(LoadIdentityDeformationMapSGIX)
	#define glLoadIdentity      MANGLE(LoadIdentity)
	#define glLoadMatrixd       MANGLE(LoadMatrixd)
	#define glLoadMatrixf       MANGLE(LoadMatrixf)
	#define glLoadName      MANGLE(LoadName)
	#define glLoadProgramNV     MANGLE(LoadProgramNV)
	#define glLoadTransposeMatrixdARB       MANGLE(LoadTransposeMatrixdARB)
	#define glLoadTransposeMatrixd      MANGLE(LoadTransposeMatrixd)
	#define glLoadTransposeMatrixfARB       MANGLE(LoadTransposeMatrixfARB)
	#define glLoadTransposeMatrixf      MANGLE(LoadTransposeMatrixf)
	#define glLockArraysEXT     MANGLE(LockArraysEXT)
	#define glLogicOp       MANGLE(LogicOp)
	#define glMap1d     MANGLE(Map1d)
	#define glMap1f     MANGLE(Map1f)
	#define glMap2d     MANGLE(Map2d)
	#define glMap2f     MANGLE(Map2f)
	#define glMapBufferARB      MANGLE(MapBufferARB)
	#define glMapBuffer     MANGLE(MapBuffer)
	#define glMapControlPointsNV        MANGLE(MapControlPointsNV)
	#define glMapGrid1d     MANGLE(MapGrid1d)
	#define glMapGrid1f     MANGLE(MapGrid1f)
	#define glMapGrid2d     MANGLE(MapGrid2d)
	#define glMapGrid2f     MANGLE(MapGrid2f)
	#define glMapObjectBufferATI        MANGLE(MapObjectBufferATI)
	#define glMapParameterfvNV      MANGLE(MapParameterfvNV)
	#define glMapParameterivNV      MANGLE(MapParameterivNV)
	#define glMaterialf     MANGLE(Materialf)
	#define glMaterialfv        MANGLE(Materialfv)
	#define glMateriali     MANGLE(Materiali)
	#define glMaterialiv        MANGLE(Materialiv)
	#define glMatrixIndexPointerARB     MANGLE(MatrixIndexPointerARB)
	#define glMatrixIndexubvARB     MANGLE(MatrixIndexubvARB)
	#define glMatrixIndexuivARB     MANGLE(MatrixIndexuivARB)
	#define glMatrixIndexusvARB     MANGLE(MatrixIndexusvARB)
	#define glMatrixMode        MANGLE(MatrixMode)
	#define glMinmaxEXT     MANGLE(MinmaxEXT)
	#define glMinmax        MANGLE(Minmax)
	#define glMultiDrawArraysEXT        MANGLE(MultiDrawArraysEXT)
	#define glMultiDrawArrays       MANGLE(MultiDrawArrays)
	#define glMultiDrawElementArrayAPPLE        MANGLE(MultiDrawElementArrayAPPLE)
	#define glMultiDrawElementsEXT      MANGLE(MultiDrawElementsEXT)
	#define glMultiDrawElements     MANGLE(MultiDrawElements)
	#define glMultiDrawRangeElementArrayAPPLE       MANGLE(MultiDrawRangeElementArrayAPPLE)
	#define glMultiModeDrawArraysIBM        MANGLE(MultiModeDrawArraysIBM)
	#define glMultiModeDrawElementsIBM      MANGLE(MultiModeDrawElementsIBM)
	#define glMultiTexCoord1dARB        MANGLE(MultiTexCoord1dARB)
	#define glMultiTexCoord1d       MANGLE(MultiTexCoord1d)
	#define glMultiTexCoord1dvARB       MANGLE(MultiTexCoord1dvARB)
	#define glMultiTexCoord1dv      MANGLE(MultiTexCoord1dv)
	#define glMultiTexCoord1fARB        MANGLE(MultiTexCoord1fARB)
	#define glMultiTexCoord1f       MANGLE(MultiTexCoord1f)
	#define glMultiTexCoord1fvARB       MANGLE(MultiTexCoord1fvARB)
	#define glMultiTexCoord1fv      MANGLE(MultiTexCoord1fv)
	#define glMultiTexCoord1hNV     MANGLE(MultiTexCoord1hNV)
	#define glMultiTexCoord1hvNV        MANGLE(MultiTexCoord1hvNV)
	#define glMultiTexCoord1iARB        MANGLE(MultiTexCoord1iARB)
	#define glMultiTexCoord1i       MANGLE(MultiTexCoord1i)
	#define glMultiTexCoord1ivARB       MANGLE(MultiTexCoord1ivARB)
	#define glMultiTexCoord1iv      MANGLE(MultiTexCoord1iv)
	#define glMultiTexCoord1sARB        MANGLE(MultiTexCoord1sARB)
	#define glMultiTexCoord1s       MANGLE(MultiTexCoord1s)
	#define glMultiTexCoord1svARB       MANGLE(MultiTexCoord1svARB)
	#define glMultiTexCoord1sv      MANGLE(MultiTexCoord1sv)
	#define glMultiTexCoord2dARB        MANGLE(MultiTexCoord2dARB)
	#define glMultiTexCoord2d       MANGLE(MultiTexCoord2d)
	#define glMultiTexCoord2dvARB       MANGLE(MultiTexCoord2dvARB)
	#define glMultiTexCoord2dv      MANGLE(MultiTexCoord2dv)
	#define glMultiTexCoord2fARB        MANGLE(MultiTexCoord2fARB)
	#define glMultiTexCoord2f       MANGLE(MultiTexCoord2f)
	#define glMultiTexCoord2fvARB       MANGLE(MultiTexCoord2fvARB)
	#define glMultiTexCoord2fv      MANGLE(MultiTexCoord2fv)
	#define glMultiTexCoord2hNV     MANGLE(MultiTexCoord2hNV)
	#define glMultiTexCoord2hvNV        MANGLE(MultiTexCoord2hvNV)
	#define glMultiTexCoord2iARB        MANGLE(MultiTexCoord2iARB)
	#define glMultiTexCoord2i       MANGLE(MultiTexCoord2i)
	#define glMultiTexCoord2ivARB       MANGLE(MultiTexCoord2ivARB)
	#define glMultiTexCoord2iv      MANGLE(MultiTexCoord2iv)
	#define glMultiTexCoord2sARB        MANGLE(MultiTexCoord2sARB)
	#define glMultiTexCoord2s       MANGLE(MultiTexCoord2s)
	#define glMultiTexCoord2svARB       MANGLE(MultiTexCoord2svARB)
	#define glMultiTexCoord2sv      MANGLE(MultiTexCoord2sv)
	#define glMultiTexCoord3dARB        MANGLE(MultiTexCoord3dARB)
	#define glMultiTexCoord3d       MANGLE(MultiTexCoord3d)
	#define glMultiTexCoord3dvARB       MANGLE(MultiTexCoord3dvARB)
	#define glMultiTexCoord3dv      MANGLE(MultiTexCoord3dv)
	#define glMultiTexCoord3fARB        MANGLE(MultiTexCoord3fARB)
	#define glMultiTexCoord3f       MANGLE(MultiTexCoord3f)
	#define glMultiTexCoord3fvARB       MANGLE(MultiTexCoord3fvARB)
	#define glMultiTexCoord3fv      MANGLE(MultiTexCoord3fv)
	#define glMultiTexCoord3hNV     MANGLE(MultiTexCoord3hNV)
	#define glMultiTexCoord3hvNV        MANGLE(MultiTexCoord3hvNV)
	#define glMultiTexCoord3iARB        MANGLE(MultiTexCoord3iARB)
	#define glMultiTexCoord3i       MANGLE(MultiTexCoord3i)
	#define glMultiTexCoord3ivARB       MANGLE(MultiTexCoord3ivARB)
	#define glMultiTexCoord3iv      MANGLE(MultiTexCoord3iv)
	#define glMultiTexCoord3sARB        MANGLE(MultiTexCoord3sARB)
	#define glMultiTexCoord3s       MANGLE(MultiTexCoord3s)
	#define glMultiTexCoord3svARB       MANGLE(MultiTexCoord3svARB)
	#define glMultiTexCoord3sv      MANGLE(MultiTexCoord3sv)
	#define glMultiTexCoord4dARB        MANGLE(MultiTexCoord4dARB)
	#define glMultiTexCoord4d       MANGLE(MultiTexCoord4d)
	#define glMultiTexCoord4dvARB       MANGLE(MultiTexCoord4dvARB)
	#define glMultiTexCoord4dv      MANGLE(MultiTexCoord4dv)
	#define glMultiTexCoord4fARB        MANGLE(MultiTexCoord4fARB)
	#define glMultiTexCoord4f       MANGLE(MultiTexCoord4f)
	#define glMultiTexCoord4fvARB       MANGLE(MultiTexCoord4fvARB)
	#define glMultiTexCoord4fv      MANGLE(MultiTexCoord4fv)
	#define glMultiTexCoord4hNV     MANGLE(MultiTexCoord4hNV)
	#define glMultiTexCoord4hvNV        MANGLE(MultiTexCoord4hvNV)
	#define glMultiTexCoord4iARB        MANGLE(MultiTexCoord4iARB)
	#define glMultiTexCoord4i       MANGLE(MultiTexCoord4i)
	#define glMultiTexCoord4ivARB       MANGLE(MultiTexCoord4ivARB)
	#define glMultiTexCoord4iv      MANGLE(MultiTexCoord4iv)
	#define glMultiTexCoord4sARB        MANGLE(MultiTexCoord4sARB)
	#define glMultiTexCoord4s       MANGLE(MultiTexCoord4s)
	#define glMultiTexCoord4svARB       MANGLE(MultiTexCoord4svARB)
	#define glMultiTexCoord4sv      MANGLE(MultiTexCoord4sv)
	#define glMultMatrixd       MANGLE(MultMatrixd)
	#define glMultMatrixf       MANGLE(MultMatrixf)
	#define glMultTransposeMatrixdARB       MANGLE(MultTransposeMatrixdARB)
	#define glMultTransposeMatrixd      MANGLE(MultTransposeMatrixd)
	#define glMultTransposeMatrixfARB       MANGLE(MultTransposeMatrixfARB)
	#define glMultTransposeMatrixf      MANGLE(MultTransposeMatrixf)
	#define glNewList       MANGLE(NewList)
	#define glNewObjectBufferATI        MANGLE(NewObjectBufferATI)
	#define glNormal3b      MANGLE(Normal3b)
	#define glNormal3bv     MANGLE(Normal3bv)
	#define glNormal3d      MANGLE(Normal3d)
	#define glNormal3dv     MANGLE(Normal3dv)
	#define glNormal3f      MANGLE(Normal3f)
	#define glNormal3fVertex3fSUN       MANGLE(Normal3fVertex3fSUN)
	#define glNormal3fVertex3fvSUN      MANGLE(Normal3fVertex3fvSUN)
	#define glNormal3fv     MANGLE(Normal3fv)
	#define glNormal3hNV        MANGLE(Normal3hNV)
	#define glNormal3hvNV       MANGLE(Normal3hvNV)
	#define glNormal3i      MANGLE(Normal3i)
	#define glNormal3iv     MANGLE(Normal3iv)
	#define glNormal3s      MANGLE(Normal3s)
	#define glNormal3sv     MANGLE(Normal3sv)
	#define glNormalPointerEXT      MANGLE(NormalPointerEXT)
	#define glNormalPointerListIBM      MANGLE(NormalPointerListIBM)
	#define glNormalPointer     MANGLE(NormalPointer)
	#define glNormalPointervINTEL       MANGLE(NormalPointervINTEL)
	#define glNormalStream3bATI     MANGLE(NormalStream3bATI)
	#define glNormalStream3bvATI        MANGLE(NormalStream3bvATI)
	#define glNormalStream3dATI     MANGLE(NormalStream3dATI)
	#define glNormalStream3dvATI        MANGLE(NormalStream3dvATI)
	#define glNormalStream3fATI     MANGLE(NormalStream3fATI)
	#define glNormalStream3fvATI        MANGLE(NormalStream3fvATI)
	#define glNormalStream3iATI     MANGLE(NormalStream3iATI)
	#define glNormalStream3ivATI        MANGLE(NormalStream3ivATI)
	#define glNormalStream3sATI     MANGLE(NormalStream3sATI)
	#define glNormalStream3svATI        MANGLE(NormalStream3svATI)
	#define glOrtho     MANGLE(Ortho)
	#define glPassTexCoordATI       MANGLE(PassTexCoordATI)
	#define glPassThrough       MANGLE(PassThrough)
	#define glPixelDataRangeNV      MANGLE(PixelDataRangeNV)
	#define glPixelMapfv        MANGLE(PixelMapfv)
	#define glPixelMapuiv       MANGLE(PixelMapuiv)
	#define glPixelMapusv       MANGLE(PixelMapusv)
	#define glPixelStoref       MANGLE(PixelStoref)
	#define glPixelStorei       MANGLE(PixelStorei)
	#define glPixelTexGenParameterfSGIS     MANGLE(PixelTexGenParameterfSGIS)
	#define glPixelTexGenParameterfvSGIS        MANGLE(PixelTexGenParameterfvSGIS)
	#define glPixelTexGenParameteriSGIS     MANGLE(PixelTexGenParameteriSGIS)
	#define glPixelTexGenParameterivSGIS        MANGLE(PixelTexGenParameterivSGIS)
	#define glPixelTexGenSGIX       MANGLE(PixelTexGenSGIX)
	#define glPixelTransferf        MANGLE(PixelTransferf)
	#define glPixelTransferi        MANGLE(PixelTransferi)
	#define glPixelTransformParameterfEXT       MANGLE(PixelTransformParameterfEXT)
	#define glPixelTransformParameterfvEXT      MANGLE(PixelTransformParameterfvEXT)
	#define glPixelTransformParameteriEXT       MANGLE(PixelTransformParameteriEXT)
	#define glPixelTransformParameterivEXT      MANGLE(PixelTransformParameterivEXT)
	#define glPixelZoom     MANGLE(PixelZoom)
	#define glPNTrianglesfATI       MANGLE(PNTrianglesfATI)
	#define glPNTrianglesiATI       MANGLE(PNTrianglesiATI)
	#define glPointParameterfARB        MANGLE(PointParameterfARB)
	#define glPointParameterfEXT        MANGLE(PointParameterfEXT)
	#define glPointParameterf       MANGLE(PointParameterf)
	#define glPointParameterfSGIS       MANGLE(PointParameterfSGIS)
	#define glPointParameterfvARB       MANGLE(PointParameterfvARB)
	#define glPointParameterfvEXT       MANGLE(PointParameterfvEXT)
	#define glPointParameterfv      MANGLE(PointParameterfv)
	#define glPointParameterfvSGIS      MANGLE(PointParameterfvSGIS)
	#define glPointParameteri       MANGLE(PointParameteri)
	#define glPointParameteriNV     MANGLE(PointParameteriNV)
	#define glPointParameteriv      MANGLE(PointParameteriv)
	#define glPointParameterivNV        MANGLE(PointParameterivNV)
	#define glPointSize     MANGLE(PointSize)
	#define glPollAsyncSGIX     MANGLE(PollAsyncSGIX)
	#define glPollInstrumentsSGIX       MANGLE(PollInstrumentsSGIX)
	#define glPolygonMode       MANGLE(PolygonMode)
	#define glPolygonOffsetEXT      MANGLE(PolygonOffsetEXT)
	#define glPolygonOffset     MANGLE(PolygonOffset)
	#define glPolygonStipple        MANGLE(PolygonStipple)
	#define glPopAttrib     MANGLE(PopAttrib)
	#define glPopClientAttrib       MANGLE(PopClientAttrib)
	#define glPopMatrix     MANGLE(PopMatrix)
	#define glPopName       MANGLE(PopName)
	#define glPrimitiveRestartIndexNV       MANGLE(PrimitiveRestartIndexNV)
	#define glPrimitiveRestartNV        MANGLE(PrimitiveRestartNV)
	#define glPrioritizeTexturesEXT     MANGLE(PrioritizeTexturesEXT)
	#define glPrioritizeTextures        MANGLE(PrioritizeTextures)
	#define glProgramCallbackMESA       MANGLE(ProgramCallbackMESA)
	#define glProgramEnvParameter4dARB      MANGLE(ProgramEnvParameter4dARB)
	#define glProgramEnvParameter4dvARB     MANGLE(ProgramEnvParameter4dvARB)
	#define glProgramEnvParameter4fARB      MANGLE(ProgramEnvParameter4fARB)
	#define glProgramEnvParameter4fvARB     MANGLE(ProgramEnvParameter4fvARB)
	#define glProgramEnvParameters4fvEXT        MANGLE(ProgramEnvParameters4fvEXT)
	#define glProgramLocalParameter4dARB        MANGLE(ProgramLocalParameter4dARB)
	#define glProgramLocalParameter4dvARB       MANGLE(ProgramLocalParameter4dvARB)
	#define glProgramLocalParameter4fARB        MANGLE(ProgramLocalParameter4fARB)
	#define glProgramLocalParameter4fvARB       MANGLE(ProgramLocalParameter4fvARB)
	#define glProgramLocalParameters4fvEXT      MANGLE(ProgramLocalParameters4fvEXT)
	#define glProgramNamedParameter4dNV     MANGLE(ProgramNamedParameter4dNV)
	#define glProgramNamedParameter4dvNV        MANGLE(ProgramNamedParameter4dvNV)
	#define glProgramNamedParameter4fNV     MANGLE(ProgramNamedParameter4fNV)
	#define glProgramNamedParameter4fvNV        MANGLE(ProgramNamedParameter4fvNV)
	#define glProgramParameter4dNV      MANGLE(ProgramParameter4dNV)
	#define glProgramParameter4dvNV     MANGLE(ProgramParameter4dvNV)
	#define glProgramParameter4fNV      MANGLE(ProgramParameter4fNV)
	#define glProgramParameter4fvNV     MANGLE(ProgramParameter4fvNV)
	#define glProgramParameters4dvNV        MANGLE(ProgramParameters4dvNV)
	#define glProgramParameters4fvNV        MANGLE(ProgramParameters4fvNV)
	#define glProgramStringARB      MANGLE(ProgramStringARB)
	#define glPushAttrib        MANGLE(PushAttrib)
	#define glPushClientAttrib      MANGLE(PushClientAttrib)
	#define glPushMatrix        MANGLE(PushMatrix)
	#define glPushName      MANGLE(PushName)
	#define glRasterPos2d       MANGLE(RasterPos2d)
	#define glRasterPos2dv      MANGLE(RasterPos2dv)
	#define glRasterPos2f       MANGLE(RasterPos2f)
	#define glRasterPos2fv      MANGLE(RasterPos2fv)
	#define glRasterPos2i       MANGLE(RasterPos2i)
	#define glRasterPos2iv      MANGLE(RasterPos2iv)
	#define glRasterPos2s       MANGLE(RasterPos2s)
	#define glRasterPos2sv      MANGLE(RasterPos2sv)
	#define glRasterPos3d       MANGLE(RasterPos3d)
	#define glRasterPos3dv      MANGLE(RasterPos3dv)
	#define glRasterPos3f       MANGLE(RasterPos3f)
	#define glRasterPos3fv      MANGLE(RasterPos3fv)
	#define glRasterPos3i       MANGLE(RasterPos3i)
	#define glRasterPos3iv      MANGLE(RasterPos3iv)
	#define glRasterPos3s       MANGLE(RasterPos3s)
	#define glRasterPos3sv      MANGLE(RasterPos3sv)
	#define glRasterPos4d       MANGLE(RasterPos4d)
	#define glRasterPos4dv      MANGLE(RasterPos4dv)
	#define glRasterPos4f       MANGLE(RasterPos4f)
	#define glRasterPos4fv      MANGLE(RasterPos4fv)
	#define glRasterPos4i       MANGLE(RasterPos4i)
	#define glRasterPos4iv      MANGLE(RasterPos4iv)
	#define glRasterPos4s       MANGLE(RasterPos4s)
	#define glRasterPos4sv      MANGLE(RasterPos4sv)
	#define glReadBuffer        MANGLE(ReadBuffer)
	#define glReadInstrumentsSGIX       MANGLE(ReadInstrumentsSGIX)
	#define glReadPixels        MANGLE(ReadPixels)
	#define glRectd     MANGLE(Rectd)
	#define glRectdv        MANGLE(Rectdv)
	#define glRectf     MANGLE(Rectf)
	#define glRectfv        MANGLE(Rectfv)
	#define glRecti     MANGLE(Recti)
	#define glRectiv        MANGLE(Rectiv)
	#define glRects     MANGLE(Rects)
	#define glRectsv        MANGLE(Rectsv)
	#define glReferencePlaneSGIX        MANGLE(ReferencePlaneSGIX)
	#define glRenderbufferStorageEXT        MANGLE(RenderbufferStorageEXT)
	#define glRenderbufferStorageMultisampleEXT     MANGLE(RenderbufferStorageMultisampleEXT)
	#define glRenderMode        MANGLE(RenderMode)
	#define glReplacementCodePointerSUN     MANGLE(ReplacementCodePointerSUN)
	#define glReplacementCodeubSUN      MANGLE(ReplacementCodeubSUN)
	#define glReplacementCodeubvSUN     MANGLE(ReplacementCodeubvSUN)
	#define glReplacementCodeuiColor3fVertex3fSUN       MANGLE(ReplacementCodeuiColor3fVertex3fSUN)
	#define glReplacementCodeuiColor3fVertex3fvSUN      MANGLE(ReplacementCodeuiColor3fVertex3fvSUN)
	#define glReplacementCodeuiColor4fNormal3fVertex3fSUN       MANGLE(ReplacementCodeuiColor4fNormal3fVertex3fSUN)
	#define glReplacementCodeuiColor4fNormal3fVertex3fvSUN      MANGLE(ReplacementCodeuiColor4fNormal3fVertex3fvSUN)
	#define glReplacementCodeuiColor4ubVertex3fSUN      MANGLE(ReplacementCodeuiColor4ubVertex3fSUN)
	#define glReplacementCodeuiColor4ubVertex3fvSUN     MANGLE(ReplacementCodeuiColor4ubVertex3fvSUN)
	#define glReplacementCodeuiNormal3fVertex3fSUN      MANGLE(ReplacementCodeuiNormal3fVertex3fSUN)
	#define glReplacementCodeuiNormal3fVertex3fvSUN     MANGLE(ReplacementCodeuiNormal3fVertex3fvSUN)
	#define glReplacementCodeuiSUN      MANGLE(ReplacementCodeuiSUN)
	#define glReplacementCodeuiTexCoord2fColor4fNormal3fVertex3fSUN     MANGLE(ReplacementCodeuiTexCoord2fColor4fNormal3fVertex3fSUN)
	#define glReplacementCodeuiTexCoord2fColor4fNormal3fVertex3fvSUN        MANGLE(ReplacementCodeuiTexCoord2fColor4fNormal3fVertex3fvSUN)
	#define glReplacementCodeuiTexCoord2fNormal3fVertex3fSUN        MANGLE(ReplacementCodeuiTexCoord2fNormal3fVertex3fSUN)
	#define glReplacementCodeuiTexCoord2fNormal3fVertex3fvSUN       MANGLE(ReplacementCodeuiTexCoord2fNormal3fVertex3fvSUN)
	#define glReplacementCodeuiTexCoord2fVertex3fSUN        MANGLE(ReplacementCodeuiTexCoord2fVertex3fSUN)
	#define glReplacementCodeuiTexCoord2fVertex3fvSUN       MANGLE(ReplacementCodeuiTexCoord2fVertex3fvSUN)
	#define glReplacementCodeuiVertex3fSUN      MANGLE(ReplacementCodeuiVertex3fSUN)
	#define glReplacementCodeuiVertex3fvSUN     MANGLE(ReplacementCodeuiVertex3fvSUN)
	#define glReplacementCodeuivSUN     MANGLE(ReplacementCodeuivSUN)
	#define glReplacementCodeusSUN      MANGLE(ReplacementCodeusSUN)
	#define glReplacementCodeusvSUN     MANGLE(ReplacementCodeusvSUN)
	#define glRequestResidentProgramsNV     MANGLE(RequestResidentProgramsNV)
	#define glResetHistogramEXT     MANGLE(ResetHistogramEXT)
	#define glResetHistogram        MANGLE(ResetHistogram)
	#define glResetMinmaxEXT        MANGLE(ResetMinmaxEXT)
	#define glResetMinmax       MANGLE(ResetMinmax)
	#define glResizeBuffersMESA     MANGLE(ResizeBuffersMESA)
	#define glRotated       MANGLE(Rotated)
	#define glRotatef       MANGLE(Rotatef)
	#define glSampleCoverageARB     MANGLE(SampleCoverageARB)
	#define glSampleCoverage        MANGLE(SampleCoverage)
	#define glSampleMapATI      MANGLE(SampleMapATI)
	#define glSampleMaskEXT     MANGLE(SampleMaskEXT)
	#define glSampleMaskSGIS        MANGLE(SampleMaskSGIS)
	#define glSamplePatternEXT      MANGLE(SamplePatternEXT)
	#define glSamplePatternSGIS     MANGLE(SamplePatternSGIS)
	#define glScaled        MANGLE(Scaled)
	#define glScalef        MANGLE(Scalef)
	#define glScissor       MANGLE(Scissor)
	#define glSecondaryColor3bEXT       MANGLE(SecondaryColor3bEXT)
	#define glSecondaryColor3b      MANGLE(SecondaryColor3b)
	#define glSecondaryColor3bvEXT      MANGLE(SecondaryColor3bvEXT)
	#define glSecondaryColor3bv     MANGLE(SecondaryColor3bv)
	#define glSecondaryColor3dEXT       MANGLE(SecondaryColor3dEXT)
	#define glSecondaryColor3d      MANGLE(SecondaryColor3d)
	#define glSecondaryColor3dvEXT      MANGLE(SecondaryColor3dvEXT)
	#define glSecondaryColor3dv     MANGLE(SecondaryColor3dv)
	#define glSecondaryColor3fEXT       MANGLE(SecondaryColor3fEXT)
	#define glSecondaryColor3f      MANGLE(SecondaryColor3f)
	#define glSecondaryColor3fvEXT      MANGLE(SecondaryColor3fvEXT)
	#define glSecondaryColor3fv     MANGLE(SecondaryColor3fv)
	#define glSecondaryColor3hNV        MANGLE(SecondaryColor3hNV)
	#define glSecondaryColor3hvNV       MANGLE(SecondaryColor3hvNV)
	#define glSecondaryColor3iEXT       MANGLE(SecondaryColor3iEXT)
	#define glSecondaryColor3i      MANGLE(SecondaryColor3i)
	#define glSecondaryColor3ivEXT      MANGLE(SecondaryColor3ivEXT)
	#define glSecondaryColor3iv     MANGLE(SecondaryColor3iv)
	#define glSecondaryColor3sEXT       MANGLE(SecondaryColor3sEXT)
	#define glSecondaryColor3s      MANGLE(SecondaryColor3s)
	#define glSecondaryColor3svEXT      MANGLE(SecondaryColor3svEXT)
	#define glSecondaryColor3sv     MANGLE(SecondaryColor3sv)
	#define glSecondaryColor3ubEXT      MANGLE(SecondaryColor3ubEXT)
	#define glSecondaryColor3ub     MANGLE(SecondaryColor3ub)
	#define glSecondaryColor3ubvEXT     MANGLE(SecondaryColor3ubvEXT)
	#define glSecondaryColor3ubv        MANGLE(SecondaryColor3ubv)
	#define glSecondaryColor3uiEXT      MANGLE(SecondaryColor3uiEXT)
	#define glSecondaryColor3ui     MANGLE(SecondaryColor3ui)
	#define glSecondaryColor3uivEXT     MANGLE(SecondaryColor3uivEXT)
	#define glSecondaryColor3uiv        MANGLE(SecondaryColor3uiv)
	#define glSecondaryColor3usEXT      MANGLE(SecondaryColor3usEXT)
	#define glSecondaryColor3us     MANGLE(SecondaryColor3us)
	#define glSecondaryColor3usvEXT     MANGLE(SecondaryColor3usvEXT)
	#define glSecondaryColor3usv        MANGLE(SecondaryColor3usv)
	#define glSecondaryColorPointerEXT      MANGLE(SecondaryColorPointerEXT)
	#define glSecondaryColorPointerListIBM      MANGLE(SecondaryColorPointerListIBM)
	#define glSecondaryColorPointer     MANGLE(SecondaryColorPointer)
	#define glSelectBuffer      MANGLE(SelectBuffer)
	#define glSeparableFilter2DEXT      MANGLE(SeparableFilter2DEXT)
	#define glSeparableFilter2D     MANGLE(SeparableFilter2D)
	#define glSetFenceAPPLE     MANGLE(SetFenceAPPLE)
	#define glSetFenceNV        MANGLE(SetFenceNV)
	#define glSetFragmentShaderConstantATI      MANGLE(SetFragmentShaderConstantATI)
	#define glSetInvariantEXT       MANGLE(SetInvariantEXT)
	#define glSetLocalConstantEXT       MANGLE(SetLocalConstantEXT)
	#define glShadeModel        MANGLE(ShadeModel)
	#define glShaderOp1EXT      MANGLE(ShaderOp1EXT)
	#define glShaderOp2EXT      MANGLE(ShaderOp2EXT)
	#define glShaderOp3EXT      MANGLE(ShaderOp3EXT)
	#define glShaderSourceARB       MANGLE(ShaderSourceARB)
	#define glShaderSource      MANGLE(ShaderSource)
	#define glSharpenTexFuncSGIS        MANGLE(SharpenTexFuncSGIS)
	#define glSpriteParameterfSGIX      MANGLE(SpriteParameterfSGIX)
	#define glSpriteParameterfvSGIX     MANGLE(SpriteParameterfvSGIX)
	#define glSpriteParameteriSGIX      MANGLE(SpriteParameteriSGIX)
	#define glSpriteParameterivSGIX     MANGLE(SpriteParameterivSGIX)
	#define glStartInstrumentsSGIX      MANGLE(StartInstrumentsSGIX)
	#define glStencilClearTagEXT        MANGLE(StencilClearTagEXT)
	#define glStencilFunc       MANGLE(StencilFunc)
	#define glStencilFuncSeparateATI        MANGLE(StencilFuncSeparateATI)
	#define glStencilFuncSeparate       MANGLE(StencilFuncSeparate)
	#define glStencilMask       MANGLE(StencilMask)
	#define glStencilMaskSeparate       MANGLE(StencilMaskSeparate)
	#define glStencilOp     MANGLE(StencilOp)
	#define glStencilOpSeparateATI      MANGLE(StencilOpSeparateATI)
	#define glStencilOpSeparate     MANGLE(StencilOpSeparate)
	#define glStopInstrumentsSGIX       MANGLE(StopInstrumentsSGIX)
	#define glStringMarkerGREMEDY       MANGLE(StringMarkerGREMEDY)
	#define glSwizzleEXT        MANGLE(SwizzleEXT)
	#define glTagSampleBufferSGIX       MANGLE(TagSampleBufferSGIX)
	#define glTangent3bEXT      MANGLE(Tangent3bEXT)
	#define glTangent3bvEXT     MANGLE(Tangent3bvEXT)
	#define glTangent3dEXT      MANGLE(Tangent3dEXT)
	#define glTangent3dvEXT     MANGLE(Tangent3dvEXT)
	#define glTangent3fEXT      MANGLE(Tangent3fEXT)
	#define glTangent3fvEXT     MANGLE(Tangent3fvEXT)
	#define glTangent3iEXT      MANGLE(Tangent3iEXT)
	#define glTangent3ivEXT     MANGLE(Tangent3ivEXT)
	#define glTangent3sEXT      MANGLE(Tangent3sEXT)
	#define glTangent3svEXT     MANGLE(Tangent3svEXT)
	#define glTangentPointerEXT     MANGLE(TangentPointerEXT)
	#define glTbufferMask3DFX       MANGLE(TbufferMask3DFX)
	#define glTestFenceAPPLE        MANGLE(TestFenceAPPLE)
	#define glTestFenceNV       MANGLE(TestFenceNV)
	#define glTestObjectAPPLE       MANGLE(TestObjectAPPLE)
	#define glTexBumpParameterfvATI     MANGLE(TexBumpParameterfvATI)
	#define glTexBumpParameterivATI     MANGLE(TexBumpParameterivATI)
	#define glTexCoord1d        MANGLE(TexCoord1d)
	#define glTexCoord1dv       MANGLE(TexCoord1dv)
	#define glTexCoord1f        MANGLE(TexCoord1f)
	#define glTexCoord1fv       MANGLE(TexCoord1fv)
	#define glTexCoord1hNV      MANGLE(TexCoord1hNV)
	#define glTexCoord1hvNV     MANGLE(TexCoord1hvNV)
	#define glTexCoord1i        MANGLE(TexCoord1i)
	#define glTexCoord1iv       MANGLE(TexCoord1iv)
	#define glTexCoord1s        MANGLE(TexCoord1s)
	#define glTexCoord1sv       MANGLE(TexCoord1sv)
	#define glTexCoord2d        MANGLE(TexCoord2d)
	#define glTexCoord2dv       MANGLE(TexCoord2dv)
	#define glTexCoord2fColor3fVertex3fSUN      MANGLE(TexCoord2fColor3fVertex3fSUN)
	#define glTexCoord2fColor3fVertex3fvSUN     MANGLE(TexCoord2fColor3fVertex3fvSUN)
	#define glTexCoord2fColor4fNormal3fVertex3fSUN      MANGLE(TexCoord2fColor4fNormal3fVertex3fSUN)
	#define glTexCoord2fColor4fNormal3fVertex3fvSUN     MANGLE(TexCoord2fColor4fNormal3fVertex3fvSUN)
	#define glTexCoord2fColor4ubVertex3fSUN     MANGLE(TexCoord2fColor4ubVertex3fSUN)
	#define glTexCoord2fColor4ubVertex3fvSUN        MANGLE(TexCoord2fColor4ubVertex3fvSUN)
	#define glTexCoord2f        MANGLE(TexCoord2f)
	#define glTexCoord2fNormal3fVertex3fSUN     MANGLE(TexCoord2fNormal3fVertex3fSUN)
	#define glTexCoord2fNormal3fVertex3fvSUN        MANGLE(TexCoord2fNormal3fVertex3fvSUN)
	#define glTexCoord2fVertex3fSUN     MANGLE(TexCoord2fVertex3fSUN)
	#define glTexCoord2fVertex3fvSUN        MANGLE(TexCoord2fVertex3fvSUN)
	#define glTexCoord2fv       MANGLE(TexCoord2fv)
	#define glTexCoord2hNV      MANGLE(TexCoord2hNV)
	#define glTexCoord2hvNV     MANGLE(TexCoord2hvNV)
	#define glTexCoord2i        MANGLE(TexCoord2i)
	#define glTexCoord2iv       MANGLE(TexCoord2iv)
	#define glTexCoord2s        MANGLE(TexCoord2s)
	#define glTexCoord2sv       MANGLE(TexCoord2sv)
	#define glTexCoord3d        MANGLE(TexCoord3d)
	#define glTexCoord3dv       MANGLE(TexCoord3dv)
	#define glTexCoord3f        MANGLE(TexCoord3f)
	#define glTexCoord3fv       MANGLE(TexCoord3fv)
	#define glTexCoord3hNV      MANGLE(TexCoord3hNV)
	#define glTexCoord3hvNV     MANGLE(TexCoord3hvNV)
	#define glTexCoord3i        MANGLE(TexCoord3i)
	#define glTexCoord3iv       MANGLE(TexCoord3iv)
	#define glTexCoord3s        MANGLE(TexCoord3s)
	#define glTexCoord3sv       MANGLE(TexCoord3sv)
	#define glTexCoord4d        MANGLE(TexCoord4d)
	#define glTexCoord4dv       MANGLE(TexCoord4dv)
	#define glTexCoord4fColor4fNormal3fVertex4fSUN      MANGLE(TexCoord4fColor4fNormal3fVertex4fSUN)
	#define glTexCoord4fColor4fNormal3fVertex4fvSUN     MANGLE(TexCoord4fColor4fNormal3fVertex4fvSUN)
	#define glTexCoord4f        MANGLE(TexCoord4f)
	#define glTexCoord4fVertex4fSUN     MANGLE(TexCoord4fVertex4fSUN)
	#define glTexCoord4fVertex4fvSUN        MANGLE(TexCoord4fVertex4fvSUN)
	#define glTexCoord4fv       MANGLE(TexCoord4fv)
	#define glTexCoord4hNV      MANGLE(TexCoord4hNV)
	#define glTexCoord4hvNV     MANGLE(TexCoord4hvNV)
	#define glTexCoord4i        MANGLE(TexCoord4i)
	#define glTexCoord4iv       MANGLE(TexCoord4iv)
	#define glTexCoord4s        MANGLE(TexCoord4s)
	#define glTexCoord4sv       MANGLE(TexCoord4sv)
	#define glTexCoordPointerEXT        MANGLE(TexCoordPointerEXT)
	#define glTexCoordPointerListIBM        MANGLE(TexCoordPointerListIBM)
	#define glTexCoordPointer       MANGLE(TexCoordPointer)
	#define glTexCoordPointervINTEL     MANGLE(TexCoordPointervINTEL)
	#define glTexEnvf       MANGLE(TexEnvf)
	#define glTexEnvfv      MANGLE(TexEnvfv)
	#define glTexEnvi       MANGLE(TexEnvi)
	#define glTexEnviv      MANGLE(TexEnviv)
	#define glTexFilterFuncSGIS     MANGLE(TexFilterFuncSGIS)
	#define glTexGend       MANGLE(TexGend)
	#define glTexGendv      MANGLE(TexGendv)
	#define glTexGenf       MANGLE(TexGenf)
	#define glTexGenfv      MANGLE(TexGenfv)
	#define glTexGeni       MANGLE(TexGeni)
	#define glTexGeniv      MANGLE(TexGeniv)
	#define glTexImage1D        MANGLE(TexImage1D)
	#define glTexImage2D        MANGLE(TexImage2D)
	#define glTexImage3DEXT     MANGLE(TexImage3DEXT)
	#define glTexImage3D        MANGLE(TexImage3D)
	#define glTexImage4DSGIS        MANGLE(TexImage4DSGIS)
	#define glTexParameterf     MANGLE(TexParameterf)
	#define glTexParameterfv        MANGLE(TexParameterfv)
	#define glTexParameteri     MANGLE(TexParameteri)
	#define glTexParameteriv        MANGLE(TexParameteriv)
	#define glTexSubImage1DEXT      MANGLE(TexSubImage1DEXT)
	#define glTexSubImage1D     MANGLE(TexSubImage1D)
	#define glTexSubImage2DEXT      MANGLE(TexSubImage2DEXT)
	#define glTexSubImage2D     MANGLE(TexSubImage2D)
	#define glTexSubImage3DEXT      MANGLE(TexSubImage3DEXT)
	#define glTexSubImage3D     MANGLE(TexSubImage3D)
	#define glTexSubImage4DSGIS     MANGLE(TexSubImage4DSGIS)
	#define glTextureColorMaskSGIS      MANGLE(TextureColorMaskSGIS)
	#define glTextureLightEXT       MANGLE(TextureLightEXT)
	#define glTextureMaterialEXT        MANGLE(TextureMaterialEXT)
	#define glTextureNormalEXT      MANGLE(TextureNormalEXT)
	#define glTrackMatrixNV     MANGLE(TrackMatrixNV)
	#define glTranslated        MANGLE(Translated)
	#define glTranslatef        MANGLE(Translatef)
	#define glUniform1fARB      MANGLE(Uniform1fARB)
	#define glUniform1f     MANGLE(Uniform1f)
	#define glUniform1fvARB     MANGLE(Uniform1fvARB)
	#define glUniform1fv        MANGLE(Uniform1fv)
	#define glUniform1iARB      MANGLE(Uniform1iARB)
	#define glUniform1i     MANGLE(Uniform1i)
	#define glUniform1ivARB     MANGLE(Uniform1ivARB)
	#define glUniform1iv        MANGLE(Uniform1iv)
	#define glUniform2fARB      MANGLE(Uniform2fARB)
	#define glUniform2f     MANGLE(Uniform2f)
	#define glUniform2fvARB     MANGLE(Uniform2fvARB)
	#define glUniform2fv        MANGLE(Uniform2fv)
	#define glUniform2iARB      MANGLE(Uniform2iARB)
	#define glUniform2i     MANGLE(Uniform2i)
	#define glUniform2ivARB     MANGLE(Uniform2ivARB)
	#define glUniform2iv        MANGLE(Uniform2iv)
	#define glUniform3fARB      MANGLE(Uniform3fARB)
	#define glUniform3f     MANGLE(Uniform3f)
	#define glUniform3fvARB     MANGLE(Uniform3fvARB)
	#define glUniform3fv        MANGLE(Uniform3fv)
	#define glUniform3iARB      MANGLE(Uniform3iARB)
	#define glUniform3i     MANGLE(Uniform3i)
	#define glUniform3ivARB     MANGLE(Uniform3ivARB)
	#define glUniform3iv        MANGLE(Uniform3iv)
	#define glUniform4fARB      MANGLE(Uniform4fARB)
	#define glUniform4f     MANGLE(Uniform4f)
	#define glUniform4fvARB     MANGLE(Uniform4fvARB)
	#define glUniform4fv        MANGLE(Uniform4fv)
	#define glUniform4iARB      MANGLE(Uniform4iARB)
	#define glUniform4i     MANGLE(Uniform4i)
	#define glUniform4ivARB     MANGLE(Uniform4ivARB)
	#define glUniform4iv        MANGLE(Uniform4iv)
	#define glUniformMatrix2fvARB       MANGLE(UniformMatrix2fvARB)
	#define glUniformMatrix2fv      MANGLE(UniformMatrix2fv)
	#define glUniformMatrix2x3fv        MANGLE(UniformMatrix2x3fv)
	#define glUniformMatrix2x4fv        MANGLE(UniformMatrix2x4fv)
	#define glUniformMatrix3fvARB       MANGLE(UniformMatrix3fvARB)
	#define glUniformMatrix3fv      MANGLE(UniformMatrix3fv)
	#define glUniformMatrix3x2fv        MANGLE(UniformMatrix3x2fv)
	#define glUniformMatrix3x4fv        MANGLE(UniformMatrix3x4fv)
	#define glUniformMatrix4fvARB       MANGLE(UniformMatrix4fvARB)
	#define glUniformMatrix4fv      MANGLE(UniformMatrix4fv)
	#define glUniformMatrix4x2fv        MANGLE(UniformMatrix4x2fv)
	#define glUniformMatrix4x3fv        MANGLE(UniformMatrix4x3fv)
	#define glUnlockArraysEXT       MANGLE(UnlockArraysEXT)
	#define glUnmapBufferARB        MANGLE(UnmapBufferARB)
	#define glUnmapBuffer       MANGLE(UnmapBuffer)
	#define glUnmapObjectBufferATI      MANGLE(UnmapObjectBufferATI)
	#define glUpdateObjectBufferATI     MANGLE(UpdateObjectBufferATI)
	#define glUseProgram        MANGLE(UseProgram)
	#define glUseProgramObjectARB       MANGLE(UseProgramObjectARB)
	#define glValidateProgramARB        MANGLE(ValidateProgramARB)
	#define glValidateProgram       MANGLE(ValidateProgram)
	#define glVariantArrayObjectATI     MANGLE(VariantArrayObjectATI)
	#define glVariantbvEXT      MANGLE(VariantbvEXT)
	#define glVariantdvEXT      MANGLE(VariantdvEXT)
	#define glVariantfvEXT      MANGLE(VariantfvEXT)
	#define glVariantivEXT      MANGLE(VariantivEXT)
	#define glVariantPointerEXT     MANGLE(VariantPointerEXT)
	#define glVariantsvEXT      MANGLE(VariantsvEXT)
	#define glVariantubvEXT     MANGLE(VariantubvEXT)
	#define glVariantuivEXT     MANGLE(VariantuivEXT)
	#define glVariantusvEXT     MANGLE(VariantusvEXT)
	#define glVertex2d      MANGLE(Vertex2d)
	#define glVertex2dv     MANGLE(Vertex2dv)
	#define glVertex2f      MANGLE(Vertex2f)
	#define glVertex2fv     MANGLE(Vertex2fv)
	#define glVertex2hNV        MANGLE(Vertex2hNV)
	#define glVertex2hvNV       MANGLE(Vertex2hvNV)
	#define glVertex2i      MANGLE(Vertex2i)
	#define glVertex2iv     MANGLE(Vertex2iv)
	#define glVertex2s      MANGLE(Vertex2s)
	#define glVertex2sv     MANGLE(Vertex2sv)
	#define glVertex3d      MANGLE(Vertex3d)
	#define glVertex3dv     MANGLE(Vertex3dv)
	#define glVertex3f      MANGLE(Vertex3f)
	#define glVertex3fv     MANGLE(Vertex3fv)
	#define glVertex3hNV        MANGLE(Vertex3hNV)
	#define glVertex3hvNV       MANGLE(Vertex3hvNV)
	#define glVertex3i      MANGLE(Vertex3i)
	#define glVertex3iv     MANGLE(Vertex3iv)
	#define glVertex3s      MANGLE(Vertex3s)
	#define glVertex3sv     MANGLE(Vertex3sv)
	#define glVertex4d      MANGLE(Vertex4d)
	#define glVertex4dv     MANGLE(Vertex4dv)
	#define glVertex4f      MANGLE(Vertex4f)
	#define glVertex4fv     MANGLE(Vertex4fv)
	#define glVertex4hNV        MANGLE(Vertex4hNV)
	#define glVertex4hvNV       MANGLE(Vertex4hvNV)
	#define glVertex4i      MANGLE(Vertex4i)
	#define glVertex4iv     MANGLE(Vertex4iv)
	#define glVertex4s      MANGLE(Vertex4s)
	#define glVertex4sv     MANGLE(Vertex4sv)
	#define glVertexArrayParameteriAPPLE        MANGLE(VertexArrayParameteriAPPLE)
	#define glVertexArrayRangeAPPLE     MANGLE(VertexArrayRangeAPPLE)
	#define glVertexArrayRangeNV        MANGLE(VertexArrayRangeNV)
	#define glVertexAttrib1dARB     MANGLE(VertexAttrib1dARB)
	#define glVertexAttrib1d        MANGLE(VertexAttrib1d)
	#define glVertexAttrib1dNV      MANGLE(VertexAttrib1dNV)
	#define glVertexAttrib1dvARB        MANGLE(VertexAttrib1dvARB)
	#define glVertexAttrib1dv       MANGLE(VertexAttrib1dv)
	#define glVertexAttrib1dvNV     MANGLE(VertexAttrib1dvNV)
	#define glVertexAttrib1fARB     MANGLE(VertexAttrib1fARB)
	#define glVertexAttrib1f        MANGLE(VertexAttrib1f)
	#define glVertexAttrib1fNV      MANGLE(VertexAttrib1fNV)
	#define glVertexAttrib1fvARB        MANGLE(VertexAttrib1fvARB)
	#define glVertexAttrib1fv       MANGLE(VertexAttrib1fv)
	#define glVertexAttrib1fvNV     MANGLE(VertexAttrib1fvNV)
	#define glVertexAttrib1hNV      MANGLE(VertexAttrib1hNV)
	#define glVertexAttrib1hvNV     MANGLE(VertexAttrib1hvNV)
	#define glVertexAttrib1sARB     MANGLE(VertexAttrib1sARB)
	#define glVertexAttrib1s        MANGLE(VertexAttrib1s)
	#define glVertexAttrib1sNV      MANGLE(VertexAttrib1sNV)
	#define glVertexAttrib1svARB        MANGLE(VertexAttrib1svARB)
	#define glVertexAttrib1sv       MANGLE(VertexAttrib1sv)
	#define glVertexAttrib1svNV     MANGLE(VertexAttrib1svNV)
	#define glVertexAttrib2dARB     MANGLE(VertexAttrib2dARB)
	#define glVertexAttrib2d        MANGLE(VertexAttrib2d)
	#define glVertexAttrib2dNV      MANGLE(VertexAttrib2dNV)
	#define glVertexAttrib2dvARB        MANGLE(VertexAttrib2dvARB)
	#define glVertexAttrib2dv       MANGLE(VertexAttrib2dv)
	#define glVertexAttrib2dvNV     MANGLE(VertexAttrib2dvNV)
	#define glVertexAttrib2fARB     MANGLE(VertexAttrib2fARB)
	#define glVertexAttrib2f        MANGLE(VertexAttrib2f)
	#define glVertexAttrib2fNV      MANGLE(VertexAttrib2fNV)
	#define glVertexAttrib2fvARB        MANGLE(VertexAttrib2fvARB)
	#define glVertexAttrib2fv       MANGLE(VertexAttrib2fv)
	#define glVertexAttrib2fvNV     MANGLE(VertexAttrib2fvNV)
	#define glVertexAttrib2hNV      MANGLE(VertexAttrib2hNV)
	#define glVertexAttrib2hvNV     MANGLE(VertexAttrib2hvNV)
	#define glVertexAttrib2sARB     MANGLE(VertexAttrib2sARB)
	#define glVertexAttrib2s        MANGLE(VertexAttrib2s)
	#define glVertexAttrib2sNV      MANGLE(VertexAttrib2sNV)
	#define glVertexAttrib2svARB        MANGLE(VertexAttrib2svARB)
	#define glVertexAttrib2sv       MANGLE(VertexAttrib2sv)
	#define glVertexAttrib2svNV     MANGLE(VertexAttrib2svNV)
	#define glVertexAttrib3dARB     MANGLE(VertexAttrib3dARB)
	#define glVertexAttrib3d        MANGLE(VertexAttrib3d)
	#define glVertexAttrib3dNV      MANGLE(VertexAttrib3dNV)
	#define glVertexAttrib3dvARB        MANGLE(VertexAttrib3dvARB)
	#define glVertexAttrib3dv       MANGLE(VertexAttrib3dv)
	#define glVertexAttrib3dvNV     MANGLE(VertexAttrib3dvNV)
	#define glVertexAttrib3fARB     MANGLE(VertexAttrib3fARB)
	#define glVertexAttrib3f        MANGLE(VertexAttrib3f)
	#define glVertexAttrib3fNV      MANGLE(VertexAttrib3fNV)
	#define glVertexAttrib3fvARB        MANGLE(VertexAttrib3fvARB)
	#define glVertexAttrib3fv       MANGLE(VertexAttrib3fv)
	#define glVertexAttrib3fvNV     MANGLE(VertexAttrib3fvNV)
	#define glVertexAttrib3hNV      MANGLE(VertexAttrib3hNV)
	#define glVertexAttrib3hvNV     MANGLE(VertexAttrib3hvNV)
	#define glVertexAttrib3sARB     MANGLE(VertexAttrib3sARB)
	#define glVertexAttrib3s        MANGLE(VertexAttrib3s)
	#define glVertexAttrib3sNV      MANGLE(VertexAttrib3sNV)
	#define glVertexAttrib3svARB        MANGLE(VertexAttrib3svARB)
	#define glVertexAttrib3sv       MANGLE(VertexAttrib3sv)
	#define glVertexAttrib3svNV     MANGLE(VertexAttrib3svNV)
	#define glVertexAttrib4bvARB        MANGLE(VertexAttrib4bvARB)
	#define glVertexAttrib4bv       MANGLE(VertexAttrib4bv)
	#define glVertexAttrib4dARB     MANGLE(VertexAttrib4dARB)
	#define glVertexAttrib4d        MANGLE(VertexAttrib4d)
	#define glVertexAttrib4dNV      MANGLE(VertexAttrib4dNV)
	#define glVertexAttrib4dvARB        MANGLE(VertexAttrib4dvARB)
	#define glVertexAttrib4dv       MANGLE(VertexAttrib4dv)
	#define glVertexAttrib4dvNV     MANGLE(VertexAttrib4dvNV)
	#define glVertexAttrib4fARB     MANGLE(VertexAttrib4fARB)
	#define glVertexAttrib4f        MANGLE(VertexAttrib4f)
	#define glVertexAttrib4fNV      MANGLE(VertexAttrib4fNV)
	#define glVertexAttrib4fvARB        MANGLE(VertexAttrib4fvARB)
	#define glVertexAttrib4fv       MANGLE(VertexAttrib4fv)
	#define glVertexAttrib4fvNV     MANGLE(VertexAttrib4fvNV)
	#define glVertexAttrib4hNV      MANGLE(VertexAttrib4hNV)
	#define glVertexAttrib4hvNV     MANGLE(VertexAttrib4hvNV)
	#define glVertexAttrib4ivARB        MANGLE(VertexAttrib4ivARB)
	#define glVertexAttrib4iv       MANGLE(VertexAttrib4iv)
	#define glVertexAttrib4NbvARB       MANGLE(VertexAttrib4NbvARB)
	#define glVertexAttrib4Nbv      MANGLE(VertexAttrib4Nbv)
	#define glVertexAttrib4NivARB       MANGLE(VertexAttrib4NivARB)
	#define glVertexAttrib4Niv      MANGLE(VertexAttrib4Niv)
	#define glVertexAttrib4NsvARB       MANGLE(VertexAttrib4NsvARB)
	#define glVertexAttrib4Nsv      MANGLE(VertexAttrib4Nsv)
	#define glVertexAttrib4NubARB       MANGLE(VertexAttrib4NubARB)
	#define glVertexAttrib4Nub      MANGLE(VertexAttrib4Nub)
	#define glVertexAttrib4NubvARB      MANGLE(VertexAttrib4NubvARB)
	#define glVertexAttrib4Nubv     MANGLE(VertexAttrib4Nubv)
	#define glVertexAttrib4NuivARB      MANGLE(VertexAttrib4NuivARB)
	#define glVertexAttrib4Nuiv     MANGLE(VertexAttrib4Nuiv)
	#define glVertexAttrib4NusvARB      MANGLE(VertexAttrib4NusvARB)
	#define glVertexAttrib4Nusv     MANGLE(VertexAttrib4Nusv)
	#define glVertexAttrib4sARB     MANGLE(VertexAttrib4sARB)
	#define glVertexAttrib4s        MANGLE(VertexAttrib4s)
	#define glVertexAttrib4sNV      MANGLE(VertexAttrib4sNV)
	#define glVertexAttrib4svARB        MANGLE(VertexAttrib4svARB)
	#define glVertexAttrib4sv       MANGLE(VertexAttrib4sv)
	#define glVertexAttrib4svNV     MANGLE(VertexAttrib4svNV)
	#define glVertexAttrib4ubNV     MANGLE(VertexAttrib4ubNV)
	#define glVertexAttrib4ubvARB       MANGLE(VertexAttrib4ubvARB)
	#define glVertexAttrib4ubv      MANGLE(VertexAttrib4ubv)
	#define glVertexAttrib4ubvNV        MANGLE(VertexAttrib4ubvNV)
	#define glVertexAttrib4uivARB       MANGLE(VertexAttrib4uivARB)
	#define glVertexAttrib4uiv      MANGLE(VertexAttrib4uiv)
	#define glVertexAttrib4usvARB       MANGLE(VertexAttrib4usvARB)
	#define glVertexAttrib4usv      MANGLE(VertexAttrib4usv)
	#define glVertexAttribArrayObjectATI        MANGLE(VertexAttribArrayObjectATI)
	#define glVertexAttribPointerARB        MANGLE(VertexAttribPointerARB)
	#define glVertexAttribPointer       MANGLE(VertexAttribPointer)
	#define glVertexAttribPointerNV     MANGLE(VertexAttribPointerNV)
	#define glVertexAttribs1dvNV        MANGLE(VertexAttribs1dvNV)
	#define glVertexAttribs1fvNV        MANGLE(VertexAttribs1fvNV)
	#define glVertexAttribs1hvNV        MANGLE(VertexAttribs1hvNV)
	#define glVertexAttribs1svNV        MANGLE(VertexAttribs1svNV)
	#define glVertexAttribs2dvNV        MANGLE(VertexAttribs2dvNV)
	#define glVertexAttribs2fvNV        MANGLE(VertexAttribs2fvNV)
	#define glVertexAttribs2hvNV        MANGLE(VertexAttribs2hvNV)
	#define glVertexAttribs2svNV        MANGLE(VertexAttribs2svNV)
	#define glVertexAttribs3dvNV        MANGLE(VertexAttribs3dvNV)
	#define glVertexAttribs3fvNV        MANGLE(VertexAttribs3fvNV)
	#define glVertexAttribs3hvNV        MANGLE(VertexAttribs3hvNV)
	#define glVertexAttribs3svNV        MANGLE(VertexAttribs3svNV)
	#define glVertexAttribs4dvNV        MANGLE(VertexAttribs4dvNV)
	#define glVertexAttribs4fvNV        MANGLE(VertexAttribs4fvNV)
	#define glVertexAttribs4hvNV        MANGLE(VertexAttribs4hvNV)
	#define glVertexAttribs4svNV        MANGLE(VertexAttribs4svNV)
	#define glVertexAttribs4ubvNV       MANGLE(VertexAttribs4ubvNV)
	#define glVertexBlendARB        MANGLE(VertexBlendARB)
	#define glVertexBlendEnvfATI        MANGLE(VertexBlendEnvfATI)
	#define glVertexBlendEnviATI        MANGLE(VertexBlendEnviATI)
	#define glVertexPointerEXT      MANGLE(VertexPointerEXT)
	#define glVertexPointerListIBM      MANGLE(VertexPointerListIBM)
	#define glVertexPointer     MANGLE(VertexPointer)
	#define glVertexPointervINTEL       MANGLE(VertexPointervINTEL)
	#define glVertexStream1dATI     MANGLE(VertexStream1dATI)
	#define glVertexStream1dvATI        MANGLE(VertexStream1dvATI)
	#define glVertexStream1fATI     MANGLE(VertexStream1fATI)
	#define glVertexStream1fvATI        MANGLE(VertexStream1fvATI)
	#define glVertexStream1iATI     MANGLE(VertexStream1iATI)
	#define glVertexStream1ivATI        MANGLE(VertexStream1ivATI)
	#define glVertexStream1sATI     MANGLE(VertexStream1sATI)
	#define glVertexStream1svATI        MANGLE(VertexStream1svATI)
	#define glVertexStream2dATI     MANGLE(VertexStream2dATI)
	#define glVertexStream2dvATI        MANGLE(VertexStream2dvATI)
	#define glVertexStream2fATI     MANGLE(VertexStream2fATI)
	#define glVertexStream2fvATI        MANGLE(VertexStream2fvATI)
	#define glVertexStream2iATI     MANGLE(VertexStream2iATI)
	#define glVertexStream2ivATI        MANGLE(VertexStream2ivATI)
	#define glVertexStream2sATI     MANGLE(VertexStream2sATI)
	#define glVertexStream2svATI        MANGLE(VertexStream2svATI)
	#define glVertexStream3dATI     MANGLE(VertexStream3dATI)
	#define glVertexStream3dvATI        MANGLE(VertexStream3dvATI)
	#define glVertexStream3fATI     MANGLE(VertexStream3fATI)
	#define glVertexStream3fvATI        MANGLE(VertexStream3fvATI)
	#define glVertexStream3iATI     MANGLE(VertexStream3iATI)
	#define glVertexStream3ivATI        MANGLE(VertexStream3ivATI)
	#define glVertexStream3sATI     MANGLE(VertexStream3sATI)
	#define glVertexStream3svATI        MANGLE(VertexStream3svATI)
	#define glVertexStream4dATI     MANGLE(VertexStream4dATI)
	#define glVertexStream4dvATI        MANGLE(VertexStream4dvATI)
	#define glVertexStream4fATI     MANGLE(VertexStream4fATI)
	#define glVertexStream4fvATI        MANGLE(VertexStream4fvATI)
	#define glVertexStream4iATI     MANGLE(VertexStream4iATI)
	#define glVertexStream4ivATI        MANGLE(VertexStream4ivATI)
	#define glVertexStream4sATI     MANGLE(VertexStream4sATI)
	#define glVertexStream4svATI        MANGLE(VertexStream4svATI)
	#define glVertexWeightfEXT      MANGLE(VertexWeightfEXT)
	#define glVertexWeightfvEXT     MANGLE(VertexWeightfvEXT)
	#define glVertexWeighthNV       MANGLE(VertexWeighthNV)
	#define glVertexWeighthvNV      MANGLE(VertexWeighthvNV)
	#define glVertexWeightPointerEXT        MANGLE(VertexWeightPointerEXT)
	#define glViewport      MANGLE(Viewport)
	#define glWeightbvARB       MANGLE(WeightbvARB)
	#define glWeightdvARB       MANGLE(WeightdvARB)
	#define glWeightfvARB       MANGLE(WeightfvARB)
	#define glWeightivARB       MANGLE(WeightivARB)
	#define glWeightPointerARB      MANGLE(WeightPointerARB)
	#define glWeightsvARB       MANGLE(WeightsvARB)
	#define glWeightubvARB      MANGLE(WeightubvARB)
	#define glWeightuivARB      MANGLE(WeightuivARB)
	#define glWeightusvARB      MANGLE(WeightusvARB)
	#define glWindowPos2dARB        MANGLE(WindowPos2dARB)
	#define glWindowPos2d       MANGLE(WindowPos2d)
	#define glWindowPos2dMESA       MANGLE(WindowPos2dMESA)
	#define glWindowPos2dvARB       MANGLE(WindowPos2dvARB)
	#define glWindowPos2dv      MANGLE(WindowPos2dv)
	#define glWindowPos2dvMESA      MANGLE(WindowPos2dvMESA)
	#define glWindowPos2fARB        MANGLE(WindowPos2fARB)
	#define glWindowPos2f       MANGLE(WindowPos2f)
	#define glWindowPos2fMESA       MANGLE(WindowPos2fMESA)
	#define glWindowPos2fvARB       MANGLE(WindowPos2fvARB)
	#define glWindowPos2fv      MANGLE(WindowPos2fv)
	#define glWindowPos2fvMESA      MANGLE(WindowPos2fvMESA)
	#define glWindowPos2iARB        MANGLE(WindowPos2iARB)
	#define glWindowPos2i       MANGLE(WindowPos2i)
	#define glWindowPos2iMESA       MANGLE(WindowPos2iMESA)
	#define glWindowPos2ivARB       MANGLE(WindowPos2ivARB)
	#define glWindowPos2iv      MANGLE(WindowPos2iv)
	#define glWindowPos2ivMESA      MANGLE(WindowPos2ivMESA)
	#define glWindowPos2sARB        MANGLE(WindowPos2sARB)
	#define glWindowPos2s       MANGLE(WindowPos2s)
	#define glWindowPos2sMESA       MANGLE(WindowPos2sMESA)
	#define glWindowPos2svARB       MANGLE(WindowPos2svARB)
	#define glWindowPos2sv      MANGLE(WindowPos2sv)
	#define glWindowPos2svMESA      MANGLE(WindowPos2svMESA)
	#define glWindowPos3dARB        MANGLE(WindowPos3dARB)
	#define glWindowPos3d       MANGLE(WindowPos3d)
	#define glWindowPos3dMESA       MANGLE(WindowPos3dMESA)
	#define glWindowPos3dvARB       MANGLE(WindowPos3dvARB)
	#define glWindowPos3dv      MANGLE(WindowPos3dv)
	#define glWindowPos3dvMESA      MANGLE(WindowPos3dvMESA)
	#define glWindowPos3fARB        MANGLE(WindowPos3fARB)
	#define glWindowPos3f       MANGLE(WindowPos3f)
	#define glWindowPos3fMESA       MANGLE(WindowPos3fMESA)
	#define glWindowPos3fvARB       MANGLE(WindowPos3fvARB)
	#define glWindowPos3fv      MANGLE(WindowPos3fv)
	#define glWindowPos3fvMESA      MANGLE(WindowPos3fvMESA)
	#define glWindowPos3iARB        MANGLE(WindowPos3iARB)
	#define glWindowPos3i       MANGLE(WindowPos3i)
	#define glWindowPos3iMESA       MANGLE(WindowPos3iMESA)
	#define glWindowPos3ivARB       MANGLE(WindowPos3ivARB)
	#define glWindowPos3iv      MANGLE(WindowPos3iv)
	#define glWindowPos3ivMESA      MANGLE(WindowPos3ivMESA)
	#define glWindowPos3sARB        MANGLE(WindowPos3sARB)
	#define glWindowPos3s       MANGLE(WindowPos3s)
	#define glWindowPos3sMESA       MANGLE(WindowPos3sMESA)
	#define glWindowPos3svARB       MANGLE(WindowPos3svARB)
	#define glWindowPos3sv      MANGLE(WindowPos3sv)
	#define glWindowPos3svMESA      MANGLE(WindowPos3svMESA)
	#define glWindowPos4dMESA       MANGLE(WindowPos4dMESA)
	#define glWindowPos4dvMESA      MANGLE(WindowPos4dvMESA)
	#define glWindowPos4fMESA       MANGLE(WindowPos4fMESA)
	#define glWindowPos4fvMESA      MANGLE(WindowPos4fvMESA)
	#define glWindowPos4iMESA       MANGLE(WindowPos4iMESA)
	#define glWindowPos4ivMESA      MANGLE(WindowPos4ivMESA)
	#define glWindowPos4sMESA       MANGLE(WindowPos4sMESA)
	#define glWindowPos4svMESA      MANGLE(WindowPos4svMESA)
	#define glWriteMaskEXT      MANGLE(WriteMaskEXT)

#endif /* MANGLE */
#else /* GET_GLFUNC */
	/***************************************************************
	 *
	 * Used recursively for prototyping and function assignment
	 *
	 * Credits: taken from sdl_glfuncs.h
	 *
	 ***************************************************************/

	OSD_GL_UNUSED(void,glAccum,(GLenum,GLfloat))
	OSD_GL_UNUSED(void,glAlphaFunc,(GLenum,GLclampf))
	OSD_GL_UNUSED(GLboolean,glAreTexturesResident,(GLsizei,const GLuint*,GLboolean*))
	OSD_GL_UNUSED(void,glArrayElement,(GLint))
	OSD_GL(void,glBegin,(GLenum))
	OSD_GL(void,glBindTexture,(GLenum,GLuint))
	OSD_GL_UNUSED(void,glBitmap,(GLsizei,GLsizei,GLfloat,GLfloat,GLfloat,GLfloat,const GLubyte*))
	OSD_GL(void,glBlendFunc,(GLenum,GLenum))
	OSD_GL_UNUSED(void,glCallList,(GLuint))
	OSD_GL_UNUSED(void,glCallLists,(GLsizei,GLenum,const GLvoid*))
	OSD_GL(void,glClear,(GLbitfield))
	OSD_GL_UNUSED(void,glClearAccum,(GLfloat,GLfloat,GLfloat,GLfloat))
	OSD_GL(void,glClearColor,(GLclampf,GLclampf,GLclampf,GLclampf))
	OSD_GL(void,glClearDepth,(GLclampd))
	OSD_GL_UNUSED(void,glClearIndex,(GLfloat))
	OSD_GL_UNUSED(void,glClearStencil,(GLint))
	OSD_GL_UNUSED(void,glClipPlane,(GLenum,const GLdouble*))
	OSD_GL_UNUSED(void,glColor3b,(GLbyte,GLbyte,GLbyte))
	OSD_GL_UNUSED(void,glColor3bv,(const GLbyte*))
	OSD_GL_UNUSED(void,glColor3d,(GLdouble,GLdouble,GLdouble))
	OSD_GL_UNUSED(void,glColor3dv,(const GLdouble*))
	OSD_GL_UNUSED(void,glColor3f,(GLfloat,GLfloat,GLfloat))
	OSD_GL_UNUSED(void,glColor3fv,(const GLfloat*))
	OSD_GL_UNUSED(void,glColor3i,(GLint,GLint,GLint))
	OSD_GL_UNUSED(void,glColor3iv,(const GLint*))
	OSD_GL_UNUSED(void,glColor3s,(GLshort,GLshort,GLshort))
	OSD_GL_UNUSED(void,glColor3sv,(const GLshort*))
	OSD_GL_UNUSED(void,glColor3ub,(GLubyte,GLubyte,GLubyte))
	OSD_GL_UNUSED(void,glColor3ubv,(const GLubyte*))
	OSD_GL_UNUSED(void,glColor3ui,(GLuint,GLuint,GLuint))
	OSD_GL_UNUSED(void,glColor3uiv,(const GLuint*))
	OSD_GL_UNUSED(void,glColor3us,(GLushort,GLushort,GLushort))
	OSD_GL_UNUSED(void,glColor3usv,(const GLushort*))
	OSD_GL_UNUSED(void,glColor4b,(GLbyte,GLbyte,GLbyte,GLbyte))
	OSD_GL_UNUSED(void,glColor4bv,(const GLbyte*))
	OSD_GL_UNUSED(void,glColor4d,(GLdouble,GLdouble,GLdouble,GLdouble))
	OSD_GL_UNUSED(void,glColor4dv,(const GLdouble*))
	OSD_GL(void,glColor4f,(GLfloat,GLfloat,GLfloat,GLfloat))
	OSD_GL_UNUSED(void,glColor4fv,(const GLfloat*))
	OSD_GL_UNUSED(void,glColor4i,(GLint,GLint,GLint,GLint))
	OSD_GL_UNUSED(void,glColor4iv,(const GLint*))
	OSD_GL_UNUSED(void,glColor4s,(GLshort,GLshort,GLshort,GLshort))
	OSD_GL_UNUSED(void,glColor4sv,(const GLshort*))
	OSD_GL_UNUSED(void,glColor4ub,(GLubyte red, GLubyte green, GLubyte blue, GLubyte alpha))
	OSD_GL_UNUSED(void,glColor4ubv,(const GLubyte *v))
	OSD_GL_UNUSED(void,glColor4ui,(GLuint red, GLuint green, GLuint blue, GLuint alpha))
	OSD_GL_UNUSED(void,glColor4uiv,(const GLuint *v))
	OSD_GL_UNUSED(void,glColor4us,(GLushort red, GLushort green, GLushort blue, GLushort alpha))
	OSD_GL_UNUSED(void,glColor4usv,(const GLushort *v))
	OSD_GL_UNUSED(void,glColorMask,(GLboolean red, GLboolean green, GLboolean blue, GLboolean alpha))
	OSD_GL_UNUSED(void,glColorMaterial,(GLenum face, GLenum mode))
	OSD_GL_UNUSED(void,glColorPointer,(GLint size, GLenum type, GLsizei stride, const GLvoid *pointer))
	OSD_GL_UNUSED(void,glCopyPixels,(GLint x, GLint y, GLsizei width, GLsizei height, GLenum type))
	OSD_GL_UNUSED(void,glCopyTexImage1D,(GLenum target, GLint level, GLenum internalFormat, GLint x, GLint y, GLsizei width, GLint border))
	OSD_GL_UNUSED(void,glCopyTexImage2D,(GLenum target, GLint level, GLenum internalFormat, GLint x, GLint y, GLsizei width, GLsizei height, GLint border))
	OSD_GL_UNUSED(void,glCopyTexSubImage1D,(GLenum target, GLint level, GLint xoffset, GLint x, GLint y, GLsizei width))
	OSD_GL_UNUSED(void,glCopyTexSubImage2D,(GLenum target, GLint level, GLint xoffset, GLint yoffset, GLint x, GLint y, GLsizei width, GLsizei height))
	OSD_GL_UNUSED(void,glCullFace,(GLenum mode))
	OSD_GL_UNUSED(void,glDeleteLists,(GLuint list, GLsizei range))
	OSD_GL(void,glDeleteTextures,(GLsizei n, const GLuint *textures))
	OSD_GL(void,glDepthFunc,(GLenum func))
	OSD_GL_UNUSED(void,glDepthMask,(GLboolean flag))
	OSD_GL_UNUSED(void,glDepthRange,(GLclampd zNear, GLclampd zFar))
	OSD_GL(void,glDisable,(GLenum cap))
	OSD_GL(void,glDisableClientState,(GLenum array))
	OSD_GL(void,glDrawArrays,(GLenum mode, GLint first, GLsizei count))
	OSD_GL_UNUSED(void,glDrawBuffer,(GLenum mode))
	OSD_GL_UNUSED(void,glDrawElements,(GLenum mode, GLsizei count, GLenum type, const GLvoid *indices))
	OSD_GL_UNUSED(void,glDrawPixels,(GLsizei width, GLsizei height, GLenum format, GLenum type, const GLvoid *pixels))
	OSD_GL_UNUSED(void,glEdgeFlag,(GLboolean flag))
	OSD_GL_UNUSED(void,glEdgeFlagPointer,(GLsizei stride, const GLvoid *pointer))
	OSD_GL_UNUSED(void,glEdgeFlagv,(const GLboolean *flag))
	OSD_GL(void,glEnable,(GLenum cap))
	OSD_GL(void,glEnableClientState,(GLenum array))
	OSD_GL(void,glEnd,(void))
	OSD_GL_UNUSED(void,glEndList,(void))
	OSD_GL_UNUSED(void,glEvalCoord1d,(GLdouble u))
	OSD_GL_UNUSED(void,glEvalCoord1dv,(const GLdouble *u))
	OSD_GL_UNUSED(void,glEvalCoord1f,(GLfloat u))
	OSD_GL_UNUSED(void,glEvalCoord1fv,(const GLfloat *u))
	OSD_GL_UNUSED(void,glEvalCoord2d,(GLdouble u, GLdouble v))
	OSD_GL_UNUSED(void,glEvalCoord2dv,(const GLdouble *u))
	OSD_GL_UNUSED(void,glEvalCoord2f,(GLfloat u, GLfloat v))
	OSD_GL_UNUSED(void,glEvalCoord2fv,(const GLfloat *u))
	OSD_GL_UNUSED(void,glEvalMesh1,(GLenum mode, GLint i1, GLint i2))
	OSD_GL_UNUSED(void,glEvalMesh2,(GLenum mode, GLint i1, GLint i2, GLint j1, GLint j2))
	OSD_GL_UNUSED(void,glEvalPoint1,(GLint i))
	OSD_GL_UNUSED(void,glEvalPoint2,(GLint i, GLint j))
	OSD_GL_UNUSED(void,glFeedbackBuffer,(GLsizei size, GLenum type, GLfloat *buffer))
	OSD_GL(void,glFinish,(void))
	OSD_GL(void,glFlush,(void))
	OSD_GL_UNUSED(void,glFogf,(GLenum pname, GLfloat param))
	OSD_GL_UNUSED(void,glFogfv,(GLenum pname, const GLfloat *params))
	OSD_GL_UNUSED(void,glFogi,(GLenum pname, GLint param))
	OSD_GL_UNUSED(void,glFogiv,(GLenum pname, const GLint *params))
	OSD_GL_UNUSED(void,glFrontFace,(GLenum mode))
	OSD_GL_UNUSED(void,glFrustum,(GLdouble left, GLdouble right, GLdouble bottom, GLdouble top, GLdouble zNear, GLdouble zFar))
	OSD_GL_UNUSED(GLuint,glGenLists,(GLsizei range))
	OSD_GL(void,glGenTextures,(GLsizei n, GLuint *textures))
	OSD_GL_UNUSED(void,glGetBooleanv,(GLenum pname, GLboolean *params))
	OSD_GL_UNUSED(void,glGetClipPlane,(GLenum plane, GLdouble *equation))
	OSD_GL_UNUSED(void,glGetDoublev,(GLenum pname, GLdouble *params))
	OSD_GL(GLenum,glGetError,(void))
	OSD_GL_UNUSED(void,glGetFloatv,(GLenum pname, GLfloat *params))
	OSD_GL(void,glGetIntegerv,(GLenum pname, GLint *params))
	OSD_GL_UNUSED(void,glGetLightfv,(GLenum light, GLenum pname, GLfloat *params))
	OSD_GL_UNUSED(void,glGetLightiv,(GLenum light, GLenum pname, GLint *params))
	OSD_GL_UNUSED(void,glGetMapdv,(GLenum target, GLenum query, GLdouble *v))
	OSD_GL_UNUSED(void,glGetMapfv,(GLenum target, GLenum query, GLfloat *v))
	OSD_GL_UNUSED(void,glGetMapiv,(GLenum target, GLenum query, GLint *v))
	OSD_GL_UNUSED(void,glGetMaterialfv,(GLenum face, GLenum pname, GLfloat *params))
	OSD_GL_UNUSED(void,glGetMaterialiv,(GLenum face, GLenum pname, GLint *params))
	OSD_GL_UNUSED(void,glGetPixelMapfv,(GLenum map, GLfloat *values))
	OSD_GL_UNUSED(void,glGetPixelMapuiv,(GLenum map, GLuint *values))
	OSD_GL_UNUSED(void,glGetPixelMapusv,(GLenum map, GLushort *values))
	OSD_GL_UNUSED(void,glGetPointerv,(GLenum pname, GLvoid* *params))
	OSD_GL_UNUSED(void,glGetPolygonStipple,(GLubyte *mask))
	OSD_GL(const GLubyte *,glGetString,(GLenum name))
	OSD_GL_UNUSED(void,glGetTexEnvfv,(GLenum target, GLenum pname, GLfloat *params))
	OSD_GL_UNUSED(void,glGetTexEnviv,(GLenum target, GLenum pname, GLint *params))
	OSD_GL_UNUSED(void,glGetTexGendv,(GLenum coord, GLenum pname, GLdouble *params))
	OSD_GL_UNUSED(void,glGetTexGenfv,(GLenum coord, GLenum pname, GLfloat *params))
	OSD_GL_UNUSED(void,glGetTexGeniv,(GLenum coord, GLenum pname, GLint *params))
	OSD_GL_UNUSED(void,glGetTexImage,(GLenum target, GLint level, GLenum format, GLenum type, GLvoid *pixels))
	OSD_GL(void,glGetTexLevelParameterfv,(GLenum target, GLint level, GLenum pname, GLfloat *params))
	OSD_GL(void,glGetTexLevelParameteriv,(GLenum target, GLint level, GLenum pname, GLint *params))
	OSD_GL_UNUSED(void,glGetTexParameterfv,(GLenum target, GLenum pname, GLfloat *params))
	OSD_GL_UNUSED(void,glGetTexParameteriv,(GLenum target, GLenum pname, GLint *params))
	OSD_GL(void,glHint,(GLenum target, GLenum mode))
	OSD_GL_UNUSED(void,glIndexMask,(GLuint mask))
	OSD_GL_UNUSED(void,glIndexPointer,(GLenum type, GLsizei stride, const GLvoid *pointer))
	OSD_GL_UNUSED(void,glIndexd,(GLdouble c))
	OSD_GL_UNUSED(void,glIndexdv,(const GLdouble *c))
	OSD_GL_UNUSED(void,glIndexf,(GLfloat c))
	OSD_GL_UNUSED(void,glIndexfv,(const GLfloat *c))
	OSD_GL_UNUSED(void,glIndexi,(GLint c))
	OSD_GL_UNUSED(void,glIndexiv,(const GLint *c))
	OSD_GL_UNUSED(void,glIndexs,(GLshort c))
	OSD_GL_UNUSED(void,glIndexsv,(const GLshort *c))
	OSD_GL_UNUSED(void,glIndexub,(GLubyte c))
	OSD_GL_UNUSED(void,glIndexubv,(const GLubyte *c))
	OSD_GL_UNUSED(void,glInitNames,(void))
	OSD_GL_UNUSED(void,glInterleavedArrays,(GLenum format, GLsizei stride, const GLvoid *pointer))
	OSD_GL_UNUSED(GLboolean,glIsEnabled,(GLenum cap))
	OSD_GL_UNUSED(GLboolean,glIsList,(GLuint list))
	OSD_GL_UNUSED(GLboolean,glIsTexture,(GLuint texture))
	OSD_GL_UNUSED(void,glLightModelf,(GLenum pname, GLfloat param))
	OSD_GL_UNUSED(void,glLightModelfv,(GLenum pname, const GLfloat *params))
	OSD_GL_UNUSED(void,glLightModeli,(GLenum pname, GLint param))
	OSD_GL_UNUSED(void,glLightModeliv,(GLenum pname, const GLint *params))
	OSD_GL_UNUSED(void,glLightf,(GLenum light, GLenum pname, GLfloat param))
	OSD_GL_UNUSED(void,glLightfv,(GLenum light, GLenum pname, const GLfloat *params))
	OSD_GL_UNUSED(void,glLighti,(GLenum light, GLenum pname, GLint param))
	OSD_GL_UNUSED(void,glLightiv,(GLenum light, GLenum pname, const GLint *params))
	OSD_GL_UNUSED(void,glLineStipple,(GLint factor, GLushort pattern))
	OSD_GL(void,glLineWidth,(GLfloat width))
	OSD_GL_UNUSED(void,glListBase,(GLuint base))
	OSD_GL(void,glLoadIdentity,(void))
	OSD_GL_UNUSED(void,glLoadMatrixd,(const GLdouble *m))
	OSD_GL_UNUSED(void,glLoadMatrixf,(const GLfloat *m))
	OSD_GL_UNUSED(void,glLoadName,(GLuint name))
	OSD_GL_UNUSED(void,glLogicOp,(GLenum opcode))
	OSD_GL_UNUSED(void,glMap1d,(GLenum target, GLdouble u1, GLdouble u2, GLint stride, GLint order, const GLdouble *points))
	OSD_GL_UNUSED(void,glMap1f,(GLenum target, GLfloat u1, GLfloat u2, GLint stride, GLint order, const GLfloat *points))
	OSD_GL_UNUSED(void,glMap2d,(GLenum target, GLdouble u1, GLdouble u2, GLint ustride, GLint uorder, GLdouble v1, GLdouble v2, GLint vstride, GLint vorder, const GLdouble *points))
	OSD_GL_UNUSED(void,glMap2f,(GLenum target, GLfloat u1, GLfloat u2, GLint ustride, GLint uorder, GLfloat v1, GLfloat v2, GLint vstride, GLint vorder, const GLfloat *points))
	OSD_GL_UNUSED(void,glMapGrid1d,(GLint un, GLdouble u1, GLdouble u2))
	OSD_GL_UNUSED(void,glMapGrid1f,(GLint un, GLfloat u1, GLfloat u2))
	OSD_GL_UNUSED(void,glMapGrid2d,(GLint un, GLdouble u1, GLdouble u2, GLint vn, GLdouble v1, GLdouble v2))
	OSD_GL_UNUSED(void,glMapGrid2f,(GLint un, GLfloat u1, GLfloat u2, GLint vn, GLfloat v1, GLfloat v2))
	OSD_GL_UNUSED(void,glMaterialf,(GLenum face, GLenum pname, GLfloat param))
	OSD_GL_UNUSED(void,glMaterialfv,(GLenum face, GLenum pname, const GLfloat *params))
	OSD_GL_UNUSED(void,glMateriali,(GLenum face, GLenum pname, GLint param))
	OSD_GL_UNUSED(void,glMaterialiv,(GLenum face, GLenum pname, const GLint *params))
	OSD_GL(void,glMatrixMode,(GLenum mode))
	OSD_GL_UNUSED(void,glMultMatrixd,(const GLdouble *m))
	OSD_GL_UNUSED(void,glMultMatrixf,(const GLfloat *m))
	OSD_GL_UNUSED(void,glNewList,(GLuint list, GLenum mode))
	OSD_GL_UNUSED(void,glNormal3b,(GLbyte nx, GLbyte ny, GLbyte nz))
	OSD_GL_UNUSED(void,glNormal3bv,(const GLbyte *v))
	OSD_GL_UNUSED(void,glNormal3d,(GLdouble nx, GLdouble ny, GLdouble nz))
	OSD_GL_UNUSED(void,glNormal3dv,(const GLdouble *v))
	OSD_GL_UNUSED(void,glNormal3f,(GLfloat nx, GLfloat ny, GLfloat nz))
	OSD_GL_UNUSED(void,glNormal3fv,(const GLfloat *v))
	OSD_GL_UNUSED(void,glNormal3i,(GLint nx, GLint ny, GLint nz))
	OSD_GL_UNUSED(void,glNormal3iv,(const GLint *v))
	OSD_GL_UNUSED(void,glNormal3s,(GLshort nx, GLshort ny, GLshort nz))
	OSD_GL_UNUSED(void,glNormal3sv,(const GLshort *v))
	OSD_GL_UNUSED(void,glNormalPointer,(GLenum type, GLsizei stride, const GLvoid *pointer))
	OSD_GL(void,glOrtho,(GLdouble left, GLdouble right, GLdouble bottom, GLdouble top, GLdouble zNear, GLdouble zFar))
	OSD_GL_UNUSED(void,glPassThrough,(GLfloat token))
	OSD_GL_UNUSED(void,glPixelMapfv,(GLenum map, GLsizei mapsize, const GLfloat *values))
	OSD_GL_UNUSED(void,glPixelMapuiv,(GLenum map, GLsizei mapsize, const GLuint *values))
	OSD_GL_UNUSED(void,glPixelMapusv,(GLenum map, GLsizei mapsize, const GLushort *values))
	OSD_GL_UNUSED(void,glPixelStoref,(GLenum pname, GLfloat param))
	OSD_GL(void,glPixelStorei,(GLenum pname, GLint param))
	OSD_GL_UNUSED(void,glPixelTransferf,(GLenum pname, GLfloat param))
	OSD_GL_UNUSED(void,glPixelTransferi,(GLenum pname, GLint param))
	OSD_GL_UNUSED(void,glPixelZoom,(GLfloat xfactor, GLfloat yfactor))
	OSD_GL(void,glPointSize,(GLfloat size))
	OSD_GL_UNUSED(void,glPolygonMode,(GLenum face, GLenum mode))
	OSD_GL_UNUSED(void,glPolygonOffset,(GLfloat factor, GLfloat units))
	OSD_GL_UNUSED(void,glPolygonStipple,(const GLubyte *mask))
	OSD_GL(void,glPopAttrib,(void))
	OSD_GL(void,glPopClientAttrib,(void))
	OSD_GL(void,glPopMatrix,(void))
	OSD_GL_UNUSED(void,glPopName,(void))
	OSD_GL_UNUSED(void,glPrioritizeTextures,(GLsizei n, const GLuint *textures, const GLclampf *priorities))
	OSD_GL(void,glPushAttrib,(GLbitfield mask))
	OSD_GL(void,glPushClientAttrib,(GLbitfield mask))
	OSD_GL(void,glPushMatrix,(void))
	OSD_GL_UNUSED(void,glPushName,(GLuint name))
	OSD_GL_UNUSED(void,glRasterPos2d,(GLdouble x, GLdouble y))
	OSD_GL_UNUSED(void,glRasterPos2dv,(const GLdouble *v))
	OSD_GL_UNUSED(void,glRasterPos2f,(GLfloat x, GLfloat y))
	OSD_GL_UNUSED(void,glRasterPos2fv,(const GLfloat *v))
	OSD_GL_UNUSED(void,glRasterPos2i,(GLint x, GLint y))
	OSD_GL_UNUSED(void,glRasterPos2iv,(const GLint *v))
	OSD_GL_UNUSED(void,glRasterPos2s,(GLshort x, GLshort y))
	OSD_GL_UNUSED(void,glRasterPos2sv,(const GLshort *v))
	OSD_GL_UNUSED(void,glRasterPos3d,(GLdouble x, GLdouble y, GLdouble z))
	OSD_GL_UNUSED(void,glRasterPos3dv,(const GLdouble *v))
	OSD_GL_UNUSED(void,glRasterPos3f,(GLfloat x, GLfloat y, GLfloat z))
	OSD_GL_UNUSED(void,glRasterPos3fv,(const GLfloat *v))
	OSD_GL_UNUSED(void,glRasterPos3i,(GLint x, GLint y, GLint z))
	OSD_GL_UNUSED(void,glRasterPos3iv,(const GLint *v))
	OSD_GL_UNUSED(void,glRasterPos3s,(GLshort x, GLshort y, GLshort z))
	OSD_GL_UNUSED(void,glRasterPos3sv,(const GLshort *v))
	OSD_GL_UNUSED(void,glRasterPos4d,(GLdouble x, GLdouble y, GLdouble z, GLdouble w))
	OSD_GL_UNUSED(void,glRasterPos4dv,(const GLdouble *v))
	OSD_GL_UNUSED(void,glRasterPos4f,(GLfloat x, GLfloat y, GLfloat z, GLfloat w))
	OSD_GL_UNUSED(void,glRasterPos4fv,(const GLfloat *v))
	OSD_GL_UNUSED(void,glRasterPos4i,(GLint x, GLint y, GLint z, GLint w))
	OSD_GL_UNUSED(void,glRasterPos4iv,(const GLint *v))
	OSD_GL_UNUSED(void,glRasterPos4s,(GLshort x, GLshort y, GLshort z, GLshort w))
	OSD_GL_UNUSED(void,glRasterPos4sv,(const GLshort *v))
	OSD_GL_UNUSED(void,glReadBuffer,(GLenum mode))
	OSD_GL_UNUSED(void,glReadPixels,(GLint x, GLint y, GLsizei width, GLsizei height, GLenum format, GLenum type, GLvoid *pixels))
	OSD_GL_UNUSED(void,glRectd,(GLdouble x1, GLdouble y1, GLdouble x2, GLdouble y2))
	OSD_GL_UNUSED(void,glRectdv,(const GLdouble *v1, const GLdouble *v2))
	OSD_GL_UNUSED(void,glRectf,(GLfloat x1, GLfloat y1, GLfloat x2, GLfloat y2))
	OSD_GL_UNUSED(void,glRectfv,(const GLfloat *v1, const GLfloat *v2))
	OSD_GL_UNUSED(void,glRecti,(GLint x1, GLint y1, GLint x2, GLint y2))
	OSD_GL_UNUSED(void,glRectiv,(const GLint *v1, const GLint *v2))
	OSD_GL_UNUSED(void,glRects,(GLshort x1, GLshort y1, GLshort x2, GLshort y2))
	OSD_GL_UNUSED(void,glRectsv,(const GLshort *v1, const GLshort *v2))
	OSD_GL_UNUSED(GLint,glRenderMode,(GLenum mode))
	OSD_GL_UNUSED(void,glRotated,(GLdouble angle, GLdouble x, GLdouble y, GLdouble z))
	OSD_GL_UNUSED(void,glRotatef,(GLfloat angle, GLfloat x, GLfloat y, GLfloat z))
	OSD_GL_UNUSED(void,glScaled,(GLdouble x, GLdouble y, GLdouble z))
	OSD_GL_UNUSED(void,glScalef,(GLfloat x, GLfloat y, GLfloat z))
	OSD_GL_UNUSED(void,glScissor,(GLint x, GLint y, GLsizei width, GLsizei height))
	OSD_GL_UNUSED(void,glSelectBuffer,(GLsizei size, GLuint *buffer))
	OSD_GL(void,glShadeModel,(GLenum mode))
	OSD_GL_UNUSED(void,glStencilFunc,(GLenum func, GLint ref, GLuint mask))
	OSD_GL_UNUSED(void,glStencilMask,(GLuint mask))
	OSD_GL_UNUSED(void,glStencilOp,(GLenum fail, GLenum zfail, GLenum zpass))
	OSD_GL_UNUSED(void,glTexCoord1d,(GLdouble s))
	OSD_GL_UNUSED(void,glTexCoord1dv,(const GLdouble *v))
	OSD_GL_UNUSED(void,glTexCoord1f,(GLfloat s))
	OSD_GL_UNUSED(void,glTexCoord1fv,(const GLfloat *v))
	OSD_GL_UNUSED(void,glTexCoord1i,(GLint s))
	OSD_GL_UNUSED(void,glTexCoord1iv,(const GLint *v))
	OSD_GL_UNUSED(void,glTexCoord1s,(GLshort s))
	OSD_GL_UNUSED(void,glTexCoord1sv,(const GLshort *v))
	OSD_GL_UNUSED(void,glTexCoord2d,(GLdouble s, GLdouble t))
	OSD_GL_UNUSED(void,glTexCoord2dv,(const GLdouble *v))
	OSD_GL(void,glTexCoord2f,(GLfloat s, GLfloat t))
	OSD_GL_UNUSED(void,glTexCoord2fv,(const GLfloat *v))
	OSD_GL_UNUSED(void,glTexCoord2i,(GLint s, GLint t))
	OSD_GL_UNUSED(void,glTexCoord2iv,(const GLint *v))
	OSD_GL_UNUSED(void,glTexCoord2s,(GLshort s, GLshort t))
	OSD_GL_UNUSED(void,glTexCoord2sv,(const GLshort *v))
	OSD_GL_UNUSED(void,glTexCoord3d,(GLdouble s, GLdouble t, GLdouble r))
	OSD_GL_UNUSED(void,glTexCoord3dv,(const GLdouble *v))
	OSD_GL_UNUSED(void,glTexCoord3f,(GLfloat s, GLfloat t, GLfloat r))
	OSD_GL_UNUSED(void,glTexCoord3fv,(const GLfloat *v))
	OSD_GL_UNUSED(void,glTexCoord3i,(GLint s, GLint t, GLint r))
	OSD_GL_UNUSED(void,glTexCoord3iv,(const GLint *v))
	OSD_GL_UNUSED(void,glTexCoord3s,(GLshort s, GLshort t, GLshort r))
	OSD_GL_UNUSED(void,glTexCoord3sv,(const GLshort *v))
	OSD_GL_UNUSED(void,glTexCoord4d,(GLdouble s, GLdouble t, GLdouble r, GLdouble q))
	OSD_GL_UNUSED(void,glTexCoord4dv,(const GLdouble *v))
	OSD_GL_UNUSED(void,glTexCoord4f,(GLfloat s, GLfloat t, GLfloat r, GLfloat q))
	OSD_GL_UNUSED(void,glTexCoord4fv,(const GLfloat *v))
	OSD_GL_UNUSED(void,glTexCoord4i,(GLint s, GLint t, GLint r, GLint q))
	OSD_GL_UNUSED(void,glTexCoord4iv,(const GLint *v))
	OSD_GL_UNUSED(void,glTexCoord4s,(GLshort s, GLshort t, GLshort r, GLshort q))
	OSD_GL_UNUSED(void,glTexCoord4sv,(const GLshort *v))
	OSD_GL(void,glTexCoordPointer,(GLint size, GLenum type, GLsizei stride, const GLvoid *pointer))
	OSD_GL(void,glTexEnvf,(GLenum target, GLenum pname, GLfloat param))
	OSD_GL_UNUSED(void,glTexEnvfv,(GLenum target, GLenum pname, const GLfloat *params))
	OSD_GL_UNUSED(void,glTexEnvi,(GLenum target, GLenum pname, GLint param))
	OSD_GL_UNUSED(void,glTexEnviv,(GLenum target, GLenum pname, const GLint *params))
	OSD_GL_UNUSED(void,glTexGend,(GLenum coord, GLenum pname, GLdouble param))
	OSD_GL_UNUSED(void,glTexGendv,(GLenum coord, GLenum pname, const GLdouble *params))
	OSD_GL_UNUSED(void,glTexGenf,(GLenum coord, GLenum pname, GLfloat param))
	OSD_GL_UNUSED(void,glTexGenfv,(GLenum coord, GLenum pname, const GLfloat *params))
	OSD_GL_UNUSED(void,glTexGeni,(GLenum coord, GLenum pname, GLint param))
	OSD_GL_UNUSED(void,glTexGeniv,(GLenum coord, GLenum pname, const GLint *params))
	OSD_GL_UNUSED(void,glTexImage1D,(GLenum target, GLint level, GLint internalformat, GLsizei width, GLint border, GLenum format, GLenum type, const GLvoid *pixels))
	OSD_GL(void,glTexImage2D,(GLenum target, GLint level, GLint internalformat, GLsizei width, GLsizei height, GLint border, GLenum format, GLenum type, const GLvoid *pixels))
	OSD_GL_UNUSED(void,glTexParameterf,(GLenum target, GLenum pname, GLfloat param))
	OSD_GL_UNUSED(void,glTexParameterfv,(GLenum target, GLenum pname, const GLfloat *params))
	OSD_GL(void,glTexParameteri,(GLenum target, GLenum pname, GLint param))
	OSD_GL_UNUSED(void,glTexParameteriv,(GLenum target, GLenum pname, const GLint *params))
	OSD_GL_UNUSED(void,glTexSubImage1D,(GLenum target, GLint level, GLint xoffset, GLsizei width, GLenum format, GLenum type, const GLvoid *pixels))
	OSD_GL(void,glTexSubImage2D,(GLenum target, GLint level, GLint xoffset, GLint yoffset, GLsizei width, GLsizei height, GLenum format, GLenum type, const GLvoid *pixels))
	OSD_GL_UNUSED(void,glTranslated,(GLdouble x, GLdouble y, GLdouble z))
	OSD_GL_UNUSED(void,glTranslatef,(GLfloat x, GLfloat y, GLfloat z))
	OSD_GL_UNUSED(void,glVertex2d,(GLdouble x, GLdouble y))
	OSD_GL_UNUSED(void,glVertex2dv,(const GLdouble *v))
	OSD_GL(void,glVertex2f,(GLfloat x, GLfloat y))
	OSD_GL_UNUSED(void,glVertex2fv,(const GLfloat *v))
	OSD_GL(void,glVertex2i,(GLint x, GLint y))
	OSD_GL_UNUSED(void,glVertex2iv,(const GLint *v))
	OSD_GL_UNUSED(void,glVertex2s,(GLshort x, GLshort y))
	OSD_GL_UNUSED(void,glVertex2sv,(const GLshort *v))
	OSD_GL_UNUSED(void,glVertex3d,(GLdouble x, GLdouble y, GLdouble z))
	OSD_GL_UNUSED(void,glVertex3dv,(const GLdouble *v))
	OSD_GL(void,glVertex3f,(GLfloat x, GLfloat y, GLfloat z))
	OSD_GL_UNUSED(void,glVertex3fv,(const GLfloat *v))
	OSD_GL_UNUSED(void,glVertex3i,(GLint x, GLint y, GLint z))
	OSD_GL_UNUSED(void,glVertex3iv,(const GLint *v))
	OSD_GL_UNUSED(void,glVertex3s,(GLshort x, GLshort y, GLshort z))
	OSD_GL_UNUSED(void,glVertex3sv,(const GLshort *v))
	OSD_GL_UNUSED(void,glVertex4d,(GLdouble x, GLdouble y, GLdouble z, GLdouble w))
	OSD_GL_UNUSED(void,glVertex4dv,(const GLdouble *v))
	OSD_GL_UNUSED(void,glVertex4f,(GLfloat x, GLfloat y, GLfloat z, GLfloat w))
	OSD_GL_UNUSED(void,glVertex4fv,(const GLfloat *v))
	OSD_GL_UNUSED(void,glVertex4i,(GLint x, GLint y, GLint z, GLint w))
	OSD_GL_UNUSED(void,glVertex4iv,(const GLint *v))
	OSD_GL_UNUSED(void,glVertex4s,(GLshort x, GLshort y, GLshort z, GLshort w))
	OSD_GL_UNUSED(void,glVertex4sv,(const GLshort *v))
	OSD_GL(void,glVertexPointer,(GLint size, GLenum type, GLsizei stride, const GLvoid *pointer))
	OSD_GL(void,glViewport,(GLint x, GLint y, GLsizei width, GLsizei height))

#endif /* GET_GLFUNC */
