#ifdef SOUND

import java.io.*;

/** 
 *
 * Class for the DMC required by the Sound Interface.
 *
 * @author   David de Niese
 * @version  0.56f
 * @final    TRUE
 *
 * Most of the information on how the NES Sound works was provided
 * by Brad Taylor's NES Sound document and the C implementation of
 * Nester's APU Source by Matt Conte (matt@conte.com).
 *
 */


final class SoundChannelDMC 
{



     /**
      *
      * <P>The Control Registers for the DMC.</P>
      *
      */

      public int regs[] = new int[4]; 



     /**
      *
      * <P>Whether the Channel is enabled.</P>
      *
      */

      public boolean enabled = false; 



     /**
      *
      * <P>The current frequency of the channel.</P>
      *
      */

      public int freq = 0; 



     /**
      *
      * <P>The Cycle Debt for this Sample to Catch Up
      *
      */

      public int phaseacc = 0x00; 



     /**
      *
      * <P>The current output Volume of the channel.</P>
      *
      */

      public int outputVol = 0; 



     /**
      *
      * Address to Read Sample Data From
      *
      */
      
      public int address = 0;



     /**
      *
      * Address to Loop Back to when Looped Sample Complete
      *
      */
      
      public int cachedAddr = 0;
      
      
      
     /**
      *
      * Sample Length
      *
      */
       
      public int dmaLength = 0;


     /**
      *
      * Sample Length for Looping Back
      *
      */

      public int cachedDMALength = 0;
      
      
      
     /**
      *
      * Current Byte of Sample
      *
      */

      public int curByte = 0;
      
      
      
     /**
      *
      * Whether or not Sample Should Loop
      *
      */

      public boolean looping = false;
      
      
     /**
      *
      * Whether Interrupt Should be Generated
      *
      */
      
      public boolean irqGen  = false;



     /**
      *
      * Whether Interrupt has Occurred
      *
      */

      public boolean irqOccurred = false;
      

     /**
      *
      * Reload the Cached Sample Data
      *
      */

      public final void reload()
      {
         
         address = cachedAddr;
         dmaLength = cachedDMALength;
         irqOccurred = false;
                                    
      }
 

}

#endif
