#ifdef STAND


// Declare Imports

   import java.awt.event.*;



/** 
*
* Class for the Window Listener used by the NetRomsFrame.
*
* @author   David de Niese
* @version  0.56f
* @final    TRUE
*
*/

final class NetRomsFrameListener implements ActionListener 
{



     /**
      *
      * <P>The NetRomsFrame the Listener is attached to.</P>
      *
      */

      private NetRomsFrame host;


     /**
      *
      * <P>The current NES Engine.</P>
      *
      */

      private NES nes;


     /**
      *
      * <P>The current Graphical User Interface.</P>
      *
      */

      private GUI gui;


     /**
      *
      * <P>Create a Frame Listener for the NetRomsFrame.</P>
      *
      */

      public NetRomsFrameListener (NES nes, GUI gui, NetRomsFrame host) 
      {


         // Grab References

            this.nes  = nes;
            this.gui  = gui;
            this.host = host;


      }



     /**
      *
      * <P>Handler for when a button is pressed within the NetRomsFrame.</P>
      *
      */

      public final void actionPerformed(ActionEvent e) 
      {


         // Fetch the Action Command

            String command = e.getActionCommand();


         // Check if the User Selected 'Download'

            if (command == "DOWNLOAD") 
            {


               // Find the real URL Location of the ROM

                  host.hiddenList.select(host.visibleList.getSelectedIndex());
                  String fileName = host.hiddenList.getSelectedItem();
                  String description = host.visibleList.getSelectedItem();



               // Start the ROM for Download

                  NetRomsDownloader downloader = new NetRomsDownloader(nes,gui,fileName,description);
                  downloader.start();


               // Dispose of the Window

                  gui.downloadFrame.dispose();
                  gui.downloadFrame = null;

            }


         // Check if the User Selected 'CLOSE'

            if (command == "CLOSE" && gui.downloadFrame != null) 
            {

               gui.downloadFrame.dispose();
               gui.downloadFrame = null;

            }


      }

}

#endif
