#ifdef STAND


// Declare Imports

   import java.awt.event.*;


/** 
*
* Class for the Window Adapter used by the NetRomsFrame.
*
* @author   David de Niese
* @version  0.56f
* @final    TRUE
*
*/

final class NetRomsFrameAdapter implements WindowListener 
{


     /**
      *
      * <P>The current NES Engine.</P>
      *
      */

      private NES nes;


     /**
      *
      * <P>The current Graphical User Interface.</P>
      *
      */

      private GUI gui;


     /**
      *
      * <P>Create a Frame Adapter for the NetRomsFrame.</P>
      *
      */

      public NetRomsFrameAdapter(NES nes, GUI gui) 
      {

         // Set References to the NES and GUI

            this.nes = nes;
            this.gui = gui;

      }


     /**
      *
      * <P>Handler for when the NetRomsFrame is Closed.</P>
      *
      */

      public final void windowClosing(WindowEvent e) 
      {


         // Kill the Window Completely

            gui.downloadFrame.dispose();
            gui.downloadFrame = null;

      }


     /**
      *
      * <P>Handler for when the NetRomsFrame is Activated.</P>
      *
      */

      public final void windowActivated (WindowEvent e) {}


     /**
      *
      * <P>Handler for when the NetRomsFrame is Deactivated.</P>
      *
      */

      public final void windowDeactivated (WindowEvent e) {}


     /**
      *
      * <P>Handler for when the NetRomsFrame is Opened.</P>
      *
      */

      public final void windowOpened (WindowEvent e) {}


     /**
      *
      * <P>Handler for when the NetRomsFrame is Closed.</P>
      *
      */

      public final void windowClosed (WindowEvent e) {}


     /**
      *
      * <P>Handler for when the NetRomsFrame is Iconified.</P>
      *
      */

      public final void windowIconified (WindowEvent e) {}


     /**
      *
      * <P>Handler for when the NetRomsFrame is Deiconified.</P>
      *
      */

      public final void windowDeiconified (WindowEvent e) {}

   
}

#endif
