

/** 
 *
 * NESCafe Exception
 *
 * @author  David de Niese
 * @version 0.56f
 * @final   TRUE
 *
 */


public final class NESCafeException extends Exception 
{


     /**
      *
      * Message that is associated with the current Exception
      *
      */

      private String message;



     /**
      *
      * <P>Constructs a new InvalidOrUnsupportedROM Exception with the specified message.</P>
      *
      * @param theMessage The Message to attach to the Exception. 
      *
      */

      public NESCafeException(String theMessage) 
      {

         message = theMessage; 

      }


     /**
      * 
      * <P>Returns a String Representation of the Exception.</P>
      *
      * @return String representation of the Exception. 
      *
      */

      public final String toString() 
      {

         return "NESCafeException:[" + message + "]";

      }


     /**
      *
      * <P>Return the Message associated with the Exception.</P>
      *
      * @return Message associated with the Exception. 
      *
      */

      public final String getMessage() 
      {

         return message; 

      }

}
