#ifdef APPLET


// Declare Imports

   import java.applet.Applet;
   import java.awt.*;
   import java.util.*;
   import java.net.*;
   import java.awt.event.*;
   import java.io.*;

      

/** 
 *
 * Class for the NESCafe Applet.
 *
 * @author   David de Niese
 * @version  0.56f
 * @final    TRUE
 *
 */

public class NESCafeApplet extends Applet implements Runnable, FocusListener 
{



     /** 
      *
      * The current Graphical User Interface
      *
      */

      private GUI gui;


     /**
      *
      * The current NES Engine
      *
      */

      private NES nes;



     /** 
      *
      * The NESCafe Applet
      *
      */

      private Thread nescafeapplet;



     /** 
      *
      * The Error Message Holder for Displaying When Loading Fails
      *
      */

      private String errMessage = "";



     /** 
      *
      * The NESCafe Standard Logo as an Image
      *
      */

      Image nescafeImg = null;



     /**
      *
      * The Load State Filename
      *
      */
      
      public String loadStateFilename = "";
      
      
      
     /**
      *
      * The UserName who is playing the Applet
      *
      */
      
      public String username = "Unknown";
      
      
      
#ifdef PUNCHOUT

     /**
      *
      * The UserName who is playing the Applet
      *
      */
      
      public boolean PunchoutCheatsEnabled = false;
    



     /**
      *
      * Result Submission Enabled
      *
      */

      public boolean PunchoutSubmitEnabled = false;


     /**
      *
      * A Special Mode
      *
      */
      
      public String PunchoutSpecialMode = "";
    

#endif



     /**
      *
      * Applet Stored Height
      *
      */

      private int appletHeight = 0;
      
      
     /**
      *
      * Applet Stored Width
      *
      */

      private int appletWidth = 0;
      


     /**
      *
      * Create a new NESCafe Applet
      *
      */

      public NESCafeApplet() {}


     /**
      * 
      * Initialise the Applet
      *
      */

      public void init() 
      {

      }



     /**
      *
      * Start the Applet
      *
      */

      public void start() 
      {

            
         // Start the NESCafe Applet Run Method

            nescafeapplet = new Thread(this);
            nescafeapplet.start();


      }



     /**
      *
      * Load a ROM from Applet Tag
      *
      */

      public final boolean loadROM(String romfile) 
      {



         // Display the Loading Screen

            gui.showLoadingScreen(true);



         // Garbage Collection

            System.gc();
            repaint();



         // Attempt to Load the ROM File

            try 
            {

               nes.cartUnload();

               if (nes.cartLoad(romfile)) 
               {

                  // Loading Success

                     System.gc();
                     return true;

			  
               } 

            } catch (Exception e) {}



         // Loading Failed

            errMessage = "NESCafe failed to load '" + romfile + "'";
            gui.showLoadingScreen(false);
            return false;


      }



     /**
      *
      * Stop the Applet
      *
      */

      public void stop() 
      {

         // Stop the Applet Running

            nes.cartUnload();
            gui.deleteDisplay();
            nescafeapplet = null;


      }



     /**
      *
      * Destory the Applet
      *
      */

      public void destroy() 
      {

      }



     /**
      *
      * Use the Applet to Load an Image
      *
      */

      public final Image loadImage(String imgFile) throws Exception 
      {

         // Determine the Method to Use to Load Images
         
            Image img = null;
            
            
         	if (true)
         	{
         		
         	   // The New Method Reads Directly from JAR File
         		
         		  img = loadImageFromJar(imgFile);
         		
         	}
            else
            {
            	
               // The Old Method Requires Files to be Available on Web Server
               
                  URL url = new URL(getCodeBase(), "images/" + imgFile);
                  img = getImage(url);
            	
            }



         // Ensure Image is Fully Downloaded

            MediaTracker tracker = new MediaTracker(this);
            tracker.addImage(img, 0);
            tracker.waitForID(0);



         // Check for Errors

            if (tracker.isErrorID(0))
               return null;

            return img;


      }



     /**
      *
      * Load Image from JAR File
      *
      */

      public Image loadImageFromJar(String name) 
      {
         
         // Declare Input Stream
         
			   DDNBInputStream in;
			
			
			
			// Declare Read Buffer
			
			   byte[] _array;
			   int _array_size;


         // Grab Toolkit
         			
			   Toolkit toolkit = Toolkit.getDefaultToolkit();
			
			
			
			// Attempt to Read Content
			
			   try 
			   {
			
			      // Grab InputStream to Resource
			      
				      in = new DDNBInputStream(getClass().getResourceAsStream(name)); 
			
			
			      // Configure Input Buffer
			      
				      ByteArrayOutputStream bytes;
				
      				bytes = new ByteArrayOutputStream();
      				_array_size = 2048;
      				_array = new byte[_array_size];
				
				
               // Read Data into Byte Array
				
				      int rb;
				
                  while ((rb = in.read(_array, 0, _array_size)) > -1) 
                  {
                     bytes.write(_array, 0, rb);
                  }

                  bytes.close();
                  _array = bytes.toByteArray();
                  in.close();


               // Create Image

                  Image image = toolkit.createImage(_array);                  
                  return image;
                  
                  
            }
            catch (Exception e) 
            {
               return null;
            }

		}
			

     /**
      *
      * Get Display Height of Applet
      *
      */
      
      public final int getDispHeight()
      {
      
         try
         {
            
               if (appletHeight == 0)
               {
                  appletHeight = this.getHeight();
               }
               return appletHeight;
               
         }   
         catch (NoSuchMethodError e)
         {

            // For Old Microsoft Plugins
            
               Dimension d  = this.getSize();
               appletHeight = d.height;
               d = null;
               return appletHeight;
            
            
         }

      }
      


     /**
      *
      * Get Display Width of Applet
      *
      */

      public final int getDispWidth()
      {
      
         try
         {

               if (appletWidth == 0)    
               {
                       
                  appletWidth = this.getWidth();
               
               }
               return appletWidth;
               
         }   
         catch (NoSuchMethodError e)
         {

            // For Old Microsoft Plugins
            
               Dimension d = this.getSize();
               appletWidth = d.width;
               d = null;
               return appletWidth;
            
         }

      }

      
     /**
      *
      * Applet Main Paint Method
      *
      */

      public void paint(Graphics g) 
      {


         // Get Dimensions
         
            int h = getDispHeight();
            int w = getDispWidth();
            
            
            int x = w/2 - (int)(1 * TVController.screenWidth )/2;
            int y = h/2 - (int)(1 * TVController.screenHeight)/2;



         // If the NES Has Not Started Then Show Default Logo

            if (nes == null)
            {

               // First Things First
      
                  g.setColor(Color.black);
                  g.fillRect(0,0,w,h);
                  


               // Draw NESCafe Image

                  if (nescafeImg != null)
                  {
                     g.drawImage(nescafeImg,x,y,Color.black,null);
                  }
             
                  return;

            }



         // If Everything is Running Ensure TVController Has Graphics Context

            if (gui != null && gui.tvController != null)
            {

               gui.tvController.passAppletGraphics(g);

            }
            
            

         // If the NES Has Started But No Cart is Running Check for Errors

            if (nes != null && !nes.isCartRunning())
            {


                  if (errMessage != null && errMessage != "")
                  {


                     if (errMessage != null && errMessage != "")
                     {

                        
                        if (gui != null && gui.tvController != null)
                        {

                           gui.tvController.setTopStatusBar(errMessage);
                           
                        }
                        
                     }
                     else
                     {
                        if ("No NES Rom Specified".equals(errMessage))
                        {
                           gui.tvController.setTopStatusBar("Please specify a ROM file in the Applet Tag");
                           
                        }
                        else
                        {
                           gui.tvController.setTopStatusBar("An unknown error occurred whilst starting NESCafe");
                        }
                     }
	
                  }


                  if (gui != null && gui.tvController != null)
                     gui.tvController.showNESCafeLogo();
                  
                  return;
			
            }
          


      }



     /**
      *
      * Applet Update Method with No Blanking
      *
      */

      public void update(Graphics g)
      {

         paint(g);

      }



     /**
      *
      * Applet Run Method - Stops if No Errors
      *
      */

      public void run() 
      {

         // Add the Focus Listener

            addFocusListener(this);


         // Call Repaint As Soon As Possible to Produce Black Background

            repaint();



         // Attempt to Load the NESCafe Standard Logo

            try
            {


               nescafeImg = loadImage("NESCafe.ddnb");
	
            }
            catch (Exception e) {}
	         repaint();


         // Create the GUI and NES

            gui = null;
            nes = null;
            System.gc();

            gui = new GUI();
            nes = new NES();



         // Initialise the NES Machine and the Graphical User Interface

            nes.setAppletMode(this);
            nes.init(gui);



         // Initialise the GUI

            gui.init(nes);



         // Get ROM File from Applet Parameters

            boolean fileLoaded = false;
            String romfile = getParameter("ROMFILE");


            if (romfile == null || romfile.equals(""))
            {

               // Load the Default ROM

                  romfile = "";

            }
 
 
         // Load the ROM File

            fileLoaded = loadROM(romfile);



         // Check if Need to Load State
         
            String loadState = getParameter("LOADSTATE");
            
            if (loadState != null && !loadState.equals(""))
            {
               
               // Issue a Load State Request

                  loadStateFilename = loadState;
                  gui.loadStateRequest = true;
                  gui.saveStateRequest = false;

            }



#ifdef PUNCHOUT


         // Check for a Special Mode Enabled

            String special = getParameter("SPECIAL");
            
            if (special != null && !special.equals(""))
               PunchoutSpecialMode = special;
               
            
            
#endif


         // Get Any Additional Parameters from HTML

            nes.usersettings.controllerZapperEnabled = "TRUE".equalsIgnoreCase(getParameter("LIGHTGUN"));
            
            username = getParameter("USERNAME");
            
            if (username == null || username.equals(""))
               username = "Unknown";



#ifdef SOUND


         // Enable Sound but by Default it is Off
         
            nes.sound.enableSound("TRUE".equalsIgnoreCase(getParameter("SOUND")));

#endif


#ifdef PUNCHOUT


         // Check if we can Submit and Check for Cheats

            PunchoutSubmitEnabled = ("TRUE".equalsIgnoreCase(getParameter("ALLOWSUBMIT")));
            PunchoutCheatsEnabled = ("TRUE".equalsIgnoreCase(getParameter("PUNCHOUTCHEATS")));
            
            
         // Ensure No One Can Cheat and Submit
         
            if (PunchoutCheatsEnabled)
               PunchoutSubmitEnabled = false;
            
#endif


         // Repaint the Screen

            repaint();



         // Pause the Emulator so it doens't Run Behind Activation Screen
         
            nes.cpu.setCPUPause(!hasFocus);


         // Allow Exit if Worked

            if (fileLoaded) return;



         // Keep Screen Updated if Failed

            Thread me = Thread.currentThread();

            while (nescafeapplet == me) 
            {

                 try 
                 {

                      Thread.currentThread().sleep(1000);
 
                 } 
                 catch (InterruptedException e) {}

                 repaint();
 
            }

	   }



     /**
      *
      * Focus Counter
      *
      */

      protected boolean hasFocus = false;



     /**
      *
      * Prior Pause Status
      *
      */

      private boolean priorPauseStatus = false;



     /**
      *
      * Handler for Focus Gain
      *
      */

      public void focusGained(FocusEvent e)
      {

         // Record Focus Status

            hasFocus = true;


         // Resume Pause Status for CPU

            if (nes != null)
               nes.cpu.setCPUPause(priorPauseStatus);

      }



     /**
      *
      * Handler for Focus Lost
      *
      */

      public void focusLost(FocusEvent e)
      {

         // Record Focus Status

            hasFocus = false;


         // Record Actual Pause Status and then Pause CPU

            if (nes != null)
            {
               priorPauseStatus = nes.cpu.getCPUPause();
               nes.cpu.setCPUPause(true);
            }

      }

}

#endif
