#ifndef MOBILE


// Declare Imports

   import java.awt.*;



/**
 *
 * Class for the Message Displayer required by the NESCafe NES Emulator.
 *
 * @author   David de Niese
 * @version  0.56f
 * @final    TRUE
 *
 */


public final class Messenger extends Thread 
{


     /**
      *
      * <P>The current Graphical User Interface.</P>
      *
      */

      private GUI gui;


     /**
      *
      * <P>The message to be displayed.</P>
      *
      */

      private String message = "";



     /**
      *
      * <P>Create a new Messenger Object.</P>
      *
      * @param Gui The GUI to receive the message.
      * @param Message The message that you wish to display.
      *
      */

      public Messenger (GUI gui, String message) 
      {

         this.message = message;
         this.gui     = gui;

      }



     /**
      *
      * <P>The run method for the Messenger Thread.</P>
      *
      */

      public final void run() 
      {


         // Display the message in the current GUI

            if (gui.tvController!=null)
            {
               gui.tvController.setStatusBar(message);
               gui.tvController.drawBlankScreen();

            }


         // Sleep for 6 seconds

            try 
            { 
               sleep (6000); 
            } 
            catch (Exception messengerException) {}


         // Remove the Message from Display

            if (gui.tvController.getStatusBar().equals(message) && gui.tvController!=null)
            {
               gui.tvController.setStatusBar("");
               gui.tvController.drawBlankScreen();

            }


      }


}

#endif
