#ifndef PUNCHOUT


/** 
 *
 * Class for the Mapper 122
 *
 * @author   David de Niese
 * @version  0.56f
 * @final    TRUE
 *
 */


public class Mapper122 extends Mapper 
{



     /**
      *
      * <P>Determine the number of the Memory Mapper.</P>
      *
      */

      public final int getMapperNumber() 
      {

         return 122;

      }



     /**
      *
      * <P>Method to initialise the Memory Mapper.</P>
      *
      * @param mm Memory Manager to initialise the Mapper with.
      *
      */

      public void init(MemoryManager mm)
      {

         // Assign Local Pointer for Memory Manager Object

            this.mm = mm;


         // Cause a Reset

            reset();


      }



      
     /**
      *
      * <P>Reset the Mapper.</P>
      *
      */

      public final void reset() 
      {

         // set CPU bank pointers
         
            setCPUBanks(0,1,2,3);
			


      }


      public void setCRC(long crc)
      {
      	
      	
#ifdef DEBUG

      	System.out.println("Mapper7A: crc=" + crc);

#endif      	
      	
      		if(crc == 0xF808AF60)
      		{
      			//AtlantisNoNazo
      			
      				patch = 1;
      				
      				
#ifdef DEBUG

      				System.out.println("Atlantis");

#endif
				
			}
      }




      private int patch=0;



     /**
      *
      * <P>Access the Mapper.</P>
      *
      */

      public final void access(int addr, int data) 
      {


			if (addr>=0x6000 && addr <0x8000)
			{
				
					if(patch==1)
					{

						int h = (data&0x20)>>2;
						int l = ((data&2)<<2) | (data&4);
						setPPUBanks(l, l+1, l+2, l+3, h, h+1, h+2, h+3);
						return;
					}
					if(addr == 0x6000)
					{
						int chr_bank0 = data & 0x07;
						int chr_bank1 = (data & 0x70) >> 4;
				
						setPPUBank0(chr_bank0*4+0);
						setPPUBank0(chr_bank0*4+1);
						setPPUBank0(chr_bank0*4+2);
						setPPUBank0(chr_bank0*4+3);
						setPPUBank0(chr_bank1*4+0);
						setPPUBank0(chr_bank1*4+1);
						setPPUBank0(chr_bank1*4+2);
						setPPUBank0(chr_bank1*4+3);
					}
					

			}
	
	
		}
	
}

#endif
