#ifdef STAND


// Declare Imports

   import java.awt.*;
   import java.awt.event.*;
   import java.net.*;
   import java.io.*;



/** 
*
* Class for the Configuration of your Internet Connection used by the NESCafe.
*
* @author   David de Niese
* @version  0.56f
* @final    TRUE
*
*/

public final class InternetConfigFrame extends Frame 
{


     /**
      *
      * <P>The current NES Engine.</P>
      *
      */

      private NES nes;


     /**
      *
      * <P>The current Graphical User Interface.</P>
      *
      */

      private GUI gui;



     /**
      *
      * <P>Checkbox for Enabling Proxy Server.</P>
      *
      */

      protected Checkbox useProxy;



     /**
      *
      * <P>TextField for Proxy Server.</P>
      *
      */

      protected TextField proxyServer;



     /**
      *
      * <P>TextField for Proxy Server Port.</P>
      *
      */

      protected TextField proxyServerPort;


     /**
      *
      * <P>TextField for Proxy Username.</P>
      *
      */

      protected TextField proxyUsername;



     /**
      *
      * <P>TextField for Proxy Password.</P>
      *
      */

      protected TextField proxyPassword;



     /**
      *
      * <P>Create a InternetConfigFrame Object.</P>
      *
      */

      public InternetConfigFrame(NES nes, GUI gui) throws Exception 
      {


         // Grab References to NES and GUI

            this.nes = nes;
            this.gui = gui;


         // Create the Window Listener

            InternetConfigFrameAdapter winAdapter = new InternetConfigFrameAdapter(nes,gui);
            addWindowListener(winAdapter);


         // Set Border Layout

            setLayout(new BorderLayout());


         // Set up the Frame

            setResizable(false);
            setTitle("Internet Configuration");
            setBackground(Color.lightGray);


         // Create a Frame Listener

            InternetConfigFrameListener listener = new InternetConfigFrameListener(nes,gui,this); 



         // Create Checkbox at Top of Screen

            Panel useProxyPanel = new Panel();
            useProxyPanel.setLayout(new FlowLayout(FlowLayout.CENTER));
            useProxy = new Checkbox("Enable Proxy Server",nes.usersettings.useProxyServer);
            useProxy.addItemListener(listener);
            useProxyPanel.add(useProxy);
            add(useProxyPanel, BorderLayout.NORTH);



         // Create Spacing Panels

            Panel space0 = new Panel();
            Panel space1 = new Panel();
            Panel space2 = new Panel();
            Panel space3 = new Panel();
            Panel space4 = new Panel();
            Panel space5 = new Panel();

            space0.setSize(10,10);
            space1.setSize(10,10);
            space2.setSize(10,10);
            space3.setSize(10,10);
            space4.setSize(10,10);
            space5.setSize(10,10);



         // Create Main Frame and Set Layout to Grid

            Panel main = new Panel();
            main.setLayout(new GridLayout(6,2));



         // Add Grid Entry 1

            Panel text1 = new Panel();
            text1.setLayout(new FlowLayout(FlowLayout.CENTER));
            text1.add(new Label("Proxy Server"));
            main.add(text1);


         // Add Grid Entry 2

            Panel text2 = new Panel();
            text2.setLayout(new FlowLayout(FlowLayout.CENTER));
            text2.add(new Label("Proxy Port Number"));
            main.add(text2);


         // Add Grid Entry for Proxy Sever

            Panel proxyServerPanel = new Panel();
            proxyServerPanel.setLayout(new FlowLayout(FlowLayout.CENTER));
            proxyServer = new TextField(nes.usersettings.proxyServer,10);
            proxyServer.setEnabled(useProxy.getState());
            proxyServerPanel.add(proxyServer);
            main.add(proxyServerPanel);


         // Add Grid Entry for Proxy Port

            Panel proxyServerPortPanel = new Panel();
            proxyServerPortPanel.setLayout(new FlowLayout(FlowLayout.CENTER));
            proxyServerPort = new TextField(nes.usersettings.proxyServerPort,10);
            proxyServerPort.setEnabled(useProxy.getState());
            proxyServerPortPanel.add(proxyServerPort);
            main.add(proxyServerPortPanel);


         // Add Grid Entries (5,6)

            main.add(space0);
            main.add(space1);


         // Add Grid Entries (7,8)

            Panel text3 = new Panel();
            text3.setLayout(new FlowLayout(FlowLayout.CENTER));
            text3.add(new Label("Proxy Username"));
            main.add(text3);

            Panel text4 = new Panel();
            text4.setLayout(new FlowLayout(FlowLayout.CENTER));
            text4.add(new Label("Proxy Password"));
            main.add(text4);



         // Add Grid Entry for Proxy Username

            Panel proxyUsernamePanel = new Panel();
            proxyUsernamePanel.setLayout(new FlowLayout(FlowLayout.CENTER));
            proxyUsername = new TextField(nes.usersettings.proxyServerUsername,10);
            proxyUsername.setEnabled(useProxy.getState());
            proxyUsernamePanel.add(proxyUsername);
            main.add(proxyUsernamePanel);


         // Add Grid Entry for Proxy Password

            Panel proxyPasswordPanel = new Panel();
            proxyPasswordPanel.setLayout(new FlowLayout(FlowLayout.CENTER));
            proxyPassword = new TextField(nes.usersettings.proxyServerPassword,10);
            proxyPassword.setEchoChar('*');
            proxyPassword.setEnabled(useProxy.getState());
            proxyPasswordPanel.add(proxyPassword);
            main.add(proxyPasswordPanel);



         // Add Grid Entries (5,6)

            main.add(space2);
            main.add(space3);


         // Add Main Content

            add(main, BorderLayout.CENTER);



         // Make the Buttons

            Button butOk = new Button("    Ok    ");
            butOk.setActionCommand("SET");
            butOk.addActionListener(listener); 
	        butOk.setForeground(Color.black); 
            butOk.setEnabled(true);

            Button butCancel = new Button ("Cancel");
            butCancel.setActionCommand("CANCEL");
            butCancel.addActionListener(listener); 
            butCancel.setForeground(Color.black); 
            butCancel.setEnabled(true);


         // Create the Bottom Panel for the Buttons and Add them

            Panel botPanel1 = new Panel();
            botPanel1.setBackground(Color.gray);
            botPanel1.add(butOk); 
            botPanel1.add(butCancel); 


         // Add that Panel to the Display

            Panel botPanel2 = new Panel();
            botPanel2.setBackground(Color.gray);
            botPanel2.setLayout(new BorderLayout());
            botPanel2.add (botPanel1, BorderLayout.EAST); 


            add (botPanel2, BorderLayout.SOUTH); 


         // Return Screen Size

            Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();

            final int w = 300; 
            final int h = 250; 

     
         // Position the Frame at the Center of the Screen

            setLocation(screenSize.width/2 - w/2, screenSize.height/2 - h/2); 
 

         // Show the Frame and Quickly Resize it

            setSize(w,h); 


      }



}

#endif
