#ifdef STAND

// Declare Imports

   import java.awt.*;
   import java.awt.event.*;


/** 
 *
 * Class for the GameGenie Window required by the NESCafe NES Emulator.
 *
 * @author   David de Niese
 * @version  0.56f
 * @final    TRUE
 *
 */


public final class GameGenieWindow extends Frame 
{


     /**
      *
      * <P>The current NES Machine.</P>
      *
      */

      private NES nes;


     /**
      *
      * <P>The current Graphical User Interface.</P>
      *
      */

      private GUI gui;




     /**
      * 
      * <P>The array of Game Genie Codes supplied by the User.</P>
      *
      */

      private java.awt.TextField command[] = new java.awt.TextField[4];




     /**
      *
      * <P>Create a new GameGenie Window.</P>
      * 
      * @param Nes The current NES Machine.
      * @param Gui The current Graphical User Interface.
      *
      */

      public GameGenieWindow (NES Nes, GUI Gui) 
      {


         // Create a new Font Object

            Font font = new Font("Helvetica", Font.PLAIN, 12);


         // Grab Pointers to NES and GUi

            nes = Nes;
            gui = Gui;


         // Set Border Layout for Chat Window

            setLayout(new BorderLayout());


         // Create and Add a Window Adaptor

            GameGenieWindowAdapter winAdapter = new GameGenieWindowAdapter(nes,gui); 
            addWindowListener(winAdapter); 



         // Set up the Frame
 
            setResizable(false); 
            setTitle("Game Genie");
            setBackground(Color.white);



         // Create Labels for prompting the User

            Label label[] = new Label[4];

            label[0] = new Label(" Code 1");
            label[1] = new Label(" Code 2");
            label[2] = new Label(" Code 3");
            label[3] = new Label(" Code 4");


         // Configure the Main Panel

            Panel leftPanel = new Panel();
            leftPanel.setForeground(Color.black);
            leftPanel.setBackground(Color.lightGray);

            leftPanel.setLayout(new GridLayout(4,2));

            for (int i = 0; i<4 ; i++) 
            {

               command[i] = new TextField("TEXTFIELD",10);
               command[i].setBackground(Color.white);
               command[i].setForeground(Color.black);
               command[i].setFont(font);

               label[i].setFont(font);
               leftPanel.add (label[i]);
               leftPanel.add(command[i]);

               command[i].setText(nes.memory.gameGenie.getCode(i));

            }


         // Add the Main Panel to the Screen

            add(leftPanel, BorderLayout.CENTER);



         // Create Submit and Cancel Buttons

            Button set = new Button("Submit");
            set.addActionListener(winAdapter);
            set.setActionCommand("SUBMIT");
            set.setFont(font);

            Button clear = new Button("Cancel");
            clear.addActionListener(winAdapter);
            clear.setActionCommand("CANCEL");
            clear.setFont(font);


         // Create a Bottom Panel for Holding the Buttons and Add it

            Panel botPanel = new Panel();
            botPanel.setBackground(Color.lightGray);
            botPanel.setForeground(Color.black);
            botPanel.add(set);
            botPanel.add(clear);
            add(botPanel,BorderLayout.SOUTH);


         // Return Screen Size

            Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();

            final int w = 300;
            final int h = 200;

       
         // Position the Frame at the Center of the Screen
  
            setLocation(screenSize.width/2 - w/2, screenSize.height/2 - h/2);


         // Show the Frame

            pack();
            show();

            command[0].requestFocus();

      }


     /**
      * 
      * <P>Grab the Game Genie codes from the input boxes.</P>
      *
      */

      public final String[] grabText() 
      {


         // Bundle Code in new String Array

            String[] retVal = new String[4];

            for (int i=0; i<4; i++)
               retVal[i] = command[i].getText();


         // Return the String Array

            return retVal;

      }


}

#endif
