#ifndef MOBILE

// Declare Imports

   import java.awt.event.*;



/** 
 *
 * Class for the Window Adapter required by GUI.
 *
 * @author   David de Niese
 * @version  0.56f
 * @final    TRUE
 *
 */

final class GUIWindowAdapter implements WindowListener 
{


     /**
      *
      * <P>The current Graphical User Interface.</P>
      *
      */

      private GUI gui;



     /**
      *
      * <P>The current NES Engine.</P>
      *
      */

      private NES nes;


     /**
      *
      * <P>Create a new GUI Window Adaptor.</P>
      *
      * @param Gui The current Graphical User Interface.
      *
      */

      public GUIWindowAdapter(GUI gui, NES nes) 
      {

         this.gui = gui;
         this.nes = nes;

      }


     /**
      *
      * <P>Handler for when the GUI Window closes.</P>
      *
      * @param windowEvent The WindowEvent.
      *
      */

      public final void windowClosing(WindowEvent windowEvent) 
      {

#ifndef APPLET

         gui.serverConnection.close();
         gui.hide();
         nes.cartUnload();
         nes.usersettings.saveSettings();
         System.exit(0); 

#endif

      }


     /**
      *
      * <P>Handler for when the GUI Window is activated.</P>
      *
      * @param windowEvent The WindowEvent. 
      *
      */
  
      public final void windowActivated (WindowEvent windowEvent) 
      {

         gui.pauseSystem(false); 

      }


     /**
      *
      * <P>Handler for when the GUI Window is deactivated.</P>
      *
      * @param windowEvent The WindowEvent.
      *
      */

      public final void windowDeactivated (WindowEvent windowEvent) {

         gui.pauseSystem(true);

      }


     /**
      *
      * <P>Handler for when the GUI Window is opened.</P>
      *
      * @param windowEvent The WindowEvent.
      *
      */

      public final void windowOpened (WindowEvent windowEvent) {}


     /**
      *
      * <P>Handler for when the GUI Window is closed.</P>
      *
      * @param windowEvent The WindowEvent.
      *
      */

      public final void windowClosed (WindowEvent windowEvent) {}


     /**
      *
      * <P>Handler for when the GUI Window is iconified.</P>
      *
      * @param windowEvent The WindowEvent.
      *
      */

      public final void windowIconified (WindowEvent windowEvent) 
      { 

         gui.pauseSystem(true); 

      }


     /**
      *
      * <P>Handler for when the GUI Window is deiconified.</P>
      *
      * @param windowEvent The WindowEvent.
      *
      */
   
      public final void windowDeiconified (WindowEvent windowEvent) 
      { 
  
         gui.pauseSystem(false);

      }
    
}

#endif
