#ifndef MOBILE


// Declare Imports

   import java.awt.event.*;
   import java.awt.*;
   import java.io.*;



/** 
 *
 * Class for the Mouse Monitor required by the GUI.
 *
 * @author   David de Niese
 * @version  0.56f
 * @final    TRUE
 *
 */

final class GUIMouseListener implements MouseMotionListener, MouseListener 
{


     /**
      *
      * <P>The current NES Machine.</P>
      *
      */

      private NES nes;


     /**
      *
      * <P>The current Graphical User Interface.</P>
      *
      */

      private GUI gui;


     /**
      *
      * <P>Create a new Mouse Monitor for the GUI.</P>
      *
      * @param Nes The current NES Machine.
      * @param Gui The current Graphical User Interface.
      *
      */

      public GUIMouseListener(NES nes, GUI gui) 
      {

         this.nes = nes;
         this.gui = gui;

      }



     /**
      * 
      * <P>Calculate Zapper Position</P>
      * 
      */

      private void calcZapperPos(MouseEvent e)
      {



         // Calculate the Offsets

            double factor = gui.tvController.tvFactor;

            double x = (double)(e.getX()-gui.tvController.guiLastX)/factor;
            double y = (double)(e.getY()-gui.tvController.guiLastY)/factor;


         // Determine the new X Location of the Mouse

            int newX = (int)x;
            if (newX<0) newX = 0;
            if (newX>255) newX = 255; 
            nes.memory.zapperX = newX;


         // Determine the new Y Location of the Mouse

            int newY = (int)y;
            if (newY<0) newY = 0;
            if (newY>239) newY = 239;
            nes.memory.zapperY = newY;



      }



     /**
      * 
      * <P>Handler for when Mouse is Pressed</P>
      * 
      */

      public void mousePressed(MouseEvent e)
      {

         if (nes != null && nes.memory != null)
         {

            if ( nes.usersettings.controllerZapperEnabled )
            {

               calcZapperPos(e);
               nes.memory.zapperTrigger = 0x10;

            }

         }

      }



     /**
      * 
      * <P>Handler for when Mouse is Released</P>
      * 
      */

      public void mouseReleased(MouseEvent e)
      {

         if (nes != null && nes.memory != null)
         {

            if ( nes.usersettings.controllerZapperEnabled )
            {

               calcZapperPos(e);
               nes.memory.zapperTrigger = 0x00;

            }
 
         }

      }




     /**
      * 
      * <P>Handler for when Mouse is Dragged</P>
      * 
      */

      public void mouseDragged(MouseEvent e)
      {}


     /**
      * 
      * <P>Handler for when Mouse is Moved</P>
      * 
      */

      public void mouseMoved(MouseEvent e)
      {}


     /**
      * 
      * <P>Handler for when Mouse is Clicked</P>
      * 
      */

      public void mouseClicked(MouseEvent e)
      {}


     /**
      * 
      * <P>Handler for when Mouse Enters</P>
      * 
      */

      public void mouseEntered(MouseEvent e)
      {}


     /**
      * 
      * <P>Handler for when Mouse Exits</P>
      * 
      */

      public void mouseExited(MouseEvent e)
      {}


}


#endif
