#ifndef MOBILE

// Declare Imports

   import java.awt.event.*;
   import java.awt.*;
   import java.io.*;



/** 
 *
 * Class for the Menu Monitor required by the GUI.
 *
 * @author   David de Niese
 * @version  0.56f
 * @final    TRUE
 *
 */

final class GUIMenuMonitor implements ActionListener, ItemListener 
{


     /**
      *
      * <P>The current NES Machine.</P>
      *
      */

      private NES nes;


     /**
      *
      * <P>The current Graphical User Interface.</P>
      *
      */

      private GUI gui;


     /**
      *
      * <P>The current Graphical User Interface.</P>
      *
      */

      private String lastDirectory = ".";



     /**
      *
      * <P>Create a new Menu Monitor for the GUI.</P>
      *
      * @param Nes The current NES Machine.
      * @param Gui The current Graphical User Interface.
      *
      */

      public GUIMenuMonitor(NES nes, GUI gui) 
      {

         this.nes = nes;
         this.gui = gui;

      }




     /**
      * 
      * <P>Handler for when an CheckBox Menu Item is changed in the GUI.</P>
      * 
      */

      public void itemStateChanged(ItemEvent e)
      {



         // Grab the Command Name

            String menulabel = (String)e.getItem();
 

#ifndef APPLET


         // Debug Enter or Exit

            if (gui.cpuMenu7.getLabel().equals(menulabel))
            {

               nes.cpu.debugEnterToggle();
               return;

            }


         // Toggle FPS Display

            if (gui.viewMenu1.getLabel().equals(menulabel)) 
            {


               // Check if we Need to Display or Hide FPS

                  if (gui.viewMenu1.getState()) 
                  {

                     gui.tvController.fpsShow();

                  } 
                  else 
                  {

                     gui.tvController.fpsHide();

                  }
                  return;

            }



         // Toggle Display of the Background

            if (gui.viewMenu2.getLabel().equals(menulabel)) 
            {

               nes.ppu.showBackground = gui.viewMenu2.getState(); 

               if (!nes.ppu.showBackground) 
               {

                  gui.writeToScreen("Background Layer is hidden..."); 

               } 
               else
               {

                  gui.writeToScreen("Background Layer is visible..."); 

               }
               return; 

            }



         // Toggle Display of Sprites

            if (gui.viewMenu3.getLabel().equals(menulabel) ) 
            {

               nes.ppu.showSprites = gui.viewMenu3.getState(); 

               if (!nes.ppu.showSprites) 
               {

                  gui.writeToScreen("Sprite Layer is hidden...");

               } 
               else 
               {

                  gui.writeToScreen("Sprite Layer is visible...");

               }
               return;

            }



         // Toggle the CPU Pause

            if (gui.cpuMenu2.getLabel().equals(menulabel)) 
            {

               nes.cpu.setCPUPause(gui.cpuMenu2.getState());
               return;

            }


         // Enable Undocumented OpCodes

            if (gui.cpuMenu5.getLabel().equals(menulabel)) 
            {

               if (gui.cpuMenu5.getState()) 
               {

                  gui.writeToScreen("Undocumented OpCode will be Processed...");
                  
               } 
               else 
               {

                  gui.writeToScreen("Undocumented OpCode will not be Processed...");

               }

               nes.usersettings.useUndocumentedOpCodes = gui.cpuMenu5.getState();
               return;

            }



         // Enable Zapper

            if (gui.cpuMenu6.getLabel().equals(menulabel)) 
            {

               nes.usersettings.controllerZapperEnabled = gui.cpuMenu6.getState();

               if (nes.usersettings.controllerZapperEnabled)
               {
                  gui.writeToScreen("Light Gun plugged into Port 2"); 
                  gui.tvController.setFrameSkip( 0 );
               }
               else
                  gui.writeToScreen("Light Gun removed from Port 2"); 

            }



#ifdef SOUND

         // Enable Sound

            if (gui.soundMenu1.getLabel().equals(menulabel)) 
            {


               // Check Sound is Available

                  if (nes.sound == null) return; 



               // Change Cursor
 
                  gui.setCursor(new Cursor(Cursor.WAIT_CURSOR)); 



               // Determine State of Sound

                  boolean soundState = gui.soundMenu1.getState();

                  if (!soundState) {

                     gui.writeToScreen("Sound has been disabled..."); 
  
                  } else {

                     gui.writeToScreen("Sound has been enabled..."); 
                     
                  }



               // Configure the Menus

                  if (nes.isCartRunning()) 
                  {
                     gui.soundMenu2.setEnabled(soundState); 
                  }

                  gui.soundMenu3.setEnabled(soundState); 
                  gui.soundMenu4.setEnabled(soundState); 
                  gui.soundMenu5.setEnabled(soundState); 
                  gui.soundMenu6.setEnabled(soundState); 
                  gui.soundMenu7.setEnabled(soundState); 
 

               // Set Sound State

                  nes.sound.enableSound(soundState); 
                  gui.setCursor(new Cursor(Cursor.DEFAULT_CURSOR)); 
                  return;

            }



         // Enable Sound Square Channel 1

            if (gui.soundMenu3.getLabel().equals(menulabel)) 
            {

               if (nes.sound == null) return; 

               if (!gui.soundMenu3.getState()) {

                  gui.writeToScreen("Square Channel 1 has been disabled..."); 
                  nes.sound.setChannelEnable(1,false); 

               } else {

                  gui.writeToScreen("Square Channel 1 has been enabled..."); 
                  nes.sound.setChannelEnable(1,true); 

               }
               return; 

            }


         // Enable Sound Square Channel 2

            if (gui.soundMenu4.getLabel().equals(menulabel)) {

               if (nes.sound == null) return; 

               if (!gui.soundMenu4.getState()) {

                  gui.writeToScreen("Square Channel 2 has been disabled..."); 
                  nes.sound.setChannelEnable(2,false); 

               } else {

                  gui.writeToScreen("Square Channel 2 has been enabled..."); 
                  nes.sound.setChannelEnable(2,true); 

               }
               return; 

            }


         // Enable Sound Triangle Channel

            if (gui.soundMenu5.getLabel().equals(menulabel)) {

               if (nes.sound == null) return; 

               if (!gui.soundMenu5.getState()) {

                  gui.writeToScreen("Triangle Channel has been disabled..."); 
                  nes.sound.setChannelEnable(3,false); 

               } else {

                  gui.writeToScreen("Triangle Channel has been enabled..."); 
                  nes.sound.setChannelEnable(3,true); 

               }
               return; 

            }



         // Enable Sound Noise Channel

            if (gui.soundMenu6.getLabel().equals(menulabel)) {

               if (nes.sound == null) return; 

               if (!gui.soundMenu6.getState()) {

                  gui.writeToScreen("Noise Channel has been disabled..."); 
                  nes.sound.setChannelEnable(4,false); 

               } else {

                  gui.writeToScreen("Noise Channel has been enabled..."); 
                  nes.sound.setChannelEnable(4,true); 

               }
               return; 

            }



         // Enable DMC Channel

            if (gui.soundMenu7.getLabel().equals(menulabel)) {

               if (nes.sound == null) return; 

               if (!gui.soundMenu7.getState()) {

                  gui.writeToScreen("DMC has been disabled..."); 
                  nes.sound.setChannelEnable(5,false); 

               } else {

                  gui.writeToScreen("DMC has been enabled..."); 
                  nes.sound.setChannelEnable(5,true); 

               }
               return; 

            }

#endif
#endif

      } 



     /**
      * 
      * <P>Handler for when an action is performed on a Menu Item in the GUI.</P>
      * 
      */

      public void actionPerformed(ActionEvent e) 
      {


         // Grab the Command Name

            String command = e.getActionCommand();


#ifndef APPLET

         // Determine which Command to Perform


         // COMMAND : Start Chatting with NESCafe Chat

            if (command == "NESCAFECHAT") 
            {

               gui.setCursor(new Cursor(Cursor.WAIT_CURSOR));
               gui.serverConnection.showChatWindow();
               gui.setCursor(new Cursor(Cursor.DEFAULT_CURSOR));

               return;

            }


         // COMMAND : Download ROM

            if (command == "CONFIGINTERNET") 
            {

               gui.setInternetConfigFrameVisible();
               return;

            }


         // COMMAND : Download ROM

            if (command == "DOWNLOADROM") 
            {

               gui.setDownloadFrameVisible();
               return;

            }


         // COMMAND : Stop Download of ROM

            if (command == "DOWNLOADSTOP") 
            {

               gui.cancelDownload = true;
               gui.writeToScreen("Attempting to Stop Download...");
               gui.serverMenu3.setEnabled(false);
               return;

            }



         // COMMAND : Download ROM Play

            if (command == "DOWNLOADPLAY") 
            {

               gui.serverMenu2.setEnabled(false);

               if (gui.downloadedFile != null && gui.downloadedFile.exists())
               {

                  openRom(gui.downloadedFile);

               }

               return;

            }


#ifdef SOUND

         // COMMAND : Record Sound

            if (command == "SOUNDRECORD") 
            {

               if (nes.sound == null) return; 

               gui.setCursor(new Cursor(Cursor.WAIT_CURSOR)); 

               if (gui.soundMenu2.getLabel().equals("Start Recording WAV")) {

                  gui.soundMenu2.setLabel("Stop Recording WAV");
                  if (nes.isCartRunning()) { 

                     gui.soundMenu1.setEnabled(false); 
                     gui.soundMenu3.setEnabled(false); 
                     gui.soundMenu4.setEnabled(false); 
                     gui.soundMenu5.setEnabled(false); 
                     gui.soundMenu6.setEnabled(false); 
                     gui.soundMenu7.setEnabled(false); 

                  }

                  nes.sound.recordStart();

               } else {

                  gui.soundMenu2.setLabel("Start Recording WAV");
                  if (nes.isCartRunning()) {

                     gui.soundMenu1.setEnabled(true); 
                     gui.soundMenu3.setEnabled(true); 
                     gui.soundMenu4.setEnabled(true); 
                     gui.soundMenu5.setEnabled(true); 
                     gui.soundMenu6.setEnabled(true); 
                     gui.soundMenu7.setEnabled(true); 

                  }

                  nes.sound.recordStop();

               }

               gui.setCursor(new Cursor(Cursor.DEFAULT_CURSOR)); 

            }
           
#endif




         // COMMAND : Close the Current ROM

            if (command == "CLOSE") {

               gui.setCursor(new Cursor(Cursor.WAIT_CURSOR)); 
               nes.cartUnload();
               gui.deleteDisplay();
               gui.setCursor(new Cursor(Cursor.DEFAULT_CURSOR)); 
               gui.writeToScreen("Rom successfully closed");

               return; 
   
            }



         // COMMAND : Show GameGenie Window

            if (command == "GAMEGENIE") {

               nes.cpu.setCPUPause(true); 
               gui.setCursor(new Cursor(Cursor.WAIT_CURSOR)); 
               gui.setGameGenieWindowVisible();
               gui.setCursor(new Cursor(Cursor.DEFAULT_CURSOR)); 
               nes.cpu.setCPUPause(false); 

               return; 

            }


         // COMMAND : Exit the Emulator

            if (command == "EXIT") {

               gui.serverConnection.close();
               gui.hide();
               nes.cartUnload();
               nes.usersettings.saveSettings();
               System.exit(0);

            }




         // COMMAND : Load a Saved State

            if (command == "LOADSTATE") {


               // Issue a Load State Request

                  gui.loadStateRequest = true;
                  gui.saveStateRequest = false;
                  gui.writeToScreen("Attempting to Load State...");
                  return;

            }



         // COMMAND : Load a Saved State

            if (command == "DEBUGSTEP") {


               // Issue a Load State Request

                  nes.cpu.debugStep(1);
                  return;

            }



         // COMMAND : Load a Saved State

            if (command == "DEBUGSTEP20") {


               // Issue a Load State Request

                  nes.cpu.debugStep(20);
                  return;

            }



         // COMMAND : Load a Saved State

            if (command == "DEBUGEVENT") {


               // Issue a Load State Request

                  nes.cpu.debugToInterrupt(true);
                  return;

            }



         // COMMAND : Open a new Rom File

            if (command == "OPEN") 
            {
               openRomDialog();
               return;
            } 




         // COMMAND : Reset the Cart

            if (command == "RESET") {

               gui.setCursor(new Cursor(Cursor.WAIT_CURSOR));
               nes.reset();


               if (nes.cpu.getCPUPause())
               {
                  gui.cpuMenu2.setState(false); 
                  nes.cpu.setCPUPause(gui.cpuMenu2.getState());
               }

               gui.setCursor(new Cursor(Cursor.DEFAULT_CURSOR));

               return;

            }


         // COMMAND : Save Image to Disk

            if (command == "SAVEGIF") {

               gui.setCursor(new Cursor(Cursor.WAIT_CURSOR));
               gui.tvController.saveScreen();
               gui.setCursor(new Cursor(Cursor.DEFAULT_CURSOR));
               return;

            }


         // COMMAND : Save the Current State of the Cartridge
                
            if (command == "SAVESTATE") {

               // Issue a Save State Request

                  gui.saveStateRequest = true;
                  gui.loadStateRequest = false;
                  gui.writeToScreen("Attempting to Save State...");
                  return;

            }

#endif


      }



#ifndef APPLET

     /**
      *
      * <P>Open a ROM Image.</P>
      *
      */

      private final void openRomDialog() 
      {



         // Pause the current Display

            gui.pauseSystem(true);


         // Set the Waiting Cursor

            gui.setCursor(new Cursor(Cursor.WAIT_CURSOR));
            gui.validate();


         // Perform a Garbage Collection

            System.gc();


         // Display the Open Dialog

            FileDialog mainSelection = new FileDialog(gui,"Open...",FileDialog.LOAD); 
            mainSelection.setFilenameFilter(new GUILoadRomFileFilter());
            mainSelection.setFile("*.nes; *.nes.gz; *.zip");
            mainSelection.setDirectory(lastDirectory);
            mainSelection.show();
            

         // Check If User Cancelled

            if (mainSelection.getFile() == null) 
            {

               gui.setCursor(new Cursor(Cursor.DEFAULT_CURSOR)); 
               gui.pauseSystem(false); 
               return; 

            }


         // Retrieve the Selected File

            lastDirectory = mainSelection.getDirectory();
            String openFilename = mainSelection.getDirectory()+mainSelection.getFile();
            File retFile = new File (openFilename);
            openRom(retFile);



      }


      private final void openRom(File retFile)
      {


         // Pause the current Display

            gui.pauseSystem(true);


         // Set the Waiting Cursor

            gui.setCursor(new Cursor(Cursor.WAIT_CURSOR));
            gui.validate();


         // Perform a Garbage Collection

            System.gc();



         // Attempt to Load File

            gui.showLoadingScreen(true);


            try  
            {

               gui.pauseSystem(true);
               gui.setCursor(new Cursor(Cursor.WAIT_CURSOR));
               nes.cartLoad(retFile.toString());
               gui.pauseSystem(false);
               nes.lastOpenedCartFileName = retFile.toString();

            } catch (Exception e) {
          
               // Cart didn't Load

                  gui.showLoadingScreen(false);
                  gui.pauseSystem(false);

            }



         // Change the Cursor to Normal

            gui.setCursor(new Cursor(Cursor.DEFAULT_CURSOR));
            System.gc();

      }
      
#endif


}
#endif
