#ifndef MOBILE


// Declare Imports

   import java.io.*;


/** 
 *
 * Class for the NES ROM File Filter required by the GUI.
 *
 * @author   David de Niese
 * @version  0.56f
 * @final    TRUE
 *
 */

public final class GUILoadRomFileFilter implements FilenameFilter 
{

     /**
      *
      * <P>Whether the given file is accepted by this filter.</P>
      *
      */

      public final boolean accept (File dirname, String filename) 
      {


         // Accept Files with NES Extension

            if (filename.toString().toUpperCase().endsWith(".NES")) return true;


         // Accept Files with NES.GZ Extension

            if (filename.toString().toUpperCase().endsWith(".NES.GZ")) return true;


         // Accept Files with ZIP Extension

            if (filename.toString().toUpperCase().endsWith(".ZIP")) return true;

         
         // Don't Accept anything Else

            return false;


      }

}
#endif
